var _lorawanutil_prefix = '__hsyco__lorawanutil.';
var _lorawanutil_devId;
var _lorawanutil_framesEnabled = false;
var _lorawanutil_frames = '';

function userCommand(name, param) {
	if (name.startsWith(_lorawanutil_prefix)) {
		if (name.endsWith('dev.frames.enable')) {
			_lorawanutil_framesEnabled = param == 'true';
			return "";
		} else if (name.endsWith('dev.frames.clear')) {
			_lorawanutil_frames = '';
			uiSet(_lorawanutil_prefix + 'dev.frames.list', 'values', _lorawanutil_frames);
			uiSet(_lorawanutil_prefix + 'dev.frames.list', 'labels', _lorawanutil_frames);
			return "";
		} else if (name.endsWith('dev.frames.list')) {
			return "";
		}
	}

}

function uiEvent(id, attr, value) {
	if (id.startsWith(_lorawanutil_prefix)) {
		// console.log('---- ' + id + ' . ' + attr + ' = ' + value);
		id = id.substring(21);
		if (attr.startsWith('_')) {
			attr = attr.substring(1);
			if (id.startsWith('dev.' + _lorawanutil_devId + '.')) {
				id = id.substring(4 + _lorawanutil_devId.length);
				if (id == '.frame.json') {
					if (_lorawanutil_framesEnabled) {
						var frame = JSON.parse(value);
						var data;
						if (frame.data) {
							data = '<code>' + frame.data.raw + '</code>';
							if (frame.data.cayenne) {
								if (frame.data.cayenne.error) {
									data += '<br />cayenne error';
								} else {
									Object.keys(frame.data.cayenne.channels).forEach(function(key) {
										var ch = frame.data.cayenne.channels[key];
										data += '<br />ch' + key + ': type=' + ch.type + ' val=' + ch.val
									})
								}
							}
						} else {
							data = '-'
						}
						var time = frame.time.replace(' ', '<br />');
						var fCnt = frame.fCnt + (frame.fCntWarn == 0 ? ' OK' : ( frame.fCntWarn == 10 ? ' REP' : ' ERR'));
						var mic = frame.mic ? 'OK' : 'ERR';
						if (_lorawanutil_frames.length != 0) {
							_lorawanutil_frames = ',' + _lorawanutil_frames;
						}
						_lorawanutil_frames = time + '|' + data + '|' + frame.fPort + '|' + fCnt + '|' + mic + _lorawanutil_frames;
						uiSet(_lorawanutil_prefix + 'dev.frames.list', 'values', _lorawanutil_frames);
						uiSet(_lorawanutil_prefix + 'dev.frames.list', 'labels', _lorawanutil_frames);
					}
				} else {
					uiSet(_lorawanutil_prefix + 'dev' + id, attr, value);
				}
			}
			return null;
		} else {
			if (id == 'dev.id') {
				_lorawanutil_devId = value;
				_lorawanutil_frames = '';
				uiSet(_lorawanutil_prefix + 'dev.frames.list', 'values', _lorawanutil_frames);
				uiSet(_lorawanutil_prefix + 'dev.frames.list', 'labels', _lorawanutil_frames);
			}
		}
	}

	return value;
}
