/*  HSYCO CONTROLLER, EVENTS SCRIPT - FUNCTIONS, version 3.8.0 Build 0134
 *  (c) 2013-2021 HSYCO S.r.l.
 *
 *  For information, see the HSYCO web site:
 *  http://www.hsyco.com/
 *
/*------------------------------------------------------------*/

var OFF = com.hsyco.userBase.OFF;
var ON = com.hsyco.userBase.ON;
var NOCHANGE = com.hsyco.userBase.NOCHANGE;
var UNKNOWN = com.hsyco.userBase.UNKNOWN;
var PAUSE = com.hsyco.userBase.PAUSE;
var PLAY = com.hsyco.userBase.PLAY;
var MERGED = com.hsyco.userBase.MERGED;



function cameraRecTrigger(cameraName, source, seconds) {
	if (__run == '1') {
		com.hsyco.userBase.cameraRecTrigger(cameraName, source, seconds);
	}
}

function cameraRecTriggerFull(cameraName, source, seconds) {
	if (__run == '1') {
		com.hsyco.userBase.cameraRecTriggerFull(cameraName, source, seconds);
	}
}

function haActiveState() {
	return Boolean(com.hsyco.userBase.haActiveState());
}

function haActive(active) {
	if (__run == '1') {
		com.hsyco.userBase.haActive(active);
	}
}

function deviceFunctionGet(name) {
	return Number(com.hsyco.userBase.deviceFunctionGet(name));
}

function irtransCommand(irId, command) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.irtransCommand(irId, command));
	} else {
		return 0;
	}
}

function isDaylight() {
	return Boolean(com.hsyco.userBase.isDaylight());
}

function getNextSunrise(now, withoffset) {
	return Number(com.hsyco.userBase.getNextSunrise(now, withoffset));
}

function getNextSunset(now, withoffset) {
	return Number(com.hsyco.userBase.getNextSunset(now, withoffset));
}

function uiClear(session) {
	if (__run == '1') {
		com.hsyco.userBase.uiClear(session);
	}
}

function uiSessionSet(session, id, attr, value) {
	if (__run == '1') {
		com.hsyco.userBase.uiSet(session, id, attr, value);
	}
}

function uiSet(id, attr, value) {
	if (__run == '1') {
		com.hsyco.userBase.uiSet(id, attr, value);
	}
}

function uiSessionGet(session, id, attr) {
	var v = com.hsyco.userBase.uiGet(session, id, attr);
	return (v === null) ? null : String(v);
}

function uiLink(source, target) {
	if (__run == '1') {
		com.hsyco.userBase.uiLink(source, target);
	}
}

function uiGet(id, attr) {
	var v = com.hsyco.userBase.uiGet(id, attr);
	return (v === null) ? null : String(v);
}

function errorLog(message) {
	if (__run == '1') {
		com.hsyco.userBase.errorLog(message);
	}
}

function messageLog(message) {
	if (__run == '1') {
		com.hsyco.userBase.messageLog(message);
	}
}

function fileLog(pathname, message) {
	if (__run == '1') {
		com.hsyco.userBase.fileLog(pathname, message);
	}
}

function sleep(millis) {
	if (__run == '1') {
		com.hsyco.userBase.sleep(millis);
	}
}

function cameraCommand(func, action, camera) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.cameraCommand(func, action, camera));
	} else {
		return 0;
	}
}

function cameraRecMode(cameraName, enabled) {
	if (__run == '1') {
		com.hsyco.userBase.cameraRecMode(cameraName, enabled);
	}
}

function cameraMode(cameraName, enabled) {
	if (__run == '1') {
		com.hsyco.userBase.cameraMode(cameraName, enabled);
	}
}

function slimButton(player, button) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.slimButton(player, button));
	} else {
		return 0;
	}
}

function slimCommand(player, command) {
	if (__run == '1') {
		var v = com.hsyco.userBase.slimCommand(player, command);
		return (v === null) ? null : String(v);
	} else {
		return null;
	}
}

function wakeOnLan(broadcast, address) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.wakeOnLan(broadcast, address));
	} else {
		return 1;
	}
}

function readComm(portName, len) {
	if (__run == '1') {
		var v = com.hsyco.userBase.readComm(portName, len);
		return (v === null) ? null : String(v);
	} else {
		return null;
	}
}

function writeComm(portName, data) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.writeComm(portName, data));
	} else {
		return 0;
	}
}

function closeComm(portName) {
	if (__run == '1') {
		com.hsyco.userBase.closeComm(portName);
	}
}

function dmxSet(channel, state) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.dmxSet(channel, state));
	} else {
		return 0;
	}
}

function dmxOn(channel) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.dmxOn(channel));
	} else {
		return 0;
	}
}

function dmxOff(channel) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.dmxOff(channel));
	} else {
		return 0;
	}
}

function dmxMerge(fromChannel, toChannel, merge) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.dmxMerge(fromChannel, toChannel, merge));
	} else {
		return 0;
	}
}

function dmxGet(channel) {
	return Number(com.hsyco.userBase.dmxGet(channel));
}

function ioServersStop(name) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.ioServersStop(name));
	} else {
		return -1;
	}
}

function ioServersRestart(name) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.ioServersRestart(name));
	} else {
		return -1;
	}
}

function ioSet(id, value) {
	if (__run == '1') {
		com.hsyco.userBase.ioSet(id, value);
	}
}

function ioGet(id) {
	var v = com.hsyco.userBase.ioGet(id);
	return (v === null) ? null : String(v);
}

function ioGetTime(id) {
	var v = com.hsyco.userBase.ioGetTime(id);
	return (v === null) ? null : Number(v);
}

function schedulerRegister(groupname, schedulename, interval) {
	if (__run == '1') {
		com.hsyco.userBase.schedulerRegister(groupname, schedulename, interval);
	}
}

function schedulerRemove(groupname, schedulename) {
	if (__run == '1') {
		com.hsyco.userBase.schedulerRemove(groupname, schedulename);
	}
}

function powerSet(power) {
	if (__run == '1') {
		com.hsyco.userBase.powerSet(power);
	}
}

function varGet(name) {
	var v = com.hsyco.userBase.varGet(name);
	return (v === null) ? null : String(v);
}

function varSet(name, value) {
	if (__run == '1') {
		com.hsyco.userBase.varSet(name, value);
	}
}

function programTimerSet(name, seconds) {
	if (__run == '1') {
		com.hsyco.userBase.programTimerSet(name, seconds);
	}
}

function programTimerClear(name) {
	if (__run == '1') {
		com.hsyco.userBase.programTimerClear(name);
	}
}

function programTimerReset(name, seconds) {
	if (__run == '1') {
		com.hsyco.userBase.programTimerReset(name, seconds);
	}
}

function programTimerRepeat(name, seconds) {
	if (__run == '1') {
		com.hsyco.userBase.programTimerRepeat(name, seconds);
	}
}

function modbusReadCoils(name, unit, address, quantity) {
	if (__run == '1') {
		var pdu = com.hsyco.userBase.modbusReadCoils(name, unit, address, quantity);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusReadDiscreteInputs(name, unit, address, quantity) {
	if (__run == '1') {
		var pdu = com.hsyco.userBase.modbusReadDiscreteInputs(name, unit, address, quantity);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusReadHoldingRegisters(name, unit, address, quantity) {
	if (__run == '1') {
		var pdu = com.hsyco.userBase.modbusReadHoldingRegisters(name, unit, address, quantity);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusReadInputRegisters(name, unit, address, quantity) {
	if (__run == '1') {
		var pdu = com.hsyco.userBase.modbusReadInputRegisters(name, unit, address, quantity);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusWriteSingleCoil(name, unit, address, value) {
	if (__run == '1') {
		var pdu = com.hsyco.userBase.modbusWriteSingleCoil(name, unit, address, value);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusWriteSingleRegister(name, unit, address, bytes) {
	if (__run == '1') {
		for (i = 0; i < bytes.length; i++) {
			if (bytes[i] > 127) {
				bytes[i] -= 256;
			}
		}
		var pdu = com.hsyco.userBase.modbusWriteSingleRegister(name, unit, address, bytes);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusWriteMultipleCoils(name, unit, address, coils, bytes) {
	if (__run == '1') {
		for (i = 0; i < bytes.length; i++) {
			if (bytes[i] > 127) {
				bytes[i] -= 256;
			}
		}
		var pdu = com.hsyco.userBase.modbusWriteMultipleCoils(name, unit, address, coils, bytes);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusWriteMultipleRegisters(name, unit, address, bytes) {
	if (__run == '1') {
		for (i = 0; i < bytes.length; i++) {
			if (bytes[i] > 127) {
				bytes[i] -= 256;
			}
		}
		var pdu = com.hsyco.userBase.modbusWriteMultipleRegisters(name, unit, address, bytes);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusWriteMaskRegister(name, unit, address, mask, bytes) {
	if (__run == '1') {
		for (i = 0; i < bytes.length; i++) {
			if (bytes[i] > 127) {
				bytes[i] -= 256;
			}
		}
		var pdu = com.hsyco.userBase.modbusWriteMaskRegister(name, unit, address, mask, bytes);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function modbusReadWriteMultipleRegisters(name, unit, readaddress, readquantity, writeaddress, bytes) {
	if (__run == '1') {
		for (i = 0; i < bytes.length; i++) {
			if (bytes[i] > 127) {
				bytes[i] -= 256;
			}
		}
		var pdu = com.hsyco.userBase.modbusReadWriteMultipleRegisters(name, unit, readaddress, readquantity, writeaddress, bytes);
		if (pdu == null) {
			return null;
		} else {
			var pdua = new Array(pdu.length);
			for (i = 0; i < pdu.length; i++) {
				pdua[i] = (pdu[i] >= 0) ? pdu[i] : 256 + pdu[i];
			}
			return pdua;
		}
	} else {
		return null;
	}
}

function sendMail(to, from, subject, body) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.sendMailMulti(to, from, subject, body));
	} else {
		return -1;
	}
}

function ping(host, timeout) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.ping(host, timeout));
	} else {
		return false;
	}
}

function leakDetectorClear(name) {
	if (__run == '1') {
		com.hsyco.userBase.leakDetectorClear(name);
	}
}

function leakDetectorOptions(name, param, value) {
	if (__run == '1') {
		com.hsyco.userBase.leakDetectorOptions(name, param, value);
	}
}

function leakDetectorUpdate(name, value) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.leakDetectorUpdate(name, value));
	} else {
		return -1;
	}
}

function dataLoggerOptions(name, param, value) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.dataLoggerOptions(name, param, value));
	} else {
		return false;
	}
}

function dataLoggerUpdate(name, value) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.dataLoggerUpdate(name, value));
	} else {
		return false;
	}
}

function dataLoggerClear(name) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.dataLoggerClear(name));
	} else {
		return false;
	}
}

function dataLoggerSave(type, names, path, timestamp) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.dataLoggerSave(type, names, path, timestamp));
	} else {
		return false;
	}
}

function user(name, param) {
	if (__run == '1') {
		com.hsyco.userBase.user(name, param);
	}
}

function audioPlayFile(where, file) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.audioPlay(where, file));
	} else {
		return 0;
	}
}

function audioPlayText(where, voice, text) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.audioPlay(where, voice, text));
	} else {
		return 0;
	}
}

function dateSet(year, month, day, hour, minute, second) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.dateSet(year, month, day, hour, minute, second));
	} else {
		return false;
	}
}

function urlGet(url, user, password) {
	if (__run == '1') {
		var v = com.hsyco.userBase.urlGet(url, user, password);
		return (v === null) ? null : String(v);
	} else {
		return null;
	}
}

function urlPost(url, contenttype, data, user, password) {
	if (__run == '1') {
		var v = com.hsyco.userBase.urlPost(url, contenttype, data, user, password);
		return (v === null) ? null : String(v);
	} else {
		return null;
	}
}

function userTimerSet(name, on, hour, minute, duration, days) {
	if (__run == '1') {
		return Boolean(com.hsyco.userBase.userTimerSet(name, on, hour, minute, duration, days));
	} else {
		return false;
	}
}

function nlp(text) {
	if (__run == '1') {
		com.hsyco.userBase.nlp(text);
	}
}

function geoBearing(lat1, lon1, lat2, lon2) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.geoBearing(lat1, lon1, lat2, lon2));
	} else {
		return -1;
	}
}

function geoDistance(lat1, lon1, lat2, lon2) {
	if (__run == '1') {
		return Number(com.hsyco.userBase.geoDistance(lat1, lon1, lat2, lon2));
	} else {
		return -1;
	}
}