/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.Configuration;
import com.hsyco.HsycoFile;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import com.hsyco.util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import plugins.wsmeasure.ALPTEC;
import plugins.wsmeasure.Alarms;
import plugins.wsmeasure.CONTREL;
import plugins.wsmeasure.CS;
import plugins.wsmeasure.ChargeController;
import plugins.wsmeasure.CostRates;
import plugins.wsmeasure.DMX3;
import plugins.wsmeasure.DPX3;
import plugins.wsmeasure.DPX3EMS;
import plugins.wsmeasure.DX3;
import plugins.wsmeasure.DataProcessor;
import plugins.wsmeasure.EMDX3;
import plugins.wsmeasure.EMS;
import plugins.wsmeasure.ENTES;
import plugins.wsmeasure.F4;
import plugins.wsmeasure.GENERIC;
import plugins.wsmeasure.GatewayCache;
import plugins.wsmeasure.IME;
import plugins.wsmeasure.M7TIC;
import plugins.wsmeasure.ModbusGatewaySettings;
import plugins.wsmeasure.NetSettings;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.Reports;
import plugins.wsmeasure.SensorCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class user
extends userBase {
    private static final String BUILD = "0116 DEV 3";
    private static final String DATABASE_URL = "jdbc:hsqldb:file:data/data;hsqldb.write_delay_millis=100;hsqldb.lock_file=false";
    private static final String DATABASE_NAME = "data";
    private static final String DATABASE_USER = "data";
    private static final String DATABASE_PASSWORD = "iwu39ie03qc";
    private static final String DATABASE_BACKUP_DIR = "data_wsmeasure_backup";
    private static final String DEFAULT_ENERGY_CURRENCY = "EUR";
    private static final String DEFAULT_AUTO_TIME_SERVER = "ntp.ubuntu.com";
    private static String VERSION = null;
    private static String PRODUCTID = null;
    private static int VVVV = 0;
    private static int CHECKPOINT = 1;
    static Hashtable<Integer, ModbusServerResponseCache> modbusServerResponseCache = new Hashtable();
    private static boolean multiProjects = false;
    private static boolean retainOldData = false;
    private static String TRIAL_FILE = "trial.ini";
    public static Vector<String[]> Models = new Vector();
    public static Vector<String[]> ModelsOptions = new Vector();
    public static Vector<Integer[]> ModelsConcentrators = new Vector();
    public static Vector<String[]> Concentrators = new Vector();
    public static Connection databaseConnection = null;
    public static String URLKey;
    public static String version;
    public static Vector<TimeZone> ZONES;
    public static Locale locale;
    public static char csvFieldSep;
    public static char csvDecimalSep;
    public static boolean autoTimeUpdate;
    public static String autoTimeServer;
    public static long dataErrorTimestamp;
    public static int dbOldDataLifetimeCoefficient;
    public static int dbOldDataDeleteAfterDaysST;
    public static int dbOldDataDeleteAfterDaysTH;
    public static int dbOldDataDeleteAfterDaysEQ;
    public static Integer dbBackupConsolidationTimeSeconds;
    public static long dbBackupConsolidationTimestampMillis;
    public static String dbBackupConsolidationExitStatus;
    public static long dbBackupScriptSize;
    public static boolean lowDiskSpace;
    public static boolean printSettings;
    public static int trialCounter;
    public static int greenUpTotalMeterId;
    public static boolean greenUpEnabled;
    public static boolean greenUpControl;
    public static int greenUpCurrentMaxAvailable;
    public static int greenUpCurrentMaxAvailableCharging;
    public static int greenUpCurrentHysteresis;
    public static int greenUpCurrentFirstReduction;
    public static int greenUpCurrentSecondReduction;
    public static int greenUpChargeQuantityMinimum;
    public static int greenUpHoldTimeMinimum;
    public static int statusPollTime;
    public static int reportsStatus;
    public static boolean reportsKillSwitch;
    public static long availableDiskSpace;
    public static boolean smallDisk;
    public static boolean hsycoDatabaseBackup;
    public static boolean hsycoDatabaseBackupConsolidation;
    public static boolean hsycoDatabaseRecovery;
    public static Short dataConsolidationIntervalMinutes;
    private static final Executor exec;
    public static final byte[] BOM;

    static {
        ZONES = new Vector();
        locale = null;
        csvFieldSep = (char)44;
        csvDecimalSep = (char)46;
        autoTimeUpdate = false;
        autoTimeServer = null;
        dataErrorTimestamp = 0L;
        dbOldDataLifetimeCoefficient = 1;
        dbOldDataDeleteAfterDaysST = 2;
        dbOldDataDeleteAfterDaysTH = 2;
        dbOldDataDeleteAfterDaysEQ = 2;
        dbBackupConsolidationTimeSeconds = null;
        dbBackupConsolidationTimestampMillis = 0L;
        dbBackupConsolidationExitStatus = null;
        dbBackupScriptSize = 0L;
        lowDiskSpace = false;
        printSettings = true;
        trialCounter = -1;
        greenUpTotalMeterId = -1;
        greenUpEnabled = false;
        greenUpControl = false;
        greenUpCurrentMaxAvailable = Integer.MAX_VALUE;
        greenUpCurrentMaxAvailableCharging = Integer.MAX_VALUE;
        greenUpCurrentHysteresis = 0;
        greenUpCurrentFirstReduction = 75;
        greenUpCurrentSecondReduction = 50;
        greenUpChargeQuantityMinimum = 32;
        greenUpHoldTimeMinimum = 60;
        statusPollTime = 3;
        reportsStatus = -1;
        reportsKillSwitch = false;
        availableDiskSpace = user.availableSpace();
        smallDisk = (double)availableDiskSpace < 1.0E10;
        hsycoDatabaseBackup = false;
        hsycoDatabaseBackupConsolidation = false;
        hsycoDatabaseRecovery = false;
        dataConsolidationIntervalMinutes = null;
        exec = Executors.newCachedThreadPool();
        BOM = new byte[]{-17, -69, -65};
    }

    public static Object getMagic() throws Exception {
        Properties ini = new Properties();
        Properties manifest = new Properties();
        FileInputStream inifis = new FileInputStream("hsyco.ini");
        ini.load(inifis);
        inifis.close();
        hsycoDatabaseBackup = Boolean.valueOf(ini.getProperty("DatabaseBackup", "false").trim());
        hsycoDatabaseBackupConsolidation = Boolean.valueOf(ini.getProperty("DatabaseBackupConsolidation", "false").trim());
        hsycoDatabaseRecovery = Boolean.valueOf(ini.getProperty("DatabaseRecovery", "false").trim());
        version = ini.getProperty("version");
        URLKey = ini.getProperty("URLKey");
        String iniproductid = ini.getProperty("productid");
        String inilicense = ini.getProperty("license");
        dataConsolidationIntervalMinutes = Short.parseShort(ini.getProperty("dataConsolidationInterval", "15"));
        multiProjects = Boolean.valueOf(ini.getProperty("multiProjects", "false").trim());
        dbOldDataDeleteAfterDaysST = Integer.parseInt(ini.getProperty("STDataExpirationDays", Integer.toString(dbOldDataDeleteAfterDaysST)));
        dbOldDataDeleteAfterDaysTH = Integer.parseInt(ini.getProperty("THDataExpirationDays", Integer.toString(dbOldDataDeleteAfterDaysTH)));
        dbOldDataDeleteAfterDaysEQ = Integer.parseInt(ini.getProperty("EQDataExpirationDays", Integer.toString(dbOldDataDeleteAfterDaysEQ)));
        if (inilicense == null) {
            manifest.load(new ByteArrayInputStream(new HsycoFile("wsmeasure.manifest", null).getBytes()));
            String manifestlicense = manifest.getProperty("license");
            if ("unlimited".equals(manifestlicense)) {
                VVVV = 255;
                PRODUCTID = version.equals("lg") ? "0 261 79" : "PM1WS1";
            } else {
                VVVV = 32;
                PRODUCTID = version.equals("lg") ? "0 261 78" : "PM1WS";
            }
            ini.put("license", Integer.toString(VVVV));
            ini.put("productid", PRODUCTID);
            user.safePropertiesStore(ini, "hsyco.ini");
        } else {
            VVVV = Integer.parseInt(inilicense);
            PRODUCTID = new String(iniproductid);
        }
        int magicModifier = multiProjects ? 8573 : 0;
        switch (VVVV) {
            case 10: {
                return magicModifier + 6703;
            }
            case 32: {
                return magicModifier + 4517;
            }
            case 255: {
                return magicModifier + 3463;
            }
        }
        user.errorLog("STARTUP FATAL ERROR: WSMEASURE LICENSE ERROR - SYSTEM RESTARTING IN 60 SECONDS");
        Thread.sleep(60000L);
        System.exit(1);
        return 0;
    }

    public static String getUserVersion() {
        try {
            if (VERSION == null) {
                Properties p = new Properties();
                p.load(new ByteArrayInputStream(new HsycoFile("wsmeasure.manifest", null).getBytes()));
                VERSION = new String(p.getProperty("version", "--"));
                CHECKPOINT = Integer.parseInt(p.getProperty("checkpoint"));
            }
        }
        catch (Exception e2) {
            VERSION = "--";
        }
        return "WSMEASURE " + VERSION;
    }

    private static void hsycoCheckPoint() {
        try {
            Connection c2 = user.getHsycoDBConnection();
            PreparedStatement stmt = c2.prepareStatement("checkpoint");
            stmt.execute();
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String WebRootRequestEvent(InetAddress addr, boolean secure, String useragent) throws Exception {
        try {
            String ul = useragent.toLowerCase();
            if (ul.indexOf("ipod;") > 0 || ul.indexOf("iphone;") > 0) {
                return String.valueOf(URLKey) + "/" + "small?language=" + user.localeToId().toLowerCase();
            }
            return String.valueOf(URLKey) + "/" + "big?language=" + user.localeToId().toLowerCase();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void pageEvent(String address, String session, String userid, String project, String page) throws Exception {
        if (!(project.equals("manager") || project.equals("manager_settings") || project.equals("admin") || project.equals("tunnelutil") || project.equals("lorawanutil"))) {
            if (project.equals("big") && page.equals("modbussettings")) {
                ModbusGatewaySettings.showConfiguration();
            } else if (project.equals("big") && page.equals("netsettings")) {
                NetSettings.showConfiguration();
            } else if (!(multiProjects || project.equals("big") || project.equals("small") || project.equals("biguser") || project.equals("smalluser"))) {
                user.uiSet(session, project, "lock", "menu");
            }
        }
    }

    public static byte[] ModbusEvent(String name, InetAddress addr, int unitid, byte[] pdu) throws Exception {
        byte[] data = null;
        byte errorcode = 0;
        long pollingtime = Polling.meterPollingEventTime;
        if (pdu[0] == 3) {
            if (pdu[3] == 0 && pdu[4] == 4) {
                int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                ModbusServerResponseCache cache = modbusServerResponseCache.get(address);
                if (cache != null && cache.timestamp >= pollingtime) {
                    return cache.response;
                }
                if (address >= 10000 && address < 19999) {
                    PreparedStatement stmt;
                    int sensorid = address - 10000;
                    SensorCache sensor = Polling.sensorCache.get(sensorid);
                    if (sensor == null) {
                        sensor = Polling.sensorGet(sensorid);
                    }
                    switch (sensor.loadid) {
                        case -3: {
                            stmt = databaseConnection.prepareStatement("select sum(meterhr) from ensdatawater where sensorid = ?");
                            break;
                        }
                        case -4: {
                            stmt = databaseConnection.prepareStatement("select sum(meterhr) from ensdatagas where sensorid = ?");
                            break;
                        }
                        default: {
                            stmt = databaseConnection.prepareStatement("select sum(meterhr) from ensdata where sensorid = ?");
                        }
                    }
                    stmt.setInt(1, sensorid);
                    ResultSet rs = stmt.executeQuery();
                    byte[] valuea = null;
                    if (rs.next()) {
                        valuea = user.encodeInteger(rs.getLong(1));
                        data = new byte[10];
                        data[0] = 3;
                        data[1] = 8;
                        int i2 = 0;
                        while (i2 < 8) {
                            data[i2 + 2] = valuea[i2];
                            ++i2;
                        }
                    } else {
                        errorcode = 2;
                    }
                    rs.close();
                    stmt.close();
                    if (errorcode == 0) {
                        if (cache != null) {
                            cache.setResponse(data, pollingtime);
                        } else {
                            modbusServerResponseCache.put(address, new ModbusServerResponseCache(data, pollingtime));
                        }
                        return data;
                    }
                } else if (address == 19999) {
                    PreparedStatement stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = -2 and loadid >= -1");
                } else if (address >= 20000 && address <= 59999) {
                    PreparedStatement stmt;
                    if (address >= 20000 && address < 29999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = -2 and loadid = ?");
                        stmt.setInt(1, address - 20000);
                    } else if (address == 29999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = -2 and loadid >= -1");
                    } else if (address >= 30000 && address < 39999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = ? and loadid >= -1");
                        stmt.setInt(1, address - 30000);
                    } else if (address == 39999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = -2 and loadid >= -1");
                    } else if (address >= 40000 && address < 49999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = ? and loadid = -3");
                        stmt.setInt(1, address - 40000);
                    } else if (address == 49999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = -2 and loadid = -3");
                    } else if (address >= 50000 && address < 59999) {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = ? and loadid = -4");
                        stmt.setInt(1, address - 50000);
                    } else {
                        stmt = databaseConnection.prepareStatement("select sum(meterhr) from endata where groupid = -2 and loadid = -4");
                    }
                    ResultSet rs = stmt.executeQuery();
                    byte[] valuea = null;
                    if (rs.next()) {
                        valuea = user.encodeInteger(rs.getLong(1));
                        data = new byte[10];
                        data[0] = 3;
                        data[1] = 8;
                        int i3 = 0;
                        while (i3 < 8) {
                            data[i3 + 2] = valuea[i3];
                            ++i3;
                        }
                    } else {
                        errorcode = 2;
                    }
                    rs.close();
                    stmt.close();
                    if (errorcode == 0) {
                        if (cache != null) {
                            cache.setResponse(data, pollingtime);
                        } else {
                            modbusServerResponseCache.put(address, new ModbusServerResponseCache(data, pollingtime));
                        }
                        return data;
                    }
                } else {
                    errorcode = 2;
                }
            } else {
                errorcode = 2;
            }
        } else {
            errorcode = 1;
        }
        data = new byte[]{(byte)(pdu[0] | 0xFFFFFF80), errorcode};
        return data;
    }

    public static void StartupEvent() {
        String s;
        Statement stmtcreatetable = null;
        boolean optionsContrelSupport = false;
        boolean optionsGenericModbusSupport = false;
        boolean optionsEntesSupport = false;
        boolean managerEnabled = false;
        boolean WiFiSupport = false;
        if (!user.checkLicense()) {
            user.errorLog("STARTUP FATAL ERROR: LICENSE LIMITS ERROR - SYSTEM RESTARTING NOW");
            System.exit(9);
        }
        user.dbZip();
        user.fixHsycoIni();
        if (Long.MAX_VALUE == availableDiskSpace) {
            user.errorLog("WSMEASURE Free Space: UNKNOWN");
        } else if (smallDisk) {
            user.messageLog("WSMEASURE Free Space: " + (long)((double)availableDiskSpace / 1000000.0) + " MBytes. (S)");
        } else {
            user.messageLog("WSMEASURE Free Space: " + (long)((double)availableDiskSpace / 1000000.0) + " MBytes.");
        }
        try {
            if (URLKey == null || version == null || !version.equals("lg") && !version.equals("bt") && !version.equals("ime")) {
                user.errorLog("STARTUP FATAL ERROR: INI FILE FORMAT ERROR - SYSTEM RESTARTING NOW");
                System.exit(1);
            }
            user.uiSet("version", "text", "Energy Web Server - " + PRODUCTID + " - " + VERSION);
            user.uiSet("version.product", "text", "Energy Web Server - " + PRODUCTID);
            user.uiSet("version.number", "value", VERSION);
            user.messageLog("Energy Web Server - " + PRODUCTID + " - " + VERSION + " (Build " + BUILD + ")");
            ZONES.add(TimeZone.getTimeZone("Europe/Paris"));
            ZONES.add(TimeZone.getTimeZone("Europe/Rome"));
            ZONES.add(TimeZone.getTimeZone("Europe/London"));
            ZONES.add(TimeZone.getTimeZone("Europe/Moscow"));
            ZONES.add(TimeZone.getTimeZone("GMT-12"));
            ZONES.add(TimeZone.getTimeZone("GMT-11"));
            ZONES.add(TimeZone.getTimeZone("GMT-10"));
            ZONES.add(TimeZone.getTimeZone("GMT-9"));
            ZONES.add(TimeZone.getTimeZone("GMT-8"));
            ZONES.add(TimeZone.getTimeZone("GMT-7"));
            ZONES.add(TimeZone.getTimeZone("GMT-6"));
            ZONES.add(TimeZone.getTimeZone("GMT-5"));
            ZONES.add(TimeZone.getTimeZone("GMT-4"));
            ZONES.add(TimeZone.getTimeZone("GMT-3"));
            ZONES.add(TimeZone.getTimeZone("GMT-2"));
            ZONES.add(TimeZone.getTimeZone("GMT-1"));
            ZONES.add(TimeZone.getTimeZone("GMT"));
            ZONES.add(TimeZone.getTimeZone("GMT+1"));
            ZONES.add(TimeZone.getTimeZone("GMT+2"));
            ZONES.add(TimeZone.getTimeZone("GMT+3"));
            ZONES.add(TimeZone.getTimeZone("GMT+4"));
            ZONES.add(TimeZone.getTimeZone("GMT+5"));
            ZONES.add(TimeZone.getTimeZone("GMT+6"));
            ZONES.add(TimeZone.getTimeZone("GMT+7"));
            ZONES.add(TimeZone.getTimeZone("GMT+8"));
            ZONES.add(TimeZone.getTimeZone("GMT+9"));
            ZONES.add(TimeZone.getTimeZone("GMT+10"));
            ZONES.add(TimeZone.getTimeZone("GMT+11"));
            ZONES.add(TimeZone.getTimeZone("GMT+12"));
            locale = new Locale(user.varGet("language!"), user.varGet("country!"));
            autoTimeUpdate = Boolean.parseBoolean(user.varGet("networktimeupdate!"));
            s = user.varGet("networktimeserver!");
            autoTimeServer = s == null || s.length() == 0 ? null : s;
        }
        catch (Exception e2) {
            locale = version.equals("lg") ? new Locale("fr", "FR") : new Locale("it", "IT");
            user.saveLocale();
        }
        s = user.varGet("gaskwhm3!");
        if (s == null) {
            user.varSet("gaskwhm3!", "0");
            user.uiSet("xgaskwhm3", "value", "0");
        } else {
            user.uiSet("xgaskwhm3", "value", s);
        }
        s = user.varGet("energycurrency!");
        if (s == null || s.length() == 0) {
            user.varSet("energycurrency!", DEFAULT_ENERGY_CURRENCY);
        }
        if ((s = user.varGet("csvdecimalsep!")) == null) {
            csvDecimalSep = (char)44;
            user.varSet("csvdecimalsep!", "comma");
        } else {
            csvDecimalSep = s.equals("point") ? (char)46 : (char)44;
        }
        s = user.varGet("csvfieldsep!");
        if (s == null) {
            csvFieldSep = (char)59;
            user.varSet("csvfieldsep!", "semicolon");
            user.uiSet("(datalogger)", "csvseparator", Character.toString(csvFieldSep));
        } else if (s.equals("semicolon")) {
            csvFieldSep = (char)59;
            user.uiSet("(datalogger)", "csvseparator", Character.toString(csvFieldSep));
        } else {
            csvFieldSep = (char)44;
            user.uiSet("(datalogger)", "csvseparator", Character.toString(csvFieldSep));
        }
        s = user.varGet("dataconsolidationintervalminutes!");
        if (s != null) {
            dataConsolidationIntervalMinutes = Short.parseShort(s);
        }
        if (user.varGet("emailaccountaddress!") == null) {
            user.varSet("emailaccountaddress!", "");
        }
        if (user.varGet("emailaccountuser!") == null) {
            user.varSet("emailaccountuser!", "");
        }
        if (user.varGet("emailaccountpassword!") == null) {
            user.varSet("emailaccountpassword!", "");
        }
        if (user.varGet("emailaccountserver!") == null) {
            user.varSet("emailaccountserver!", "");
        }
        if (user.varGet("emailaccountport!") == null) {
            user.varSet("emailaccountport!", "");
        }
        if (user.varGet("emailaccountssl!") == null) {
            user.varSet("emailaccountssl!", "false");
        }
        if (user.varGet("telegrambot!") == null) {
            user.varSet("telegrambot!", "");
        }
        if (user.varGet("telegrampassword!") == null) {
            user.varSet("telegrampassword!", "");
        }
        if (user.varGet("telegramtoken!") == null) {
            user.varSet("telegramtoken!", "");
        }
        if (user.varGet("autoreportsummary!") == null) {
            user.varSet("autoreportsummary!", "false");
        }
        if (user.varGet("autoreportdetailed!") == null) {
            user.varSet("autoreportdetailed!", "false");
        }
        if (user.varGet("autoreportmonthly!") == null) {
            user.varSet("autoreportmonthly!", "false");
        }
        if (user.varGet("autoreportyearly!") == null) {
            user.varSet("autoreportyearly!", "false");
        }
        if (user.varGet("autoreportpdf!") == null) {
            user.varSet("autoreportpdf!", "false");
        }
        if (user.varGet("autoreportcsv!") == null) {
            user.varSet("autoreportcsv!", "false");
        }
        if (user.varGet("autoreportfrequency!") == null) {
            user.varSet("autoreportfrequency!", "monthly");
        }
        if (user.varGet("autoreportaddress!") == null) {
            user.varSet("autoreportaddress!", "");
        }
        if (user.varGet("autoreportsensors!") == null) {
            user.varSet("autoreportsensors!", "none");
        }
        if (user.varGet("alertsstatechanges!") == null) {
            user.varSet("alertsstatechanges!", "false");
        }
        if (user.varGet("alertsthreshold!") == null) {
            user.varSet("alertsthreshold!", "false");
        }
        if (user.varGet("alertsconferrors!") == null) {
            user.varSet("alertsconferrors!", "false");
        }
        if (user.varGet("alertscomerrors!") == null) {
            user.varSet("alertscomerrors!", "false");
        }
        if (user.varGet("alertsemailalert!") == null) {
            user.varSet("alertsemailalert!", "false");
        }
        if (user.varGet("alertstelegramalert!") == null) {
            user.varSet("alertstelegramalert!", "false");
        }
        if (user.varGet("alertsemailaddress!") == null) {
            user.varSet("alertsemailaddress!", "");
        }
        if (user.varGet("alertsemailsubject!") == null) {
            user.varSet("alertsemailsubject!", "");
        }
        try {
            Properties ini = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini.load(inifis);
            inifis.close();
            optionsContrelSupport = Boolean.parseBoolean(ini.getProperty("ContrelSupport", "false").trim());
            optionsGenericModbusSupport = Boolean.parseBoolean(ini.getProperty("GenericModbusSupport", "true").trim());
            optionsEntesSupport = Boolean.parseBoolean(ini.getProperty("EntesSupport", "false").trim());
            statusPollTime = Integer.parseInt(ini.getProperty("statusPollTime", Integer.toString(statusPollTime)).trim());
            greenUpEnabled = Boolean.parseBoolean(ini.getProperty("GreenUpEnabled", "lg".equals(version) || "bt".equals(version) ? "true" : "false").trim());
            greenUpHoldTimeMinimum = Integer.parseInt(ini.getProperty("greenUpHoldTimeMinimum", Integer.toString(greenUpHoldTimeMinimum)).trim());
            managerEnabled = Boolean.parseBoolean(ini.getProperty("ManagerEnabled", "false").trim());
            retainOldData = Boolean.parseBoolean(ini.getProperty("retainOldData", "false").trim());
            if (!managerEnabled) {
                user.uiSet("manager", "lock", "true");
                user.uiSet("manager_settings", "lock", "menu");
                user.uiSet("admin", "lock", "menu");
                user.uiSet("tunnelutil", "lock", "menu");
                user.uiSet("lorawanutil", "lock", "menu");
            }
            if (!Boolean.parseBoolean(ini.getProperty("WiFiSupport", "false").trim())) {
                WiFiSupport = false;
                user.uiSet("netsettings.wifi", "visible", "false");
                user.uiSet("netsettings.lan", "pos", "x0y120");
            } else {
                WiFiSupport = true;
            }
            s = user.varGet("greenuptotalmeterid!");
            if (s != null) {
                greenUpTotalMeterId = Integer.parseInt(s);
            }
            if ((s = user.varGet("greenupcontrol!")) != null) {
                greenUpControl = Boolean.parseBoolean(s);
            }
            if ((s = user.varGet("greenupcurrentmaxavailable!")) != null) {
                greenUpCurrentMaxAvailable = Integer.parseInt(s);
            }
            if ((s = user.varGet("greenupcurrentmaxavailablecharging!")) != null) {
                greenUpCurrentMaxAvailableCharging = Integer.parseInt(s);
            }
            if ((s = user.varGet("greenupcurrenthysteresis!")) != null) {
                greenUpCurrentHysteresis = Integer.parseInt(s);
            }
            if ((s = user.varGet("greenupcurrentfirstreduction!")) != null) {
                greenUpCurrentFirstReduction = Integer.parseInt(s);
            }
            if ((s = user.varGet("greenupcurrentsecondreduction!")) != null) {
                greenUpCurrentSecondReduction = Integer.parseInt(s);
            }
            if ((s = user.varGet("greenupchargequantityminimum!")) != null) {
                greenUpChargeQuantityMinimum = Integer.parseInt(s);
            }
        }
        catch (Exception e3) {
            user.errorLog("STARTUP ERROR: ERROR READING OPTIONAL WSMEASURE CONFIGURATION PARAMETERS - IGNORED");
        }
        user.messageLog("WSMEASURE STARTUP: LOADING MODELS");
        user.readModelsXls(version, optionsContrelSupport, optionsEntesSupport, optionsGenericModbusSupport);
        user.messageLog("WSMEASURE STARTUP: CONNECTING TO DATABASE");
        user.dbConnect();
        user.messageLog("WSMEASURE STARTUP: CHECKING DATABASE COMPACT");
        user.dbCompact();
        try {
            stmtcreatetable = databaseConnection.createStatement();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table access (userid varchar(16) primary key, rights varchar(256))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ACCESS], CREATED");
            stmtcreatetable.execute("insert into access (userid, rights) values ('administrator', 'conf:1,maint:1,data:0,view:1,control:1')");
            stmtcreatetable.execute("insert into access (userid, rights) values ('installer', 'conf:1,maint:1,data:0,view:1,control:0')");
            stmtcreatetable.execute("insert into access (userid, rights) values ('user', 'conf:0,maint:1,data:0,view:1,control:0')");
            if (greenUpEnabled) {
                stmtcreatetable.execute("insert into access (userid, rights) values ('GreenUp', 'conf:1,maint:1,data:0,view:1,control:1,gmaint:1,gcontrol:1,gview:1')");
            }
            if (user.accessIniInitialize()) {
                user.messageLog("STARTUP WARNING: FILE NOT FOUND [ACCESS.INI], CREATED");
            }
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ACCESS], LOADED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table tasks (taskid varchar(256) primary key, pointer varchar(256), phase integer)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [TASKS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table racks (rackid integer generated by default as identity primary key,name varchar(256) unique,description varchar(256),enabled boolean)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [RACKS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table loads (loadid integer generated by default as identity primary key,name varchar(256) unique,locked boolean,enabled boolean)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [LOADS], CREATED");
            stmtcreatetable.execute("insert into loads (name, locked, enabled) values ('RT 2012 [1]', true, true)");
            stmtcreatetable.execute("insert into loads (name, locked, enabled) values ('RT 2012 [2]', true, true)");
            stmtcreatetable.execute("insert into loads (name, locked, enabled) values ('RT 2012 [3]', true, true)");
            stmtcreatetable.execute("insert into loads (name, locked, enabled) values ('RT 2012 [4]', true, true)");
            stmtcreatetable.execute("insert into loads (name, locked, enabled) values ('RT 2012 [5]', true, true)");
            stmtcreatetable.execute("insert into loads (name, locked, enabled) values ('RT 2012 [6]', true, true)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [LOADS], LOADED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table groups (groupid integer generated by default as identity primary key,name varchar(256) unique,description varchar(256),enabled boolean)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [GROUPS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table gateways (gatewayid integer generated by default as identity primary key,address varchar(256),name varchar(256) unique,description varchar(256),rackid integer,eqsensorid integer,enabled boolean,error integer)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [GATEWAYS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table sensors (sensorid integer generated by default as identity primary key,address integer,subaddress varchar(32),scale real,unit varchar(16),name varchar(256),modelid integer,gatewayid integer,loadid integer,group1id integer,group2id integer,group3id integer,group4id integer,group5id integer,enabled boolean,qualityerror integer,qualitymessage varchar(256),error integer)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [SENSORS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table stdata (seq integer generated by default as identity primary key,sensorid integer,ltime timestamp(0),meter integer,raw varbinary(4096))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [STDATA], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index stidx on stdata (sensorid, ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [STIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table thdata (seq integer generated by default as identity primary key,sensorid integer,ltime timestamp(0),raw varbinary(4096))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [THDATA], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index thidx on thdata (sensorid, ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [THIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index thidx2 on thdata (sensorid, seq);");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [THIDX2], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table eqdata (seq integer generated by default as identity primary key,sensorid integer,ltime timestamp(0),raw varbinary(4096),thderror boolean,herror boolean)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [EQDATA], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index eqidx on eqdata (sensorid, ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [EQIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index eqidx2 on eqdata (ltime);");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [EQIDX2], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index eqidx3 on eqdata (sensorid, seq);");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [EQIDX3], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table endata (groupid integer,loadid integer,lyear smallint,lmonth smallint,lday smallint,lhour smallint,lmin smallint,ltime timestamp(0),meter bigint,constraint enkey primary key (groupid, loadid, lyear, lmonth, lday, lhour, lmin))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ENDATA], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index enidx on endata (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ENIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index enidx2 on endata (loadid)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ENIDX2], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index enidx3 on endata (groupid)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ENIDX3], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table ensdata (sensorid integer,lyear smallint,lmonth smallint,lday smallint,lhour smallint,lmin smallint,ltime timestamp(0),meter bigint,constraint enskey primary key (sensorid, lyear, lmonth, lday, lhour, lmin))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ENSDATA], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index ensidx on ensdata (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ENSIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table sensors add nototals boolean");
            user.messageLog("STARTUP WARNING: TABLE [SENSORS], NOTOTALS COLUMN ADDED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table sensors add priority boolean");
            user.messageLog("STARTUP WARNING: TABLE [SENSORS], PRIORITY COLUMN ADDED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table cscharges (seq integer generated by default as identity primary key,time timestamp(0),sensorid integer,side smallint,plug smallint,chargeid bigint,userid varchar(24),intime timestamp(0),outtime timestamp(0),avgcurrent integer,peakcurrent integer,chgtime integer,waittime integer,p3p boolean,pmpf boolean,phwer boolean,phwenr boolean,pevle boolean,pevde boolean,pevce boolean,pevcpe boolean,pevo boolean,pdle boolean,pdce boolean,pdo boolean,poe boolean)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [CSCHARGES], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index cschargessensorididx on cscharges (sensorid)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [CSCHARGESSENSORIDIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index cschargesintimeidx on cscharges (intime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [CSCHARGESINTIMEIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table csstat (seq integer generated by default as identity primary key,time timestamp(0),sensorid integer,totnumcharges bigint,totavgcurrent integer,totpeakcurrent integer,totchgtime bigint,totwaittime bigint)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [CSSTAT], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index ccsstatsensorididx on csstat (sensorid)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [CCSSTATSENSORIDIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index csstattimeidx on csstat (time)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [CSSTATTIMEIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table csstate (seq integer generated by default as identity primary key,time timestamp(0),sensorid integer,plug smallint,state smallint,userid varchar(24),\"CURRENT\" integer,avgcurrent integer,peakcurrent integer,chgtime integer,waittime integer,p3p boolean,pmpf boolean,phwer boolean,phwenr boolean,pevle boolean,pevde boolean,pevce boolean,pevcpe boolean,pevo boolean,pdle boolean,pdce boolean,pdo boolean,poe boolean)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [CSSTATE], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index ccsstatesensorididx on csstate (sensorid)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [CCSSTATESENSORIDIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index csstatetimeidx on csstate (time)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [CSSTATETIMEIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table ensdatawater (sensorid integer,lyear smallint,lmonth smallint,lday smallint,lhour smallint,lmin smallint,ltime timestamp(0),meter bigint,constraint enswkey primary key (sensorid, lyear, lmonth, lday, lhour, lmin))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ENSDATAWATER], CREATED");
            stmtcreatetable.execute("drop index ensidx");
            stmtcreatetable.execute("create index ensidx on ensdata (ltime)");
            user.messageLog("STARTUP WARNING: TABLE INDEX ENSIDX, FIXED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index enswateridx on ensdatawater (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ENSWATERIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table ensdatagas (sensorid integer,lyear smallint,lmonth smallint,lday smallint,lhour smallint,lmin smallint,ltime timestamp(0),meter bigint,constraint ensgkey primary key (sensorid, lyear, lmonth, lday, lhour, lmin))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ENSDATAGAS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index ensgasidx on ensdatagas (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ENSGASIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table sensors add noalerts boolean");
            user.messageLog("STARTUP WARNING: TABLE [SENSORS], NOALERTS COLUMN ADDED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table sensors add interfaceaddress integer");
            user.messageLog("STARTUP WARNING: TABLE [SENSORS], INTERFACEADDRESS COLUMN ADDED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table alarms (ts bigint,data varchar(256),acknowledged boolean,constraint alarmskey primary key (data))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [ALARMS], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index alarmsidx on alarms (ts)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [ALARMSIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table endata add meterhr bigint");
            user.messageLog("STARTUP WARNING: TABLE [ENDATA], METERHR COLUMN ADDED");
            stmtcreatetable.execute("update endata set meterhr = meter * 1000");
            stmtcreatetable.execute("alter table endata drop meter");
            user.messageLog("STARTUP WARNING: TABLE [ENDATA], METER COLUMN DROPPED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table ensdata add meterhr bigint");
            user.messageLog("STARTUP WARNING: TABLE [ENSDATA], METERHR COLUMN ADDED");
            stmtcreatetable.execute("update ensdata set meterhr = meter * 1000");
            stmtcreatetable.execute("alter table ensdata drop meter");
            user.messageLog("STARTUP WARNING: TABLE [ENSDATA], METER COLUMN DROPPED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table ensdatawater add meterhr bigint");
            user.messageLog("STARTUP WARNING: TABLE [ENSDATAWATER], METERHR COLUMN ADDED");
            stmtcreatetable.execute("update ensdatawater set meterhr = meter * 1000");
            stmtcreatetable.execute("alter table ensdatawater drop meter");
            user.messageLog("STARTUP WARNING: TABLE [ENSDATAWATER], METER COLUMN DROPPED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table ensdatagas add meterhr bigint");
            user.messageLog("STARTUP WARNING: TABLE [ENSDATAGAS], METERHR COLUMN ADDED");
            stmtcreatetable.execute("update ensdatagas set meterhr = meter * 1000");
            stmtcreatetable.execute("alter table ensdatagas drop meter");
            user.messageLog("STARTUP WARNING: TABLE [ENSDATAGAS], METER COLUMN DROPPED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("alter table sensors add description varchar(4096)");
            user.messageLog("STARTUP WARNING: TABLE [SENSORS], DESCRIPTION COLUMN ADDED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("update alarms set data = concat(substring(data from 7 for 4), '-', substring(data from 4 for 2), '-', substring(data from 1 for 2), ' ', substring(data from 12)) where substring(data from 3 for 1) = '-'");
            if (stmtcreatetable.getUpdateCount() > 0) {
                user.messageLog("STARTUP WARNING: TABLE [ALARMS], DATE FORMAT UPDATED");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("drop table currencies");
            user.messageLog("STARTUP WARNING: TABLE [CURRENCIES], DELETED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table pfsdata (sensorid integer,lyear smallint,lmonth smallint,lday smallint,lhour smallint,lmin smallint,ltime timestamp(0),meterhr bigint,samples smallint,constraint pfskey primary key (sensorid, lyear, lmonth, lday, lhour, lmin))");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [PFSDATA], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index pfsidx on pfsdata (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [PFSIDX], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index stidx2 on stdata (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [STIDX2], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create index thidx3 on thdata (ltime)");
            user.messageLog("STARTUP WARNING: INDEX NOT FOUND [THIDX3], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmtcreatetable.execute("create cached table rates (rateid integer primary key,name varchar(256),color integer,cost1 integer,validity1 integer,cost2 integer,validity2 integer,cost3 integer,validity3 integer,cost4 integer,validity4 integer,cost5 integer,validity5 integer)");
            stmtcreatetable.execute("insert into rates values (20, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (21, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (22, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (23, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (24, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (30, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (31, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (32, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (33, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (34, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (40, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (41, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (42, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (43, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            stmtcreatetable.execute("insert into rates values (44, '', -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1)");
            user.messageLog("STARTUP WARNING: TABLE NOT FOUND [RATES], CREATED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataProcessor.init();
        Polling.gatewayStartAll();
        DataProcessor.eqInitUI();
        if (greenUpEnabled) {
            ChargeController.init();
        }
        Reports.init();
        Alarms.init();
        CostRates.init();
        NetSettings.init(WiFiSupport);
        ModbusGatewaySettings.isRTUEnabled();
        trialCounter = user.trialCounter(false);
        if (trialCounter == 0) {
            user.disableAllGateways();
        }
    }

    public static void TimeEvent(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        if (cal.get(1) < 2010) {
            trialCounter = user.trialCounter(false);
            if (trialCounter == 0) {
                user.disableAllGateways();
            }
            return;
        }
        if (!smallDisk || cal.get(12) % 5 == 0) {
            Polling.checkPoint(false);
        }
        if (dataErrorTimestamp != 0L && time > dataErrorTimestamp + 3600000L) {
            dataErrorTimestamp = 0L;
            Polling.dataErrorAlert(false);
        }
        if (printSettings) {
            DataProcessor.settings();
            printSettings = false;
        }
        Polling.csvFileEnergyImport();
        String emailReporterFrequency = user.varGet("autoreportfrequency!");
        if (emailReporterFrequency != null && cal.get(11) == 3 && cal.get(12) == 0) {
            if (emailReporterFrequency.equals("daily")) {
                Reports.emailReporter();
            } else if (emailReporterFrequency.equals("weekly")) {
                if (cal.get(7) == 2) {
                    Reports.emailReporter();
                }
            } else if (emailReporterFrequency.equals("monthly") && cal.get(5) == 1) {
                Reports.emailReporter();
            }
        }
        if (cal.get(12) == 0) {
            if (!retainOldData) {
                DataProcessor.deleteOldData();
            }
            if (cal.get(11) == 0) {
                DataProcessor.eq();
            }
            DataProcessor.energy();
            DataProcessor.consolidate();
            DataProcessor.devices();
            Alarms.consolidate();
            if (autoTimeUpdate) {
                user.execNtpdate();
            }
            user.diskSpaceTestFlag();
            if (cal.get(11) == 0) {
                if (smallDisk) {
                    user.filesDelete(new File("logs"), null, 864000000L, 0L);
                }
                if (lowDiskSpace) {
                    user.filesDelete(new File("userdata"), new File("userdata/settings"), 2592000000L, 864000000L);
                }
            }
            if (hsycoDatabaseBackup && cal.get(11) == 0) {
                user.dbBackup();
            }
            if ((trialCounter = user.trialCounter(true)) == 0) {
                user.disableAllGateways();
            }
        }
        user.dbStatusDisplay();
        if (cal.get(12) % 15 == 0) {
            DataProcessor.breakers();
        }
    }

    public static void SchedulerEvent(String groupname, String schedulename) {
        block16: {
            if (Calendar.getInstance().get(1) < 2010) {
                return;
            }
            try {
                if (groupname.startsWith("poll_")) {
                    Polling.pollingEvent(groupname, schedulename);
                } else if (groupname.equals("charge_controller")) {
                    if (schedulename.equals("eqlogger")) {
                        ChargeController.logger(true);
                    } else if (schedulename.equals("controller")) {
                        ChargeController.controller();
                    } else if (schedulename.equals("logger")) {
                        ChargeController.logger(false);
                    }
                } else if (groupname.equals("alarms")) {
                    if (schedulename.equals("polling")) {
                        Alarms.polling();
                    }
                } else if (groupname.equals("costrates") && schedulename.equals("load")) {
                    CostRates.loadScheduler();
                    CostRates.loadCache();
                }
            }
            catch (Exception e2) {
                if (!Configuration.verboseLog) break block16;
                user.errorLog("SchedulerEvent(\"" + groupname + "\", \"" + schedulename + ") Exception: " + e2.getLocalizedMessage());
            }
        }
    }

    public static void programTimerEvent(String name) {
        if (name.equalsIgnoreCase("netsettings.ap.off")) {
            NetSettings.programTimerOffEvent();
        } else if (name.equalsIgnoreCase("netsettings.errors.off")) {
            NetSettings.programTimerErrorTimeoutEvent();
        } else if (name.equalsIgnoreCase("wsmeasure.exit")) {
            System.exit(0);
        }
    }

    public static void printHash(String header, Hashtable<String, Integer> values) {
        System.out.println("---- " + header + " ----");
        Enumeration<String> e2 = values.keys();
        while (e2.hasMoreElements()) {
            String k2 = e2.nextElement();
            System.out.println(String.valueOf(k2) + "=" + values.get(k2));
        }
        System.out.println();
    }

    private static void displayHash(StringBuffer buffer, Hashtable<String, String> values) {
        boolean first = true;
        if (!values.isEmpty()) {
            if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '{') {
                buffer.append(',');
            }
            Enumeration<String> e2 = values.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                String value = values.get(k2);
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append('\"');
                buffer.append(k2);
                if (value.startsWith("[")) {
                    buffer.append("\":");
                    buffer.append(value);
                    continue;
                }
                buffer.append("\":\"");
                buffer.append(value);
                buffer.append('\"');
            }
        }
    }

    public static void httpRawEvent(String host, boolean secure, String version, String httpmethod, boolean gzip, String contenttype, String query, String session, String userid, BufferedOutputStream out, BufferedInputStream in) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        int sep = query.indexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        if ((sep = query.lastIndexOf(64)) >= 0) {
            String id = URLDecoder.decode(query.substring(0, sep), "UTF-8");
            String rem = URLDecoder.decode(query.substring(sep + 1), "UTF-8");
            if (rem.equals("pdf_reports")) {
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
                user.pdfReports(out, w, secure, userid, version, gzip, query);
            } else {
                String ret = "ack" + user.userCommandInternal(session, userid, rem, id);
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
                w.write(version);
                w.write(" 200 OK\r\n");
                w.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                w.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                w.write("Content-length: " + ret.length() + "\r\n");
                w.write("Content-type: text/plain\r\n");
                w.write("Cache-Control: no-store, no-cache\r\n\r\n");
                w.write(ret.toString());
                ((Writer)w).flush();
            }
        } else if (query.equals("upload")) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            BufferedOutputStream outs = new BufferedOutputStream(bytesOut);
            byte[] buff = new byte[4096];
            int n2 = 0;
            while ((n2 = in.read(buff)) >= 0) {
                outs.write(buff, 0, n2);
            }
            outs.close();
            if (user.upload(".", bytesOut.toByteArray()) != -1) {
                w.write(version);
                w.write(" 200 OK\r\n");
                w.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                w.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                w.write("Content-length: 2\r\n");
                w.write("Content-type: text/plain");
                w.write("\r\nCache-Control: no-store, no-cache\r\n\r\n");
                w.write("ok");
                ((Writer)w).flush();
            } else {
                w.write(version);
                w.write(" 200 OK\r\n");
                w.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                w.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                w.write("Content-length: 5\r\n");
                w.write("Content-type: text/plain");
                w.write("\r\nCache-Control: no-store, no-cache\r\n\r\n");
                w.write("error");
                ((Writer)w).flush();
            }
        } else {
            if (query.startsWith("~")) {
                return;
            }
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            w.write(version);
            w.write(" 200 OK\r\n");
            w.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            w.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            w.write("Content-length: 0\r\n");
            w.write("Content-type: text/plain\r\n");
            w.write("Cache-Control: no-store, no-cache\r\n\r\n");
            ((Writer)w).flush();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String userCommand(String session, String userid, String name, String param) {
        if (name.toLowerCase().startsWith("state.s.")) {
            int outid;
            SensorCache sensor;
            block28: {
                String[] sa2;
                block26: {
                    int outid2;
                    block27: {
                        try {
                            sa2 = name.split("[.]");
                            sensor = Polling.sensorCache.get(Integer.parseInt(sa2[2]));
                            if (sensor.modelid != 62) break block26;
                            outid2 = Integer.parseInt(sa2[4]);
                            if (!sa2[3].equalsIgnoreCase("out") || outid2 < 1 || outid2 > 2) return null;
                            if (!param.equalsIgnoreCase("on") && !param.equals("1")) break block27;
                            EMS.commandGeneric(sensor, outid2, true);
                            return "!";
                        }
                        catch (Exception sa2) {
                            return null;
                        }
                    }
                    if (!param.equalsIgnoreCase("off") && !param.equals("0")) return null;
                    EMS.commandGeneric(sensor, outid2, false);
                    return "!";
                }
                if (sensor.modelid != 90 && sensor.modelid != 91) return null;
                outid = Integer.parseInt(sa2[4]);
                if (!sa2[3].equalsIgnoreCase("dout") || outid < 1 || outid > 6) return null;
                if (!param.equalsIgnoreCase("on") && !param.equals("1")) break block28;
                M7TIC.commandOutput(sensor, outid, true);
                return "!";
            }
            if (!param.equalsIgnoreCase("off") && !param.equals("0")) return null;
            M7TIC.commandOutput(sensor, outid, false);
            return "!";
        }
        if (name.startsWith("userdatalogger:d")) {
            int rateid;
            int sensorid;
            block29: {
                try {
                    if (user.checkUserRights(userid, "view")) break block29;
                    return "{\"datalogger\":\"null\"}";
                }
                catch (Exception e2) {
                    return "{\"datalogger\":\"null\"}";
                }
            }
            int ratesep = name.indexOf(114, 16);
            if (ratesep > 0) {
                sensorid = Integer.parseInt(name.substring(16, ratesep));
                rateid = Integer.parseInt(name.substring(ratesep + 1));
            } else {
                sensorid = Integer.parseInt(name.substring(16));
                rateid = -1;
            }
            SensorCache sensor = Polling.sensorCache.get(sensorid);
            if (sensor.modelid == 124 || sensor.modelid == 125 || sensor.modelid == 126 || sensor.modelid == 127) {
                String[] pa = param.split(";");
                if (pa.length == 3) {
                    long ts = Long.parseLong(pa[0]);
                    return user.pfDataLoggerLiveJSON(ts, sensorid);
                }
                if (pa.length != 4) return null;
                return user.pfDataLoggerBrowserJSON(pa[1], pa[2], sensorid);
            }
            String[] pa = param.split(";");
            if (pa.length == 3) {
                long ts = Long.parseLong(pa[0]);
                return user.energyDataLoggerLiveJSON(ts, sensorid, 0, 0);
            }
            if (pa.length != 4) return null;
            if (rateid != -1) return user.costDataLoggerBrowserJSON(pa[1], pa[2], sensorid, 0, 0, rateid);
            return user.energyDataLoggerBrowserJSON(pa[1], pa[2], sensorid, 0, 0);
        }
        if (name.startsWith("userdatalogger:g")) {
            int rateid;
            int loadid;
            int groupid;
            block30: {
                try {
                    if (user.checkUserRights(userid, "view")) break block30;
                    return "{\"datalogger\":\"null\"}";
                }
                catch (Exception e3) {
                    return "{\"datalogger\":\"null\"}";
                }
            }
            int x = name.lastIndexOf(108);
            int ratesep = name.indexOf(114, 16);
            if (ratesep > 0) {
                groupid = Integer.parseInt(name.substring(16, x));
                loadid = Integer.parseInt(name.substring(x + 1, ratesep));
                rateid = Integer.parseInt(name.substring(ratesep + 1));
            } else {
                groupid = Integer.parseInt(name.substring(16, x));
                loadid = Integer.parseInt(name.substring(x + 1));
                rateid = -1;
            }
            String[] pa = param.split(";");
            if (pa.length == 3) {
                long ts = Long.parseLong(pa[0]);
                return user.energyDataLoggerLiveJSON(ts, -1, loadid, groupid);
            }
            if (pa.length != 4) return null;
            if (rateid != -1) return user.costDataLoggerBrowserJSON(pa[1], pa[2], -1, loadid, groupid, rateid);
            return user.energyDataLoggerBrowserJSON(pa[1], pa[2], -1, loadid, groupid);
        }
        if (name.equalsIgnoreCase("email.send")) {
            try {
                String[] pa = param.split(";", 3);
                Reports.sendMail(pa[0], pa[1], pa[2]);
                return "!";
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "!";
        }
        if (name.equalsIgnoreCase("data.compact") && param.equals("trigger")) {
            user.dbCompactTrigger();
            return "!";
        }
        if (!name.equalsIgnoreCase("csv_regen")) return null;
        user.csvRegen(param);
        return "!";
    }

    public static String userSubmit(String session, String uid, String name, HashMap<String, String> fields) {
        if (name.equals("netsettings")) {
            NetSettings.userSubmit(session, uid, fields);
            return "!";
        }
        if (name.equals("modbussettings")) {
            ModbusGatewaySettings.userSubmit(session, uid, fields);
            return "!";
        }
        return null;
    }

    public static String userCommandInternal(String session, String userid, String rem, String id) throws Exception {
        try {
            if (rem.equals("read_sensor")) {
                return user.readSensor(userid, id);
            }
            if (rem.equals("read_energy")) {
                return user.readEnergy(userid, id);
            }
            if (rem.equals("req_access")) {
                return user.reqAccess(userid, id);
            }
            if (rem.equals("set_access")) {
                return user.setAccess(userid, id);
            }
            if (rem.equals("set_trialcode")) {
                return user.setTrialCode(userid, id);
            }
            if (rem.equals("req_currentlocaltime")) {
                return user.reqCurrentLocalTime(userid);
            }
            if (rem.equals("req_systemsettings")) {
                return user.reqSystemSettings(userid);
            }
            if (rem.equals("set_systemsettings")) {
                return user.setSystemSettings(userid, id);
            }
            if (rem.equals("req_timezones")) {
                return user.reqTimeZones(userid);
            }
            if (rem.equals("set_timeauto") || rem.equals("set_timemanual")) {
                return user.setTime(userid, id);
            }
            if (rem.equals("req_racks")) {
                return user.reqRacks(userid);
            }
            if (rem.equals("new_rack")) {
                return user.newRack(userid, id);
            }
            if (rem.equals("edit_rack")) {
                return user.editRack(userid, id);
            }
            if (rem.equals("command_rack")) {
                return user.commandRack(userid, id);
            }
            if (rem.equals("req_loads")) {
                return user.reqLoads(userid);
            }
            if (rem.equals("new_load")) {
                return user.newLoad(userid, id);
            }
            if (rem.equals("edit_load")) {
                return user.editLoad(userid, id);
            }
            if (rem.equals("command_load")) {
                return user.commandLoad(userid, id);
            }
            if (rem.equals("req_groups")) {
                return user.reqGroups(userid);
            }
            if (rem.equals("new_group")) {
                return user.newGroup(userid, id);
            }
            if (rem.equals("edit_group")) {
                return user.editGroup(userid, id);
            }
            if (rem.equals("command_group")) {
                return user.commandGroup(userid, id);
            }
            if (rem.equals("req_rates")) {
                return user.reqRates(userid, id);
            }
            if (rem.equals("edit_rate")) {
                return user.editRate(userid, id);
            }
            if (rem.equals("req_gateways")) {
                return user.reqGateways(userid);
            }
            if (rem.equals("new_gateway")) {
                return user.newGateway(userid, id);
            }
            if (rem.equals("edit_gateway")) {
                return user.editGateway(userid, id);
            }
            if (rem.equals("command_gateway")) {
                return user.commandGateway(userid, id);
            }
            if (rem.equals("test_gateway")) {
                return user.testGateway(userid, id);
            }
            if (rem.equals("req_links")) {
                return user.reqLinks(userid);
            }
            if (rem.equals("req_sensors")) {
                return user.reqSensors(userid);
            }
            if (rem.equals("new_sensor")) {
                return user.newSensor(userid, id);
            }
            if (rem.equals("edit_sensor")) {
                return user.editSensor(userid, id);
            }
            if (rem.equals("command_sensor")) {
                return user.commandSensor(userid, id);
            }
            if (rem.equals("test_sensor")) {
                return user.testSensor(userid, id);
            }
            if (rem.equals("req_alarms")) {
                return user.reqAlarms(userid);
            }
            if (rem.equals("set_alarm")) {
                return user.setAlarm(userid, id);
            }
            if (rem.equals("req_models")) {
                return user.reqModels(userid);
            }
            if (rem.equals("req_concentrators")) {
                return user.reqConcentrators(userid);
            }
            if (rem.equals("req_energyoptions")) {
                return user.reqEnergyOptions(userid);
            }
            if (rem.equals("set_energyoptions")) {
                return user.setEnergyOptions(userid, id);
            }
            if (rem.equals("req_emailsettings")) {
                return user.reqEmailSettings(userid);
            }
            if (rem.equals("set_emailsettings")) {
                return user.setEmailSettings(userid, id);
            }
            if (rem.equals("test_emailsettings")) {
                return user.testEmailSettings(userid, id);
            }
            if (rem.equals("req_telegramsettings")) {
                return user.reqTelegramSettings(userid);
            }
            if (rem.equals("set_telegramsettings")) {
                return user.setTelegramSettings(userid, id);
            }
            if (rem.equals("test_telegramsettings")) {
                return user.testTelegramSettings(userid, id);
            }
            if (rem.equals("req_autoreportsettings")) {
                return user.reqAutoReportSettings(userid);
            }
            if (rem.equals("set_autoreportsettings")) {
                return user.setAutoReportSettings(userid, id);
            }
            if (rem.equals("req_alertsettings")) {
                return user.reqAlertSettings(userid);
            }
            if (rem.equals("set_alertsettings")) {
                return user.setAlertSettings(userid, id);
            }
            if (rem.equals("dbzip")) {
                return user.dbZip(userid, id);
            }
            if (rem.equals("req_greenup_config")) {
                return user.reqGreenUpConfiguration(userid);
            }
            if (rem.equals("set_greenup_config")) {
                return user.setGreenUpConfiguration(userid, id);
            }
            if (rem.equals("command_gmaint")) {
                return user.commandGmaint(userid, id);
            }
            if (rem.equals("command_gmanagement")) {
                return user.commandGmanagement(userid, id);
            }
            if (rem.equals("reports")) {
                return user.reports(userid, id);
            }
        }
        catch (Exception e2) {
            return "data:error";
        }
        return null;
    }

    private static boolean csvRegen(String param) {
        String condition;
        block9: {
            try {
                if ("stdata".equals(param)) {
                    condition = "taskid like 'stdata.%'";
                    break block9;
                }
                if ("eqdata".equals(param)) {
                    condition = "taskid like 'eqdata.%'";
                    break block9;
                }
                if ("thdata".equals(param)) {
                    condition = "taskid like 'thdata.%'";
                    break block9;
                }
                if ("ensdata".equals(param)) {
                    condition = "taskid = 'ensdata%'";
                    break block9;
                }
                if ("endata".equals(param)) {
                    condition = "taskid = 'endata'";
                    break block9;
                }
                if ("all".equals(param)) {
                    DataProcessor.fixTablesTimestamp();
                    user.delete(new File("userdata/devices"));
                    user.delete(new File("userdata/energy"));
                    condition = "taskid like 'stdata.%' OR taskid like 'eqdata.%' OR taskid like 'thdata.%' OR TASKID like 'ensdata%' OR TASKID = 'endata' OR taskid like 'cscharges.%' OR taskid like 'csstat.%' OR taskid like 'csstate.%'";
                    break block9;
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("delete from tasks where " + condition);
        pstmt.execute();
        user.messageLog("WARNING: CSV FILES REGENERATION REQUEST [" + param.toUpperCase() + "]");
        return true;
    }

    static boolean pdfReports(OutputStream raw, Writer out, boolean secure, String userid, String version, boolean gzip, String query) {
        if (!user.checkUserRights(userid, "view")) {
            return false;
        }
        try {
            String[] sa;
            int sep = query.lastIndexOf(64);
            if ("pdf_reports".equalsIgnoreCase(URLDecoder.decode(query.substring(sep + 1), "UTF-8")) && (sa = URLDecoder.decode(query.substring(0, sep), "UTF-8").split(",")).length >= 2) {
                int i2;
                int[] ids;
                String filename;
                byte[] responseBytes;
                if ("yearly".equalsIgnoreCase(sa[0])) {
                    responseBytes = Reports.annualReportPDF(Integer.parseInt(sa[1]));
                    filename = "yearly-report_" + sa[1] + ".pdf";
                } else if ("monthly".equalsIgnoreCase(sa[0])) {
                    responseBytes = Reports.montlyReportPDF(Integer.parseInt(sa[1]), Integer.parseInt(sa[2]));
                    filename = "monthly-report_" + sa[1] + "-" + sa[2] + ".pdf";
                } else if ("yearlysensors".equalsIgnoreCase(sa[0])) {
                    ids = new int[sa.length - 2];
                    i2 = 0;
                    while (i2 < ids.length) {
                        ids[i2] = Integer.parseInt(sa[i2 + 2]);
                        ++i2;
                    }
                    responseBytes = Reports.annualSensorsReportPDF(Integer.parseInt(sa[1]), ids);
                    filename = "detailed-yearly-report_" + sa[1] + ".pdf";
                } else if ("monthlysensors".equalsIgnoreCase(sa[0])) {
                    ids = new int[sa.length - 3];
                    i2 = 0;
                    while (i2 < ids.length) {
                        ids[i2] = Integer.parseInt(sa[i2 + 3]);
                        ++i2;
                    }
                    responseBytes = Reports.montlySensorsReportPDF(Integer.parseInt(sa[1]), Integer.parseInt(sa[2]), ids);
                    filename = "detailed-monthly-report_" + sa[1] + "-" + sa[2] + ".pdf";
                } else {
                    responseBytes = null;
                    filename = null;
                }
                if (responseBytes != null) {
                    if (gzip) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        gzos.write(responseBytes, 0, responseBytes.length);
                        gzos.close();
                        responseBytes = baos.toByteArray();
                    }
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + new Date() + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + responseBytes.length + "\r\n");
                    if (gzip) {
                        out.write("Content-Encoding: gzip\r\n");
                    }
                    out.write("Content-disposition: attachment; filename=" + filename + "\r\n");
                    out.write("Content-type: application/octet-stream\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    raw.write(responseBytes);
                    raw.flush();
                } else {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + new Date() + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: 5\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.write("error");
                    out.flush();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String reports(String userid, String param) throws Exception {
        block12: {
            String[] sa;
            block13: {
                int today;
                int tomonth;
                int toyear;
                int fromday;
                int frommonth;
                int fromyear;
                int[] devices;
                block17: {
                    int period;
                    boolean cost;
                    block16: {
                        block15: {
                            block14: {
                                long maxfilesize = 100000000L;
                                if (!user.userAdministratorCheck(userid) || (sa = param.split(",")).length <= 1 || !"data".equals(sa[0])) break block12;
                                if (!"run".equals(sa[1]) || sa.length <= 11) break block13;
                                if (reportsStatus != 1) break block14;
                                return "data:busy";
                            }
                            devices = new int[sa.length - 11];
                            int i2 = 0;
                            while (i2 < devices.length) {
                                devices[i2] = Integer.parseInt(sa[i2 + 11]);
                                ++i2;
                            }
                            fromyear = Integer.parseInt(sa[3]);
                            frommonth = Integer.parseInt(sa[4]);
                            fromday = Integer.parseInt(sa[5]);
                            toyear = Integer.parseInt(sa[6]);
                            tomonth = Integer.parseInt(sa[7]);
                            today = Integer.parseInt(sa[8]);
                            cost = Boolean.parseBoolean(sa[9]);
                            int p = Integer.parseInt(sa[10]);
                            int n2 = period = p == 15 ? (int)dataConsolidationIntervalMinutes.shortValue() : p;
                            if (!"meters".equals(sa[2])) break block15;
                            Runnable task = new Runnable(){

                                public void run() {
                                    long remainingsize = 100000000L;
                                    reportsKillSwitch = false;
                                    reportsStatus = 1;
                                    user.reportsCancel();
                                    user.uiSet("xreport.status", "value", "1/3");
                                    remainingsize -= DataProcessor.reportEnergyDevices(2, cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, remainingsize, devices);
                                    user.uiSet("xreport.status", "value", "2/3");
                                    remainingsize -= DataProcessor.reportEnergyDevices(3, cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, remainingsize, devices);
                                    user.uiSet("xreport.status", "value", "3/3");
                                    DataProcessor.reportEnergyDevices(4, cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, remainingsize, devices);
                                    if (reportsKillSwitch) {
                                        user.reportsCancel();
                                        reportsKillSwitch = false;
                                        reportsStatus = -1;
                                    } else {
                                        user.uiSet("xreport.status", "value", "ready");
                                        reportsStatus = 0;
                                    }
                                }
                            };
                            exec.execute(task);
                            return "data:ok";
                        }
                        if (!"loads".equals(sa[2])) break block16;
                        Runnable task = new Runnable(){

                            public void run() {
                                reportsKillSwitch = false;
                                reportsStatus = 1;
                                user.reportsCancel();
                                user.uiSet("xreport.status", "value", "1/1");
                                DataProcessor.reportEnergyLoads(cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, 100000000L, devices);
                                if (reportsKillSwitch) {
                                    user.reportsCancel();
                                    user.uiSet("xreport.status", "value", "idle");
                                    reportsStatus = -1;
                                } else {
                                    user.uiSet("xreport.status", "value", "ready");
                                    reportsStatus = 0;
                                }
                            }
                        };
                        exec.execute(task);
                        return "data:ok";
                    }
                    if (!"groups".equals(sa[2])) break block17;
                    Runnable task = new Runnable(){

                        public void run() {
                            long remainingsize = 100000000L;
                            reportsKillSwitch = false;
                            reportsStatus = 1;
                            user.reportsCancel();
                            user.uiSet("xreport.status", "value", "1/3");
                            remainingsize -= DataProcessor.reportEnergyGroups(2, cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, remainingsize, devices);
                            user.uiSet("xreport.status", "value", "2/3");
                            remainingsize -= DataProcessor.reportEnergyGroups(3, cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, remainingsize, devices);
                            user.uiSet("xreport.status", "value", "3/3");
                            DataProcessor.reportEnergyGroups(4, cost, fromyear, frommonth, fromday, toyear, tomonth, today, period, remainingsize, devices);
                            if (reportsKillSwitch) {
                                user.reportsCancel();
                                reportsKillSwitch = false;
                                reportsStatus = -1;
                            } else {
                                user.uiSet("xreport.status", "value", "ready");
                                reportsStatus = 0;
                            }
                        }
                    };
                    exec.execute(task);
                    return "data:ok";
                }
                if ("charges".equals(sa[2])) {
                    Runnable task = new Runnable(){

                        public void run() {
                            reportsKillSwitch = false;
                            reportsStatus = 1;
                            user.reportsCancel();
                            user.uiSet("xreport.status", "value", "1/1");
                            DataProcessor.reportChargingDevices(fromyear, frommonth, fromday, toyear, tomonth, today, 100000000L, devices);
                            if (reportsKillSwitch) {
                                user.reportsCancel();
                                reportsKillSwitch = false;
                                reportsStatus = -1;
                            } else {
                                user.uiSet("xreport.status", "value", "ready");
                                reportsStatus = 0;
                            }
                        }
                    };
                    exec.execute(task);
                    return "data:ok";
                }
            }
            try {
                if ("cancel".equals(sa[1])) {
                    if (reportsStatus == 1) {
                        reportsKillSwitch = true;
                    } else {
                        user.reportsCancel();
                        reportsKillSwitch = false;
                    }
                    return "data:ok";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "data:error";
    }

    private static void reportsCancel() {
        try {
            File path = new File("reportdata");
            File[] fa = path.listFiles();
            int i2 = 0;
            while (i2 < fa.length) {
                fa[i2].delete();
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        user.uiSet("xreport.status", "value", "idle");
        user.uiSet("xreport.progress", "value", "0");
        user.uiSet("xreport.truncated", "flag", "false");
    }

    public static String dbZip(String userid, String param) throws Exception {
        boolean exit = false;
        if (user.userAdministratorCheck(userid)) {
            try {
                FileOutputStream fos;
                if (param.equals("backup")) {
                    fos = new FileOutputStream(".dbzipbackup");
                    fos.write(66);
                    fos.close();
                    exit = true;
                } else if (param.equals("restore")) {
                    fos = new FileOutputStream(".dbziprestore");
                    fos.write(82);
                    fos.close();
                    exit = true;
                }
                Runnable task = new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.exit(0);
                    }
                };
                if (exit) {
                    exec.execute(task);
                    return "data:ok";
                }
                return "data:error";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "data:error";
    }

    public static String reqAccess(String userid, String param) throws Exception {
        String rights;
        String uid;
        if (param.length() == 0) {
            uid = userid;
        } else if (param.length() > 0 && user.userAdministratorCheck(userid)) {
            uid = param;
        } else {
            return "data:error";
        }
        if (uid.length() > 16) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("select rights from access where userid = ?");
        pstmt.setString(1, uid);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next() && (rights = rs.getString(1)).length() > 0) {
            String usermenu = "";
            String multitype = "";
            String trial = "";
            String greenup = "";
            String modbusgate = "";
            String eqsupport = "";
            try {
                StringBuffer sb = new StringBuffer();
                FileInputStream fis = new FileInputStream("www/text_user.txt");
                Properties p = new Properties();
                p.load(fis);
                fis.close();
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String k2 = (String)e2.nextElement();
                    if (!k2.startsWith("menu")) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append("\"" + k2.substring(4) + "\":\"" + p.getProperty(k2) + "\"");
                }
                if (sb.length() > 0) {
                    usermenu = ",\"usermenu\":{" + sb.toString() + "}";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pstmt.close();
            pstmt = databaseConnection.prepareStatement("select count(*) from sensors where loadid < -1");
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                multitype = ",\"multitype\":\"true\"";
            }
            pstmt.close();
            if (trialCounter != -1) {
                trial = ",\"trialcounter\":" + trialCounter;
            }
            greenup = ",\"greenup\":\"" + greenUpEnabled + "\"";
            if (ModbusGatewaySettings.isRTUEnabled()) {
                modbusgate = ",\"modbusgate\":\"true\"";
            }
            if (VVVV == 10) {
                eqsupport = ",\"eq\":\"false\"";
            }
            return "data:{\"access\":{" + (user.userAdministratorCheck(userid) ? "admin:1," : "admin:0,") + rights + "},\"userid\":\"" + userid + "\"" + multitype + usermenu + trial + greenup + modbusgate + eqsupport + "}";
        }
        pstmt.close();
        return "data:{\"access\":{" + (user.userAdministratorCheck(userid) ? "admin:1," : "admin:0,") + "conf:0,maint:0,data:0,view:0,control:0},\"userid\":\"" + userid + "\"}";
    }

    public static String setAccess(String userid, String param) throws Exception {
        String[] sa = param.split(",", 2);
        if (user.userAdministratorCheck(userid)) {
            String rights = sa[1];
            String uid = sa[0];
            if (uid.length() < 1 || uid.length() > 16 || rights.length() > 256) {
                return "data:error";
            }
            PreparedStatement pstmt = databaseConnection.prepareStatement("select userid from access where userid = ?");
            pstmt.setString(1, uid);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                rs.close();
                pstmt.close();
                pstmt = databaseConnection.prepareStatement("update access set rights = ? where userid = ?");
                pstmt.setString(1, rights);
                pstmt.setString(2, uid);
                pstmt.execute();
            } else {
                rs.close();
                pstmt.close();
                pstmt = databaseConnection.prepareStatement("insert into access values (?, ?)");
                pstmt.setString(1, uid);
                pstmt.setString(2, rights);
                pstmt.execute();
            }
            Polling.checkPoint(false);
            return user.reqAccess(userid, uid);
        }
        return "data:error";
    }

    public static String setTrialCode(String userid, String param) throws Exception {
        if (user.userAdministratorCheck(userid)) {
            return user.trialUnlock(param) ? "data:ok" : "data:error";
        }
        return "data:error";
    }

    private static String reqSystemSettings(String userid) throws Exception {
        StringBuffer sb = new StringBuffer("data:{\"systemsettings\":{language:\"");
        sb.append(user.localeToId().toLowerCase());
        sb.append("\",servername:\"");
        sb.append(URLEncoder.encode(Configuration.publicServerName, "UTF-8").replace('+', ' '));
        sb.append("\",csvdecimalsep:\"");
        sb.append(user.varGet("csvdecimalsep!"));
        sb.append("\",csvfieldsep:\"");
        sb.append(user.varGet("csvfieldsep!"));
        sb.append("\",sampleinterval:\"");
        sb.append(dataConsolidationIntervalMinutes);
        sb.append("\",timeout:\"");
        sb.append(Configuration.keyInactivityMillis / 3600000L);
        sb.append("\"}}");
        return sb.toString();
    }

    private static String reqCurrentLocalTime(String userid) throws Exception {
        StringBuffer sb = new StringBuffer("data:{\"currentlocaltime\":{\"year\":\"");
        Calendar cal = Calendar.getInstance(locale);
        sb.append(cal.get(1));
        sb.append("\",\"month\":\"");
        sb.append(cal.get(2) < 9 ? "0" + (cal.get(2) + 1) : Integer.valueOf(cal.get(2) + 1));
        sb.append("\",\"day\":\"");
        sb.append(cal.get(5) < 10 ? "0" + cal.get(5) : Integer.valueOf(cal.get(5)));
        sb.append("\",\"hours\":\"");
        sb.append(cal.get(11) < 10 ? "0" + cal.get(11) : Integer.valueOf(cal.get(11)));
        sb.append("\",\"minutes\":\"");
        sb.append(cal.get(12) < 10 ? "0" + cal.get(12) : Integer.valueOf(cal.get(12)));
        sb.append("\",\"seconds\":\"");
        sb.append(cal.get(13) < 10 ? "0" + cal.get(13) : Integer.valueOf(cal.get(13)));
        sb.append("\",\"dst\":\"");
        sb.append(TimeZone.getDefault().inDaylightTime(cal.getTime()) ? "on" : "off");
        sb.append("\",\"zone\":\"");
        sb.append(ZONES.indexOf(TimeZone.getDefault()));
        sb.append("\",\"auto\":\"");
        sb.append(autoTimeUpdate ? "on" : "off");
        sb.append("\",\"server\":\"");
        if (autoTimeServer != null && autoTimeServer.length() > 0) {
            sb.append(URLEncoder.encode(autoTimeServer, "UTF-8").replace('+', ' '));
        }
        sb.append("\"}}");
        return sb.toString();
    }

    private static String setSystemSettings(String userid, String param) throws Exception {
        if (user.userAdministratorCheck(userid)) {
            String[] sa = param.split(",");
            if (sa.length == 6 || sa.length == 7) {
                try {
                    if (Integer.parseInt(sa[2]) <= 0 || sa[1].length() < 1) {
                        throw new Exception();
                    }
                    String servername = URLDecoder.decode(sa[1], "UTF-8");
                    int i2 = 0;
                    while (i2 < servername.length()) {
                        char c2 = servername.charAt(i2);
                        if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-')) {
                            throw new Exception();
                        }
                        ++i2;
                    }
                    if (sa[0].equalsIgnoreCase("en")) {
                        locale = new Locale("en", "GB");
                    } else if (sa[0].equalsIgnoreCase("fr")) {
                        locale = new Locale("fr", "FR");
                    } else if (sa[0].equalsIgnoreCase("it")) {
                        locale = new Locale("it", "IT");
                    } else if (sa[0].equalsIgnoreCase("bf")) {
                        locale = new Locale("fr", "BE");
                    } else if (sa[0].equalsIgnoreCase("bn")) {
                        locale = new Locale("nl", "BE");
                    } else if (sa[0].equalsIgnoreCase("nl")) {
                        locale = new Locale("nl", "NL");
                    } else if (sa[0].equalsIgnoreCase("es")) {
                        locale = new Locale("es", "ES");
                    } else if (sa[0].equalsIgnoreCase("cn")) {
                        locale = new Locale("zh", "CN");
                    } else if (sa[0].equalsIgnoreCase("pt")) {
                        locale = new Locale("pt", "PT");
                    } else if (sa[0].equalsIgnoreCase("gr")) {
                        locale = new Locale("el", "GR");
                    } else if (sa[0].equalsIgnoreCase("pl")) {
                        locale = new Locale("pl", "PL");
                    } else if (sa[0].equalsIgnoreCase("ru")) {
                        locale = new Locale("ru", "RU");
                    } else {
                        throw new Exception();
                    }
                    user.saveLocale();
                    Reports.init();
                    Alarms.init();
                    if (sa[3].equals("point")) {
                        csvDecimalSep = (char)46;
                        user.varSet("csvdecimalsep!", "point");
                    } else if (sa[3].equals("comma")) {
                        csvDecimalSep = (char)44;
                        user.varSet("csvdecimalsep!", "comma");
                    } else {
                        throw new Exception();
                    }
                    if (sa[4].equals("semicolon")) {
                        csvFieldSep = (char)59;
                        user.varSet("csvfieldsep!", "semicolon");
                        user.uiSet("(datalogger)", "csvseparator", Character.toString(csvFieldSep));
                    } else if (sa[4].equals("comma")) {
                        csvFieldSep = (char)44;
                        user.varSet("csvfieldsep!", "comma");
                        user.uiSet("(datalogger)", "csvseparator", Character.toString(csvFieldSep));
                    } else {
                        throw new Exception();
                    }
                    if (sa[5].equals("10")) {
                        dataConsolidationIntervalMinutes = 10;
                        user.varSet("dataconsolidationintervalminutes!", "10");
                    } else if (sa[5].equals("15")) {
                        dataConsolidationIntervalMinutes = 15;
                        user.varSet("dataconsolidationintervalminutes!", "15");
                    } else {
                        throw new Exception();
                    }
                    if (sa.length == 7 && !user.setSysPwd("wsmeasure", URLDecoder.decode(sa[6], "UTF-8"))) {
                        throw new Exception();
                    }
                    Properties ini = new Properties();
                    FileInputStream inifis = new FileInputStream("hsyco.ini");
                    ini.load(inifis);
                    inifis.close();
                    if (!sa[1].equals(ini.getProperty("ServerName")) || !sa[2].equals(ini.getProperty("KeysInactivityHours"))) {
                        ini.put("ServerName", sa[1]);
                        ini.put("KeysInactivityHours", sa[2]);
                        user.safePropertiesStore(ini, "hsyco.ini");
                    }
                    user.hsycoCheckPoint();
                    return user.reqSystemSettings(userid);
                }
                catch (Exception e2) {
                    return "data:error";
                }
            }
            return "data:error";
        }
        return null;
    }

    private static String reqTimeZones(String userid) throws Exception {
        StringBuffer sb = new StringBuffer("data:{\"timezones\":{");
        if (user.userAdministratorCheck(userid)) {
            int i2 = 0;
            while (i2 < ZONES.size()) {
                TimeZone tz = ZONES.elementAt(i2);
                sb.append(i2 == 0 ? "\"" : ",\"");
                sb.append(i2);
                sb.append("\":[\"");
                sb.append(URLEncoder.encode(tz.getID(), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(tz.getRawOffset() / 3600000);
                sb.append("\"]");
                ++i2;
            }
            sb.append("}}");
            return sb.toString();
        }
        return "data:error";
    }

    private static String setTime(String userid, String param) throws Exception {
        if (user.userAdministratorCheck(userid)) {
            String[] sa = param.split(",");
            if (sa.length == 1) {
                if (user.execTimeZone(Integer.parseInt(sa[0]))) {
                    user.varSet("networktimeupdate!", "true");
                    autoTimeUpdate = true;
                    user.execNtpdate();
                    return user.reqCurrentLocalTime(userid);
                }
                return "data:error";
            }
            if (sa.length == 2) {
                if (user.execTimeZone(Integer.parseInt(sa[0]))) {
                    autoTimeUpdate = true;
                    autoTimeServer = URLDecoder.decode(sa[1], "UTF-8").trim().toLowerCase();
                    user.varSet("networktimeupdate!", "true");
                    user.varSet("networktimeserver!", autoTimeServer);
                    user.execNtpdate();
                    return user.reqCurrentLocalTime(userid);
                }
                return "data:error";
            }
            if (sa.length == 6) {
                if (user.execTimeZone(Integer.parseInt(sa[0])) && user.execDate(Integer.parseInt(sa[1]), Integer.parseInt(sa[2]), Integer.parseInt(sa[3]), Integer.parseInt(sa[4]), Integer.parseInt(sa[5]))) {
                    user.varSet("networktimeupdate!", "false");
                    autoTimeUpdate = false;
                    return user.reqCurrentLocalTime(userid);
                }
                return "data:error";
            }
            return "data:error";
        }
        return null;
    }

    public static String reqRacks(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = user.selectAllRacks();
            if (result == null) {
                return "data:error";
            }
            if (result.length() == 0) {
                return "data:empty";
            }
            return "data:{\"racks\":{" + result + "}}";
        }
        return "data:noaccess";
    }

    public static String newRack(String userid, String param) throws Exception {
        String[] sa = param.split(",", 2);
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String name = URLDecoder.decode(sa[0], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("insert into racks (name, description, enabled) values (?, ?, true)", 1);
        pstmt.setString(1, name);
        pstmt.setString(2, URLDecoder.decode(sa[1], "UTF-8"));
        pstmt.execute();
        ResultSet rs = pstmt.getGeneratedKeys();
        if (rs.next()) {
            String id = rs.getString(1);
            rs.close();
            Polling.checkPoint(false);
            return "data:{\"newid\":\"" + id + "\",\"racks\":{" + user.selectAllRacks() + "}}";
        }
        return "data:error";
    }

    public static String editRack(String userid, String param) throws Exception {
        String[] sa = param.split(",", 3);
        if (sa.length != 3) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String name = URLDecoder.decode(sa[1], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("update racks set name = ?, description = ? where rackid = ?");
        pstmt.setString(1, name);
        pstmt.setString(2, URLDecoder.decode(sa[2], "UTF-8"));
        pstmt.setInt(3, Integer.parseInt(sa[0]));
        pstmt.execute();
        Polling.checkPoint(false);
        String result = user.selectAllRacks();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"racks\":{" + result + "}}";
    }

    public static String commandRack(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        if (sa[1].equals("disable")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update racks set enabled = false where rackid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else if (sa[1].equals("enable")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update racks set enabled = true where rackid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else if (sa[1].equals("purge")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("delete from racks where rackid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else {
            return "data:error";
        }
        String result = user.selectAllRacks();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"racks\":{" + result + "}}";
    }

    private static String selectAllRacks() {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select rackid, name, description, enabled from racks");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(rs.getString(1));
                sb.append("\":[\"");
                sb.append(URLEncoder.encode(rs.getString(2), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(3), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(rs.getBoolean(4) ? "enabled\"]" : "disabled\"]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String reqLoads(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = user.selectAllLoads();
            if (result == null) {
                return "data:error";
            }
            if (result.length() == 0) {
                return "data:empty";
            }
            return "data:{\"loads\":{" + result + "}}";
        }
        return "data:noaccess";
    }

    public static String newLoad(String userid, String param) throws Exception {
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String name = URLDecoder.decode(param, "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("insert into loads (name, locked, enabled) values (?, false, true)", 1);
        pstmt.setString(1, name);
        pstmt.execute();
        ResultSet rs = pstmt.getGeneratedKeys();
        if (rs.next()) {
            String id = rs.getString(1);
            rs.close();
            Polling.checkPoint(false);
            return "data:{\"newid\":\"" + id + "\",\"loads\":{" + user.selectAllLoads() + "}}";
        }
        return "data:error";
    }

    public static String editLoad(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String name = URLDecoder.decode(sa[1], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("update loads set name = ? where loadid = ? and locked = false");
        pstmt.setString(1, name);
        pstmt.setInt(2, Integer.parseInt(sa[0]));
        pstmt.execute();
        Polling.checkPoint(false);
        String result = user.selectAllLoads();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"loads\":{" + result + "}}";
    }

    public static String commandLoad(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        if (sa[1].equals("disable")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update loads set enabled = false where loadid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else if (sa[1].equals("enable")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update loads set enabled = true where loadid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else if (sa[1].equals("purge")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("delete from loads where loadid = ? and locked = false");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else {
            return "data:error";
        }
        String result = user.selectAllLoads();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"loads\":{" + result + "}}";
    }

    private static String selectAllLoads() {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select loadid, name, locked, enabled from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(rs.getString(1));
                sb.append("\":[\"");
                sb.append(URLEncoder.encode(rs.getString(2), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                if (rs.getBoolean(4)) {
                    if (rs.getBoolean(3)) {
                        sb.append("locked\"]");
                        continue;
                    }
                    sb.append("enabled\"]");
                    continue;
                }
                sb.append("disabled\"]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String reqGroups(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = user.selectAllGroups();
            if (result == null) {
                return "data:error";
            }
            if (result.length() == 0) {
                return "data:empty";
            }
            return "data:{\"groups\":{" + result + "}}";
        }
        return "data:noaccess";
    }

    public static String newGroup(String userid, String param) throws Exception {
        String[] sa = param.split(",", 2);
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String name = URLDecoder.decode(sa[0], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("insert into groups (name, description, enabled) values (?, ?, true)", 1);
        pstmt.setString(1, name);
        pstmt.setString(2, URLDecoder.decode(sa[1], "UTF-8"));
        pstmt.execute();
        ResultSet rs = pstmt.getGeneratedKeys();
        if (rs.next()) {
            String id = rs.getString(1);
            rs.close();
            Polling.checkPoint(false);
            return "data:{\"newid\":\"" + id + "\",\"groups\":{" + user.selectAllGroups() + "}}";
        }
        return "data:error";
    }

    public static String editGroup(String userid, String param) throws Exception {
        String[] sa = param.split(",", 3);
        if (sa.length != 3) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String name = URLDecoder.decode(sa[1], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("update groups set name = ?, description = ? where groupid = ?");
        pstmt.setString(1, name);
        pstmt.setString(2, URLDecoder.decode(sa[2], "UTF-8"));
        pstmt.setInt(3, Integer.parseInt(sa[0]));
        pstmt.execute();
        Polling.checkPoint(false);
        String result = user.selectAllGroups();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"groups\":{" + result + "}}";
    }

    public static String commandGroup(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        if (sa[1].equals("disable")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update groups set enabled = false where groupid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else if (sa[1].equals("enable")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update groups set enabled = true where groupid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else if (sa[1].equals("purge")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("delete from groups where groupid = ?");
            pstmt.setInt(1, Integer.parseInt(sa[0]));
            pstmt.execute();
        } else {
            return "data:error";
        }
        String result = user.selectAllGroups();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"groups\":{" + result + "}}";
    }

    private static String selectAllGroups() {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select groupid, name, description, enabled from groups");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(rs.getString(1));
                sb.append("\":[\"");
                sb.append(URLEncoder.encode(rs.getString(2), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(3), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(rs.getBoolean(4) ? "enabled\"]" : "disabled\"]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String reqRates(String userid, String param) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String electricityRates = user.selectAllRates(2);
            String waterRates = user.selectAllRates(3);
            String gasRates = user.selectAllRates(4);
            if (electricityRates == null || waterRates == null || gasRates == null) {
                return "data:error";
            }
            return "data:{\"rates\":{\"electricity\":[" + electricityRates + "]," + "\"water\":[" + waterRates + "]," + "\"gas\":[" + gasRates + "]}}";
        }
        return "data:noaccess";
    }

    public static String editRate(String userid, String param) throws Exception {
        int type;
        int[] cost = new int[5];
        int[] validity = new int[5];
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String[] sa = param.split(",", 14);
        if (sa.length != 14) {
            return "data:error";
        }
        if (sa[0].equals("electricity")) {
            type = 2;
        } else if (sa[0].equals("water")) {
            type = 3;
        } else if (sa[0].equals("gas")) {
            type = 4;
        } else {
            return "data:error";
        }
        int id = Integer.parseInt(sa[1]);
        if (id < 0 || id > 4) {
            return "data:error";
        }
        id = type * 10 + id;
        String name = URLDecoder.decode(sa[2], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        int color = Integer.parseInt(sa[3]);
        if (color < 0 || color > 7) {
            return "data:error";
        }
        int i2 = 0;
        while (i2 < 5) {
            int c2 = Integer.parseInt(sa[4 + i2]);
            if (c2 < -1) {
                return "data:error";
            }
            int v = Integer.parseInt(sa[9 + i2]);
            if (v != -1 && !user.isYMD(v)) {
                return "data:error";
            }
            if (i2 == 0) {
                validity[0] = v;
                cost[0] = c2;
            } else {
                int j2 = 0;
                while (j2 < i2) {
                    if (v > validity[j2]) {
                        int k2 = i2;
                        while (k2 > j2) {
                            validity[k2] = validity[k2 - 1];
                            cost[k2] = cost[k2 - 1];
                            --k2;
                        }
                        validity[j2] = v;
                        cost[j2] = c2;
                        break;
                    }
                    ++j2;
                }
                if (j2 == i2) {
                    validity[i2] = v;
                    cost[i2] = c2;
                }
            }
            ++i2;
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("update rates set name = ?, color = ?, cost1 = ?, validity1 = ?, cost2 = ?, validity2 = ?, cost3 = ?, validity3 = ?, cost4 = ?, validity4 = ?, cost5 = ?, validity5 = ? where rateid = ?");
        pstmt.setInt(13, id);
        pstmt.setString(1, name);
        pstmt.setInt(2, color);
        i2 = 0;
        while (i2 < 5) {
            pstmt.setInt(3 + 2 * i2, cost[i2]);
            pstmt.setInt(4 + 2 * i2, validity[i2]);
            ++i2;
        }
        pstmt.execute();
        CostRates.loadRates();
        String electricityRates = user.selectAllRates(2);
        String waterRates = user.selectAllRates(3);
        String gasRates = user.selectAllRates(4);
        if (electricityRates == null || waterRates == null || gasRates == null) {
            return "data:error";
        }
        return "data:{\"rates\":{\"electricity\":[" + electricityRates + "]," + "\"water\":[" + waterRates + "]," + "\"gas\":[" + gasRates + "]}}";
    }

    private static String selectAllRates(int type) {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select rateid, name, color, cost1, validity1, cost2, validity2, cost3, validity3, cost4, validity4, cost5, validity5 from rates where rateid >= ? and rateid <= ? order by rateid");
            pstmt.setInt(1, type *= 10);
            pstmt.setInt(2, type + 4);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("[\"");
                sb.append(URLEncoder.encode(rs.getString(2), "UTF-8").replace('+', ' '));
                sb.append("\",");
                sb.append(rs.getString(3));
                sb.append(",[");
                sb.append(rs.getString(4));
                int i2 = 0;
                while (i2 < 4) {
                    sb.append(',');
                    sb.append(rs.getString(6 + 2 * i2));
                    ++i2;
                }
                sb.append("],[");
                sb.append(rs.getString(5));
                i2 = 0;
                while (i2 < 4) {
                    sb.append(',');
                    sb.append(rs.getString(7 + 2 * i2));
                    ++i2;
                }
                sb.append("]]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String reqGateways(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = user.selectAllGateways();
            if (result == null) {
                return "data:error";
            }
            if (result.length() == 0) {
                return "data:empty";
            }
            return "data:{\"gateways\":{" + result + "}}";
        }
        return "data:noaccess";
    }

    public static String newGateway(String userid, String param) throws Exception {
        String[] sa = param.split(",", 6);
        if (sa.length != 6) {
            return "data:error";
        }
        if (userid != null && !user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String address = user.isValidIpV4Address(URLDecoder.decode(sa[0], "UTF-8"));
        if (address == null) {
            return "data:error/ip";
        }
        switch (user.checkGatewaysLimits(address, -1, !sa[5].equals("-1"))) {
            case -1: 
            case 2: {
                return "data:error";
            }
            case 1: {
                return "data:error/license";
            }
        }
        String name = URLDecoder.decode(sa[1], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("insert into gateways (address, name, description, enabled, rackid, eqsensorid, error) values (?, ?, ?, ?, ?, ?, 0)", 1);
        pstmt.setString(1, address);
        pstmt.setString(2, name);
        pstmt.setString(3, URLDecoder.decode(sa[2], "UTF-8"));
        pstmt.setBoolean(4, sa[3].equalsIgnoreCase("on"));
        int rackid = Integer.parseInt(sa[4]);
        pstmt.setInt(5, rackid);
        int eqsensorid = Integer.parseInt(sa[5]);
        pstmt.setInt(6, eqsensorid);
        pstmt.execute();
        ResultSet rs = pstmt.getGeneratedKeys();
        if (rs.next()) {
            String id = rs.getString(1);
            rs.close();
            Polling.checkPoint(false);
            Polling.gatewayStart(Integer.parseInt(id), name, address, rackid, eqsensorid, sa[3].equalsIgnoreCase("on"));
            return "data:{\"newid\":\"" + id + "\",\"gateways\":{" + user.selectAllGateways() + "}}";
        }
        return "data:error";
    }

    public static String editGateway(String userid, String param) throws Exception {
        PreparedStatement pstmt;
        String[] sa = param.split(",", 6);
        if (sa.length != 6) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String address = user.isValidIpV4Address(URLDecoder.decode(sa[1], "UTF-8"));
        if (address == null) {
            return "data:error/ip";
        }
        int id = Integer.parseInt(sa[0]);
        switch (user.checkGatewaysLimits(address, id, !sa[5].equals("-1"))) {
            case -1: 
            case 2: {
                return "data:error";
            }
            case 1: {
                return "data:error/license";
            }
        }
        String name = URLDecoder.decode(sa[2], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        if (ModbusGatewaySettings.isRTUEnabled()) {
            pstmt = databaseConnection.prepareStatement("select address from gateways where gatewayid = ?");
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && rs.getString(1).equals("127.0.0.1") && !address.equals("127.0.0.1")) {
                rs.close();
                return "data:error";
            }
            rs.close();
        }
        pstmt = databaseConnection.prepareStatement("update gateways set address = ?, name = ?, description = ?, rackid = ?, eqsensorid = ? where gatewayid = ?");
        pstmt.setString(1, address);
        pstmt.setString(2, name);
        pstmt.setString(3, URLDecoder.decode(sa[3], "UTF-8"));
        int rackid = Integer.parseInt(sa[4]);
        pstmt.setInt(4, rackid);
        int eqsensorid = Integer.parseInt(sa[5]);
        pstmt.setInt(5, eqsensorid);
        pstmt.setInt(6, id);
        pstmt.execute();
        Polling.checkPoint(false);
        Polling.gatewayStart(id, name, address, rackid, eqsensorid, Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).enabled);
        String result = user.selectAllGateways();
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"gateways\":{" + result + "}}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String commandGateway(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        if (sa[1].equals("off")) {
            PreparedStatement pstmt = databaseConnection.prepareStatement("update gateways set enabled = false where gatewayid = ?");
            int id = Integer.parseInt(sa[0]);
            pstmt.setInt(1, id);
            pstmt.execute();
            Polling.gatewayStop(id);
        } else if (sa[1].equals("on")) {
            if (trialCounter == 0) return "data:error";
            PreparedStatement pstmt = databaseConnection.prepareStatement("update gateways set enabled = true where gatewayid = ?");
            int id = Integer.parseInt(sa[0]);
            pstmt.setInt(1, id);
            pstmt.execute();
            Polling.gatewayStart(id);
        } else {
            if (!sa[1].equals("purge")) return "data:error";
            PreparedStatement pstmt = databaseConnection.prepareStatement("select count(*) from sensors where gatewayid = ?");
            int id = Integer.parseInt(sa[0]);
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return "data:error";
            if (rs.getInt(1) == 0) {
                rs.close();
                if (ModbusGatewaySettings.isRTUEnabled()) {
                    pstmt = databaseConnection.prepareStatement("select address from gateways where gatewayid = ?");
                    pstmt.setInt(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next() && rs.getString(1).equals("127.0.0.1")) {
                        rs.close();
                        return "data:error";
                    }
                    rs.close();
                }
                pstmt = databaseConnection.prepareStatement("delete from gateways where gatewayid = ?");
                pstmt.setInt(1, id);
                pstmt.execute();
                Polling.gatewayDelete(id);
            } else {
                rs.close();
                return "data:notempty";
            }
        }
        String result = user.selectAllGateways();
        if (result == null) {
            return "data:error";
        }
        if (result.length() != 0) return "data:{\"gateways\":{" + result + "}}";
        return "data:empty";
    }

    public static String testGateway(String userid, String param) throws Exception {
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        try {
            Socket gwsock = new Socket();
            param = user.isValidIpV4Address(URLDecoder.decode(param, "UTF-8"));
            String[] aa = param.split("[:]");
            if (aa.length == 1) {
                gwsock.connect(new InetSocketAddress(param, 502), 3000);
            } else {
                gwsock.connect(new InetSocketAddress(aa[0], Integer.parseInt(aa[1])), 3000);
            }
            if (gwsock.isBound()) {
                gwsock.close();
                return "data:{\"test\":{\"status\":\"ok\"}}";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "data:{\"test\":{\"status\":\"error\"}}";
    }

    public static String selectAllGateways() {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select gatewayid, address, name, description, enabled, eqsensorid, rackid, error from gateways");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(rs.getString(1));
                sb.append("\":[\"");
                sb.append(URLEncoder.encode(rs.getString(2), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(3), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(4), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(rs.getBoolean(5) ? "on" : "off");
                sb.append("\",\"");
                sb.append(rs.getString(6));
                sb.append("\",\"");
                sb.append(rs.getString(7));
                sb.append("\",\"");
                switch (rs.getInt(8)) {
                    case 1: {
                        sb.append("offline\"]");
                        break;
                    }
                    case 2: {
                        sb.append("errors\"]");
                        break;
                    }
                    default: {
                        sb.append("online\"]");
                    }
                }
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static void disableAllGateways() {
        Vector<Integer> gateways = new Vector<Integer>();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select gatewayid from gateways where enabled = true");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                gateways.add(rs.getInt(1));
            }
            rs.close();
            pstmt = databaseConnection.prepareStatement("update gateways set enabled = false");
            pstmt.execute();
            int i2 = 0;
            while (i2 < gateways.size()) {
                Polling.gatewayStop((Integer)gateways.elementAt(i2));
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String reqLinks(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = EMS.selectAllLinks();
            if (result == null) {
                return "data:error";
            }
            if (result.length() == 0) {
                return "data:empty";
            }
            return "data:{\"links\":" + result + "}";
        }
        return "data:noaccess";
    }

    public static String reqSensors(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = user.selectAllSensors();
            if (result == null) {
                return "data:error";
            }
            if (result.length() == 0) {
                return "data:empty";
            }
            return "data:{\"sensors\":{" + result + "}}";
        }
        return "data:noaccess";
    }

    public static String newSensor(String userid, String param) throws Exception {
        int interfaceaddress;
        int address;
        String[] sa = param.split(",", 15);
        if (sa.length != 15) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String[] a2 = sa[0].split("[-]");
        if (a2.length == 2) {
            address = Integer.parseInt(a2[0]);
            interfaceaddress = Integer.parseInt(a2[1]);
        } else {
            address = Integer.parseInt(a2[0]);
            interfaceaddress = 0;
        }
        String subaddress = sa[1].equals("null") ? "" : URLDecoder.decode(sa[1], "UTF-8");
        int gatewayid = Integer.parseInt(sa[3]);
        int modelid = Integer.parseInt(sa[5]);
        String gatewayaddress = Polling.gatewayCache.get((Object)Integer.valueOf((int)gatewayid)).address;
        if (gatewayid < 0 || modelid < 0 || address < 1 || address > 247 || sa[1].length() < 1) {
            return "data:error";
        }
        switch (user.checkSensorsLimits(gatewayid, address, subaddress, -1)) {
            case -1: {
                return "data:error";
            }
            case 2: {
                break;
            }
            case 1: {
                return "data:error/license";
            }
        }
        String name = URLDecoder.decode(sa[2], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        switch (Models.elementAt(modelid)[15].length() > 0 ? Integer.parseInt(Models.elementAt(modelid)[15]) : modelid) {
            case 141: 
            case 145: {
                IME.setProtocolTypeCExDF(gatewayaddress, address);
            }
        }
        PreparedStatement pstmt = databaseConnection.prepareStatement("insert into sensors (address, interfaceaddress, subaddress, scale, unit, name, gatewayid, enabled, modelid, loadid, group1id, group2id, group3id, group4id, group5id, qualityerror, qualitymessage, error, nototals, noalerts, priority, description) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, '', 0, ?, ?, false, ?)", 1);
        pstmt.setInt(1, address);
        pstmt.setInt(2, interfaceaddress);
        pstmt.setString(3, subaddress);
        pstmt.setDouble(4, 1.0);
        pstmt.setString(5, "");
        pstmt.setString(6, name);
        pstmt.setInt(7, gatewayid);
        pstmt.setBoolean(8, sa[4].equalsIgnoreCase("on"));
        pstmt.setInt(9, modelid);
        pstmt.setInt(10, Integer.parseInt(sa[6]));
        pstmt.setInt(11, Integer.parseInt(sa[7]));
        pstmt.setInt(12, Integer.parseInt(sa[8]));
        pstmt.setInt(13, Integer.parseInt(sa[9]));
        pstmt.setInt(14, Integer.parseInt(sa[10]));
        pstmt.setInt(15, Integer.parseInt(sa[11]));
        pstmt.setBoolean(16, sa[12].equalsIgnoreCase("true"));
        pstmt.setBoolean(17, sa[13].equalsIgnoreCase("true"));
        pstmt.setString(18, URLDecoder.decode(sa[14], "UTF-8"));
        pstmt.execute();
        ResultSet rs = pstmt.getGeneratedKeys();
        if (rs.next()) {
            int sensorid = rs.getInt(1);
            rs.close();
            Polling.checkPoint(false);
            Polling.gatewaySensorsUpdate(gatewayid);
            EMS.discoveryReset(gatewayaddress, address);
            Alarms.cacheReset(gatewayaddress, address);
            return "data:{\"sensor\":{" + user.selectSensor(sensorid) + "}}";
        }
        return "data:error";
    }

    public static String editSensor(String userid, String param) throws Exception {
        int interfaceaddress;
        int address;
        String[] sa = param.split(",", 14);
        if (sa.length != 14) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        int sensorid = Integer.parseInt(sa[0]);
        PreparedStatement pstmt = databaseConnection.prepareStatement("select gatewayid from sensors where sensorid = ?");
        pstmt.setInt(1, sensorid);
        ResultSet rs = pstmt.executeQuery();
        if (!rs.next()) {
            return "data:error";
        }
        int gatewayid = Integer.parseInt(rs.getString(1));
        String gatewayaddress = Polling.gatewayCache.get((Object)Integer.valueOf((int)gatewayid)).address;
        String[] a2 = sa[1].split("[-]");
        if (a2.length == 2) {
            address = Integer.parseInt(a2[0]);
            interfaceaddress = Integer.parseInt(a2[1]);
        } else {
            address = Integer.parseInt(a2[0]);
            interfaceaddress = 0;
        }
        String subaddress = sa[2].equals("null") ? "" : URLDecoder.decode(sa[2], "UTF-8");
        int modelid = Integer.parseInt(sa[4]);
        if (gatewayid < 0 || modelid < 0 || address < 1 || address > 247 || sa[2].length() < 1) {
            return "data:error";
        }
        switch (user.checkSensorsLimits(gatewayid, address, subaddress, sensorid)) {
            case -1: {
                return "data:error";
            }
            case 2: {
                break;
            }
            case 1: {
                return "data:error/license";
            }
        }
        String name = URLDecoder.decode(sa[3], "UTF-8");
        if (name.length() <= 0) {
            return "data:error";
        }
        switch (Models.elementAt(modelid)[15].length() > 0 ? Integer.parseInt(Models.elementAt(modelid)[15]) : modelid) {
            case 141: 
            case 145: {
                IME.setProtocolTypeCExDF(gatewayaddress, address);
            }
        }
        pstmt = databaseConnection.prepareStatement("update sensors set address = ?, interfaceaddress = ?, subaddress = ?, scale = 1.0, unit = '', name = ?, modelid = ?, loadid = ?, group1id = ?, group2id = ?, group3id = ?, group4id = ?, group5id = ?, nototals = ?, noalerts = ?, description = ? where sensorid = ?");
        pstmt.setInt(1, address);
        pstmt.setInt(2, interfaceaddress);
        pstmt.setString(3, subaddress);
        pstmt.setString(4, name);
        pstmt.setInt(5, modelid);
        pstmt.setInt(6, Integer.parseInt(sa[5]));
        pstmt.setInt(7, Integer.parseInt(sa[6]));
        pstmt.setInt(8, Integer.parseInt(sa[7]));
        pstmt.setInt(9, Integer.parseInt(sa[8]));
        pstmt.setInt(10, Integer.parseInt(sa[9]));
        pstmt.setInt(11, Integer.parseInt(sa[10]));
        pstmt.setBoolean(12, sa[11].equalsIgnoreCase("true"));
        pstmt.setBoolean(13, sa[12].equalsIgnoreCase("true"));
        pstmt.setString(14, URLDecoder.decode(sa[13], "UTF-8"));
        pstmt.setInt(15, sensorid);
        pstmt.execute();
        Polling.checkPoint(false);
        Polling.gatewaySensorsUpdate(gatewayid);
        EMS.discoveryReset(gatewayaddress, address);
        Alarms.cacheReset(gatewayaddress, address);
        String result = user.selectSensor(sensorid);
        if (result == null) {
            return "data:error";
        }
        if (result.length() == 0) {
            return "data:empty";
        }
        return "data:{\"sensor\":{" + result + "}}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String commandSensor(String userid, String param) throws Exception {
        String result;
        block46: {
            boolean on;
            int numberOfSteps;
            int sensorid;
            String[] sa;
            block54: {
                block53: {
                    block52: {
                        block51: {
                            block50: {
                                int gatewayid;
                                PreparedStatement pstmt;
                                block49: {
                                    block48: {
                                        block47: {
                                            block45: {
                                                sa = param.split(",");
                                                if (sa.length < 2) {
                                                    return "data:error";
                                                }
                                                sensorid = Integer.parseInt(sa[0]);
                                                pstmt = databaseConnection.prepareStatement("select gatewayid from sensors where sensorid = ?");
                                                pstmt.setInt(1, sensorid);
                                                ResultSet rs = pstmt.executeQuery();
                                                if (!rs.next()) return "data:error";
                                                gatewayid = Integer.parseInt(rs.getString(1));
                                                if (!sa[1].equals("off")) break block45;
                                                if (!user.checkUserRights(userid, "conf")) {
                                                    return "data:noaccess";
                                                }
                                                pstmt = databaseConnection.prepareStatement("update sensors set enabled = false where sensorid = ?");
                                                pstmt.setInt(1, sensorid);
                                                pstmt.execute();
                                                Polling.gatewaySensorsUpdate(gatewayid);
                                                result = user.selectSensor(sensorid);
                                                break block46;
                                            }
                                            if (!sa[1].equals("on")) break block47;
                                            if (!user.checkUserRights(userid, "conf")) {
                                                return "data:noaccess";
                                            }
                                            pstmt = databaseConnection.prepareStatement("update sensors set enabled = true where sensorid = ?");
                                            pstmt.setInt(1, sensorid);
                                            pstmt.execute();
                                            Polling.gatewaySensorsUpdate(gatewayid);
                                            result = user.selectSensor(sensorid);
                                            break block46;
                                        }
                                        if (!sa[1].equals("purge")) break block48;
                                        if (!user.checkUserRights(userid, "conf")) {
                                            return "data:noaccess";
                                        }
                                        pstmt = databaseConnection.prepareStatement("delete from sensors where sensorid = ?");
                                        pstmt.setInt(1, sensorid);
                                        pstmt.execute();
                                        Polling.sensorCache.remove(sensorid);
                                        Polling.gatewaySensorsUpdate(gatewayid);
                                        result = user.selectSensor(sensorid);
                                        break block46;
                                    }
                                    if (!sa[1].equals("gnormal")) break block49;
                                    if (!user.checkUserRights(userid, "conf")) {
                                        return "data:noaccess";
                                    }
                                    ChargeController.chargeCache.get(sensorid).setPriority(false);
                                    Polling.sensorCache.get((Object)Integer.valueOf((int)sensorid)).priority = false;
                                    pstmt = databaseConnection.prepareStatement("update sensors set priority = false where sensorid = ?");
                                    pstmt.setInt(1, sensorid);
                                    pstmt.execute();
                                    Polling.gatewaySensorsUpdate(gatewayid);
                                    result = user.selectSensor(sensorid);
                                    break block46;
                                }
                                if (!sa[1].equals("gpriority")) break block50;
                                if (!user.checkUserRights(userid, "conf")) {
                                    return "data:noaccess";
                                }
                                ChargeController.chargeCache.get(sensorid).setPriority(true);
                                Polling.sensorCache.get((Object)Integer.valueOf((int)sensorid)).priority = true;
                                pstmt = databaseConnection.prepareStatement("update sensors set priority = true where sensorid = ?");
                                pstmt.setInt(1, sensorid);
                                pstmt.execute();
                                Polling.gatewaySensorsUpdate(gatewayid);
                                result = user.selectSensor(sensorid);
                                break block46;
                            }
                            if (!sa[1].equals("breakeropen")) break block51;
                            if (!user.checkUserRights(userid, "control")) {
                                return "data:noaccess";
                            }
                            StringBuffer sb = new StringBuffer();
                            sb.append("\"breaker\":{");
                            user.displayHash(sb, EMS.commandBreaker(Polling.sensorCache.get(sensorid), true));
                            sb.append('}');
                            result = sb.toString();
                            break block46;
                        }
                        if (!sa[1].equals("breakerclose")) break block52;
                        if (!user.checkUserRights(userid, "control")) {
                            return "data:noaccess";
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append("\"breaker\":{");
                        user.displayHash(sb, EMS.commandBreaker(Polling.sensorCache.get(sensorid), false));
                        sb.append('}');
                        result = sb.toString();
                        break block46;
                    }
                    if (!sa[1].equals("contactor")) break block53;
                    if (!user.checkUserRights(userid, "control")) {
                        return "data:noaccess";
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("\"contactor\":{");
                    user.displayHash(sb, EMS.commandContactor(Polling.sensorCache.get(sensorid)));
                    sb.append('}');
                    result = sb.toString();
                    break block46;
                }
                if (!sa[1].startsWith("output")) break block54;
                if (!user.checkUserRights(userid, "control")) {
                    return "data:noaccess";
                }
                SensorCache sensor = Polling.sensorCache.get(sensorid);
                switch (sensor.modelid) {
                    case 62: {
                        int address = Integer.parseInt(sa[1].substring(6));
                        if (address != 1) {
                            if (address != 2) return "data:error";
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append("\"generic\":{");
                        user.displayHash(sb, EMS.commandGeneric(sensor, address));
                        sb.append('}');
                        result = sb.toString();
                        break block46;
                    }
                    case 90: 
                    case 91: {
                        int address = Integer.parseInt(sa[1].substring(6));
                        if (address < 1) return "data:error";
                        if (address > 6) return "data:error";
                        if (sa.length == 3) {
                            if (!sa[2].equals("flip")) return "data:error";
                            if (!M7TIC.commandOutput(sensor, address)) return "data:error";
                            return "data:ok";
                        }
                        if (sa.length != 5) return "data:error";
                        if (!M7TIC.commandOutputConfiguration(sensor, address, sa[2].equals("nc"), sa[3].equals("blink"), Integer.parseInt(sa[4]))) return "data:error";
                        return "data:ok";
                    }
                    default: {
                        return "data:error";
                    }
                }
            }
            if (sa[1].startsWith("input")) {
                if (!user.checkUserRights(userid, "control")) {
                    return "data:noaccess";
                }
                SensorCache sensor = Polling.sensorCache.get(sensorid);
                switch (sensor.modelid) {
                    case 90: {
                        int address = Integer.parseInt(sa[1].substring(5));
                        if (address < 1) return "data:error";
                        if (address > 24) return "data:error";
                        if (sa.length != 3) return "data:error";
                        if (sa[2].equals("acth")) {
                            if (!M7TIC.commandInputConfiguration(sensor, address, true)) return "data:error";
                            return "data:ok";
                        }
                        if (!sa[2].equals("actl")) return "data:error";
                        if (!M7TIC.commandInputConfiguration(sensor, address, false)) return "data:error";
                        return "data:ok";
                    }
                }
                return "data:error";
            }
            if (sa[1].equals("mhours")) {
                if (!user.checkUserRights(userid, "control")) {
                    return "data:noaccess";
                }
                SensorCache sensor = Polling.sensorCache.get(sensorid);
                switch (sensor.modelid) {
                    case 124: 
                    case 125: 
                    case 126: {
                        if (!sa[2].equals("reset")) return "data:error";
                        if (!ALPTEC.writeResetMaintenanceHoursX2(sensor.gatewayaddress, sensor.address)) return "data:error";
                        StringBuffer sb = new StringBuffer();
                        user.displayHash(sb, ALPTEC.readMaintenanceHoursX2(sensor.gatewayaddress, sensor.address));
                        return "data:{\"sensor\":{\"maintenance\":{" + sb.toString() + "}}}";
                    }
                    case 127: {
                        if (!sa[2].equals("reset")) return "data:error";
                        if (!ALPTEC.writeResetMaintenanceHours8(sensor.gatewayaddress, sensor.address, Integer.parseInt(sa[3]))) return "data:error";
                        return "data:ok";
                    }
                }
                return "data:error";
            }
            if (sa[1].equals("mode")) {
                if (!user.checkUserRights(userid, "control")) {
                    return "data:noaccess";
                }
                SensorCache sensor = Polling.sensorCache.get(sensorid);
                switch (sensor.modelid) {
                    case 124: 
                    case 125: 
                    case 126: {
                        if (!sa[2].equals("auto")) {
                            if (!sa[2].equals("man")) return "data:error";
                        }
                        if (!ALPTEC.writeModeX2(sensor.gatewayaddress, sensor.address, sa[2].equals("auto"))) return "data:error";
                        StringBuffer sb = new StringBuffer();
                        user.displayHash(sb, ALPTEC.readStepsModeX2(sensor.gatewayaddress, sensor.address, ALPTEC.getNumberOfStepsByModel(sensor.modelid)));
                        return "data:{\"sensor\":{\"status\":{" + sb.toString() + "}}}";
                    }
                    case 127: {
                        if (!sa[2].equals("auto")) {
                            if (!sa[2].equals("man")) return "data:error";
                        }
                        if (!ALPTEC.writeMode8(sensor.gatewayaddress, sensor.address, sa[2].equals("auto"))) return "data:error";
                        StringBuffer sb = new StringBuffer();
                        user.displayHash(sb, ALPTEC.readStepsMode8(sensor.gatewayaddress, sensor.address));
                        return "data:{\"sensor\":{\"status\":{" + sb.toString() + "}}}";
                    }
                }
                return "data:error";
            }
            if (!sa[1].equals("stepsmode")) return "data:error";
            if (!user.checkUserRights(userid, "control")) {
                return "data:noaccess";
            }
            SensorCache sensor = Polling.sensorCache.get(sensorid);
            switch (sensor.modelid) {
                case 124: 
                case 125: 
                case 126: {
                    numberOfSteps = ALPTEC.getNumberOfStepsByModel(sensor.modelid);
                    break;
                }
                case 127: {
                    int numberOfSteps2 = ALPTEC.getNumberOfStepsByModel(sensor.modelid);
                    StringBuffer sb = new StringBuffer();
                    user.displayHash(sb, ALPTEC.readStepsModeX2(sensor.gatewayaddress, sensor.address, numberOfSteps2));
                    return "data:{\"sensor\":{\"status\":{" + sb.toString() + "}}}";
                }
                default: {
                    return "data:error";
                }
            }
            if (numberOfSteps <= 0) return "data:error";
            if (sa[2].equals("all")) {
                on = sa[3].equals("on");
                int step = 1;
                while (step <= numberOfSteps) {
                    ALPTEC.writeStepsModeX2(sensor.gatewayaddress, sensor.address, step, on);
                    ++step;
                }
            } else {
                on = sa[3].equals("on");
                int step = Integer.parseInt(sa[2]);
                ALPTEC.writeStepsModeX2(sensor.gatewayaddress, sensor.address, step, on);
            }
            StringBuffer sb = new StringBuffer();
            user.displayHash(sb, ALPTEC.readStepsModeX2(sensor.gatewayaddress, sensor.address, numberOfSteps));
            return "data:{\"sensor\":{\"status\":{" + sb.toString() + "}}}";
        }
        if (result == null) {
            return "data:error";
        }
        if (result.length() != 0) return "data:{\"sensor\":{" + result + "}}";
        return "data:empty";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String commandGmaint(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "gmaint")) {
            return "data:noaccess";
        }
        try {
            int sensorid = Integer.parseInt(sa[0]);
            SensorCache sensor = Polling.sensorCache.get(sensorid);
            switch (sensor.modelid) {
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 96: 
                case 98: 
                case 99: 
                case 105: {
                    if (sa[1].equals("greset")) {
                        CS.writeHardwareReset(sensor);
                        return user.readSensor(userid, String.valueOf(sensorid) + ",gmaintenance");
                    }
                    if (sa[1].equals("gevon")) {
                        CS.writePlugsDisabled(sensor, true, false);
                        return user.readSensor(userid, String.valueOf(sensorid) + ",gmaintenance");
                    }
                    if (sa[1].equals("gevoff")) {
                        CS.writePlugsDisabled(sensor, true, true);
                        return user.readSensor(userid, String.valueOf(sensorid) + ",gmaintenance");
                    }
                    if (sa[1].equals("gdomon")) {
                        CS.writePlugsDisabled(sensor, false, false);
                        return user.readSensor(userid, String.valueOf(sensorid) + ",gmaintenance");
                    }
                    if (!sa[1].equals("gdomoff")) return "data:error";
                    CS.writePlugsDisabled(sensor, false, true);
                    return user.readSensor(userid, String.valueOf(sensorid) + ",gmaintenance");
                }
            }
            return "data:error";
        }
        catch (Exception e2) {
            return "data:error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String commandGmanagement(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "gcontrol")) {
            return "data:noaccess";
        }
        try {
            int sensorid = Integer.parseInt(sa[0]);
            SensorCache sensor = Polling.sensorCache.get(sensorid);
            if (sa[1].equals("chargestart")) {
                switch (sensor.modelid) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 105: {
                        String plug = CS.readStationCharge(sensor, false).get("plug");
                        if (plug.equals("ev")) {
                            CS.writeChargeAuthorization(sensor, true, true);
                            return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                        }
                        if (!plug.equals("dom")) return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                        CS.writeChargeAuthorization(sensor, false, true);
                        return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                    }
                }
                return "data:error";
            }
            if (sa[1].equals("chargewait")) {
                switch (sensor.modelid) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 105: {
                        String plug = CS.readStationCharge(sensor, false).get("plug");
                        if (plug.equals("ev")) {
                            CS.writeChargeAuthorization(sensor, true, false);
                            return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                        }
                        if (!plug.equals("dom")) return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                        CS.writeChargeAuthorization(sensor, false, false);
                        return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                    }
                }
                return "data:error";
            }
            if (sa[1].equals("nopriority")) {
                try {
                    ChargeController.chargeCache.get(sensor.sensorid).setPriority(false);
                    return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
                }
                catch (Exception e2) {
                    return "data:error";
                }
            }
            if (!sa[1].equals("priority")) return "data:error";
            try {
                ChargeController.chargeCache.get(sensor.sensorid).setPriority(true);
                return user.readSensor(userid, String.valueOf(sensorid) + ",gstationcommandstate");
            }
            catch (Exception e3) {
                return "data:error";
            }
        }
        catch (Exception e4) {
            return "data:error";
        }
    }

    public static String testSensor(String userid, String param) throws Exception {
        String subaddress;
        String[] sa = param.split(",");
        switch (sa.length) {
            case 3: {
                subaddress = null;
                break;
            }
            case 4: {
                subaddress = URLDecoder.decode(sa[3], "UTF-8");
                break;
            }
            default: {
                return "data:error";
            }
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        GatewayCache gateway = Polling.gatewayCache.get(Integer.parseInt(sa[0]));
        int modelid = Integer.parseInt(sa[1]);
        if (Models.elementAt(modelid)[15].length() > 0) {
            modelid = Integer.parseInt(Models.elementAt(modelid)[15]);
        }
        switch (modelid) {
            case 0: 
            case 1: {
                Hashtable<String, Integer> data = EMDX3.decodeVIF(EMDX3.readVIF(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 2: 
            case 3: {
                Hashtable<String, Long> datal = EMDX3.decodePartialEnergyNeg(EMDX3.readPartialEnergyNeg(gateway.address, Integer.parseInt(sa[2])));
                if (datal.size() > 0 && datal.get("Es") != -1L) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 4: 
            case 5: {
                Hashtable<String, Integer> data = IME.decodeVIF467x(IME.readVIF467x(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 6: 
            case 7: 
            case 8: 
            case 94: {
                Hashtable<String, Integer> data = IME.decodeVIF468x(IME.readVIF468x(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 9: 
            case 18: 
            case 19: {
                Hashtable<String, Integer> data = IME.decodeVIF4686(IME.readVIF4686(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 61: 
            case 64: {
                if (subaddress.startsWith("0:")) {
                    Hashtable<String, Long> datal = EMDX3.decodeTotalEnergyCounter(EMDX3.readTotalEnergyCounter(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("1:")) {
                    Hashtable<String, Long> datal = F4.decodeTotalEnergyCounter(F4.readTotalCounter(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("2:")) {
                    Hashtable<String, Long> datal = F4.decodeTotalEnergyCounter12(F4.readTotalCounter12(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("3:")) {
                    String[] a2 = sa[2].split("[-]");
                    if (a2.length != 2) {
                        if (EMS.discovery(gateway.address, Integer.parseInt(a2[0]), 1, true)) {
                            Hashtable<String, Long> datal = EMS.decodeTotalEnergyCounter(EMS.readTotalCounter(gateway.address, Integer.parseInt(a2[0]), subaddress));
                            if (datal.size() > 0 && datal.get("Ea") != -1L) {
                                return "data:{\"test\":{\"status\":\"ok\"}}";
                            }
                            return "data:{\"test\":{\"status\":\"error\"}}";
                        }
                        return "data:{\"test\":{\"status\":\"error\"}}";
                    }
                    if (EMS.discovery(gateway.address, Integer.parseInt(a2[0]), Integer.parseInt(a2[1]), 1, true)) {
                        Hashtable<String, Long> datal = EMS.decodeTotalEnergyCounter(EMS.readTotalCounter(gateway.address, Integer.parseInt(a2[0]), subaddress));
                        if (datal.size() > 0 && datal.get("Ea") != -1L) {
                            return "data:{\"test\":{\"status\":\"ok\"}}";
                        }
                        return "data:{\"test\":{\"status\":\"error\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("4:") || subaddress.startsWith("5:") || subaddress.startsWith("6:")) {
                    Hashtable<String, Long> datal = IME.decodeTotalEnergyCounter(IME.readTotalCounter(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 20: {
                Hashtable<String, Integer> data = DMX3.decodeVIF(DMX3.readVIF(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("I1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 21: {
                Hashtable<String, Integer> data = DPX3.decodeVIF(DPX3.readVIF(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("I1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                if (CS.testSensor(gateway.address, Integer.parseInt(sa[2]), Integer.parseInt(sa[1]))) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 39: 
            case 40: {
                if (subaddress.startsWith("0:")) {
                    Hashtable<String, Long> datal = EMDX3.decodeTotalM3Counter(EMDX3.readTotalEnergyCounter(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("1:")) {
                    Hashtable<String, Long> datal = F4.decodeTotalM3Counter(F4.readTotalCounter(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("2:")) {
                    Hashtable<String, Long> datal = F4.decodeTotalM3Counter12(F4.readTotalCounter12(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("3:")) {
                    String[] a3 = sa[2].split("[-]");
                    if (a3.length != 2) {
                        if (EMS.discovery(gateway.address, Integer.parseInt(a3[0]), 1, true)) {
                            Hashtable<String, Long> datal = EMS.decodeTotalM3Counter(EMS.readTotalCounter(gateway.address, Integer.parseInt(a3[0]), subaddress));
                            if (datal.size() > 0 && datal.get("Ea") != -1L) {
                                return "data:{\"test\":{\"status\":\"ok\"}}";
                            }
                            return "data:{\"test\":{\"status\":\"error\"}}";
                        }
                        return "data:{\"test\":{\"status\":\"error\"}}";
                    }
                    if (EMS.discovery(gateway.address, Integer.parseInt(a3[0]), Integer.parseInt(a3[1]), 1, true)) {
                        Hashtable<String, Long> datal = EMS.decodeTotalM3Counter(EMS.readTotalCounter(gateway.address, Integer.parseInt(a3[0]), subaddress));
                        if (datal.size() > 0 && datal.get("Ea") != -1L) {
                            return "data:{\"test\":{\"status\":\"ok\"}}";
                        }
                        return "data:{\"test\":{\"status\":\"error\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (subaddress.startsWith("4:") || subaddress.startsWith("5:") || subaddress.startsWith("6:")) {
                    Hashtable<String, Long> datal = IME.decodeTotalM3Counter(IME.readTotalCounter(gateway.address, Integer.parseInt(sa[2]), subaddress));
                    if (datal.size() > 0 && datal.get("Ea") != -1L) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 41: {
                Hashtable<String, Integer> data = CONTREL.decodeVIF(CONTREL.readVIF(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() == 11) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 42: {
                Hashtable<String, Integer> data = DX3.decodeVIF(DX3.readVIF(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("I1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 43: {
                Hashtable<String, Long> datal = GENERIC.decodeTotalEnergy(GENERIC.readTotalEnergy(gateway.address, Integer.parseInt(sa[2]), subaddress));
                if (datal != null && datal.get("Ea") != null) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 44: 
            case 45: 
            case 46: 
            case 92: 
            case 93: {
                Hashtable<String, Integer> data = F4.decodeVIFN200(F4.readVIFN200(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 48: 
            case 49: {
                Hashtable<String, Integer> data = ENTES.decodeVIFMPR46S(ENTES.readVIFMPR46S(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 62: {
                String[] a4 = sa[2].split("[-]");
                if (a4.length != 2) {
                    if (EMS.discovery(gateway.address, Integer.parseInt(a4[0]), 1, true)) {
                        return "data:{\"test\":{\"status\":\"ok\"}}";
                    }
                    return "data:{\"test\":{\"status\":\"error\"}}";
                }
                if (EMS.discovery(gateway.address, Integer.parseInt(a4[0]), Integer.parseInt(a4[1]), 1, true)) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 63: {
                Hashtable<String, Integer> data = IME.decodeVIF412068(IME.readVIF412068(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 90: {
                if (M7TIC.readDecodeDigitalInputsState(gateway.address, Integer.parseInt(sa[2])) != null) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 91: {
                if (M7TIC.readDecodeDigitalOutputsState(gateway.address, Integer.parseInt(sa[2])) != null) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 124: {
                return "data:{\"test\":{\"status\":\"" + ("3.2".equals(ALPTEC.readModel(gateway.address, Integer.parseInt(sa[2]))) ? "ok" : "error") + "\"}}";
            }
            case 125: {
                return "data:{\"test\":{\"status\":\"" + ("5.2".equals(ALPTEC.readModel(gateway.address, Integer.parseInt(sa[2]))) ? "ok" : "error") + "\"}}";
            }
            case 126: {
                return "data:{\"test\":{\"status\":\"" + ("8.2".equals(ALPTEC.readModel(gateway.address, Integer.parseInt(sa[2]))) ? "ok" : "error") + "\"}}";
            }
            case 127: {
                return "data:{\"test\":{\"status\":\"" + ("8".equals(ALPTEC.readModel(gateway.address, Integer.parseInt(sa[2]))) ? "ok" : "error") + "\"}}";
            }
            case 136: {
                Hashtable<String, Integer> data = IME.decodeVIFD4DC(IME.readVIFD4DC(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 141: {
                Hashtable<String, Integer> data;
                if (IME.setProtocolTypeCExDF(gateway.address, Integer.parseInt(sa[2])) && (data = IME.decodeVIFCE2DF(IME.readVIFCE2DF(gateway.address, Integer.parseInt(sa[2])))).size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 145: {
                Hashtable<String, Integer> data;
                if (IME.setProtocolTypeCExDF(gateway.address, Integer.parseInt(sa[2])) && (data = IME.decodeVIFCE4DF(IME.readVIFCE4DF(gateway.address, Integer.parseInt(sa[2]), false))).size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 152: {
                Hashtable<String, Integer> data = IME.decodeVIFCE4DF(IME.readVIFCE4DF(gateway.address, Integer.parseInt(sa[2]), true));
                if (data.size() > 0 && data.get("V1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
            case 190: {
                Hashtable<String, Integer> data = DPX3EMS.decodeVIF(DPX3EMS.readVIF(gateway.address, Integer.parseInt(sa[2])));
                if (data.size() > 0 && data.get("I1") != -1) {
                    return "data:{\"test\":{\"status\":\"ok\"}}";
                }
                return "data:{\"test\":{\"status\":\"error\"}}";
            }
        }
        return "data:error";
    }

    public static String selectAllSensors() {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select sensorid, address, interfaceaddress, subaddress, name, gatewayid, enabled, modelid, loadid, group1id, group2id, group3id, group4id, group5id, qualityerror, qualitymessage, error, nototals, noalerts, priority, description from sensors");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int address = rs.getInt(2);
                int interfaceaddress = rs.getInt(3);
                int gatewayid = rs.getInt(6);
                GatewayCache gateway = Polling.gatewayCache.get(gatewayid);
                int modelid = rs.getInt(8);
                String description = rs.getString(21);
                description = description == null ? "" : URLEncoder.encode(description, "UTF-8").replace('+', ' ');
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(rs.getString(1));
                sb.append("\":[\"");
                sb.append(address);
                if (interfaceaddress != 0) {
                    sb.append('-');
                    sb.append(interfaceaddress);
                }
                sb.append("\",\"");
                sb.append(rs.getString(4).length() > 0 ? rs.getString(4) : "null");
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(5), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(gatewayid);
                sb.append("\",\"");
                if (gateway.enabled) {
                    sb.append(rs.getBoolean(7) ? "on" : "off");
                } else {
                    sb.append("off");
                }
                sb.append("\",\"");
                sb.append(modelid);
                sb.append("\",\"");
                sb.append(rs.getString(9));
                sb.append("\",\"");
                sb.append(rs.getString(10));
                sb.append("\",\"");
                sb.append(rs.getString(11));
                sb.append("\",\"");
                sb.append(rs.getString(12));
                sb.append("\",\"");
                sb.append(rs.getString(13));
                sb.append("\",\"");
                sb.append(rs.getString(14));
                sb.append("\",\"");
                sb.append(rs.getInt(15));
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(16), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                switch (rs.getInt(17)) {
                    case 1: {
                        sb.append("offline");
                        break;
                    }
                    case 2: {
                        sb.append("errors");
                        break;
                    }
                    default: {
                        sb.append("online");
                    }
                }
                sb.append("\",\"");
                sb.append(rs.getBoolean(18) ? "true" : "false");
                sb.append("\",\"");
                sb.append(rs.getBoolean(19) ? "true" : "false");
                sb.append("\",\"");
                sb.append(rs.getBoolean(20) ? "true" : "false");
                sb.append("\",");
                switch (modelid) {
                    case 62: {
                        sb.append("[");
                        sb.append(EMS.discoveryGet(Polling.gatewayCache.get((Object)Integer.valueOf((int)gatewayid)).address, address));
                        sb.append("]");
                        break;
                    }
                    case 90: {
                        sb.append("[\"breaker.state\",\"breaker.command\"]");
                        break;
                    }
                    case 91: {
                        sb.append("[\"breaker.command\"]");
                        break;
                    }
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        sb.append("[\"measure\",\"maintenance.control\",\"steps.state\"]");
                        break;
                    }
                    default: {
                        sb.append("null");
                    }
                }
                sb.append(",\"");
                sb.append(description);
                sb.append("\"]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static boolean validateJarUpload(byte[] data, int begin, int end) {
        boolean valid = false;
        try {
            JarEntry entry;
            JarInputStream jar = new JarInputStream(new ByteArrayInputStream(data, begin, end));
            while ((entry = jar.getNextJarEntry()) != null) {
                if (!"wsmeasure.manifest".equals(entry.getName())) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = jar.read(buffer, 0, buffer.length)) != -1) {
                    baos.write(buffer, 0, read);
                }
                Properties p = new Properties();
                p.load(new ByteArrayInputStream(baos.toByteArray()));
                valid = Integer.parseInt(p.getProperty("checkpoint")) >= CHECKPOINT;
                break;
            }
            jar.close();
            return valid;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static String selectSensor(int sensorid) {
        StringBuffer sb = new StringBuffer();
        try {
            PreparedStatement pstmt = databaseConnection.prepareStatement("select sensorid, address, interfaceaddress, subaddress, name, gatewayid, enabled, modelid, loadid, group1id, group2id, group3id, group4id, group5id, qualityerror, qualitymessage, error, nototals, noalerts, priority, description from sensors where sensorid = ?");
            pstmt.setInt(1, sensorid);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int address = rs.getInt(2);
                int interfaceaddress = rs.getInt(3);
                int gatewayid = rs.getInt(6);
                int modelid = rs.getInt(8);
                String description = rs.getString(21);
                description = description == null ? "" : URLEncoder.encode(description, "UTF-8").replace('+', ' ');
                sb.append('\"');
                sb.append(rs.getString(1));
                sb.append("\":[\"");
                sb.append(address);
                if (interfaceaddress != 0) {
                    sb.append('-');
                    sb.append(interfaceaddress);
                }
                sb.append("\",\"");
                sb.append(rs.getString(4).length() > 0 ? rs.getString(4) : "null");
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(5), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                sb.append(gatewayid);
                sb.append("\",\"");
                if (Polling.gatewayCache.get((Object)Integer.valueOf((int)gatewayid)).enabled) {
                    sb.append(rs.getBoolean(7) ? "on" : "off");
                } else {
                    sb.append("off");
                }
                sb.append("\",\"");
                sb.append(rs.getString(8));
                sb.append("\",\"");
                sb.append(rs.getString(9));
                sb.append("\",\"");
                sb.append(rs.getString(10));
                sb.append("\",\"");
                sb.append(rs.getString(11));
                sb.append("\",\"");
                sb.append(rs.getString(12));
                sb.append("\",\"");
                sb.append(rs.getString(13));
                sb.append("\",\"");
                sb.append(rs.getString(14));
                sb.append("\",\"");
                sb.append(rs.getInt(15));
                sb.append("\",\"");
                sb.append(URLEncoder.encode(rs.getString(16), "UTF-8").replace('+', ' '));
                sb.append("\",\"");
                switch (rs.getInt(17)) {
                    case 1: {
                        sb.append("offline");
                        break;
                    }
                    case 2: {
                        sb.append("errors");
                        break;
                    }
                    default: {
                        sb.append("online");
                    }
                }
                sb.append("\",\"");
                sb.append(rs.getBoolean(18) ? "true" : "false");
                sb.append("\",\"");
                sb.append(rs.getBoolean(19) ? "true" : "false");
                sb.append("\",\"");
                sb.append(rs.getBoolean(20) ? "true" : "false");
                sb.append("\",");
                switch (modelid) {
                    case 62: {
                        sb.append("[");
                        sb.append(EMS.discoveryGet(Polling.gatewayCache.get((Object)Integer.valueOf((int)gatewayid)).address, address));
                        sb.append("]");
                        break;
                    }
                    case 90: {
                        sb.append("[\"breaker.state\",\"breaker.command\"]");
                        break;
                    }
                    case 91: {
                        sb.append("[\"breaker.command\"]");
                        break;
                    }
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        sb.append("[\"maintenance.control\",\"steps.control\"]");
                        break;
                    }
                    default: {
                        sb.append("null");
                    }
                }
                sb.append(",\"");
                sb.append(description);
                sb.append("\"]");
            }
            rs.close();
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String reqModels(String userid) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (user.checkUserRights(userid, "")) {
            int i2 = 0;
            while (i2 < Models.size()) {
                String[] row = Models.elementAt(i2);
                if (row != null && row[0].length() > 0) {
                    Integer[] conc = ModelsConcentrators.elementAt(i2);
                    String[] opt = ModelsOptions.elementAt(i2);
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append('\"');
                    sb.append(i2);
                    sb.append("\":{\"name\":\"");
                    sb.append(URLEncoder.encode(row[0], "UTF-8").replace('+', ' '));
                    sb.append("\",\"family\":\"");
                    sb.append(URLEncoder.encode(row[13], "UTF-8").replace('+', ' '));
                    sb.append("\",\"position\":\"");
                    sb.append(URLEncoder.encode(row[14], "UTF-8").replace('+', ' '));
                    sb.append("\",\"capabilities\":{\"vif\":\"");
                    if (row[2].length() == 0 || row[2].startsWith("vit")) {
                        sb.append("no");
                    } else if (row[2].startsWith("vif:")) {
                        sb.append("yes:");
                        sb.append(row[2].substring(4));
                    } else {
                        sb.append("yes");
                    }
                    sb.append("\",\"vit\":\"");
                    if (row[2].startsWith("vit")) {
                        sb.append("yes");
                    } else {
                        sb.append("no");
                    }
                    sb.append("\",\"power\":\"");
                    if (row[3].length() == 0) {
                        sb.append("no");
                    } else if (row[3].startsWith("power:")) {
                        sb.append("yes:");
                        sb.append(row[3].substring(6));
                    } else {
                        sb.append("yes");
                    }
                    sb.append("\",\"thd\":\"");
                    sb.append(row[4].length() > 0 ? "yes" : "no");
                    sb.append("\",\"thdstat\":\"");
                    sb.append(row[5].length() > 0 ? "yes" : "no");
                    sb.append("\",\"energy\":\"");
                    sb.append(row[6].length() > 0 ? "yes" : "no");
                    sb.append("\",\"harmonic\":\"");
                    if (row[11].length() == 0) {
                        sb.append("no");
                    } else if (row[11].startsWith("harmonic:")) {
                        sb.append("yes:");
                        sb.append(row[11].substring(9));
                    } else {
                        sb.append("yes");
                    }
                    sb.append("\",\"greenup\":\"");
                    sb.append(row[12].startsWith("greenup:") ? "yes:" + row[12].substring(8) : "no");
                    if (row[6].equals("energywater")) {
                        sb.append("\",\"water\":\"yes");
                    } else if (row[6].equals("energygas")) {
                        sb.append("\",\"gas\":\"yes");
                    } else if (row[6].equals("energygeneric")) {
                        sb.append("\",\"generic\":\"yes");
                    }
                    sb.append("\"}");
                    if (conc != null) {
                        sb.append(",\"concentrators\":[");
                        int c2 = 0;
                        while (c2 < conc.length) {
                            sb.append(c2 > 0 ? ",\"" : "\"");
                            sb.append(conc[c2]);
                            sb.append('\"');
                            ++c2;
                        }
                        sb.append(']');
                    }
                    if (opt != null) {
                        sb.append(",\"options\":[");
                        int o2 = 0;
                        while (o2 < opt.length) {
                            sb.append(o2 > 0 ? ",\"" : "\"");
                            sb.append(opt[o2]);
                            sb.append('\"');
                            ++o2;
                        }
                        sb.append(']');
                    }
                    sb.append("}");
                }
                ++i2;
            }
            if (sb.length() == 0) {
                return "data:empty";
            }
            return "data:{\"models\":{" + sb.toString() + "}}";
        }
        return "data:noaccess";
    }

    public static String reqConcentrators(String userid) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (user.checkUserRights(userid, "")) {
            int i2 = 0;
            while (i2 < Concentrators.size()) {
                String[] row = Concentrators.elementAt(i2);
                if (row != null) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append('\"');
                    sb.append(i2);
                    sb.append("\":{\"name\":\"");
                    sb.append(URLEncoder.encode(row[0], "UTF-8").replace('+', ' '));
                    sb.append("\"}");
                }
                ++i2;
            }
            if (sb.length() == 0) {
                return "data:empty";
            }
            return "data:{\"concentrators\":{" + sb.toString() + "}}";
        }
        return "data:noaccess";
    }

    public static String reqEnergyOptions(String userid) {
        if (user.checkUserRights(userid, "")) {
            return "data:{\"energyoptions\":{\"gasconv\":\"" + user.varGet("gaskwhm3!") + "\",\"currency\":\"" + user.varGet("energycurrency!") + "\"}}";
        }
        return "data:noaccess";
    }

    public static String setEnergyOptions(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        try {
            if (!Double.isFinite(Double.parseDouble(sa[0]))) {
                return "data:error";
            }
        }
        catch (Exception e2) {
            return "data:error";
        }
        user.varSet("gaskwhm3!", sa[0]);
        user.uiSet("xgaskwhm3", "value", sa[0]);
        user.varSet("energycurrency!", sa[1].trim().toUpperCase());
        return user.reqEnergyOptions(userid);
    }

    private static String reqEmailSettings(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            return "data:{\"emailsettings\":{\"address\":\"" + URLEncoder.encode(user.varGet("emailaccountaddress!"), "UTF-8").replace('+', ' ') + "\",\"user\":\"" + URLEncoder.encode(user.varGet("emailaccountuser!"), "UTF-8").replace('+', ' ') + "\",\"password\":\"" + URLEncoder.encode(user.varGet("emailaccountpassword!"), "UTF-8").replace('+', ' ') + "\",\"server\":\"" + URLEncoder.encode(user.varGet("emailaccountserver!"), "UTF-8").replace('+', ' ') + "\",\"port\":\"" + user.varGet("emailaccountport!") + "\",\"ssl\":\"" + user.varGet("emailaccountssl!") + "\"}}";
        }
        return "data:noaccess";
    }

    private static String setEmailSettings(String userid, String param) throws Exception {
        String[] sa = param.split(",");
        if (sa.length != 6) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        user.varSet("emailaccountaddress!", URLDecoder.decode(sa[0], "UTF-8"));
        user.varSet("emailaccountuser!", URLDecoder.decode(sa[1], "UTF-8"));
        user.varSet("emailaccountpassword!", URLDecoder.decode(sa[2], "UTF-8"));
        user.varSet("emailaccountserver!", URLDecoder.decode(sa[3], "UTF-8"));
        user.varSet("emailaccountport!", sa[4]);
        user.varSet("emailaccountssl!", sa[5]);
        user.hsycoCheckPoint();
        return user.reqEmailSettings(userid);
    }

    private static String testEmailSettings(String userid, String param) throws Exception {
        Integer SmtpHostPort;
        String[] sa = param.split(",");
        if (sa.length != 6) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String SmtpHostName = URLDecoder.decode(sa[3], "UTF-8");
        try {
            SmtpHostPort = Integer.parseInt(sa[4]);
        }
        catch (Exception e2) {
            SmtpHostPort = null;
        }
        String SmtpHostSSL = sa[5];
        String SmtpHostUser = URLDecoder.decode(sa[1], "UTF-8");
        String SmtpHostPassword = URLDecoder.decode(sa[2], "UTF-8");
        String fromAddress = URLDecoder.decode(sa[0], "UTF-8");
        if (Reports.sendMail(fromAddress, "Test email", "Test email", SmtpHostName, SmtpHostPort, SmtpHostSSL, SmtpHostUser, SmtpHostPassword, fromAddress) == 1) {
            return "data:{\"test\":{\"status\":\"ok\"}}";
        }
        return "data:{\"test\":{\"status\":\"error\"}}";
    }

    private static String reqTelegramSettings(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            return "data:{\"telegramsettings\":{\"bot\":\"" + URLEncoder.encode(user.varGet("telegrambot!"), "UTF-8").replace('+', ' ') + "\",\"password\":\"" + URLEncoder.encode(user.varGet("telegrampassword!"), "UTF-8").replace('+', ' ') + "\",\"token\":\"" + URLEncoder.encode(user.varGet("telegramtoken!"), "UTF-8").replace('+', ' ') + "\",\"users\":[" + user.selectAllTelegramUsers() + "]}}";
        }
        return "data:noaccess";
    }

    private static String setTelegramSettings(String userid, String param) throws Exception {
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        String[] sa = param.split(",");
        if (sa.length < 3) {
            return "data:error";
        }
        user.varSet("telegrambot!", URLDecoder.decode(sa[0], "UTF-8"));
        String password = URLDecoder.decode(sa[1], "UTF-8");
        user.ioSet("telegram.password", password);
        user.varSet("telegrampassword!", password);
        String token = URLDecoder.decode(sa[2], "UTF-8");
        user.ioSet("telegram.token", token);
        user.varSet("telegramtoken!", token);
        int i2 = 3;
        while (i2 < sa.length) {
            String[] ua = URLDecoder.decode(sa[i2], "UTF-8").split("=");
            if (ua[1].equalsIgnoreCase("true")) {
                user.ioSet("telegram.enable", ua[0]);
            } else {
                user.ioSet("telegram.disable", ua[0]);
            }
            ++i2;
        }
        Alarms.init();
        user.hsycoCheckPoint();
        return user.reqTelegramSettings(userid);
    }

    private static String testTelegramSettings(String userid, String param) throws Exception {
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        if (Reports.sendTelegram("Test message.") == 1) {
            return "data:{\"test\":{\"status\":\"ok\"}}";
        }
        return "data:{\"test\":{\"status\":\"error\"}}";
    }

    private static String selectAllTelegramUsers() {
        try {
            StringBuffer sb = new StringBuffer();
            FileInputStream fis = new FileInputStream(new File("telegram-telegram.ini"));
            Properties users = new Properties();
            users.load(fis);
            fis.close();
            Enumeration<Object> e2 = users.keys();
            while (e2.hasMoreElements()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                String k2 = (String)e2.nextElement();
                String n2 = users.getProperty(k2);
                if (k2.startsWith("-")) {
                    sb.append("[\"");
                    sb.append(k2.substring(1));
                    sb.append("\",\"false\",\"");
                } else {
                    sb.append("[\"");
                    sb.append(k2);
                    sb.append("\",\"true\",\"");
                }
                sb.append(URLEncoder.encode(n2, "UTF-8").replace('+', ' '));
                sb.append("\"]");
            }
            return sb.toString();
        }
        catch (Exception e3) {
            return "";
        }
    }

    private static String reqAutoReportSettings(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            return "data:{\"autoreportsettings\":{\"summary\":\"" + user.varGet("autoreportsummary!") + "\",\"detailed\":\"" + user.varGet("autoreportdetailed!") + "\",\"monthly\":\"" + user.varGet("autoreportmonthly!") + "\",\"yearly\":\"" + user.varGet("autoreportyearly!") + "\",\"pdf\":\"" + user.varGet("autoreportpdf!") + "\",\"csv\":\"" + user.varGet("autoreportcsv!") + "\",\"frequency\":\"" + user.varGet("autoreportfrequency!") + "\",\"address\":\"" + URLEncoder.encode(user.varGet("autoreportaddress!"), "UTF-8").replace('+', ' ') + "\",\"sensors\":\"" + user.varGet("autoreportsensors!") + "\"}}";
        }
        return "data:noaccess";
    }

    private static String setAutoReportSettings(String userid, String param) throws Exception {
        String[] sa = param.split(",", 9);
        if (sa.length != 9) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        user.varSet("autoreportsummary!", sa[0]);
        user.varSet("autoreportdetailed!", sa[1]);
        user.varSet("autoreportmonthly!", sa[2]);
        user.varSet("autoreportyearly!", sa[3]);
        user.varSet("autoreportpdf!", sa[4]);
        user.varSet("autoreportcsv!", sa[5]);
        user.varSet("autoreportfrequency!", sa[6]);
        user.varSet("autoreportaddress!", URLDecoder.decode(sa[7], "UTF-8"));
        user.varSet("autoreportsensors!", sa[8]);
        user.hsycoCheckPoint();
        return user.reqAutoReportSettings(userid);
    }

    private static String reqAlertSettings(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            return "data:{\"alertsettings\":{\"statechanges\":\"" + user.varGet("alertsstatechanges!") + "\",\"threshold\":\"" + user.varGet("alertsthreshold!") + "\",\"pfc\":\"" + user.varGet("alertspfc!") + "\",\"conferrors\":\"" + user.varGet("alertsconferrors!") + "\",\"comerrors\":\"" + user.varGet("alertscomerrors!") + "\",\"emailalert\":\"" + user.varGet("alertsemailalert!") + "\",\"address\":\"" + URLEncoder.encode(user.varGet("alertsemailaddress!"), "UTF-8").replace('+', ' ') + "\",\"object\":\"" + URLEncoder.encode(user.varGet("alertsemailsubject!"), "UTF-8").replace('+', ' ') + "\",\"telegramalert\":\"" + user.varGet("alertstelegramalert!") + "\"}}";
        }
        return "data:noaccess";
    }

    private static String setAlertSettings(String userid, String param) throws Exception {
        String[] sa = param.split(",", 9);
        if (sa.length != 9) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        user.varSet("alertsstatechanges!", sa[0]);
        user.varSet("alertsthreshold!", sa[1]);
        user.varSet("alertspfc!", sa[2]);
        user.varSet("alertsconferrors!", sa[3]);
        user.varSet("alertscomerrors!", sa[4]);
        user.varSet("alertsemailalert!", sa[5]);
        user.varSet("alertsemailaddress!", URLDecoder.decode(sa[6], "UTF-8"));
        user.varSet("alertsemailsubject!", URLDecoder.decode(sa[7], "UTF-8"));
        user.varSet("alertstelegramalert!", sa[8]);
        user.hsycoCheckPoint();
        return user.reqAlertSettings(userid);
    }

    public static String reqAlarms(String userid) throws Exception {
        if (user.checkUserRights(userid, "")) {
            String result = Alarms.selectAllAlarms();
            if (result == null) {
                return "data:error";
            }
            return "data:{\"alarms\":[" + result + "]}";
        }
        return "data:noaccess";
    }

    public static String setAlarm(String userid, String param) throws Exception {
        String[] sa = param.split(",", 2);
        if (sa.length != 2) {
            return "data:error";
        }
        if (!user.checkUserRights(userid, "control")) {
            return "data:noaccess";
        }
        if (Alarms.setAlarm(sa[0], sa[1].equals("off"))) {
            return user.reqAlarms(userid);
        }
        return "data:error";
    }

    private static String reqGreenUpConfiguration(String userid) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (user.checkUserRights(userid, "conf")) {
            sb.append("data:{\"greenupconfig\":{\"totalsensor\":\"");
            sb.append(greenUpTotalMeterId);
            sb.append("\",\"control\":\"");
            sb.append(greenUpControl);
            sb.append("\",\"currentmaxavailable\":\"");
            if (greenUpCurrentMaxAvailable != Integer.MAX_VALUE) {
                sb.append(greenUpCurrentMaxAvailable);
            }
            sb.append("\",\"currentmaxavailablecharging\":\"");
            if (greenUpCurrentMaxAvailableCharging != Integer.MAX_VALUE) {
                sb.append(greenUpCurrentMaxAvailableCharging);
            }
            sb.append("\",\"currenthysteresis\":\"");
            sb.append(greenUpCurrentHysteresis);
            sb.append("\",\"currentfirstreduction\":\"");
            sb.append(greenUpCurrentFirstReduction);
            sb.append("\",\"currentsecondreduction\":\"");
            sb.append(greenUpCurrentSecondReduction);
            sb.append("\",\"chargequantityminimum\":\"");
            sb.append(greenUpChargeQuantityMinimum);
            sb.append("\"}}");
            return sb.toString();
        }
        return "data:noaccess";
    }

    private static String setGreenUpConfiguration(String userid, String param) throws Exception {
        if (!user.checkUserRights(userid, "conf")) {
            return "data:noaccess";
        }
        try {
            String[] sa = param.split(",");
            if (sa.length == 8) {
                greenUpTotalMeterId = Integer.parseInt(sa[0]);
                greenUpControl = Boolean.parseBoolean(sa[1]);
                greenUpCurrentMaxAvailable = sa[2].length() > 0 ? Integer.parseInt(sa[2]) : Integer.MAX_VALUE;
                greenUpCurrentMaxAvailableCharging = sa[3].length() > 0 ? Integer.parseInt(sa[3]) : Integer.MAX_VALUE;
                greenUpCurrentHysteresis = Integer.parseInt(sa[4]);
                greenUpCurrentFirstReduction = Integer.parseInt(sa[5]);
                greenUpCurrentSecondReduction = Integer.parseInt(sa[6]);
                greenUpChargeQuantityMinimum = Integer.parseInt(sa[7]);
                user.varSet("greenuptotalmeterid!", Integer.toString(greenUpTotalMeterId));
                user.varSet("greenupcontrol!", Boolean.toString(greenUpControl));
                user.varSet("greenupcurrentmaxavailable!", Integer.toString(greenUpCurrentMaxAvailable));
                user.varSet("greenupcurrentmaxavailablecharging!", Integer.toString(greenUpCurrentMaxAvailableCharging));
                user.varSet("greenupcurrenthysteresis!", Integer.toString(greenUpCurrentHysteresis));
                user.varSet("greenupcurrentfirstreduction!", Integer.toString(greenUpCurrentFirstReduction));
                user.varSet("greenupcurrentsecondreduction!", Integer.toString(greenUpCurrentSecondReduction));
                user.varSet("greenupchargequantityminimum!", Integer.toString(greenUpChargeQuantityMinimum));
                user.hsycoCheckPoint();
                return user.reqGreenUpConfiguration(userid);
            }
            if (param.startsWith("eq=")) {
                ChargeController.EQChargeId = param.equals("eq=off") ? -1 : Integer.parseInt(param.substring(3));
                return "data:{\"greenupconfig\":{\"eq\":\"" + param.substring(3) + "\"}}";
            }
            return "data:error";
        }
        catch (Exception e2) {
            return "data:error";
        }
    }

    private static void saveLocale() {
        user.varSet("language!", locale.getLanguage());
        user.varSet("country!", locale.getCountry());
    }

    private static boolean checkUserRights(String userid, String right) {
        block4: {
            String rights;
            block5: {
                try {
                    PreparedStatement pstmt = databaseConnection.prepareStatement("select rights from access where userid = ?");
                    pstmt.setString(1, userid);
                    ResultSet rs = pstmt.executeQuery();
                    if (!rs.next()) break block4;
                    rights = rs.getString(1);
                    rs.close();
                    if (right.length() <= 0) break block5;
                    int i2 = rights.indexOf(String.valueOf(right) + ":");
                    if (i2 >= 0) {
                        return rights.charAt(i2 + right.length() + 1) == '1';
                    }
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            return rights.indexOf(":1") > 0;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSensor(String userid, String param) throws Exception {
        StringBuffer sb = new StringBuffer();
        String[] sa = param.split(",");
        if (sa.length != 2) {
            return "data:error";
        }
        try {
            boolean invertedoption;
            int sensorid = Integer.parseInt(sa[0]);
            SensorCache sensor = Polling.sensorCache.get(sensorid);
            boolean bl = invertedoption = sensor.subaddress != null && sensor.subaddress.endsWith("#inv");
            if (sa[1].equals("vif")) {
                Hashtable<String, String> h2;
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                if (Models.elementAt(sensor.modelid)[2].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            user.displayHash(sb, EMDX3.displayVIF(EMDX3.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 4: 
                        case 5: {
                            user.displayHash(sb, IME.displayVIF467x(IME.readVIF467x(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 94: {
                            user.displayHash(sb, IME.displayVIF468x(IME.readVIF468x(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 9: 
                        case 18: 
                        case 19: {
                            user.displayHash(sb, IME.displayVIF4686(IME.readVIF4686(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 20: {
                            user.displayHash(sb, DMX3.displayVIF(DMX3.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 21: {
                            user.displayHash(sb, DPX3.displayVIF(DPX3.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 41: {
                            user.displayHash(sb, CONTREL.displayVIF(CONTREL.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 42: {
                            user.displayHash(sb, DX3.displayVIF(DX3.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 44: 
                        case 45: 
                        case 46: 
                        case 92: 
                        case 93: {
                            user.displayHash(sb, F4.displayVIFN200(F4.readVIFN200(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 48: 
                        case 49: {
                            user.displayHash(sb, ENTES.displayVIFMPR46S(ENTES.readVIFMPR46S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 62: {
                            user.displayHash(sb, EMS.displayVIF(EMS.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 63: {
                            user.displayHash(sb, IME.displayVIF412068(IME.readVIF412068(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 136: {
                            user.displayHash(sb, IME.displayVIFD4DC(IME.readVIFD4DC(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 141: {
                            user.displayHash(sb, IME.displayVIFCE2DF(IME.readVIFCE2DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 145: {
                            user.displayHash(sb, IME.displayVIFCE4DF(IME.readVIFCE4DF(sensor.gatewayaddress, sensor.address, false)));
                            break;
                        }
                        case 152: {
                            user.displayHash(sb, IME.displayVIFCE4DF(IME.readVIFCE4DF(sensor.gatewayaddress, sensor.address, true)));
                            break;
                        }
                        case 190: {
                            user.displayHash(sb, DPX3EMS.displayVIF(DPX3EMS.readVIF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[10].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            h2 = EMDX3.displayAvgExt(EMDX3.readAvgExt(sensor.gatewayaddress, sensor.address));
                            h2.remove("avgP+");
                            h2.remove("avgP-");
                            h2.remove("avgQ+");
                            h2.remove("avgQ-");
                            h2.remove("avgS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 41: {
                            h2 = CONTREL.displayAvgExt(CONTREL.readAvgExt(sensor.gatewayaddress, sensor.address));
                            h2.remove("avgP+");
                            h2.remove("avgQ+");
                            h2.remove("avgQ-");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 44: 
                        case 92: {
                            h2 = F4.displayAvgExtN200(F4.readAvgExtN200(sensor.gatewayaddress, sensor.address), 100);
                            h2.remove("avgP+");
                            h2.remove("avgP-");
                            h2.remove("avgQ+");
                            h2.remove("avgQ-");
                            h2.remove("avgS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            h2 = F4.displayAvgExtN200(F4.readAvgExtN200(sensor.gatewayaddress, sensor.address), 10);
                            h2.remove("avgP+");
                            h2.remove("avgP-");
                            h2.remove("avgQ+");
                            h2.remove("avgQ-");
                            h2.remove("avgS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 48: 
                        case 49: {
                            h2 = ENTES.displayAvgExtMPR46S(ENTES.readAvgExtMPR46S(sensor.gatewayaddress, sensor.address));
                            h2.remove("avgP+");
                            h2.remove("avgP-");
                            h2.remove("avgQ+");
                            h2.remove("avgQ-");
                            h2.remove("avgS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 152: {
                            h2 = IME.displayAvgExtCE4DF(IME.readAvgExtCE4DF(sensor.gatewayaddress, sensor.address));
                            user.displayHash(sb, h2);
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[8].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            h2 = EMDX3.displayMaxBase(EMDX3.readMaxBase(sensor.gatewayaddress, sensor.address));
                            h2.remove("maxP+");
                            h2.remove("maxP-");
                            h2.remove("maxQ+");
                            h2.remove("maxQ-");
                            h2.remove("maxS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 41: {
                            h2 = CONTREL.displayMaxBase(CONTREL.readMaxBase(sensor.gatewayaddress, sensor.address));
                            h2.remove("maxP+");
                            h2.remove("maxP-");
                            h2.remove("maxQ+");
                            h2.remove("maxQ-");
                            h2.remove("maxS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 44: 
                        case 92: {
                            h2 = F4.displayMaxBaseN200(F4.readMaxBaseN200(sensor.gatewayaddress, sensor.address), 100);
                            h2.remove("maxP+");
                            h2.remove("maxQ+");
                            h2.remove("maxS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            h2 = F4.displayMaxBaseN200(F4.readMaxBaseN200(sensor.gatewayaddress, sensor.address), 10);
                            h2.remove("maxP+");
                            h2.remove("maxQ+");
                            h2.remove("maxS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 48: 
                        case 49: {
                            h2 = ENTES.displayMaxBaseMPR46S(ENTES.readMaxBaseMPR46S(sensor.gatewayaddress, sensor.address));
                            h2.remove("maxP+");
                            h2.remove("maxP-");
                            h2.remove("maxQ+");
                            h2.remove("maxS");
                            user.displayHash(sb, h2);
                            break;
                        }
                        case 152: {
                            h2 = IME.displayMaxBaseCE4DF(IME.readMaxBaseCE4DF(sensor.gatewayaddress, sensor.address));
                            user.displayHash(sb, h2);
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[9].length() > 0) {
                    switch (sensor.modelid) {
                        case 44: 
                        case 92: {
                            user.displayHash(sb, F4.displayMaxExtN200(F4.readMaxExtN200(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            user.displayHash(sb, F4.displayMaxExtN200(F4.readMaxExtN300(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 48: 
                        case 49: {
                            user.displayHash(sb, ENTES.displayMaxExtMPR46S(ENTES.readMaxExtMPR46S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 152: {
                            user.displayHash(sb, IME.displayMaxExtCE4DF(IME.readMaxExtCE4DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"vif\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("vit")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                if (Models.elementAt(sensor.modelid)[2].length() > 0) {
                    switch (sensor.modelid) {
                        case 124: 
                        case 125: 
                        case 126: {
                            user.displayHash(sb, ALPTEC.displayVITX2(ALPTEC.readVITX2(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 127: {
                            user.displayHash(sb, ALPTEC.displayVIT8(ALPTEC.readVIT8(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[8].length() > 0) {
                    switch (sensor.modelid) {
                        case 124: 
                        case 125: 
                        case 126: {
                            user.displayHash(sb, ALPTEC.displayMaxBaseX2(ALPTEC.readMaxBaseX2(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[9].length() > 0) {
                    switch (sensor.modelid) {
                        case 124: 
                        case 125: 
                        case 126: {
                            user.displayHash(sb, ALPTEC.displayMaxExtX2(ALPTEC.readMaxExtX2(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 127: {
                            user.displayHash(sb, ALPTEC.displayMaxExt8(ALPTEC.readMaxExt8(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"vit\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("pow")) {
                Hashtable<String, String> h3;
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                if (Models.elementAt(sensor.modelid)[3].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            user.displayHash(sb, EMDX3.displayPower(EMDX3.readPower(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 4: 
                        case 5: {
                            user.displayHash(sb, IME.displayPower467x(IME.readPower467x(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 6: 
                        case 7: {
                            user.displayHash(sb, IME.displayPower4680(IME.readPower4680(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 94: {
                            user.displayHash(sb, IME.displayPower412074(IME.readPower412074(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 18: 
                        case 19: {
                            user.displayHash(sb, IME.displayPower4686(IME.readPower4686(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 20: {
                            user.displayHash(sb, DMX3.displayPower(DMX3.readPower(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 21: {
                            user.displayHash(sb, DPX3.displayPower(DPX3.readPower(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 41: {
                            user.displayHash(sb, CONTREL.displayPower(CONTREL.readPower(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 42: {
                            user.displayHash(sb, DX3.displayPower(DX3.readPower(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 44: 
                        case 92: {
                            user.displayHash(sb, F4.displayPowerN200(F4.readPowerN200(sensor.gatewayaddress, sensor.address), 100));
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            user.displayHash(sb, F4.displayPowerN200(F4.readPowerN200(sensor.gatewayaddress, sensor.address), 10));
                            break;
                        }
                        case 48: 
                        case 49: {
                            user.displayHash(sb, ENTES.displayPowerMPR46S(ENTES.readPowerMPR46S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 62: {
                            user.displayHash(sb, EMS.displayPower(EMS.readPower(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 63: {
                            user.displayHash(sb, IME.displayPower412068(IME.readPower412068(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 124: 
                        case 125: 
                        case 126: {
                            user.displayHash(sb, ALPTEC.displayPowerX2(ALPTEC.readPowerX2(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 127: {
                            user.displayHash(sb, ALPTEC.displayPower8(ALPTEC.readPower8(sensor.gatewayaddress, sensor.address)));
                        }
                        case 136: {
                            user.displayHash(sb, IME.displayPowerD4DC(IME.readPowerD4DC(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 141: {
                            user.displayHash(sb, IME.displayPowerCE2DF(IME.readPowerCE2DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 145: 
                        case 152: {
                            user.displayHash(sb, IME.displayPowerCE4DF(IME.readPowerCE4DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 190: {
                            user.displayHash(sb, DPX3EMS.displayPower(DPX3EMS.readPower(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[10].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            h3 = EMDX3.displayAvgExt(EMDX3.readAvgExt(sensor.gatewayaddress, sensor.address));
                            h3.remove("avgU12");
                            h3.remove("avgU23");
                            h3.remove("avgU31");
                            h3.remove("avgV1");
                            h3.remove("avgV2");
                            h3.remove("avgV3");
                            h3.remove("avgF");
                            h3.remove("avgI1");
                            h3.remove("avgI2");
                            h3.remove("avgI3");
                            h3.remove("avgIn");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 94: {
                            user.displayHash(sb, IME.displayAvgExt4680(IME.readAvgExt4680(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 18: 
                        case 19: {
                            user.displayHash(sb, IME.displayAvgExt4686(IME.readAvgExt4686(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 41: {
                            user.displayHash(sb, CONTREL.displayAvgExt(CONTREL.readAvgExt(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 44: 
                        case 92: {
                            h3 = F4.displayAvgExtN200(F4.readAvgExtN200(sensor.gatewayaddress, sensor.address), 100);
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            h3 = F4.displayAvgExtN200(F4.readAvgExtN200(sensor.gatewayaddress, sensor.address), 10);
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 48: 
                        case 49: {
                            h3 = ENTES.displayAvgExtMPR46S(ENTES.readAvgExtMPR46S(sensor.gatewayaddress, sensor.address));
                            h3.remove("avgU12");
                            h3.remove("avgU23");
                            h3.remove("avgU31");
                            h3.remove("avgV1");
                            h3.remove("avgV2");
                            h3.remove("avgV3");
                            h3.remove("avgF");
                            h3.remove("avgI1");
                            h3.remove("avgI2");
                            h3.remove("avgI3");
                            h3.remove("avgIn");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 136: {
                            user.displayHash(sb, IME.displayAvgExtD4DC(IME.readAvgExtD4DC(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[8].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            h3 = EMDX3.displayMaxBase(EMDX3.readMaxBase(sensor.gatewayaddress, sensor.address));
                            h3.remove("maxI1");
                            h3.remove("maxI2");
                            h3.remove("maxI3");
                            h3.remove("maxIn");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 94: {
                            user.displayHash(sb, IME.displayMaxBase4680(IME.readMaxBase4680(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 18: 
                        case 19: {
                            user.displayHash(sb, IME.displayMaxBase4686(IME.readMaxBase4686(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 41: {
                            h3 = CONTREL.displayMaxBase(CONTREL.readMaxBase(sensor.gatewayaddress, sensor.address));
                            h3.remove("maxI1");
                            h3.remove("maxI2");
                            h3.remove("maxI3");
                            h3.remove("maxIn");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 44: 
                        case 92: {
                            h3 = F4.displayMaxBaseN200(F4.readMaxBaseN200(sensor.gatewayaddress, sensor.address), 100);
                            h3.remove("maxI1");
                            h3.remove("maxI2");
                            h3.remove("maxI3");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            h3 = F4.displayMaxBaseN200(F4.readMaxBaseN200(sensor.gatewayaddress, sensor.address), 10);
                            h3.remove("maxI1");
                            h3.remove("maxI2");
                            h3.remove("maxI3");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 48: 
                        case 49: {
                            h3 = ENTES.displayMaxBaseMPR46S(ENTES.readMaxBaseMPR46S(sensor.gatewayaddress, sensor.address));
                            h3.remove("maxI1");
                            h3.remove("maxI2");
                            h3.remove("maxI3");
                            h3.remove("maxIn");
                            user.displayHash(sb, h3);
                            break;
                        }
                        case 136: {
                            user.displayHash(sb, IME.displayMaxBaseD4DC(IME.readMaxBaseD4DC(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"pow\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("thd")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                if (Models.elementAt(sensor.modelid)[4].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            user.displayHash(sb, EMDX3.displayTHD(EMDX3.readTHD(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 21: {
                            user.displayHash(sb, DPX3.displayTHD(DPX3.readTHD(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 41: {
                            user.displayHash(sb, CONTREL.displayTHD(CONTREL.readTHD(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 42: {
                            user.displayHash(sb, DX3.displayTHD(DX3.readTHD(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 44: 
                        case 92: {
                            user.displayHash(sb, F4.displayTHDN200(F4.readTHDN200(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            user.displayHash(sb, F4.displayTHDN200(F4.readTHDN300(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 48: 
                        case 49: {
                            user.displayHash(sb, ENTES.displayTHDMPR46S(ENTES.readTHDMPR46S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 62: {
                            user.displayHash(sb, EMS.displayTHD(EMS.readTHD(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 124: 
                        case 125: 
                        case 126: {
                            user.displayHash(sb, ALPTEC.displayTHDX2(ALPTEC.readTHDX2(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 127: {
                            user.displayHash(sb, ALPTEC.displayTHD8(ALPTEC.readTHD8(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 152: {
                            user.displayHash(sb, IME.displayTHDCE4DF(IME.readTHDCE4DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 190: {
                            user.displayHash(sb, DPX3EMS.displayTHD(DPX3EMS.readTHD(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[5].length() > 0) {
                    user.displayHash(sb, EMDX3.displayTHDStat(EMDX3.readTHDStat(sensor.gatewayaddress, sensor.address)));
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"thd\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("har")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                if (Models.elementAt(sensor.modelid)[11].length() > 0) {
                    switch (sensor.modelid) {
                        case 2: 
                        case 3: {
                            user.displayHash(sb, EMDX3.displayHarmonicV(EMDX3.readHarmonicV(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, EMDX3.displayHarmonicU(EMDX3.readHarmonicU(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, EMDX3.displayHarmonicI(EMDX3.readHarmonicI(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 44: {
                            user.displayHash(sb, F4.displayHarmonicVN200(F4.readHarmonicVN200(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, F4.displayHarmonicUN200(F4.readHarmonicUN200(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, F4.displayHarmonicIN200(F4.readHarmonicIN200(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 45: {
                            user.displayHash(sb, F4.displayHarmonicVN300(F4.readHarmonicVN300(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, F4.displayHarmonicUN300(F4.readHarmonicUN300(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, F4.displayHarmonicIN200(F4.readHarmonicIN200(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 46: {
                            user.displayHash(sb, F4.displayHarmonicVN300(F4.readHarmonicVN400(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, F4.displayHarmonicUN300(F4.readHarmonicUN400(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, F4.displayHarmonicIN200(F4.readHarmonicIN400(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 49: {
                            user.displayHash(sb, ENTES.displayHarmonicVMPR47S(ENTES.readHarmonicVMPR47S(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, ENTES.displayHarmonicIMPR47S(ENTES.readHarmonicIMPR47S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 62: {
                            user.displayHash(sb, EMS.displayHarmonicV(EMS.readHarmonicV(sensor.gatewayaddress, sensor.address)));
                            user.displayHash(sb, EMS.displayHarmonicI(EMS.readHarmonicI(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 124: 
                        case 125: 
                        case 126: {
                            user.displayHash(sb, ALPTEC.displayHarmonicX2(ALPTEC.readHarmonicX2(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 127: {
                            user.displayHash(sb, ALPTEC.displayHarmonic8(ALPTEC.readHarmonic8(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"har\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("steps")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                switch (sensor.modelid) {
                    case 124: 
                    case 125: {
                        user.displayHash(sb, ALPTEC.displaySteps3252(ALPTEC.readSteps3252(sensor.gatewayaddress, sensor.address, ALPTEC.getNumberOfStepsByModel(sensor.modelid))));
                        user.displayHash(sb, ALPTEC.displayCapacitorOverloadX2(ALPTEC.readCapacitorOverloadX2(sensor.gatewayaddress, sensor.address)));
                        user.displayHash(sb, ALPTEC.readStepsModeX2(sensor.gatewayaddress, sensor.address, ALPTEC.getNumberOfStepsByModel(sensor.modelid)));
                        break;
                    }
                    case 126: {
                        user.displayHash(sb, ALPTEC.displaySteps82(ALPTEC.readSteps82(sensor.gatewayaddress, sensor.address)));
                        user.displayHash(sb, ALPTEC.displayCapacitorOverloadX2(ALPTEC.readCapacitorOverloadX2(sensor.gatewayaddress, sensor.address)));
                        user.displayHash(sb, ALPTEC.readStepsModeX2(sensor.gatewayaddress, sensor.address, ALPTEC.getNumberOfStepsByModel(sensor.modelid)));
                        break;
                    }
                    case 127: {
                        user.displayHash(sb, ALPTEC.displaySteps8(ALPTEC.readSteps8(sensor.gatewayaddress, sensor.address)));
                        user.displayHash(sb, ALPTEC.readStepsMode8(sensor.gatewayaddress, sensor.address));
                        break;
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"steps\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("mhours")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                switch (sensor.modelid) {
                    case 124: 
                    case 125: 
                    case 126: {
                        user.displayHash(sb, ALPTEC.readMaintenanceHoursX2(sensor.gatewayaddress, sensor.address));
                        break;
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"maintenance\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("enrt")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                if (Models.elementAt(sensor.modelid)[6].length() > 0) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            user.displayHash(sb, EMDX3.displayPartialEnergyPos(EMDX3.readPartialEnergyPos(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 4: 
                        case 5: {
                            user.displayHash(sb, IME.displayEnergyPos467x(IME.readEnergyPos467x(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 6: 
                        case 7: {
                            user.displayHash(sb, IME.displayEnergyPos4680(IME.readEnergyPos4680(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 94: {
                            user.displayHash(sb, IME.displayEnergyPos412074(IME.readEnergyPos412074(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 8: 
                        case 18: 
                        case 19: {
                            user.displayHash(sb, IME.displayEnergyPos468x(IME.readEnergyPos4684(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 9: {
                            user.displayHash(sb, IME.displayEnergyPos468x(IME.readEnergyPos4686(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 61: 
                        case 64: {
                            if (sensor.subaddress.startsWith("0:")) {
                                user.displayHash(sb, EMDX3.displayTotalEnergyCounter(EMDX3.readTotalEnergyCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (sensor.subaddress.startsWith("1:")) {
                                user.displayHash(sb, F4.displayTotalEnergyCounter(F4.readTotalCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (sensor.subaddress.startsWith("2:")) {
                                user.displayHash(sb, F4.displayTotalEnergyCounter12(F4.readTotalCounter12(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (sensor.subaddress.startsWith("3:")) {
                                user.displayHash(sb, EMS.displayTotalEnergyCounter(EMS.readTotalCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (!sensor.subaddress.startsWith("4:") && !sensor.subaddress.startsWith("5:") && !sensor.subaddress.startsWith("6:")) break;
                            user.displayHash(sb, IME.displayTotalEnergyCounter(IME.readTotalCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                            break;
                        }
                        case 20: {
                            byte[] data = DMX3.readEnergyPos(sensor.gatewayaddress, sensor.address, invertedoption);
                            if (data.length == 1) break;
                            user.displayHash(sb, DMX3.displayEnergyPos(data));
                            break;
                        }
                        case 21: {
                            byte[] data = DPX3.readEnergyPos(sensor.gatewayaddress, sensor.address, invertedoption);
                            if (data.length == 1) break;
                            user.displayHash(sb, DPX3.displayEnergyPos(data));
                            break;
                        }
                        case 39: 
                        case 40: {
                            if (sensor.subaddress.startsWith("0:")) {
                                user.displayHash(sb, EMDX3.displayTotalM3Counter(EMDX3.readTotalM3Counter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (sensor.subaddress.startsWith("1:")) {
                                user.displayHash(sb, F4.displayTotalM3Counter(F4.readTotalCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (sensor.subaddress.startsWith("2:")) {
                                user.displayHash(sb, F4.displayTotalM3Counter12(F4.readTotalCounter12(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (sensor.subaddress.startsWith("3:")) {
                                user.displayHash(sb, EMS.displayTotalM3Counter(EMS.readTotalCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                                break;
                            }
                            if (!sensor.subaddress.startsWith("4:") && !sensor.subaddress.startsWith("5:") && !sensor.subaddress.startsWith("6:")) break;
                            user.displayHash(sb, IME.displayTotalM3Counter(IME.readTotalCounter(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                            break;
                        }
                        case 41: {
                            user.displayHash(sb, CONTREL.displayPartialEnergyPos(CONTREL.readPartialEnergyPos(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 42: {
                            byte[] data = DX3.readEnergyPos(sensor.gatewayaddress, sensor.address, invertedoption);
                            if (data.length == 1) break;
                            user.displayHash(sb, DX3.displayEnergyPos(data));
                            break;
                        }
                        case 43: {
                            user.displayHash(sb, GENERIC.displayTotalEnergy(GENERIC.readTotalEnergy(sensor.gatewayaddress, sensor.address, sensor.subaddress)));
                            break;
                        }
                        case 44: 
                        case 92: {
                            user.displayHash(sb, F4.displayEnergyPosN200(F4.readEnergyPosN200(sensor.gatewayaddress, sensor.address), 100));
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            user.displayHash(sb, F4.displayEnergyPosN200(F4.readEnergyPosN200(sensor.gatewayaddress, sensor.address), 10));
                            break;
                        }
                        case 48: 
                        case 49: {
                            user.displayHash(sb, ENTES.displayEnergyPosMPR46S(ENTES.readEnergyPosMPR46S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 62: {
                            byte[] data = EMS.readEnergyPos(sensor.gatewayaddress, sensor.address, invertedoption);
                            if (data.length == 1) break;
                            user.displayHash(sb, EMS.displayEnergyPos(data));
                            break;
                        }
                        case 63: {
                            user.displayHash(sb, IME.displayEnergyPos412068(IME.readEnergyPos412068(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 136: {
                            user.displayHash(sb, IME.displayEnergyPosD4DC(IME.readEnergyPosD4DC(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 141: {
                            user.displayHash(sb, IME.displayEnergyPosCE2DF(IME.readEnergyPosCE2DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 145: 
                        case 152: {
                            user.displayHash(sb, IME.displayEnergyPosCE4DF(IME.readEnergyPosCE4DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 190: {
                            byte[] data = DPX3EMS.readEnergyPos(sensor.gatewayaddress, sensor.address, invertedoption);
                            if (data.length == 1) break;
                            user.displayHash(sb, DPX3EMS.displayEnergyPos(data));
                            break;
                        }
                    }
                }
                if (Models.elementAt(sensor.modelid)[7].length() > 0) {
                    switch (sensor.modelid) {
                        case 2: 
                        case 3: {
                            user.displayHash(sb, EMDX3.displayPartialEnergyNeg(EMDX3.readPartialEnergyNeg(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 20: {
                            user.displayHash(sb, DMX3.displayEnergyNeg(DMX3.readEnergyNeg(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 21: {
                            user.displayHash(sb, DPX3.displayEnergyNeg(DPX3.readEnergyNeg(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 41: {
                            user.displayHash(sb, CONTREL.displayPartialEnergyNeg(CONTREL.readPartialEnergyNeg(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 42: {
                            user.displayHash(sb, DX3.displayEnergyNeg(DX3.readEnergyNeg(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 44: 
                        case 92: {
                            user.displayHash(sb, F4.displayEnergyNegN200(F4.readEnergyNegN200(sensor.gatewayaddress, sensor.address), 100));
                            break;
                        }
                        case 45: 
                        case 46: 
                        case 93: {
                            user.displayHash(sb, F4.displayEnergyNegN200(F4.readEnergyNegN200(sensor.gatewayaddress, sensor.address), 10));
                            break;
                        }
                        case 48: 
                        case 49: {
                            user.displayHash(sb, ENTES.displayEnergyNegMPR46S(ENTES.readEnergyNegMPR46S(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 62: {
                            user.displayHash(sb, EMS.displayEnergyNeg(EMS.readEnergyNeg(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                        case 136: {
                            user.displayHash(sb, IME.displayEnergyNegD4DC(IME.readEnergyNegD4DC(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 141: {
                            user.displayHash(sb, IME.displayEnergyNegCE2DF(IME.readEnergyNegCE2DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 145: 
                        case 152: {
                            user.displayHash(sb, IME.displayEnergyNegCE4DF(IME.readEnergyNegCE4DF(sensor.gatewayaddress, sensor.address)));
                            break;
                        }
                        case 190: {
                            user.displayHash(sb, DPX3EMS.displayEnergyNeg(DPX3EMS.readEnergyNeg(sensor.gatewayaddress, sensor.address, invertedoption)));
                            break;
                        }
                    }
                }
                if (sb.length() > 0) {
                    return "data:{\"sensor\":{\"enrt\":{" + sb.toString() + "}}}";
                }
                return "data:empty";
            }
            if (sa[1].equals("energy")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                user.displayHash(sb, user.energyView(0L, sensorid));
                if (sb.length() <= 0) {
                    return "data:empty";
                }
                StringBuffer sbr = new StringBuffer("data:{\"sensor\":{\"cost\":\"");
                switch (sensor.loadid) {
                    case -3: {
                        sbr.append(user.varGet("watercost!"));
                        break;
                    }
                    case -4: {
                        sbr.append(user.varGet("gascost!"));
                        break;
                    }
                    default: {
                        sbr.append(user.varGet("energycost!"));
                    }
                }
                sbr.append("\",\"currency\":\"");
                sbr.append(user.varGet("energycurrency!"));
                sbr.append("\",\"energy\":{");
                sbr.append(sb);
                sbr.append("}}}");
                return sbr.toString();
            }
            if (sa[1].equals("gmaintenance")) {
                if (!user.checkUserRights(userid, "gmaint")) {
                    return "data:noaccess";
                }
                Hashtable<String, String> values = CS.readStationErrors(sensor);
                sb.append("\"stationerrors\":[\"");
                sb.append(values.get("powerfail"));
                sb.append("\",\"");
                sb.append(values.get("rechwerror"));
                sb.append("\",\"");
                sb.append(values.get("fatalhwerror"));
                sb.append("\",\"");
                sb.append(values.get("chgerror"));
                sb.append("\",\"");
                sb.append(values.get("lowbatt"));
                sb.append("\",\"");
                sb.append("0");
                sb.append("\"], ");
                Thread.sleep(100L);
                values = CS.readChargeErrors(sensor);
                sb.append("\"chargeerrors\":[\"");
                sb.append(values.get("evlockerror"));
                sb.append("\",\"");
                sb.append(values.get("evdisconnect"));
                sb.append("\",\"");
                sb.append(values.get("evchgcurrlimit"));
                sb.append("\",\"");
                sb.append(values.get("evcpfail"));
                sb.append("\",\"");
                sb.append(values.get("evoverheat"));
                sb.append("\",\"");
                sb.append(values.get("domlockerror"));
                sb.append("\",\"");
                sb.append(values.get("domchgcurrlimit"));
                sb.append("\",\"");
                sb.append(values.get("domoverheat"));
                sb.append("\",\"");
                sb.append(values.get("other"));
                sb.append("\"], ");
                Thread.sleep(100L);
                values = CS.readPlugsStatus(sensor);
                sb.append("\"plugs\":[\"");
                sb.append(values.get("ev"));
                sb.append("\",\"");
                sb.append(values.get("dom"));
                sb.append("\"]");
                return "data:{\"sensor\":{" + sb.toString() + "}}";
            }
            if (sa[1].equals("gstate")) {
                if (!user.checkUserRights(userid, "gview")) {
                    return "data:noaccess";
                }
                sb.append("\"stationstate\":{");
                user.displayHash(sb, CS.readStationState(sensor));
                sb.append("}, \"chargestate\":{");
                Thread.sleep(100L);
                user.displayHash(sb, CS.readStationCharge(sensor, true));
                sb.append("}, \"about\":{");
                Thread.sleep(100L);
                user.displayHash(sb, CS.readStationInfo(sensor));
                sb.append('}');
                return "data:{\"sensor\":{" + sb.toString() + "}}";
            }
            if (sa[1].equals("gstationcommandstate")) {
                if (!user.checkUserRights(userid, "gview")) {
                    return "data:noaccess";
                }
                sb.append("\"stationcommandstate\":{");
                user.displayHash(sb, CS.readStationCommandState(sensor));
                sb.append(ChargeController.chargeCache.get((Object)Integer.valueOf((int)sensor.sensorid)).priority ? ",\"nopriority\":\"0\", \"priority\":\"1\"" : ",\"nopriority\":\"1\", \"priority\":\"0\"");
                sb.append('}');
                return "data:{\"sensor\":{" + sb.toString() + "}}";
            }
            if (sa[1].equals("breaker")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                sb.append("\"breaker\":{");
                user.displayHash(sb, EMS.getBreaker(sensor));
                sb.append('}');
                return "data:{\"sensor\":{" + sb.toString() + "}}";
            }
            if (sa[1].equals("contactor")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                sb.append("\"contactor\":{");
                user.displayHash(sb, EMS.getContactor(sensor));
                sb.append('}');
                return "data:{\"sensor\":{" + sb.toString() + "}}";
            }
            if (sa[1].equals("generic")) {
                if (!user.checkUserRights(userid, "view")) {
                    return "data:noaccess";
                }
                sb.append("\"generic\":{");
                user.displayHash(sb, EMS.getGeneric(sensor));
                sb.append('}');
                return "data:{\"sensor\":{" + sb.toString() + "}}";
            }
            if (!sa[1].equals("state")) {
                return "data:error";
            }
            if (!user.checkUserRights(userid, "view")) {
                return "data:noaccess";
            }
            switch (sensor.modelid) {
                case 90: {
                    sb.append("\"state\":{");
                    user.displayHash(sb, M7TIC.displayIOState(sensor.gatewayaddress, sensor.address));
                    sb.append('}');
                    return "data:{\"sensor\":{" + sb.toString() + "}}";
                }
                case 91: {
                    sb.append("\"state\":{");
                    user.displayHash(sb, M7TIC.displayPROGState(sensor.gatewayaddress, sensor.address));
                    sb.append('}');
                    return "data:{\"sensor\":{" + sb.toString() + "}}";
                }
            }
            return "data:error";
        }
        catch (Exception e2) {
            return "data:error";
        }
    }

    public static String readEnergy(String userid, String param) throws Exception {
        String[] sa;
        block8: {
            sa = param.split(",");
            if (sa.length != 1 && sa.length != 2) {
                return "data:error";
            }
            if (!user.checkUserRights(userid, "view")) {
                return "data:noaccess";
            }
            try {
                if (!sa[0].equals("total")) break block8;
                StringBuffer energy = new StringBuffer();
                user.displayHash(energy, user.energyTotalView(0L));
                StringBuffer gas = new StringBuffer();
                user.displayHash(gas, user.gasTotalView(0L));
                StringBuffer water = new StringBuffer();
                user.displayHash(water, user.waterTotalView(0L));
                if (energy.length() > 0) {
                    return "data:{\"total\":{\"energy\":{" + energy.toString() + "},\"gas\":{" + gas.toString() + "},\"water\":{" + water.toString() + "}}}";
                }
                return "data:empty";
            }
            catch (Exception e2) {
                return "data:error";
            }
        }
        if (sa.length == 2) {
            StringBuffer partial = new StringBuffer();
            user.displayHash(partial, user.meterPartialView(0L, Integer.parseInt(sa[1]), Integer.parseInt(sa[0])));
            if (partial.length() > 0) {
                return "data:{\"partial\":{\"energy\":{" + partial.toString() + "}}}";
            }
            return "data:empty";
        }
        return "data:error";
    }

    public static Hashtable<String, String> energyView(long time, int sensorid) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        SensorCache sensor = Polling.sensorCache.get(sensorid);
        long energytotal = 0L;
        long costtotal = 0L;
        long[] todayenergy = new long[12];
        long[] yesterdayenergy = new long[12];
        long[] thismonthenergy = new long[31];
        long[] lastmonthenergy = new long[31];
        long[] thisyearenergy = new long[12];
        long[] lastyearenergy = new long[12];
        long[] todaycost = new long[12];
        long[] yesterdaycost = new long[12];
        long[] thismonthcost = new long[31];
        long[] lastmonthcost = new long[31];
        long[] thisyearcost = new long[12];
        long[] lastyearcost = new long[12];
        if (sensor == null) {
            sensor = Polling.sensorGet(sensorid);
        }
        try {
            PreparedStatement stmt;
            int costratetype;
            long now = time == 0L ? System.currentTimeMillis() : time;
            Calendar today = Calendar.getInstance();
            Calendar yesterday = Calendar.getInstance();
            Calendar lastmonth = Calendar.getInstance();
            Calendar lastyear = Calendar.getInstance();
            today.setTimeInMillis(now);
            int day = today.get(5);
            int month = today.get(2);
            int year = today.get(1);
            yesterday.setTimeInMillis(now - 86400000L);
            lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
            lastyear.setTimeInMillis(now);
            lastyear.set(1, year - 1);
            lastyear.set(2, 0);
            lastyear.set(5, 1);
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.set(13, 0);
            lastyear.set(14, 0);
            switch (sensor.loadid) {
                case -3: {
                    costratetype = 3;
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdatawater where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    break;
                }
                case -4: {
                    costratetype = 4;
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdatagas where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    break;
                }
                default: {
                    costratetype = 2;
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdata where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                }
            }
            stmt.setInt(1, sensorid);
            stmt.setTimestamp(2, new Timestamp(lastyear.getTimeInMillis()));
            stmt.setTimestamp(3, new Timestamp(now));
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                long energy = rs.getLong(5);
                long cost = CostRates.match(costratetype, -1, lyear, lmonth + 1, lday, lhour);
                long l2 = cost = cost < 0L ? -1L : energy * cost;
                if (lyear == year) {
                    int n2 = lmonth;
                    thisyearenergy[n2] = thisyearenergy[n2] + energy;
                    if (thisyearcost[lmonth] != -1L) {
                        thisyearcost[lmonth] = cost == -1L ? -1L : thisyearcost[lmonth] + cost;
                    }
                } else if (lyear == year - 1) {
                    int n3 = lmonth;
                    lastyearenergy[n3] = lastyearenergy[n3] + energy;
                    if (lastyearcost[lmonth] != -1L) {
                        long l3 = lastyearcost[lmonth] = cost == -1L ? -1L : lastyearcost[lmonth] + cost;
                    }
                }
                if (lyear == year && lmonth == month) {
                    int n4 = lday - 1;
                    thismonthenergy[n4] = thismonthenergy[n4] + energy;
                    if (thismonthcost[lday - 1] != -1L) {
                        thismonthcost[lday - 1] = cost == -1L ? -1L : thismonthcost[lday - 1] + cost;
                    }
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    int n5 = lday - 1;
                    lastmonthenergy[n5] = lastmonthenergy[n5] + energy;
                    if (lastmonthcost[lday - 1] != -1L) {
                        long l4 = lastmonthcost[lday - 1] = cost == -1L ? -1L : lastmonthcost[lday - 1] + cost;
                    }
                }
                if (lyear == year && lmonth == month && lday == day) {
                    int n6 = lhour / 2;
                    todayenergy[n6] = todayenergy[n6] + energy;
                    if (todaycost[lhour / 2] == -1L) continue;
                    todaycost[lhour / 2] = cost == -1L ? -1L : todaycost[lhour / 2] + cost;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                int n7 = lhour / 2;
                yesterdayenergy[n7] = yesterdayenergy[n7] + energy;
                if (yesterdaycost[lhour / 2] == -1L) continue;
                long l5 = yesterdaycost[lhour / 2] = cost == -1L ? -1L : yesterdaycost[lhour / 2] + cost;
            }
            rs.close();
            StringBuffer sb = new StringBuffer("[");
            StringBuffer sbc = new StringBuffer("[");
            int i2 = 0;
            while (i2 < todayenergy.length) {
                if (i2 > 0) {
                    energytotal += todayenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = todaycost[i2] == -1L ? -1L : costtotal + todaycost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = todayenergy[i2];
                    costtotal = todaycost[i2];
                }
                sb.append(todayenergy[i2]);
                sbc.append(todaycost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("today", sb.toString());
            values.put("todaycost", sbc.toString());
            values.put("todaytotalenergy", Long.toString(energytotal));
            values.put("todaytotalcost", costtotal == -1L ? "0" : Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < yesterdayenergy.length) {
                if (i2 > 0) {
                    energytotal += yesterdayenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = yesterdaycost[i2] == -1L ? -1L : costtotal + yesterdaycost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = yesterdayenergy[i2];
                    costtotal = yesterdaycost[i2];
                }
                sb.append(yesterdayenergy[i2]);
                sbc.append(yesterdaycost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("yesterday", sb.toString());
            values.put("yesterdaycost", sbc.toString());
            values.put("yesterdaytotalenergy", Long.toString(energytotal));
            values.put("yesterdaytotalcost", costtotal == -1L ? "0" : Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < thismonthenergy.length) {
                if (i2 > 0) {
                    energytotal += thismonthenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = thismonthcost[i2] == -1L ? -1L : costtotal + thismonthcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = thismonthenergy[i2];
                    costtotal = thismonthcost[i2];
                }
                sb.append(thismonthenergy[i2]);
                sbc.append(thismonthcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("thismonth", sb.toString());
            values.put("thismonthcost", sbc.toString());
            values.put("thismonthtotalenergy", Long.toString(energytotal));
            values.put("thismonthtotalcost", costtotal == -1L ? "0" : Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < lastmonthenergy.length) {
                if (i2 > 0) {
                    energytotal += lastmonthenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = lastmonthcost[i2] == -1L ? -1L : costtotal + lastmonthcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = lastmonthenergy[i2];
                    costtotal = lastmonthcost[i2];
                }
                sb.append(lastmonthenergy[i2]);
                sbc.append(lastmonthcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("lastmonth", sb.toString());
            values.put("lastmonthcost", sbc.toString());
            values.put("lastmonthtotalenergy", Long.toString(energytotal));
            values.put("lastmonthtotalcost", costtotal == -1L ? "0" : Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < thisyearenergy.length) {
                if (i2 > 0) {
                    energytotal += thisyearenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = thisyearcost[i2] == -1L ? -1L : costtotal + thisyearcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = thisyearenergy[i2];
                    costtotal = thisyearcost[i2];
                }
                sb.append(thisyearenergy[i2]);
                sbc.append(thisyearcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("thisyear", sb.toString());
            values.put("thisyearcost", sbc.toString());
            values.put("thisyeartotalenergy", Long.toString(energytotal));
            values.put("thisyeartotalcost", costtotal == -1L ? "0" : Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < lastyearenergy.length) {
                if (i2 > 0) {
                    energytotal += lastyearenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = lastyearcost[i2] == -1L ? -1L : costtotal + lastyearcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = lastyearenergy[i2];
                    costtotal = lastyearcost[i2];
                }
                sb.append(lastyearenergy[i2]);
                sbc.append(lastyearcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("lastyear", sb.toString());
            values.put("lastyearcost", sbc.toString());
            values.put("lastyeartotalenergy", Long.toString(energytotal));
            values.put("lastyeartotalcost", costtotal == -1L ? "0" : Double.toString(costtotal));
            return values;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static String energyDataLoggerLiveJSON(long time, int sensorid, int loadid, int groupid) throws Exception {
        boolean newdata;
        PreparedStatement stmt;
        String energycurrency;
        int costratetype;
        SensorCache sensor = Polling.sensorCache.get(sensorid);
        String unit = null;
        long ltimemax = 0L;
        long ltimemin = Long.MAX_VALUE;
        long energytotal = 0L;
        long costtotal = 0L;
        long energymax = 0L;
        long[] todayenergy = new long[12];
        long[] yesterdayenergy = new long[12];
        long[] thismonthenergy = new long[31];
        long[] lastmonthenergy = new long[31];
        long[] thisyearenergy = new long[12];
        long[] lastyearenergy = new long[12];
        long[] todaycost = new long[12];
        long[] yesterdaycost = new long[12];
        long[] thismonthcost = new long[31];
        long[] lastmonthcost = new long[31];
        long[] thisyearcost = new long[12];
        long[] lastyearcost = new long[12];
        try {
            if (sensor == null && sensorid != -1) {
                sensor = Polling.sensorGet(sensorid);
            }
            switch (sensorid != -1 ? sensor.loadid : loadid) {
                case -3: {
                    costratetype = 3;
                    unit = "dm3 m3 dam3 hm3 km3";
                    break;
                }
                case -4: {
                    costratetype = 4;
                    unit = "dm3 m3 dam3 hm3 km3";
                    break;
                }
                default: {
                    costratetype = 2;
                    unit = "Wh";
                }
            }
            energycurrency = user.varGet("energycurrency!");
        }
        catch (Exception e2) {
            costratetype = -1;
            energycurrency = "";
        }
        long now = System.currentTimeMillis();
        Calendar today = Calendar.getInstance();
        Calendar yesterday = Calendar.getInstance();
        Calendar lastmonth = Calendar.getInstance();
        Calendar lastyear = Calendar.getInstance();
        today.setTimeInMillis(now);
        int day = today.get(5);
        int month = today.get(2);
        int year = today.get(1);
        yesterday.setTimeInMillis(now - 86400000L);
        lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
        lastyear.setTimeInMillis(now);
        lastyear.set(1, year - 1);
        lastyear.set(2, 0);
        lastyear.set(5, 1);
        lastyear.set(11, 0);
        lastyear.set(12, 0);
        lastyear.set(13, 0);
        lastyear.set(14, 0);
        if (sensorid >= 0) {
            switch (sensor.loadid) {
                case -3: {
                    stmt = databaseConnection.prepareStatement("select min(ltime), max(ltime) from ensdatawater where sensorid = ?");
                    break;
                }
                case -4: {
                    stmt = databaseConnection.prepareStatement("select min(ltime), max(ltime) from ensdatagas where sensorid = ?");
                    break;
                }
                default: {
                    stmt = databaseConnection.prepareStatement("select min(ltime), max(ltime) from ensdata where sensorid = ?");
                }
            }
            stmt.setInt(1, sensorid);
        } else if (loadid == -2) {
            stmt = databaseConnection.prepareStatement("select min(ltime), max(ltime) from endata where groupid = ? and loadid >= -1");
            stmt.setInt(1, groupid);
        } else {
            stmt = databaseConnection.prepareStatement("select min(ltime), max(ltime) from endata where groupid = ? and loadid = ?");
            stmt.setInt(1, groupid);
            stmt.setInt(2, loadid);
        }
        ResultSet rs = stmt.executeQuery();
        if (rs.next() && rs.getTimestamp(1) != null) {
            ltimemin = rs.getTimestamp(1).getTime();
            ltimemax = rs.getTimestamp(2).getTime();
            newdata = ltimemax > time || now / 86400000L != time / 86400000L;
        } else {
            ltimemin = now;
            newdata = false;
        }
        rs.close();
        stmt.close();
        if (newdata) {
            if (sensorid >= 0) {
                switch (sensor.loadid) {
                    case -3: {
                        stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), max(ltime) from ensdatawater where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                        break;
                    }
                    case -4: {
                        stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), max(ltime) from ensdatagas where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                        break;
                    }
                    default: {
                        stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), max(ltime) from ensdata where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    }
                }
                stmt.setInt(1, sensorid);
                stmt.setTimestamp(2, new Timestamp(lastyear.getTimeInMillis()));
                stmt.setTimestamp(3, new Timestamp(now));
            } else if (loadid == -2) {
                stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), max(ltime) from endata where groupid = ? and loadid >= -1 and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                stmt.setInt(1, groupid);
                stmt.setTimestamp(2, new Timestamp(lastyear.getTimeInMillis()));
                stmt.setTimestamp(3, new Timestamp(now));
            } else {
                stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), max(ltime) from endata where groupid = ? and loadid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                stmt.setInt(1, groupid);
                stmt.setInt(2, loadid);
                stmt.setTimestamp(3, new Timestamp(lastyear.getTimeInMillis()));
                stmt.setTimestamp(4, new Timestamp(now));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                long cost;
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                long energy = rs.getLong(5);
                long l2 = rs.getTimestamp(6).getTime();
                if (l2 > ltimemax) {
                    ltimemax = l2;
                }
                if (l2 < ltimemin) {
                    ltimemin = l2;
                }
                long l3 = cost = (cost = (long)CostRates.match(costratetype, -1, lyear, lmonth + 1, lday, lhour)) < 0L ? -1L : energy * cost;
                if (lyear == year) {
                    int n2 = lmonth;
                    thisyearenergy[n2] = thisyearenergy[n2] + energy;
                    if (thisyearcost[lmonth] != -1L) {
                        thisyearcost[lmonth] = cost == -1L ? -1L : thisyearcost[lmonth] + cost;
                    }
                } else if (lyear == year - 1) {
                    int n3 = lmonth;
                    lastyearenergy[n3] = lastyearenergy[n3] + energy;
                    if (lastyearcost[lmonth] != -1L) {
                        long l4 = lastyearcost[lmonth] = cost == -1L ? -1L : lastyearcost[lmonth] + cost;
                    }
                }
                if (lyear == year && lmonth == month) {
                    int n4 = lday - 1;
                    thismonthenergy[n4] = thismonthenergy[n4] + energy;
                    if (thismonthcost[lday - 1] != -1L) {
                        thismonthcost[lday - 1] = cost == -1L ? -1L : thismonthcost[lday - 1] + cost;
                    }
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    int n5 = lday - 1;
                    lastmonthenergy[n5] = lastmonthenergy[n5] + energy;
                    if (lastmonthcost[lday - 1] != -1L) {
                        long l5 = lastmonthcost[lday - 1] = cost == -1L ? -1L : lastmonthcost[lday - 1] + cost;
                    }
                }
                if (lyear == year && lmonth == month && lday == day) {
                    int n6 = lhour / 2;
                    todayenergy[n6] = todayenergy[n6] + energy;
                    if (todaycost[lhour / 2] == -1L) continue;
                    todaycost[lhour / 2] = cost == -1L ? -1L : todaycost[lhour / 2] + cost;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                int n7 = lhour / 2;
                yesterdayenergy[n7] = yesterdayenergy[n7] + energy;
                if (yesterdaycost[lhour / 2] == -1L) continue;
                long l6 = yesterdaycost[lhour / 2] = cost == -1L ? -1L : yesterdaycost[lhour / 2] + cost;
            }
            rs.close();
            stmt.close();
        }
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"start\":\"");
        sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(ltimemin));
        sb.append("\"");
        sb.append(",\"maxresolution\":\"hour\"");
        sb.append(",\"monthconso\":\"");
        sb.append(DataProcessor.T3 / 86400000L);
        sb.append("\"");
        sb.append(",\"dayconso\":\"");
        sb.append(DataProcessor.T2 / 86400000L);
        sb.append("\"");
        sb.append(",\"hourconso\":\"");
        sb.append(DataProcessor.T1 / 86400000L);
        sb.append("\"");
        sb.append(",\"timestamp\":");
        sb.append(ltimemax);
        sb.append(",\"hour\":");
        sb.append(today.get(11));
        sb.append(",\"day\":");
        switch (today.get(7)) {
            case 2: {
                sb.append(0);
                break;
            }
            case 3: {
                sb.append(1);
                break;
            }
            case 4: {
                sb.append(2);
                break;
            }
            case 5: {
                sb.append(3);
                break;
            }
            case 6: {
                sb.append(4);
                break;
            }
            case 7: {
                sb.append(5);
                break;
            }
            case 1: {
                sb.append(6);
            }
        }
        sb.append(",\"month\":");
        sb.append(month);
        sb.append(",\"year\":");
        sb.append(year);
        if (newdata) {
            sb.append(",\"datalogger\":{\"type\":\"counter\"");
            sb.append(",\"day\":{\"present\":{\"values\":\"");
            int i2 = 0;
            while (i2 < todayenergy.length) {
                if (i2 > 0) {
                    energytotal += todayenergy[i2];
                    if (costtotal != -1L) {
                        long l7 = costtotal = todaycost[i2] == -1L ? -1L : costtotal + todaycost[i2];
                    }
                    if (todayenergy[i2] > energymax) {
                        energymax = todayenergy[i2];
                    }
                    sb.append(',');
                } else {
                    energymax = energytotal = todayenergy[i2];
                    costtotal = todaycost[i2];
                }
                sb.append(todayenergy[i2]);
                ++i2;
            }
            sb.append("\",\"total\":\"<b>");
            sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
            sb.append(" ");
            sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
            sb.append("</b>");
            sb.append("\",\"rangemin\":\"0\"");
            sb.append(",\"rangemax\":\"");
            sb.append(energymax);
            sb.append("\"},\"past\":{\"values\":\"");
            i2 = 0;
            while (i2 < yesterdayenergy.length) {
                if (i2 > 0) {
                    energytotal += yesterdayenergy[i2];
                    if (costtotal != -1L) {
                        long l8 = costtotal = yesterdaycost[i2] == -1L ? -1L : costtotal + yesterdaycost[i2];
                    }
                    if (yesterdayenergy[i2] > energymax) {
                        energymax = yesterdayenergy[i2];
                    }
                    sb.append(',');
                } else {
                    energymax = energytotal = yesterdayenergy[i2];
                    costtotal = yesterdaycost[i2];
                }
                sb.append(yesterdayenergy[i2]);
                ++i2;
            }
            sb.append("\",\"total\":\"<b>");
            sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
            sb.append(" ");
            sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
            sb.append("</b>");
            sb.append("\",\"rangemin\":\"0\"");
            sb.append(",\"rangemax\":\"");
            sb.append(energymax);
            sb.append("\"}}");
            sb.append(",\"month\":{\"present\":{\"values\":\"");
            i2 = 0;
            while (i2 < thismonthenergy.length) {
                if (i2 > 0) {
                    energytotal += thismonthenergy[i2];
                    if (costtotal != -1L) {
                        long l9 = costtotal = thismonthcost[i2] == -1L ? -1L : costtotal + thismonthcost[i2];
                    }
                    if (thismonthenergy[i2] > energymax) {
                        energymax = thismonthenergy[i2];
                    }
                    sb.append(',');
                } else {
                    energymax = energytotal = thismonthenergy[i2];
                    costtotal = thismonthcost[i2];
                }
                sb.append(thismonthenergy[i2]);
                ++i2;
            }
            sb.append("\",\"total\":\"<b>");
            sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
            sb.append(" ");
            sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
            sb.append("</b>");
            sb.append("\",\"rangemin\":\"0\"");
            sb.append(",\"rangemax\":\"");
            sb.append(energymax);
            sb.append("\"},\"past\":{\"values\":\"");
            i2 = 0;
            while (i2 < lastmonthenergy.length) {
                if (i2 > 0) {
                    energytotal += lastmonthenergy[i2];
                    if (costtotal != -1L) {
                        long l10 = costtotal = lastmonthcost[i2] == -1L ? -1L : costtotal + lastmonthcost[i2];
                    }
                    if (lastmonthenergy[i2] > energymax) {
                        energymax = lastmonthenergy[i2];
                    }
                    sb.append(',');
                } else {
                    energymax = energytotal = lastmonthenergy[i2];
                    costtotal = lastmonthcost[i2];
                }
                sb.append(lastmonthenergy[i2]);
                ++i2;
            }
            sb.append("\",\"total\":\"<b>");
            sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
            sb.append(" ");
            sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
            sb.append("</b>");
            sb.append("\",\"rangemin\":\"0\"");
            sb.append(",\"rangemax\":\"");
            sb.append(energymax);
            sb.append("\"}}");
            sb.append(",\"year\":{\"present\":{\"values\":\"");
            i2 = 0;
            while (i2 < thisyearenergy.length) {
                if (i2 > 0) {
                    energytotal += thisyearenergy[i2];
                    if (costtotal != -1L) {
                        long l11 = costtotal = thisyearcost[i2] == -1L ? -1L : costtotal + thisyearcost[i2];
                    }
                    if (thisyearenergy[i2] > energymax) {
                        energymax = thisyearenergy[i2];
                    }
                    sb.append(',');
                } else {
                    energymax = energytotal = thisyearenergy[i2];
                    costtotal = thisyearcost[i2];
                }
                sb.append(thisyearenergy[i2]);
                ++i2;
            }
            sb.append("\",\"total\":\"<b>");
            sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
            sb.append(" ");
            sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
            sb.append("</b>");
            sb.append("\",\"rangemin\":\"0\"");
            sb.append(",\"rangemax\":\"");
            sb.append(energymax);
            sb.append("\"},\"past\":{\"values\":\"");
            i2 = 0;
            while (i2 < lastyearenergy.length) {
                if (i2 > 0) {
                    energytotal += lastyearenergy[i2];
                    if (costtotal != -1L) {
                        long l12 = costtotal = lastyearcost[i2] == -1L ? -1L : costtotal + lastyearcost[i2];
                    }
                    if (lastyearenergy[i2] > energymax) {
                        energymax = lastyearenergy[i2];
                    }
                    sb.append(',');
                } else {
                    energymax = energytotal = lastyearenergy[i2];
                    costtotal = lastyearcost[i2];
                }
                sb.append(lastyearenergy[i2]);
                ++i2;
            }
            sb.append("\",\"total\":\"<b>");
            sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
            sb.append(" ");
            if (costtotal == -1L) {
                sb.append("0 ");
                sb.append(energycurrency);
            } else {
                sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
            }
            sb.append("</b>");
            sb.append("\",\"rangemin\":\"0\"");
            sb.append(",\"rangemax\":\"");
            sb.append(energymax);
            sb.append("\"}}}");
        } else {
            sb.append(",\"datalogger\":\"null\"");
        }
        sb.append("}");
        return sb.toString();
    }

    static String energyDataLoggerBrowserJSON(String resolution, String yyyymmdd, int sensorid, int loadid, int groupid) throws Exception {
        PreparedStatement stmt;
        String energycurrency;
        int costratetype;
        SensorCache sensor = Polling.sensorCache.get(sensorid);
        int resolutioncode = 0;
        String unit = null;
        long energytotal = 0L;
        long costtotal = 0L;
        long energymax = 0L;
        long[] periodenergy = null;
        long[] periodcost = null;
        try {
            if (sensor == null && sensorid != -1) {
                sensor = Polling.sensorGet(sensorid);
            }
            switch (sensorid != -1 ? sensor.loadid : loadid) {
                case -3: {
                    costratetype = 3;
                    unit = "dm3 m3 dam3 hm3 km3";
                    break;
                }
                case -4: {
                    costratetype = 4;
                    unit = "dm3 m3 dam3 hm3 km3";
                    break;
                }
                default: {
                    costratetype = 2;
                    unit = "Wh";
                }
            }
            energycurrency = user.varGet("energycurrency!");
        }
        catch (Exception e2) {
            costratetype = 1;
            energycurrency = "";
        }
        int year = Integer.parseInt(yyyymmdd.substring(0, 4));
        int month = Integer.parseInt(yyyymmdd.substring(4, 6));
        int day = Integer.parseInt(yyyymmdd.substring(6, 8));
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        if (resolution.equals("hour")) {
            periodenergy = new long[24];
            periodcost = new long[24];
            resolutioncode = 0;
            from.set(1, year);
            from.set(2, month - 1);
            from.set(5, day);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year);
            to.set(2, month - 1);
            to.set(5, day);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        } else if (resolution.equals("day")) {
            periodenergy = new long[31];
            periodcost = new long[31];
            resolutioncode = 1;
            from.set(1, year);
            from.set(2, month - 1);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year);
            to.set(2, month);
            to.set(5, 1);
            to.set(11, 0);
            to.set(12, 0);
            to.set(13, 0);
            to.set(14, 0);
            to.add(13, -1);
        } else if (resolution.equals("month")) {
            periodenergy = new long[12];
            periodcost = new long[12];
            resolutioncode = 2;
            from.set(1, year);
            from.set(2, 0);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year);
            to.set(2, 11);
            to.set(5, 31);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        } else if (resolution.equals("year")) {
            periodenergy = new long[10];
            periodcost = new long[10];
            resolutioncode = 3;
            from.set(1, year);
            from.set(2, 0);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year + 9);
            to.set(2, 11);
            to.set(5, 31);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        }
        if (sensorid >= 0) {
            switch (sensor.loadid) {
                case -3: {
                    stmt = databaseConnection.prepareStatement("select min(ltime) from ensdatawater where sensorid = ?");
                    break;
                }
                case -4: {
                    stmt = databaseConnection.prepareStatement("select min(ltime) from ensdatagas where sensorid = ?");
                    break;
                }
                default: {
                    stmt = databaseConnection.prepareStatement("select min(ltime) from ensdata where sensorid = ?");
                }
            }
            stmt.setInt(1, sensorid);
        } else if (loadid == -2) {
            stmt = databaseConnection.prepareStatement("select min(ltime) from endata where groupid = ? and loadid >= -1");
            stmt.setInt(1, groupid);
        } else {
            stmt = databaseConnection.prepareStatement("select min(ltime) from endata where groupid = ? and loadid = ?");
            stmt.setInt(1, groupid);
            stmt.setInt(2, loadid);
        }
        ResultSet rs = stmt.executeQuery();
        long ltimemin = rs.next() && rs.getTimestamp(1) != null ? rs.getTimestamp(1).getTime() : System.currentTimeMillis();
        rs.close();
        stmt.close();
        if (sensorid >= 0) {
            switch (sensor.loadid) {
                case -3: {
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdatawater where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    break;
                }
                case -4: {
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdatagas where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    break;
                }
                default: {
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdata where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                }
            }
            stmt.setInt(1, sensorid);
            stmt.setTimestamp(2, new Timestamp(from.getTimeInMillis()));
            stmt.setTimestamp(3, new Timestamp(to.getTimeInMillis()));
        } else if (loadid == -2) {
            stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = ? and loadid >= -1 and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
            stmt.setInt(1, groupid);
            stmt.setTimestamp(2, new Timestamp(from.getTimeInMillis()));
            stmt.setTimestamp(3, new Timestamp(to.getTimeInMillis()));
        } else {
            stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = ? and loadid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
            stmt.setInt(1, groupid);
            stmt.setInt(2, loadid);
            stmt.setTimestamp(3, new Timestamp(from.getTimeInMillis()));
            stmt.setTimestamp(4, new Timestamp(to.getTimeInMillis()));
        }
        rs = stmt.executeQuery();
        while (rs.next()) {
            short lyear = rs.getShort(1);
            int lmonth = rs.getShort(2) - 1;
            int lday = rs.getShort(3) - 1;
            short lhour = rs.getShort(4);
            long energy = rs.getLong(5);
            long cost = CostRates.match(costratetype, -1, lyear, lmonth + 1, lday + 1, lhour);
            cost = cost < 0L ? -1L : energy * cost;
            switch (resolutioncode) {
                case 0: {
                    short s = lhour;
                    periodenergy[s] = periodenergy[s] + energy;
                    if (periodcost[lhour] == -1L) break;
                    periodcost[lhour] = cost == -1L ? -1L : periodcost[lhour] + cost;
                    break;
                }
                case 1: {
                    int n2 = lday;
                    periodenergy[n2] = periodenergy[n2] + energy;
                    if (periodcost[lday] == -1L) break;
                    periodcost[lday] = cost == -1L ? -1L : periodcost[lday] + cost;
                    break;
                }
                case 2: {
                    int n3 = lmonth;
                    periodenergy[n3] = periodenergy[n3] + energy;
                    if (periodcost[lmonth] == -1L) break;
                    periodcost[lmonth] = cost == -1L ? -1L : periodcost[lmonth] + cost;
                    break;
                }
                case 3: {
                    int n4 = lyear - from.get(1);
                    periodenergy[n4] = periodenergy[n4] + energy;
                    if (periodcost[lyear - from.get(1)] == -1L) break;
                    long l2 = periodcost[lyear - from.get((int)1)] = cost == -1L ? -1L : periodcost[lyear - from.get(1)] + cost;
                }
            }
        }
        rs.close();
        stmt.close();
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"start\":\"");
        sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(ltimemin));
        sb.append("\"");
        sb.append(",\"maxresolution\":\"hour\"");
        sb.append(",\"monthconso\":\"");
        sb.append(DataProcessor.T3 / 86400000L);
        sb.append("\"");
        sb.append(",\"dayconso\":\"");
        sb.append(DataProcessor.T2 / 86400000L);
        sb.append("\"");
        sb.append(",\"hourconso\":\"");
        sb.append(DataProcessor.T1 / 86400000L);
        sb.append("\"");
        sb.append(",\"datalogger\":{\"type\":\"counter\"");
        sb.append(",\"browser\":{\"data\":{\"values\":\"");
        int i2 = 0;
        while (i2 < periodenergy.length) {
            if (i2 > 0) {
                energytotal += periodenergy[i2];
                if (costtotal != -1L) {
                    long l3 = costtotal = periodcost[i2] == -1L ? -1L : costtotal + periodcost[i2];
                }
                if (periodenergy[i2] > energymax) {
                    energymax = periodenergy[i2];
                }
                sb.append(',');
            } else {
                energymax = energytotal = periodenergy[i2];
                costtotal = periodcost[i2];
            }
            sb.append(periodenergy[i2]);
            ++i2;
        }
        sb.append("\",\"total\":\"<b>");
        sb.append(user.numberToStringUnitScaling(energytotal, energymax, unit));
        sb.append(" ");
        if (costtotal == -1L) {
            sb.append("0 ");
            sb.append(energycurrency);
        } else {
            sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costtotal / 1000000.0, energycurrency));
        }
        sb.append("</b>");
        sb.append("\",\"rangemin\":\"0\"");
        sb.append(",\"rangemax\":\"");
        sb.append(energymax);
        sb.append("\"}}}");
        sb.append("}");
        return sb.toString();
    }

    static String costDataLoggerBrowserJSON(String resolution, String yyyymmdd, int sensorid, int loadid, int groupid, int rateid) throws Exception {
        long ltimemin;
        PreparedStatement stmt;
        String energycurrency;
        int ratetype;
        DecimalFormat df = new DecimalFormat("0.##");
        SensorCache sensor = Polling.sensorCache.get(sensorid);
        int resolutioncode = 0;
        long costtotal = 0L;
        long costmax = 0L;
        long[] periodcost = null;
        try {
            if (sensor == null && sensorid != -1) {
                sensor = Polling.sensorGet(sensorid);
            }
            switch (sensorid != -1 ? sensor.loadid : loadid) {
                case -3: {
                    ratetype = 3;
                    break;
                }
                case -4: {
                    ratetype = 4;
                    break;
                }
                default: {
                    ratetype = 2;
                }
            }
            energycurrency = user.varGet("energycurrency!");
        }
        catch (Exception e2) {
            return null;
        }
        int year = Integer.parseInt(yyyymmdd.substring(0, 4));
        int month = Integer.parseInt(yyyymmdd.substring(4, 6));
        int day = Integer.parseInt(yyyymmdd.substring(6, 8));
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        Calendar begin = CostRates.getBeginDate();
        if (resolution.equals("hour")) {
            periodcost = new long[24];
            resolutioncode = 0;
            from.set(1, year);
            from.set(2, month - 1);
            from.set(5, day);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            if (from.compareTo(begin) < 0) {
                from.setTime(begin.getTime());
                from.set(11, 0);
                from.set(12, 0);
                from.set(13, 0);
                from.set(14, 0);
                from.add(5, 1);
            }
            to.set(1, year);
            to.set(2, month - 1);
            to.set(5, day);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        } else if (resolution.equals("day")) {
            periodcost = new long[31];
            resolutioncode = 1;
            from.set(1, year);
            from.set(2, month - 1);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            if (from.compareTo(begin) < 0) {
                from.setTime(begin.getTime());
                from.set(11, 0);
                from.set(12, 0);
                from.set(13, 0);
                from.set(14, 0);
                from.add(5, 1);
            }
            to.set(1, year);
            to.set(2, month);
            to.set(5, 1);
            to.set(11, 0);
            to.set(12, 0);
            to.set(13, 0);
            to.set(14, 0);
            to.add(13, -1);
        } else if (resolution.equals("month")) {
            periodcost = new long[12];
            resolutioncode = 2;
            from.set(1, year);
            from.set(2, 0);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            if (from.compareTo(begin) < 0) {
                from.setTime(begin.getTime());
                from.set(5, 1);
                from.set(11, 0);
                from.set(12, 0);
                from.set(13, 0);
                from.set(14, 0);
                from.add(2, 1);
            }
            to.set(1, year);
            to.set(2, 11);
            to.set(5, 31);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        } else if (resolution.equals("year")) {
            periodcost = new long[10];
            resolutioncode = 3;
            from.set(1, year);
            from.set(2, 0);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            if (from.compareTo(begin) < 0) {
                from.setTime(begin.getTime());
                from.set(2, 0);
                from.set(5, 1);
                from.set(11, 0);
                from.set(12, 0);
                from.set(13, 0);
                from.set(14, 0);
                from.add(1, 1);
            }
            to.set(1, year + 9);
            to.set(2, 11);
            to.set(5, 31);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        }
        if (sensorid >= 0) {
            switch (sensor.loadid) {
                case -3: {
                    stmt = databaseConnection.prepareStatement("select min(ltime) from ensdatawater where sensorid = ?");
                    break;
                }
                case -4: {
                    stmt = databaseConnection.prepareStatement("select min(ltime) from ensdatagas where sensorid = ?");
                    break;
                }
                default: {
                    stmt = databaseConnection.prepareStatement("select min(ltime) from ensdata where sensorid = ?");
                }
            }
            stmt.setInt(1, sensorid);
        } else if (loadid == -2) {
            stmt = databaseConnection.prepareStatement("select min(ltime) from endata where groupid = ? and loadid >= -1");
            stmt.setInt(1, groupid);
        } else {
            stmt = databaseConnection.prepareStatement("select min(ltime) from endata where groupid = ? and loadid = ?");
            stmt.setInt(1, groupid);
            stmt.setInt(2, loadid);
        }
        ResultSet rs = stmt.executeQuery();
        if (rs.next() && rs.getTimestamp(1) != null) {
            Calendar c2;
            ltimemin = rs.getTimestamp(1).getTime();
            if (ltimemin < (c2 = CostRates.getBeginDate()).getTimeInMillis()) {
                ltimemin = c2.getTimeInMillis();
            }
        } else {
            ltimemin = System.currentTimeMillis();
        }
        rs.close();
        stmt.close();
        if (sensorid >= 0) {
            switch (sensor.loadid) {
                case -3: {
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdatawater where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    break;
                }
                case -4: {
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdatagas where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                    break;
                }
                default: {
                    stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from ensdata where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                }
            }
            stmt.setInt(1, sensorid);
            stmt.setTimestamp(2, new Timestamp(from.getTimeInMillis()));
            stmt.setTimestamp(3, new Timestamp(to.getTimeInMillis()));
        } else if (loadid == -2) {
            stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = ? and loadid >= -1 and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
            stmt.setInt(1, groupid);
            stmt.setTimestamp(2, new Timestamp(from.getTimeInMillis()));
            stmt.setTimestamp(3, new Timestamp(to.getTimeInMillis()));
        } else {
            stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = ? and loadid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
            stmt.setInt(1, groupid);
            stmt.setInt(2, loadid);
            stmt.setTimestamp(3, new Timestamp(from.getTimeInMillis()));
            stmt.setTimestamp(4, new Timestamp(to.getTimeInMillis()));
        }
        rs = stmt.executeQuery();
        while (rs.next()) {
            int cost = CostRates.match(ratetype, rateid, rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4));
            if (cost == -1) continue;
            switch (resolutioncode) {
                case 0: {
                    short s = rs.getShort(4);
                    periodcost[s] = periodcost[s] + rs.getLong(5) * (long)cost;
                    break;
                }
                case 1: {
                    int n2 = rs.getShort(3) - 1;
                    periodcost[n2] = periodcost[n2] + rs.getLong(5) * (long)cost;
                    break;
                }
                case 2: {
                    int n3 = rs.getShort(2) - 1;
                    periodcost[n3] = periodcost[n3] + rs.getLong(5) * (long)cost;
                    break;
                }
                case 3: {
                    int n4 = rs.getShort(1) - year;
                    periodcost[n4] = periodcost[n4] + rs.getLong(5) * (long)cost;
                }
            }
        }
        rs.close();
        stmt.close();
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"start\":\"");
        sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(ltimemin));
        sb.append("\"");
        sb.append(",\"maxresolution\":\"hour\"");
        sb.append(",\"monthconso\":\"");
        sb.append(31L + DataProcessor.T3 / 86400000L);
        sb.append("\"");
        sb.append(",\"dayconso\":\"");
        sb.append(31L + DataProcessor.T2 / 86400000L);
        sb.append("\"");
        sb.append(",\"hourconso\":\"");
        sb.append(DataProcessor.T1 / 86400000L);
        sb.append("\"");
        sb.append(",\"datalogger\":{\"type\":\"counter\"");
        sb.append(",\"browser\":{\"data\":{\"values\":\"");
        int i2 = 0;
        while (i2 < periodcost.length) {
            if (i2 > 0) {
                costtotal += periodcost[i2];
                if (periodcost[i2] > costmax) {
                    costmax = periodcost[i2];
                }
                sb.append(',');
            } else {
                costmax = costtotal = periodcost[i2];
            }
            sb.append(df.format((double)periodcost[i2] / 1000000.0));
            ++i2;
        }
        sb.append("\",\"total\":\"<b>");
        sb.append(user.numberToStringUnitScaling((double)costtotal / 1000000.0, (double)costmax / 1000000.0, energycurrency));
        sb.append("</b>");
        sb.append("\",\"rangemin\":\"0\"");
        sb.append(",\"rangemax\":\"");
        sb.append(Math.ceil((double)costmax / 1000000.0));
        sb.append("\"}}}");
        sb.append("}");
        return sb.toString();
    }

    static String pfDataLoggerLiveJSON(long time, int sensorid) throws Exception {
        boolean newdata;
        DecimalFormat df = new DecimalFormat("0.##");
        long ltimemax = 0L;
        long ltimemin = Long.MAX_VALUE;
        double datamin = 0.0;
        double datamax = 0.0;
        long[] todaydata = new long[12];
        long[] yesterdaydata = new long[12];
        long[] thismonthdata = new long[31];
        long[] lastmonthdata = new long[31];
        long[] thisyeardata = new long[12];
        long[] lastyeardata = new long[12];
        int[] todaysamples = new int[12];
        int[] yesterdaysamples = new int[12];
        int[] thismonthsamples = new int[31];
        int[] lastmonthsamples = new int[31];
        int[] thisyearsamples = new int[12];
        int[] lastyearsamples = new int[12];
        long now = System.currentTimeMillis();
        Calendar today = Calendar.getInstance();
        Calendar yesterday = Calendar.getInstance();
        Calendar lastmonth = Calendar.getInstance();
        Calendar lastyear = Calendar.getInstance();
        today.setTimeInMillis(now);
        int day = today.get(5);
        int month = today.get(2);
        int year = today.get(1);
        yesterday.setTimeInMillis(now - 86400000L);
        lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
        lastyear.setTimeInMillis(now);
        lastyear.set(1, year - 1);
        lastyear.set(2, 0);
        lastyear.set(5, 1);
        lastyear.set(11, 0);
        lastyear.set(12, 0);
        lastyear.set(13, 0);
        lastyear.set(14, 0);
        PreparedStatement stmt = databaseConnection.prepareStatement("select min(ltime), max(ltime) from pfsdata where sensorid = ?");
        stmt.setInt(1, sensorid);
        ResultSet rs = stmt.executeQuery();
        if (rs.next() && rs.getTimestamp(1) != null) {
            ltimemin = rs.getTimestamp(1).getTime();
            ltimemax = rs.getTimestamp(2).getTime();
            newdata = ltimemax > time || now / 86400000L != time / 86400000L;
        } else {
            ltimemin = now;
            newdata = false;
        }
        rs.close();
        stmt.close();
        if (newdata) {
            stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), sum(samples), max(ltime) from pfsdata where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
            stmt.setInt(1, sensorid);
            stmt.setTimestamp(2, new Timestamp(lastyear.getTimeInMillis()));
            stmt.setTimestamp(3, new Timestamp(now));
            rs = stmt.executeQuery();
            while (rs.next()) {
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                long value = rs.getLong(5);
                int samples = rs.getInt(6);
                long l2 = rs.getTimestamp(7).getTime();
                if (l2 > ltimemax) {
                    ltimemax = l2;
                }
                if (l2 < ltimemin) {
                    ltimemin = l2;
                }
                if (lyear == year) {
                    int n2 = lmonth;
                    thisyeardata[n2] = thisyeardata[n2] + value;
                    int n3 = lmonth;
                    thisyearsamples[n3] = thisyearsamples[n3] + samples;
                } else if (lyear == year - 1) {
                    int n4 = lmonth;
                    lastyeardata[n4] = lastyeardata[n4] + value;
                    int n5 = lmonth;
                    lastyearsamples[n5] = lastyearsamples[n5] + samples;
                }
                if (lyear == year && lmonth == month) {
                    int n6 = lday - 1;
                    thismonthdata[n6] = thismonthdata[n6] + value;
                    int n7 = lday - 1;
                    thismonthsamples[n7] = thismonthsamples[n7] + samples;
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    int n8 = lday - 1;
                    lastmonthdata[n8] = lastmonthdata[n8] + value;
                    int n9 = lday - 1;
                    lastmonthsamples[n9] = lastmonthsamples[n9] + samples;
                }
                if (lyear == year && lmonth == month && lday == day) {
                    int n10 = lhour / 2;
                    todaydata[n10] = todaydata[n10] + value;
                    int n11 = lhour / 2;
                    todaysamples[n11] = todaysamples[n11] + samples;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                int n12 = lhour / 2;
                yesterdaydata[n12] = yesterdaydata[n12] + value;
                int n13 = lhour / 2;
                yesterdaysamples[n13] = yesterdaysamples[n13] + samples;
            }
            rs.close();
            stmt.close();
        }
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"start\":\"");
        sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(ltimemin));
        sb.append("\"");
        sb.append(",\"maxresolution\":\"hour\"");
        sb.append(",\"monthconso\":\"");
        sb.append(DataProcessor.T3 / 86400000L);
        sb.append("\"");
        sb.append(",\"dayconso\":\"");
        sb.append(DataProcessor.T2 / 86400000L);
        sb.append("\"");
        sb.append(",\"hourconso\":\"");
        sb.append(DataProcessor.T1 / 86400000L);
        sb.append("\"");
        sb.append(",\"timestamp\":");
        sb.append(ltimemax);
        sb.append(",\"hour\":");
        sb.append(today.get(11));
        sb.append(",\"day\":");
        switch (today.get(7)) {
            case 2: {
                sb.append(0);
                break;
            }
            case 3: {
                sb.append(1);
                break;
            }
            case 4: {
                sb.append(2);
                break;
            }
            case 5: {
                sb.append(3);
                break;
            }
            case 6: {
                sb.append(4);
                break;
            }
            case 7: {
                sb.append(5);
                break;
            }
            case 1: {
                sb.append(6);
            }
        }
        sb.append(",\"month\":");
        sb.append(month);
        sb.append(",\"year\":");
        sb.append(year);
        if (newdata) {
            double d2;
            sb.append(",\"datalogger\":{\"type\":\"range\",\"origin\":\"auto\"");
            sb.append(",\"day\":{\"avg\":{\"present\":{\"values\":\"");
            boolean availabledata = false;
            int i2 = 0;
            while (i2 < todaydata.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                if (todaysamples[i2] > 0) {
                    d2 = (double)todaydata[i2] / (double)todaysamples[i2] / 10000.0;
                    if (availabledata) {
                        if (d2 > datamax) {
                            datamax = d2;
                        }
                        if (d2 < datamin) {
                            datamin = d2;
                        }
                    } else {
                        availabledata = true;
                        datamin = datamax = d2;
                    }
                    sb.append(df.format(d2));
                }
                ++i2;
            }
            sb.append("\",\"total\":\"");
            if (availabledata) {
                sb.append("\",\"rangemin\":\"");
                sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
                sb.append("\",\"rangemax\":\"");
                sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
            }
            sb.append("\"},\"past\":{\"values\":\"");
            availabledata = false;
            i2 = 0;
            while (i2 < yesterdaydata.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                if (yesterdaysamples[i2] > 0) {
                    d2 = (double)yesterdaydata[i2] / (double)yesterdaysamples[i2] / 10000.0;
                    if (availabledata) {
                        if (d2 > datamax) {
                            datamax = d2;
                        }
                        if (d2 < datamin) {
                            datamin = d2;
                        }
                    } else {
                        availabledata = true;
                        datamin = datamax = d2;
                    }
                    sb.append(df.format(d2));
                }
                ++i2;
            }
            sb.append("\",\"total\":\"");
            if (availabledata) {
                sb.append("\",\"rangemin\":\"");
                sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
                sb.append("\",\"rangemax\":\"");
                sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
            }
            sb.append("\"}}}");
            sb.append(",\"month\":{\"avg\":{\"present\":{\"values\":\"");
            availabledata = false;
            i2 = 0;
            while (i2 < thismonthdata.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                if (thismonthsamples[i2] > 0) {
                    d2 = (double)thismonthdata[i2] / (double)thismonthsamples[i2] / 10000.0;
                    if (availabledata) {
                        if (d2 > datamax) {
                            datamax = d2;
                        }
                        if (d2 < datamin) {
                            datamin = d2;
                        }
                    } else {
                        availabledata = true;
                        datamin = datamax = d2;
                    }
                    sb.append(df.format(d2));
                }
                ++i2;
            }
            sb.append("\",\"total\":\"");
            if (availabledata) {
                sb.append("\",\"rangemin\":\"");
                sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
                sb.append("\",\"rangemax\":\"");
                sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
            }
            sb.append("\"},\"past\":{\"values\":\"");
            availabledata = false;
            i2 = 0;
            while (i2 < lastmonthdata.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                if (lastmonthsamples[i2] > 0) {
                    d2 = (double)lastmonthdata[i2] / (double)lastmonthsamples[i2] / 10000.0;
                    if (availabledata) {
                        if (d2 > datamax) {
                            datamax = d2;
                        }
                        if (d2 < datamin) {
                            datamin = d2;
                        }
                    } else {
                        availabledata = true;
                        datamin = datamax = d2;
                    }
                    sb.append(df.format(d2));
                }
                ++i2;
            }
            sb.append("\",\"total\":\"");
            if (availabledata) {
                sb.append("\",\"rangemin\":\"");
                sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
                sb.append("\",\"rangemax\":\"");
                sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
            }
            sb.append("\"}}}");
            sb.append(",\"year\":{\"avg\":{\"present\":{\"values\":\"");
            availabledata = false;
            i2 = 0;
            while (i2 < thisyeardata.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                if (thisyearsamples[i2] > 0) {
                    d2 = (double)thisyeardata[i2] / (double)thisyearsamples[i2] / 10000.0;
                    if (availabledata) {
                        if (d2 > datamax) {
                            datamax = d2;
                        }
                        if (d2 < datamin) {
                            datamin = d2;
                        }
                    } else {
                        availabledata = true;
                        datamin = datamax = d2;
                    }
                    sb.append(df.format(d2));
                }
                ++i2;
            }
            sb.append("\",\"total\":\"");
            if (availabledata) {
                sb.append("\",\"rangemin\":\"");
                sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
                sb.append("\",\"rangemax\":\"");
                sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
            }
            sb.append("\"},\"past\":{\"values\":\"");
            availabledata = false;
            i2 = 0;
            while (i2 < lastyeardata.length) {
                if (i2 > 0) {
                    sb.append(',');
                }
                if (lastyearsamples[i2] > 0) {
                    d2 = (double)lastyeardata[i2] / (double)lastyearsamples[i2] / 10000.0;
                    if (availabledata) {
                        if (d2 > datamax) {
                            datamax = d2;
                        }
                        if (d2 < datamin) {
                            datamin = d2;
                        }
                    } else {
                        availabledata = true;
                        datamin = datamax = d2;
                    }
                    sb.append(df.format(d2));
                }
                ++i2;
            }
            sb.append("\",\"total\":\"");
            if (availabledata) {
                sb.append("\",\"rangemin\":\"");
                sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
                sb.append("\",\"rangemax\":\"");
                sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
            }
            sb.append("\"}}}}");
        } else {
            sb.append(",\"datalogger\":\"null\"");
        }
        sb.append("}");
        return sb.toString();
    }

    static String pfDataLoggerBrowserJSON(String resolution, String yyyymmdd, int sensorid) throws Exception {
        DecimalFormat df = new DecimalFormat("0.##");
        int resolutioncode = 0;
        double datamin = 0.0;
        double datamax = 0.0;
        long[] perioddata = null;
        int[] periodsamples = null;
        int year = Integer.parseInt(yyyymmdd.substring(0, 4));
        int month = Integer.parseInt(yyyymmdd.substring(4, 6));
        int day = Integer.parseInt(yyyymmdd.substring(6, 8));
        Calendar from = Calendar.getInstance();
        Calendar to = Calendar.getInstance();
        if (resolution.equals("hour")) {
            perioddata = new long[24];
            periodsamples = new int[24];
            resolutioncode = 0;
            from.set(1, year);
            from.set(2, month - 1);
            from.set(5, day);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year);
            to.set(2, month - 1);
            to.set(5, day);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        } else if (resolution.equals("day")) {
            perioddata = new long[31];
            periodsamples = new int[31];
            resolutioncode = 1;
            from.set(1, year);
            from.set(2, month - 1);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year);
            to.set(2, month);
            to.set(5, 1);
            to.set(11, 0);
            to.set(12, 0);
            to.set(13, 0);
            to.set(14, 0);
            to.add(13, -1);
        } else if (resolution.equals("month")) {
            perioddata = new long[12];
            periodsamples = new int[12];
            resolutioncode = 2;
            from.set(1, year);
            from.set(2, 0);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year);
            to.set(2, 11);
            to.set(5, 31);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        } else if (resolution.equals("year")) {
            perioddata = new long[10];
            periodsamples = new int[10];
            resolutioncode = 3;
            from.set(1, year);
            from.set(2, 0);
            from.set(5, 1);
            from.set(11, 0);
            from.set(12, 0);
            from.set(13, 0);
            from.set(14, 0);
            to.set(1, year + 9);
            to.set(2, 11);
            to.set(5, 31);
            to.set(11, 23);
            to.set(12, 59);
            to.set(13, 59);
            to.set(14, 0);
        }
        PreparedStatement stmt = databaseConnection.prepareStatement("select min(ltime) from pfsdata where sensorid = ?");
        stmt.setInt(1, sensorid);
        ResultSet rs = stmt.executeQuery();
        long ltimemin = rs.next() && rs.getTimestamp(1) != null ? rs.getTimestamp(1).getTime() : System.currentTimeMillis();
        rs.close();
        stmt.close();
        stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr), sum(samples) from pfsdata where sensorid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
        stmt.setInt(1, sensorid);
        stmt.setTimestamp(2, new Timestamp(from.getTimeInMillis()));
        stmt.setTimestamp(3, new Timestamp(to.getTimeInMillis()));
        rs = stmt.executeQuery();
        while (rs.next()) {
            switch (resolutioncode) {
                case 0: {
                    short s = rs.getShort(4);
                    perioddata[s] = perioddata[s] + rs.getLong(5);
                    short s2 = rs.getShort(4);
                    periodsamples[s2] = periodsamples[s2] + rs.getInt(6);
                    break;
                }
                case 1: {
                    int n2 = rs.getShort(3) - 1;
                    perioddata[n2] = perioddata[n2] + rs.getLong(5);
                    int n3 = rs.getShort(3) - 1;
                    periodsamples[n3] = periodsamples[n3] + rs.getInt(6);
                    break;
                }
                case 2: {
                    int n4 = rs.getShort(2) - 1;
                    perioddata[n4] = perioddata[n4] + rs.getLong(5);
                    int n5 = rs.getShort(3) - 1;
                    periodsamples[n5] = periodsamples[n5] + rs.getInt(6);
                    break;
                }
                case 3: {
                    int n6 = rs.getShort(1) - from.get(1);
                    perioddata[n6] = perioddata[n6] + rs.getLong(5);
                    int n7 = rs.getShort(1) - from.get(1);
                    periodsamples[n7] = periodsamples[n7] + rs.getInt(6);
                }
            }
        }
        rs.close();
        stmt.close();
        StringBuffer sb = new StringBuffer("{");
        sb.append("\"start\":\"");
        sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(ltimemin));
        sb.append("\"");
        sb.append(",\"maxresolution\":\"hour\"");
        sb.append(",\"monthconso\":\"");
        sb.append(DataProcessor.T3 / 86400000L);
        sb.append("\"");
        sb.append(",\"dayconso\":\"");
        sb.append(DataProcessor.T2 / 86400000L);
        sb.append("\"");
        sb.append(",\"hourconso\":\"");
        sb.append(DataProcessor.T1 / 86400000L);
        sb.append("\"");
        sb.append(",\"datalogger\":{\"type\":\"range\",\"origin\":\"auto\"");
        sb.append(",\"browser\":{\"avg\":{\"data\":{\"values\":\"");
        boolean availabledata = false;
        int i2 = 0;
        while (i2 < perioddata.length) {
            if (i2 > 0) {
                sb.append(',');
            }
            if (periodsamples[i2] > 0) {
                double d2 = (double)perioddata[i2] / (double)periodsamples[i2] / 10000.0;
                if (availabledata) {
                    if (d2 > datamax) {
                        datamax = d2;
                    }
                    if (d2 < datamin) {
                        datamin = d2;
                    }
                } else {
                    availabledata = true;
                    datamin = datamax = d2;
                }
                sb.append(df.format(d2));
            }
            ++i2;
        }
        sb.append("\",\"total\":\"");
        if (availabledata) {
            sb.append("\",\"rangemin\":\"");
            sb.append(df.format(datamin == -1.0 ? datamin : datamin - 0.01));
            sb.append("\",\"rangemax\":\"");
            sb.append(df.format(datamax == 1.0 ? datamax : datamax + 0.01));
        }
        sb.append("\"}}}}");
        sb.append("}");
        return sb.toString();
    }

    private static String numberToStringUnitScaling(double value, double scalevalue, String unit) {
        DecimalFormat df = new DecimalFormat("0.##");
        try {
            String[] unitArray = unit.split(" ");
            if (scalevalue >= 1.0E12) {
                return String.valueOf(df.format(value / 1.0E12)) + " " + (unitArray.length > 4 ? unitArray[4] : "T" + unit);
            }
            if (scalevalue >= 1.0E9) {
                return String.valueOf(df.format(value / 1.0E9)) + " " + (unitArray.length > 3 ? unitArray[3] : "G" + unit);
            }
            if (scalevalue >= 1000000.0) {
                return String.valueOf(df.format(value / 1000000.0)) + " " + (unitArray.length > 2 ? unitArray[2] : "M" + unit);
            }
            if (scalevalue >= 1000.0) {
                return String.valueOf(df.format(value / 1000.0)) + " " + (unitArray.length > 1 ? unitArray[1] : "k" + unit);
            }
            return String.valueOf(df.format(value)) + " " + unitArray[0];
        }
        catch (Exception e2) {
            return Double.toString(value);
        }
    }

    static Hashtable<String, String> meterPartialView(long time, int loadid, int groupid) {
        int costratetype;
        Hashtable<String, String> values = new Hashtable<String, String>();
        long energytotal = 0L;
        long costtotal = 0L;
        long[] todayenergy = new long[12];
        long[] yesterdayenergy = new long[12];
        long[] thismonthenergy = new long[31];
        long[] lastmonthenergy = new long[31];
        long[] thisyearenergy = new long[12];
        long[] lastyearenergy = new long[12];
        long[] todaycost = new long[12];
        long[] yesterdaycost = new long[12];
        long[] thismonthcost = new long[31];
        long[] lastmonthcost = new long[31];
        long[] thisyearcost = new long[12];
        long[] lastyearcost = new long[12];
        switch (loadid) {
            case -3: {
                costratetype = 3;
                break;
            }
            case -4: {
                costratetype = 4;
                break;
            }
            default: {
                costratetype = 2;
            }
        }
        try {
            PreparedStatement stmt;
            long now = time == 0L ? System.currentTimeMillis() : time;
            Calendar today = Calendar.getInstance();
            Calendar yesterday = Calendar.getInstance();
            Calendar lastmonth = Calendar.getInstance();
            Calendar lastyear = Calendar.getInstance();
            today.setTimeInMillis(now);
            int day = today.get(5);
            int month = today.get(2);
            int year = today.get(1);
            yesterday.setTimeInMillis(now - 86400000L);
            lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
            lastyear.setTimeInMillis(now);
            lastyear.set(1, year - 1);
            lastyear.set(2, 0);
            lastyear.set(5, 1);
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.set(13, 0);
            lastyear.set(14, 0);
            if (loadid == -2) {
                stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = ? and loadid >= -1 and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                stmt.setInt(1, groupid);
                stmt.setTimestamp(2, new Timestamp(lastyear.getTimeInMillis()));
                stmt.setTimestamp(3, new Timestamp(now));
            } else {
                stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = ? and loadid = ? and ltime >= ? and ltime <= ? group by lyear, lmonth, lday, lhour");
                stmt.setInt(1, groupid);
                stmt.setInt(2, loadid);
                stmt.setTimestamp(3, new Timestamp(lastyear.getTimeInMillis()));
                stmt.setTimestamp(4, new Timestamp(now));
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                long energy = rs.getLong(5);
                long cost = CostRates.match(costratetype, -1, lyear, lmonth + 1, lday, lhour);
                long l2 = cost = cost < 0L ? -1L : energy * cost;
                if (lyear == year) {
                    int n2 = lmonth;
                    thisyearenergy[n2] = thisyearenergy[n2] + energy;
                    if (thisyearcost[lmonth] != -1L) {
                        thisyearcost[lmonth] = cost == -1L ? -1L : thisyearcost[lmonth] + cost;
                    }
                } else if (lyear == year - 1) {
                    int n3 = lmonth;
                    lastyearenergy[n3] = lastyearenergy[n3] + energy;
                    if (lastyearcost[lmonth] != -1L) {
                        long l3 = lastyearcost[lmonth] = cost == -1L ? -1L : lastyearcost[lmonth] + cost;
                    }
                }
                if (lyear == year && lmonth == month) {
                    int n4 = lday - 1;
                    thismonthenergy[n4] = thismonthenergy[n4] + energy;
                    if (thismonthcost[lday - 1] != -1L) {
                        thismonthcost[lday - 1] = cost == -1L ? -1L : thismonthcost[lday - 1] + cost;
                    }
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    int n5 = lday - 1;
                    lastmonthenergy[n5] = lastmonthenergy[n5] + energy;
                    if (lastmonthcost[lday - 1] != -1L) {
                        long l4 = lastmonthcost[lday - 1] = cost == -1L ? -1L : lastmonthcost[lday - 1] + cost;
                    }
                }
                if (lyear == year && lmonth == month && lday == day) {
                    int n6 = lhour / 2;
                    todayenergy[n6] = todayenergy[n6] + energy;
                    if (todaycost[lhour / 2] == -1L) continue;
                    todaycost[lhour / 2] = cost == -1L ? -1L : todaycost[lhour / 2] + cost;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                int n7 = lhour / 2;
                yesterdayenergy[n7] = yesterdayenergy[n7] + energy;
                if (yesterdaycost[lhour / 2] == -1L) continue;
                long l5 = yesterdaycost[lhour / 2] = cost == -1L ? -1L : yesterdaycost[lhour / 2] + cost;
            }
            rs.close();
            StringBuffer sb = new StringBuffer("[");
            StringBuffer sbc = new StringBuffer("[");
            int i2 = 0;
            while (i2 < todayenergy.length) {
                if (i2 > 0) {
                    energytotal += todayenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = todaycost[i2] == -1L ? -1L : costtotal + todaycost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = todayenergy[i2];
                    costtotal = todaycost[i2];
                }
                sb.append(todayenergy[i2]);
                sbc.append(todaycost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("today", sb.toString());
            values.put("todaycost", sbc.toString());
            values.put("todaytotalenergy", Long.toString(energytotal));
            values.put("todaytotalcost", Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < yesterdayenergy.length) {
                if (i2 > 0) {
                    energytotal += yesterdayenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = yesterdaycost[i2] == -1L ? -1L : costtotal + yesterdaycost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = yesterdayenergy[i2];
                    costtotal = yesterdaycost[i2];
                }
                sb.append(yesterdayenergy[i2]);
                sbc.append(yesterdaycost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("yesterday", sb.toString());
            values.put("yesterdaycost", sbc.toString());
            values.put("yesterdaytotalenergy", Long.toString(energytotal));
            values.put("yesterdaytotalcost", Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < thismonthenergy.length) {
                if (i2 > 0) {
                    energytotal += thismonthenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = thismonthcost[i2] == -1L ? -1L : costtotal + thismonthcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = thismonthenergy[i2];
                    costtotal = thismonthcost[i2];
                }
                sb.append(thismonthenergy[i2]);
                sbc.append(thismonthcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("thismonth", sb.toString());
            values.put("thismonthcost", sbc.toString());
            values.put("thismonthtotalenergy", Long.toString(energytotal));
            values.put("thismonthtotalcost", Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < lastmonthenergy.length) {
                if (i2 > 0) {
                    energytotal += lastmonthenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = lastmonthcost[i2] == -1L ? -1L : costtotal + lastmonthcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = lastmonthenergy[i2];
                    costtotal = lastmonthcost[i2];
                }
                sb.append(lastmonthenergy[i2]);
                sbc.append(lastmonthcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("lastmonth", sb.toString());
            values.put("lastmonthcost", sbc.toString());
            values.put("lastmonthtotalenergy", Long.toString(energytotal));
            values.put("lastmonthtotalcost", Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < thisyearenergy.length) {
                if (i2 > 0) {
                    energytotal += thisyearenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = thisyearcost[i2] == -1L ? -1L : costtotal + thisyearcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = thisyearenergy[i2];
                    costtotal = thisyearcost[i2];
                }
                sb.append(thisyearenergy[i2]);
                sbc.append(thisyearcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("thisyear", sb.toString());
            values.put("thisyearcost", sbc.toString());
            values.put("thisyeartotalenergy", Long.toString(energytotal));
            values.put("thisyeartotalcost", Double.toString(costtotal));
            sb = new StringBuffer("[");
            sbc = new StringBuffer("[");
            i2 = 0;
            while (i2 < lastyearenergy.length) {
                if (i2 > 0) {
                    energytotal += lastyearenergy[i2];
                    if (costtotal != -1L) {
                        costtotal = lastyearcost[i2] == -1L ? -1L : costtotal + lastyearcost[i2];
                    }
                    sb.append(',');
                    sbc.append(',');
                } else {
                    energytotal = lastyearenergy[i2];
                    costtotal = lastyearcost[i2];
                }
                sb.append(lastyearenergy[i2]);
                sbc.append(lastyearcost[i2]);
                ++i2;
            }
            sb.append(']');
            sbc.append(']');
            values.put("lastyear", sb.toString());
            values.put("lastyearcost", sbc.toString());
            values.put("lastyeartotalenergy", Long.toString(energytotal));
            values.put("lastyeartotalcost", Double.toString(costtotal));
            return values;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static Hashtable<String, String> energyTotalView(long time) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Vector<Integer> loadstable = new Vector<Integer>();
        DecimalFormat df = new DecimalFormat("0.##");
        long[][] dayenergy = new long[14][5];
        long[][] monthenergy = new long[14][5];
        long[][] yearenergy = new long[14][5];
        long[] dayenergytotal = new long[4];
        long[] monthenergytotal = new long[4];
        long[] yearenergytotal = new long[4];
        String energycurrency = user.varGet("energycurrency!");
        try {
            int loadid;
            PreparedStatement stmt = databaseConnection.prepareStatement("select loadid from loads where enabled = true");
            ResultSet rs = stmt.executeQuery();
            int i2 = 0;
            while (rs.next() && i2 < 13) {
                loadid = rs.getInt(1);
                yearenergy[i2][0] = loadid;
                monthenergy[i2][0] = loadid;
                dayenergy[i2][0] = loadid;
                loadstable.add(loadid);
                ++i2;
            }
            rs.close();
            yearenergy[i2][0] = -1L;
            monthenergy[i2][0] = -1L;
            dayenergy[i2][0] = -1L;
            loadstable.add(-1);
            ++i2;
            while (i2 < 14) {
                yearenergy[i2][0] = -2L;
                monthenergy[i2][0] = -2L;
                dayenergy[i2][0] = -2L;
                loadstable.add(-2);
                ++i2;
            }
            long now = time == 0L ? System.currentTimeMillis() : time;
            Calendar today = Calendar.getInstance();
            Calendar yesterday = Calendar.getInstance();
            Calendar lastmonth = Calendar.getInstance();
            Calendar lastyear = Calendar.getInstance();
            today.setTimeInMillis(now);
            int day = today.get(5);
            int month = today.get(2);
            int year = today.get(1);
            yesterday.setTimeInMillis(now - 86400000L);
            lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
            lastyear.setTimeInMillis(now);
            lastyear.set(1, year - 1);
            lastyear.set(2, 0);
            lastyear.set(5, 1);
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.set(13, 0);
            lastyear.set(14, 0);
            stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, loadid, sum(meterhr) from endata where groupid = -2 and ltime >= ? and ltime <= ? group by loadid, lyear, lmonth, lday, lhour");
            stmt.setTimestamp(1, new Timestamp(lastyear.getTimeInMillis()));
            stmt.setTimestamp(2, new Timestamp(now));
            rs = stmt.executeQuery();
            while (rs.next()) {
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                loadid = rs.getInt(5);
                long energy = rs.getLong(6);
                long cost = CostRates.match(2, -1, lyear, lmonth + 1, lday, lhour);
                cost = cost < 0L ? -1L : energy * cost;
                i2 = loadstable.indexOf(loadid);
                if (i2 >= 0) {
                    if (lyear == year) {
                        long[] lArray = yearenergy[i2];
                        lArray[1] = lArray[1] + energy;
                        yearenergytotal[0] = yearenergytotal[0] + energy;
                        if (yearenergy[i2][3] != -1L) {
                            long l2 = yearenergy[i2][3] = cost == -1L ? -1L : yearenergy[i2][3] + cost;
                        }
                        if (yearenergytotal[2] != -1L) {
                            yearenergytotal[2] = cost == -1L ? -1L : yearenergytotal[2] + cost;
                        }
                    } else if (lyear == year - 1) {
                        long[] lArray = yearenergy[i2];
                        lArray[2] = lArray[2] + energy;
                        yearenergytotal[1] = yearenergytotal[1] + energy;
                        if (yearenergy[i2][4] != -1L) {
                            long l3 = yearenergy[i2][4] = cost == -1L ? -1L : yearenergy[i2][4] + cost;
                        }
                        if (yearenergytotal[3] != -1L) {
                            long l4 = yearenergytotal[3] = cost == -1L ? -1L : yearenergytotal[3] + cost;
                        }
                    }
                    if (lyear == year && lmonth == month) {
                        long[] lArray = monthenergy[i2];
                        lArray[1] = lArray[1] + energy;
                        monthenergytotal[0] = monthenergytotal[0] + energy;
                        if (monthenergy[i2][3] != -1L) {
                            long l5 = monthenergy[i2][3] = cost == -1L ? -1L : monthenergy[i2][3] + cost;
                        }
                        if (monthenergytotal[2] != -1L) {
                            monthenergytotal[2] = cost == -1L ? -1L : monthenergytotal[2] + cost;
                        }
                    } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                        long[] lArray = monthenergy[i2];
                        lArray[2] = lArray[2] + energy;
                        monthenergytotal[1] = monthenergytotal[1] + energy;
                        if (monthenergy[i2][4] != -1L) {
                            long l6 = monthenergy[i2][4] = cost == -1L ? -1L : monthenergy[i2][4] + cost;
                        }
                        if (monthenergytotal[3] != -1L) {
                            long l7 = monthenergytotal[3] = cost == -1L ? -1L : monthenergytotal[3] + cost;
                        }
                    }
                    if (lyear == year && lmonth == month && lday == day) {
                        long[] lArray = dayenergy[i2];
                        lArray[1] = lArray[1] + energy;
                        dayenergytotal[0] = dayenergytotal[0] + energy;
                        if (dayenergy[i2][3] != -1L) {
                            long l8 = dayenergy[i2][3] = cost == -1L ? -1L : dayenergy[i2][3] + cost;
                        }
                        if (dayenergytotal[2] == -1L) continue;
                        dayenergytotal[2] = cost == -1L ? -1L : dayenergytotal[2] + cost;
                        continue;
                    }
                    if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                    long[] lArray = dayenergy[i2];
                    lArray[2] = lArray[2] + energy;
                    dayenergytotal[1] = dayenergytotal[1] + energy;
                    if (dayenergy[i2][4] != -1L) {
                        long l9 = dayenergy[i2][4] = cost == -1L ? -1L : dayenergy[i2][4] + cost;
                    }
                    if (dayenergytotal[3] == -1L) continue;
                    dayenergytotal[3] = cost == -1L ? -1L : dayenergytotal[3] + cost;
                    continue;
                }
                if (lyear == year) {
                    yearenergytotal[0] = yearenergytotal[0] + energy;
                    if (yearenergytotal[2] != -1L) {
                        yearenergytotal[2] = cost == -1L ? -1L : yearenergytotal[2] + cost;
                    }
                } else if (lyear == year - 1) {
                    yearenergytotal[1] = yearenergytotal[1] + energy;
                    if (yearenergytotal[3] != -1L) {
                        long l10 = yearenergytotal[3] = cost == -1L ? -1L : yearenergytotal[3] + cost;
                    }
                }
                if (lyear == year && lmonth == month) {
                    monthenergytotal[0] = monthenergytotal[0] + energy;
                    if (monthenergytotal[2] != -1L) {
                        monthenergytotal[2] = cost == -1L ? -1L : monthenergytotal[2] + cost;
                    }
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    monthenergytotal[1] = monthenergytotal[1] + energy;
                    if (monthenergytotal[3] != -1L) {
                        long l11 = monthenergytotal[3] = cost == -1L ? -1L : monthenergytotal[3] + cost;
                    }
                }
                if (lyear == year && lmonth == month && lday == day) {
                    dayenergytotal[0] = dayenergytotal[0] + energy;
                    if (dayenergytotal[2] == -1L) continue;
                    dayenergytotal[2] = cost == -1L ? -1L : dayenergytotal[2] + cost;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                dayenergytotal[1] = dayenergytotal[1] + energy;
                if (dayenergytotal[3] == -1L) continue;
                long l12 = dayenergytotal[3] = cost == -1L ? -1L : dayenergytotal[3] + cost;
            }
            rs.close();
            StringBuffer sb = new StringBuffer("[");
            int x = 0;
            while (x < dayenergy.length) {
                if (x > 0) {
                    sb.append(',');
                }
                sb.append('[');
                sb.append(dayenergy[x][0]);
                sb.append(',');
                sb.append(dayenergy[x][1]);
                sb.append(',');
                sb.append(dayenergy[x][2]);
                sb.append(',');
                sb.append(dayenergy[x][3]);
                sb.append(',');
                sb.append(dayenergy[x][4]);
                sb.append(']');
                ++x;
            }
            sb.append(']');
            values.put("day", sb.toString());
            values.put("todaytotalenergy", Long.toString(dayenergytotal[0]));
            values.put("todaytotalcost", String.valueOf(dayenergytotal[2] == -1L ? "0" : df.format((double)dayenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("yesterdaytotalenergy", Long.toString(dayenergytotal[1]));
            values.put("yesterdaytotalcost", String.valueOf(dayenergytotal[3] == -1L ? "0" : df.format((double)dayenergytotal[3] / 1000000.0)) + " " + energycurrency);
            sb = new StringBuffer("[");
            x = 0;
            while (x < monthenergy.length) {
                if (x > 0) {
                    sb.append(',');
                }
                sb.append('[');
                sb.append(monthenergy[x][0]);
                sb.append(',');
                sb.append(monthenergy[x][1]);
                sb.append(',');
                sb.append(monthenergy[x][2]);
                sb.append(',');
                sb.append(monthenergy[x][3]);
                sb.append(',');
                sb.append(monthenergy[x][4]);
                sb.append(']');
                ++x;
            }
            sb.append(']');
            values.put("month", sb.toString());
            values.put("thismonthtotalenergy", Long.toString(monthenergytotal[0]));
            values.put("thismonthtotalcost", String.valueOf(monthenergytotal[2] == -1L ? "0" : df.format((double)monthenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("lastmonthtotalenergy", Long.toString(monthenergytotal[1]));
            values.put("lastmonthtotalcost", String.valueOf(monthenergytotal[3] == -1L ? "0" : df.format((double)monthenergytotal[3] / 1000000.0)) + " " + energycurrency);
            sb = new StringBuffer("[");
            x = 0;
            while (x < yearenergy.length) {
                if (x > 0) {
                    sb.append(',');
                }
                sb.append('[');
                sb.append(yearenergy[x][0]);
                sb.append(',');
                sb.append(yearenergy[x][1]);
                sb.append(',');
                sb.append(yearenergy[x][2]);
                sb.append(',');
                sb.append(yearenergy[x][3]);
                sb.append(',');
                sb.append(yearenergy[x][4]);
                sb.append(']');
                ++x;
            }
            sb.append(']');
            values.put("year", sb.toString());
            values.put("thisyeartotalenergy", Long.toString(yearenergytotal[0]));
            values.put("thisyeartotalcost", String.valueOf(yearenergytotal[2] == -1L ? "0" : df.format((double)yearenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("lastyeartotalenergy", Long.toString(yearenergytotal[1]));
            values.put("lastyeartotalcost", String.valueOf(yearenergytotal[3] == -1L ? "0" : df.format((double)yearenergytotal[3] / 1000000.0)) + " " + energycurrency);
            return values;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static Hashtable<String, String> waterTotalView(long time) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        DecimalFormat df = new DecimalFormat("0.##");
        long[] dayenergytotal = new long[4];
        long[] monthenergytotal = new long[4];
        long[] yearenergytotal = new long[4];
        String energycurrency = user.varGet("energycurrency!");
        try {
            long now = time == 0L ? System.currentTimeMillis() : time;
            Calendar today = Calendar.getInstance();
            Calendar yesterday = Calendar.getInstance();
            Calendar lastmonth = Calendar.getInstance();
            Calendar lastyear = Calendar.getInstance();
            today.setTimeInMillis(now);
            int day = today.get(5);
            int month = today.get(2);
            int year = today.get(1);
            yesterday.setTimeInMillis(now - 86400000L);
            lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
            lastyear.setTimeInMillis(now);
            lastyear.set(1, year - 1);
            lastyear.set(2, 0);
            lastyear.set(5, 1);
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.set(13, 0);
            lastyear.set(14, 0);
            PreparedStatement stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = -3 and loadid = -3 and ltime >= ? and ltime <= ? group by loadid, lyear, lmonth, lday, lhour");
            stmt.setTimestamp(1, new Timestamp(lastyear.getTimeInMillis()));
            stmt.setTimestamp(2, new Timestamp(now));
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                long energy = rs.getLong(5);
                long cost = CostRates.match(3, -1, lyear, lmonth + 1, lday, lhour);
                long l2 = cost = cost < 0L ? -1L : energy * cost;
                if (lyear == year) {
                    yearenergytotal[0] = yearenergytotal[0] + energy;
                    if (yearenergytotal[2] != -1L) {
                        yearenergytotal[2] = cost == -1L ? -1L : yearenergytotal[2] + cost;
                    }
                } else if (lyear == year - 1) {
                    yearenergytotal[1] = yearenergytotal[1] + energy;
                    if (yearenergytotal[3] != -1L) {
                        long l3 = yearenergytotal[3] = cost == -1L ? -1L : yearenergytotal[3] + cost;
                    }
                }
                if (lyear == year && lmonth == month) {
                    monthenergytotal[0] = monthenergytotal[0] + energy;
                    if (monthenergytotal[2] != -1L) {
                        monthenergytotal[2] = cost == -1L ? -1L : monthenergytotal[2] + cost;
                    }
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    monthenergytotal[1] = monthenergytotal[1] + energy;
                    if (monthenergytotal[3] != -1L) {
                        long l4 = monthenergytotal[3] = cost == -1L ? -1L : monthenergytotal[3] + cost;
                    }
                }
                if (lyear == year && lmonth == month && lday == day) {
                    dayenergytotal[0] = dayenergytotal[0] + energy;
                    if (dayenergytotal[2] == -1L) continue;
                    dayenergytotal[2] = cost == -1L ? -1L : dayenergytotal[2] + cost;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                dayenergytotal[1] = dayenergytotal[1] + energy;
                if (dayenergytotal[3] == -1L) continue;
                long l5 = dayenergytotal[3] = cost == -1L ? -1L : dayenergytotal[3] + cost;
            }
            rs.close();
            values.put("todaytotalenergy", Long.toString(dayenergytotal[0]));
            values.put("todaytotalcost", String.valueOf(dayenergytotal[2] == -1L ? "0" : df.format((double)dayenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("yesterdaytotalenergy", Long.toString(dayenergytotal[1]));
            values.put("yesterdaytotalcost", String.valueOf(dayenergytotal[3] == -1L ? "0" : df.format((double)dayenergytotal[3] / 1000000.0)) + " " + energycurrency);
            values.put("thismonthtotalenergy", Long.toString(monthenergytotal[0]));
            values.put("thismonthtotalcost", String.valueOf(monthenergytotal[2] == -1L ? "0" : df.format((double)monthenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("lastmonthtotalenergy", Long.toString(monthenergytotal[1]));
            values.put("lastmonthtotalcost", String.valueOf(monthenergytotal[3] == -1L ? "0" : df.format((double)monthenergytotal[3] / 1000000.0)) + " " + energycurrency);
            values.put("thisyeartotalenergy", Long.toString(yearenergytotal[0]));
            values.put("thisyeartotalcost", String.valueOf(yearenergytotal[2] == -1L ? "0" : df.format((double)yearenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("lastyeartotalenergy", Long.toString(yearenergytotal[1]));
            values.put("lastyeartotalcost", String.valueOf(yearenergytotal[3] == -1L ? "0" : df.format((double)yearenergytotal[3] / 1000000.0)) + " " + energycurrency);
            return values;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static Hashtable<String, String> gasTotalView(long time) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        DecimalFormat df = new DecimalFormat("0.##");
        long[] dayenergytotal = new long[4];
        long[] monthenergytotal = new long[4];
        long[] yearenergytotal = new long[4];
        String energycurrency = user.varGet("energycurrency!");
        try {
            long now = time == 0L ? System.currentTimeMillis() : time;
            Calendar today = Calendar.getInstance();
            Calendar yesterday = Calendar.getInstance();
            Calendar lastmonth = Calendar.getInstance();
            Calendar lastyear = Calendar.getInstance();
            today.setTimeInMillis(now);
            int day = today.get(5);
            int month = today.get(2);
            int year = today.get(1);
            yesterday.setTimeInMillis(now - 86400000L);
            lastmonth.setTimeInMillis(now - 86400000L * (long)(day + 1));
            lastyear.setTimeInMillis(now);
            lastyear.set(1, year - 1);
            lastyear.set(2, 0);
            lastyear.set(5, 1);
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.set(13, 0);
            lastyear.set(14, 0);
            PreparedStatement stmt = databaseConnection.prepareStatement("select lyear, lmonth, lday, lhour, sum(meterhr) from endata where groupid = -4 and loadid = -4 and ltime >= ? and ltime <= ? group by loadid, lyear, lmonth, lday, lhour");
            stmt.setTimestamp(1, new Timestamp(lastyear.getTimeInMillis()));
            stmt.setTimestamp(2, new Timestamp(now));
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                short lyear = rs.getShort(1);
                int lmonth = rs.getShort(2) - 1;
                short lday = rs.getShort(3);
                short lhour = rs.getShort(4);
                long energy = rs.getLong(5);
                long cost = CostRates.match(4, -1, lyear, lmonth + 1, lday, lhour);
                long l2 = cost = cost < 0L ? -1L : energy * cost;
                if (lyear == year) {
                    yearenergytotal[0] = yearenergytotal[0] + energy;
                    if (yearenergytotal[2] != -1L) {
                        yearenergytotal[2] = cost == -1L ? -1L : yearenergytotal[2] + cost;
                    }
                } else if (lyear == year - 1) {
                    yearenergytotal[1] = yearenergytotal[1] + energy;
                    if (yearenergytotal[3] != -1L) {
                        long l3 = yearenergytotal[3] = cost == -1L ? -1L : yearenergytotal[3] + cost;
                    }
                }
                if (lyear == year && lmonth == month) {
                    monthenergytotal[0] = monthenergytotal[0] + energy;
                    if (monthenergytotal[2] != -1L) {
                        monthenergytotal[2] = cost == -1L ? -1L : monthenergytotal[2] + cost;
                    }
                } else if (lyear == lastmonth.get(1) && lmonth == lastmonth.get(2)) {
                    monthenergytotal[1] = monthenergytotal[1] + energy;
                    if (monthenergytotal[3] != -1L) {
                        long l4 = monthenergytotal[3] = cost == -1L ? -1L : monthenergytotal[3] + cost;
                    }
                }
                if (lyear == year && lmonth == month && lday == day) {
                    dayenergytotal[0] = dayenergytotal[0] + energy;
                    if (dayenergytotal[2] == -1L) continue;
                    dayenergytotal[2] = cost == -1L ? -1L : dayenergytotal[2] + cost;
                    continue;
                }
                if (lyear != yesterday.get(1) || lmonth != yesterday.get(2) || lday != yesterday.get(5)) continue;
                dayenergytotal[1] = dayenergytotal[1] + energy;
                if (dayenergytotal[3] == -1L) continue;
                long l5 = dayenergytotal[3] = cost == -1L ? -1L : dayenergytotal[3] + cost;
            }
            rs.close();
            values.put("todaytotalenergy", Long.toString(dayenergytotal[0]));
            values.put("todaytotalcost", String.valueOf(dayenergytotal[2] == -1L ? "0" : df.format((double)dayenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("yesterdaytotalenergy", Long.toString(dayenergytotal[1]));
            values.put("yesterdaytotalcost", String.valueOf(dayenergytotal[3] == -1L ? "0" : df.format((double)dayenergytotal[3] / 1000000.0)) + " " + energycurrency);
            values.put("thismonthtotalenergy", Long.toString(monthenergytotal[0]));
            values.put("thismonthtotalcost", String.valueOf(monthenergytotal[2] == -1L ? "0" : df.format((double)monthenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("lastmonthtotalenergy", Long.toString(monthenergytotal[1]));
            values.put("lastmonthtotalcost", String.valueOf(monthenergytotal[3] == -1L ? "0" : df.format((double)monthenergytotal[3] / 1000000.0)) + " " + energycurrency);
            values.put("thisyeartotalenergy", Long.toString(yearenergytotal[0]));
            values.put("thisyeartotalcost", String.valueOf(yearenergytotal[2] == -1L ? "0" : df.format((double)yearenergytotal[2] / 1000000.0)) + " " + energycurrency);
            values.put("lastyeartotalenergy", Long.toString(yearenergytotal[1]));
            values.put("lastyeartotalcost", String.valueOf(yearenergytotal[3] == -1L ? "0" : df.format((double)yearenergytotal[3] / 1000000.0)) + " " + energycurrency);
            return values;
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setSysPwd(String user2, String password) {
        String[] cmda = new String[]{"smbpasswd", "-s", user2};
        try {
            int len = password.length();
            if (len < 8 || len > 16) {
                return false;
            }
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (true) {
                if (i2 >= password.length()) {
                    String pwd = sb.toString();
                    Runtime rt = Runtime.getRuntime();
                    Process proc = rt.exec("chpasswd");
                    PrintWriter in = new PrintWriter(proc.getOutputStream());
                    BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    in.println(String.valueOf(user2) + ":" + pwd);
                    in.flush();
                    in.close();
                    out.close();
                    err.close();
                    proc.waitFor();
                    proc = rt.exec(cmda);
                    in = new PrintWriter(proc.getOutputStream());
                    err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    in.println(pwd);
                    in.println(pwd);
                    in.flush();
                    in.close();
                    out.close();
                    err.close();
                    proc.waitFor();
                    user.restartSSH();
                    user.restartSamba();
                    return true;
                }
                char c2 = password.charAt(i2);
                if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') && (c2 < '0' || c2 > '9')) break;
                sb.append(c2);
                ++i2;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static void restartSSH() {
        String[][] cmda = new String[][]{{"/etc/init.d/ssh", "stop"}, {"killall", "sshd"}, {"/etc/init.d/ssh", "start"}};
        try {
            Runtime rt = Runtime.getRuntime();
            int i2 = 0;
            while (i2 < cmda.length) {
                Process proc = rt.exec(cmda[i2]);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void restartSamba() {
        String[] cmda = new String[]{"/etc/init.d/samba", "restart"};
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brout.readLine() != null) {
            }
            proc.destroy();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void execNtpdate() {
        String[] cmda = new String[]{"ntpdate", autoTimeServer == null || autoTimeServer.length() == 0 ? DEFAULT_AUTO_TIME_SERVER : autoTimeServer};
        try {
            Runtime rt = Runtime.getRuntime();
            if (System.getProperty("os.name").toLowerCase().equals("linux")) {
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean execTimeZone(int zone) {
        String[] cmda = new String[]{"dpkg-reconfigure", "--frontend", "noninteractive", "tzdata"};
        try {
            Runtime rt = Runtime.getRuntime();
            if (System.getProperty("os.name").toLowerCase().equals("linux")) {
                TimeZone newtz = ZONES.elementAt(zone);
                if (!TimeZone.getDefault().getID().equals(newtz.getID())) {
                    File file = new File("/etc/timezone");
                    FileWriter fw = new FileWriter(file, false);
                    fw.write(newtz.getID());
                    fw.close();
                    TimeZone.setDefault(newtz);
                    Process proc = rt.exec(cmda);
                    BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while (brout.readLine() != null) {
                    }
                    proc.destroy();
                    brerr.close();
                    brout.close();
                    user.messageLog("TIMEZONE CHANGE: " + newtz.getID());
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static boolean execDate(int year, int month, int day, int hour, int minute) {
        String[] cmda = new String[]{"date", "-s", ""};
        String[] cmda1 = new String[]{"hwclock", "--utc", "--systohc"};
        StringBuffer sb = new StringBuffer();
        try {
            Runtime rt = Runtime.getRuntime();
            if (System.getProperty("os.name").toLowerCase().equals("linux")) {
                sb.append(month < 10 ? "0" + month : Integer.valueOf(month));
                sb.append('/');
                sb.append(day < 10 ? "0" + day : Integer.valueOf(day));
                sb.append('/');
                sb.append(year < 100 ? "20" + year : Integer.valueOf(year));
                sb.append(' ');
                sb.append(hour < 10 ? "0" + hour : Integer.valueOf(hour));
                sb.append(':');
                sb.append(minute < 10 ? "0" + minute : Integer.valueOf(minute));
                cmda[2] = sb.toString();
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
                proc = rt.exec(cmda1);
                brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
                user.messageLog("DATE/TIME CHANGE: " + cmda[2]);
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static void diskSpaceTestFlag() {
        try {
            File f2 = new File("data");
            if (f2.getUsableSpace() * 100L / f2.getTotalSpace() > (long)(smallDisk ? 30 : 20)) {
                lowDiskSpace = false;
                user.uiSet("xerr.disk", "flag", "false");
            } else {
                lowDiskSpace = true;
                user.uiSet("xerr.disk", "flag", "true");
            }
        }
        catch (Exception e2) {
            user.uiSet("xerr.disk", "flag", "true");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String isValidIpV4Address(String address) {
        StringBuffer sb = new StringBuffer();
        String pa = new String();
        try {
            String string;
            int port;
            String[] aa = address.split("[:]");
            switch (aa.length) {
                case 1: {
                    address = aa[0].trim();
                    port = 0;
                    break;
                }
                case 2: {
                    address = aa[0].trim();
                    try {
                        port = Integer.parseInt(aa[1].trim());
                        if (port < 1) return null;
                        if (port > 65534) {
                            return null;
                        }
                        break;
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
                default: {
                    return null;
                }
            }
            String[] sa = address.split("[.]");
            if (sa.length != 4) return null;
            int i2 = 0;
            while (true) {
                if (i2 >= 4) {
                    pa = sb.toString();
                    if (pa.equals("0.0.0.0")) return null;
                    if (!pa.equals("255.255.255.255")) break;
                    return null;
                }
                int a2 = Integer.parseInt(sa[i2]);
                if (a2 < 0) return null;
                if (a2 > 255) return null;
                if (i2 > 0) {
                    sb.append('.');
                }
                sb.append(a2);
                ++i2;
            }
            if (port == 0) {
                string = pa;
                return string;
            }
            string = String.valueOf(pa) + ":" + port;
            return string;
        }
        catch (Exception e3) {
            return null;
        }
    }

    private static int checkGatewaysLimits(String address, int gatewayid, boolean haseq) {
        PreparedStatement pstmt;
        block8: {
            try {
                if (!haseq || VVVV != 10) break block8;
                return -1;
            }
            catch (Exception e2) {
                return -1;
            }
        }
        if (gatewayid >= 0) {
            pstmt = databaseConnection.prepareStatement("select count(*) from gateways where address = ? and gatewayid <> ?");
            pstmt.setString(1, address);
            pstmt.setInt(2, gatewayid);
        } else {
            pstmt = databaseConnection.prepareStatement("select count(*) from gateways where address = ?");
            pstmt.setString(1, address);
        }
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int count = rs.getInt(1);
            rs.close();
            if (count > 0) {
                return 2;
            }
        } else {
            return -1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int checkSensorsLimits(int gatewayid, int address, String subaddress, int sensorid) {
        try {
            String[] sa;
            int limit;
            PreparedStatement pstmt = databaseConnection.prepareStatement("select count(*) from sensors");
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                return -1;
            }
            int count = rs.getInt(1);
            rs.close();
            int n2 = limit = sensorid == -1 ? VVVV - 1 : VVVV;
            if (count > limit) {
                return 1;
            }
            if (subaddress.indexOf(58) != -1 && (sa = subaddress.split(":")).length == 2) {
                int concentratormodel = Integer.parseInt(subaddress.substring(0, subaddress.indexOf(58)));
                int concentratorport = Integer.parseInt(subaddress.substring(subaddress.indexOf(58) + 1));
                switch (concentratormodel) {
                    case 0: {
                        if (concentratorport >= 1 && concentratorport <= 7) break;
                        return -1;
                    }
                    case 1: 
                    case 2: {
                        if (concentratorport >= 1 && concentratorport <= 12) break;
                        return -1;
                    }
                    case 3: {
                        if (concentratorport >= 1 && concentratorport <= 3) break;
                        return -1;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        if (concentratorport == 1) break;
                        return -1;
                    }
                }
            }
            if (sensorid >= 0) {
                pstmt = subaddress.length() > 0 ? databaseConnection.prepareStatement("select count(*) from sensors where gatewayid = ? and address = ? and (subaddress = ? or subaddress = '') and sensorid <> ?") : databaseConnection.prepareStatement("select count(*) from sensors where gatewayid = ? and address = ? and (subaddress <> ? or subaddress = '') and sensorid <> ?");
                pstmt.setInt(1, gatewayid);
                pstmt.setInt(2, address);
                pstmt.setString(3, subaddress);
                pstmt.setInt(4, sensorid);
            } else {
                pstmt = subaddress.length() > 0 ? databaseConnection.prepareStatement("select count(*) from sensors where gatewayid = ? and address = ? and (subaddress = ? or subaddress = '')") : databaseConnection.prepareStatement("select count(*) from sensors where gatewayid = ? and address = ? and (subaddress <> ? or subaddress = '')");
                pstmt.setInt(1, gatewayid);
                pstmt.setInt(2, address);
                pstmt.setString(3, subaddress);
            }
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                return -1;
            }
            count = rs.getInt(1);
            rs.close();
            if (count > 0) {
                return 2;
            }
            return 0;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private static void dbConnect() {
        Statement stmt = null;
        try {
            block6: {
                try {
                    databaseConnection = DriverManager.getConnection(DATABASE_URL, "data", DATABASE_PASSWORD);
                }
                catch (Exception e2) {
                    if (user.dbAttemptRecovery()) break block6;
                    throw e2;
                }
            }
            databaseConnection.setAutoCommit(true);
            stmt = databaseConnection.createStatement();
            stmt.execute("set files log false");
        }
        catch (Exception e3) {
            user.errorLog("WSMEASURE STARTUP FATAL ERROR: CANNOT CONNECT TO DATABASE - SYSTEM RESTARTING NOW");
            System.exit(1);
        }
        try {
            stmt.execute("set files scale 64");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean dbAttemptRecovery() throws Exception {
        File dataBackupDir;
        if (hsycoDatabaseBackup && hsycoDatabaseRecovery && (dataBackupDir = new File(DATABASE_BACKUP_DIR)).exists() && dataBackupDir.isDirectory()) {
            hsyco.errorLog("WSMEASURE Database unrecoverable error - attempting recovery from last backup (corrupted database directory renamed as data_wsmeasure_original)");
            try {
                int i2;
                File dataDir = new File("data");
                File dataFile = new File(dataDir, "data.data");
                File[] dataFiles = dataDir.listFiles();
                if (dataFile.getUsableSpace() > 3L * dataFile.length()) {
                    File dataOriginalDir = new File("data_wsmeasure_original");
                    if (!dataOriginalDir.isDirectory()) {
                        dataOriginalDir.mkdir();
                        dataOriginalDir.setWritable(true, false);
                    }
                    int i3 = 0;
                    while (i3 < dataFiles.length) {
                        if (dataFiles[i3].getName().startsWith("data.")) {
                            File to = new File(dataOriginalDir, dataFiles[i3].getName());
                            dataFiles[i3].renameTo(to);
                        }
                        ++i3;
                    }
                } else {
                    int FILEBUFFER = 4096;
                    byte[] data = new byte[4096];
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream("data_wsmeasure_original.zip"));
                    i2 = 0;
                    while (i2 < dataFiles.length) {
                        if (dataFiles[i2].isFile()) {
                            String name = dataFiles[i2].getName();
                            int counter = 0;
                            if (name.startsWith("data.")) {
                                BufferedInputStream source = new BufferedInputStream(new FileInputStream(dataFiles[i2]), 4096);
                                zos.putNextEntry(new ZipEntry(name));
                                while ((counter = source.read(data, 0, 4096)) != -1) {
                                    zos.write(data, 0, counter);
                                }
                                source.close();
                            }
                        }
                        ++i2;
                    }
                    zos.close();
                }
                boolean restoredFromConsolidatedBackup = false;
                File dataBackupConsolidatedFile = new File(dataBackupDir, "data.zip");
                if (dataBackupConsolidatedFile.isFile()) {
                    ZipEntry entry;
                    byte[] buffer = new byte[4096];
                    FileInputStream ins = new FileInputStream(dataBackupConsolidatedFile);
                    ZipInputStream zin = new ZipInputStream(ins);
                    while ((entry = zin.getNextEntry()) != null) {
                        int len;
                        File to = new File(dataDir, entry.getName());
                        FileOutputStream outs = new FileOutputStream(to);
                        while ((len = zin.read(buffer)) > 0) {
                            outs.write(buffer, 0, len);
                        }
                        outs.close();
                        to.setWritable(true, false);
                        to.getAbsoluteFile().getParentFile().setLastModified(System.currentTimeMillis());
                        zin.closeEntry();
                    }
                    zin.close();
                    restoredFromConsolidatedBackup = true;
                }
                if (!restoredFromConsolidatedBackup) {
                    File[] dataBackupFiles = dataBackupDir.listFiles();
                    i2 = 0;
                    while (i2 < dataBackupFiles.length) {
                        String fname;
                        if (dataBackupFiles[i2].isFile() && !(fname = dataBackupFiles[i2].getName()).equals("data.zip") && fname.startsWith("data.")) {
                            File to = new File(dataDir, dataBackupFiles[i2].getName());
                            FileInputStream ins = new FileInputStream(dataBackupFiles[i2]);
                            FileOutputStream outs = new FileOutputStream(to);
                            FileChannel in = ins.getChannel();
                            FileChannel out = outs.getChannel();
                            in.transferTo(0L, in.size(), out);
                            ins.close();
                            outs.close();
                            to.setWritable(true, false);
                        }
                        ++i2;
                    }
                }
                databaseConnection = DriverManager.getConnection(DATABASE_URL, "data", DATABASE_PASSWORD);
                hsyco.messageLog("WSMEASURE Database successfully recovered from last backup");
                return true;
            }
            catch (Exception e1) {
                hsyco.errorLog("WSMEASURE Database recovery from last backup failed: " + e1);
                throw e1;
            }
        }
        return false;
    }

    private static void dbBackup() {
        boolean corrupted;
        boolean backupcompleted = false;
        try {
            String temppath = String.valueOf(new File(".").getCanonicalPath()) + "/.__" + DATABASE_BACKUP_DIR + "/";
            String realpath = String.valueOf(new File(".").getCanonicalPath()) + "/" + DATABASE_BACKUP_DIR + "/";
            File temppathfile = new File(temppath);
            File realpathfile = new File(realpath);
            long backuptime = System.currentTimeMillis();
            if (hsycoDatabaseBackupConsolidation) {
                File[] files = new File(realpath).listFiles();
                if (files != null) {
                    int i2 = 0;
                    while (i2 < files.length) {
                        if (!files[i2].getName().endsWith(".zip")) {
                            files[i2].delete();
                        }
                        ++i2;
                    }
                }
                databaseConnection.createStatement().execute("backup database to '" + realpath + "' not blocking as files");
            } else {
                user.delete(temppathfile);
                databaseConnection.createStatement().execute("backup database to '" + temppath + "' not blocking as files");
                user.delete(realpathfile);
                temppathfile.renameTo(realpathfile);
            }
            user.messageLog("WSMEASURE Database backup in " + (System.currentTimeMillis() - backuptime) / 1000L + "s");
            backupcompleted = true;
        }
        catch (Exception e2) {
            user.errorLog("WSMEASURE Database backup failed");
        }
        if (backupcompleted && hsycoDatabaseBackupConsolidation && (corrupted = user.dbBackupConsolidationController()) && hsycoDatabaseRecovery) {
            hsyco.messageLog("WSMEASURE Database: Possible corruption detected. HSYCO will restart now...");
            System.exit(1);
        }
    }

    static boolean dbBackupConsolidationController() {
        int STALL_COUNTER_TICKS_LIMIT = 3600;
        String[] cmd = new String[]{"java", "-Djava.library.path=.", "-cp", new File(".hsyco.jar").exists() ? ".hsyco.jar:." : "hsyco.jar:.", "com.hsyco.hsyco", "exec", "dbconso", DATABASE_BACKUP_DIR, "data", "data", DATABASE_PASSWORD};
        boolean abort = false;
        boolean corrupted = false;
        int state = -1;
        int newstate = 0;
        int stallcounter = 0;
        long originaldatafilesize = -1L;
        long newdatafilesize = -1L;
        long newscriptfilesize = -1L;
        long newzipfilesize = -1L;
        try {
            long starttime = System.nanoTime();
            String jdbcpath = String.valueOf(new File(".").getCanonicalPath()) + "/" + DATABASE_BACKUP_DIR;
            String jdbcfileroot = String.valueOf(jdbcpath) + "/" + "data";
            File jdbcpathfile = new File(jdbcpath);
            File dbdatafile = new File(String.valueOf(jdbcfileroot) + ".data");
            File dbnewdatafile = new File(String.valueOf(jdbcfileroot) + ".data.new");
            File dbscriptfile = new File(String.valueOf(jdbcfileroot) + ".script");
            File dbnewscriptfile = new File(String.valueOf(jdbcfileroot) + ".script.new");
            File dbzipfile = new File(String.valueOf(jdbcfileroot) + ".zip");
            long dbzipfileoriginaltime = dbzipfile.lastModified();
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (proc.isAlive()) {
                if (newstate != state) {
                    state = newstate;
                    hsyco.messageLog("WSMEASURE Database: Backup consolidation in progress (" + state + ")");
                }
                while (brout.ready()) {
                    brout.read();
                }
                while (brerr.ready()) {
                    brerr.read();
                }
                if (abort) {
                    proc.destroy();
                } else if ((double)jdbcpathfile.getUsableSpace() > (double)jdbcpathfile.getTotalSpace() * 0.1) {
                    long size;
                    if (dbdatafile.exists()) {
                        if (originaldatafilesize < 0L) {
                            originaldatafilesize = dbdatafile.length();
                        }
                        if (dbnewscriptfile.exists()) {
                            newstate = 2;
                            size = dbnewscriptfile.length();
                            if (size > newscriptfilesize) {
                                newscriptfilesize = size;
                                stallcounter = 0;
                                if (size > 10000000L & originaldatafilesize != 0L && size > originaldatafilesize * 2L) {
                                    abort = true;
                                    corrupted = true;
                                    dbBackupConsolidationExitStatus = "runaway";
                                    hsyco.errorLog("WSMEASURE Database: Backup consolidation aborted due to runaway script file");
                                }
                            } else if (stallcounter > 3600) {
                                abort = true;
                                corrupted = true;
                                dbBackupConsolidationExitStatus = "stalled.scripting";
                                hsyco.errorLog("WSMEASURE Database: Backup consolidation aborted due to stalled script file (scripting)");
                            } else {
                                ++stallcounter;
                            }
                        } else if (state != 1) {
                            newstate = 1;
                            stallcounter = 0;
                        } else {
                            size = dbnewdatafile.length();
                            if (size != 0L && size > newdatafilesize) {
                                newdatafilesize = size;
                                stallcounter = 0;
                                if (size > 10000000L & originaldatafilesize != 0L && size > originaldatafilesize * 2L) {
                                    abort = true;
                                    corrupted = true;
                                    dbBackupConsolidationExitStatus = "runaway";
                                    hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to runaway data file");
                                }
                            } else if (stallcounter > 3600) {
                                abort = true;
                                corrupted = true;
                                dbBackupConsolidationExitStatus = "stalled.pre";
                                hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to stalled script file (pre)");
                            } else {
                                ++stallcounter;
                            }
                        }
                    } else if (dbscriptfile.exists() && !dbnewscriptfile.exists()) {
                        if (state != 3) {
                            newstate = 3;
                            stallcounter = 0;
                            dbBackupScriptSize = dbscriptfile.length();
                        } else if (dbzipfile.exists() && dbzipfile.lastModified() > dbzipfileoriginaltime) {
                            size = dbzipfile.length();
                            if (size > newzipfilesize) {
                                newzipfilesize = size;
                                stallcounter = 0;
                                if (size > newscriptfilesize) {
                                    abort = true;
                                    corrupted = true;
                                    dbBackupConsolidationExitStatus = "runaway.zip";
                                    hsyco.errorLog("WSMEASURE Database: Backup consolidation aborted due to runaway zip file");
                                }
                            } else if (stallcounter > 3600) {
                                abort = true;
                                corrupted = true;
                                dbBackupConsolidationExitStatus = "stalled.zip";
                                hsyco.errorLog("WSMEASURE Database: Backup consolidation aborted due to stalled zip file");
                            } else {
                                ++stallcounter;
                            }
                        } else if (stallcounter > 3600) {
                            abort = true;
                            corrupted = true;
                            dbBackupConsolidationExitStatus = "stalled.post";
                            hsyco.errorLog("WSMEASURE Database: Backup consolidation aborted due to stalled script file (post)");
                        } else {
                            ++stallcounter;
                        }
                    }
                } else {
                    abort = true;
                    dbBackupConsolidationExitStatus = "nospace";
                    hsyco.errorLog("WSMEASURE Database: Backup consolidation aborted due to insufficient space");
                }
                Thread.sleep(1000L);
            }
            if (abort) {
                dbnewscriptfile.delete();
                dbBackupConsolidationTimeSeconds = -1;
            } else {
                int e2 = proc.exitValue();
                if (e2 == 0) {
                    dbBackupConsolidationTimeSeconds = (int)((System.nanoTime() - starttime) / 1000000000L);
                    dbBackupConsolidationTimestampMillis = System.currentTimeMillis();
                    dbBackupConsolidationExitStatus = "done";
                    hsyco.messageLog("WSMEASURE Database: Backup consolidation completed in " + dbBackupConsolidationTimeSeconds + "s");
                } else {
                    dbBackupConsolidationTimeSeconds = -1;
                    dbBackupConsolidationExitStatus = "error=" + Math.abs(e2);
                    hsyco.messageLog("WSMEASURE Database: Backup consolidation error (" + e2 + ")");
                    if (e2 == 1) {
                        corrupted = true;
                    }
                }
            }
        }
        catch (Exception e3) {
            dbBackupConsolidationTimeSeconds = -1;
            dbBackupConsolidationExitStatus = "exception";
            hsyco.errorLog("WSMEASURE Database: Backup consolidation exception: " + e3);
        }
        return corrupted;
    }

    private static void dbCompact() {
        long now = System.currentTimeMillis();
        try {
            File f2 = new File(".dbcompact_wsmeasure");
            if (f2.canWrite()) {
                f2.delete();
                user.messageLog("WSMEASURE Database: Optimization procedure in progress...");
                databaseConnection.createStatement().execute("shutdown script");
                user.messageLog("WSMEASURE Database: Optimization procedure completed in " + (System.currentTimeMillis() - now) / 1000L + "s. HSYCO will restart now...");
                System.exit(0);
            }
        }
        catch (Exception e2) {
            user.errorLog("WSMEASURE Database: Optimization procedure failed. HSYCO will restart now...");
            System.exit(0);
        }
    }

    private static void dbCompactTrigger() {
        try {
            FileOutputStream fos = new FileOutputStream(".dbcompact");
            fos.write(66);
            fos.close();
            fos = new FileOutputStream(".dbcompact_wsmeasure");
            fos.write(66);
            fos.close();
            hsyco.messageLog("HSYCO/WSMEASURE Database: Initiating optimization procedure. HSYCO will restart now...");
            user.programTimerSet("wsmeasure.exit", 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void dbStatusDisplay() {
        try {
            File dataFile = new File("data/data.data");
            long dataSize = dataFile.length();
            File dataBackupZipFile = new File("data_wsmeasure_backup/data.zip");
            long dataBackupZipTime = dataBackupZipFile.lastModified();
            SimpleDateFormat rfc3339Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (dataSize < 1000000000L) {
                user.uiSet("wsmeasure.data.size", "value", String.valueOf(dataSize / 1000000L) + " MB");
            } else {
                DecimalFormat decimalFormat = new DecimalFormat("#0.#");
                user.uiSet("wsmeasure.data.size", "value", String.valueOf(decimalFormat.format((double)dataSize / 1.0E9)) + " GB");
            }
            if (dataBackupZipTime <= 0L) {
                user.uiSet("wsmeasure.data.backup.time", "value", "---");
            } else {
                user.uiSet("wsmeasure.data.backup.time", "value", rfc3339Format.format(dataBackupZipTime));
            }
            String s = "done".equals(dbBackupConsolidationExitStatus) ? "Ok" : ("runaway".equals(dbBackupConsolidationExitStatus) ? "$error; (1010)" : ("stalled.scripting".equals(dbBackupConsolidationExitStatus) ? "$error; (1021)" : ("stalled.pre".equals(dbBackupConsolidationExitStatus) ? "$error; (1020)" : ("stalled.post".equals(dbBackupConsolidationExitStatus) ? "$error; (1022)" : ("runaway.zip".equals(dbBackupConsolidationExitStatus) ? "$error; (1030)" : ("stalled.zip".equals(dbBackupConsolidationExitStatus) ? "$error; (1040)" : ("nospace".equals(dbBackupConsolidationExitStatus) ? "$notenoughstoragespace;" : ("exception".equals(dbBackupConsolidationExitStatus) ? "$error; (1060)" : (dbBackupConsolidationExitStatus != null && dbBackupConsolidationExitStatus.startsWith("error=") ? "$error; (" + dbBackupConsolidationExitStatus.substring(6) + ")" : "---")))))))));
            user.uiSet("wsmeasure.data.backup.status", "value", s);
            user.uiSet("wsmeasure.data.health.optimize", "visible", dataSize > 50000000L && dbBackupScriptSize > 0L && dataSize > 3L * dbBackupScriptSize ? "true" : "false");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void dbZip() {
        String[] cmdb = new String[]{"zip", "-r", "database.zip", "access.ini", "data"};
        String[] cmdr = new String[]{"unzip", "-o", "userdata/database.zip"};
        try {
            boolean restoremode;
            boolean backupmode;
            File f2 = new File(".dbzipbackup");
            if (f2.canWrite()) {
                backupmode = true;
                f2.delete();
                user.messageLog("BACKUP FLAG: FOUND");
            } else {
                backupmode = false;
            }
            f2 = new File(".dbziprestore");
            if (f2.canWrite()) {
                restoremode = true;
                f2.delete();
                user.messageLog("RESTORE FLAG: FOUND");
            } else {
                restoremode = false;
            }
            if (backupmode && !restoremode) {
                user.messageLog("BACKUP PROCEDURE: STARTING");
                user.dbConnect();
                Polling.checkPoint(true);
                user.messageLog("BACKUP PROCEDURE: DATABASE COMPACTED");
                Process proc = Runtime.getRuntime().exec(cmdb);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
                f2 = new File("database.zip");
                f2.setWritable(true, false);
                f2.renameTo(new File("userdata/database.zip"));
                user.messageLog("BACKUP PROCEDURE: END");
                System.exit(0);
            } else if (!backupmode && restoremode) {
                user.messageLog("RESTORE PROCEDURE: STARTING");
                Process proc = Runtime.getRuntime().exec(cmdr);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
                user.messageLog("RESTORE PROCEDURE: END");
                f2 = new File("userdata/database.zip");
                if (f2.canWrite()) {
                    f2.delete();
                }
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean delete(File path) {
        boolean ret = true;
        try {
            if (path.exists()) {
                if (path.isDirectory()) {
                    File[] fileArray = path.listFiles();
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File f2 = fileArray[n3];
                        ret = ret && user.delete(f2);
                        ++n3;
                    }
                }
                return ret && path.delete();
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static void fixHsycoIni() {
        String ioServers;
        Properties ini3;
        try {
            boolean wsmeasure = false;
            boolean wsmeasureill = false;
            Properties ini2 = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini2.load(inifis);
            inifis.close();
            String AutoKillFiles = ini2.getProperty("AutoKillFiles");
            String[] sa = AutoKillFiles.split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                String item = sa[i2].trim();
                if (item.equalsIgnoreCase("wsmeasure.jar")) {
                    wsmeasure = true;
                } else if (item.equalsIgnoreCase("wsmeasureill.jar")) {
                    wsmeasureill = true;
                }
                ++i2;
            }
            if (!wsmeasure) {
                ini2.put("AutoKillFiles", String.valueOf(AutoKillFiles) + ", wsmeasure.jar");
                user.safePropertiesStore(ini2, "hsyco.ini");
            } else if (!wsmeasureill) {
                ini2.put("AutoKillFiles", String.valueOf(AutoKillFiles) + ", wsmeasureill.jar");
                user.safePropertiesStore(ini2, "hsyco.ini");
            }
        }
        catch (Exception wsmeasure) {
            // empty catch block
        }
        try {
            ini3 = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini3.load(inifis);
            inifis.close();
            ioServers = ini3.getProperty("ioServers");
            if (ioServers == null) {
                ini3.put("ioServers", "telegram");
                ini3.put("ioServersType.telegram", "TELEGRAM");
                user.safePropertiesStore(ini3, "hsyco.ini");
            } else if (!ioServers.contains("telegram")) {
                ini3.put("ioServers", String.valueOf(ioServers) + ", telegram");
                ini3.put("ioServersType.telegram", "TELEGRAM");
                user.safePropertiesStore(ini3, "hsyco.ini");
            }
        }
        catch (Exception ini3) {
            // empty catch block
        }
        try {
            ini3 = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini3.load(inifis);
            inifis.close();
            ioServers = ini3.getProperty("ioServers");
            if (ioServers == null) {
                ini3.put("ioServers", "system");
                ini3.put("ioServersType.system", "SYSTEM");
                ini3.put("ioServersOptions.system", "internetmonitor=false");
                user.safePropertiesStore(ini3, "hsyco.ini");
            } else if (!ioServers.contains("system")) {
                ini3.put("ioServers", String.valueOf(ioServers) + ", system");
                ini3.put("ioServersType.system", "SYSTEM");
                ini3.put("ioServersOptions.system", "internetmonitor=false");
                user.safePropertiesStore(ini3, "hsyco.ini");
            }
        }
        catch (Exception ini4) {
            // empty catch block
        }
        try {
            boolean changed = false;
            Properties ini5 = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini5.load(inifis);
            inifis.close();
            if (ini5.getProperty("DatabaseBackup") == null) {
                changed = true;
                ini5.put("DatabaseBackup", "true");
            }
            if (ini5.getProperty("DatabaseBackupConsolidation") == null) {
                changed = true;
                ini5.put("DatabaseBackupConsolidation", "true");
            }
            if (ini5.getProperty("DatabaseRecovery") == null) {
                changed = true;
                ini5.put("DatabaseRecovery", "true");
            }
            if (ini5.getProperty("RootBackupDay") == null) {
                changed = true;
                ini5.put("RootBackupDay", "*");
            }
            if (ini5.getProperty("RootBackupHour") == null) {
                changed = true;
                ini5.put("RootBackupHour", "1");
            }
            if (ini5.getProperty("RootBackupMinute") == null) {
                changed = true;
                ini5.put("RootBackupMinute", "30");
            }
            if (changed) {
                user.safePropertiesStore(ini5, "hsyco.ini");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkLicense() {
        String ioservers = null;
        String dmxservers = null;
        String commports = null;
        String limits = null;
        try {
            String key;
            Properties ini = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini.load(inifis);
            inifis.close();
            Properties license = new Properties();
            FileInputStream licensefis = new FileInputStream("license.txt");
            license.load(licensefis);
            licensefis.close();
            Enumeration<?> e2 = ini.propertyNames();
            while (e2.hasMoreElements()) {
                key = (String)e2.nextElement();
                if (key.equalsIgnoreCase("ioServers")) {
                    if (ioservers != null) {
                        return false;
                    }
                    ioservers = ini.getProperty(key);
                    continue;
                }
                if (key.equalsIgnoreCase("dmxServers")) {
                    if (dmxservers != null) {
                        return false;
                    }
                    dmxservers = ini.getProperty(key);
                    continue;
                }
                if (!key.equalsIgnoreCase("CommPorts")) continue;
                if (commports != null) {
                    return false;
                }
                commports = ini.getProperty(key);
            }
            e2 = license.propertyNames();
            while (e2.hasMoreElements()) {
                key = (String)e2.nextElement();
                if (!key.equalsIgnoreCase("limits")) continue;
                if (limits != null) {
                    return false;
                }
                limits = license.getProperty(key);
            }
            if (limits == null || limits.length() == 0) {
                if (dmxservers != null || commports != null) {
                    return false;
                }
                if (ioservers != null) {
                    String[] a2 = ioservers.split(",");
                    int i2 = 0;
                    while (i2 < a2.length) {
                        String type = ini.getProperty("ioServersType." + a2[0].trim());
                        if (!(type.equalsIgnoreCase("telegram") || type.equalsIgnoreCase("system") || type.equalsIgnoreCase("dummy"))) {
                            return false;
                        }
                        ++i2;
                    }
                }
            }
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    static String localeToId() {
        String l2 = locale.getLanguage();
        String c2 = locale.getCountry();
        if (c2.equalsIgnoreCase("gb")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("fr")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("it")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("be")) {
            return l2.equalsIgnoreCase("fr") ? "bf" : "bn";
        }
        if (c2.equalsIgnoreCase("nl")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("es")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("cn")) {
            return c2.toLowerCase();
        }
        if (c2.equalsIgnoreCase("pt")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("gr")) {
            return c2.toLowerCase();
        }
        if (c2.equalsIgnoreCase("pl")) {
            return l2;
        }
        if (c2.equalsIgnoreCase("ru")) {
            return l2;
        }
        return "en";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int trialCounter(boolean decrement) {
        Properties tp = new Properties();
        try {
            FileInputStream fis = new FileInputStream(TRIAL_FILE);
            try {
                tp.load(fis);
                fis.close();
                int counter = Integer.parseInt(tp.getProperty("counter", "0"));
                if (counter <= 0) {
                    return 0;
                }
                if (decrement) {
                    tp.setProperty("counter", Integer.toString(--counter));
                    user.safePropertiesStore(tp, TRIAL_FILE);
                }
                return counter;
            }
            catch (Exception e2) {
                return 0;
            }
        }
        catch (Exception e3) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean trialUnlock(String code) {
        Properties tp = new Properties();
        try {
            FileInputStream fis = new FileInputStream(TRIAL_FILE);
            try {
                tp.load(fis);
                fis.close();
                if (tp.getProperty("code", "").equals(code)) {
                    trialCounter = -1;
                    return new File(TRIAL_FILE).delete();
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        catch (Exception e3) {
            return true;
        }
    }

    private static void filesDelete(File f2, File skip, long agemillis, long tailagemillis) {
        block19: {
            long now = System.currentTimeMillis();
            try {
                if (tailagemillis > 0L) {
                    long t;
                    if (f2 == null || f2.equals(skip)) {
                        return;
                    }
                    if (!f2.isDirectory()) break block19;
                    long oldest = Long.MAX_VALUE;
                    File[] files = f2.listFiles();
                    int i2 = 0;
                    while (i2 < files.length) {
                        if (files[i2].isDirectory()) {
                            user.filesDelete(files[i2], skip, agemillis, tailagemillis);
                        } else if (files[i2].isFile() && (t = files[i2].lastModified()) < oldest) {
                            oldest = t;
                        }
                        ++i2;
                    }
                    if (oldest == Long.MAX_VALUE) break block19;
                    long timeLimit = oldest + tailagemillis < now - agemillis ? oldest + tailagemillis : now - agemillis;
                    i2 = 0;
                    while (i2 < files.length) {
                        if (files[i2].isFile() && (t = files[i2].lastModified()) < timeLimit) {
                            try {
                                if (files[i2].delete()) {
                                    user.messageLog("file too old - deleted: " + files[i2].getPath());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i2;
                    }
                    break block19;
                }
                if (tailagemillis != 0L || agemillis <= 0L) break block19;
                long timeLimit = now - agemillis;
                if (f2 == null || f2.equals(skip)) {
                    return;
                }
                if (f2.isDirectory()) {
                    File[] files = f2.listFiles();
                    int i3 = 0;
                    while (i3 < files.length) {
                        user.filesDelete(files[i3], skip, agemillis, tailagemillis);
                        ++i3;
                    }
                    break block19;
                }
                if (!f2.isFile() || f2.lastModified() >= timeLimit) break block19;
                try {
                    if (f2.delete()) {
                        user.messageLog("file too old - deleted: " + f2.getPath());
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static long availableSpace() {
        File root;
        block3: {
            try {
                root = new File(".");
                if (root.exists()) break block3;
                return Long.MAX_VALUE;
            }
            catch (Exception e2) {
                user.errorLog("availableSpace - Generic exception - " + e2.getLocalizedMessage());
                return Long.MAX_VALUE;
            }
        }
        return root.getUsableSpace();
    }

    static void safePropertiesStore(Properties p, String filename) throws Exception {
        File destFile = new File(filename);
        File tempFile = new File(String.valueOf(util.isWindows ? "_" : ".~") + filename);
        FileOutputStream fos = new FileOutputStream(tempFile);
        p.store(fos, "Generated by WSMEASURE " + VERSION);
        fos.flush();
        fos.close();
        if (util.isWindows) {
            destFile.delete();
        }
        tempFile.renameTo(destFile);
        destFile.setWritable(true, false);
    }

    static byte[] encodeInteger(long value) {
        try {
            BigInteger number = BigInteger.valueOf(value);
            byte[] bv = number.toByteArray();
            byte[] b2 = new byte[8];
            int i2 = 0;
            while (i2 < b2.length) {
                if (bv.length - 1 >= i2) {
                    b2[b2.length - 1 - i2] = bv[bv.length - 1 - i2];
                } else if (number.signum() == -1) {
                    b2[b2.length - 1 - i2] = -1;
                }
                ++i2;
            }
            return b2;
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int upload(String path, byte[] post) {
        String boundary = "\r\n";
        String header = "";
        int state = 0;
        int fileBegin = 0;
        int fileEnd = 0;
        try {
            File destPath = new File(path);
            user.pathSanityCheck(destPath, false);
            int i2 = 0;
            while (true) {
                if (i2 >= post.length) {
                    return post.length;
                }
                switch (state) {
                    case 0: {
                        if (post[i2] == 13) {
                            if (post[i2 + 1] != 10) {
                                return -1;
                            }
                            state = 1;
                            ++i2;
                            break;
                        }
                        boundary = String.valueOf(boundary) + (char)post[i2];
                        break;
                    }
                    case 1: {
                        if (post[i2] == 13 && post[i2 + 1] == 10 && post[i2 + 2] == 13 && post[i2 + 3] == 10) {
                            fileBegin = i2 + 4;
                            state = 2;
                            i2 += 4;
                            break;
                        }
                        header = String.valueOf(header) + (char)post[i2];
                        break;
                    }
                    case 2: {
                        int p = 0;
                        while (p < boundary.length()) {
                            if ((char)post[i2 + p] == boundary.charAt(p)) {
                                state = 3;
                                ++p;
                                continue;
                            }
                            state = 2;
                            break;
                        }
                        if (state != 3) break;
                        fileEnd = i2 - 1;
                        ++i2;
                        if (fileBegin <= fileEnd) {
                            int nb = header.indexOf("filename=\"");
                            if (nb == -1) {
                                return -1;
                            }
                            String filename = header.substring(nb += 10, header.indexOf(34, nb));
                            int ps1 = filename.lastIndexOf(47);
                            int ps2 = filename.lastIndexOf(92);
                            if (ps1 != -1 || ps2 != -1) {
                                filename = filename.substring((ps1 >= ps2 ? ps1 : ps2) + 1);
                            }
                            if (filename.endsWith(".zip")) {
                                File destFile = new File(new File("plugins"), filename);
                                user.pathSanityCheck(destFile, false);
                                File parent = destFile.getParentFile();
                                if (!parent.isDirectory() && parent.mkdir()) {
                                    parent.setWritable(true, false);
                                }
                                if (!user.unzip(destFile, new ByteArrayInputStream(post, fileBegin, fileEnd - fileBegin + 1))) {
                                    return -1;
                                }
                            } else {
                                if (!filename.equals("wsmeasure.jar") && !filename.equals("wsmeasureill.jar")) {
                                    return -1;
                                }
                                File tempFile = new File(destPath, ".~" + filename);
                                File destFile = new File(destPath, filename);
                                user.pathSanityCheck(destFile, false);
                                if (!user.validateJarUpload(post, fileBegin, fileEnd - fileBegin + 1)) {
                                    return -1;
                                }
                                FileOutputStream fos = new FileOutputStream(tempFile);
                                fos.write(post, fileBegin, fileEnd - fileBegin + 1);
                                fos.close();
                                tempFile.renameTo(destFile);
                                destFile.setWritable(true, false);
                            }
                        }
                        state = 0;
                        boundary = "\r\n";
                        header = "";
                        break;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return -1;
        }
    }

    static boolean unzip(File zipfile, ByteArrayInputStream data) {
        byte[] buffer = new byte[4096];
        try {
            String zipname = zipfile.getName();
            if (zipname.toLowerCase().endsWith(".zip")) {
                ZipEntry entry;
                String basepath = zipfile.getParent();
                String zipbasepath = zipname.substring(0, zipname.length() - 4);
                ZipInputStream zin = new ZipInputStream(data);
                while ((entry = zin.getNextEntry()) != null) {
                    if (entry.getName().startsWith(zipbasepath) && !entry.isDirectory()) {
                        int len;
                        File entryfile = new File(basepath, entry.getName());
                        user.mkdir(entryfile.getParentFile());
                        FileOutputStream fos = new FileOutputStream(entryfile);
                        while ((len = zin.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        entryfile.setWritable(true, false);
                    }
                    zin.closeEntry();
                }
                zin.close();
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static void mkdir(File f2) {
        try {
            if (f2 != null) {
                user.mkdir(f2.getParentFile());
                if (f2.mkdir()) {
                    f2.setWritable(true, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void pathSanityCheck(File f2, boolean rootExclusion) throws Exception {
        File root = new File(".");
        if (!f2.getCanonicalPath().startsWith(root.getCanonicalPath())) {
            throw new SecurityException("FileServer - pathSanityCheck Violation");
        }
        if (rootExclusion && f2.getCanonicalPath().equals(root.getCanonicalPath())) {
            throw new SecurityException("FileServer - pathSanityCheck Root Violation");
        }
    }

    private static boolean isYMD(int date) {
        GregorianCalendar cal = new GregorianCalendar();
        try {
            int year = date / 10000;
            int month = date % 10000 / 100;
            int day = date % 100;
            cal.setLenient(false);
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.getTimeInMillis();
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static boolean accessIniInitialize() {
        File accessFile = new File("access.ini");
        if (accessFile.canRead() && accessFile.length() == 0L) {
            try {
                Properties ap = new Properties();
                ap.setProperty("*administrator", "a045b7efa463c6ed195c644163f4168952fbd34a,d3ffe2a443f46b47ba76b08f7e03eab7ef29ec8,0,0,0.0.0.0");
                ap.setProperty("installer", "69df79bef9287d3bcb8f104a408b6de6a108fd8,535648254d8e8ce73c1a2d826e52cab7ad83cfa,0,0,0.0.0.0");
                ap.setProperty("user", "7b21848ac9af35beddb2d6b9fc3851934db8420,2fea87c5aa2d32b0fbe69eecdd1283d072a2567,0,0,0.0.0.0");
                if (greenUpEnabled) {
                    ap.setProperty("*GreenUp", "9eab102e8f9431bb2316851d11e658eb20b730,91c7fede8c6da970576f14148c3f6b4a36d18fb,0,0,0.0.0.0");
                }
                FileOutputStream fos = new FileOutputStream(accessFile);
                ap.store(fos, "Generated by WSMEASURE - Factory configuration");
                fos.close();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void readModelsXls(String version, boolean contrelSupport, boolean entesSupport, boolean genericModbusSupport) {
        Integer[] MCALL;
        int namecolumn;
        HsycoFile f2 = new HsycoFile("plugins/wsmeasure/resources", "wsmeasure-models.xls");
        ByteArrayInputStream bis = new ByteArrayInputStream(f2.getBytes());
        int r = 0;
        int c2 = 0;
        String[] MOINV = new String[]{"inv"};
        if (version.equals("lg")) {
            namecolumn = 2;
            MCALL = entesSupport ? new Integer[]{0, 1, 2, 3, 4, 5, 6} : new Integer[]{0, 2, 3, 4, 5, 6};
            Concentrators.add("0 046 87,004687".split(","));
            if (entesSupport) {
                Concentrators.add("ENTES EPC-12,ENTES EPC-12".split(","));
            } else {
                Concentrators.add(null);
            }
            Concentrators.add("4 120 65,412065".split(","));
            Concentrators.add("4 149 26,414926".split(","));
            Concentrators.add("4 120 81,412081".split(","));
            Concentrators.add("4 120 91,412091".split(","));
            Concentrators.add("4 120 41,412041".split(","));
        } else if (version.equals("bt")) {
            namecolumn = 6;
            MCALL = entesSupport ? new Integer[]{0, 1, 2, 3} : new Integer[]{0, 2, 3};
            Concentrators.add("F4CON,F4CON".split(","));
            if (entesSupport) {
                Concentrators.add("ENTES EPC-12,ENTES EPC-12".split(","));
            } else {
                Concentrators.add(null);
            }
            Concentrators.add("F4CON12,F4CON12".split(","));
            Concentrators.add("F80BI,F80BI".split(","));
            Concentrators.add(null);
            Concentrators.add(null);
            Concentrators.add(null);
        } else if (version.equals("ime")) {
            namecolumn = 10;
            MCALL = entesSupport ? new Integer[]{1, 2, 3, 4, 5, 6} : new Integer[]{2, 3, 4, 5, 6};
            Concentrators.add(null);
            if (entesSupport) {
                Concentrators.add("ENTES EPC-12,ENTES EPC-12".split(","));
            } else {
                Concentrators.add(null);
            }
            Concentrators.add("IF4C001,IF4C001".split(","));
            Concentrators.add("SXMIMP,SXMIMP".split(","));
            Concentrators.add("CE2DF3DTCL1,CE2DF3DTCL1".split(","));
            Concentrators.add("CE4DF3DTCL1,CE4DF3DTCL1".split(","));
            Concentrators.add("CE4TBDTCL1,CE4TBDTCL1".split(","));
        } else {
            user.errorLog("STARTUP ERROR: wsmeasure-models.xls brand version error");
            return;
        }
        try {
            HSSFWorkbook wb = new HSSFWorkbook(bis);
            bis.close();
            Sheet sheet = wb.getSheet("MODELS");
            r = 1;
            while (r <= sheet.getLastRowNum()) {
                Row row = sheet.getRow(r);
                String[] modelData = new String[16];
                c2 = namecolumn;
                String name = row.getCell(c2).getStringCellValue();
                c2 = 1;
                String alias = row.getCell(1).getStringCellValue();
                modelData[0] = name;
                c2 = namecolumn + 1;
                modelData[1] = row.getCell(c2).getStringCellValue();
                c2 = namecolumn + 2;
                modelData[13] = row.getCell(c2).getStringCellValue();
                c2 = namecolumn + 3;
                modelData[14] = row.getCell(c2).getStringCellValue();
                modelData[15] = alias;
                if (alias.length() == 0) {
                    c2 = 14;
                    while (c2 < 25) {
                        modelData[c2 - 12] = row.getCell(c2).getStringCellValue();
                        ++c2;
                    }
                } else {
                    String[] aliasData = Models.get(Integer.parseInt(alias));
                    c2 = 14;
                    while (c2 < 25) {
                        modelData[c2 - 12] = new String(aliasData[c2 - 12]);
                        ++c2;
                    }
                }
                if (r == 42) {
                    Models.add((String[])(contrelSupport ? modelData : null));
                } else if (r == 44) {
                    Models.add((String[])(genericModbusSupport ? modelData : null));
                } else if (r == 49 || r == 50) {
                    Models.add((String[])(entesSupport ? modelData : null));
                } else {
                    Models.add(modelData);
                }
                if (alias.length() == 0) {
                    c2 = 25;
                    ModelsConcentrators.add((Integer[])(row.getCell(25).getStringCellValue().equalsIgnoreCase("Y") ? MCALL : null));
                    c2 = 26;
                    ModelsOptions.add((String[])(row.getCell(26).getStringCellValue().equalsIgnoreCase("MOINV") ? MOINV : null));
                } else {
                    int aid = Integer.parseInt(alias);
                    ModelsConcentrators.add(ModelsConcentrators.elementAt(aid));
                    ModelsOptions.add(ModelsOptions.elementAt(aid));
                }
                ++r;
            }
            wb.close();
        }
        catch (Exception e2) {
            user.errorLog("STARTUP ERROR: wsmeasure-models.xls R" + r + "C" + c2 + ": " + e2.getMessage());
        }
    }

    public static boolean isGreenUpModel(int model) {
        try {
            return Models.get(model)[12].startsWith("greenup");
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean isPFCModel(int model) {
        switch (model) {
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                return true;
            }
        }
        return false;
    }

    public static byte[] modbusSendPdu(int deviceid, byte[] pdu) throws Exception {
        String[] aa;
        SensorCache sensor = Polling.sensorCache.get(deviceid);
        if (sensor == null) {
            sensor = Polling.sensorGet(deviceid);
        }
        if ((aa = sensor.gatewayaddress.split("[:]")).length == 1) {
            return user.modbusSendPdu(sensor.gatewayaddress, 502, sensor.address, pdu);
        }
        return user.modbusSendPdu(aa[0], Integer.parseInt(aa[1]), sensor.address, pdu);
    }

    public static byte[] modbusSendPdu(String hostname, int port, int unitid, byte[] pdu) throws Exception {
        Socket sock = new Socket();
        try {
            sock.connect(new InetSocketAddress(hostname, port), 3000);
            byte[] byArray = user.modbusSendPdu(sock, unitid, pdu);
            return byArray;
        }
        finally {
            sock.close();
        }
    }

    public static byte[] modbusSendPdu(Socket sock, int unitid, byte[] data) throws Exception {
        ByteArrayOutputStream pdu = new ByteArrayOutputStream();
        byte[] mbap = new byte[7];
        int length = 1 + data.length;
        BufferedInputStream in = new BufferedInputStream(sock.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream());
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(length / 256);
        out.write(length % 256);
        out.write(unitid);
        out.write(data);
        out.flush();
        in.read(mbap);
        if (mbap[6] == (byte)unitid) {
            length = 256 * (mbap[4] & 0xFF) + (mbap[5] & 0xFF) - 1;
            int i2 = 0;
            while (i2 < length) {
                pdu.write(in.read());
                ++i2;
            }
            return pdu.toByteArray();
        }
        return null;
    }

    private static class ModbusServerResponseCache {
        byte[] response;
        long timestamp;

        public ModbusServerResponseCache(byte[] response, long timestamp) {
            this.response = Arrays.copyOf(response, response.length);
            this.timestamp = timestamp;
        }

        public void setResponse(byte[] response, long timestamp) {
            this.response = Arrays.copyOf(response, response.length);
            this.timestamp = timestamp;
        }
    }
}

