/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.Configuration;
import com.hsyco.Graphics;
import com.hsyco.HsycoFile;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import plugins.wsmeasure.DataProcessor;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reports {
    private static PDFont font = PDType1Font.HELVETICA;
    private static Properties ptxt = null;
    private static String language = null;
    private static String version = null;
    private static boolean emailReporterSemaphore = false;
    private static final double CO2_TO_WH = 1883.2;

    public static void init() {
        language = user.localeToId();
        version = user.version;
        try {
            ptxt = new Properties();
            HsycoFile f2 = new HsycoFile("plugins/wsmeasure/resources/pdf/" + version, "text_" + ("cn gr pl ru".contains(language) ? "en" : language) + ".txt");
            ByteArrayInputStream bis = new ByteArrayInputStream(f2.getBytes());
            ptxt.load(bis);
            bis.close();
        }
        catch (Exception e2) {
            ptxt = null;
        }
    }

    public static byte[] annualReportPDF(int year) {
        PDDocument document = null;
        PDPageContentStream content = null;
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Hashtable<String, String> energyData = null;
        Hashtable<String, String> gasData = null;
        Hashtable<String, String> waterData = null;
        Hashtable<String, String> partialData = null;
        String[][] t11 = new String[1][1];
        String[][] t12 = new String[1][2];
        String[][] t53 = new String[5][3];
        String[][] t143 = new String[14][3];
        int page = 1;
        try {
            int i2;
            String[] x2;
            double[] c2;
            double[] v2;
            String[] thisyearcostdata;
            String thisyearcost;
            String[] thisyeardata;
            String thisyear;
            String[] c1;
            String[] x1;
            double[] v1;
            double lastyeartotalenergy;
            double thisyeartotalenergy;
            String lastyeartotalcost;
            String thisyeartotalcost;
            double m3ToWh;
            try {
                m3ToWh = Double.parseDouble(user.varGet("gaskwhm3!"));
            }
            catch (Exception e2) {
                m3ToWh = 0.0;
            }
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            String today = new SimpleDateFormat("yyyy-MM-dd").format(new Date(cal.getTimeInMillis()));
            cal.set(2, 11);
            cal.set(1, year);
            cal.set(5, 1);
            cal.set(5, cal.getActualMaximum(5));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            energyData = user.energyTotalView(t);
            gasData = user.gasTotalView(t);
            waterData = user.waterTotalView(t);
            document = new PDDocument();
            String docname = String.valueOf(ptxt.getProperty("yearlyreport")) + " - " + year + " (" + today + ")";
            content = Reports.addPage(document, docname, page++);
            Reports.drawTitle(document, content, docname);
            Reports.drawImage(document, content, "icongrand.png", 0.0f, 760.0f, 20.0f, 18.0f);
            Reports.drawText(document, content, ptxt.getProperty("overall"), 14.0f, 20.0f, 764.0f, 0, false);
            String s = energyData.get("thisyeartotalcost");
            double ce = Double.parseDouble(s.substring(0, s.indexOf(32)));
            s = gasData.get("thisyeartotalcost");
            double cg = Double.parseDouble(s.substring(0, s.indexOf(32)));
            s = waterData.get("thisyeartotalcost");
            double cw = Double.parseDouble(s.substring(0, s.indexOf(32)));
            Reports.drawEnergyPie(document, content, 200.0f, 500.0f, 200.0f, 200.0f, ce, cg, cw);
            t53[0][1] = ptxt.getProperty("thisyear");
            t53[1][0] = ptxt.getProperty("quantity");
            t53[1][1] = ptxt.getProperty("value");
            t53[1][2] = ptxt.getProperty("cost");
            t53[2][0] = ptxt.getProperty("electricity");
            t53[2][1] = Reports.energyFormatter(Double.parseDouble(energyData.get("thisyeartotalenergy")), 2, "Wh");
            t53[2][2] = Reports.costFormatter(energyData.get("thisyeartotalcost"), 2);
            t53[3][0] = ptxt.getProperty("gas");
            t53[3][1] = Reports.energyFormatterGas(Double.parseDouble(gasData.get("thisyeartotalenergy")) / 1000.0, 1, m3ToWh);
            t53[3][2] = Reports.costFormatter(gasData.get("thisyeartotalcost"), 2);
            t53[4][0] = ptxt.getProperty("water");
            t53[4][1] = Reports.energyFormatter(Double.parseDouble(waterData.get("thisyeartotalenergy")) / 1000.0, 2, "m3");
            t53[4][2] = Reports.costFormatter(waterData.get("thisyeartotalcost"), 2);
            Reports.drawMatrix(document, content, 100.0f, 300.0f, 400.0f, 80.0f, t53, null, 2, 0);
            t53[0][1] = ptxt.getProperty("lastyear");
            t53[2][1] = Reports.energyFormatter(Double.parseDouble(energyData.get("lastyeartotalenergy")), 2, "Wh");
            t53[2][2] = Reports.costFormatter(energyData.get("lastyeartotalcost"), 2);
            t53[3][1] = Reports.energyFormatterGas(Double.parseDouble(gasData.get("lastyeartotalenergy")) / 1000.0, 1, m3ToWh);
            t53[3][2] = Reports.costFormatter(gasData.get("lastyeartotalcost"), 2);
            t53[4][1] = Reports.energyFormatter(Double.parseDouble(waterData.get("lastyeartotalenergy")) / 1000.0, 2, "m3");
            t53[4][2] = Reports.costFormatter(waterData.get("lastyeartotalcost"), 2);
            Reports.drawMatrix(document, content, 100.0f, 200.0f, 400.0f, 80.0f, t53, null, 2, 0);
            content.close();
            if (Double.parseDouble(energyData.get("thisyeartotalenergy")) > 0.0 || Double.parseDouble(energyData.get("lastyeartotalenergy")) > 0.0) {
                content = Reports.addPage(document, docname, page++);
                thisyeartotalcost = energyData.get("thisyeartotalcost");
                lastyeartotalcost = energyData.get("lastyeartotalcost");
                thisyeartotalenergy = Double.parseDouble(energyData.get("thisyeartotalenergy"));
                lastyeartotalenergy = Double.parseDouble(energyData.get("lastyeartotalenergy"));
                Reports.drawImage(document, content, "iconload-2.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, ptxt.getProperty("electricity"), 14.0f, 20.0f, 764.0f, 0, false);
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thisyeartotalenergy, 2, "Wh");
                t12[0][1] = Reports.costFormatter(thisyeartotalcost, 2);
                Reports.drawMatrix(document, content, 20.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastyeartotalenergy, 2, "Wh");
                t12[0][1] = Reports.costFormatter(lastyeartotalcost, 2);
                Reports.drawMatrix(document, content, 320.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisyeartotalenergy, lastyeartotalenergy};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "Wh", false);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("yearlyreport")) + " " + ptxt.getProperty("electricity"), 10.0f, 298.0f, 280.0f, 1, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 160.0f, thisyeartotalcost, lastyeartotalcost);
                Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 160.0f, thisyeartotalenergy, lastyeartotalenergy);
                content.close();
                content = Reports.addPage(document, docname, page++);
                Reports.drawImage(document, content, "iconload-2.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("electricity")) + " - " + ptxt.getProperty("trend"), 14.0f, 20.0f, 764.0f, 0, false);
                partialData = user.meterPartialView(t, -2, -2);
                thisyear = partialData.get("thisyear");
                thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                thisyearcost = partialData.get("thisyearcost");
                thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                v2 = new double[12];
                c2 = new double[12];
                x2 = new String[12];
                t143[0][1] = ptxt.getProperty("thisyear");
                t143[1][0] = ptxt.getProperty("month");
                t143[1][1] = ptxt.getProperty("value");
                t143[1][2] = ptxt.getProperty("cost");
                i2 = 0;
                while (i2 < 12) {
                    v2[i2] = Double.parseDouble(thisyeardata[i2]);
                    c2[i2] = Double.parseDouble(thisyearcostdata[i2]);
                    x2[i2] = ptxt.getProperty("month_short_" + (i2 + 1));
                    t143[i2 + 2][0] = ptxt.getProperty("month_" + (i2 + 1));
                    t143[i2 + 2][1] = Reports.energyFormatter(v2[i2], 2, "Wh");
                    t143[i2 + 2][2] = Reports.costFormatter(String.valueOf(c2[i2] / 1000000.0) + " " + energycurrency, 2);
                    ++i2;
                }
                Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v2, null, x2, null, "Wh", false);
                Reports.drawMatrix(document, content, 100.0f, 150.0f, 400.0f, 250.0f, t143, null, 2, 0);
                content.close();
            }
            if (Double.parseDouble(gasData.get("thisyeartotalenergy")) > 0.0 || Double.parseDouble(gasData.get("lastyeartotalenergy")) > 0.0) {
                content = Reports.addPage(document, docname, page++);
                thisyeartotalcost = gasData.get("thisyeartotalcost");
                lastyeartotalcost = gasData.get("lastyeartotalcost");
                thisyeartotalenergy = Double.parseDouble(gasData.get("thisyeartotalenergy"));
                lastyeartotalenergy = Double.parseDouble(gasData.get("lastyeartotalenergy"));
                Reports.drawImage(document, content, "iconload-4.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, ptxt.getProperty("gas"), 14.0f, 20.0f, 764.0f, 0, false);
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(thisyeartotalenergy / 1000.0, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(thisyeartotalcost, 2);
                Reports.drawMatrix(document, content, 20.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t12[0][0] = Reports.energyFormatterGas(lastyeartotalenergy / 1000.0, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(lastyeartotalcost, 2);
                Reports.drawMatrix(document, content, 320.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisyeartotalenergy / 1000.0, lastyeartotalenergy / 1000.0};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("yearlyreport")) + " " + ptxt.getProperty("gas"), 10.0f, 298.0f, 280.0f, 1, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 160.0f, thisyeartotalcost, lastyeartotalcost);
                Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 160.0f, thisyeartotalenergy * m3ToWh / 1000000.0, lastyeartotalenergy * m3ToWh / 1000000.0);
                content.close();
                content = Reports.addPage(document, docname, page++);
                Reports.drawImage(document, content, "iconload-4.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("gas")) + " - " + ptxt.getProperty("trend"), 14.0f, 20.0f, 764.0f, 0, false);
                partialData = user.meterPartialView(t, -4, -4);
                thisyear = partialData.get("thisyear");
                thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                thisyearcost = partialData.get("thisyearcost");
                thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                v2 = new double[12];
                c2 = new double[12];
                x2 = new String[12];
                t143[0][1] = ptxt.getProperty("thisyear");
                t143[1][0] = ptxt.getProperty("month");
                t143[1][1] = ptxt.getProperty("value");
                t143[1][2] = ptxt.getProperty("cost");
                i2 = 0;
                while (i2 < 12) {
                    v2[i2] = Double.parseDouble(thisyeardata[i2]) / 1000.0;
                    c2[i2] = Double.parseDouble(thisyearcostdata[i2]);
                    x2[i2] = ptxt.getProperty("month_short_" + (i2 + 1));
                    t143[i2 + 2][0] = ptxt.getProperty("month_" + (i2 + 1));
                    t143[i2 + 2][1] = m3ToWh == 0.0 ? Reports.energyFormatter(v2[i2], 2, "m3") : String.valueOf(Reports.energyFormatter(v2[i2], 1, "m3")) + " - " + Reports.energyFormatter(v2[i2] * m3ToWh, 1, "Wh");
                    t143[i2 + 2][2] = Reports.costFormatter(String.valueOf(c2[i2] / 1000000.0) + " " + energycurrency, 2);
                    ++i2;
                }
                Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v2, null, x2, null, "m3", false);
                Reports.drawMatrix(document, content, 100.0f, 150.0f, 400.0f, 250.0f, t143, null, 2, 0);
                content.close();
            }
            if (Double.parseDouble(waterData.get("thisyeartotalenergy")) > 0.0 || Double.parseDouble(waterData.get("lastyeartotalenergy")) > 0.0) {
                content = Reports.addPage(document, docname, page++);
                thisyeartotalcost = waterData.get("thisyeartotalcost");
                lastyeartotalcost = waterData.get("lastyeartotalcost");
                thisyeartotalenergy = Double.parseDouble(waterData.get("thisyeartotalenergy"));
                lastyeartotalenergy = Double.parseDouble(waterData.get("lastyeartotalenergy"));
                Reports.drawImage(document, content, "iconload-3.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, ptxt.getProperty("water"), 14.0f, 20.0f, 764.0f, 0, false);
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thisyeartotalenergy / 1000.0, 2, "m3");
                t12[0][1] = Reports.costFormatter(thisyeartotalcost, 2);
                Reports.drawMatrix(document, content, 20.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastyeartotalenergy / 1000.0, 2, "m3");
                t12[0][1] = Reports.costFormatter(lastyeartotalcost, 2);
                Reports.drawMatrix(document, content, 320.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisyeartotalenergy / 1000.0, lastyeartotalenergy / 1000.0};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("yearlyreport")) + " " + ptxt.getProperty("water"), 10.0f, 298.0f, 280.0f, 1, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, thisyeartotalcost, lastyeartotalcost);
                content.close();
                content = Reports.addPage(document, docname, page++);
                Reports.drawImage(document, content, "iconload-3.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("water")) + " - " + ptxt.getProperty("trend"), 14.0f, 20.0f, 764.0f, 0, false);
                partialData = user.meterPartialView(t, -3, -3);
                thisyear = partialData.get("thisyear");
                thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                thisyearcost = partialData.get("thisyearcost");
                thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                v2 = new double[12];
                c2 = new double[12];
                x2 = new String[12];
                t143[0][1] = ptxt.getProperty("thisyear");
                t143[1][0] = ptxt.getProperty("month");
                t143[1][1] = ptxt.getProperty("value");
                t143[1][2] = ptxt.getProperty("cost");
                i2 = 0;
                while (i2 < 12) {
                    v2[i2] = Double.parseDouble(thisyeardata[i2]) / 1000.0;
                    c2[i2] = Double.parseDouble(thisyearcostdata[i2]);
                    x2[i2] = ptxt.getProperty("month_short_" + (i2 + 1));
                    t143[i2 + 2][0] = ptxt.getProperty("month_" + (i2 + 1));
                    t143[i2 + 2][1] = Reports.energyFormatter(v2[i2], 2, "m3");
                    t143[i2 + 2][2] = Reports.costFormatter(String.valueOf(c2[i2] / 1000000.0) + " " + energycurrency, 2);
                    ++i2;
                }
                Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v2, null, x2, null, "m3", false);
                Reports.drawMatrix(document, content, 100.0f, 150.0f, 400.0f, 250.0f, t143, null, 2, 0);
                content.close();
            }
            content = Reports.addPage(document, docname, page++);
            Reports.drawImage(document, content, "iconpartial.png", 0.0f, 760.0f, 20.0f, 18.0f);
            Reports.drawText(document, content, String.valueOf(ptxt.getProperty("electricity")) + " " + ptxt.getProperty("loads"), 14.0f, 20.0f, 764.0f, 0, false);
            String yearloads = energyData.get("year");
            String[] sa = yearloads.substring(1, yearloads.length() - 1).split(",");
            double[] loaddata = new double[sa.length / 5];
            double[] loadcost = new double[sa.length / 5];
            String[] loadname = new String[sa.length / 5];
            int loadsnumber = 0;
            int i3 = 0;
            while (i3 < loaddata.length) {
                int loadid = Integer.parseInt(sa[i3 * 5].substring(1));
                if (loadid == -2) break;
                loadsnumber = i3 + 1;
                loadname[i3] = loadid == -1 ? ptxt.getProperty("others") : DataProcessor.filterLoadNames((String)loadnames.get(loadid), true);
                loaddata[i3] = Double.parseDouble(sa[i3 * 5 + 1]);
                loadcost[i3] = Double.parseDouble(sa[i3 * 5 + 3]);
                ++i3;
            }
            double[] v3 = new double[loadsnumber];
            double[] c3 = new double[loadsnumber];
            String[] x3 = new String[loadsnumber];
            String[][] tx3 = new String[loadsnumber + 2][3];
            tx3[0][1] = ptxt.getProperty("thisyear");
            tx3[1][0] = ptxt.getProperty("loads");
            tx3[1][1] = ptxt.getProperty("value");
            tx3[1][2] = ptxt.getProperty("cost");
            int i4 = 0;
            while (i4 < loadsnumber) {
                v3[i4] = loaddata[i4];
                c3[i4] = loadcost[i4];
                x3[i4] = loadname[i4];
                tx3[i4 + 2][0] = loadname[i4];
                tx3[i4 + 2][1] = Reports.energyFormatter(v3[i4], 2, "Wh");
                tx3[i4 + 2][2] = Reports.costFormatter(String.valueOf(c3[i4] / 1000000.0) + " " + energycurrency, 2);
                ++i4;
            }
            Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v3, null, x3, null, "Wh", true);
            Reports.drawMatrix(document, content, 100.0f, 400 - (loadsnumber + 2) * 18, 400.0f, (loadsnumber + 2) * 18, tx3, null, 2, 0);
            content.close();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            document.save(bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e3) {
            user.errorLog("annualReport Exception: " + e3);
            e3.printStackTrace();
            return null;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] montlyReportPDF(int year, int month) {
        PDDocument document = null;
        PDPageContentStream content = null;
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Hashtable<String, String> energyData = null;
        Hashtable<String, String> gasData = null;
        Hashtable<String, String> waterData = null;
        Hashtable<String, String> partialData = null;
        String[][] t11 = new String[1][1];
        String[][] t12 = new String[1][2];
        String[][] t53 = new String[5][3];
        String[][] t333 = new String[33][3];
        int page = 1;
        try {
            int i2;
            String[] x2;
            double[] c2;
            double[] v2;
            String[] thismonthcostdata;
            String thismonthcost;
            String[] thismonthdata;
            String thismonth;
            String[] c1;
            String[] x1;
            double[] v1;
            double lastmonthtotalenergy;
            double thismonthtotalenergy;
            String lastmonthtotalcost;
            String thismonthtotalcost;
            double m3ToWh;
            try {
                m3ToWh = Double.parseDouble(user.varGet("gaskwhm3!"));
            }
            catch (Exception e2) {
                m3ToWh = 0.0;
            }
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            String today = new SimpleDateFormat("yyyy-MM-dd").format(new Date(cal.getTimeInMillis()));
            cal.set(2, month - 1);
            cal.set(1, year);
            cal.set(5, 1);
            int lastDayOfMonth = cal.getActualMaximum(5);
            cal.set(5, lastDayOfMonth);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            energyData = user.energyTotalView(t);
            gasData = user.gasTotalView(t);
            waterData = user.waterTotalView(t);
            document = new PDDocument();
            String docname = String.valueOf(ptxt.getProperty("monthlyreport")) + " - " + ptxt.getProperty("month_" + month) + " " + year + " (" + today + ")";
            content = Reports.addPage(document, docname, page++);
            Reports.drawTitle(document, content, docname);
            Reports.drawImage(document, content, "icongrand.png", 0.0f, 760.0f, 20.0f, 18.0f);
            Reports.drawText(document, content, ptxt.getProperty("overall"), 14.0f, 20.0f, 764.0f, 0, false);
            String s = energyData.get("thismonthtotalcost");
            double ce = Double.parseDouble(s.substring(0, s.indexOf(32)));
            s = gasData.get("thismonthtotalcost");
            double cg = Double.parseDouble(s.substring(0, s.indexOf(32)));
            s = waterData.get("thismonthtotalcost");
            double cw = Double.parseDouble(s.substring(0, s.indexOf(32)));
            Reports.drawEnergyPie(document, content, 200.0f, 500.0f, 200.0f, 200.0f, ce, cg, cw);
            t53[0][1] = ptxt.getProperty("thismonth");
            t53[1][0] = ptxt.getProperty("quantity");
            t53[1][1] = ptxt.getProperty("value");
            t53[1][2] = ptxt.getProperty("cost");
            t53[2][0] = ptxt.getProperty("electricity");
            t53[2][1] = Reports.energyFormatter(Double.parseDouble(energyData.get("thismonthtotalenergy")), 2, "Wh");
            t53[2][2] = Reports.costFormatter(energyData.get("thismonthtotalcost"), 2);
            t53[3][0] = ptxt.getProperty("gas");
            t53[3][1] = Reports.energyFormatterGas(Double.parseDouble(gasData.get("thismonthtotalenergy")) / 1000.0, 1, m3ToWh);
            t53[3][2] = Reports.costFormatter(gasData.get("thismonthtotalcost"), 2);
            t53[4][0] = ptxt.getProperty("water");
            t53[4][1] = Reports.energyFormatter(Double.parseDouble(waterData.get("thismonthtotalenergy")) / 1000.0, 2, "m3");
            t53[4][2] = Reports.costFormatter(waterData.get("thismonthtotalcost"), 2);
            Reports.drawMatrix(document, content, 100.0f, 300.0f, 400.0f, 80.0f, t53, null, 2, 0);
            t53[0][1] = ptxt.getProperty("lastmonth");
            t53[2][1] = Reports.energyFormatter(Double.parseDouble(energyData.get("lastmonthtotalenergy")), 2, "Wh");
            t53[2][2] = Reports.costFormatter(energyData.get("lastmonthtotalcost"), 2);
            t53[3][1] = Reports.energyFormatterGas(Double.parseDouble(gasData.get("lastmonthtotalenergy")) / 1000.0, 1, m3ToWh);
            t53[3][2] = Reports.costFormatter(gasData.get("lastmonthtotalcost"), 2);
            t53[4][1] = Reports.energyFormatter(Double.parseDouble(waterData.get("lastmonthtotalenergy")) / 1000.0, 2, "m3");
            t53[4][2] = Reports.costFormatter(waterData.get("lastmonthtotalcost"), 2);
            Reports.drawMatrix(document, content, 100.0f, 200.0f, 400.0f, 80.0f, t53, null, 2, 0);
            content.close();
            if (Double.parseDouble(energyData.get("thismonthtotalenergy")) > 0.0 || Double.parseDouble(energyData.get("lastmonthtotalenergy")) > 0.0) {
                content = Reports.addPage(document, docname, page++);
                thismonthtotalcost = energyData.get("thismonthtotalcost");
                lastmonthtotalcost = energyData.get("lastmonthtotalcost");
                thismonthtotalenergy = Double.parseDouble(energyData.get("thismonthtotalenergy"));
                lastmonthtotalenergy = Double.parseDouble(energyData.get("lastmonthtotalenergy"));
                Reports.drawImage(document, content, "iconload-2.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, ptxt.getProperty("electricity"), 14.0f, 20.0f, 764.0f, 0, false);
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thismonthtotalenergy, 2, "Wh");
                t12[0][1] = Reports.costFormatter(thismonthtotalcost, 2);
                Reports.drawMatrix(document, content, 20.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastmonthtotalenergy, 2, "Wh");
                t12[0][1] = Reports.costFormatter(lastmonthtotalcost, 2);
                Reports.drawMatrix(document, content, 320.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thismonthtotalenergy, lastmonthtotalenergy};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "Wh", false);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("monthlyreport")) + " " + ptxt.getProperty("electricity"), 10.0f, 298.0f, 280.0f, 1, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 160.0f, thismonthtotalcost, lastmonthtotalcost);
                Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 160.0f, thismonthtotalenergy, lastmonthtotalenergy);
                content.close();
                content = Reports.addPage(document, docname, page++);
                Reports.drawImage(document, content, "iconload-2.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("electricity")) + " - " + ptxt.getProperty("trend"), 14.0f, 20.0f, 764.0f, 0, false);
                partialData = user.meterPartialView(t, -2, -2);
                thismonth = partialData.get("thismonth");
                thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                thismonthcost = partialData.get("thismonthcost");
                thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                v2 = new double[31];
                c2 = new double[31];
                x2 = new String[31];
                t333[0][1] = ptxt.getProperty("thismonth");
                t333[1][0] = ptxt.getProperty("day");
                t333[1][1] = ptxt.getProperty("value");
                t333[1][2] = ptxt.getProperty("cost");
                i2 = 0;
                while (i2 < 31) {
                    v2[i2] = Double.parseDouble(thismonthdata[i2]);
                    c2[i2] = Double.parseDouble(thismonthcostdata[i2]);
                    x2[i2] = Integer.toString(i2 + 1);
                    t333[i2 + 2][0] = Integer.toString(i2 + 1);
                    t333[i2 + 2][1] = Reports.energyFormatter(v2[i2], 2, "Wh");
                    t333[i2 + 2][2] = Reports.costFormatter(String.valueOf(c2[i2] / 1000000.0) + " " + energycurrency, 2);
                    ++i2;
                }
                Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v2, null, x2, null, "Wh", false);
                Reports.drawMatrix(document, content, 100.0f, 50.0f, 400.0f, 400.0f, t333, lastDayOfMonth + 2, 2, 0);
                content.close();
            }
            if (Double.parseDouble(gasData.get("thismonthtotalenergy")) > 0.0 || Double.parseDouble(gasData.get("lastmonthtotalenergy")) > 0.0) {
                content = Reports.addPage(document, docname, page++);
                thismonthtotalcost = gasData.get("thismonthtotalcost");
                lastmonthtotalcost = gasData.get("lastmonthtotalcost");
                thismonthtotalenergy = Double.parseDouble(gasData.get("thismonthtotalenergy"));
                lastmonthtotalenergy = Double.parseDouble(gasData.get("lastmonthtotalenergy"));
                Reports.drawImage(document, content, "iconload-4.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, ptxt.getProperty("gas"), 14.0f, 20.0f, 764.0f, 0, false);
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(thismonthtotalenergy / 1000.0, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(thismonthtotalcost, 2);
                Reports.drawMatrix(document, content, 20.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(lastmonthtotalenergy / 1000.0, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(lastmonthtotalcost, 2);
                Reports.drawMatrix(document, content, 320.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thismonthtotalenergy / 1000.0, lastmonthtotalenergy / 1000.0};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("monthlyreport")) + " " + ptxt.getProperty("gas"), 10.0f, 298.0f, 280.0f, 1, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 160.0f, thismonthtotalcost, lastmonthtotalcost);
                Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 160.0f, thismonthtotalenergy * m3ToWh / 1000000.0, lastmonthtotalenergy * m3ToWh / 1000000.0);
                content.close();
                content = Reports.addPage(document, docname, page++);
                Reports.drawImage(document, content, "iconload-4.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("gas")) + " - " + ptxt.getProperty("trend"), 14.0f, 20.0f, 764.0f, 0, false);
                partialData = user.meterPartialView(t, -4, -4);
                thismonth = partialData.get("thismonth");
                thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                thismonthcost = partialData.get("thismonthcost");
                thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                v2 = new double[31];
                c2 = new double[31];
                x2 = new String[31];
                t333[0][1] = ptxt.getProperty("thismonth");
                t333[1][0] = ptxt.getProperty("day");
                t333[1][1] = ptxt.getProperty("value");
                t333[1][2] = ptxt.getProperty("cost");
                i2 = 0;
                while (i2 < 31) {
                    v2[i2] = Double.parseDouble(thismonthdata[i2]) / 1000.0;
                    c2[i2] = Double.parseDouble(thismonthcostdata[i2]);
                    x2[i2] = Integer.toString(i2 + 1);
                    t333[i2 + 2][0] = Integer.toString(i2 + 1);
                    t333[i2 + 2][1] = Reports.energyFormatterGas(v2[i2], 1, m3ToWh);
                    t333[i2 + 2][2] = Reports.costFormatter(String.valueOf(c2[i2] / 1000000.0) + " " + energycurrency, 2);
                    ++i2;
                }
                Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v2, null, x2, null, "m3", false);
                Reports.drawMatrix(document, content, 100.0f, 50.0f, 400.0f, 400.0f, t333, lastDayOfMonth + 2, 2, 0);
                content.close();
            }
            if (Double.parseDouble(waterData.get("thismonthtotalenergy")) > 0.0 || Double.parseDouble(waterData.get("lastmonthtotalenergy")) > 0.0) {
                content = Reports.addPage(document, docname, page++);
                thismonthtotalcost = waterData.get("thismonthtotalcost");
                lastmonthtotalcost = waterData.get("lastmonthtotalcost");
                thismonthtotalenergy = Double.parseDouble(waterData.get("thismonthtotalenergy"));
                lastmonthtotalenergy = Double.parseDouble(waterData.get("lastmonthtotalenergy"));
                Reports.drawImage(document, content, "iconload-3.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, ptxt.getProperty("water"), 14.0f, 20.0f, 764.0f, 0, false);
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thismonthtotalenergy / 1000.0, 2, "m3");
                t12[0][1] = Reports.costFormatter(thismonthtotalcost, 2);
                Reports.drawMatrix(document, content, 20.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 720.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastmonthtotalenergy / 1000.0, 2, "m3");
                t12[0][1] = Reports.costFormatter(lastmonthtotalcost, 2);
                Reports.drawMatrix(document, content, 320.0f, 700.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thismonthtotalenergy / 1000.0, lastmonthtotalenergy / 1000.0};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("monthlyreport")) + " " + ptxt.getProperty("water"), 10.0f, 298.0f, 280.0f, 1, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, thismonthtotalcost, lastmonthtotalcost);
                content.close();
                content = Reports.addPage(document, docname, page++);
                Reports.drawImage(document, content, "iconload-3.png", 0.0f, 760.0f, 20.0f, 18.0f);
                Reports.drawText(document, content, String.valueOf(ptxt.getProperty("water")) + " - " + ptxt.getProperty("trend"), 14.0f, 20.0f, 764.0f, 0, false);
                partialData = user.meterPartialView(t, -3, -3);
                thismonth = partialData.get("thismonth");
                thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                thismonthcost = partialData.get("thismonthcost");
                thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                v2 = new double[31];
                c2 = new double[31];
                x2 = new String[31];
                t333[0][1] = ptxt.getProperty("thismonth");
                t333[1][0] = ptxt.getProperty("day");
                t333[1][1] = ptxt.getProperty("value");
                t333[1][2] = ptxt.getProperty("cost");
                i2 = 0;
                while (i2 < 31) {
                    v2[i2] = Double.parseDouble(thismonthdata[i2]) / 1000.0;
                    c2[i2] = Double.parseDouble(thismonthcostdata[i2]);
                    x2[i2] = Integer.toString(i2 + 1);
                    t333[i2 + 2][0] = Integer.toString(i2 + 1);
                    t333[i2 + 2][1] = Reports.energyFormatter(v2[i2], 2, "m3");
                    t333[i2 + 2][2] = Reports.costFormatter(String.valueOf(c2[i2] / 1000000.0) + " " + energycurrency, 2);
                    ++i2;
                }
                Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v2, null, x2, null, "m3", false);
                Reports.drawMatrix(document, content, 100.0f, 50.0f, 400.0f, 400.0f, t333, lastDayOfMonth + 2, 2, 0);
                content.close();
            }
            content = Reports.addPage(document, docname, page++);
            Reports.drawImage(document, content, "iconpartial.png", 0.0f, 760.0f, 20.0f, 18.0f);
            Reports.drawText(document, content, String.valueOf(ptxt.getProperty("electricity")) + " " + ptxt.getProperty("loads"), 14.0f, 20.0f, 764.0f, 0, false);
            String monthloads = energyData.get("month");
            String[] sa = monthloads.substring(1, monthloads.length() - 1).split(",");
            double[] loaddata = new double[sa.length / 5];
            double[] loadcost = new double[sa.length / 5];
            String[] loadname = new String[sa.length / 5];
            int loadsnumber = 0;
            int i3 = 0;
            while (i3 < loaddata.length) {
                int loadid = Integer.parseInt(sa[i3 * 5].substring(1));
                if (loadid == -2) break;
                loadsnumber = i3 + 1;
                loadname[i3] = loadid == -1 ? ptxt.getProperty("others") : DataProcessor.filterLoadNames((String)loadnames.get(loadid), true);
                loaddata[i3] = Double.parseDouble(sa[i3 * 5 + 1]);
                loadcost[i3] = Double.parseDouble(sa[i3 * 5 + 3]);
                ++i3;
            }
            double[] v3 = new double[loadsnumber];
            double[] c3 = new double[loadsnumber];
            String[] x3 = new String[loadsnumber];
            String[][] tx3 = new String[loadsnumber + 2][3];
            tx3[0][1] = ptxt.getProperty("thismonth");
            tx3[1][0] = ptxt.getProperty("loads");
            tx3[1][1] = ptxt.getProperty("value");
            tx3[1][2] = ptxt.getProperty("cost");
            int i4 = 0;
            while (i4 < loadsnumber) {
                v3[i4] = loaddata[i4];
                c3[i4] = loadcost[i4];
                x3[i4] = loadname[i4];
                tx3[i4 + 2][0] = loadname[i4];
                tx3[i4 + 2][1] = Reports.energyFormatter(v3[i4], 2, "Wh");
                tx3[i4 + 2][2] = Reports.costFormatter(String.valueOf(c3[i4] / 1000000.0) + " " + energycurrency, 2);
                ++i4;
            }
            Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 200.0f, v3, null, x3, null, "Wh", true);
            Reports.drawMatrix(document, content, 100.0f, 400 - (loadsnumber + 2) * 18, 400.0f, (loadsnumber + 2) * 18, tx3, null, 2, 0);
            content.close();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            document.save(bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e3) {
            user.errorLog("montlyReport Exception: " + e3);
            e3.printStackTrace();
            return null;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] annualSensorsReportPDF(int year, int[] sensors) {
        PDDocument document = null;
        PDPageContentStream content = null;
        double thisperiodenergygrandtotal = 0.0;
        double lastperiodenergygrandtotal = 0.0;
        double thisperiodcostgrandtotal = 0.0;
        double lastperiodcostgrandtotal = 0.0;
        int sensorsmix = 0;
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Vector<Hashtable<String, String>> deviceData = new Vector<Hashtable<String, String>>();
        String[][] t11 = new String[1][1];
        String[][] t12 = new String[1][2];
        int page = 1;
        try {
            String[] x1;
            double[] v1;
            double m3ToWh;
            try {
                m3ToWh = Double.parseDouble(user.varGet("gaskwhm3!"));
            }
            catch (Exception e2) {
                m3ToWh = 0.0;
            }
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            String today = new SimpleDateFormat("yyyy-MM-dd").format(new Date(cal.getTimeInMillis()));
            cal.set(2, 11);
            cal.set(1, year);
            cal.set(5, 1);
            cal.set(5, cal.getActualMaximum(5));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            int i2 = 0;
            while (i2 < sensors.length) {
                SensorCache sensor = Polling.sensorGet(sensors[i2]);
                Hashtable<String, String> d2 = user.energyView(t, sensors[i2]);
                deviceData.add(d2);
                if (d2 != null) {
                    double thisperiodenergy = Double.parseDouble(d2.get("thisyeartotalenergy")) / 1000.0;
                    double lastperiodenergy = Double.parseDouble(d2.get("lastyeartotalenergy")) / 1000.0;
                    double thisperiodcost = Double.parseDouble(d2.get("thisyeartotalcost")) / 1000000.0;
                    double lastperiodcost = Double.parseDouble(d2.get("lastyeartotalcost")) / 1000000.0;
                    thisperiodenergygrandtotal += thisperiodenergy;
                    lastperiodenergygrandtotal += lastperiodenergy;
                    thisperiodcostgrandtotal += thisperiodcost;
                    lastperiodcostgrandtotal += lastperiodcost;
                    switch (sensor.loadid) {
                        case -3: {
                            if (sensorsmix == 3) break;
                            sensorsmix = sensorsmix != 0 ? 1 : 3;
                            break;
                        }
                        case -4: {
                            if (sensorsmix == 4) break;
                            sensorsmix = sensorsmix != 0 ? 1 : 4;
                            break;
                        }
                        default: {
                            if (sensorsmix == 2) break;
                            sensorsmix = sensorsmix != 0 ? 1 : 2;
                        }
                    }
                }
                ++i2;
            }
            document = new PDDocument();
            String docname = String.valueOf(ptxt.getProperty("yearlydetailedreport")) + " - " + year + " (" + today + ")";
            content = Reports.addPage(document, docname, page++);
            Reports.drawTitle(document, content, docname);
            Reports.drawImage(document, content, "icongrand.png", 0.0f, 760.0f, 20.0f, 18.0f);
            Reports.drawText(document, content, ptxt.getProperty("selectiontotal"), 14.0f, 20.0f, 764.0f, 0, false);
            if (sensorsmix == 1) {
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = "";
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = "";
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodcostgrandtotal, lastperiodcostgrandtotal};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, energycurrency, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
            } else if (sensorsmix == 2) {
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thisperiodenergygrandtotal * 1000.0, 2, "Wh");
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastperiodenergygrandtotal * 1000.0, 2, "Wh");
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodenergygrandtotal * 1000.0, lastperiodenergygrandtotal * 1000.0};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "Wh", false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
                Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 160.0f, thisperiodenergygrandtotal * 1000.0, lastperiodenergygrandtotal * 1000.0);
            } else if (sensorsmix == 3) {
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thisperiodenergygrandtotal, 2, "m3");
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastperiodenergygrandtotal, 2, "m3");
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodenergygrandtotal, lastperiodenergygrandtotal};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
            } else if (sensorsmix == 4) {
                t11[0][0] = ptxt.getProperty("thisyear");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(thisperiodenergygrandtotal, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastyear");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(lastperiodenergygrandtotal, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodenergygrandtotal, lastperiodenergygrandtotal};
                x1 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
            }
            content.close();
            int i3 = 0;
            while (i3 < sensors.length) {
                Hashtable data = (Hashtable)deviceData.get(i3);
                if (data != null) {
                    double mult;
                    String unit;
                    String load;
                    double[] v = new double[24];
                    String[] x = new String[24];
                    String[] c2 = new String[24];
                    float[] cr = new float[24];
                    String thisyear = (String)data.get("thisyear");
                    String[] thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                    String lastyear = (String)data.get("lastyear");
                    String[] lastyeardata = lastyear.substring(1, lastyear.length() - 1).split(",");
                    SensorCache sensor = Polling.sensorGet(sensors[i3]);
                    switch (sensor.loadid) {
                        case -1: {
                            load = ptxt.getProperty("others");
                            unit = "Wh";
                            mult = 1.0;
                            break;
                        }
                        case -3: {
                            load = ptxt.getProperty("water");
                            unit = " m3";
                            mult = 0.001;
                            break;
                        }
                        case -4: {
                            load = ptxt.getProperty("gas");
                            unit = " m3";
                            mult = 0.001;
                            break;
                        }
                        default: {
                            load = DataProcessor.filterLoadNames((String)loadnames.get(sensor.loadid), true);
                            unit = "Wh";
                            mult = 1.0;
                        }
                    }
                    content = Reports.addPage(document, docname, page++);
                    Reports.drawImage(document, content, "icondetails.png", 0.0f, 760.0f, 20.0f, 18.0f);
                    Reports.drawText(document, content, sensor.name, 14.0f, 20.0f, 764.0f, 0, false);
                    Reports.drawText(document, content, String.valueOf(ptxt.getProperty("id")) + ":", 14.0f, 20.0f, 744.0f, 0, false);
                    Reports.drawText(document, content, Integer.toString(sensors[i3]), 14.0f, 100.0f, 744.0f, 0, false);
                    Reports.drawText(document, content, String.valueOf(ptxt.getProperty("load")) + ":", 14.0f, 20.0f, 724.0f, 0, false);
                    Reports.drawText(document, content, load, 14.0f, 100.0f, 724.0f, 0, false);
                    Reports.drawText(document, content, String.valueOf(ptxt.getProperty("model")) + ":", 14.0f, 20.0f, 704.0f, 0, false);
                    Reports.drawText(document, content, user.Models.get(sensor.modelid)[0], 14.0f, 100.0f, 704.0f, 0, false);
                    int m2 = 0;
                    while (m2 < 12) {
                        v[m2 * 2] = Double.parseDouble(thisyeardata[m2]) * mult;
                        v[m2 * 2 + 1] = Double.parseDouble(lastyeardata[m2]) * mult;
                        x[m2 * 2] = ptxt.getProperty("month_short_" + (m2 + 1));
                        x[m2 * 2 + 1] = "";
                        c2[m2 * 2] = "199,77,49";
                        c2[m2 * 2 + 1] = "219,189,187";
                        cr[m2 * 2] = 1.0f;
                        cr[m2 * 2 + 1] = 0.5f;
                        ++m2;
                    }
                    Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 170.0f, v, c2, x, cr, unit, false);
                    String thisyeartotalcost = String.valueOf(Double.parseDouble((String)data.get("thisyeartotalcost")) / 1000000.0) + " " + energycurrency;
                    String lastyeartotalcost = String.valueOf(Double.parseDouble((String)data.get("lastyeartotalcost")) / 1000000.0) + " " + energycurrency;
                    double thisyeartotalenergy = Double.parseDouble((String)data.get("thisyeartotalenergy"));
                    double lastyeartotalenergy = Double.parseDouble((String)data.get("lastyeartotalenergy"));
                    t11[0][0] = ptxt.getProperty("thisyear");
                    Reports.drawMatrix(document, content, 20.0f, 440.0f, 250.0f, 20.0f, t11, null, 1, 0);
                    t12[0][0] = sensor.loadid == -4 ? Reports.energyFormatterGas(thisyeartotalenergy * mult, 1, m3ToWh) : Reports.energyFormatter(thisyeartotalenergy * mult, 2, unit);
                    t12[0][1] = Reports.costFormatter(thisyeartotalcost, 2);
                    Reports.drawMatrix(document, content, 20.0f, 420.0f, 250.0f, 20.0f, t12, null, 0, 0);
                    t11[0][0] = ptxt.getProperty("lastyear");
                    Reports.drawMatrix(document, content, 320.0f, 440.0f, 250.0f, 20.0f, t11, null, 1, 0);
                    t12[0][0] = sensor.loadid == -4 ? Reports.energyFormatterGas(lastyeartotalenergy * mult, 1, m3ToWh) : Reports.energyFormatter(lastyeartotalenergy * mult, 2, unit);
                    t12[0][1] = Reports.costFormatter(lastyeartotalcost, 2);
                    Reports.drawMatrix(document, content, 320.0f, 420.0f, 250.0f, 20.0f, t12, null, 0, 0);
                    double[] v12 = new double[]{thisyeartotalenergy * mult, lastyeartotalenergy * mult};
                    String[] x12 = new String[]{ptxt.getProperty("thisyear"), ptxt.getProperty("lastyear")};
                    String[] c1 = new String[]{"199,77,49", "219,189,187"};
                    Reports.drawBarChart(document, content, 20.0f, 190.0f, 550.0f, 200.0f, v12, c1, x12, null, unit, false);
                    switch (sensor.loadid) {
                        case -3: {
                            Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 80.0f, thisyeartotalcost, lastyeartotalcost);
                            break;
                        }
                        case -4: {
                            Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 80.0f, thisyeartotalcost, lastyeartotalcost);
                            Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 80.0f, thisyeartotalenergy * m3ToWh / 1000.0, lastyeartotalenergy * m3ToWh / 1000.0);
                            break;
                        }
                        default: {
                            Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 80.0f, thisyeartotalcost, lastyeartotalcost);
                            Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 80.0f, thisyeartotalenergy, lastyeartotalenergy);
                        }
                    }
                    content.close();
                }
                ++i3;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            document.save(bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e3) {
            user.errorLog("annualSensorsReport Exception: " + e3);
            e3.printStackTrace();
            return null;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] montlySensorsReportPDF(int year, int month, int[] sensors) {
        PDDocument document = null;
        PDPageContentStream content = null;
        double thisperiodenergygrandtotal = 0.0;
        double lastperiodenergygrandtotal = 0.0;
        double thisperiodcostgrandtotal = 0.0;
        double lastperiodcostgrandtotal = 0.0;
        int sensorsmix = 0;
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Vector<Hashtable<String, String>> deviceData = new Vector<Hashtable<String, String>>();
        String[][] t11 = new String[1][1];
        String[][] t12 = new String[1][2];
        int page = 1;
        try {
            String[] x1;
            double[] v1;
            double m3ToWh;
            try {
                m3ToWh = Double.parseDouble(user.varGet("gaskwhm3!"));
            }
            catch (Exception e2) {
                m3ToWh = 0.0;
            }
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            String today = new SimpleDateFormat("yyyy-MM-dd").format(new Date(cal.getTimeInMillis()));
            cal.set(2, month - 1);
            cal.set(1, year);
            cal.set(5, 1);
            cal.set(5, cal.getActualMaximum(5));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            int i2 = 0;
            while (i2 < sensors.length) {
                SensorCache sensor = Polling.sensorGet(sensors[i2]);
                Hashtable<String, String> d2 = user.energyView(t, sensors[i2]);
                deviceData.add(d2);
                if (d2 != null) {
                    double thisperiodenergy = Double.parseDouble(d2.get("thismonthtotalenergy")) / 1000.0;
                    double lastperiodenergy = Double.parseDouble(d2.get("lastmonthtotalenergy")) / 1000.0;
                    double thisperiodcost = Double.parseDouble(d2.get("thismonthtotalcost")) / 1000000.0;
                    double lastperiodcost = Double.parseDouble(d2.get("lastmonthtotalcost")) / 1000000.0;
                    thisperiodenergygrandtotal += thisperiodenergy;
                    lastperiodenergygrandtotal += lastperiodenergy;
                    thisperiodcostgrandtotal += thisperiodcost;
                    lastperiodcostgrandtotal += lastperiodcost;
                    switch (sensor.loadid) {
                        case -3: {
                            if (sensorsmix == 3) break;
                            sensorsmix = sensorsmix != 0 ? 1 : 3;
                            break;
                        }
                        case -4: {
                            if (sensorsmix == 4) break;
                            sensorsmix = sensorsmix != 0 ? 1 : 4;
                            break;
                        }
                        default: {
                            if (sensorsmix == 2) break;
                            sensorsmix = sensorsmix != 0 ? 1 : 2;
                        }
                    }
                }
                ++i2;
            }
            document = new PDDocument();
            String docname = String.valueOf(ptxt.getProperty("monthlydetailedreport")) + " - " + ptxt.getProperty("month_" + month) + " " + year + " (" + today + ")";
            content = Reports.addPage(document, docname, page++);
            Reports.drawTitle(document, content, docname);
            Reports.drawImage(document, content, "icongrand.png", 0.0f, 760.0f, 20.0f, 18.0f);
            Reports.drawText(document, content, ptxt.getProperty("selectiontotal"), 14.0f, 20.0f, 764.0f, 0, false);
            if (sensorsmix == 1) {
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = "";
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = "";
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodcostgrandtotal, lastperiodcostgrandtotal};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, energycurrency, false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
            } else if (sensorsmix == 2) {
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thisperiodenergygrandtotal * 1000.0, 2, "Wh");
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastperiodenergygrandtotal * 1000.0, 2, "Wh");
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodenergygrandtotal * 1000.0, lastperiodenergygrandtotal * 1000.0};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "Wh", false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
                Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 160.0f, thisperiodenergygrandtotal * 1000.0, lastperiodenergygrandtotal * 1000.0);
            } else if (sensorsmix == 3) {
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(thisperiodenergygrandtotal, 2, "m3");
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatter(lastperiodenergygrandtotal, 2, "m3");
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodenergygrandtotal, lastperiodenergygrandtotal};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
            } else if (sensorsmix == 4) {
                t11[0][0] = ptxt.getProperty("thismonth");
                Reports.drawMatrix(document, content, 20.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(thisperiodenergygrandtotal, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 20.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                t11[0][0] = ptxt.getProperty("lastmonth");
                Reports.drawMatrix(document, content, 320.0f, 610.0f, 250.0f, 20.0f, t11, null, 1, 0);
                t12[0][0] = Reports.energyFormatterGas(lastperiodenergygrandtotal, 1, m3ToWh);
                t12[0][1] = Reports.costFormatter(String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency, 2);
                Reports.drawMatrix(document, content, 320.0f, 590.0f, 250.0f, 20.0f, t12, null, 0, 0);
                v1 = new double[]{thisperiodenergygrandtotal, lastperiodenergygrandtotal};
                x1 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                String[] c1 = new String[]{"199,77,49", "219,189,187"};
                Reports.drawBarChart(document, content, 20.0f, 300.0f, 550.0f, 250.0f, v1, c1, x1, null, "m3", false);
                Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 160.0f, String.valueOf(thisperiodcostgrandtotal) + " " + energycurrency, String.valueOf(lastperiodcostgrandtotal) + " " + energycurrency);
            }
            content.close();
            int i3 = 0;
            while (i3 < sensors.length) {
                Hashtable data = (Hashtable)deviceData.get(i3);
                if (data != null) {
                    double mult;
                    String unit;
                    String load;
                    double[] v = new double[62];
                    String[] x = new String[62];
                    String[] c2 = new String[62];
                    float[] cr = new float[62];
                    String thismonth = (String)data.get("thismonth");
                    String[] thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                    String lastmonth = (String)data.get("lastmonth");
                    String[] lastmonthdata = lastmonth.substring(1, lastmonth.length() - 1).split(",");
                    SensorCache sensor = Polling.sensorGet(sensors[i3]);
                    switch (sensor.loadid) {
                        case -1: {
                            load = ptxt.getProperty("others");
                            unit = "Wh";
                            mult = 1.0;
                            break;
                        }
                        case -3: {
                            load = ptxt.getProperty("water");
                            unit = " m3";
                            mult = 0.001;
                            break;
                        }
                        case -4: {
                            load = ptxt.getProperty("gas");
                            unit = " m3";
                            mult = 0.001;
                            break;
                        }
                        default: {
                            load = DataProcessor.filterLoadNames((String)loadnames.get(sensor.loadid), true);
                            unit = "Wh";
                            mult = 1.0;
                        }
                    }
                    content = Reports.addPage(document, docname, page++);
                    Reports.drawImage(document, content, "icondetails.png", 0.0f, 760.0f, 20.0f, 18.0f);
                    Reports.drawText(document, content, sensor.name, 14.0f, 20.0f, 764.0f, 0, false);
                    Reports.drawText(document, content, String.valueOf(ptxt.getProperty("id")) + ":", 14.0f, 20.0f, 744.0f, 0, false);
                    Reports.drawText(document, content, Integer.toString(sensors[i3]), 14.0f, 100.0f, 744.0f, 0, false);
                    Reports.drawText(document, content, String.valueOf(ptxt.getProperty("load")) + ":", 14.0f, 20.0f, 724.0f, 0, false);
                    Reports.drawText(document, content, load, 14.0f, 100.0f, 724.0f, 0, false);
                    Reports.drawText(document, content, String.valueOf(ptxt.getProperty("model")) + ":", 14.0f, 20.0f, 704.0f, 0, false);
                    Reports.drawText(document, content, user.Models.get(sensor.modelid)[0], 14.0f, 100.0f, 704.0f, 0, false);
                    int d3 = 0;
                    while (d3 < 31) {
                        v[d3 * 2] = Double.parseDouble(thismonthdata[d3]) * mult;
                        v[d3 * 2 + 1] = Double.parseDouble(lastmonthdata[d3]) * mult;
                        x[d3 * 2] = Integer.toString(d3 + 1);
                        x[d3 * 2 + 1] = "";
                        c2[d3 * 2] = "199,77,49";
                        c2[d3 * 2 + 1] = "219,189,187";
                        cr[d3 * 2] = 1.0f;
                        cr[d3 * 2 + 1] = 0.5f;
                        ++d3;
                    }
                    Reports.drawBarChart(document, content, 20.0f, 500.0f, 550.0f, 170.0f, v, c2, x, cr, unit, false);
                    String thismonthtotalcost = String.valueOf(Double.parseDouble((String)data.get("thismonthtotalcost")) / 1000000.0) + " " + energycurrency;
                    String lastmonthtotalcost = String.valueOf(Double.parseDouble((String)data.get("lastmonthtotalcost")) / 1000000.0) + " " + energycurrency;
                    double thismonthtotalenergy = Double.parseDouble((String)data.get("thismonthtotalenergy"));
                    double lastmonthtotalenergy = Double.parseDouble((String)data.get("lastmonthtotalenergy"));
                    t11[0][0] = ptxt.getProperty("thismonth");
                    Reports.drawMatrix(document, content, 20.0f, 440.0f, 250.0f, 20.0f, t11, null, 1, 0);
                    t12[0][0] = sensor.loadid == -4 ? Reports.energyFormatterGas(thismonthtotalenergy * mult, 1, m3ToWh) : Reports.energyFormatter(thismonthtotalenergy * mult, 2, unit);
                    t12[0][1] = Reports.costFormatter(thismonthtotalcost, 2);
                    Reports.drawMatrix(document, content, 20.0f, 420.0f, 250.0f, 20.0f, t12, null, 0, 0);
                    t11[0][0] = ptxt.getProperty("lastmonth");
                    Reports.drawMatrix(document, content, 320.0f, 440.0f, 250.0f, 20.0f, t11, null, 1, 0);
                    t12[0][0] = sensor.loadid == -4 ? Reports.energyFormatterGas(lastmonthtotalenergy * mult, 1, m3ToWh) : Reports.energyFormatter(lastmonthtotalenergy * mult, 2, unit);
                    t12[0][1] = Reports.costFormatter(lastmonthtotalcost, 2);
                    Reports.drawMatrix(document, content, 320.0f, 420.0f, 250.0f, 20.0f, t12, null, 0, 0);
                    double[] v12 = new double[]{thismonthtotalenergy * mult, lastmonthtotalenergy * mult};
                    String[] x12 = new String[]{ptxt.getProperty("thismonth"), ptxt.getProperty("lastmonth")};
                    String[] c1 = new String[]{"199,77,49", "219,189,187"};
                    Reports.drawBarChart(document, content, 20.0f, 190.0f, 550.0f, 200.0f, v12, c1, x12, null, unit, false);
                    switch (sensor.loadid) {
                        case -3: {
                            Reports.drawEnergyConsumptionDeltaBox(document, content, 200.0f, 80.0f, thismonthtotalcost, lastmonthtotalcost);
                            break;
                        }
                        case -4: {
                            Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 80.0f, thismonthtotalcost, lastmonthtotalcost);
                            Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 80.0f, thismonthtotalenergy * m3ToWh / 1000.0, lastmonthtotalenergy * m3ToWh / 1000.0);
                            break;
                        }
                        default: {
                            Reports.drawEnergyConsumptionDeltaBox(document, content, 90.0f, 80.0f, thismonthtotalcost, lastmonthtotalcost);
                            Reports.drawCO2ConsumptionDeltaBox(document, content, 320.0f, 80.0f, thismonthtotalenergy, lastmonthtotalenergy);
                        }
                    }
                    content.close();
                }
                ++i3;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            document.save(bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e3) {
            user.errorLog("montlySensorsReport Exception: " + e3);
            e3.printStackTrace();
            return null;
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] annualReportCSV(int year) {
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Hashtable<String, String> energyData = null;
        Hashtable<String, String> gasData = null;
        Hashtable<String, String> waterData = null;
        Hashtable<String, String> partialData = null;
        DecimalFormat df = new DecimalFormat("0.##");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter csv = null;
        if (user.csvFieldSep != ',') {
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
        }
        try {
            Double c2;
            Double v;
            int i2;
            String[] thisyearcostdata;
            String thisyearcost;
            String[] thisyeardata;
            String thisyear;
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            cal.set(2, 11);
            cal.set(1, year);
            cal.set(5, 1);
            cal.set(5, cal.getActualMaximum(5));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            energyData = user.energyTotalView(t);
            gasData = user.gasTotalView(t);
            waterData = user.waterTotalView(t);
            csv = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            csv.write(new String(user.BOM, "UTF-8"));
            csv.write("Quantity" + user.csvFieldSep + "Month" + user.csvFieldSep + "Value (kWh / m3)" + user.csvFieldSep + "Cost (" + energycurrency + ")\r\n");
            if (Double.parseDouble(energyData.get("thisyeartotalenergy")) > 0.0 || Double.parseDouble(energyData.get("lastyeartotalenergy")) > 0.0) {
                partialData = user.meterPartialView(t, -2, -2);
                thisyear = partialData.get("thisyear");
                thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                thisyearcost = partialData.get("thisyearcost");
                thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                i2 = 0;
                while (i2 < 12) {
                    v = Double.parseDouble(thisyeardata[i2]) / 1000.0;
                    c2 = Double.parseDouble(thisyearcostdata[i2]) / 1000000.0;
                    csv.write(ptxt.getProperty("electricity"));
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(i2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++i2;
                }
            }
            if (Double.parseDouble(gasData.get("thisyeartotalenergy")) > 0.0 || Double.parseDouble(gasData.get("lastyeartotalenergy")) > 0.0) {
                partialData = user.meterPartialView(t, -4, -4);
                thisyear = partialData.get("thisyear");
                thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                thisyearcost = partialData.get("thisyearcost");
                thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                i2 = 0;
                while (i2 < 12) {
                    v = Double.parseDouble(thisyeardata[i2]) / 1000.0;
                    c2 = Double.parseDouble(thisyearcostdata[i2]) / 1000000.0;
                    csv.write(ptxt.getProperty("gas"));
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(i2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++i2;
                }
            }
            if (Double.parseDouble(waterData.get("thisyeartotalenergy")) > 0.0 || Double.parseDouble(waterData.get("lastyeartotalenergy")) > 0.0) {
                partialData = user.meterPartialView(t, -3, -3);
                thisyear = partialData.get("thisyear");
                thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                thisyearcost = partialData.get("thisyearcost");
                thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                i2 = 0;
                while (i2 < 12) {
                    v = Double.parseDouble(thisyeardata[i2]) / 1000.0;
                    c2 = Double.parseDouble(thisyearcostdata[i2]) / 1000000.0;
                    csv.write(ptxt.getProperty("water"));
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(i2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++i2;
                }
            }
            csv.close();
            return baos.toByteArray();
        }
        catch (Exception e2) {
            user.errorLog("annualReport Exception: " + e2);
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] montlyReportCSV(int year, int month) {
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Hashtable<String, String> energyData = null;
        Hashtable<String, String> gasData = null;
        Hashtable<String, String> waterData = null;
        Hashtable<String, String> partialData = null;
        DecimalFormat df = new DecimalFormat("0.##");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter csv = null;
        if (user.csvFieldSep != ',') {
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
        }
        try {
            Double c2;
            Double v;
            int i2;
            String[] thismonthcostdata;
            String thismonthcost;
            String[] thismonthdata;
            String thismonth;
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            cal.set(2, month - 1);
            cal.set(1, year);
            cal.set(5, 1);
            int lastDayOfMonth = cal.getActualMaximum(5);
            cal.set(5, lastDayOfMonth);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            energyData = user.energyTotalView(t);
            gasData = user.gasTotalView(t);
            waterData = user.waterTotalView(t);
            csv = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            csv.write(new String(user.BOM, "UTF-8"));
            csv.write("Quantity" + user.csvFieldSep + "Day" + user.csvFieldSep + "Value (kWh / m3)" + user.csvFieldSep + "Cost (" + energycurrency + ")\r\n");
            if (Double.parseDouble(energyData.get("thismonthtotalenergy")) > 0.0 || Double.parseDouble(energyData.get("lastmonthtotalenergy")) > 0.0) {
                partialData = user.meterPartialView(t, -2, -2);
                thismonth = partialData.get("thismonth");
                thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                thismonthcost = partialData.get("thismonthcost");
                thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                i2 = 0;
                while (i2 < 31) {
                    v = Double.parseDouble(thismonthdata[i2]) / 1000.0;
                    c2 = Double.parseDouble(thismonthcostdata[i2]) / 1000000.0;
                    csv.write(ptxt.getProperty("electricity"));
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(i2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++i2;
                }
            }
            if (Double.parseDouble(gasData.get("thismonthtotalenergy")) > 0.0 || Double.parseDouble(gasData.get("lastmonthtotalenergy")) > 0.0) {
                partialData = user.meterPartialView(t, -4, -4);
                thismonth = partialData.get("thismonth");
                thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                thismonthcost = partialData.get("thismonthcost");
                thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                i2 = 0;
                while (i2 < 31) {
                    v = Double.parseDouble(thismonthdata[i2]) / 1000.0;
                    c2 = Double.parseDouble(thismonthcostdata[i2]) / 1000000.0;
                    csv.write(ptxt.getProperty("gas"));
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(i2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++i2;
                }
            }
            if (Double.parseDouble(waterData.get("thismonthtotalenergy")) > 0.0 || Double.parseDouble(waterData.get("lastmonthtotalenergy")) > 0.0) {
                partialData = user.meterPartialView(t, -3, -3);
                thismonth = partialData.get("thismonth");
                thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                thismonthcost = partialData.get("thismonthcost");
                thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                i2 = 0;
                while (i2 < 31) {
                    v = Double.parseDouble(thismonthdata[i2]) / 1000.0;
                    c2 = Double.parseDouble(thismonthcostdata[i2]) / 1000000.0;
                    csv.write(ptxt.getProperty("water"));
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(i2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++i2;
                }
            }
            csv.close();
            return baos.toByteArray();
        }
        catch (Exception e2) {
            user.errorLog("montlyReport Exception: " + e2);
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] annualSensorsReportCSV(int year, int[] sensors) {
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Vector<Hashtable<String, String>> deviceData = new Vector<Hashtable<String, String>>();
        DecimalFormat df = new DecimalFormat("0.##");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter csv = null;
        if (user.csvFieldSep != ',') {
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
        }
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            cal.set(2, 11);
            cal.set(1, year);
            cal.set(5, 1);
            cal.set(5, cal.getActualMaximum(5));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            int i2 = 0;
            while (i2 < sensors.length) {
                Hashtable<String, String> d2 = user.energyView(t, sensors[i2]);
                deviceData.add(d2);
                ++i2;
            }
            csv = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            csv.write(new String(user.BOM, "UTF-8"));
            csv.write("ID" + user.csvFieldSep + "Name" + user.csvFieldSep + "Load" + user.csvFieldSep + "Month" + user.csvFieldSep + "Value (kWh / m3)" + user.csvFieldSep + "Cost (" + energycurrency + ")\r\n");
            i2 = 0;
            while (i2 < sensors.length) {
                String load;
                Hashtable data = (Hashtable)deviceData.get(i2);
                String thisyear = (String)data.get("thisyear");
                String[] thisyeardata = thisyear.substring(1, thisyear.length() - 1).split(",");
                String thisyearcost = (String)data.get("thisyearcost");
                String[] thisyearcostdata = thisyearcost.substring(1, thisyearcost.length() - 1).split(",");
                SensorCache sensor = Polling.sensorGet(sensors[i2]);
                switch (sensor.loadid) {
                    case -1: {
                        load = ptxt.getProperty("others");
                        break;
                    }
                    case -3: {
                        load = ptxt.getProperty("water");
                        break;
                    }
                    case -4: {
                        load = ptxt.getProperty("gas");
                        break;
                    }
                    default: {
                        load = DataProcessor.filterLoadNames((String)loadnames.get(sensor.loadid), false);
                    }
                }
                int m2 = 0;
                while (m2 < 12) {
                    Double v = Double.parseDouble(thisyeardata[m2]) / 1000.0;
                    Double c2 = Double.parseDouble(thisyearcostdata[m2]) / 1000000.0;
                    csv.write(Integer.toString(sensor.sensorid));
                    csv.write(user.csvFieldSep);
                    csv.write(sensor.name);
                    csv.write(user.csvFieldSep);
                    csv.write(load);
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(m2 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++m2;
                }
                ++i2;
            }
            csv.close();
            return baos.toByteArray();
        }
        catch (Exception e2) {
            user.errorLog("annualSensorsReport Exception: " + e2);
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] montlySensorsReportCSV(int year, int month, int[] sensors) {
        Hashtable<Integer, String> loadnames = new Hashtable<Integer, String>();
        Vector<Hashtable<String, String>> deviceData = new Vector<Hashtable<String, String>>();
        DecimalFormat df = new DecimalFormat("0.##");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter csv = null;
        if (user.csvFieldSep != ',') {
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
        }
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                loadnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            String energycurrency = user.varGet("energycurrency!");
            Calendar cal = Calendar.getInstance();
            cal.set(2, month - 1);
            cal.set(1, year);
            cal.set(5, 1);
            cal.set(5, cal.getActualMaximum(5));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long t = cal.getTimeInMillis();
            int i2 = 0;
            while (i2 < sensors.length) {
                Hashtable<String, String> d2 = user.energyView(t, sensors[i2]);
                deviceData.add(d2);
                ++i2;
            }
            csv = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            csv.write(new String(user.BOM, "UTF-8"));
            csv.write("ID" + user.csvFieldSep + "Name" + user.csvFieldSep + "Load" + user.csvFieldSep + "Day" + user.csvFieldSep + "Value (kWh / m3)" + user.csvFieldSep + "Cost (" + energycurrency + ")\r\n");
            i2 = 0;
            while (i2 < sensors.length) {
                String load;
                Hashtable data = (Hashtable)deviceData.get(i2);
                String thismonth = (String)data.get("thismonth");
                String[] thismonthdata = thismonth.substring(1, thismonth.length() - 1).split(",");
                String thismonthcost = (String)data.get("thismonthcost");
                String[] thismonthcostdata = thismonthcost.substring(1, thismonthcost.length() - 1).split(",");
                SensorCache sensor = Polling.sensorGet(sensors[i2]);
                switch (sensor.loadid) {
                    case -1: {
                        load = ptxt.getProperty("others");
                        break;
                    }
                    case -3: {
                        load = ptxt.getProperty("water");
                        break;
                    }
                    case -4: {
                        load = ptxt.getProperty("gas");
                        break;
                    }
                    default: {
                        load = DataProcessor.filterLoadNames((String)loadnames.get(sensor.loadid), false);
                    }
                }
                int d3 = 0;
                while (d3 < 31) {
                    Double v = Double.parseDouble(thismonthdata[d3]) / 1000.0;
                    Double c2 = Double.parseDouble(thismonthcostdata[d3]) / 1000000.0;
                    csv.write(Integer.toString(sensor.sensorid));
                    csv.write(user.csvFieldSep);
                    csv.write(sensor.name);
                    csv.write(user.csvFieldSep);
                    csv.write(load);
                    csv.write(user.csvFieldSep);
                    csv.write(Integer.toString(d3 + 1));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(v));
                    csv.write(user.csvFieldSep);
                    csv.write(df.format(c2));
                    csv.write("\r\n");
                    ++d3;
                }
                ++i2;
            }
            csv.close();
            return baos.toByteArray();
        }
        catch (Exception e2) {
            user.errorLog("montlySensorsReport Exception: " + e2);
            e2.printStackTrace();
            return null;
        }
    }

    public static void emailReporter() {
        long t;
        block24: {
            t = System.currentTimeMillis();
            if (emailReporterSemaphore) {
                return;
            }
            emailReporterSemaphore = true;
            try {
                String address = user.varGet("autoreportaddress!");
                boolean summary = Boolean.parseBoolean(user.varGet("autoreportsummary!"));
                boolean detailed = Boolean.parseBoolean(user.varGet("autoreportdetailed!"));
                if (address.length() <= 0 || !summary && !detailed) break block24;
                Vector<String> names = new Vector<String>();
                Vector<byte[]> data = new Vector<byte[]>();
                boolean monthly = Boolean.parseBoolean(user.varGet("autoreportmonthly!"));
                boolean yearly = Boolean.parseBoolean(user.varGet("autoreportyearly!"));
                boolean pdf = Boolean.parseBoolean(user.varGet("autoreportpdf!"));
                boolean csv = Boolean.parseBoolean(user.varGet("autoreportcsv!"));
                String sensors = user.varGet("autoreportsensors!");
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.setTimeInMillis(cal.getTimeInMillis() - 86400000L);
                cal.set(5, 1);
                int year = cal.get(1);
                int month = cal.get(2) + 1;
                if (summary) {
                    if (yearly) {
                        if (pdf) {
                            names.add("yearly-report_" + year + ".pdf");
                            data.add(Reports.annualReportPDF(year));
                        }
                        if (csv) {
                            names.add("yearly-report_" + year + ".csv");
                            data.add(Reports.annualReportCSV(year));
                        }
                    }
                    if (monthly) {
                        if (pdf) {
                            names.add("monthly-report_" + year + "-" + month + ".pdf");
                            data.add(Reports.montlyReportPDF(year, month));
                        }
                        if (csv) {
                            names.add("monthly-report_" + year + ".csv");
                            data.add(Reports.montlyReportCSV(year, month));
                        }
                    }
                }
                if (detailed) {
                    int[] ids;
                    if (sensors.equals("all")) {
                        ids = new int[Polling.sensorCache.size()];
                        int i2 = 0;
                        Enumeration<Integer> e2 = Polling.sensorCache.keys();
                        while (e2.hasMoreElements()) {
                            ids[i2++] = e2.nextElement();
                        }
                    } else if (sensors.equals("none")) {
                        ids = new int[]{};
                    } else {
                        String[] sa = sensors.split(",");
                        ids = new int[sa.length];
                        int i3 = 0;
                        while (i3 < ids.length) {
                            ids[i3] = Integer.parseInt(sa[i3]);
                            ++i3;
                        }
                    }
                    if (ids.length > 0) {
                        if (yearly) {
                            if (pdf) {
                                names.add("detailed-yearly-report_" + year + ".pdf");
                                data.add(Reports.annualSensorsReportPDF(year, ids));
                            }
                            if (csv) {
                                names.add("detailed-yearly-report_" + year + ".csv");
                                data.add(Reports.annualSensorsReportCSV(year, ids));
                            }
                        }
                        if (monthly) {
                            if (pdf) {
                                names.add("detailed-monthly-report_" + year + "-" + month + ".pdf");
                                data.add(Reports.montlySensorsReportPDF(year, month, ids));
                            }
                            if (csv) {
                                names.add("detailed-monthly-report_" + year + "-" + month + ".csv");
                                data.add(Reports.montlySensorsReportCSV(year, month, ids));
                            }
                        }
                    }
                }
                Reports.sendMail(address, ptxt.getProperty("reportsemailsubject"), names, data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        user.messageLog("PROFILING: EMAILREPORTER [" + (System.currentTimeMillis() - t) + "]");
        emailReporterSemaphore = false;
    }

    private static void drawImage(PDDocument document, PDPageContentStream stream, String name, float x, float y, float width, float height) throws Exception {
        HsycoFile f2 = new HsycoFile("plugins/wsmeasure/resources/pdf/" + version, name);
        ByteArrayInputStream bis = new ByteArrayInputStream(f2.getBytes());
        PDPixelMap imageobj = new PDPixelMap(document, ImageIO.read(bis));
        stream.drawXObject(imageobj, x, y, width, height);
        ((PDXObject)imageobj).clear();
    }

    private static void drawImage(PDDocument document, PDPageContentStream stream, BufferedImage image, float x, float y, float width, float height) throws Exception {
        PDPixelMap imageobj = new PDPixelMap(document, image);
        stream.drawXObject(imageobj, x, y, width, height);
        ((PDXObject)imageobj).clear();
    }

    private static void drawText(PDDocument document, PDPageContentStream stream, String text, float size, float x, float y, int align, boolean negative) throws Exception {
        if (negative) {
            stream.setNonStrokingColor(255, 255, 255);
        } else {
            stream.setNonStrokingColor(0, 0, 0);
        }
        stream.beginText();
        stream.setFont(font, size);
        switch (align) {
            case 1: {
                stream.setTextTranslation(x - (float)((int)(size * font.getStringWidth(text) / 1000.0f) / 2), y);
                break;
            }
            case 2: {
                stream.setTextTranslation(x - (float)((int)(size * font.getStringWidth(text) / 1000.0f)), y);
                break;
            }
            default: {
                stream.setTextTranslation(x, y);
            }
        }
        stream.drawString(text);
        stream.endText();
    }

    private static PDPageContentStream addPage(PDDocument document, String name, int number) throws Exception {
        PDPage page = new PDPage(PDPage.PAGE_SIZE_A4);
        document.addPage(page);
        PDPageContentStream content = new PDPageContentStream(document, page);
        Reports.drawImage(document, content, "logo.png", 0.0f, 5.0f, 72.0f, 20.0f);
        Reports.drawText(document, content, name, 10.0f, 298.0f, 10.0f, 1, false);
        Reports.drawText(document, content, Integer.toString(number), 10.0f, 585.0f, 10.0f, 2, false);
        return content;
    }

    private static void drawEnergyPie(PDDocument document, PDPageContentStream stream, float x, float y, float width, float height, double electricity, double gas, double water) throws Exception {
        float yt;
        float xt;
        StringBuffer code = new StringBuffer();
        long eang = 0L;
        long gang = 0L;
        long wang = 0L;
        int ANG_DIST_MIN = 30;
        DecimalFormat df = new DecimalFormat("0.#");
        if (electricity == 0.0 && gas == 0.0 && water == 0.0) {
            return;
        }
        long earc = Math.round(360.0 * electricity / (electricity + gas + water));
        long garc = Math.round(360.0 * gas / (electricity + gas + water));
        long warc = 360L - earc - garc;
        if (earc != 0L) {
            code.append("arc(0,0,600,600,90,-" + earc + ",'pie','255,255,255','213,113,68');");
            eang = 90L - earc / 2L;
        }
        if (garc != 0L) {
            code.append("arc(0,0,600,600," + (90L - earc) + ",-" + garc + ",'pie','255,255,255','125,142,70');");
            gang = 90L - earc - garc / 2L;
            if (Reports.angleDiff(eang, gang) < 30L) {
                gang -= 30L - Reports.angleDiff(eang, gang);
            }
        }
        if (warc != 0L) {
            long d2;
            code.append("arc(0,0,600,600," + (90L - earc - garc) + ",-" + warc + ",'pie','255,255,255','96,147,208');");
            wang = 90L - earc - garc - warc / 2L;
            if (Reports.angleDiff(gang, wang) < 30L) {
                d2 = 30L - Reports.angleDiff(gang, wang) / 2L;
                wang -= d2;
                gang += d2;
            } else if (Reports.angleDiff(eang, wang) < 30L) {
                d2 = (30L - Reports.angleDiff(eang, wang)) / 2L;
                wang += d2;
                eang -= d2;
            }
        }
        code.append("arc(150,150,300,300,0,360,'pie','255,255,255','255,255,255');");
        ByteArrayInputStream in = new ByteArrayInputStream(Graphics.draw2D(600, 600, code.toString(), "jpeg"));
        BufferedImage image = ImageIO.read(in);
        Reports.drawImage(document, stream, image, x, y, width, height);
        if (earc != 0L) {
            xt = (float)(Math.cos(Math.toRadians(eang)) * (double)(width + 50.0f) / 2.0 + (double)x - 25.0 + (double)((width + 50.0f) / 2.0f));
            yt = (float)(Math.sin(Math.toRadians(eang)) * (double)(height + 50.0f) / 2.0 + (double)y - 25.0 + (double)((height + 50.0f) / 2.0f));
            Reports.drawText(document, stream, ptxt.getProperty("electricity"), 14.0f, xt, yt + 10.0f, 1, false);
            Reports.drawText(document, stream, String.valueOf(df.format((double)earc / 3.6)) + "%", 18.0f, xt, yt - 10.0f, 1, false);
        }
        if (garc != 0L) {
            xt = (float)(Math.cos(Math.toRadians(gang)) * (double)(width + 50.0f) / 2.0 + (double)x - 25.0 + (double)((width + 50.0f) / 2.0f));
            yt = (float)(Math.sin(Math.toRadians(gang)) * (double)(height + 50.0f) / 2.0 + (double)y - 25.0 + (double)((height + 50.0f) / 2.0f));
            Reports.drawText(document, stream, ptxt.getProperty("gas"), 14.0f, xt, yt + 10.0f, 1, false);
            Reports.drawText(document, stream, String.valueOf(df.format((double)garc / 3.6)) + "%", 18.0f, xt, yt - 10.0f, 1, false);
        }
        if (warc != 0L) {
            xt = (float)(Math.cos(Math.toRadians(wang)) * (double)(width + 50.0f) / 2.0 + (double)x - 25.0 + (double)((width + 50.0f) / 2.0f));
            yt = (float)(Math.sin(Math.toRadians(wang)) * (double)(height + 50.0f) / 2.0 + (double)y - 25.0 + (double)((height + 50.0f) / 2.0f));
            Reports.drawText(document, stream, ptxt.getProperty("water"), 14.0f, xt, yt + 10.0f, 1, false);
            Reports.drawText(document, stream, String.valueOf(df.format((double)warc / 3.6)) + "%", 18.0f, xt, yt - 10.0f, 1, false);
        }
    }

    private static void drawMatrix(PDDocument document, PDPageContentStream stream, float x, float y, float width, float height, String[][] data, Integer data_rows, int header_rows, int header_cols) throws Exception {
        int FONT_SIZE = 10;
        int columns = data[0].length;
        int lines = data_rows == null ? data.length : data_rows;
        float lineheight = height / (float)lines;
        float columnwidth = width / (float)columns;
        stream.setNonStrokingColor(0, 0, 0);
        int i2 = 0;
        while (i2 <= lines) {
            stream.drawLine(x, y + (float)i2 * lineheight, x + width, y + (float)i2 * lineheight);
            ++i2;
        }
        i2 = 0;
        while (i2 <= columns) {
            stream.drawLine(x + (float)i2 * columnwidth, y, x + (float)i2 * columnwidth, y + height);
            ++i2;
        }
        if (header_rows == 2) {
            stream.setNonStrokingColor(64, 64, 64);
            stream.fillRect(x, y + height - lineheight, width, lineheight);
            stream.setNonStrokingColor(128, 128, 128);
            stream.fillRect(x, y + height - lineheight * 2.0f, width, lineheight);
        } else if (header_rows > 0) {
            stream.setNonStrokingColor(64, 64, 64);
            stream.fillRect(x, y + height - lineheight * (float)header_rows, width, lineheight * (float)header_rows);
        }
        if (header_cols > 0) {
            stream.setNonStrokingColor(64, 64, 64);
            stream.fillRect(x, y, columnwidth * (float)header_cols, height);
        }
        int r = 0;
        while (r < lines) {
            int c2 = 0;
            while (c2 < data[r].length) {
                if (data[r][c2] != null && data[r][c2].length() > 0) {
                    Reports.drawText(document, stream, data[r][c2], 10.0f, x + columnwidth * (float)c2 + columnwidth / 2.0f, y + height - lineheight * (float)r - lineheight / 2.0f - 3.0f, 1, r < header_rows || c2 < header_cols);
                }
                ++c2;
            }
            ++r;
        }
    }

    private static void drawTitle(PDDocument document, PDPageContentStream stream, String text) throws Exception {
        stream.setNonStrokingColor(64, 64, 64);
        stream.fillRect(2.0f, 792.0f, 590.0f, 26.0f);
        stream.setNonStrokingColor(255, 255, 255);
        stream.fillRect(3.0f, 794.0f, 587.0f, 23.0f);
        Reports.drawText(document, stream, text, 16.0f, 298.0f, 800.0f, 1, false);
    }

    private static void drawBarChart(PDDocument document, PDPageContentStream stream, float x, float y, float width, float height, double[] values, String[] colors, String[] xlabels, float[] crop, String unit, boolean alternatexlabels) throws Exception {
        int FONT_SIZE = 10;
        int LABEL_X_MARGIN = 80;
        int LABEL_Y_MARGIN = alternatexlabels ? 20 : 10;
        int Y_DIVISION_HEIGHT = 50;
        int yDivHeight = 50;
        float itemwidth = (width - 80.0f) / (float)values.length;
        double maxValue = 0.0;
        int i2 = 0;
        while (i2 < values.length) {
            if (maxValue < values[i2]) {
                maxValue = values[i2];
            }
            ++i2;
        }
        int ydivisions = (int)height / 50;
        yDivHeight = (int)height / ydivisions;
        stream.setNonStrokingColor(0, 0, 0);
        stream.drawLine(x + 80.0f, y + (float)LABEL_Y_MARGIN, x + width, y + (float)LABEL_Y_MARGIN);
        stream.drawLine(x + 80.0f, y + (float)LABEL_Y_MARGIN, x + 80.0f, y + height);
        stream.setStrokingColor(128, 128, 128);
        i2 = 1;
        while (i2 < ydivisions) {
            float yd = y + (float)LABEL_Y_MARGIN + (float)(i2 * yDivHeight);
            stream.drawLine(x + 80.0f, yd, x + width, yd);
            Reports.drawText(document, stream, Reports.energyFormatter(maxValue * (double)i2 * (double)yDivHeight / (double)height, 2, unit), 10.0f, x + 80.0f - 16.0f, yd - 5.0f, 2, false);
            ++i2;
        }
        Reports.drawText(document, stream, Reports.energyFormatter(maxValue, 2, unit), 10.0f, x + 80.0f - 16.0f, y + height - 5.0f, 2, false);
        stream.setNonStrokingColor(0, 0, 0);
        i2 = 0;
        while (i2 < xlabels.length) {
            if (xlabels[i2] != null && xlabels[i2].length() > 0) {
                Reports.drawText(document, stream, xlabels[i2], 10.0f, x + 80.0f + itemwidth * (float)i2 + itemwidth / 2.0f, !alternatexlabels || i2 % 2 == 0 ? y : y + (float)(LABEL_Y_MARGIN / 2), 1, false);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < values.length) {
            if (values[i2] > 0.0) {
                double yd = (double)(height - (float)LABEL_Y_MARGIN) * values[i2] / maxValue;
                if (colors != null && colors[i2] != null) {
                    String[] sa = colors[i2].split(",");
                    stream.setNonStrokingColor(Integer.parseInt(sa[0]), Integer.parseInt(sa[1]), Integer.parseInt(sa[2]));
                } else {
                    stream.setNonStrokingColor(199, 77, 49);
                }
                stream.fillRect(x + 80.0f + itemwidth * (float)i2 + itemwidth * 0.15f, y + (float)LABEL_Y_MARGIN, crop == null ? itemwidth / 1.3f : crop[i2] * itemwidth / 1.3f, (float)yd);
            }
            ++i2;
        }
    }

    private static void drawEnergyConsumptionDeltaBox(PDDocument document, PDPageContentStream stream, float x, float y, String thiscost, String lastcost) throws Exception {
        String currency;
        double thiscostvalue;
        float WIDTH = 190.0f;
        float HEIGHT = 70.0f;
        float[] rx = new float[]{x, x + 190.0f, x + 190.0f, x, x};
        float[] ry = new float[]{y, y, y + 70.0f, y + 70.0f, y};
        DecimalFormat df1 = new DecimalFormat("0.#");
        int i2 = thiscost.indexOf(32);
        if (i2 == -1) {
            thiscostvalue = Double.parseDouble(thiscost);
            currency = "";
        } else {
            thiscostvalue = Double.parseDouble(thiscost.substring(0, i2));
            currency = thiscost.substring(i2 + 1);
        }
        i2 = lastcost.indexOf(32);
        double lastcostvalue = i2 == -1 ? Double.parseDouble(lastcost) : Double.parseDouble(lastcost.substring(0, i2));
        stream.setStrokingColor(0, 0, 0);
        stream.drawPolygon(rx, ry);
        Reports.drawImage(document, stream, "money.png", x + 190.0f - 50.0f, y + 10.0f, 40.0f, 40.0f);
        Reports.drawText(document, stream, String.valueOf(ptxt.getProperty("energyconsumption")) + ":", 10.0f, x + 70.0f, y + 70.0f - 20.0f, 1, false);
        Reports.drawText(document, stream, lastcostvalue == 0.0 ? "--" : String.valueOf(df1.format(100.0 * (thiscostvalue / lastcostvalue - 1.0))) + " %", 12.0f, x + 70.0f, y + 70.0f - 40.0f, 1, false);
        Reports.drawText(document, stream, String.valueOf(df1.format(thiscostvalue - lastcostvalue)) + " " + currency, 12.0f, x + 70.0f, y + 70.0f - 60.0f, 1, false);
    }

    private static void drawCO2ConsumptionDeltaBox(PDDocument document, PDPageContentStream stream, float x, float y, double thisenergy, double lastenergy) throws Exception {
        float WIDTH = 190.0f;
        float HEIGHT = 70.0f;
        float[] rx = new float[]{x, x + 190.0f, x + 190.0f, x, x};
        float[] ry = new float[]{y, y, y + 70.0f, y + 70.0f, y};
        stream.setStrokingColor(0, 0, 0);
        stream.drawPolygon(rx, ry);
        Reports.drawImage(document, stream, "leaf.png", x + 190.0f - 50.0f, y + 10.0f, 40.0f, 40.0f);
        Reports.drawText(document, stream, String.valueOf(ptxt.getProperty("co2consumption")) + ":", 10.0f, x + 70.0f, y + 70.0f - 20.0f, 1, false);
        Reports.drawText(document, stream, String.valueOf((long)((thisenergy - lastenergy) / 1883.2)) + " kg eq CO2", 12.0f, x + 70.0f, y + 70.0f - 50.0f, 1, false);
    }

    private static long angleDiff(long a2, long b2) {
        if (a2 < 0L) {
            a2 += 360L;
        }
        if (b2 < 0L) {
            b2 += 360L;
        }
        if (a2 <= 180L ^ b2 <= 180L) {
            return 360L - Math.abs(a2 - b2);
        }
        return Math.abs(a2 - b2);
    }

    private static String energyFormatter(double value, int decimals, String unit) {
        String prefix;
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(decimals);
        if (value < 1000.0) {
            prefix = "";
        } else if (value < 1000000.0) {
            prefix = "k";
            value /= 1000.0;
        } else if (value < 1.0E9) {
            prefix = "M";
            value /= 1000000.0;
        } else if (value < 1.0E12) {
            prefix = "G";
            value /= 1.0E9;
        } else if (value < 1.0E15) {
            prefix = "T";
            value /= 1.0E12;
        } else if (value < 1.0E18) {
            prefix = "P";
            value /= 1.0E15;
        } else {
            prefix = "?";
        }
        return String.valueOf(df.format(value).replace('.', user.csvDecimalSep)) + " " + prefix + unit;
    }

    private static String energyFormatterGas(double value, int decimals, double m3ToWh) {
        if (m3ToWh == 0.0) {
            return Reports.energyFormatter(value, decimals, "m3");
        }
        return String.valueOf(Reports.energyFormatter(value, decimals, "m3")) + " - " + Reports.energyFormatter(value * m3ToWh, decimals, "Wh");
    }

    private static String costFormatter(String valuestring, int decimals) {
        String prefix;
        String currency;
        Double value;
        DecimalFormat df = new DecimalFormat();
        int i2 = valuestring.indexOf(32);
        if (i2 == -1) {
            value = Double.parseDouble(valuestring);
            currency = "";
        } else {
            value = Double.parseDouble(valuestring.substring(0, i2));
            currency = valuestring.substring(i2 + 1);
        }
        df.setMaximumFractionDigits(decimals);
        if (value < 1000.0) {
            prefix = "";
        } else if (value < 1000000.0) {
            prefix = "k";
            value = value / 1000.0;
        } else if (value < 1.0E9) {
            prefix = "M";
            value = value / 1000000.0;
        } else if (value < 1.0E12) {
            prefix = "G";
            value = value / 1.0E9;
        } else if (value < 1.0E15) {
            prefix = "T";
            value = value / 1.0E12;
        } else if (value < 1.0E18) {
            prefix = "P";
            value = value / 1.0E15;
        } else {
            prefix = "?";
        }
        return String.valueOf(df.format(value).replace('.', user.csvDecimalSep)) + " " + prefix + currency;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int sendMail(String to, String subject, Vector<String> names, Vector<byte[]> data, String SmtpHostName, Integer SmtpHostPort, String SmtpHostSSL, String SmtpHostUser, String SmtpHostPassword, String fromAddress) {
        Service t = null;
        boolean sendError = true;
        try {
            boolean SmtpDebug;
            String s = user.varGet("$smtpdebug");
            boolean bl = SmtpDebug = s != null && s.equalsIgnoreCase("true");
            int SmtpHostSSLMode = "true".equals(SmtpHostSSL) ? 1 : ("esmtp".equals(SmtpHostSSL) ? 2 : 0);
            if (SmtpHostPort == null) {
                switch (SmtpHostSSLMode) {
                    case 1: {
                        SmtpHostPort = 465;
                        break;
                    }
                    case 2: {
                        SmtpHostPort = 587;
                        break;
                    }
                    default: {
                        SmtpHostPort = 25;
                    }
                }
            }
            final String SmtpHostUserFinal = new String(SmtpHostUser);
            final String SmtpHostPasswordFinal = new String(SmtpHostPassword);
            String[] recipients = to.split("[, ]");
            int x = 0;
            while (x < recipients.length) {
                if (recipients[x].length() > 0) {
                    Object[] servers;
                    String[] ta = recipients[x].split("@");
                    if (ta.length != 2 || ta[1].length() < 4) {
                        user.errorLog("sendMail - ERROR: to address is invalid");
                        return -1;
                    }
                    if (SmtpHostName.length() == 0) {
                        String[] da = ta[1].split(":");
                        if (da.length == 2) {
                            to = String.valueOf(ta[0]) + "@" + da[0];
                            servers = new Object[]{da[1]};
                        } else {
                            Hashtable<String, String> env = new Hashtable<String, String>();
                            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                            InitialDirContext ictx = new InitialDirContext(env);
                            Attributes attrs = ictx.getAttributes(ta[1], new String[]{"MX"});
                            Attribute attr = attrs.get("MX");
                            NamingEnumeration<?> en = attr.getAll();
                            TreeMap<Integer, String> ns = new TreeMap<Integer, String>();
                            while (en.hasMore()) {
                                String[] sa = ((String)en.next()).split(" ");
                                ns.put(Integer.parseInt(sa[0]), sa[1].endsWith(".") ? sa[1].substring(0, sa[1].length() - 1) : sa[1]);
                            }
                            servers = ns.values().toArray();
                        }
                    } else {
                        servers = new Object[]{null};
                    }
                    int i2 = 0;
                    while (i2 < servers.length) {
                        try {
                            Session session;
                            Properties props = new Properties();
                            if (servers[i2] != null) {
                                props.setProperty("mail.smtp.host", (String)servers[i2]);
                                session = Session.getInstance(props, null);
                            } else {
                                props.setProperty("mail.smtp.host", SmtpHostName);
                                props.setProperty("mail.smtp.port", Integer.toString(SmtpHostPort));
                                switch (SmtpHostSSLMode) {
                                    case 1: {
                                        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                                        props.setProperty("mail.smtp.socketFactory.fallback", "false");
                                        break;
                                    }
                                    case 2: {
                                        props.setProperty("mail.smtp.starttls.enable", "true");
                                    }
                                }
                                if (SmtpHostUser.length() > 0 || SmtpHostPassword.length() > 0) {
                                    props.setProperty("mail.smtp.auth", "true");
                                    session = Session.getInstance(props, new Authenticator(){

                                        protected PasswordAuthentication getPasswordAuthentication() {
                                            return new PasswordAuthentication(SmtpHostUserFinal, SmtpHostPasswordFinal);
                                        }
                                    });
                                } else {
                                    session = Session.getInstance(props, null);
                                }
                            }
                            if (SmtpDebug) {
                                session.setDebug(true);
                            }
                            MimeMessage message = new MimeMessage(session);
                            message.setFrom(new InternetAddress(fromAddress));
                            message.addRecipient(Message.RecipientType.TO, new InternetAddress(recipients[x]));
                            message.setSubject(subject);
                            MimeMultipart multipart = new MimeMultipart();
                            int b2 = 0;
                            while (b2 < data.size()) {
                                try {
                                    MimeBodyPart part = new MimeBodyPart();
                                    part.setText("\r\n");
                                    ((Multipart)multipart).addBodyPart(part);
                                    byte[] theData = data.elementAt(b2);
                                    InternetHeaders headers = new InternetHeaders();
                                    headers.addHeader("Content-Type", "application/octet-stream");
                                    headers.addHeader("Content-Disposition", "attachment; filename=" + names.elementAt(b2));
                                    headers.addHeader("Content-Transfer-Encoding", "base64");
                                    part = new MimeBodyPart(headers, Reports.encodeBase64String(theData).getBytes("UTF-8"));
                                    ((Multipart)multipart).addBodyPart(part);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++b2;
                            }
                            if (data.size() > 0) {
                                message.setContent(multipart);
                            } else {
                                message.setText("");
                            }
                            t = session.getTransport("smtp");
                            t.connect();
                            ((Transport)t).sendMessage(message, message.getAllRecipients());
                            sendError = false;
                            break;
                        }
                        catch (Exception e2) {
                            if (Configuration.verboseLog) {
                                user.errorLog("sendMail - ERROR: " + e2.getMessage());
                            }
                        }
                        finally {
                            if (t != null) {
                                t.close();
                            }
                        }
                        ++i2;
                    }
                }
                ++x;
            }
            return sendError ? 0 : 1;
        }
        catch (Exception e3) {
            user.errorLog("sendMail - GENERIC ERROR: " + e3);
            return -1;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int sendMail(String to, String subject, String text, String SmtpHostName, Integer SmtpHostPort, String SmtpHostSSL, String SmtpHostUser, String SmtpHostPassword, String fromAddress) {
        Service t = null;
        boolean sendError = true;
        try {
            boolean SmtpDebug;
            String s = user.varGet("$smtpdebug");
            boolean bl = SmtpDebug = s != null && s.equalsIgnoreCase("true");
            int SmtpHostSSLMode = "true".equals(SmtpHostSSL) ? 1 : ("esmtp".equals(SmtpHostSSL) ? 2 : 0);
            if (SmtpHostPort == null) {
                switch (SmtpHostSSLMode) {
                    case 1: {
                        SmtpHostPort = 465;
                        break;
                    }
                    case 2: {
                        SmtpHostPort = 587;
                        break;
                    }
                    default: {
                        SmtpHostPort = 25;
                    }
                }
            }
            final String SmtpHostUserFinal = new String(SmtpHostUser);
            final String SmtpHostPasswordFinal = new String(SmtpHostPassword);
            String[] recipients = to.split("[, ]");
            int x = 0;
            while (x < recipients.length) {
                if (recipients[x].length() > 0) {
                    Object[] servers;
                    String[] ta = recipients[x].split("@");
                    if (ta.length != 2 || ta[1].length() < 4) {
                        user.errorLog("sendMail - ERROR: to address is invalid");
                        return -1;
                    }
                    if (SmtpHostName.length() == 0) {
                        String[] da = ta[1].split(":");
                        if (da.length == 2) {
                            to = String.valueOf(ta[0]) + "@" + da[0];
                            servers = new Object[]{da[1]};
                        } else {
                            Hashtable<String, String> env = new Hashtable<String, String>();
                            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                            InitialDirContext ictx = new InitialDirContext(env);
                            Attributes attrs = ictx.getAttributes(ta[1], new String[]{"MX"});
                            Attribute attr = attrs.get("MX");
                            NamingEnumeration<?> en = attr.getAll();
                            TreeMap<Integer, String> ns = new TreeMap<Integer, String>();
                            while (en.hasMore()) {
                                String[] sa = ((String)en.next()).split(" ");
                                ns.put(Integer.parseInt(sa[0]), sa[1].endsWith(".") ? sa[1].substring(0, sa[1].length() - 1) : sa[1]);
                            }
                            servers = ns.values().toArray();
                        }
                    } else {
                        servers = new Object[]{null};
                    }
                    int i2 = 0;
                    while (i2 < servers.length) {
                        try {
                            Session session;
                            Properties props = new Properties();
                            if (servers[i2] != null) {
                                props.setProperty("mail.smtp.host", (String)servers[i2]);
                                session = Session.getInstance(props, null);
                            } else {
                                props.setProperty("mail.smtp.host", SmtpHostName);
                                props.setProperty("mail.smtp.port", Integer.toString(SmtpHostPort));
                                switch (SmtpHostSSLMode) {
                                    case 1: {
                                        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                                        props.setProperty("mail.smtp.socketFactory.fallback", "false");
                                        break;
                                    }
                                    case 2: {
                                        props.setProperty("mail.smtp.starttls.enable", "true");
                                    }
                                }
                                if (SmtpHostUser.length() > 0 || SmtpHostPassword.length() > 0) {
                                    props.setProperty("mail.smtp.auth", "true");
                                    session = Session.getInstance(props, new Authenticator(){

                                        protected PasswordAuthentication getPasswordAuthentication() {
                                            return new PasswordAuthentication(SmtpHostUserFinal, SmtpHostPasswordFinal);
                                        }
                                    });
                                } else {
                                    session = Session.getInstance(props, null);
                                }
                            }
                            if (SmtpDebug) {
                                session.setDebug(true);
                            }
                            MimeMessage message = new MimeMessage(session);
                            message.setFrom(new InternetAddress(fromAddress));
                            message.addRecipient(Message.RecipientType.TO, new InternetAddress(recipients[x]));
                            message.setSubject(subject);
                            message.setText(text);
                            t = session.getTransport("smtp");
                            t.connect();
                            ((Transport)t).sendMessage(message, message.getAllRecipients());
                            sendError = false;
                            break;
                        }
                        catch (Exception e2) {
                            if (Configuration.verboseLog) {
                                user.errorLog("sendMail - ERROR: " + e2.getMessage());
                            }
                        }
                        finally {
                            if (t != null) {
                                t.close();
                            }
                        }
                        ++i2;
                    }
                }
                ++x;
            }
            return sendError ? 0 : 1;
        }
        catch (Exception e3) {
            user.errorLog("sendMail - GENERIC ERROR: " + e3);
            return -1;
        }
    }

    public static int sendMail(String to, String subject, Vector<String> names, Vector<byte[]> data) {
        Integer SmtpHostPort;
        String SmtpHostName = user.varGet("emailaccountserver!");
        try {
            SmtpHostPort = Integer.parseInt(user.varGet("emailaccountport!"));
        }
        catch (Exception e2) {
            SmtpHostPort = null;
        }
        String SmtpHostSSL = user.varGet("emailaccountssl!");
        String SmtpHostUser = user.varGet("emailaccountuser!");
        String SmtpHostPassword = user.varGet("emailaccountpassword!");
        String fromAddress = user.varGet("emailaccountaddress!");
        return Reports.sendMail(to, subject, names, data, SmtpHostName, SmtpHostPort, SmtpHostSSL, SmtpHostUser, SmtpHostPassword, fromAddress);
    }

    public static int sendMail(String to, String subject, String text) {
        Integer SmtpHostPort;
        String SmtpHostName = user.varGet("emailaccountserver!");
        try {
            SmtpHostPort = Integer.parseInt(user.varGet("emailaccountport!"));
        }
        catch (Exception e2) {
            SmtpHostPort = null;
        }
        String SmtpHostSSL = user.varGet("emailaccountssl!");
        String SmtpHostUser = user.varGet("emailaccountuser!");
        String SmtpHostPassword = user.varGet("emailaccountpassword!");
        String fromAddress = user.varGet("emailaccountaddress!");
        return Reports.sendMail(to, subject, text, SmtpHostName, SmtpHostPort, SmtpHostSSL, SmtpHostUser, SmtpHostPassword, fromAddress);
    }

    public static int sendTelegram(String text) {
        user.ioSet("telegram.message.all", text);
        if ("online".equals(user.ioGet("telegram.connection"))) {
            return 1;
        }
        return 0;
    }

    static String encodeBase64String(byte[] data) throws Exception {
        String s = Base64.encodeBase64String(data);
        int i2 = s.lastIndexOf(13);
        return i2 != -1 ? s.substring(0, i2) : s;
    }
}

