/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.Configuration;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.Vector;
import plugins.wsmeasure.ALPTEC;
import plugins.wsmeasure.CONTREL;
import plugins.wsmeasure.DMX3;
import plugins.wsmeasure.DPX3;
import plugins.wsmeasure.DX3;
import plugins.wsmeasure.EMDX3;
import plugins.wsmeasure.EMS;
import plugins.wsmeasure.ENTES;
import plugins.wsmeasure.F4;
import plugins.wsmeasure.GENERIC;
import plugins.wsmeasure.GatewayCache;
import plugins.wsmeasure.IME;
import plugins.wsmeasure.M7TIC;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polling {
    public static Hashtable<Integer, SensorCache> sensorCache = new Hashtable();
    public static Hashtable<Integer, GatewayCache> gatewayCache = new Hashtable();
    public static Object configurationSemaphore = new Object();
    public static long meterPollingEventTime = 0L;
    private static PreparedStatement ststmt;
    private static PreparedStatement thstmt;
    private static PreparedStatement eqstmt;
    private static PreparedStatement eninsertstmt;
    private static PreparedStatement enupdatestmt;
    private static PreparedStatement ensinsertstmt;
    private static PreparedStatement ensupdatestmt;
    private static PreparedStatement enswinsertstmt;
    private static PreparedStatement enswupdatestmt;
    private static PreparedStatement ensginsertstmt;
    private static PreparedStatement ensgupdatestmt;
    private static PreparedStatement pfsinsertstmt;
    private static PreparedStatement pfsupdatestmt;
    private static PreparedStatement checkpoint;
    private static boolean checkpointSemaphore;

    static {
        checkpointSemaphore = false;
    }

    public static void gatewayStartAll() {
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select gatewayid, name, address, rackid, eqsensorid, enabled from gateways order by gatewayid");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Polling.gatewayStart(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getInt(4), rs.getInt(5), rs.getBoolean(6));
            }
            rs.close();
            ststmt = user.databaseConnection.prepareStatement("insert into stdata (sensorid, ltime, meter, raw) values (?, ?, ?, ?)");
            thstmt = user.databaseConnection.prepareStatement("insert into thdata (sensorid, ltime, raw) values (?, ?, ?)");
            eqstmt = user.databaseConnection.prepareStatement("insert into eqdata (sensorid, ltime, raw, thderror, herror) values (?, ?, ?, ?, ?)");
            eninsertstmt = user.databaseConnection.prepareStatement("insert into endata (groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            enupdatestmt = user.databaseConnection.prepareStatement("update endata set meterhr = meterhr + ?, ltime = ? where groupid = ? and loadid = ? and lyear = ? and lmonth = ? and lday = ? and lhour = ? and lmin = ?");
            ensinsertstmt = user.databaseConnection.prepareStatement("insert into ensdata (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, ?, ?, ?)");
            ensupdatestmt = user.databaseConnection.prepareStatement("update ensdata set meterhr = meterhr + ?, ltime = ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and lhour = ? and lmin = ?");
            enswinsertstmt = user.databaseConnection.prepareStatement("insert into ensdatawater (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, ?, ?, ?)");
            enswupdatestmt = user.databaseConnection.prepareStatement("update ensdatawater set meterhr = meterhr + ?, ltime = ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and lhour = ? and lmin = ?");
            ensginsertstmt = user.databaseConnection.prepareStatement("insert into ensdatagas (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, ?, ?, ?)");
            ensgupdatestmt = user.databaseConnection.prepareStatement("update ensdatagas set meterhr = meterhr + ?, ltime = ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and lhour = ? and lmin = ?");
            pfsinsertstmt = user.databaseConnection.prepareStatement("insert into pfsdata (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr, samples) values (?, ?, ?, ?, ?, ?, ?, ?, 1)");
            pfsupdatestmt = user.databaseConnection.prepareStatement("update pfsdata set meterhr = meterhr + ?, samples = samples + 1, ltime = ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and lhour = ? and lmin = ?");
            checkpoint = user.databaseConnection.prepareStatement("checkpoint");
        }
        catch (Exception e2) {
            user.errorLog("POLLING: INITIALIZATION ERROR - SYSTEM RESTARTING NOW");
            user.sleep(5000L);
            System.exit(2);
        }
    }

    public static void gatewayStart(int id) {
        Polling.gatewayStart(id, Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).name, Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).address, Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).rackid, Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).eqsensorid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gatewayStart(int id, String name, String address, int rackid, int eqsensorid, boolean enabled) {
        user.messageLog("POLLING: GATEWAY START [" + name + "]");
        Object object = configurationSemaphore;
        synchronized (object) {
            gatewayCache.put(id, new GatewayCache(id, name, address, rackid, eqsensorid, enabled));
            if (enabled) {
                user.schedulerRegister("poll_gw_" + id, "meter", 90000);
                user.schedulerRegister("poll_gw_" + id, "std", user.dataConsolidationIntervalMinutes * 60000);
                user.schedulerRegister("poll_gw_" + id, "thd", 600000);
                user.schedulerRegister("poll_gw_" + id, "status", user.statusPollTime * 1000);
                user.schedulerRegister("poll_gw_" + id, "pf", 60000);
                if (eqsensorid >= 0) {
                    user.schedulerRegister("poll_gw_" + id, "eq", 10000);
                } else {
                    user.schedulerRemove("poll_gw_" + id, "eq");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gatewaySensorsUpdate(int id) {
        Object object = configurationSemaphore;
        synchronized (object) {
            Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).sensors = null;
            Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).eqsensormodel = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gatewayStop(int id) {
        user.messageLog("POLLING: GATEWAY STOP [" + Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).name + "]");
        Object object = configurationSemaphore;
        synchronized (object) {
            user.schedulerRemove("poll_gw_" + id, "meter");
            user.schedulerRemove("poll_gw_" + id, "std");
            user.schedulerRemove("poll_gw_" + id, "thd");
            user.schedulerRemove("poll_gw_" + id, "status");
            user.schedulerRemove("poll_gw_" + id, "eq");
            Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).enabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gatewayDelete(int id) {
        user.messageLog("POLLING: GATEWAY DELETE [" + Polling.gatewayCache.get((Object)Integer.valueOf((int)id)).name + "]");
        Object object = configurationSemaphore;
        synchronized (object) {
            user.schedulerRemove("poll_gw_" + id, "meter");
            user.schedulerRemove("poll_gw_" + id, "std");
            user.schedulerRemove("poll_gw_" + id, "thd");
            user.schedulerRemove("poll_gw_" + id, "status");
            user.schedulerRemove("poll_gw_" + id, "eq");
            gatewayCache.remove(id);
            user.printSettings = true;
        }
    }

    public static void pollingEvent(String groupname, String schedulename) {
        block260: {
            SensorCache sensor = null;
            byte[] energypos = null;
            byte[] energyneg = null;
            byte[] avgext = null;
            byte[] maxext = null;
            byte[] maxbase = null;
            byte[] thdstat = null;
            byte[] steps = null;
            byte[] thd = null;
            byte[] hi = null;
            byte[] hu = null;
            byte[] hv = null;
            boolean[] booleanvalues = null;
            int[] intvalues = null;
            try {
                int gatewayid = Integer.parseInt(groupname.substring(8));
                GatewayCache cache = gatewayCache.get(gatewayid);
                String gateway = cache.address;
                if (cache.sensors == null) {
                    Polling.gatewaySensorsReload(gatewayid);
                }
                if (schedulename.equals("status")) {
                    int i2 = 0;
                    while (cache.sensors != null && i2 < cache.sensors.length) {
                        block259: {
                            try {
                                sensor = cache.sensors[i2];
                                if (!sensor.enabled) break block259;
                                switch (sensor.modelid) {
                                    case 20: {
                                        Integer status = DMX3.readBreakerState(gateway, sensor.address);
                                        if (status == null) {
                                            if (sensor.breakerstate != null) {
                                                sensor.breakerstate = null;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "");
                                            }
                                        } else if (status == -1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != -1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "fault");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "fault");
                                            }
                                        } else if (status == 1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != 1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "1");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "1");
                                            }
                                        } else if (status == 0 && (sensor.breakerstate == null || sensor.breakerstate != 0)) {
                                            sensor.breakerstate = status;
                                            user.varSet("$xbreaker.s." + sensor.sensorid, "0");
                                            user.uiSet("xbreaker.s" + sensor.sensorid, "value", "0");
                                        }
                                        break;
                                    }
                                    case 21: {
                                        Integer status = DPX3.readBreakerState(gateway, sensor.address);
                                        if (status == null) {
                                            if (sensor.breakerstate != null) {
                                                sensor.breakerstate = null;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "");
                                            }
                                        } else if (status == -1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != -1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "fault");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "fault");
                                            }
                                        } else if (status == 1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != 1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "1");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "1");
                                            }
                                        } else if (status == 0 && (sensor.breakerstate == null || sensor.breakerstate != 0)) {
                                            sensor.breakerstate = status;
                                            user.varSet("$xbreaker.s." + sensor.sensorid, "0");
                                            user.uiSet("xbreaker.s" + sensor.sensorid, "value", "0");
                                        }
                                        break;
                                    }
                                    case 42: {
                                        Integer status = DX3.readBreakerState(gateway, sensor.address);
                                        if (status == null) {
                                            if (sensor.breakerstate != null) {
                                                sensor.breakerstate = null;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "");
                                            }
                                        } else if (status == 1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != 1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "1");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "1");
                                            }
                                        } else if (status == 0 && (sensor.breakerstate == null || sensor.breakerstate != 0)) {
                                            sensor.breakerstate = status;
                                            user.varSet("$xbreaker.s." + sensor.sensorid, "0");
                                            user.uiSet("xbreaker.s" + sensor.sensorid, "value", "0");
                                        }
                                        break;
                                    }
                                    case 62: {
                                        Integer status = EMS.readBreakerState(gateway, sensor.address);
                                        if (status == null || status == -2) {
                                            if (sensor.breakerstate != null) {
                                                sensor.breakerstate = null;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "");
                                            }
                                        } else if (status == -1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != -1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "fault");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "fault");
                                            }
                                        } else if (status == 1) {
                                            if (sensor.breakerstate == null || sensor.breakerstate != 1) {
                                                sensor.breakerstate = status;
                                                user.varSet("$xbreaker.s." + sensor.sensorid, "1");
                                                user.uiSet("xbreaker.s" + sensor.sensorid, "value", "1");
                                            }
                                        } else if (status == 0 && (sensor.breakerstate == null || sensor.breakerstate != 0)) {
                                            sensor.breakerstate = status;
                                            user.varSet("$xbreaker.s." + sensor.sensorid, "0");
                                            user.uiSet("xbreaker.s" + sensor.sensorid, "value", "0");
                                        }
                                        EMS.discoveryLink(gateway, sensor.address, 1);
                                        user.uiSet("xlink.s" + sensor.sensorid, "value", EMS.isLinked(gateway, sensor.address) ? "1" : "0");
                                        break;
                                    }
                                    case 90: {
                                        int j2;
                                        booleanvalues = M7TIC.readDecodeDigitalInputsState(gateway, sensor.address);
                                        if (booleanvalues != null) {
                                            j2 = 0;
                                            while (j2 < 24) {
                                                user.varSet("$state.s." + sensor.sensorid + ".din." + (j2 + 1), booleanvalues[j2] ? "1" : "0");
                                                ++j2;
                                            }
                                        }
                                        if ((booleanvalues = M7TIC.readDecodeDigitalOutputsState(gateway, sensor.address)) != null) {
                                            j2 = 0;
                                            while (j2 < 6) {
                                                user.varSet("$state.s." + sensor.sensorid + ".dout." + (j2 + 1), booleanvalues[j2] ? "1" : "0");
                                                ++j2;
                                            }
                                        }
                                        if ((intvalues = M7TIC.readDecodeAnalogInputsState(gateway, sensor.address)) != null) {
                                            j2 = 0;
                                            while (j2 < 4) {
                                                user.varSet("$state.s." + sensor.sensorid + ".ain." + (j2 + 1), Integer.toString(intvalues[i2]));
                                                ++j2;
                                            }
                                        }
                                        break;
                                    }
                                    case 91: {
                                        booleanvalues = M7TIC.readDecodeDigitalOutputsState(gateway, sensor.address);
                                        if (booleanvalues != null) {
                                            int j3 = 0;
                                            while (j3 < 6) {
                                                user.varSet("$state.s." + sensor.sensorid + ".dout." + (j3 + 1), booleanvalues[j3] ? "1" : "0");
                                                ++j3;
                                            }
                                        }
                                        break;
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i2;
                    }
                    break block260;
                }
                if (schedulename.equals("eq")) {
                    if (cache.eqsensorid >= 0) {
                        sensor = sensorCache.get(cache.eqsensorid);
                        if (sensor.enabled) {
                            if (user.Models.elementAt(sensor.modelid)[10].length() > 0) {
                                switch (sensor.modelid) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        avgext = EMDX3.readAvgExt(gateway, sensor.address);
                                        break;
                                    }
                                    case 41: {
                                        avgext = CONTREL.readAvgExt(gateway, sensor.address);
                                        break;
                                    }
                                    case 44: 
                                    case 45: 
                                    case 46: 
                                    case 92: 
                                    case 93: {
                                        avgext = F4.readAvgExtN200(gateway, sensor.address);
                                        break;
                                    }
                                    case 48: 
                                    case 49: {
                                        avgext = ENTES.readAvgExtMPR46S(gateway, sensor.address);
                                        break;
                                    }
                                    case 152: {
                                        avgext = IME.readAvgExtCE4DF(gateway, sensor.address);
                                    }
                                }
                            }
                            if (user.Models.elementAt(sensor.modelid)[4].length() > 0) {
                                switch (sensor.modelid) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        thd = EMDX3.readTHD(gateway, sensor.address);
                                        break;
                                    }
                                    case 21: {
                                        thd = DPX3.readTHD(gateway, sensor.address);
                                        break;
                                    }
                                    case 41: {
                                        thd = CONTREL.readTHD(gateway, sensor.address);
                                        break;
                                    }
                                    case 42: {
                                        thd = DX3.readTHD(gateway, sensor.address);
                                        break;
                                    }
                                    case 44: 
                                    case 92: {
                                        thd = F4.readTHDN200(gateway, sensor.address);
                                        break;
                                    }
                                    case 45: 
                                    case 46: 
                                    case 93: {
                                        thd = F4.readTHDN300(gateway, sensor.address);
                                        break;
                                    }
                                    case 48: 
                                    case 49: {
                                        thd = ENTES.readTHDMPR46S(gateway, sensor.address);
                                        break;
                                    }
                                    case 62: {
                                        thd = EMS.readTHD(gateway, sensor.address);
                                        break;
                                    }
                                    case 124: 
                                    case 125: 
                                    case 126: {
                                        thd = ALPTEC.readTHDX2(gateway, sensor.address);
                                        break;
                                    }
                                    case 127: {
                                        thd = ALPTEC.readTHD8(gateway, sensor.address);
                                        break;
                                    }
                                    case 152: {
                                        thd = IME.readTHDCE4DF(gateway, sensor.address);
                                    }
                                }
                            }
                            if (user.Models.elementAt(sensor.modelid)[11].length() > 0) {
                                switch (sensor.modelid) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        hi = EMDX3.readHarmonicI(gateway, sensor.address);
                                        hu = EMDX3.readHarmonicU(gateway, sensor.address);
                                        hv = EMDX3.readHarmonicV(gateway, sensor.address);
                                        break;
                                    }
                                    case 44: {
                                        hi = F4.readHarmonicIN200(gateway, sensor.address);
                                        hu = F4.readHarmonicUN200(gateway, sensor.address);
                                        hv = F4.readHarmonicVN200(gateway, sensor.address);
                                        break;
                                    }
                                    case 45: {
                                        hi = F4.readHarmonicIN200(gateway, sensor.address);
                                        hu = F4.readHarmonicUN300(gateway, sensor.address);
                                        hv = F4.readHarmonicVN300(gateway, sensor.address);
                                        break;
                                    }
                                    case 46: {
                                        hi = F4.readHarmonicIN400(gateway, sensor.address);
                                        hu = F4.readHarmonicUN400(gateway, sensor.address);
                                        hv = F4.readHarmonicVN400(gateway, sensor.address);
                                        break;
                                    }
                                    case 49: {
                                        hi = ENTES.readHarmonicIMPR47S(gateway, sensor.address);
                                        hv = ENTES.readHarmonicVMPR47S(gateway, sensor.address);
                                        break;
                                    }
                                    case 62: {
                                        hi = EMS.readHarmonicI(gateway, sensor.address);
                                        hv = EMS.readHarmonicV(gateway, sensor.address);
                                    }
                                }
                            }
                            Polling.eqdataSave(sensor, avgext, thd, hi, hu, hv);
                            Polling.sensorErrorFlag(sensor, false);
                        }
                    }
                    break block260;
                }
                if (schedulename.equals("thd")) {
                    int i3 = 0;
                    while (cache.sensors != null && i3 < cache.sensors.length) {
                        try {
                            sensor = cache.sensors[i3];
                            if (sensor.enabled && user.Models.elementAt(sensor.modelid)[4].length() > 0) {
                                switch (sensor.modelid) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        thd = EMDX3.readTHD(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 21: {
                                        thd = DPX3.readTHD(gateway, sensor.address);
                                        if (thd.length != 0) {
                                            Polling.thdataSave(sensor, thd);
                                        }
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 41: {
                                        thd = CONTREL.readTHD(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 42: {
                                        thd = DX3.readTHD(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 44: 
                                    case 92: {
                                        thd = F4.readTHDN200(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 45: 
                                    case 46: 
                                    case 93: {
                                        thd = F4.readTHDN300(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 48: 
                                    case 49: {
                                        thd = ENTES.readTHDMPR46S(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 62: {
                                        thd = EMS.readTHD(gateway, sensor.address);
                                        if (thd.length != 0) {
                                            Polling.thdataSave(sensor, thd);
                                        }
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 124: 
                                    case 125: 
                                    case 126: {
                                        thd = ALPTEC.readTHDX2(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 127: {
                                        thd = ALPTEC.readTHD8(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 152: {
                                        thd = IME.readTHDCE4DF(gateway, sensor.address);
                                        Polling.thdataSave(sensor, thd);
                                        Polling.sensorErrorFlag(sensor, false);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        }
                        catch (Exception e2) {
                            if (sensor != null) {
                                Polling.sensorErrorFlag(sensor, true);
                                user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: " + sensor.sensorid);
                            }
                            user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: ?");
                        }
                        ++i3;
                    }
                    break block260;
                }
                if (schedulename.equals("meter")) {
                    Polling.gatewayTest(cache);
                    int i4 = 0;
                    while (cache.sensors != null && i4 < cache.sensors.length) {
                        block261: {
                            try {
                                sensor = cache.sensors[i4];
                                if (!sensor.enabled || user.Models.elementAt(sensor.modelid)[6].length() <= 0) break block261;
                                switch (sensor.modelid) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        energypos = EMDX3.readPartialEnergyPos(gateway, sensor.address);
                                        long meter = EMDX3.decodePartialEnergyPos(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 4: 
                                    case 5: {
                                        energypos = IME.readEnergyPos467x(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPos467x(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 6: 
                                    case 7: {
                                        energypos = IME.readEnergyPos4680(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPos4680(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 94: {
                                        energypos = IME.readEnergyPos412074(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPos412074(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 8: 
                                    case 18: 
                                    case 19: {
                                        energypos = IME.readEnergyPos4684(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPos468x(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 9: {
                                        energypos = IME.readEnergyPos4686(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPos468x(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 10: 
                                    case 11: 
                                    case 12: 
                                    case 13: 
                                    case 14: 
                                    case 15: 
                                    case 16: 
                                    case 17: 
                                    case 61: 
                                    case 64: {
                                        if (sensor.subaddress.startsWith("0:")) {
                                            energypos = EMDX3.readTotalEnergyCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = EMDX3.decodeTotalEnergyCounter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("1:")) {
                                            energypos = F4.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = F4.decodeTotalEnergyCounter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("2:")) {
                                            energypos = F4.readTotalCounter12(gateway, sensor.address, sensor.subaddress);
                                            long meter = F4.decodeTotalEnergyCounter12(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("3:")) {
                                            energypos = EMS.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = EMS.decodeTotalEnergyCounter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("4:") || sensor.subaddress.startsWith("5:") || sensor.subaddress.startsWith("6:")) {
                                            energypos = IME.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = IME.decodeTotalEnergyCounter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                        }
                                        break;
                                    }
                                    case 20: {
                                        energypos = DMX3.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                        if (energypos.length != 1) {
                                            long meter = DMX3.decodeEnergyPos(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                        }
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 21: {
                                        energypos = DPX3.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                        if (energypos.length != 0) {
                                            long meter = DPX3.decodeEnergyPos(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                        }
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 39: 
                                    case 40: {
                                        if (sensor.subaddress.startsWith("0:")) {
                                            energypos = EMDX3.readTotalM3Counter(gateway, sensor.address, sensor.subaddress);
                                            long meter = EMDX3.decodeTotalM3Counter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("1:")) {
                                            energypos = F4.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = F4.decodeTotalM3Counter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("2:")) {
                                            energypos = F4.readTotalCounter12(gateway, sensor.address, sensor.subaddress);
                                            long meter = F4.decodeTotalM3Counter12(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("3:")) {
                                            energypos = EMS.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = EMS.decodeTotalM3Counter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                            break;
                                        }
                                        if (sensor.subaddress.startsWith("4:") || sensor.subaddress.startsWith("5:") || sensor.subaddress.startsWith("6:")) {
                                            energypos = IME.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            long meter = IME.decodeTotalM3Counter(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                            Polling.sensorErrorFlag(sensor, false);
                                        }
                                        break;
                                    }
                                    case 41: {
                                        energypos = CONTREL.readPartialEnergyPos(gateway, sensor.address);
                                        long meter = CONTREL.decodePartialEnergyPos(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 42: {
                                        energypos = DX3.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                        if (energypos.length != 1) {
                                            long meter = DX3.decodeEnergyPos(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                        }
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 43: {
                                        energypos = GENERIC.readTotalEnergy(gateway, sensor.address, sensor.subaddress);
                                        long meter = GENERIC.decodeTotalEnergy(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 44: 
                                    case 92: {
                                        energypos = F4.readEnergyPosN200(gateway, sensor.address);
                                        long meter = F4.decodeEnergyPosN200(energypos, 100).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 45: 
                                    case 46: 
                                    case 93: {
                                        energypos = F4.readEnergyPosN200(gateway, sensor.address);
                                        long meter = F4.decodeEnergyPosN200(energypos, 10).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 48: 
                                    case 49: {
                                        energypos = ENTES.readEnergyPosMPR46S(gateway, sensor.address);
                                        long meter = ENTES.decodeEnergyPosMPR46S(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 62: {
                                        energypos = EMS.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                        if (energypos.length != 0) {
                                            long meter = EMS.decodeEnergyPos(energypos).get("Ea");
                                            Polling.meterSave(sensor, meter);
                                        }
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 63: {
                                        energypos = IME.readEnergyPos412068(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPos412068(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 136: {
                                        energypos = IME.readEnergyPosD4DC(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPosD4DC(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 141: {
                                        energypos = IME.readEnergyPosCE2DF(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPosCE2DF(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                        break;
                                    }
                                    case 145: 
                                    case 152: {
                                        energypos = IME.readEnergyPosCE4DF(gateway, sensor.address);
                                        long meter = IME.decodeEnergyPosCE4DF(energypos).get("Ea");
                                        Polling.meterSave(sensor, meter);
                                        Polling.sensorErrorFlag(sensor, false);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                            catch (Exception e3) {
                                if (sensor != null) {
                                    Polling.sensorErrorFlag(sensor, true);
                                    user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: " + sensor.sensorid);
                                }
                                user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: ?");
                            }
                        }
                        ++i4;
                    }
                    meterPollingEventTime = System.currentTimeMillis();
                    break block260;
                }
                if (schedulename.equals("std")) {
                    int i5 = 0;
                    while (cache.sensors != null && i5 < cache.sensors.length) {
                        try {
                            sensor = cache.sensors[i5];
                            if (sensor.enabled) {
                                boolean skip = true;
                                steps = null;
                                thdstat = null;
                                maxbase = null;
                                maxext = null;
                                avgext = null;
                                energyneg = null;
                                energypos = null;
                                if (user.Models.elementAt(sensor.modelid)[6].length() > 0) {
                                    switch (sensor.modelid) {
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            skip = false;
                                            energypos = EMDX3.readPartialEnergyPos(gateway, sensor.address);
                                            break;
                                        }
                                        case 4: 
                                        case 5: {
                                            skip = false;
                                            energypos = IME.readEnergyPos467x(gateway, sensor.address);
                                            break;
                                        }
                                        case 6: 
                                        case 7: {
                                            skip = false;
                                            energypos = IME.readEnergyPos4680(gateway, sensor.address);
                                            break;
                                        }
                                        case 94: {
                                            skip = false;
                                            energypos = IME.readEnergyPos412074(gateway, sensor.address);
                                            break;
                                        }
                                        case 8: 
                                        case 18: 
                                        case 19: {
                                            skip = false;
                                            energypos = IME.readEnergyPos4684(gateway, sensor.address);
                                            break;
                                        }
                                        case 9: {
                                            skip = false;
                                            energypos = IME.readEnergyPos4686(gateway, sensor.address);
                                            break;
                                        }
                                        case 10: 
                                        case 11: 
                                        case 12: 
                                        case 13: 
                                        case 14: 
                                        case 15: 
                                        case 16: 
                                        case 17: 
                                        case 61: 
                                        case 64: {
                                            if (sensor.subaddress.startsWith("0:")) {
                                                skip = false;
                                                energypos = EMDX3.readTotalEnergyCounter(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (sensor.subaddress.startsWith("1:")) {
                                                skip = false;
                                                energypos = F4.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (sensor.subaddress.startsWith("2:")) {
                                                skip = false;
                                                energypos = F4.readTotalCounter12(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (sensor.subaddress.startsWith("3:")) {
                                                skip = false;
                                                energypos = EMS.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (!sensor.subaddress.startsWith("4:") && !sensor.subaddress.startsWith("5:") && !sensor.subaddress.startsWith("6:")) break;
                                            skip = false;
                                            energypos = IME.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            break;
                                        }
                                        case 20: {
                                            skip = false;
                                            energypos = DMX3.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 21: {
                                            skip = false;
                                            energypos = DPX3.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 39: 
                                        case 40: {
                                            if (sensor.subaddress.startsWith("0:")) {
                                                skip = false;
                                                energypos = EMDX3.readTotalM3Counter(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (sensor.subaddress.startsWith("1:")) {
                                                skip = false;
                                                energypos = F4.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (sensor.subaddress.startsWith("2:")) {
                                                skip = false;
                                                energypos = F4.readTotalCounter12(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (sensor.subaddress.startsWith("3:")) {
                                                skip = false;
                                                energypos = EMS.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                                break;
                                            }
                                            if (!sensor.subaddress.startsWith("4:") && !sensor.subaddress.startsWith("5:") && !sensor.subaddress.startsWith("6:")) break;
                                            skip = false;
                                            energypos = IME.readTotalCounter(gateway, sensor.address, sensor.subaddress);
                                            break;
                                        }
                                        case 41: {
                                            skip = false;
                                            energypos = CONTREL.readPartialEnergyPos(gateway, sensor.address);
                                            break;
                                        }
                                        case 42: {
                                            skip = false;
                                            energypos = DX3.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 43: {
                                            skip = false;
                                            energypos = GENERIC.readTotalEnergy(gateway, sensor.address, sensor.subaddress);
                                            break;
                                        }
                                        case 44: 
                                        case 45: 
                                        case 46: 
                                        case 92: 
                                        case 93: {
                                            skip = false;
                                            energypos = F4.readEnergyPosN200(gateway, sensor.address);
                                            break;
                                        }
                                        case 48: 
                                        case 49: {
                                            skip = false;
                                            energypos = ENTES.readEnergyPosMPR46S(gateway, sensor.address);
                                            break;
                                        }
                                        case 62: {
                                            skip = false;
                                            energypos = EMS.readEnergyPos(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 63: {
                                            skip = false;
                                            energypos = IME.readEnergyPos412068(gateway, sensor.address);
                                            break;
                                        }
                                        case 136: {
                                            skip = false;
                                            energypos = IME.readEnergyPosD4DC(gateway, sensor.address);
                                            break;
                                        }
                                        case 141: {
                                            skip = false;
                                            energypos = IME.readEnergyPosCE2DF(gateway, sensor.address);
                                            break;
                                        }
                                        case 145: 
                                        case 152: {
                                            skip = false;
                                            energypos = IME.readEnergyPosCE4DF(gateway, sensor.address);
                                        }
                                    }
                                }
                                if (user.Models.elementAt(sensor.modelid)[7].length() > 0) {
                                    switch (sensor.modelid) {
                                        case 2: 
                                        case 3: {
                                            skip = false;
                                            energyneg = EMDX3.readPartialEnergyNeg(gateway, sensor.address);
                                            break;
                                        }
                                        case 20: {
                                            skip = false;
                                            energyneg = DMX3.readEnergyNeg(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 21: {
                                            skip = false;
                                            energyneg = DPX3.readEnergyNeg(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 41: {
                                            skip = false;
                                            energyneg = CONTREL.readPartialEnergyNeg(gateway, sensor.address);
                                            break;
                                        }
                                        case 42: {
                                            skip = false;
                                            energyneg = DX3.readEnergyNeg(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 44: 
                                        case 45: 
                                        case 46: 
                                        case 92: 
                                        case 93: {
                                            skip = false;
                                            energyneg = F4.readEnergyNegN200(gateway, sensor.address);
                                            break;
                                        }
                                        case 48: 
                                        case 49: {
                                            skip = false;
                                            energyneg = ENTES.readEnergyNegMPR46S(gateway, sensor.address);
                                            break;
                                        }
                                        case 62: {
                                            skip = false;
                                            energyneg = EMS.readEnergyNeg(gateway, sensor.address, sensor.subaddress != null && sensor.subaddress.endsWith("#inv"));
                                            break;
                                        }
                                        case 136: {
                                            skip = false;
                                            energyneg = IME.readEnergyNegD4DC(gateway, sensor.address);
                                            break;
                                        }
                                        case 141: {
                                            skip = false;
                                            energyneg = IME.readEnergyNegCE2DF(gateway, sensor.address);
                                            break;
                                        }
                                        case 145: 
                                        case 152: {
                                            skip = false;
                                            energyneg = IME.readEnergyNegCE4DF(gateway, sensor.address);
                                        }
                                    }
                                }
                                if (user.Models.elementAt(sensor.modelid)[10].length() > 0) {
                                    switch (sensor.modelid) {
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            skip = false;
                                            avgext = EMDX3.readAvgExt(gateway, sensor.address);
                                            break;
                                        }
                                        case 6: 
                                        case 7: 
                                        case 94: {
                                            skip = false;
                                            avgext = IME.readAvgExt4680(gateway, sensor.address);
                                            break;
                                        }
                                        case 8: 
                                        case 9: 
                                        case 18: {
                                            skip = false;
                                            avgext = IME.readAvgExt4686(gateway, sensor.address);
                                            break;
                                        }
                                        case 41: {
                                            skip = false;
                                            avgext = CONTREL.readAvgExt(gateway, sensor.address);
                                            break;
                                        }
                                        case 44: 
                                        case 45: 
                                        case 46: 
                                        case 92: 
                                        case 93: {
                                            skip = false;
                                            avgext = F4.readAvgExtN200(gateway, sensor.address);
                                            break;
                                        }
                                        case 48: 
                                        case 49: {
                                            skip = false;
                                            avgext = ENTES.readAvgExtMPR46S(gateway, sensor.address);
                                            break;
                                        }
                                        case 136: {
                                            skip = false;
                                            avgext = IME.readAvgExtD4DC(gateway, sensor.address);
                                            break;
                                        }
                                        case 152: {
                                            skip = false;
                                            avgext = IME.readAvgExtCE4DF(gateway, sensor.address);
                                        }
                                    }
                                }
                                if (user.Models.elementAt(sensor.modelid)[9].length() > 0) {
                                    switch (sensor.modelid) {
                                        case 2: 
                                        case 3: {
                                            skip = false;
                                            maxext = EMDX3.readMaxExt(gateway, sensor.address);
                                            break;
                                        }
                                        case 44: 
                                        case 92: {
                                            skip = false;
                                            maxext = F4.readMaxExtN200(gateway, sensor.address);
                                            break;
                                        }
                                        case 45: 
                                        case 46: 
                                        case 93: {
                                            skip = false;
                                            maxext = F4.readMaxExtN300(gateway, sensor.address);
                                            break;
                                        }
                                        case 48: 
                                        case 49: {
                                            skip = false;
                                            maxext = ENTES.readMaxExtMPR46S(gateway, sensor.address);
                                            break;
                                        }
                                        case 124: 
                                        case 125: 
                                        case 126: {
                                            skip = false;
                                            maxext = ALPTEC.readMaxExtX2(gateway, sensor.address);
                                            break;
                                        }
                                        case 127: {
                                            skip = false;
                                            maxext = ALPTEC.readMaxExt8(gateway, sensor.address);
                                            break;
                                        }
                                        case 152: {
                                            skip = false;
                                            maxext = IME.readMaxExtCE4DF(gateway, sensor.address);
                                        }
                                    }
                                }
                                if (user.Models.elementAt(sensor.modelid)[8].length() > 0) {
                                    switch (sensor.modelid) {
                                        case 0: 
                                        case 1: 
                                        case 2: 
                                        case 3: {
                                            skip = false;
                                            maxbase = EMDX3.readMaxBase(gateway, sensor.address);
                                            break;
                                        }
                                        case 6: 
                                        case 7: 
                                        case 94: {
                                            skip = false;
                                            maxbase = IME.readMaxBase4680(gateway, sensor.address);
                                            break;
                                        }
                                        case 8: 
                                        case 9: 
                                        case 18: 
                                        case 19: {
                                            skip = false;
                                            maxbase = IME.readMaxBase4686(gateway, sensor.address);
                                            break;
                                        }
                                        case 41: {
                                            skip = false;
                                            maxbase = CONTREL.readMaxBase(gateway, sensor.address);
                                            break;
                                        }
                                        case 44: 
                                        case 45: 
                                        case 46: 
                                        case 92: 
                                        case 93: {
                                            skip = false;
                                            maxbase = F4.readMaxBaseN200(gateway, sensor.address);
                                            break;
                                        }
                                        case 48: 
                                        case 49: {
                                            skip = false;
                                            maxbase = ENTES.readMaxBaseMPR46S(gateway, sensor.address);
                                            break;
                                        }
                                        case 124: 
                                        case 125: 
                                        case 126: {
                                            skip = false;
                                            maxbase = ALPTEC.readMaxBaseX2(gateway, sensor.address);
                                            break;
                                        }
                                        case 136: {
                                            skip = false;
                                            maxbase = IME.readMaxBaseD4DC(gateway, sensor.address);
                                            break;
                                        }
                                        case 152: {
                                            skip = false;
                                            maxbase = IME.readMaxBaseCE4DF(gateway, sensor.address);
                                        }
                                    }
                                }
                                if (user.Models.elementAt(sensor.modelid)[5].length() > 0) {
                                    skip = false;
                                    thdstat = EMDX3.readTHDStat(gateway, sensor.address);
                                }
                                switch (sensor.modelid) {
                                    case 124: 
                                    case 125: {
                                        skip = false;
                                        steps = ALPTEC.readSteps3252(gateway, sensor.address, ALPTEC.getNumberOfStepsByModel(sensor.modelid));
                                        break;
                                    }
                                    case 126: {
                                        skip = false;
                                        steps = ALPTEC.readSteps82(gateway, sensor.address);
                                        break;
                                    }
                                    case 127: {
                                        skip = false;
                                        steps = ALPTEC.readSteps8(gateway, sensor.address);
                                    }
                                }
                                if (!skip) {
                                    if (sensor.modelid != 20 && sensor.modelid != 21 && sensor.modelid != 42 || energypos.length != 0) {
                                        Polling.stdataSave(sensor, energypos, energyneg, avgext, maxext, maxbase, thdstat, steps);
                                    }
                                    Polling.sensorErrorFlag(sensor, false);
                                }
                            }
                        }
                        catch (Exception e4) {
                            if (sensor != null) {
                                Polling.sensorErrorFlag(sensor, true);
                                user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: " + sensor.sensorid);
                            }
                            user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: ?");
                        }
                        ++i5;
                    }
                    break block260;
                }
                if (!schedulename.equals("pf")) break block260;
                int i6 = 0;
                while (cache.sensors != null && i6 < cache.sensors.length) {
                    try {
                        sensor = cache.sensors[i6];
                        if (sensor.enabled) {
                            switch (sensor.modelid) {
                                case 124: 
                                case 125: 
                                case 126: {
                                    Polling.pfSave(sensor, ALPTEC.decodePowerX2(ALPTEC.readPowerX2(gateway, sensor.address)).get("PF").intValue());
                                    Polling.sensorErrorFlag(sensor, false);
                                    break;
                                }
                                case 127: {
                                    Polling.pfSave(sensor, ALPTEC.decodePower8(ALPTEC.readPower8(gateway, sensor.address)).get("PF").intValue());
                                    Polling.sensorErrorFlag(sensor, false);
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e5) {
                        if (sensor != null) {
                            Polling.sensorErrorFlag(sensor, true);
                            user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: " + sensor.sensorid);
                        }
                        user.errorLog("POLLING: EVENT EXCEPTION [" + groupname + "/" + schedulename + "] SENSOR: ?");
                    }
                    ++i6;
                }
            }
            catch (Exception e6) {
                if (sensor != null) {
                    Polling.sensorErrorFlag(sensor, true);
                }
                user.errorLog("POLLING: EVENT/GENERIC EXCEPTION [" + groupname + "/" + schedulename + "]");
            }
        }
    }

    public static void csvFileEnergyImport() {
        File importDirectory = new File("userdata/upload");
        try {
            File[] files = importDirectory.listFiles();
            int i2 = 0;
            while (i2 < files.length) {
                File f2 = files[i2];
                if (f2.isFile() && f2.canWrite()) {
                    Polling.csvFileEnergyImport(f2);
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void csvFileEnergyImport(File f2) {
        block53: {
            BufferedInputStream bin = null;
            OutputStreamWriter okout = null;
            OutputStreamWriter errout = null;
            Scanner s = null;
            String header = null;
            int i2 = 0;
            String filename = null;
            try {
                filename = f2.getName();
                File path = f2.getParentFile();
                if (!filename.endsWith("_energy.csv")) break block53;
                File csvImportedFile = new File(path, String.valueOf(filename.substring(0, filename.length() - 4)) + "_ok.csv");
                File csvRejectedFile = new File(path, String.valueOf(filename.substring(0, filename.length() - 4)) + "_err.csv");
                int sensorid = Integer.parseInt(filename.substring(0, filename.length() - 11));
                SensorCache sensor = Polling.sensorGet(sensorid);
                if (sensor == null) {
                    user.errorLog("IMPORT: SENSOR ENERGY [" + filename + "]: SENSOR [" + sensorid + "] NOT DEFINED");
                    f2.delete();
                    return;
                }
                try {
                    bin = new BufferedInputStream(new FileInputStream(f2));
                    s = new Scanner((InputStream)bin, "UTF-8");
                    s.useDelimiter("[\r\n]+");
                    while (s.hasNext()) {
                        String line = s.next();
                        if (++i2 == 1) {
                            header = line;
                            continue;
                        }
                        boolean error = true;
                        String[] sa = line.split("[;,]");
                        if (sa.length == 2) {
                            try {
                                String[] sb = sa[0].split("[-: ]+", 6);
                                if (sb.length == 5) {
                                    short year = Short.parseShort(sb[0]);
                                    short month = Short.parseShort(sb[1]);
                                    short day = Short.parseShort(sb[2]);
                                    short hour = Short.parseShort(sb[3]);
                                    short minute = Polling.roundMinutes(Short.parseShort(sb[4]));
                                    int energy = Integer.parseInt(sa[1]);
                                    Calendar now = Calendar.getInstance();
                                    now.set(14, 0);
                                    now.set(year, month - 1, day, hour, minute, 0);
                                    Timestamp ts = new Timestamp(now.getTimeInMillis());
                                    Polling.ensdataUpdate(sensor, year, month, day, hour, minute, ts, energy);
                                    if (!sensor.nototals) {
                                        Polling.endataUpdate(sensor.loadid < -1 ? sensor.loadid : -2, sensor.loadid, year, month, day, hour, minute, ts, energy);
                                        int g2 = 0;
                                        while (g2 < sensor.groupid.length) {
                                            if (sensor.groupid[g2] >= 0) {
                                                Polling.endataUpdate(sensor.groupid[g2], sensor.loadid, year, month, day, hour, minute, ts, energy);
                                            }
                                            ++g2;
                                        }
                                    }
                                    error = false;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (error) {
                            if (errout == null) {
                                errout = new OutputStreamWriter((OutputStream)new FileOutputStream(csvRejectedFile, false), "UTF-8");
                                errout.write(header);
                            }
                            errout.write("\r\n");
                            errout.write(line);
                            continue;
                        }
                        if (okout == null) {
                            okout = new OutputStreamWriter((OutputStream)new FileOutputStream(csvImportedFile, false), "UTF-8");
                            okout.write(header);
                        }
                        okout.write("\r\n");
                        okout.write(line);
                    }
                    f2.delete();
                }
                catch (Exception e2) {
                    user.errorLog("IMPORT: SENSOR ENERGY [" + filename + "]: EXCEPTION");
                }
            }
            finally {
                try {
                    bin.close();
                }
                catch (Exception exception) {}
                try {
                    if (okout != null) {
                        okout.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (errout != null) {
                        errout.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gatewaySensorsReload(int id) {
        SensorCache[] sensors;
        Vector<SensorCache> buffer = new Vector<SensorCache>();
        int eqSensorModel = -1;
        GatewayCache gateway = gatewayCache.get(id);
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select sensorid, name, address, interfaceaddress, subaddress, scale, unit, modelid, loadid, group1id, group2id, group3id, group4id, group5id, enabled, nototals, noalerts, priority from sensors where gatewayid = ?");
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int sensorid = rs.getInt(1);
                SensorCache sensor = new SensorCache(sensorid, id, gateway.name, gateway.address, rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getString(5), rs.getDouble(6), rs.getString(7), rs.getInt(8), rs.getInt(9), rs.getInt(10), rs.getInt(11), rs.getInt(12), rs.getInt(13), rs.getInt(14), rs.getBoolean(15), rs.getBoolean(16), rs.getBoolean(17), rs.getBoolean(18));
                buffer.add(sensor);
                sensorCache.put(sensorid, sensor);
                if (sensorid != gateway.eqsensorid) continue;
                eqSensorModel = rs.getInt(3);
            }
            rs.close();
            if (buffer.size() > 0) {
                sensors = buffer.toArray(new SensorCache[buffer.size()]);
                user.messageLog("POLLING: SENSORS UPDATE [" + gateway.name + "]");
            } else {
                sensors = new SensorCache[]{};
            }
        }
        catch (Exception e2) {
            user.errorLog("POLLING: SENSORS UPDATE ERROR [" + gateway.name + "]");
            sensors = null;
            eqSensorModel = -1;
        }
        Object object = configurationSemaphore;
        synchronized (object) {
            gateway.sensors = sensors;
            gateway.eqsensormodel = eqSensorModel;
        }
        user.printSettings = true;
    }

    private static void meterSave(SensorCache sensor, long meter) {
        long delta = 0L;
        long nowmillis = System.currentTimeMillis();
        try {
            if (meter > 0L) {
                if (sensor.meter == -1L) {
                    sensor.meter = meter;
                    sensor.metertime = nowmillis;
                } else if (sensor.meter > meter || meter - sensor.meter > 10000000L) {
                    user.messageLog("POLLING: PARTIAL ENERGY RESET [" + sensor.sensorid + "] " + meter + " .. " + sensor.meter);
                    sensor.meter = meter;
                    sensor.metertime = nowmillis;
                } else if (sensor.metertime < nowmillis - 1800000L) {
                    user.messageLog("POLLING: PARTIAL ENERGY RESET [" + sensor.sensorid + "] timeout: " + (nowmillis - sensor.metertime) + " msec.");
                    sensor.meter = meter;
                    sensor.metertime = nowmillis;
                } else if (sensor.meter < meter) {
                    Calendar now = Calendar.getInstance();
                    Timestamp ts = new Timestamp(now.getTimeInMillis());
                    short lyear = (short)now.get(1);
                    short lmonth = (short)(now.get(2) + 1);
                    short lday = (short)now.get(5);
                    short lhour = (short)now.get(11);
                    short lmin = Polling.roundMinutes((short)now.get(12));
                    delta = meter - sensor.meter;
                    sensor.meter = meter;
                    sensor.metertime = nowmillis;
                    Polling.ensdataUpdate(sensor, lyear, lmonth, lday, lhour, lmin, ts, delta);
                    user.varSet("$energy." + sensor.sensorid, "{\"timestamp\":\"" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now.getTime()) + "\",\"delta\":\"" + delta + "\",\"meter\":\"" + meter + "\"}");
                    if (!sensor.nototals) {
                        Polling.endataUpdate(sensor.loadid < -1 ? sensor.loadid : -2, sensor.loadid, lyear, lmonth, lday, lhour, lmin, ts, delta);
                        int i2 = 0;
                        while (i2 < sensor.groupid.length) {
                            if (sensor.groupid[i2] >= 0) {
                                Polling.endataUpdate(sensor.groupid[i2], sensor.loadid, lyear, lmonth, lday, lhour, lmin, ts, delta);
                            }
                            ++i2;
                        }
                    }
                } else if (sensor.meter == meter) {
                    sensor.metertime = nowmillis;
                }
            }
        }
        catch (Exception e2) {
            user.errorLog("POLLING: ENDATA WRITE ERROR [" + sensor.sensorid + "]");
            Polling.dataErrorAlert(true);
        }
    }

    private static void pfSave(SensorCache sensor, long meter) {
        try {
            Calendar now = Calendar.getInstance();
            long nowts = now.getTimeInMillis();
            Timestamp ts = new Timestamp(nowts);
            short lyear = (short)now.get(1);
            short lmonth = (short)(now.get(2) + 1);
            short lday = (short)now.get(5);
            short lhour = (short)now.get(11);
            short lmin = Polling.roundMinutes((short)now.get(12));
            sensor.meter = meter;
            sensor.metertime = nowts;
            Polling.pfsdataUpdate(sensor, lyear, lmonth, lday, lhour, lmin, ts, meter);
            user.varSet("$pf." + sensor.sensorid, "{\"timestamp\":\"" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now.getTime()) + "\",\"pf\":\"" + meter + "\"}");
        }
        catch (Exception e2) {
            user.errorLog("POLLING: PFSATA WRITE ERROR [" + sensor.sensorid + "]");
            Polling.dataErrorAlert(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stdataSave(SensorCache sensor, byte[] energypos, byte[] energyneg, byte[] avgext, byte[] maxext, byte[] maxbase, byte[] thdstat, byte[] steps) {
        int delta = 0;
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        try {
            if (Configuration.eventsLog) {
                StringBuffer buffer = new StringBuffer();
                StringBuffer log = new StringBuffer("POLLING: LOGGER [");
                switch (sensor.modelid) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        buffer.append(Polling.hashLongToStringBuffer(EMDX3.decodePartialEnergyPos(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(EMDX3.decodePartialEnergyNeg(energyneg)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeAvgExt(avgext)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeMaxExt(maxext)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeMaxBase(maxbase)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeTHDStat(thdstat)));
                        break;
                    }
                    case 4: 
                    case 5: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPos467x(energypos)));
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 94: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPos4680(energypos)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeAvgExt4680(avgext)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeMaxBase4680(maxbase)));
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 18: 
                    case 19: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPos468x(energypos)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeAvgExt4686(avgext)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeMaxBase4686(maxbase)));
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 61: 
                    case 64: {
                        if (sensor.subaddress.startsWith("0:")) {
                            buffer.append(Polling.hashLongToStringBuffer(EMDX3.decodeTotalEnergyCounter(energypos)));
                            break;
                        }
                        if (sensor.subaddress.startsWith("1:")) {
                            buffer.append(Polling.hashLongToStringBuffer(F4.decodeTotalEnergyCounter(energypos)));
                            break;
                        }
                        if (sensor.subaddress.startsWith("2:")) {
                            buffer.append(Polling.hashLongToStringBuffer(F4.decodeTotalEnergyCounter12(energypos)));
                            break;
                        }
                        if (sensor.subaddress.startsWith("3:")) {
                            buffer.append(Polling.hashLongToStringBuffer(EMS.decodeTotalEnergyCounter(energypos)));
                            break;
                        }
                        if (!sensor.subaddress.startsWith("4:") && !sensor.subaddress.startsWith("5:") && !sensor.subaddress.startsWith("6:")) break;
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeTotalEnergyCounter(energypos)));
                        break;
                    }
                    case 20: {
                        buffer.append(Polling.hashLongToStringBuffer(DMX3.decodeEnergyPos(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(DMX3.decodeEnergyNeg(energyneg)));
                        break;
                    }
                    case 21: {
                        buffer.append(Polling.hashLongToStringBuffer(DPX3.decodeEnergyPos(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(DPX3.decodeEnergyNeg(energyneg)));
                        break;
                    }
                    case 39: 
                    case 40: {
                        if (sensor.subaddress.startsWith("0:")) {
                            buffer.append(Polling.hashLongToStringBuffer(EMDX3.decodeTotalM3Counter(energypos)));
                            break;
                        }
                        if (sensor.subaddress.startsWith("1:")) {
                            buffer.append(Polling.hashLongToStringBuffer(F4.decodeTotalM3Counter(energypos)));
                            break;
                        }
                        if (sensor.subaddress.startsWith("2:")) {
                            buffer.append(Polling.hashLongToStringBuffer(F4.decodeTotalM3Counter12(energypos)));
                            break;
                        }
                        if (sensor.subaddress.startsWith("3:")) {
                            buffer.append(Polling.hashLongToStringBuffer(EMS.decodeTotalM3Counter(energypos)));
                            break;
                        }
                        if (!sensor.subaddress.startsWith("4:") && !sensor.subaddress.startsWith("5:") && !sensor.subaddress.startsWith("6:")) break;
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeTotalM3Counter(energypos)));
                        break;
                    }
                    case 41: {
                        buffer.append(Polling.hashLongToStringBuffer(CONTREL.decodePartialEnergyPos(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(CONTREL.decodePartialEnergyNeg(energyneg)));
                        buffer.append(Polling.hashToStringBuffer(CONTREL.decodeAvgExt(avgext)));
                        buffer.append(Polling.hashToStringBuffer(CONTREL.decodeMaxBase(maxbase)));
                        break;
                    }
                    case 42: {
                        buffer.append(Polling.hashLongToStringBuffer(DX3.decodeEnergyPos(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(DX3.decodeEnergyNeg(energyneg)));
                        break;
                    }
                    case 43: {
                        buffer.append(Polling.hashLongToStringBuffer(GENERIC.decodeTotalEnergy(energypos)));
                        break;
                    }
                    case 44: 
                    case 92: {
                        buffer.append(Polling.hashLongToStringBuffer(F4.decodeEnergyPosN200(energypos, 100)));
                        buffer.append(Polling.hashLongToStringBuffer(F4.decodeEnergyNegN200(energyneg, 100)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeAvgExtN200(avgext, 100)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeMaxExtN200(maxext)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeMaxBaseN200(maxbase, 100)));
                        break;
                    }
                    case 45: 
                    case 46: 
                    case 93: {
                        buffer.append(Polling.hashLongToStringBuffer(F4.decodeEnergyPosN200(energypos, 10)));
                        buffer.append(Polling.hashLongToStringBuffer(F4.decodeEnergyNegN200(energyneg, 10)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeAvgExtN200(avgext, 10)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeMaxExtN200(maxext)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeMaxBaseN200(maxbase, 10)));
                        break;
                    }
                    case 48: 
                    case 49: {
                        buffer.append(Polling.hashLongToStringBuffer(ENTES.decodeEnergyPosMPR46S(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(ENTES.decodeEnergyNegMPR46S(energyneg)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeAvgExtMPR46S(avgext)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeMaxExtMPR46S(maxext)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeMaxBaseMPR46S(maxbase)));
                        break;
                    }
                    case 62: {
                        buffer.append(Polling.hashLongToStringBuffer(EMS.decodeEnergyPos(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(EMS.decodeEnergyNeg(energyneg)));
                        break;
                    }
                    case 63: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPos412068(energypos)));
                        break;
                    }
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        Hashtable<String, Integer[]> stepsvalues;
                        if (sensor.modelid == 126) {
                            buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeMaxExtX2(maxext)));
                            buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeMaxBaseX2(maxbase)));
                            stepsvalues = ALPTEC.decodeSteps82(steps);
                        } else if (sensor.modelid == 127) {
                            buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeMaxExt8(maxext)));
                            stepsvalues = ALPTEC.decodeSteps8(steps);
                        } else {
                            buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeMaxExtX2(maxext)));
                            buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeMaxBaseX2(maxbase)));
                            stepsvalues = ALPTEC.decodeSteps3252(steps);
                        }
                        Integer[] sr = stepsvalues.get("SR");
                        Integer[] sn = stepsvalues.get("SN");
                        Integer[] st = stepsvalues.get("ST");
                        int i2 = 0;
                        while (i2 < ALPTEC.getNumberOfStepsByModel(sensor.modelid)) {
                            buffer.append('R');
                            buffer.append(i2 + 1);
                            buffer.append('=');
                            buffer.append(sr[i2]);
                            buffer.append(' ');
                            buffer.append('N');
                            buffer.append(i2 + 1);
                            buffer.append('=');
                            buffer.append(sn[i2]);
                            buffer.append(' ');
                            buffer.append('T');
                            buffer.append(i2 + 1);
                            buffer.append('=');
                            buffer.append(st[i2]);
                            buffer.append(' ');
                            ++i2;
                        }
                        break;
                    }
                    case 136: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPosD4DC(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyNegD4DC(energyneg)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeAvgExtD4DC(avgext)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeMaxBaseD4DC(maxbase)));
                        break;
                    }
                    case 141: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPosCE2DF(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyNegCE2DF(energyneg)));
                        break;
                    }
                    case 145: 
                    case 152: {
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyPosCE4DF(energypos)));
                        buffer.append(Polling.hashLongToStringBuffer(IME.decodeEnergyNegCE4DF(energyneg)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeAvgExtCE4DF(avgext)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeMaxExtCE4DF(maxext)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeMaxBaseCE4DF(maxbase)));
                    }
                }
                log.append(sensor.gatewayname);
                log.append('/');
                log.append(sensor.address);
                if (sensor.subaddress != null && sensor.subaddress.length() > 0) {
                    log.append('/');
                    log.append(sensor.subaddress);
                }
                log.append("] -- ");
                if (buffer.length() > 0) {
                    log.append(buffer);
                    user.messageLog(log.toString());
                } else {
                    log.append("READ ERROR");
                    user.errorLog(log.toString());
                }
            }
        }
        catch (Exception e2) {
            user.errorLog("POLLING: STDATA WRITE ERROR [" + sensor.sensorid + "]");
            Polling.dataErrorAlert(true);
        }
        try {
            if (energypos != null) {
                bb.write(energypos);
            }
            if (energyneg != null) {
                bb.write(energyneg);
            }
            if (avgext != null) {
                bb.write(avgext);
            }
            if (maxext != null) {
                bb.write(maxext);
            }
            if (maxbase != null) {
                bb.write(maxbase);
            }
            if (thdstat != null) {
                bb.write(thdstat);
            }
            if (steps != null) {
                bb.write(steps);
            }
            PreparedStatement e2 = ststmt;
            synchronized (e2) {
                ststmt.setInt(1, sensor.sensorid);
                ststmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                ststmt.setInt(3, delta);
                ststmt.setBytes(4, bb.toByteArray());
                ststmt.execute();
            }
        }
        catch (Exception e3) {
            user.errorLog("POLLING: STDATA WRITE ERROR [" + sensor.sensorid + "]");
            Polling.dataErrorAlert(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void endataUpdate(int groupid, int loadid, short lyear, short lmonth, short lday, short lhour, short lmin, Timestamp ltime, long meter) throws Exception {
        PreparedStatement preparedStatement = eninsertstmt;
        synchronized (preparedStatement) {
            eninsertstmt.setInt(1, groupid);
            eninsertstmt.setInt(2, loadid);
            eninsertstmt.setShort(3, lyear);
            eninsertstmt.setShort(4, lmonth);
            eninsertstmt.setShort(5, lday);
            eninsertstmt.setShort(6, lhour);
            eninsertstmt.setShort(7, lmin);
            eninsertstmt.setTimestamp(8, ltime);
            eninsertstmt.setLong(9, meter);
            try {
                eninsertstmt.execute();
            }
            catch (SQLException e2) {
                if (e2.getSQLState().equals("23505")) {
                    enupdatestmt.setLong(1, meter);
                    enupdatestmt.setTimestamp(2, ltime);
                    enupdatestmt.setInt(3, groupid);
                    enupdatestmt.setInt(4, loadid);
                    enupdatestmt.setShort(5, lyear);
                    enupdatestmt.setShort(6, lmonth);
                    enupdatestmt.setShort(7, lday);
                    enupdatestmt.setShort(8, lhour);
                    enupdatestmt.setShort(9, lmin);
                    enupdatestmt.execute();
                }
                throw e2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensdataUpdate(SensorCache sensor, short lyear, short lmonth, short lday, short lhour, short lmin, Timestamp ltime, long meter) throws Exception {
        switch (sensor.loadid) {
            case -3: {
                PreparedStatement preparedStatement = enswinsertstmt;
                synchronized (preparedStatement) {
                    enswinsertstmt.setInt(1, sensor.sensorid);
                    enswinsertstmt.setShort(2, lyear);
                    enswinsertstmt.setShort(3, lmonth);
                    enswinsertstmt.setShort(4, lday);
                    enswinsertstmt.setShort(5, lhour);
                    enswinsertstmt.setShort(6, lmin);
                    enswinsertstmt.setTimestamp(7, ltime);
                    enswinsertstmt.setLong(8, meter);
                    try {
                        enswinsertstmt.execute();
                    }
                    catch (SQLException e2) {
                        if (e2.getSQLState().equals("23505")) {
                            enswupdatestmt.setLong(1, meter);
                            enswupdatestmt.setTimestamp(2, ltime);
                            enswupdatestmt.setInt(3, sensor.sensorid);
                            enswupdatestmt.setShort(4, lyear);
                            enswupdatestmt.setShort(5, lmonth);
                            enswupdatestmt.setShort(6, lday);
                            enswupdatestmt.setShort(7, lhour);
                            enswupdatestmt.setShort(8, lmin);
                            enswupdatestmt.execute();
                        }
                        throw e2;
                    }
                    break;
                }
            }
            case -4: {
                PreparedStatement preparedStatement = ensginsertstmt;
                synchronized (preparedStatement) {
                    ensginsertstmt.setInt(1, sensor.sensorid);
                    ensginsertstmt.setShort(2, lyear);
                    ensginsertstmt.setShort(3, lmonth);
                    ensginsertstmt.setShort(4, lday);
                    ensginsertstmt.setShort(5, lhour);
                    ensginsertstmt.setShort(6, lmin);
                    ensginsertstmt.setTimestamp(7, ltime);
                    ensginsertstmt.setLong(8, meter);
                    try {
                        ensginsertstmt.execute();
                    }
                    catch (SQLException e3) {
                        if (e3.getSQLState().equals("23505")) {
                            ensgupdatestmt.setLong(1, meter);
                            ensgupdatestmt.setTimestamp(2, ltime);
                            ensgupdatestmt.setInt(3, sensor.sensorid);
                            ensgupdatestmt.setShort(4, lyear);
                            ensgupdatestmt.setShort(5, lmonth);
                            ensgupdatestmt.setShort(6, lday);
                            ensgupdatestmt.setShort(7, lhour);
                            ensgupdatestmt.setShort(8, lmin);
                            ensgupdatestmt.execute();
                        }
                        throw e3;
                    }
                    break;
                }
            }
            default: {
                PreparedStatement preparedStatement = ensinsertstmt;
                synchronized (preparedStatement) {
                    ensinsertstmt.setInt(1, sensor.sensorid);
                    ensinsertstmt.setShort(2, lyear);
                    ensinsertstmt.setShort(3, lmonth);
                    ensinsertstmt.setShort(4, lday);
                    ensinsertstmt.setShort(5, lhour);
                    ensinsertstmt.setShort(6, lmin);
                    ensinsertstmt.setTimestamp(7, ltime);
                    ensinsertstmt.setLong(8, meter);
                    try {
                        ensinsertstmt.execute();
                    }
                    catch (SQLException e4) {
                        if (e4.getSQLState().equals("23505")) {
                            ensupdatestmt.setLong(1, meter);
                            ensupdatestmt.setTimestamp(2, ltime);
                            ensupdatestmt.setInt(3, sensor.sensorid);
                            ensupdatestmt.setShort(4, lyear);
                            ensupdatestmt.setShort(5, lmonth);
                            ensupdatestmt.setShort(6, lday);
                            ensupdatestmt.setShort(7, lhour);
                            ensupdatestmt.setShort(8, lmin);
                            ensupdatestmt.execute();
                        }
                        throw e4;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pfsdataUpdate(SensorCache sensor, short lyear, short lmonth, short lday, short lhour, short lmin, Timestamp ltime, long meter) throws Exception {
        PreparedStatement preparedStatement = pfsinsertstmt;
        synchronized (preparedStatement) {
            pfsinsertstmt.setInt(1, sensor.sensorid);
            pfsinsertstmt.setShort(2, lyear);
            pfsinsertstmt.setShort(3, lmonth);
            pfsinsertstmt.setShort(4, lday);
            pfsinsertstmt.setShort(5, lhour);
            pfsinsertstmt.setShort(6, lmin);
            pfsinsertstmt.setTimestamp(7, ltime);
            pfsinsertstmt.setLong(8, meter);
            try {
                pfsinsertstmt.execute();
            }
            catch (SQLException e2) {
                if (e2.getSQLState().equals("23505")) {
                    pfsupdatestmt.setLong(1, meter);
                    pfsupdatestmt.setTimestamp(2, ltime);
                    pfsupdatestmt.setInt(3, sensor.sensorid);
                    pfsupdatestmt.setShort(4, lyear);
                    pfsupdatestmt.setShort(5, lmonth);
                    pfsupdatestmt.setShort(6, lday);
                    pfsupdatestmt.setShort(7, lhour);
                    pfsupdatestmt.setShort(8, lmin);
                    pfsupdatestmt.execute();
                }
                throw e2;
            }
        }
    }

    private static short roundMinutes(short min) {
        return (short)(min / user.dataConsolidationIntervalMinutes * user.dataConsolidationIntervalMinutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void thdataSave(SensorCache sensor, byte[] thd) {
        try {
            PreparedStatement preparedStatement = thstmt;
            synchronized (preparedStatement) {
                thstmt.setInt(1, sensor.sensorid);
                thstmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                thstmt.setBytes(3, thd);
                thstmt.execute();
            }
            if (Configuration.eventsLog) {
                StringBuffer buffer = new StringBuffer();
                StringBuffer log = new StringBuffer("POLLING: LOGGER [");
                switch (sensor.modelid) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeTHD(thd)));
                        break;
                    }
                    case 21: {
                        buffer.append(Polling.hashToStringBuffer(DPX3.decodeTHD(thd)));
                        break;
                    }
                    case 41: {
                        buffer.append(Polling.hashToStringBuffer(CONTREL.decodeTHD(thd)));
                        break;
                    }
                    case 42: {
                        buffer.append(Polling.hashToStringBuffer(DX3.decodeTHD(thd)));
                        break;
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 92: 
                    case 93: {
                        buffer.append(Polling.hashToStringBuffer(F4.decodeTHDN200(thd)));
                        break;
                    }
                    case 48: 
                    case 49: {
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeTHDMPR46S(thd)));
                        break;
                    }
                    case 62: {
                        buffer.append(Polling.hashToStringBuffer(EMS.decodeTHD(thd)));
                        break;
                    }
                    case 124: 
                    case 125: 
                    case 126: {
                        buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeTHDX2(thd)));
                        break;
                    }
                    case 127: {
                        buffer.append(Polling.hashToStringBuffer(ALPTEC.decodeTHD8(thd)));
                        break;
                    }
                    case 152: {
                        buffer.append(Polling.hashToStringBuffer(IME.decodeTHDCE4DF(thd)));
                    }
                }
                log.append(sensor.gatewayname);
                log.append('/');
                log.append(sensor.address);
                log.append("] -- ");
                if (buffer.length() > 0) {
                    log.append(buffer);
                    user.messageLog(log.toString());
                } else {
                    log.append("READ ERROR");
                    user.errorLog(log.toString());
                }
            }
        }
        catch (Exception e2) {
            user.errorLog("POLLING: THDATA WRITE ERROR [" + sensor.sensorid + "]");
            Polling.dataErrorAlert(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void eqdataSave(SensorCache sensor, byte[] avgext, byte[] thd, byte[] hi, byte[] hu, byte[] hv) {
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        try {
            if (avgext != null) {
                bb.write(avgext);
            }
            if (thd != null) {
                bb.write(thd);
            }
            if (hi != null) {
                bb.write(hi);
            }
            if (hu != null) {
                bb.write(hu);
            }
            if (hv != null) {
                bb.write(hv);
            }
            PreparedStatement preparedStatement = eqstmt;
            synchronized (preparedStatement) {
                eqstmt.setInt(1, sensor.sensorid);
                eqstmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                eqstmt.setBytes(3, bb.toByteArray());
                switch (sensor.modelid) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        eqstmt.setBoolean(4, EMDX3.chechTHD(thd));
                        eqstmt.setBoolean(5, EMDX3.checkHarmonicU(hu));
                        break;
                    }
                    case 21: {
                        eqstmt.setBoolean(4, DPX3.chechTHD(thd));
                        eqstmt.setBoolean(5, false);
                        break;
                    }
                    case 41: {
                        eqstmt.setBoolean(4, false);
                        eqstmt.setBoolean(5, false);
                        break;
                    }
                    case 42: {
                        eqstmt.setBoolean(4, DX3.chechTHD(thd));
                        eqstmt.setBoolean(5, false);
                        break;
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 92: 
                    case 93: {
                        eqstmt.setBoolean(4, false);
                        eqstmt.setBoolean(5, false);
                        break;
                    }
                    case 48: 
                    case 49: {
                        eqstmt.setBoolean(4, ENTES.chechTHDMPR46S(thd));
                        eqstmt.setBoolean(5, false);
                        break;
                    }
                    case 62: {
                        eqstmt.setBoolean(4, EMS.chechTHD(thd));
                        eqstmt.setBoolean(5, false);
                        break;
                    }
                    case 152: {
                        eqstmt.setBoolean(4, IME.chechTHDCE4DF(thd));
                        eqstmt.setBoolean(5, false);
                    }
                }
                eqstmt.execute();
            }
            if (Configuration.eventsLog) {
                StringBuffer buffer = new StringBuffer();
                StringBuffer log = new StringBuffer("POLLING: LOGGER [");
                switch (sensor.modelid) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeAvgExt(avgext)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeTHD(thd)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeHarmonicI(hi)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeHarmonicU(hu)));
                        buffer.append(Polling.hashToStringBuffer(EMDX3.decodeHarmonicV(hv)));
                        break;
                    }
                    case 21: {
                        buffer.append(Polling.hashToStringBuffer(DPX3.decodeTHD(thd)));
                        break;
                    }
                    case 41: {
                        buffer.append(Polling.hashToStringBuffer(CONTREL.decodeAvgExt(avgext)));
                        buffer.append(Polling.hashToStringBuffer(CONTREL.decodeTHD(thd)));
                        break;
                    }
                    case 42: {
                        buffer.append(Polling.hashToStringBuffer(DX3.decodeTHD(thd)));
                        break;
                    }
                    case 44: 
                    case 45: 
                    case 46: {
                        buffer.append(Polling.hashToStringBuffer(F4.decodeAvgExtN200(avgext, sensor.modelid == 44 ? 100 : 10)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeTHDN200(thd)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeHarmonicIN200(hi)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeHarmonicVN200(hv)));
                        break;
                    }
                    case 92: 
                    case 93: {
                        buffer.append(Polling.hashToStringBuffer(F4.decodeAvgExtN200(avgext, sensor.modelid == 92 ? 100 : 10)));
                        buffer.append(Polling.hashToStringBuffer(F4.decodeTHDN200(thd)));
                        break;
                    }
                    case 48: {
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeAvgExtMPR46S(avgext)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeTHDMPR46S(thd)));
                        break;
                    }
                    case 49: {
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeAvgExtMPR46S(avgext)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeTHDMPR46S(thd)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeHarmonicIMPR47S(hi)));
                        buffer.append(Polling.hashToStringBuffer(ENTES.decodeHarmonicVMPR47S(hv)));
                        break;
                    }
                    case 62: {
                        buffer.append(Polling.hashToStringBuffer(EMS.decodeTHD(thd)));
                        break;
                    }
                    case 152: {
                        buffer.append(Polling.hashToStringBuffer(IME.decodeAvgExtCE4DF(avgext)));
                        buffer.append(Polling.hashToStringBuffer(IME.decodeTHDCE4DF(thd)));
                    }
                }
                log.append(sensor.gatewayname);
                log.append('/');
                log.append(sensor.address);
                log.append("] -- ");
                if (buffer.length() > 0) {
                    log.append(buffer);
                    user.messageLog(log.toString());
                } else {
                    log.append("READ ERROR");
                    user.errorLog(log.toString());
                }
            }
        }
        catch (Exception e2) {
            user.errorLog("POLLING: EQDATA WRITE ERROR  [" + sensor.sensorid + "]");
            Polling.dataErrorAlert(true);
        }
    }

    private static StringBuffer hashToStringBuffer(Hashtable<String, Integer> values) {
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            Enumeration<String> e2 = values.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                sb.append(k2);
                sb.append('=');
                sb.append(values.get(k2));
                sb.append(' ');
            }
        }
        return sb;
    }

    private static StringBuffer hashLongToStringBuffer(Hashtable<String, Long> values) {
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            Enumeration<String> e2 = values.keys();
            while (e2.hasMoreElements()) {
                String k2 = e2.nextElement();
                sb.append(k2);
                sb.append('=');
                sb.append(values.get(k2));
                sb.append(' ');
            }
        }
        return sb;
    }

    private static void gatewayTest(GatewayCache gateway) {
        try {
            Socket gwsock = new Socket();
            String[] aa = gateway.address.split("[:]");
            if (aa.length == 1) {
                gwsock.connect(new InetSocketAddress(gateway.address, 502), 3000);
            } else {
                gwsock.connect(new InetSocketAddress(aa[0], Integer.parseInt(aa[1])), 3000);
            }
            if (gwsock.isBound()) {
                gwsock.close();
                if (gateway.error != 0) {
                    gateway.error = 0;
                    user.uiSet("xerr.g" + gateway.gatewayid, "flag", "false");
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gateway.error != 1) {
            gateway.error = 1;
            user.uiSet("xerr.g" + gateway.gatewayid, "flag", "true");
        }
    }

    public static void sensorErrorFlag(SensorCache sensor, boolean error) {
        if (error) {
            if (sensor.error != 1) {
                sensor.error = 1;
                user.uiSet("xerr.s" + sensor.sensorid, "flag", "true");
                user.errorLog("POLLING: SENSOR ERROR [" + sensor.sensorid + "]");
            }
        } else if (sensor.error != 0) {
            sensor.error = 0;
            user.uiSet("xerr.s" + sensor.sensorid, "flag", "false");
            user.messageLog("POLLING: SENSOR OK [" + sensor.sensorid + "]");
        }
    }

    public static void checkPoint(boolean defrag) {
        long t = System.currentTimeMillis();
        if (!checkpointSemaphore) {
            checkpointSemaphore = true;
            try {
                if (defrag) {
                    PreparedStatement stmt = user.databaseConnection.prepareStatement("checkpoint defrag");
                    stmt.execute();
                    stmt.close();
                } else {
                    checkpoint.execute();
                }
            }
            catch (Exception e2) {
                user.errorLog("data logger error: CHECKPOINT");
                Polling.dataErrorAlert(true);
            }
            long dt = System.currentTimeMillis() - t;
            if (defrag) {
                user.messageLog("PROFILING: CHECKPOINTDEFRAG [" + dt + "]");
            } else if (dt >= 500L) {
                user.messageLog("PROFILING: CHECKPOINT [" + dt + "]");
            }
            checkpointSemaphore = false;
        }
    }

    public static void dataErrorAlert(boolean error) {
        user.dataErrorTimestamp = System.currentTimeMillis();
        user.uiSet("xerr.datalogger", "flag", error ? "true" : "false");
    }

    public static SensorCache searchSensorCache(String gatewayAddress, int sensorAddress) {
        try {
            Enumeration<Integer> e2 = sensorCache.keys();
            while (e2.hasMoreElements()) {
                Integer k2 = e2.nextElement();
                SensorCache sensor = sensorCache.get(k2);
                if (!sensor.gatewayaddress.equals(gatewayAddress) || sensor.address != sensorAddress) continue;
                return sensor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static GatewayCache searchGatewayCache(String gatewayAddress) {
        try {
            Enumeration<Integer> e2 = gatewayCache.keys();
            while (e2.hasMoreElements()) {
                Integer k2 = e2.nextElement();
                GatewayCache gateway = gatewayCache.get(k2);
                if (!gateway.address.equals(gatewayAddress)) continue;
                return gateway;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static SensorCache sensorGet(int sensorid) {
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select gatewayid, name, address, interfaceaddress, subaddress, scale, unit, modelid, loadid, group1id, group2id, group3id, group4id, group5id, enabled, nototals, noalerts, priority from sensors where sensorid = ?");
            pstmt.setInt(1, sensorid);
            ResultSet rs = pstmt.executeQuery();
            SensorCache sensor = rs.next() ? new SensorCache(sensorid, rs.getInt(1), null, null, rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getString(5), rs.getDouble(6), rs.getString(7), rs.getInt(8), rs.getInt(9), rs.getInt(10), rs.getInt(11), rs.getInt(12), rs.getInt(13), rs.getInt(14), rs.getBoolean(15), rs.getBoolean(16), rs.getBoolean(17), rs.getBoolean(18)) : null;
            rs.close();
            return sensor;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

