/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetSettings {
    private static final Executor exec = Executors.newCachedThreadPool();
    private static final int AP_POWERON_TIME_SECONDS = 600;
    private static final int ERROR_MESSAGES_TIMEOUT_SECONDS = 5;
    private static final String DEFAULT_AP_MODE = "power";
    private static final String RESOLV_FILE_NAME = "/etc/resolv.conf";
    private static final String INTERFACES_FILE_NAME = "/etc/network/interfaces";
    private static final String HOSTAPD_FILE_NAME = "/etc/hostapd/hostapd.conf";
    private static final String WS_NETSERVICE_FILE_NAME = "/etc/systemd/system/hsyco.wsnet.service";
    private static final String WS_NETSERVICE_SCRIPT_FILE_NAME = "/tmp/hsyco.wsnet.sh";
    private static String lanAddress = "";
    private static String lanMask = "";
    private static String lanRouter = "";
    private static String dns1 = "";
    private static String dns2 = "";
    private static boolean apEnabled = false;
    private static boolean apPowerModeActive = false;

    static void userSubmit(String session, String uid, HashMap<String, String> fields) {
        try {
            NetSettings.validateIPV4Address(fields.get("netsettings.lan.address"), false, false);
            NetSettings.validateIPV4Address(fields.get("netsettings.lan.mask"), false, true);
            NetSettings.validateIPV4Address(fields.get("netsettings.lan.router"), true, false);
            NetSettings.validateIPV4Address(fields.get("netsettings.dns1"), true, false);
            NetSettings.validateIPV4Address(fields.get("netsettings.dns2"), true, false);
        }
        catch (Exception e2) {
            user.uiSet("xerr.netsettings", "text", "lan_error");
            user.programTimerSet("netsettings.errors.off", 5);
            return;
        }
        try {
            if (!fields.get("netsettings.wifi.address").isEmpty()) {
                NetSettings.validateIPV4Address(fields.get("netsettings.wifi.address"), false, false);
                NetSettings.validateIPV4Address(fields.get("netsettings.wifi.mask"), false, true);
                NetSettings.validateIPV4Address(fields.get("netsettings.wifi.router"), true, false);
            }
            if (fields.get("netsettings.wifi.ssid").isEmpty() ^ fields.get("netsettings.wifi.key").isEmpty()) {
                throw new Exception();
            }
            if (!fields.get("netsettings.wifi.ssid").isEmpty() && fields.get("netsettings.wifi.dhcp").equals("false") && fields.get("netsettings.wifi.address").isEmpty()) {
                throw new Exception();
            }
        }
        catch (Exception e3) {
            user.uiSet("xerr.netsettings", "text", "wifi_error");
            user.programTimerSet("netsettings.errors.off", 5);
            return;
        }
        try {
            if (!fields.get("netsettings.ap.mode").equals("off") && (fields.get("netsettings.ap.ssid").isEmpty() || fields.get("netsettings.ap.key").isEmpty())) {
                throw new Exception();
            }
        }
        catch (Exception e4) {
            user.uiSet("xerr.netsettings", "text", "ap_error");
            user.programTimerSet("netsettings.errors.off", 5);
            return;
        }
        if (!"confirm".equals(user.uiGet("xerr.netsettings", "text"))) {
            user.uiSet("xerr.netsettings", "text", "confirm");
            return;
        }
        user.uiSet("xerr.netsettings", "text", "");
        lanAddress = fields.get("netsettings.lan.address");
        lanMask = fields.get("netsettings.lan.mask");
        lanRouter = fields.get("netsettings.lan.router");
        dns1 = fields.get("netsettings.dns1");
        dns2 = fields.get("netsettings.dns2");
        if (fields.get("netsettings.wifi.dhcp").equals("true")) {
            user.varSet("$netsettings.wifi.dhcp!", "true");
            user.varSet("$netsettings.wifi.address!", "");
            user.varSet("$netsettings.wifi.mask!", "");
            user.varSet("$netsettings.wifi.router!", "");
        } else {
            user.varSet("$netsettings.wifi.dhcp!", "false");
            user.varSet("$netsettings.wifi.address!", fields.get("netsettings.wifi.address"));
            user.varSet("$netsettings.wifi.mask!", fields.get("netsettings.wifi.mask"));
            user.varSet("$netsettings.wifi.router!", fields.get("netsettings.wifi.router"));
        }
        user.varSet("$netsettings.wifi.ssid!", fields.get("netsettings.wifi.ssid"));
        user.varSet("$netsettings.wifi.key!", fields.get("netsettings.wifi.key"));
        user.varSet("$netsettings.ap.mode!", fields.get("netsettings.ap.mode"));
        user.varSet("$netsettings.ap.ssid!", fields.get("netsettings.ap.ssid"));
        user.varSet("$netsettings.ap.key!", fields.get("netsettings.ap.key"));
        NetSettings.showConfiguration();
        Runnable task = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                    user.messageLog("NetSettings - commitConfiguration start");
                    NetSettings.commitConfiguration();
                    user.messageLog("NetSettings - commitConfiguration end");
                }
                catch (Exception e2) {
                    user.errorLog("NetSettings - Error in commitConfiguration thread: " + e2);
                }
            }
        };
        exec.execute(task);
    }

    static void programTimerOffEvent() {
        if (apEnabled && user.varGet("$netsettings.ap.mode!").equals(DEFAULT_AP_MODE)) {
            apPowerModeActive = false;
            NetSettings.commitConfiguration();
        }
    }

    static void programTimerErrorTimeoutEvent() {
        user.uiSet("xerr.netsettings", "text", "");
    }

    static void init(boolean WiFiSupport) {
        NetSettings.readInterfacesFile();
        String apmode = user.varGet("$netsettings.ap.mode!");
        if (apmode == null) {
            apmode = WiFiSupport ? DEFAULT_AP_MODE : "off";
            user.varSet("$netsettings.ap.mode!", DEFAULT_AP_MODE);
            user.varSet("$netsettings.wifi.dhcp!", "false");
            user.varSet("$netsettings.wifi.address!", "");
            user.varSet("$netsettings.wifi.mask!", "");
            user.varSet("$netsettings.wifi.router!", "");
            user.varSet("$netsettings.wifi.ssid!", "");
            user.varSet("$netsettings.wifi.key!", "");
            user.varSet("$netsettings.ap.ssid!", "wsmeasure");
            user.varSet("$netsettings.ap.key!", "wsmeasure");
        }
        if (apmode.equals(DEFAULT_AP_MODE)) {
            apPowerModeActive = true;
            user.programTimerSet("netsettings.ap.off", 600);
        }
        NetSettings.showConfiguration();
        NetSettings.commitConfiguration();
    }

    static void commitConfiguration() {
        String[] SYSTEMCTL_START_WS_NETSERVICE = new String[]{"systemctl", "restart", "hsyco.wsnet.service"};
        String[] SYSTEMCTL_DAEMON_RELOAD = new String[]{"systemctl", "daemon-reload"};
        boolean ap = apPowerModeActive && NetSettings.bootTime() < 600L;
        String wifiSsid = user.varGet("$netsettings.wifi.ssid!");
        boolean interfacesChanged = NetSettings.writeInterfacesFile(ap, false);
        boolean hostapdChanged = NetSettings.writeHostapdFile(false);
        if (interfacesChanged || hostapdChanged) {
            try {
                FileWriter fw = new FileWriter(WS_NETSERVICE_FILE_NAME);
                fw.write("[Unit]\n");
                fw.write("Description=WSMEASURE Network interfaces restart\n\n");
                fw.write("[Service]\n");
                fw.write("Type=oneshot\n");
                fw.write("ExecStart=/bin/sh /tmp/hsyco.wsnet.sh\n");
                fw.write("RemainAfterExit=yes\n");
                fw.close();
                fw = new FileWriter(WS_NETSERVICE_SCRIPT_FILE_NAME);
                fw.write("#!/bin/bash\n");
                fw.write("ip address flush eth0\n");
                fw.write("ip address flush wlan0\n");
                fw.write("ifdown --force eth0\n");
                fw.write("ifdown --force wlan0\n");
                fw.write("systemctl stop dnsmasq\n");
                fw.write("systemctl stop hostapd\n");
                fw.write("killall hostapd\n");
                fw.write("killall dhclient\n");
                fw.write("sleep 5\n");
                if (hostapdChanged) {
                    fw.write("mv /etc/hostapd/hostapd.conf~ /etc/hostapd/hostapd.conf\n");
                }
                if (interfacesChanged) {
                    fw.write("mv /etc/network/interfaces~ /etc/network/interfaces\n");
                }
                fw.write("ifup --force eth0\n");
                if (apEnabled) {
                    fw.write("ifup --force wlan0\n");
                    fw.write("sleep 1\n");
                    fw.write("systemctl enable dnsmasq\n");
                    fw.write("systemctl enable hostapd\n");
                    fw.write("systemctl start dnsmasq\n");
                    fw.write("systemctl start hostapd\n");
                } else {
                    fw.write("systemctl disable dnsmasq\n");
                    fw.write("systemctl disable hostapd\n");
                    if (wifiSsid.length() > 0) {
                        fw.write("ifup --force wlan0 &\n");
                        fw.write("sleep 1\n");
                        fw.write("wpa_cli -i wlan0 reassociate\n");
                    }
                }
                fw.close();
                NetSettings.exec(SYSTEMCTL_DAEMON_RELOAD);
                NetSettings.exec(SYSTEMCTL_START_WS_NETSERVICE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void showConfiguration() {
        user.uiSet("netsettings.lan.address", "value", lanAddress);
        user.uiSet("netsettings.lan.mask", "value", lanMask);
        user.uiSet("netsettings.lan.router", "value", lanRouter);
        user.uiSet("netsettings.dns1", "value", dns1);
        user.uiSet("netsettings.dns2", "value", dns2);
        user.uiSet("netsettings.wifi.dhcp", "value", user.varGet("$netsettings.wifi.dhcp!"));
        user.uiSet("netsettings.wifi.address", "value", user.varGet("$netsettings.wifi.address!"));
        user.uiSet("netsettings.wifi.mask", "value", user.varGet("$netsettings.wifi.mask!"));
        user.uiSet("netsettings.wifi.router", "value", user.varGet("$netsettings.wifi.router!"));
        user.uiSet("netsettings.wifi.ssid", "value", user.varGet("$netsettings.wifi.ssid!"));
        user.uiSet("netsettings.wifi.key", "value", user.varGet("$netsettings.wifi.key!"));
        user.uiSet("netsettings.ap.mode", "value", user.varGet("$netsettings.ap.mode!"));
        user.uiSet("netsettings.ap.ssid", "value", user.varGet("$netsettings.ap.ssid!"));
        user.uiSet("netsettings.ap.key", "value", user.varGet("$netsettings.ap.key!"));
    }

    private static boolean readInterfacesFile() {
        File interfacesFile = new File(INTERFACES_FILE_NAME);
        int ethid = -1;
        if (interfacesFile.canRead()) {
            try {
                String fl;
                BufferedReader fis = new BufferedReader(new FileReader(interfacesFile));
                while ((fl = fis.readLine()) != null) {
                    try {
                        String[] sa = fl.split("[ ]+");
                        if (sa[0].equals("iface") && sa[1].equals("eth0")) {
                            ethid = 0;
                        } else if (sa[0].equals("iface") && sa[1].equals("wlan0")) {
                            ethid = 1;
                        } else if (ethid == 0 && sa[0].equals("dns-nameservers")) {
                            InetAddress.getByName(sa[1]);
                            dns1 = new String(sa[1]);
                            InetAddress.getByName(sa[2]);
                            dns2 = new String(sa[2]);
                        }
                        if (ethid != 0) continue;
                        if (sa[0].equals("address")) {
                            InetAddress.getByName(sa[1]);
                            lanAddress = new String(sa[1]);
                            continue;
                        }
                        if (sa[0].equals("netmask")) {
                            InetAddress.getByName(sa[1]);
                            lanMask = new String(sa[1]);
                            continue;
                        }
                        if (!sa[0].equals("gateway")) continue;
                        InetAddress.getByName(sa[1]);
                        lanRouter = new String(sa[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                fis.close();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean writeInterfacesFile(boolean ap, boolean noop) {
        FileWriter fw;
        block19: {
            block18: {
                String wifiSsid = user.varGet("$netsettings.wifi.ssid!");
                String apSsid = user.varGet("$netsettings.ap.ssid!");
                String apMode = user.varGet("$netsettings.ap.mode!");
                try {
                    fw = new FileWriter("/etc/network/interfaces~");
                    fw.write("auto lo eth0");
                    fw.write("\niface lo inet loopback");
                    fw.write("\n\niface eth0 inet static");
                    fw.write("\naddress ");
                    fw.write(lanAddress);
                    fw.write("\nnetmask ");
                    fw.write(lanMask);
                    if (lanRouter.length() > 0) {
                        fw.write("\ngateway ");
                        fw.write(lanRouter);
                    }
                    if (dns1.length() > 0 || dns2.length() > 0) {
                        fw.write("\ndns-nameservers");
                        if (dns1.length() > 0) {
                            fw.write(" ");
                            fw.write(dns1);
                        }
                        if (dns2.length() > 0) {
                            fw.write(" ");
                            fw.write(dns2);
                        }
                    }
                    if (apSsid.length() > 0 && (apMode.equals("on") || ap && apMode.equals(DEFAULT_AP_MODE))) {
                        apEnabled = true;
                        fw.write("\n\nauto wlan0");
                        fw.write("\niface wlan0 inet static");
                        fw.write("\nhostapd /etc/hostapd/hostapd.conf");
                        fw.write("\naddress 192.168.200.1");
                        fw.write("\nnetmask 255.255.255.0");
                    } else if (wifiSsid.length() > 0) {
                        apEnabled = false;
                        fw.write("\n\nauto wlan0");
                        if (user.varGet("$netsettings.wifi.dhcp!").equals("true")) {
                            fw.write("\niface wlan0 inet dhcp");
                            fw.write("\nwpa-essid ");
                            fw.write(user.varGet("$netsettings.wifi.ssid!"));
                            fw.write("\nwpa-psk ");
                            fw.write(user.varGet("$netsettings.wifi.key!"));
                        } else {
                            fw.write("\niface wlan0 inet static");
                            fw.write("\naddress ");
                            fw.write(user.varGet("$netsettings.wifi.address!"));
                            fw.write("\nnetmask ");
                            fw.write(user.varGet("$netsettings.wifi.mask!"));
                            if (user.varGet("$netsettings.wifi.router!").length() > 0) {
                                fw.write("\ngateway ");
                                fw.write(user.varGet("$netsettings.wifi.router!"));
                            }
                            fw.write("\nwpa-essid ");
                            fw.write(user.varGet("$netsettings.wifi.ssid!"));
                            fw.write("\nwpa-psk ");
                            fw.write(user.varGet("$netsettings.wifi.key!"));
                        }
                    } else {
                        apEnabled = false;
                    }
                    fw.write("\n");
                    fw.close();
                    if (!NetSettings.compareFiles("/etc/network/interfaces~", INTERFACES_FILE_NAME)) break block18;
                    new File("/etc/network/interfaces~").delete();
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            if (!noop) break block19;
            return true;
        }
        if (new File("/etc/network/interfaces~").renameTo(new File(INTERFACES_FILE_NAME))) {
            fw = new FileWriter(RESOLV_FILE_NAME);
            fw.write("#Generated by ");
            fw.write(user.getUserVersion());
            fw.write("\n");
            if (dns1.length() > 0) {
                fw.write("\nnameserver ");
                fw.write(dns1);
            }
            if (dns2.length() > 0) {
                fw.write("\nnameserver ");
                fw.write(dns2);
            }
            fw.write("\n");
            fw.close();
            return true;
        }
        return false;
    }

    private static boolean writeHostapdFile(boolean noop) {
        block4: {
            block6: {
                block5: {
                    String apSsid = user.varGet("$netsettings.ap.ssid!");
                    String apKey = user.varGet("$netsettings.ap.key!");
                    try {
                        if (apSsid.length() <= 0 || apKey.length() <= 0) break block4;
                        FileWriter fw = new FileWriter("/etc/hostapd/hostapd.conf~");
                        fw.write("interface=wlan0\nlogger_syslog=-1\nlogger_syslog_level=2\nlogger_stdout=-1\nlogger_stdout_level=2\nctrl_interface=/var/run/hostapd\nctrl_interface_group=0");
                        fw.write("\nssid=");
                        fw.write(apSsid);
                        fw.write("\nhw_mode=g\nchannel=1\nbeacon_int=100\ndtim_period=2\nmax_num_sta=255\nrts_threshold=2347\nfragm_threshold=2346\nmacaddr_acl=0\nauth_algs=3\nignore_broadcast_ssid=0");
                        fw.write("\nwmm_enabled=1\nwmm_ac_bk_cwmin=4\nwmm_ac_bk_cwmax=10\nwmm_ac_bk_aifs=7\nwmm_ac_bk_txop_limit=0\nwmm_ac_bk_acm=0\nwmm_ac_be_aifs=3\nwmm_ac_be_cwmin=4\nwmm_ac_be_cwmax=10\nwmm_ac_be_txop_limit=0\nwmm_ac_be_acm=0");
                        fw.write("\nwmm_ac_vi_aifs=2\nwmm_ac_vi_cwmin=3\nwmm_ac_vi_cwmax=4\nwmm_ac_vi_txop_limit=94\nwmm_ac_vi_acm=0\nwmm_ac_vo_aifs=2\nwmm_ac_vo_cwmin=2\nwmm_ac_vo_cwmax=3\nwmm_ac_vo_txop_limit=47\nwmm_ac_vo_acm=0");
                        fw.write("\neapol_key_index_workaround=0\neap_server=0\nown_ip_addr=127.0.0.1\nwpa=2");
                        fw.write("\nwpa_passphrase=");
                        fw.write(apKey);
                        fw.write("\n");
                        fw.close();
                        if (!NetSettings.compareFiles("/etc/hostapd/hostapd.conf~", HOSTAPD_FILE_NAME)) break block5;
                        new File("/etc/hostapd/hostapd.conf~").delete();
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (!noop) break block6;
                return true;
            }
            return new File("/etc/hostapd/hostapd.conf~").renameTo(new File(HOSTAPD_FILE_NAME));
        }
        return false;
    }

    private static boolean compareFiles(String file1, String file2) {
        try {
            int b2;
            int b1;
            BufferedInputStream bin1 = new BufferedInputStream(new FileInputStream(file1));
            BufferedInputStream bin2 = new BufferedInputStream(new FileInputStream(file2));
            do {
                b1 = bin1.read();
                b2 = bin2.read();
            } while (b1 != -1 && b2 != -1 & b1 == b2);
            bin1.close();
            bin2.close();
            return b1 == -1 && b2 == -1;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static void exec(String[] cmd) {
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brerr.readLine() != null) {
            }
            while (brout.readLine() != null) {
            }
            proc.waitFor();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static long bootTime() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void validateIPV4Address(String addr, boolean emptyAllowed, boolean mask) throws Exception {
        if (emptyAllowed && (addr == null || addr.isEmpty())) {
            return;
        }
        String[] a2 = addr.split("[.]");
        int i2 = 0;
        while (i2 < 4) {
            int n2 = Integer.parseInt(a2[i2]);
            if (n2 < 0 || n2 > 255 || !mask && i2 == 0 && (n2 == 0 || n2 == 255)) {
                throw new Exception();
            }
            ++i2;
        }
    }
}

