/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.hsyco;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModbusGatewaySettings {
    private static Boolean modbusRTUEnabled = null;
    private static int speed;
    private static int stop;
    private static int parity;
    private static int timeout;
    private static boolean modbusTCPServerEnabled;

    static {
        modbusTCPServerEnabled = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isRTUEnabled() {
        if (modbusRTUEnabled != null) return modbusRTUEnabled;
        try {
            Properties ini = new Properties();
            FileInputStream inifis = new FileInputStream("hsyco.ini");
            ini.load(inifis);
            inifis.close();
            modbusRTUEnabled = "MODBUSRTU".equalsIgnoreCase(ini.getProperty("ioServersType.modbusgate"));
            if (modbusRTUEnabled.booleanValue()) {
                String s = ini.getProperty("CommPort.serial.Params");
                String[] sa = s.split(",");
                int v = Integer.parseInt(sa[0]);
                switch (v) {
                    case 1200: 
                    case 2400: 
                    case 4800: 
                    case 9600: 
                    case 19200: 
                    case 38400: 
                    case 57600: 
                    case 115200: {
                        speed = v;
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                v = Integer.parseInt(sa[1]);
                switch (v) {
                    case 8: {
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                v = Integer.parseInt(sa[2]);
                switch (v) {
                    case 1: 
                    case 2: {
                        stop = v;
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                v = Integer.parseInt(sa[3]);
                switch (v) {
                    case 0: 
                    case 1: 
                    case 2: {
                        parity = v;
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                if (Integer.parseInt(sa[4]) != 0) {
                    throw new Exception();
                }
                if (sa.length == 6) {
                    v = Integer.parseInt(sa[5]);
                    if (v < 0) throw new Exception();
                    timeout = v;
                } else {
                    timeout = 0;
                }
                s = ini.getProperty("ioServersOptions.modbusgate");
                if (s != null) {
                    sa = s.split(",");
                    int i2 = 0;
                    while (i2 < sa.length) {
                        if (sa[i2].trim().toLowerCase().startsWith("tcpmodbuseventunitid")) {
                            modbusTCPServerEnabled = true;
                            break;
                        }
                        ++i2;
                    }
                }
                user.newGateway(null, "127.0.0.1,Local,,on,-1,-1");
                return modbusRTUEnabled;
            } else {
                modbusTCPServerEnabled = "MODBUSTCPSERVER".equalsIgnoreCase(ini.getProperty("ioServersType.modbusgate"));
            }
            return modbusRTUEnabled;
        }
        catch (Exception e2) {
            modbusRTUEnabled = false;
            modbusTCPServerEnabled = false;
        }
        return modbusRTUEnabled;
    }

    static boolean setRTUParams(int speed, int stop, int parity, int timeout, boolean tcpserver) {
        if (modbusRTUEnabled.booleanValue()) {
            try {
                Properties ini = new Properties();
                FileInputStream inifis = new FileInputStream("hsyco.ini");
                ini.load(inifis);
                inifis.close();
                StringBuffer sb = new StringBuffer();
                if (speed != 1200 && speed != 2400 && speed != 4800 && speed != 9600 && speed != 19200 && speed != 38400 && speed != 57600 && speed != 115200) {
                    throw new Exception();
                }
                sb.append(speed);
                sb.append(',');
                sb.append(8);
                if (stop != 1 && stop != 2) {
                    throw new Exception();
                }
                sb.append(',');
                sb.append(stop);
                if (parity != 0 && parity != 1 && parity != 2) {
                    throw new Exception();
                }
                sb.append(',');
                sb.append(parity);
                sb.append(',');
                sb.append(0);
                if (timeout < 0) {
                    throw new Exception();
                }
                if (timeout > 0) {
                    sb.append(',');
                    sb.append(timeout);
                }
                ini.put("CommPort.serial.Params", sb.toString());
                if (tcpserver) {
                    ini.put("ioServersOptions.modbusgate", "frameinterval=50, tcpgatewayport=502, tcpmodbuseventunitid=247");
                } else {
                    ini.put("ioServersOptions.modbusgate", "frameinterval=50, tcpgatewayport=502, tcpgatewaywhitelist=127.0.0.1");
                }
                user.safePropertiesStore(ini, "hsyco.ini");
                ModbusGatewaySettings.speed = speed;
                ModbusGatewaySettings.stop = stop;
                ModbusGatewaySettings.parity = parity;
                ModbusGatewaySettings.timeout = timeout;
                modbusTCPServerEnabled = tcpserver;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    static boolean setTCPServer(boolean tcpserver) {
        block12: {
            block13: {
                ini = new Properties();
                inifis = new FileInputStream("hsyco.ini");
                ini.load(inifis);
                inifis.close();
                ioServersOriginal = ini.getProperty("ioServers").trim();
                if (!tcpserver) break block12;
                if (hsyco.ioLimitsReservationRequest() <= 0) break block13;
                if (ioServersOriginal != null && ioServersOriginal.length() > 0) {
                    found = false;
                    sa = ioServersOriginal.split(",");
                    i = 0;
                    while (i < sa.length) {
                        if (sa[i].trim().equalsIgnoreCase("modbusgate")) {
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        ini.put("ioServers", String.valueOf(ioServersOriginal) + ", modbusgate");
                    }
                } else {
                    ini.put("ioServers", "modbusgate");
                }
                ini.put("ioServersType.modbusgate", "MODBUSTCPSERVER");
                ** GOTO lbl49
            }
            return false;
        }
        try {
            if (ioServersOriginal != null) {
                sb = new StringBuffer();
                sa = ioServersOriginal.split(",");
                i = 0;
                while (i < sa.length) {
                    s = sa[i].trim();
                    if (!s.equalsIgnoreCase("modbusgate")) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(s);
                    }
                    ++i;
                }
                ini.put("ioServers", sb.toString());
                ini.remove("ioServersType.modbusgate");
            }
lbl49:
            // 4 sources

            user.safePropertiesStore(ini, "hsyco.ini");
            ModbusGatewaySettings.modbusTCPServerEnabled = tcpserver;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static void showConfiguration() {
        user.uiSet("xerr.modbussettings", "text", "");
        user.uiSet("modbussettings.tcpserver", "value", modbusTCPServerEnabled ? "1" : "0");
        if (modbusRTUEnabled.booleanValue()) {
            user.uiSet("modbussettings.speed", "value", Integer.toString(speed));
            user.uiSet("modbussettings.stop", "value", Integer.toString(stop));
            user.uiSet("modbussettings.parity", "value", Integer.toString(parity));
            user.uiSet("modbussettings.timeout", "value", timeout == 0 ? "" : Integer.toString(timeout));
        }
    }

    static void userSubmit(String session, String uid, HashMap<String, String> fields) {
        if (!"confirm".equals(user.uiGet("xerr.modbussettings", "text"))) {
            user.uiSet("xerr.modbussettings", "text", "confirm");
            return;
        }
        user.uiSet("xerr.modbussettings", "text", "");
        if (modbusRTUEnabled.booleanValue()) {
            int timeout;
            int speed = Integer.parseInt(fields.get("modbussettings.speed"));
            int stop = Integer.parseInt(fields.get("modbussettings.stop"));
            int parity = Integer.parseInt(fields.get("modbussettings.parity"));
            boolean tcpserver = "1".equals(fields.get("modbussettings.tcpserver"));
            try {
                timeout = Integer.parseInt(fields.get("modbussettings.timeout"));
            }
            catch (Exception e2) {
                timeout = 0;
            }
            if (!ModbusGatewaySettings.setRTUParams(speed, stop, parity, timeout, tcpserver)) {
                user.uiSet("xerr.modbussettings", "text", "error");
            }
        } else {
            boolean tcpserver = "1".equals(fields.get("modbussettings.tcpserver"));
            if (!ModbusGatewaySettings.setTCPServer(tcpserver)) {
                user.uiSet("xerr.modbussettings", "text", "error");
            }
        }
    }
}

