/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.nio.ByteBuffer;
import java.util.Hashtable;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M7TIC {
    public static boolean[] readDecodeDigitalInputsState(String gateway, int unitid) {
        boolean[] values = new boolean[24];
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4097, 2);
        if (data.length == 6) {
            int i2 = 0;
            while (i2 < 8) {
                values[i2] = (data[3] & 1 << i2) > 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                values[i2 + 8] = (data[2] & 1 << i2) > 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                values[i2 + 16] = (data[5] & 1 << i2) > 0;
                ++i2;
            }
            return values;
        }
        return null;
    }

    public static boolean[] readDecodeDigitalOutputsState(String gateway, int unitid) {
        boolean[] values = new boolean[6];
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 16385, 1);
        if (data.length == 4) {
            int i2 = 0;
            while (i2 < 6) {
                values[i2] = (data[3] & 1 << i2) > 0;
                ++i2;
            }
            return values;
        }
        return null;
    }

    public static int[] readDecodeAnalogInputsState(String gateway, int unitid) {
        int[] values = new int[4];
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 32769, 4);
        if (data.length == 10) {
            int i2 = 0;
            while (i2 < 4) {
                values[i2] = data[3 + i2 * 2] & 0xFF;
                ++i2;
            }
            return values;
        }
        return null;
    }

    public static byte[] readDigitalInputsConfiguration(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(48);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 12304, 16);
        bb.put(data, 2, 32);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 12320, 6);
        return bb.put(data, 2, 12).array();
    }

    public static byte[] readDigitalOutputsConfiguration(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 24592, 6);
        return bb.put(data, 2, 12).array();
    }

    public static Hashtable<String, String> displayIOState(String gateway, int unitid) {
        boolean[] digitalInputs = M7TIC.readDecodeDigitalInputsState(gateway, unitid);
        int[] analogInputs = M7TIC.readDecodeAnalogInputsState(gateway, unitid);
        boolean[] digitalOutputs = M7TIC.readDecodeDigitalOutputsState(gateway, unitid);
        byte[] digitalInputsComfiguration = M7TIC.readDigitalInputsConfiguration(gateway, unitid);
        byte[] digitalOutputsConfiguration = M7TIC.readDigitalOutputsConfiguration(gateway, unitid);
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            int i2 = 0;
            while (i2 < digitalInputs.length) {
                values.put("di" + (i2 + 1), digitalInputs[i2] ? "1" : "0");
                values.put("di" + (i2 + 1) + ".acth", (digitalInputsComfiguration[2 * i2 + 1] & 2) != 0 ? "1" : "0");
                ++i2;
            }
            i2 = 0;
            while (i2 < analogInputs.length) {
                values.put("ai" + (i2 + 1), Integer.toString(analogInputs[i2]));
                ++i2;
            }
            i2 = 0;
            while (i2 < digitalOutputs.length) {
                values.put("do" + (i2 + 1), digitalOutputs[i2] ? "1" : "0");
                values.put("do" + (i2 + 1) + ".nc", (digitalOutputsConfiguration[2 * i2] & 0x40) != 0 ? "1" : "0");
                values.put("do" + (i2 + 1) + ".blink", (digitalOutputsConfiguration[2 * i2] & 0x20) != 0 ? "1" : "0");
                values.put("do" + (i2 + 1) + ".time", Integer.toString((digitalOutputsConfiguration[2 * i2 + 1] & 0xFF) + ((digitalOutputsConfiguration[2 * i2] & 7) << 8)));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static Hashtable<String, String> displayPROGState(String gateway, int unitid) {
        boolean[] digitalOutputs = M7TIC.readDecodeDigitalOutputsState(gateway, unitid);
        byte[] digitalOutputsConfiguration = M7TIC.readDigitalOutputsConfiguration(gateway, unitid);
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            int i2 = 0;
            while (i2 < digitalOutputs.length) {
                if ((digitalOutputsConfiguration[2 * i2] & 0x40) != 0) {
                    values.put("do" + (i2 + 1), digitalOutputs[i2] ? "0" : "1");
                    values.put("do" + (i2 + 1) + ".nc", "1");
                } else {
                    values.put("do" + (i2 + 1), digitalOutputs[i2] ? "1" : "0");
                    values.put("do" + (i2 + 1) + ".nc", "0");
                }
                values.put("do" + (i2 + 1) + ".blink", (digitalOutputsConfiguration[2 * i2] & 0x20) != 0 ? "1" : "0");
                values.put("do" + (i2 + 1) + ".time", Integer.toString((digitalOutputsConfiguration[2 * i2 + 1] & 0xFF) + ((digitalOutputsConfiguration[2 * i2] & 7) << 8)));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean commandOutput(SensorCache sensor, int address) {
        boolean[] digitalOutputs = M7TIC.readDecodeDigitalOutputsState(sensor.gatewayaddress, sensor.address);
        try {
            switch (sensor.modelid) {
                case 90: {
                    byte[] digitalOutputsConfiguration = M7TIC.readDigitalOutputsConfiguration(sensor.gatewayaddress, sensor.address);
                    byte[] data = user.modbusWriteSingleCoil(sensor.gatewayaddress, sensor.address, address, !(digitalOutputs[address - 1] ^ (digitalOutputsConfiguration[2 * (address - 1)] & 0x40) != 0));
                    return data != null && data.length == 5;
                }
                case 91: {
                    byte[] data = user.modbusWriteSingleCoil(sensor.gatewayaddress, sensor.address, address, !digitalOutputs[address - 1]);
                    return data != null && data.length == 5;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean commandOutput(SensorCache sensor, int address, boolean value) {
        byte[] data = user.modbusWriteSingleCoil(sensor.gatewayaddress, sensor.address, address, value);
        return data != null && data.length == 5;
    }

    public static boolean commandInputConfiguration(SensorCache sensor, int address, boolean activehigh) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(activehigh ? 2 : 0);
        byte[] data = byArray;
        return (data = user.modbusWriteMultipleRegisters(sensor.gatewayaddress, sensor.address, 12303 + address, data)) != null && data.length == 5;
    }

    public static boolean commandOutputConfiguration(SensorCache sensor, int address, boolean nc, boolean blink, int time) {
        byte[] data = new byte[2];
        data[1] = (byte)(time & 0xFF);
        data[0] = (byte)(time >> 8 & 7);
        if (blink) {
            data[0] = (byte)(data[0] | 0x20);
        }
        if (nc) {
            data[0] = (byte)(data[0] | 0x40);
        }
        return (data = user.modbusWriteMultipleRegisters(sensor.gatewayaddress, sensor.address, 24591 + address, data)) != null && data.length == 5;
    }
}

