/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IME {
    private static final String[] PF_SECTOR_STRING = new String[]{"", " IND", " CAP"};

    public static byte[] readVIF467x(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(20);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8192, 10);
        return bb.put(data, 2, 20).array();
    }

    public static Hashtable<String, Integer> decodeVIF467x(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toLong(data, 0));
            values.put("I1", IME.toLong(data, 4));
            values.put("F", IME.toInteger(data, 18));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF467x(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toLongString(data, 0, 4, 3, false));
            values.put("I1", IME.toLongString(data, 4, 4, 3, false));
            values.put("F", IME.toIntegerString(data, 18, 4, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower467x(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(10);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8196, 3);
        bb.put(data, 2, 6);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 8199, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePower467x(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("P", (data[5] == 0 ? IME.toLong(data, 0) : -IME.toLong(data, 0)) / 1000);
            int i2 = IME.toInteger(data, 6);
            if (data[9] == 2) {
                i2 = -i2;
            }
            values.put("PF", 10 * i2);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower467x(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePower467x(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 2, true));
            values.put("PF", IME.toLongString(decoded.get("PF"), 4, 3, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos467x(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 8202, 2);
        return bb.put(data, 2, 4).array();
    }

    public static Hashtable<String, Long> decodeEnergyPos467x(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", (long)IME.toLong(data, 0) * 100L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos467x(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea", Long.toString((long)IME.toLong(data, 0) * 100L));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIF468x(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(42);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4096, 20);
        bb.put(data, 2, 40);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4134, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIF468x(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toLong(data, 0));
            values.put("V2", IME.toLong(data, 4));
            values.put("V3", IME.toLong(data, 8));
            values.put("I1", IME.toLong(data, 12));
            values.put("I2", IME.toLong(data, 16));
            values.put("I3", IME.toLong(data, 20));
            values.put("U12", IME.toLong(data, 28));
            values.put("U23", IME.toLong(data, 32));
            values.put("U31", IME.toLong(data, 36));
            values.put("F", IME.toInteger(data, 40));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF468x(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toLongString(data, 0, 4, 3, false));
            values.put("V2", IME.toLongString(data, 4, 4, 3, false));
            values.put("V3", IME.toLongString(data, 8, 4, 3, false));
            values.put("I1", IME.toLongString(data, 12, 4, 3, false));
            values.put("I2", IME.toLongString(data, 16, 4, 3, false));
            values.put("I3", IME.toLongString(data, 20, 4, 3, false));
            values.put("U12", IME.toLongString(data, 28, 4, 3, false));
            values.put("U23", IME.toLongString(data, 32, 4, 3, false));
            values.put("U31", IME.toLongString(data, 36, 4, 3, false));
            values.put("F", IME.toIntegerString(data, 40, 4, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIF4686(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(42);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4096, 20);
        bb.put(data, 2, 40);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4134, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIF4686(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toLong(data, 0));
            values.put("V2", IME.toLong(data, 4));
            values.put("V3", IME.toLong(data, 8));
            values.put("I1", IME.toLong(data, 12));
            values.put("I2", IME.toLong(data, 16));
            values.put("I3", IME.toLong(data, 20));
            values.put("In", IME.toLong(data, 24));
            values.put("U12", IME.toLong(data, 28));
            values.put("U23", IME.toLong(data, 32));
            values.put("U31", IME.toLong(data, 36));
            values.put("F", IME.toInteger(data, 40));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF4686(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toLongString(data, 0, 4, 3, false));
            values.put("V2", IME.toLongString(data, 4, 4, 3, false));
            values.put("V3", IME.toLongString(data, 8, 4, 3, false));
            values.put("I1", IME.toLongString(data, 12, 4, 3, false));
            values.put("I2", IME.toLongString(data, 16, 4, 3, false));
            values.put("I3", IME.toLongString(data, 20, 4, 3, false));
            values.put("In", IME.toLongString(data, 24, 4, 3, false));
            values.put("U12", IME.toLongString(data, 28, 4, 3, false));
            values.put("U23", IME.toLongString(data, 32, 4, 3, false));
            values.put("U31", IME.toLongString(data, 36, 4, 3, false));
            values.put("F", IME.toIntegerString(data, 40, 4, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower4686(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(60);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 256, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4116, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4132, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4140, 18);
        bb.put(data, 2, 36);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePower4686(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ktaktv = IME.toInteger(data, 0) * IME.toInteger(data, 2) / 10;
            int i2 = data[17] == 0 ? IME.toLong(data, 4) : -IME.toLong(data, 4);
            values.put("P", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = data[19] == 0 ? IME.toLong(data, 8) : -IME.toLong(data, 8);
            values.put("Q", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = IME.toLong(data, 12);
            values.put("S", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = IME.toInteger(data, 20);
            if (data[23] == 2) {
                i2 = -i2;
            }
            values.put("PF", 10 * i2);
            i2 = data[37] == 0 ? IME.toLong(data, 24) : -IME.toLong(data, 24);
            values.put("P1", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = data[39] == 0 ? IME.toLong(data, 28) : -IME.toLong(data, 28);
            values.put("P2", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = data[41] == 0 ? IME.toLong(data, 32) : -IME.toLong(data, 32);
            values.put("P3", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = data[55] == 0 ? IME.toLong(data, 42) : -IME.toLong(data, 42);
            values.put("Q1", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = data[57] == 0 ? IME.toLong(data, 46) : -IME.toLong(data, 46);
            values.put("Q2", i2 /= ktaktv < 6000L ? 1000 : 10);
            i2 = data[59] == 0 ? IME.toLong(data, 50) : -IME.toLong(data, 50);
            values.put("Q3", i2 /= ktaktv < 6000L ? 1000 : 10);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower4686(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePower4686(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 2, true));
            values.put("Q", IME.toLongString(decoded.get("Q"), 4, 2, true));
            values.put("S", IME.toLongString(decoded.get("S"), 4, 2, false));
            values.put("PF", IME.toLongString(decoded.get("PF"), 4, 3, true));
            values.put("P1", IME.toLongString(decoded.get("P1"), 4, 2, true));
            values.put("P2", IME.toLongString(decoded.get("P2"), 4, 2, true));
            values.put("P3", IME.toLongString(decoded.get("P3"), 4, 2, true));
            values.put("Q1", IME.toLongString(decoded.get("Q1"), 4, 2, true));
            values.put("Q2", IME.toLongString(decoded.get("Q2"), 4, 2, true));
            values.put("Q3", IME.toLongString(decoded.get("Q3"), 4, 2, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos4684(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 256, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4124, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPos468x(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            long ktaktv = IME.toInteger(data, 0) * IME.toInteger(data, 2) / 10;
            long i2 = (long)IME.toLong(data, 4) * 1000L;
            if (ktaktv < 10L) {
                i2 /= 100L;
            } else if (ktaktv < 100L) {
                i2 /= 10L;
            } else if (ktaktv < 1000L) {
                i2 /= 1L;
            } else if (ktaktv < 10000L) {
                i2 *= 10L;
            } else if (ktaktv < 100000L) {
                i2 *= 100L;
            } else if (ktaktv < 1000000L) {
                i2 *= 1000L;
            }
            values.put("Ea", i2);
            i2 = (long)IME.toLong(data, 8) * 1000L;
            if (ktaktv < 10L) {
                i2 /= 100L;
            } else if (ktaktv < 100L) {
                i2 /= 10L;
            } else if (ktaktv < 1000L) {
                i2 /= 1L;
            } else if (ktaktv < 10000L) {
                i2 *= 10L;
            } else if (ktaktv < 100000L) {
                i2 *= 100L;
            } else if (ktaktv < 1000000L) {
                i2 *= 1000L;
            }
            values.put("Er", i2);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos468x(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyPos468x(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExt4686(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 256, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4135, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeAvgExt4686(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ktaktv = IME.toInteger(data, 0) * IME.toInteger(data, 2) / 10;
            int i2 = IME.toLong(data, 4);
            values.put("avgP+", i2 /= ktaktv < 6000L ? 1000 : 10);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExt4686(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeAvgExt4686(data);
            values.put("avgP+", IME.toLongString(decoded.get("avgP+"), 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBase4686(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 256, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4137, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBase4686(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ktaktv = IME.toInteger(data, 0) * IME.toInteger(data, 2) / 10;
            int i2 = IME.toLong(data, 4);
            values.put("maxP+", i2 /= ktaktv < 6000L ? 1000 : 10);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBase4686(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeMaxBase4686(data);
            values.put("maxP+", IME.toLongString(decoded.get("maxP+"), 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower4680(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(56);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4116, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4132, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4140, 18);
        bb.put(data, 2, 36);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePower4680(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = data[13] == 0 ? IME.toLong(data, 0) : -IME.toLong(data, 0);
            values.put("P", i2 / 1000);
            i2 = data[15] == 0 ? IME.toLong(data, 4) : -IME.toLong(data, 4);
            values.put("Q", i2 / 1000);
            i2 = IME.toLong(data, 8);
            values.put("S", i2 / 1000);
            i2 = IME.toInteger(data, 16);
            if (data[19] == 2) {
                i2 = -i2;
            }
            values.put("PF", 10 * i2);
            i2 = data[33] == 0 ? IME.toLong(data, 20) : -IME.toLong(data, 20);
            values.put("P1", i2 / 1000);
            i2 = data[35] == 0 ? IME.toLong(data, 24) : -IME.toLong(data, 24);
            values.put("P2", i2 / 1000);
            i2 = data[37] == 0 ? IME.toLong(data, 28) : -IME.toLong(data, 28);
            values.put("P3", i2 / 1000);
            i2 = data[51] == 0 ? IME.toLong(data, 38) : -IME.toLong(data, 38);
            values.put("Q1", i2 / 1000);
            i2 = data[53] == 0 ? IME.toLong(data, 42) : -IME.toLong(data, 42);
            values.put("Q2", i2 / 1000);
            i2 = data[55] == 0 ? IME.toLong(data, 46) : -IME.toLong(data, 46);
            values.put("Q3", i2 / 1000);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower4680(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePower4680(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 2, true));
            values.put("Q", IME.toLongString(decoded.get("Q"), 4, 2, true));
            values.put("S", IME.toLongString(decoded.get("S"), 4, 2, false));
            values.put("PF", IME.toLongString(decoded.get("PF"), 4, 3, true));
            values.put("P1", IME.toLongString(decoded.get("P1"), 4, 2, true));
            values.put("P2", IME.toLongString(decoded.get("P2"), 4, 2, true));
            values.put("P3", IME.toLongString(decoded.get("P3"), 4, 2, true));
            values.put("Q1", IME.toLongString(decoded.get("Q1"), 4, 2, true));
            values.put("Q2", IME.toLongString(decoded.get("Q2"), 4, 2, true));
            values.put("Q3", IME.toLongString(decoded.get("Q3"), 4, 2, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower412074(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(68);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4116, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4132, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4140, 18);
        bb.put(data, 2, 36);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4164, 6);
        bb.put(data, 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePower412074(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = data[13] == 0 ? IME.toLong(data, 0) : -IME.toLong(data, 0);
            values.put("P", i2 / 1000);
            i2 = data[15] == 0 ? IME.toLong(data, 4) : -IME.toLong(data, 4);
            values.put("Q", i2 / 1000);
            i2 = IME.toLong(data, 8);
            values.put("S", i2 / 1000);
            i2 = IME.toInteger(data, 16);
            if (data[19] == 2) {
                i2 = -i2;
            }
            values.put("PF", 10 * i2);
            i2 = data[33] == 0 ? IME.toLong(data, 20) : -IME.toLong(data, 20);
            values.put("P1", i2 / 1000);
            i2 = data[35] == 0 ? IME.toLong(data, 24) : -IME.toLong(data, 24);
            values.put("P2", i2 / 1000);
            i2 = data[37] == 0 ? IME.toLong(data, 28) : -IME.toLong(data, 28);
            values.put("P3", i2 / 1000);
            i2 = data[51] == 0 ? IME.toLong(data, 38) : -IME.toLong(data, 38);
            values.put("Q1", i2 / 1000);
            i2 = data[53] == 0 ? IME.toLong(data, 42) : -IME.toLong(data, 42);
            values.put("Q2", i2 / 1000);
            i2 = data[55] == 0 ? IME.toLong(data, 46) : -IME.toLong(data, 46);
            values.put("Q3", i2 / 1000);
            int j2 = 1;
            while (j2 <= 3) {
                i2 = IME.toInteger(data, 54 + 2 * j2);
                if (data[19] == 2) {
                    i2 = -i2;
                }
                values.put("PF" + j2, 10 * i2);
                ++j2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower412074(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePower412074(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 2, true));
            values.put("Q", IME.toLongString(decoded.get("Q"), 4, 2, true));
            values.put("S", IME.toLongString(decoded.get("S"), 4, 2, false));
            values.put("PF", IME.toLongString(decoded.get("PF"), 4, 3, true));
            values.put("P1", IME.toLongString(decoded.get("P1"), 4, 2, true));
            values.put("P2", IME.toLongString(decoded.get("P2"), 4, 2, true));
            values.put("P3", IME.toLongString(decoded.get("P3"), 4, 2, true));
            values.put("Q1", IME.toLongString(decoded.get("Q1"), 4, 2, true));
            values.put("Q2", IME.toLongString(decoded.get("Q2"), 4, 2, true));
            values.put("Q3", IME.toLongString(decoded.get("Q3"), 4, 2, true));
            values.put("PF1", IME.toLongString(decoded.get("PF1"), 4, 3, true));
            values.put("PF2", IME.toLongString(decoded.get("PF2"), 4, 3, true));
            values.put("PF3", IME.toLongString(decoded.get("PF3"), 4, 3, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos4680(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4124, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPos4680(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int i2 = IME.toLong(data, 0);
            values.put("Ea", (long)i2 * 10L);
            i2 = IME.toLong(data, 4);
            values.put("Er", (long)i2 * 10L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos4680(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyPos4680(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos412074(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4240, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPos412074(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int i2 = IME.toLong(data, 0);
            values.put("Ea", (long)i2 * 10L);
            i2 = IME.toLong(data, 4);
            values.put("Er", (long)i2 * 10L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos412074(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyPos412074(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExt4680(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4135, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeAvgExt4680(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = IME.toLong(data, 0);
            values.put("avgP+", i2 / 1000);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExt4680(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeAvgExt4680(data);
            values.put("avgP+", IME.toLongString(decoded.get("avgP+"), 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBase4680(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4137, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBase4680(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = IME.toLong(data, 0);
            values.put("maxP+", i2 / 1000);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBase4680(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeMaxBase4680(data);
            values.put("maxP+", IME.toLongString(decoded.get("maxP+"), 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos4686(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 256, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4126, 4);
        bb.put(data, 6, 4);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static byte[] readVIF412068(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 0, 3);
        return bb.put(data, 2, 6).array();
    }

    public static Hashtable<String, Integer> decodeVIF412068(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toInteger(data, 0));
            values.put("I1", IME.toInteger(data, 2));
            values.put("F", IME.toInteger(data, 4));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF412068(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toIntegerString(data, 0, 4, 1, false));
            values.put("I1", IME.toIntegerString(data, 2, 4, 1, false));
            values.put("F", IME.toIntegerString(data, 4, 4, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower412068(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 3, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePower412068(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("P", IME.toInteger(data, 0));
            values.put("Q", IME.toInteger(data, 2));
            values.put("S", IME.toInteger(data, 4));
            values.put("PF", IME.toInteger(data, 6));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower412068(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("P", IME.toIntegerString(data, 0, 4, 3, false));
            values.put("Q", IME.toIntegerString(data, 2, 4, 3, false));
            values.put("S", IME.toIntegerString(data, 4, 4, 3, false));
            values.put("PF", IME.toIntegerString(data, 6, 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos412068(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 7, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 17, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPos412068(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", (long)IME.toLong(data, 0) * 10L);
            values.put("Er", (long)IME.toLong(data, 4) * 10L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos412068(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Hashtable<String, Long> decoded = IME.decodeEnergyPos412068(data);
        try {
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIFD4DC(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4096, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIFD4DC(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toLong(data, 0));
            values.put("I1", IME.toLong(data, 4));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIFD4DC(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toLongString(data, 0, 4, 3, false));
            values.put("I1", IME.toLongString(data, 4, 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPowerD4DC(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4609, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4100, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePowerD4DC(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long kta = IME.toInteger(data, 0);
            values.put("P", kta < 6000L ? IME.toLong(data, 2) / 100 : IME.toLong(data, 2));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPowerD4DC(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePowerD4DC(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 3, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPosD4DC(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4609, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4102, 2);
        return bb.put(data, 2, 4).array();
    }

    public static Hashtable<String, Long> decodeEnergyPosD4DC(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            long kta = IME.toInteger(data, 0);
            long scale = kta < 100L ? 10L : (kta < 1000L ? 100L : 1000L);
            values.put("Ea", (long)IME.toLong(data, 2) * scale);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPosD4DC(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyPosD4DC(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNegD4DC(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4609, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4104, 2);
        return bb.put(data, 2, 4).array();
    }

    public static Hashtable<String, Long> decodeEnergyNegD4DC(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            long kta = IME.toInteger(data, 0);
            long scale = kta < 100L ? 10L : (kta < 1000L ? 100L : 1000L);
            values.put("Ea-", (long)IME.toLong(data, 2) * scale);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNegD4DC(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyNegD4DC(data);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExtD4DC(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4609, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4108, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeAvgExtD4DC(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long kta = IME.toInteger(data, 0);
            values.put("avgP+", kta < 6000L ? IME.toLong(data, 2) / 100 : IME.toLong(data, 2));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExtD4DC(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeAvgExtD4DC(data);
            values.put("avgP+", IME.toLongString(decoded.get("avgP+"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBaseD4DC(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4609, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4110, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBaseD4DC(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long kta = IME.toInteger(data, 0);
            values.put("maxP+", kta < 6000L ? IME.toLong(data, 2) / 100 : IME.toLong(data, 2));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBaseD4DC(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeMaxBaseD4DC(data);
            values.put("maxP+", IME.toLongString(decoded.get("maxP+"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIFCE2DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(10);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20509, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20480, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20537, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIFCE2DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toLong(data, 0));
            values.put("I1", IME.toLong(data, 4));
            values.put("F", IME.toInteger(data, 8));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIFCE2DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toLongString(data, 0, 4, 3, false));
            values.put("I1", IME.toLongString(data, 4, 4, 3, false));
            values.put("F", IME.toIntegerString(data, 8, 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPowerCE2DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20551, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20557, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20569, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20581, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadInputRegisters(gateway, unitid, 20587, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePowerCE2DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("P", IME.toLong1Complement(data, 0) / 100);
            values.put("Q", IME.toLong1Complement(data, 4) / 100);
            values.put("S", IME.toLong(data, 8) / 100);
            values.put("PF", IME.toInteger1Complement(data, 12));
            values.put("PFSECTOR", Integer.valueOf(data[15]));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPowerCE2DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePowerCE2DF(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 3, true));
            values.put("Q", IME.toLongString(decoded.get("Q"), 4, 3, false));
            values.put("S", IME.toLongString(decoded.get("S"), 4, 3, false));
            values.put("PF", String.valueOf(IME.toLongString(decoded.get("PF"), 4, 3, true)) + PF_SECTOR_STRING[data[15]]);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPosCE2DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20592, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20598, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPosCE2DF(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        values.put("Ea", (long)IME.toLong(data, 0) * 10L);
        values.put("Er", (long)IME.toLong(data, 4) * 10L);
        return values;
    }

    public static Hashtable<String, String> displayEnergyPosCE2DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyPosCE2DF(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNegCE2DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20594, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20600, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyNegCE2DF(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        values.put("Ea-", (long)IME.toLong(data, 0) * 10L);
        values.put("Er-", (long)IME.toLong(data, 4) * 10L);
        return values;
    }

    public static Hashtable<String, String> displayEnergyNegCE2DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyNegCE2DF(data);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            values.put("Er-", Long.toString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIFCE4DF(String gateway, int unitid, boolean In) {
        if (In) {
            ByteBuffer bb = ByteBuffer.allocate(42);
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20509, 12);
            bb.put(data, 2, 24);
            data = user.modbusReadInputRegisters(gateway, unitid, 20480, 8);
            bb.put(data, 2, 16);
            data = user.modbusReadInputRegisters(gateway, unitid, 20537, 1);
            bb.put(data, 2, 2);
            return bb.array();
        }
        ByteBuffer bb = ByteBuffer.allocate(38);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20509, 12);
        bb.put(data, 2, 24);
        data = user.modbusReadInputRegisters(gateway, unitid, 20480, 6);
        bb.put(data, 2, 12);
        data = user.modbusReadInputRegisters(gateway, unitid, 20537, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIFCE4DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", IME.toLong(data, 0));
            values.put("V2", IME.toLong(data, 4));
            values.put("V3", IME.toLong(data, 8));
            values.put("U12", IME.toLong(data, 12));
            values.put("U23", IME.toLong(data, 16));
            values.put("U31", IME.toLong(data, 20));
            values.put("I1", IME.toLong(data, 24));
            values.put("I2", IME.toLong(data, 28));
            values.put("I3", IME.toLong(data, 32));
            if (data.length == 42) {
                values.put("In", IME.toLong(data, 36));
                values.put("F", IME.toInteger(data, 40));
            } else {
                values.put("F", IME.toInteger(data, 36));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIFCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", IME.toLongString(data, 0, 4, 3, false));
            values.put("V2", IME.toLongString(data, 4, 4, 3, false));
            values.put("V3", IME.toLongString(data, 8, 4, 3, false));
            values.put("U12", IME.toLongString(data, 12, 4, 3, false));
            values.put("U23", IME.toLongString(data, 16, 4, 3, false));
            values.put("U31", IME.toLongString(data, 20, 4, 3, false));
            values.put("I1", IME.toLongString(data, 24, 4, 3, false));
            values.put("I2", IME.toLongString(data, 28, 4, 3, false));
            values.put("I3", IME.toLongString(data, 32, 4, 3, false));
            if (data.length == 42) {
                values.put("In", IME.toLongString(data, 36, 4, 3, false));
                values.put("F", IME.toIntegerString(data, 40, 4, 2, false));
            } else {
                values.put("F", IME.toIntegerString(data, 36, 4, 2, false));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPowerCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(90);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20538, 37);
        bb.put(data, 2, 74);
        data = user.modbusReadInputRegisters(gateway, unitid, 20581, 3);
        bb.put(data, 2, 6);
        data = user.modbusReadInputRegisters(gateway, unitid, 20587, 3);
        bb.put(data, 2, 6);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20481, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20484, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePowerCE4DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            long ktaktv = IME.toInteger(data, 86) * IME.toInteger(data, 88) / 100;
            int scale = ktaktv < 5000L ? 1 : 1000;
            values.put("P", IME.toLong1Complement(data, 0) / 100 * scale);
            values.put("Q", IME.toLong1Complement(data, 4) / 100 * scale);
            values.put("S", IME.toLong(data, 12) / 100 * scale);
            values.put("PF", IME.toInteger1Complement(data, 20));
            values.put("PFSECTOR", Integer.valueOf(data[25]));
            values.put("P1", IME.toLong1Complement(data, 26) / 100 * scale);
            values.put("P2", IME.toLong1Complement(data, 30) / 100 * scale);
            values.put("P3", IME.toLong1Complement(data, 34) / 100 * scale);
            values.put("Q1", IME.toLong1Complement(data, 38) / 100 * scale);
            values.put("Q2", IME.toLong1Complement(data, 42) / 100 * scale);
            values.put("Q3", IME.toLong1Complement(data, 46) / 100 * scale);
            values.put("S1", IME.toLong(data, 62) / 100 * scale);
            values.put("S2", IME.toLong(data, 66) / 100 * scale);
            values.put("S3", IME.toLong(data, 70) / 100 * scale);
            values.put("PF1", IME.toInteger1Complement(data, 74));
            values.put("PF1SECTOR", Integer.valueOf(data[81]));
            values.put("PF2", IME.toInteger1Complement(data, 76));
            values.put("PF2SECTOR", Integer.valueOf(data[83]));
            values.put("PF3", IME.toInteger1Complement(data, 78));
            values.put("PF3SECTOR", Integer.valueOf(data[85]));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPowerCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodePowerCE4DF(data);
            values.put("P", IME.toLongString(decoded.get("P"), 4, 3, true));
            values.put("Q", IME.toLongString(decoded.get("Q"), 4, 3, true));
            values.put("S", IME.toLongString(decoded.get("S"), 4, 3, false));
            values.put("PF", String.valueOf(IME.toLongString(decoded.get("PF"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PFSECTOR")]);
            values.put("PF1", String.valueOf(IME.toLongString(decoded.get("PF1"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PF1SECTOR")]);
            values.put("PF2", String.valueOf(IME.toLongString(decoded.get("PF2"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PF2SECTOR")]);
            values.put("PF3", String.valueOf(IME.toLongString(decoded.get("PF3"), 4, 3, true)) + PF_SECTOR_STRING[decoded.get("PF3SECTOR")]);
            values.put("P1", IME.toLongString(decoded.get("P1"), 4, 3, true));
            values.put("P2", IME.toLongString(decoded.get("P2"), 4, 3, true));
            values.put("P3", IME.toLongString(decoded.get("P3"), 4, 3, true));
            values.put("Q1", IME.toLongString(decoded.get("Q1"), 4, 3, true));
            values.put("Q2", IME.toLongString(decoded.get("Q2"), 4, 3, true));
            values.put("Q3", IME.toLongString(decoded.get("Q3"), 4, 3, true));
            values.put("S1", IME.toLongString(decoded.get("S1"), 4, 3, false));
            values.put("S2", IME.toLongString(decoded.get("S2"), 4, 3, false));
            values.put("S3", IME.toLongString(decoded.get("S3"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHDCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(22);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 20480, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadInputRegisters(gateway, unitid, 20706, 10);
        bb.put(data, 2, 20);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeTHDCE4DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            if (data[0] == 51) {
                values.put("THDU12", IME.toInteger(data, 16));
                values.put("THDU23", IME.toInteger(data, 18));
                values.put("THDU31", IME.toInteger(data, 20));
            } else {
                values.put("THDV1", IME.toInteger(data, 10));
                values.put("THDV2", IME.toInteger(data, 12));
                values.put("THDV3", IME.toInteger(data, 14));
            }
            values.put("THDI1", IME.toInteger(data, 2));
            values.put("THDI2", IME.toInteger(data, 4));
            values.put("THDI3", IME.toInteger(data, 6));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHDCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeTHDCE4DF(data);
            Enumeration<String> keys = decoded.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                values.put(key, IME.toLongString(decoded.get(key), 4, 1, true));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean chechTHDCE4DF(byte[] data) {
        try {
            if (data[0] == 51) {
                return IME.toInteger(data, 16) >= 80 || IME.toInteger(data, 18) >= 80 || IME.toInteger(data, 20) >= 80;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readEnergyPosCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20592, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20598, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20481, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20484, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPosCE4DF(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        long ktaktv = IME.toInteger(data, 8) * IME.toInteger(data, 10) / 100;
        long scale = ktaktv < 10L ? 10L : (ktaktv < 100L ? 100L : (ktaktv < 1000L ? 1000L : (ktaktv < 10000L ? 10000L : (ktaktv < 100000L ? 100000L : 1000000L))));
        values.put("Ea", (long)IME.toLong1Complement(data, 0) * scale);
        values.put("Er", (long)IME.toLong1Complement(data, 4) * scale);
        return values;
    }

    public static Hashtable<String, String> displayEnergyPosCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyPosCE4DF(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNegCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20594, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadInputRegisters(gateway, unitid, 20600, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20481, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20484, 1);
        bb.put(data, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyNegCE4DF(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        long ktaktv = IME.toInteger(data, 8) * IME.toInteger(data, 10) / 100;
        long scale = ktaktv < 10L ? 10L : (ktaktv < 100L ? 100L : (ktaktv < 1000L ? 1000L : (ktaktv < 10000L ? 10000L : (ktaktv < 100000L ? 100000L : 1000000L))));
        values.put("Ea-", (long)IME.toLong1Complement(data, 0) * scale);
        values.put("Er-", (long)IME.toLong1Complement(data, 4) * scale);
        return values;
    }

    public static Hashtable<String, String> displayEnergyNegCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = IME.decodeEnergyNegCE4DF(data);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            values.put("Er-", Long.toString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBaseCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 20628, 6);
        bb.put(data, 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBaseCE4DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("maxI1", IME.toLong(data, 0));
            values.put("maxI2", IME.toLong(data, 4));
            values.put("maxI3", IME.toLong(data, 8));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBaseCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeMaxBaseCE4DF(data);
            Enumeration<String> keys = decoded.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                values.put(key, IME.toLongString(decoded.get(key), 4, 3, true));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxExtCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 20480, 1);
        bb.put(data, 2, 2);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 20614, 6);
        bb.put(data, 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxExtCE4DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            if (data[0] == 51) {
                values.put("maxU12", IME.toLong(data, 2));
                values.put("maxU23", IME.toLong(data, 6));
                values.put("maxU31", IME.toLong(data, 10));
            } else {
                values.put("maxV1", IME.toLong(data, 2));
                values.put("maxV2", IME.toLong(data, 6));
                values.put("maxV3", IME.toLong(data, 10));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxExtCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeMaxExtCE4DF(data);
            Enumeration<String> keys = decoded.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                values.put(key, IME.toLongString(decoded.get(key), 4, 3, true));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExtCE4DF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20498, 6);
        bb.put(data, 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeAvgExtCE4DF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("avgI1", IME.toLong(data, 0));
            values.put("avgI2", IME.toLong(data, 4));
            values.put("avgI3", IME.toLong(data, 8));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExtCE4DF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = IME.decodeAvgExtCE4DF(data);
            Enumeration<String> keys = decoded.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                values.put(key, IME.toLongString(decoded.get(key), 4, 3, true));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTotalCounter(String gateway, int unitid, String subaddress) {
        ByteBuffer bb = ByteBuffer.allocate(9);
        byte[] data = null;
        data = user.modbusReadHoldingRegisters(gateway, unitid, 4097, 1);
        if ((data[3] & 0x40) > 0 && (data = user.modbusReadHoldingRegisters(gateway, unitid, 29696, 4)).length == 10) {
            bb.put(data, 2, 8);
            bb.put((byte)4);
            return bb.array();
        }
        return null;
    }

    public static Hashtable<String, Long> decodeTotalEnergyCounter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int unit = IME.toInteger(data, 0);
            switch (unit) {
                case 0: {
                    values.put("Ea", (long)IME.toLong(data, 4) / 100L);
                    break;
                }
                case 1: {
                    values.put("Ea", (long)(IME.toLong(data, 4) / 100) * 1000L);
                    break;
                }
                case 2: {
                    values.put("Ea", (long)(IME.toLong(data, 4) / 100) * 1000000L);
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergyCounter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = IME.decodeTotalEnergyCounter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static Hashtable<String, Long> decodeTotalM3Counter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int unit = IME.toInteger(data, 0);
            switch (unit) {
                case 9: {
                    values.put("Ea", (long)IME.toLong(data, 4) * 10L);
                    break;
                }
                case 10: {
                    values.put("Ea", (long)IME.toLong(data, 4) * 10000L);
                    break;
                }
                case 11: {
                    values.put("Ea", (long)IME.toLong(data, 4) * 10000000L);
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalM3Counter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = IME.decodeTotalM3Counter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setProtocolTypeCExDF(String gateway, int unitid) {
        byte[] data = null;
        data = user.modbusReadHoldingRegisters(gateway, unitid, 0, 1);
        try {
            switch (data[3]) {
                case 0: {
                    return true;
                }
                case 1: {
                    data = new byte[2];
                    data = user.modbusWriteMultipleRegisters(gateway, unitid, 0, data);
                    if (data[0] != 16) return false;
                    if (data[4] != 1) return false;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static int toLong(byte[] data, int index) {
        return IME.decodeInteger(data, index, 4, false).intValue();
    }

    private static int toLong1Complement(byte[] data, int index) {
        if ((data[index] & 0x80) != 0) {
            byte[] a2 = Arrays.copyOf(data, data.length);
            a2[index] = (byte)(a2[index] & 0x7F);
            return -IME.decodeInteger(a2, index, 4, false).intValue();
        }
        return IME.decodeInteger(data, index, 4, false).intValue();
    }

    private static int toInteger(byte[] data, int index) {
        return IME.decodeInteger(data, index, 2, false).intValue();
    }

    private static int toInteger1Complement(byte[] data, int index) {
        if ((data[index] & 0x80) != 0) {
            byte[] a2 = Arrays.copyOf(data, data.length);
            a2[index] = (byte)(a2[index] & 0x7F);
            return -IME.decodeInteger(a2, index, 2, false).intValue();
        }
        return IME.decodeInteger(data, index, 2, false).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        long val = IME.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "";
        }
        return Long.toString(val);
    }

    private static String toLongString(byte[] data, int index, int digits, int decimals, boolean signed) {
        long val = IME.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static String toLongString(int val, int digits, int decimals, boolean signed) {
        if (signed && val == Integer.MAX_VALUE || !signed && val == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, boolean signed) {
        int val = IME.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

