/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.HsycoFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import plugins.wsmeasure.ALPTEC;
import plugins.wsmeasure.CONTREL;
import plugins.wsmeasure.CostRates;
import plugins.wsmeasure.DMX3;
import plugins.wsmeasure.DPX3;
import plugins.wsmeasure.DX3;
import plugins.wsmeasure.EMDX3;
import plugins.wsmeasure.EMS;
import plugins.wsmeasure.ENTES;
import plugins.wsmeasure.F4;
import plugins.wsmeasure.GENERIC;
import plugins.wsmeasure.GatewayCache;
import plugins.wsmeasure.IME;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.Task;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataProcessor {
    static final long T1 = (user.smallDisk ? 30L : 30L) * 86400000L;
    static final long T2 = (user.smallDisk ? 732L : 732L) * 86400000L;
    static final long T3 = (user.smallDisk ? 732L : 732L) * 86400000L;
    private static PreparedStatement taskselectstmt;
    private static PreparedStatement taskinsertstmt;
    private static PreparedStatement taskupdate2stmt;
    private static PreparedStatement stdataselect1stmt;
    private static PreparedStatement stdataselect2stmt;
    private static PreparedStatement thdataselect1stmt;
    private static PreparedStatement thdataselect2stmt;
    private static PreparedStatement eqdataselect1stmt;
    private static PreparedStatement eqdataselect2stmt;
    private static PreparedStatement eqcheckselectstmt;
    private static PreparedStatement endataselect1stmt;
    private static PreparedStatement endataselect2stmt;
    private static PreparedStatement endatawaterselect1stmt;
    private static PreparedStatement endatawaterselect2stmt;
    private static PreparedStatement endatagasselect1stmt;
    private static PreparedStatement endatagasselect2stmt;
    private static PreparedStatement endataallselect1stmt;
    private static PreparedStatement endataallselect2stmt;
    private static PreparedStatement ensdataselect1stmt;
    private static PreparedStatement ensdataselect2stmt;
    private static PreparedStatement ensdatawaterselect1stmt;
    private static PreparedStatement ensdatawaterselect2stmt;
    private static PreparedStatement ensdatagasselect1stmt;
    private static PreparedStatement ensdatagasselect2stmt;
    private static PreparedStatement cschargesselectstmt;
    private static PreparedStatement csstatselectstmt;
    private static PreparedStatement csstateselectstmt;

    public static void init() {
        try {
            taskselectstmt = user.databaseConnection.prepareStatement("select pointer, phase from tasks where taskid = ?");
            taskinsertstmt = user.databaseConnection.prepareStatement("insert into tasks (taskid, pointer, phase) values (?, ?, ?)");
            taskupdate2stmt = user.databaseConnection.prepareStatement("update tasks set pointer = ?, phase = ? where taskid = ?");
            stdataselect1stmt = user.databaseConnection.prepareStatement("select seq, ltime, raw from stdata where sensorid = ? order by seq limit 1000 using index");
            stdataselect2stmt = user.databaseConnection.prepareStatement("select seq, ltime, raw from stdata where sensorid = ? and seq > ? order by seq limit 1000 using index");
            thdataselect1stmt = user.databaseConnection.prepareStatement("select seq, ltime, raw from thdata where sensorid = ? order by seq limit 1000 using index");
            thdataselect2stmt = user.databaseConnection.prepareStatement("select seq, ltime, raw from thdata where sensorid = ? and seq > ? order by seq limit 1000 using index");
            eqdataselect1stmt = user.databaseConnection.prepareStatement("select seq, ltime, raw from eqdata where sensorid = ? order by seq limit 1000 using index");
            eqdataselect2stmt = user.databaseConnection.prepareStatement("select seq, ltime, raw from eqdata where sensorid = ? and seq > ? order by seq limit 1000 using index");
            eqcheckselectstmt = user.databaseConnection.prepareStatement("select seq, ltime, raw, thderror, herror from eqdata where sensorid = ? and ltime >= ? and ltime < ? order by seq limit 1000 using index");
            endataselect1stmt = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime <= localtimestamp and loadid >= -1 order by ltime limit 1000", 1004, 1007);
            endataselect2stmt = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime > ? and ltime <= localtimestamp and loadid >= -1 order by ltime limit 1000", 1004, 1007);
            endatawaterselect1stmt = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime <= localtimestamp and loadid = -3 order by ltime limit 1000", 1004, 1007);
            endatawaterselect2stmt = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime > ? and ltime <= localtimestamp and loadid = -3 order by ltime limit 1000", 1004, 1007);
            endatagasselect1stmt = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime <= localtimestamp and loadid = -4 order by ltime limit 1000", 1004, 1007);
            endatagasselect2stmt = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime > ? and ltime <= localtimestamp and loadid = -4 order by ltime limit 1000", 1004, 1007);
            endataallselect1stmt = user.databaseConnection.prepareStatement("select groupid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime <= localtimestamp and groupid <= -2 order by ltime limit 1000", 1004, 1007);
            endataallselect2stmt = user.databaseConnection.prepareStatement("select groupid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from endata where ltime > ? and ltime <= localtimestamp and groupid <= -2 order by ltime limit 1000", 1004, 1007);
            ensdataselect1stmt = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from ensdata where ltime <= localtimestamp order by ltime limit 1000", 1004, 1007);
            ensdataselect2stmt = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from ensdata where ltime > ? and ltime <= localtimestamp order by ltime limit 1000", 1004, 1007);
            ensdatawaterselect1stmt = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from ensdatawater where ltime <= localtimestamp order by ltime limit 1000", 1004, 1007);
            ensdatawaterselect2stmt = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from ensdatawater where ltime > ? and ltime <= localtimestamp order by ltime limit 1000", 1004, 1007);
            ensdatagasselect1stmt = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from ensdatagas where ltime <= localtimestamp order by ltime limit 1000", 1004, 1007);
            ensdatagasselect2stmt = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr from ensdatagas where ltime > ? and ltime <= localtimestamp order by ltime limit 1000", 1004, 1007);
            cschargesselectstmt = user.databaseConnection.prepareStatement("select seq, time, sensorid, side, plug, chargeid, userid, intime, outtime, avgcurrent, peakcurrent, chgtime, waittime, p3p, pmpf, phwer, phwenr, pevle, pevde, pevce, pevcpe, pevo, pdle, pdce, pdo, poe from cscharges where sensorid = ? and seq > ? order by seq limit 1000");
            csstatselectstmt = user.databaseConnection.prepareStatement("select seq, time, sensorid, totnumcharges, totavgcurrent, totpeakcurrent, totchgtime, totwaittime from csstat where sensorid = ? and seq > ? order by seq limit 1000 using index");
            csstateselectstmt = user.databaseConnection.prepareStatement("select seq, time, sensorid, plug, state, userid, \"CURRENT\", avgcurrent, peakcurrent, chgtime, waittime, p3p, pmpf, phwer, phwenr, pevle, pevde, pevce, pevcpe, pevo, pdle, pdce, pdo, poe from csstate where sensorid = ? and seq > ? order by seq limit 1000");
            DataProcessor.newDirs("userdata");
        }
        catch (Exception e2) {
            user.errorLog("DATA PROCESSOR FATAL ERROR - SYSTEM RESTARTING NOW");
            user.sleep(5000L);
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void settings() {
        Hashtable<Integer, String> racks = new Hashtable<Integer, String>();
        Hashtable<Integer, String> loads = new Hashtable<Integer, String>();
        Hashtable<Integer, String> groups = new Hashtable<Integer, String>();
        try {
            Object object = Polling.configurationSemaphore;
            synchronized (object) {
                int i2;
                StringBuffer sb;
                SensorCache sensor;
                int s;
                GatewayCache gateway;
                BufferedWriter fw;
                PreparedStatement pstmt = user.databaseConnection.prepareStatement("select rackid, name from racks");
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    racks.put(rs.getInt(1), rs.getString(2));
                }
                rs.close();
                pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    loads.put(rs.getInt(1), rs.getString(2));
                }
                rs.close();
                pstmt = user.databaseConnection.prepareStatement("select groupid, name from groups");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    groups.put(rs.getInt(1), rs.getString(2));
                }
                rs.close();
                String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis()));
                String pathname = "userdata/settings/";
                DataProcessor.newDirs(pathname);
                File file = new File(pathname, "energySettings.csv");
                if (file.exists()) {
                    fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
                } else {
                    fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
                    fw.write(new String(user.BOM, "UTF-8"));
                    if (user.csvFieldSep == ';') {
                        fw.write("Time;Device ID;Device P/N;Device Address;Gateway Address; Gateway Name; Panel Board; Load; Group 1; Group 2; Group 3; Group 4; Group 5; EQ Sensor; Supply\r\n");
                    } else {
                        fw.write("Time,Device ID,Device P/N,Device Address,Gateway Address, Gateway Name, Panel Board, Load, Group 1, Group 2, Group 3, Group 4, Group 5, EQ Sensor, Supply\r\n");
                    }
                }
                Enumeration<GatewayCache> e2 = Polling.gatewayCache.elements();
                while (e2.hasMoreElements()) {
                    gateway = e2.nextElement();
                    if (gateway.sensors == null) continue;
                    s = 0;
                    while (s < gateway.sensors.length) {
                        sensor = gateway.sensors[s];
                        if (!user.isGreenUpModel(sensor.modelid) && !user.isPFCModel(sensor.modelid)) {
                            sb = new StringBuffer();
                            sb.append(time);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.sensorid);
                            sb.append(user.csvFieldSep);
                            sb.append(user.Models.elementAt(sensor.modelid)[1]);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.address);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.gatewayaddress);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.gatewayname);
                            sb.append(user.csvFieldSep);
                            sb.append(racks.containsKey(gateway.rackid) ? (String)racks.get(gateway.rackid) : "");
                            sb.append(user.csvFieldSep);
                            if (sensor.loadid == -3) {
                                sb.append("Water");
                            } else if (sensor.loadid == -4) {
                                sb.append("Gas");
                            } else if (loads.containsKey(sensor.loadid)) {
                                sb.append(DataProcessor.filterLoadNames((String)loads.get(sensor.loadid), false));
                            } else {
                                sb.append("undefined");
                            }
                            i2 = 0;
                            while (i2 < 5) {
                                sb.append(user.csvFieldSep);
                                sb.append(groups.containsKey(sensor.groupid[i2]) ? (String)groups.get(sensor.groupid[i2]) : "");
                                ++i2;
                            }
                            sb.append(user.csvFieldSep);
                            sb.append(gateway.eqsensorid == sensor.sensorid ? "true" : "false");
                            sb.append(user.csvFieldSep);
                            if (sensor.subaddress != null && sensor.subaddress.endsWith("#inv")) {
                                sb.append("downstream");
                            }
                            sb.append("\r\n");
                            fw.write(sb.toString());
                        }
                        ++s;
                    }
                }
                fw.close();
                file.setWritable(true, false);
                file = new File(pathname, "GreenUpSettings.csv");
                if (file.exists()) {
                    fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
                } else {
                    fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
                    fw.write(new String(user.BOM, "UTF-8"));
                    if (user.csvFieldSep == ';') {
                        fw.write("Time;Device ID;Device P/N;Device Address;Gateway Address; Gateway Name; Panel Board; Phase; Group 1; Group 2; Group 3; Group 4; Group 5; EQ Sensor\r\n");
                    } else {
                        fw.write("Time,Device ID,Device P/N,Device Address,Gateway Address, Gateway Name, Panel Board, Phase, Group 1, Group 2, Group 3, Group 4, Group 5, EQ Sensor\r\n");
                    }
                }
                e2 = Polling.gatewayCache.elements();
                while (e2.hasMoreElements()) {
                    gateway = e2.nextElement();
                    if (gateway.sensors == null) continue;
                    s = 0;
                    while (s < gateway.sensors.length) {
                        sensor = gateway.sensors[s];
                        if (user.isGreenUpModel(sensor.modelid)) {
                            sb = new StringBuffer();
                            sb.append(time);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.sensorid);
                            sb.append(user.csvFieldSep);
                            sb.append(user.Models.elementAt(sensor.modelid)[1]);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.address);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.gatewayaddress);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.gatewayname);
                            sb.append(user.csvFieldSep);
                            sb.append(racks.containsKey(gateway.rackid) ? (String)racks.get(gateway.rackid) : "");
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.loadid == -1 ? 123 : sensor.loadid);
                            i2 = 0;
                            while (i2 < 5) {
                                sb.append(user.csvFieldSep);
                                sb.append(groups.containsKey(sensor.groupid[i2]) ? (String)groups.get(sensor.groupid[i2]) : "");
                                ++i2;
                            }
                            sb.append(user.csvFieldSep);
                            sb.append(gateway.eqsensorid == sensor.sensorid ? "true" : "false");
                            sb.append("\r\n");
                            fw.write(sb.toString());
                        }
                        ++s;
                    }
                }
                fw.close();
                file.setWritable(true, false);
                file = new File(pathname, "PFCSettings.csv");
                if (file.exists()) {
                    fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
                } else {
                    fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
                    fw.write(new String(user.BOM, "UTF-8"));
                    if (user.csvFieldSep == ';') {
                        fw.write("Time;Device ID;Device P/N;Device Address;Gateway Address; Gateway Name; Panel Board\r\n");
                    } else {
                        fw.write("Time,Device ID,Device P/N,Device Address,Gateway Address, Gateway Name, Panel Board\r\n");
                    }
                }
                e2 = Polling.gatewayCache.elements();
                while (e2.hasMoreElements()) {
                    gateway = e2.nextElement();
                    if (gateway.sensors == null) continue;
                    s = 0;
                    while (s < gateway.sensors.length) {
                        sensor = gateway.sensors[s];
                        if (user.isPFCModel(sensor.modelid)) {
                            sb = new StringBuffer();
                            sb.append(time);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.sensorid);
                            sb.append(user.csvFieldSep);
                            sb.append(user.Models.elementAt(sensor.modelid)[1]);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.address);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.gatewayaddress);
                            sb.append(user.csvFieldSep);
                            sb.append(sensor.gatewayname);
                            sb.append(user.csvFieldSep);
                            sb.append(racks.containsKey(gateway.rackid) ? (String)racks.get(gateway.rackid) : "");
                            sb.append("\r\n");
                            fw.write(sb.toString());
                        }
                        ++s;
                    }
                }
                fw.close();
                file.setWritable(true, false);
                file = new File(pathname, "general.csv");
                fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
                fw.write(new String(user.BOM, "UTF-8"));
                if (user.csvFieldSep == ';') {
                    fw.write("TEXT1;TEXT2;TEXT3;TEXT4;TEXT5;CABINET;COLUMN;PANEL;GATEWAY IP ADDRESS;COM PORT ID;BAUD;PARITY;MODE;DEVICE ADDR;DEVICE P/N;DEVICE ID;DEVICE DESCRIPTION;LINKED DEVICE P/N;LINKED DEVICE ID;LINKED DEVICE DESCRIPTION\r\n");
                } else {
                    fw.write("TEXT1,TEXT2,TEXT3,TEXT4,TEXT5,CABINET,COLUMN,PANEL,GATEWAY IP ADDRESS,COM PORT ID,BAUD,PARITY,MODE,DEVICE ADDR,DEVICE P/N,DEVICE ID,DEVICE DESCRIPTION,LINKED DEVICE P/N,LINKED DEVICE ID,LINKED DEVICE DESCRIPTION\r\n");
                }
                e2 = Polling.gatewayCache.elements();
                while (e2.hasMoreElements()) {
                    gateway = e2.nextElement();
                    if (gateway.sensors == null) continue;
                    s = 0;
                    while (s < gateway.sensors.length) {
                        sensor = gateway.sensors[s];
                        sb = new StringBuffer();
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(racks.containsKey(gateway.rackid) ? (String)racks.get(gateway.rackid) : "");
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(sensor.gatewayaddress);
                        sb.append(user.csvFieldSep);
                        sb.append('1');
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(sensor.address);
                        sb.append(user.csvFieldSep);
                        sb.append(user.Models.elementAt(sensor.modelid)[1]);
                        sb.append(user.csvFieldSep);
                        sb.append(sensor.name);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append("\r\n");
                        fw.write(sb.toString());
                        ++s;
                    }
                }
                fw.close();
                file.setWritable(true, false);
            }
        }
        catch (Exception e3) {
            user.errorLog("DATAPROCESSOR/SENSORSSETTINGS: GENERIC ERROR [" + e3 + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void devices() {
        SensorCache sensor = null;
        int seq = -1;
        long t = System.currentTimeMillis();
        try {
            Enumeration<Integer> e2 = Polling.gatewayCache.keys();
            while (e2.hasMoreElements()) {
                int gatewayid = e2.nextElement();
                GatewayCache gateway = Polling.gatewayCache.get(gatewayid);
                if (!gateway.enabled || gateway.sensors == null) continue;
                int i2 = 0;
                while (i2 < gateway.sensors.length) {
                    block50: {
                        sensor = gateway.sensors[i2];
                        try {
                            byte[] raw;
                            long ltime;
                            ResultSet rs;
                            PreparedStatement preparedStatement;
                            Task task;
                            if (!sensor.enabled) break block50;
                            if (user.isGreenUpModel(sensor.modelid)) {
                                task = DataProcessor.taskRead("cscharges." + sensor.sensorid);
                                preparedStatement = cschargesselectstmt;
                                synchronized (preparedStatement) {
                                    cschargesselectstmt.setInt(1, sensor.sensorid);
                                    cschargesselectstmt.setInt(2, task == null ? -1 : Integer.parseInt(task.pointer));
                                    rs = cschargesselectstmt.executeQuery();
                                }
                                seq = -1;
                                while (rs.next()) {
                                    seq = rs.getInt(1);
                                    DataProcessor.csChargesToFile(sensor.sensorid, rs);
                                }
                                if (seq != -1) {
                                    DataProcessor.taskWrite("cscharges." + sensor.sensorid, Integer.toString(seq), 0);
                                }
                                rs.close();
                                task = DataProcessor.taskRead("csstat." + sensor.sensorid);
                                preparedStatement = csstatselectstmt;
                                synchronized (preparedStatement) {
                                    csstatselectstmt.setInt(1, sensor.sensorid);
                                    csstatselectstmt.setInt(2, task == null ? -1 : Integer.parseInt(task.pointer));
                                    rs = csstatselectstmt.executeQuery();
                                }
                                seq = -1;
                                while (rs.next()) {
                                    seq = rs.getInt(1);
                                    DataProcessor.csStatToFile(sensor.sensorid, rs);
                                }
                                if (seq != -1) {
                                    DataProcessor.taskWrite("csstat." + sensor.sensorid, Integer.toString(seq), 0);
                                }
                                rs.close();
                                task = DataProcessor.taskRead("csstate." + sensor.sensorid);
                                preparedStatement = csstateselectstmt;
                                synchronized (preparedStatement) {
                                    csstateselectstmt.setInt(1, sensor.sensorid);
                                    csstateselectstmt.setInt(2, task == null ? -1 : Integer.parseInt(task.pointer));
                                    rs = csstateselectstmt.executeQuery();
                                }
                                seq = -1;
                                while (rs.next()) {
                                    seq = rs.getInt(1);
                                    DataProcessor.csStateToFile(sensor.sensorid, rs);
                                }
                                if (seq != -1) {
                                    DataProcessor.taskWrite("csstate." + sensor.sensorid, Integer.toString(seq), 0);
                                }
                                rs.close();
                                break block50;
                            }
                            task = DataProcessor.taskRead("stdata." + sensor.sensorid);
                            if (task == null) {
                                preparedStatement = stdataselect1stmt;
                                synchronized (preparedStatement) {
                                    stdataselect1stmt.setInt(1, sensor.sensorid);
                                    rs = stdataselect1stmt.executeQuery();
                                }
                            }
                            preparedStatement = stdataselect2stmt;
                            synchronized (preparedStatement) {
                                stdataselect2stmt.setInt(1, sensor.sensorid);
                                stdataselect2stmt.setInt(2, Integer.parseInt(task.pointer));
                                rs = stdataselect2stmt.executeQuery();
                            }
                            seq = -1;
                            while (rs.next()) {
                                seq = rs.getInt(1);
                                ltime = rs.getTimestamp(2).getTime();
                                raw = rs.getBytes(3);
                                DataProcessor.rawStDataToFile(sensor.sensorid, sensor.modelid, ltime, raw);
                            }
                            if (seq != -1) {
                                DataProcessor.taskWrite("stdata." + sensor.sensorid, Integer.toString(seq), 0);
                            }
                            rs.close();
                            if (gateway.eqsensorid == sensor.sensorid) {
                                task = DataProcessor.taskRead("eqdata." + sensor.sensorid);
                                if (task == null) {
                                    preparedStatement = eqdataselect1stmt;
                                    synchronized (preparedStatement) {
                                        eqdataselect1stmt.setInt(1, sensor.sensorid);
                                        rs = eqdataselect1stmt.executeQuery();
                                    }
                                }
                                preparedStatement = eqdataselect2stmt;
                                synchronized (preparedStatement) {
                                    eqdataselect2stmt.setInt(1, sensor.sensorid);
                                    eqdataselect2stmt.setInt(2, Integer.parseInt(task.pointer));
                                    rs = eqdataselect2stmt.executeQuery();
                                }
                                seq = -1;
                                while (rs.next()) {
                                    seq = rs.getInt(1);
                                    ltime = rs.getTimestamp(2).getTime();
                                    raw = rs.getBytes(3);
                                    DataProcessor.rawEqDataToFile(sensor.sensorid, sensor.modelid, ltime, raw);
                                }
                                if (seq != -1) {
                                    DataProcessor.taskWrite("eqdata." + sensor.sensorid, Integer.toString(seq), 0);
                                }
                                rs.close();
                                break block50;
                            }
                            task = DataProcessor.taskRead("thdata." + sensor.sensorid);
                            if (task == null) {
                                preparedStatement = thdataselect1stmt;
                                synchronized (preparedStatement) {
                                    thdataselect1stmt.setInt(1, sensor.sensorid);
                                    rs = thdataselect1stmt.executeQuery();
                                }
                            }
                            preparedStatement = thdataselect2stmt;
                            synchronized (preparedStatement) {
                                thdataselect2stmt.setInt(1, sensor.sensorid);
                                thdataselect2stmt.setInt(2, Integer.parseInt(task.pointer));
                                rs = thdataselect2stmt.executeQuery();
                            }
                            seq = -1;
                            while (rs.next()) {
                                seq = rs.getInt(1);
                                ltime = rs.getTimestamp(2).getTime();
                                raw = rs.getBytes(3);
                                DataProcessor.rawThDataToFile(sensor.sensorid, sensor.modelid, ltime, raw);
                            }
                            if (seq != -1) {
                                DataProcessor.taskWrite("thdata." + sensor.sensorid, Integer.toString(seq), 0);
                            }
                            rs.close();
                        }
                        catch (Exception es) {
                            user.errorLog("DATAPROCESSOR/DEVICES: GENERIC ERROR [" + es + "] SENSOR: " + sensor.sensorid);
                        }
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e3) {
            user.errorLog("DATAPROCESSOR/DEVICES: GENERIC ERROR [" + e3 + "] CANNOT CONTINUE");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/DEVICES [" + (System.currentTimeMillis() - t) + "]");
    }

    public static void energy() {
        DataProcessor.energyElectricity();
        DataProcessor.energyWater();
        DataProcessor.energyGas();
        DataProcessor.energyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void energyElectricity() {
        long meter;
        int lmin;
        int lhour;
        int lday;
        int lmonth;
        int lyear;
        int lastmin;
        int lasthour;
        int lastday;
        int lastmonth;
        int lastyear;
        PreparedStatement preparedStatement;
        long now;
        Task task;
        ResultSet rs;
        Vector<Integer> sensorids = new Vector<Integer>();
        Vector<String> sensornames = new Vector<String>();
        Vector<Integer> loadids = new Vector<Integer>();
        Vector<String> loadnames = new Vector<String>();
        Vector<Integer> groupids = new Vector<Integer>();
        Vector<String> groupnames = new Vector<String>();
        Hashtable<Integer, Long> sensorsenergy = new Hashtable<Integer, Long>();
        Hashtable<Integer, Long> groupsenergy = new Hashtable<Integer, Long>();
        Hashtable<Integer, Long> loadsenergy = new Hashtable<Integer, Long>();
        int pyear = 0;
        int pmonth = 0;
        int pday = 0;
        int phour = 0;
        int pmin = 0;
        int qyear = 0;
        int qmonth = 0;
        int qday = 0;
        int qhour = 0;
        int qmin = 0;
        long ltime = 0L;
        long ptime = 0L;
        long qtime = 0L;
        long t = System.currentTimeMillis();
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select sensorid, name, modelid from sensors where enabled = true and loadid >= -1");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (user.isGreenUpModel(rs.getInt(3))) continue;
                sensorids.add(rs.getInt(1));
                sensornames.add(String.valueOf(rs.getString(2)) + " [Wh]");
            }
            rs.close();
            pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads where enabled = true");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                loadids.add(rs.getInt(1));
                loadnames.add(String.valueOf(DataProcessor.filterLoadNames(rs.getString(2), false)) + " [Wh]");
            }
            loadids.add(-1);
            loadnames.add("Others");
            rs.close();
            pstmt = user.databaseConnection.prepareStatement("select groupid, name from groups where enabled = true");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupids.add(rs.getInt(1));
                groupnames.add(String.valueOf(rs.getString(2)) + " [Wh]");
            }
            rs.close();
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/ENERGY: GENERIC ERROR, STAGE 1 [" + e2 + "]");
        }
        try {
            task = DataProcessor.taskRead("ensdata");
            if (task == null) {
                rs = ensdataselect1stmt.executeQuery();
            } else {
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("ensdata", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/ENERGY: WARNING, ENSDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    preparedStatement = ensdataselect2stmt;
                    synchronized (preparedStatement) {
                        ensdataselect2stmt.setTimestamp(1, new Timestamp(Long.parseLong(task.pointer)));
                        rs = ensdataselect2stmt.executeQuery();
                    }
                }
            }
            if (rs != null && rs.last()) {
                lastyear = rs.getInt(2);
                lastmonth = rs.getInt(3);
                lastday = rs.getInt(4);
                lasthour = rs.getInt(5);
                lastmin = rs.getInt(6);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int sensorid = rs.getInt(1);
                    lyear = rs.getInt(2);
                    lmonth = rs.getInt(3);
                    lday = rs.getInt(4);
                    lhour = rs.getInt(5);
                    lmin = rs.getInt(6);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(7).getTime();
                    meter = rs.getLong(8);
                    if (!sensorids.contains(sensorid)) continue;
                    if (lyear == pyear && lmonth == pmonth && lday == pday && lhour == phour && lmin == pmin) {
                        sensorsenergy.put(sensorid, meter);
                        ptime = ltime;
                        continue;
                    }
                    if (sensorsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("energy", "devices", ptime, pyear, pmonth, pday, phour, pmin, sensorids, sensornames, sensorsenergy);
                    }
                    sensorsenergy.clear();
                    sensorsenergy.put(sensorid, meter);
                    pyear = lyear;
                    pmonth = lmonth;
                    pday = lday;
                    phour = lhour;
                    pmin = lmin;
                    ptime = ltime;
                }
            }
            if (sensorsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("energy", "devices", ptime, pyear, pmonth, pday, phour, pmin, sensorids, sensornames, sensorsenergy);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("ensdata", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e3) {
            user.errorLog("DATAPROCESSOR/ENERGY: GENERIC ERROR, STAGE 2 [" + e3 + "]");
        }
        try {
            task = DataProcessor.taskRead("endata");
            if (task == null) {
                rs = endataselect1stmt.executeQuery();
            } else {
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("endata", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/ENERGY: WARNING, ENDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    preparedStatement = endataselect2stmt;
                    synchronized (preparedStatement) {
                        endataselect2stmt.setTimestamp(1, new Timestamp(pointer));
                        rs = endataselect2stmt.executeQuery();
                    }
                }
            }
            pmin = 0;
            phour = 0;
            pday = 0;
            pmonth = 0;
            pyear = 0;
            ltime = 0;
            if (rs != null && rs.last()) {
                lastyear = rs.getInt(3);
                lastmonth = rs.getInt(4);
                lastday = rs.getInt(5);
                lasthour = rs.getInt(6);
                lastmin = rs.getInt(7);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int groupid = rs.getInt(1);
                    int loadid = rs.getInt(2);
                    lyear = rs.getInt(3);
                    lmonth = rs.getInt(4);
                    lday = rs.getInt(5);
                    lhour = rs.getInt(6);
                    lmin = rs.getInt(7);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(8).getTime();
                    meter = rs.getLong(9);
                    if (groupid == -2) {
                        if (!loadids.contains(loadid)) continue;
                        if (lyear == pyear && lmonth == pmonth && lday == pday && lhour == phour && lmin == pmin) {
                            loadsenergy.put(loadid, meter);
                            ptime = ltime;
                            continue;
                        }
                        if (loadsenergy.size() > 0) {
                            DataProcessor.rawEnergyToFile("energy", "loads", ptime, pyear, pmonth, pday, phour, pmin, loadids, loadnames, loadsenergy);
                        }
                        loadsenergy.clear();
                        loadsenergy.put(loadid, meter);
                        pyear = lyear;
                        pmonth = lmonth;
                        pday = lday;
                        phour = lhour;
                        pmin = lmin;
                        ptime = ltime;
                        continue;
                    }
                    if (!groupids.contains(groupid)) continue;
                    if (lyear == qyear && lmonth == qmonth && lday == qday && lhour == qhour && lmin == qmin) {
                        Long ge = groupsenergy.get(groupid);
                        groupsenergy.put(groupid, ge == null ? meter : meter + ge);
                        qtime = ltime;
                        continue;
                    }
                    if (groupsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("energy", "groups", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
                    }
                    groupsenergy.clear();
                    groupsenergy.put(groupid, meter);
                    qyear = lyear;
                    qmonth = lmonth;
                    qday = lday;
                    qhour = lhour;
                    qmin = lmin;
                    qtime = ltime;
                }
            }
            if (loadsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("energy", "loads", ptime, pyear, pmonth, pday, phour, pmin, loadids, loadnames, loadsenergy);
            }
            if (groupsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("energy", "groups", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("endata", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e4) {
            user.errorLog("DATAPROCESSOR/ENERGY: GENERIC ERROR, STAGE 3 [" + e4 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/ENERGYELECTRICITY [" + (System.currentTimeMillis() - t) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void energyWater() {
        long meter;
        int lmin;
        int lhour;
        int lday;
        int lmonth;
        int lyear;
        int lastmin;
        int lasthour;
        int lastday;
        int lastmonth;
        int lastyear;
        PreparedStatement preparedStatement;
        long now;
        Task task;
        ResultSet rs;
        Vector<Integer> sensorids = new Vector<Integer>();
        Vector<String> sensornames = new Vector<String>();
        Vector<Integer> groupids = new Vector<Integer>();
        Vector<String> groupnames = new Vector<String>();
        Hashtable<Integer, Long> sensorsenergy = new Hashtable<Integer, Long>();
        Hashtable<Integer, Long> groupsenergy = new Hashtable<Integer, Long>();
        int pyear = 0;
        int pmonth = 0;
        int pday = 0;
        int phour = 0;
        int pmin = 0;
        int qyear = 0;
        int qmonth = 0;
        int qday = 0;
        int qhour = 0;
        int qmin = 0;
        long ltime = 0L;
        long ptime = 0L;
        long qtime = 0L;
        long t = System.currentTimeMillis();
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select sensorid, name, modelid from sensors where enabled = true and loadid = -3");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (user.isGreenUpModel(rs.getInt(3))) continue;
                sensorids.add(rs.getInt(1));
                sensornames.add(String.valueOf(rs.getString(2)) + " [dm3]");
            }
            rs.close();
            pstmt = user.databaseConnection.prepareStatement("select groupid, name from groups where enabled = true");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupids.add(rs.getInt(1));
                groupnames.add(String.valueOf(rs.getString(2)) + " [dm3]");
            }
            rs.close();
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/WATER: GENERIC ERROR, STAGE 1 [" + e2 + "]");
        }
        try {
            task = DataProcessor.taskRead("ensdatawater");
            if (task == null) {
                rs = ensdatawaterselect1stmt.executeQuery();
            } else {
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("ensdatawater", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/WATER: WARNING, ENSDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    preparedStatement = ensdatawaterselect2stmt;
                    synchronized (preparedStatement) {
                        ensdatawaterselect2stmt.setTimestamp(1, new Timestamp(Long.parseLong(task.pointer)));
                        rs = ensdatawaterselect2stmt.executeQuery();
                    }
                }
            }
            if (rs != null && rs.last()) {
                lastyear = rs.getInt(2);
                lastmonth = rs.getInt(3);
                lastday = rs.getInt(4);
                lasthour = rs.getInt(5);
                lastmin = rs.getInt(6);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int sensorid = rs.getInt(1);
                    lyear = rs.getInt(2);
                    lmonth = rs.getInt(3);
                    lday = rs.getInt(4);
                    lhour = rs.getInt(5);
                    lmin = rs.getInt(6);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(7).getTime();
                    meter = rs.getLong(8);
                    if (!sensorids.contains(sensorid)) continue;
                    if (lyear == pyear && lmonth == pmonth && lday == pday && lhour == phour && lmin == pmin) {
                        sensorsenergy.put(sensorid, meter);
                        ptime = ltime;
                        continue;
                    }
                    if (sensorsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("water", "devices", ptime, pyear, pmonth, pday, phour, pmin, sensorids, sensornames, sensorsenergy);
                    }
                    sensorsenergy.clear();
                    sensorsenergy.put(sensorid, meter);
                    pyear = lyear;
                    pmonth = lmonth;
                    pday = lday;
                    phour = lhour;
                    pmin = lmin;
                    ptime = ltime;
                }
            }
            if (sensorsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("water", "devices", ptime, pyear, pmonth, pday, phour, pmin, sensorids, sensornames, sensorsenergy);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("ensdatawater", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e3) {
            user.errorLog("DATAPROCESSOR/WATER: GENERIC ERROR, STAGE 2 [" + e3 + "]");
        }
        try {
            task = DataProcessor.taskRead("endatawater");
            if (task == null) {
                rs = endatawaterselect1stmt.executeQuery();
            } else {
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("endatawater", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/WATER: WARNING, ENDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    preparedStatement = endatawaterselect2stmt;
                    synchronized (preparedStatement) {
                        endatawaterselect2stmt.setTimestamp(1, new Timestamp(pointer));
                        rs = endatawaterselect2stmt.executeQuery();
                    }
                }
            }
            pmin = 0;
            phour = 0;
            pday = 0;
            pmonth = 0;
            pyear = 0;
            ltime = 0;
            if (rs != null && rs.last()) {
                lastyear = rs.getInt(3);
                lastmonth = rs.getInt(4);
                lastday = rs.getInt(5);
                lasthour = rs.getInt(6);
                lastmin = rs.getInt(7);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int groupid = rs.getInt(1);
                    lyear = rs.getInt(3);
                    lmonth = rs.getInt(4);
                    lday = rs.getInt(5);
                    lhour = rs.getInt(6);
                    lmin = rs.getInt(7);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(8).getTime();
                    meter = rs.getLong(9);
                    if (!groupids.contains(groupid)) continue;
                    if (lyear == qyear && lmonth == qmonth && lday == qday && lhour == qhour && lmin == qmin) {
                        Long ge = groupsenergy.get(groupid);
                        groupsenergy.put(groupid, ge == null ? meter : meter + ge);
                        qtime = ltime;
                        continue;
                    }
                    if (groupsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("water", "groups", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
                    }
                    groupsenergy.clear();
                    groupsenergy.put(groupid, meter);
                    qyear = lyear;
                    qmonth = lmonth;
                    qday = lday;
                    qhour = lhour;
                    qmin = lmin;
                    qtime = ltime;
                }
            }
            if (groupsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("water", "groups", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("endatawater", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e4) {
            user.errorLog("DATAPROCESSOR/WATER: GENERIC ERROR, STAGE 3 [" + e4 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/ENERGYWATER [" + (System.currentTimeMillis() - t) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void energyGas() {
        long meter;
        int lmin;
        int lhour;
        int lday;
        int lmonth;
        int lyear;
        int lastmin;
        int lasthour;
        int lastday;
        int lastmonth;
        int lastyear;
        PreparedStatement preparedStatement;
        long now;
        Task task;
        ResultSet rs;
        Vector<Integer> sensorids = new Vector<Integer>();
        Vector<String> sensornames = new Vector<String>();
        Vector<Integer> groupids = new Vector<Integer>();
        Vector<String> groupnames = new Vector<String>();
        Hashtable<Integer, Long> sensorsenergy = new Hashtable<Integer, Long>();
        Hashtable<Integer, Long> groupsenergy = new Hashtable<Integer, Long>();
        int pyear = 0;
        int pmonth = 0;
        int pday = 0;
        int phour = 0;
        int pmin = 0;
        int qyear = 0;
        int qmonth = 0;
        int qday = 0;
        int qhour = 0;
        int qmin = 0;
        long ltime = 0L;
        long ptime = 0L;
        long qtime = 0L;
        long t = System.currentTimeMillis();
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select sensorid, name, modelid from sensors where enabled = true and loadid = -4");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (user.isGreenUpModel(rs.getInt(3))) continue;
                sensorids.add(rs.getInt(1));
                sensornames.add(String.valueOf(rs.getString(2)) + " [dm3]");
            }
            rs.close();
            pstmt = user.databaseConnection.prepareStatement("select groupid, name from groups where enabled = true");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupids.add(rs.getInt(1));
                groupnames.add(String.valueOf(rs.getString(2)) + " [dm3]");
            }
            rs.close();
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/GAS: GENERIC ERROR, STAGE 1 [" + e2 + "]");
        }
        try {
            task = DataProcessor.taskRead("ensdatagas");
            if (task == null) {
                rs = ensdatagasselect1stmt.executeQuery();
            } else {
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("ensdatagas", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/GAS: WARNING, ENSDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    preparedStatement = ensdatagasselect2stmt;
                    synchronized (preparedStatement) {
                        ensdatagasselect2stmt.setTimestamp(1, new Timestamp(Long.parseLong(task.pointer)));
                        rs = ensdatagasselect2stmt.executeQuery();
                    }
                }
            }
            if (rs != null && rs.last()) {
                lastyear = rs.getInt(2);
                lastmonth = rs.getInt(3);
                lastday = rs.getInt(4);
                lasthour = rs.getInt(5);
                lastmin = rs.getInt(6);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int sensorid = rs.getInt(1);
                    lyear = rs.getInt(2);
                    lmonth = rs.getInt(3);
                    lday = rs.getInt(4);
                    lhour = rs.getInt(5);
                    lmin = rs.getInt(6);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(7).getTime();
                    meter = rs.getLong(8);
                    if (!sensorids.contains(sensorid)) continue;
                    if (lyear == pyear && lmonth == pmonth && lday == pday && lhour == phour && lmin == pmin) {
                        sensorsenergy.put(sensorid, meter);
                        ptime = ltime;
                        continue;
                    }
                    if (sensorsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("gas", "devices", ptime, pyear, pmonth, pday, phour, pmin, sensorids, sensornames, sensorsenergy);
                    }
                    sensorsenergy.clear();
                    sensorsenergy.put(sensorid, meter);
                    pyear = lyear;
                    pmonth = lmonth;
                    pday = lday;
                    phour = lhour;
                    pmin = lmin;
                    ptime = ltime;
                }
            }
            if (sensorsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("gas", "devices", ptime, pyear, pmonth, pday, phour, pmin, sensorids, sensornames, sensorsenergy);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("ensdatagas", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e3) {
            user.errorLog("DATAPROCESSOR/GAS: GENERIC ERROR, STAGE 2 [" + e3 + "]");
        }
        try {
            task = DataProcessor.taskRead("endatagas");
            if (task == null) {
                rs = endatagasselect1stmt.executeQuery();
            } else {
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("endatagas", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/GAS: WARNING, ENDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    preparedStatement = endatagasselect2stmt;
                    synchronized (preparedStatement) {
                        endatagasselect2stmt.setTimestamp(1, new Timestamp(pointer));
                        rs = endatagasselect2stmt.executeQuery();
                    }
                }
            }
            pmin = 0;
            phour = 0;
            pday = 0;
            pmonth = 0;
            pyear = 0;
            ltime = 0;
            if (rs != null && rs.last()) {
                lastyear = rs.getInt(3);
                lastmonth = rs.getInt(4);
                lastday = rs.getInt(5);
                lasthour = rs.getInt(6);
                lastmin = rs.getInt(7);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int groupid = rs.getInt(1);
                    lyear = rs.getInt(3);
                    lmonth = rs.getInt(4);
                    lday = rs.getInt(5);
                    lhour = rs.getInt(6);
                    lmin = rs.getInt(7);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(8).getTime();
                    meter = rs.getLong(9);
                    if (!groupids.contains(groupid)) continue;
                    if (lyear == qyear && lmonth == qmonth && lday == qday && lhour == qhour && lmin == qmin) {
                        Long ge = groupsenergy.get(groupid);
                        groupsenergy.put(groupid, ge == null ? meter : meter + ge);
                        qtime = ltime;
                        continue;
                    }
                    if (groupsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("gas", "groups", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
                    }
                    groupsenergy.clear();
                    groupsenergy.put(groupid, meter);
                    qyear = lyear;
                    qmonth = lmonth;
                    qday = lday;
                    qhour = lhour;
                    qmin = lmin;
                    qtime = ltime;
                }
            }
            if (groupsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("gas", "groups", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("endatagas", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e4) {
            user.errorLog("DATAPROCESSOR/GAS: GENERIC ERROR, STAGE 3 [" + e4 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/ENERGYGAS [" + (System.currentTimeMillis() - t) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void energyAll() {
        Vector<Integer> groupids = new Vector<Integer>();
        Vector<String> groupnames = new Vector<String>();
        Vector<String> groupnamescost = new Vector<String>();
        Hashtable<Integer, Long> groupsenergy = new Hashtable<Integer, Long>();
        Hashtable<Integer, Long> groupscost = new Hashtable<Integer, Long>();
        int qyear = 0;
        int qmonth = 0;
        int qday = 0;
        int qhour = 0;
        int qmin = 0;
        long ltime = 0L;
        long qtime = 0L;
        String currency = user.varGet("energycurrency!");
        long t = System.currentTimeMillis();
        groupids.add(-2);
        groupnames.add("Electricity [Wh]");
        groupnamescost.add("Electricity [" + currency + "/100]");
        groupids.add(-3);
        groupnames.add("Water [dm3]");
        groupnamescost.add("Water [" + currency + "/100]");
        groupids.add(-4);
        groupnames.add("Gas [dm3]");
        groupnamescost.add("Gas [" + currency + "/100]");
        try {
            ResultSet rs;
            Task task = DataProcessor.taskRead("endataall");
            if (task == null) {
                rs = endataallselect1stmt.executeQuery();
            } else {
                long now;
                long pointer = Long.parseLong(task.pointer);
                if (pointer > (now = System.currentTimeMillis())) {
                    pointer = now;
                    DataProcessor.taskWrite("endataall", Long.toString(now), 0);
                    user.messageLog("DATAPROCESSOR/ALL: WARNING, ENDATA POINTER TIMESTAMP RESET TO CURRENT TIME");
                    rs = null;
                } else {
                    PreparedStatement preparedStatement = endataallselect2stmt;
                    synchronized (preparedStatement) {
                        endataallselect2stmt.setTimestamp(1, new Timestamp(pointer));
                        rs = endataallselect2stmt.executeQuery();
                    }
                }
            }
            ltime = 0L;
            if (rs != null && rs.last()) {
                int lastyear = rs.getInt(2);
                int lastmonth = rs.getInt(3);
                int lastday = rs.getInt(4);
                int lasthour = rs.getInt(5);
                int lastmin = rs.getInt(6);
                rs.beforeFirst();
                while (rs != null && rs.next()) {
                    int costratetype;
                    int groupid = rs.getInt(1);
                    int lyear = rs.getInt(2);
                    int lmonth = rs.getInt(3);
                    int lday = rs.getInt(4);
                    int lhour = rs.getInt(5);
                    int lmin = rs.getInt(6);
                    if (lyear == lastyear && lmonth == lastmonth && lday == lastday && lhour == lasthour && lmin == lastmin) break;
                    ltime = rs.getTimestamp(7).getTime();
                    long meter = rs.getLong(8);
                    switch (groupid) {
                        case -3: {
                            costratetype = 3;
                            break;
                        }
                        case -4: {
                            costratetype = 4;
                            break;
                        }
                        default: {
                            costratetype = 2;
                        }
                    }
                    if (!groupids.contains(groupid)) continue;
                    if (lyear == qyear && lmonth == qmonth && lday == qday && lhour == qhour && lmin == qmin) {
                        Long ge = groupsenergy.get(groupid);
                        long energy = ge == null ? meter : meter + ge;
                        long cost = CostRates.match(costratetype, -1, lyear, lmonth + 1, lday, lhour);
                        cost = cost <= 0L ? 0L : energy * cost;
                        groupsenergy.put(groupid, energy);
                        groupscost.put(groupid, cost);
                        qtime = ltime;
                        continue;
                    }
                    if (groupsenergy.size() > 0) {
                        DataProcessor.rawEnergyToFile("overallTotal", "overallTotalValues", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
                        int i2 = 0;
                        while (i2 < groupids.size()) {
                            int gid = groupids.elementAt(i2);
                            Long tc = groupscost.get(gid);
                            if (tc != null) {
                                groupscost.put(gid, tc / 1000000L);
                            }
                            ++i2;
                        }
                        DataProcessor.rawEnergyToFile("overallTotal", "overallTotalCosts", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnamescost, groupscost);
                    }
                    groupsenergy.clear();
                    groupscost.clear();
                    groupsenergy.put(groupid, meter);
                    long cost = CostRates.match(costratetype, -1, lyear, lmonth + 1, lday, lhour);
                    cost = cost <= 0L ? 0L : meter * cost;
                    groupscost.put(groupid, cost);
                    qyear = lyear;
                    qmonth = lmonth;
                    qday = lday;
                    qhour = lhour;
                    qmin = lmin;
                    qtime = ltime;
                }
            }
            if (groupsenergy.size() > 0) {
                DataProcessor.rawEnergyToFile("overallTotal", "overallTotalValues", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnames, groupsenergy);
                int i3 = 0;
                while (i3 < groupids.size()) {
                    int gid = groupids.elementAt(i3);
                    Long tc = (Long)groupscost.get(gid);
                    if (tc != null) {
                        groupscost.put(gid, tc / 1000000L);
                    }
                    ++i3;
                }
                DataProcessor.rawEnergyToFile("overallTotal", "overallTotalCosts", qtime, qyear, qmonth, qday, qhour, qmin, groupids, groupnamescost, groupscost);
            }
            if (ltime > 0L) {
                DataProcessor.taskWrite("endataall", Long.toString(ltime), 0);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/ALL: GENERIC ERROR [" + e2 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/ENERGYALL [" + (System.currentTimeMillis() - t) + "]");
    }

    public static void eq() {
        long t = System.currentTimeMillis();
        try {
            Task task = DataProcessor.taskRead("eqcheck");
            if (task == null) {
                Calendar start = Calendar.getInstance();
                if (start.get(7) == 1) {
                    start.add(5, -6);
                } else {
                    start.add(5, 2 - start.get(7));
                }
                start.set(11, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                DataProcessor.taskWrite("eqcheck", Long.toString(start.getTimeInMillis()), 0);
            } else {
                Calendar now7 = Calendar.getInstance();
                now7.add(5, -7);
                Calendar start = Calendar.getInstance();
                start.setTimeInMillis(Long.parseLong(task.pointer));
                while (start.compareTo(now7) <= 0) {
                    DataProcessor.eqWeek(start);
                    start.add(5, 7);
                    start.set(11, 0);
                    start.set(12, 0);
                    start.set(13, 0);
                    start.set(14, 0);
                    DataProcessor.taskWrite("eqcheck", Long.toString(start.getTimeInMillis()), 0);
                }
            }
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/EQ: GENERIC ERROR, STAGE 1 [" + e2 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/EQ [" + (System.currentTimeMillis() - t) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eqWeek(Calendar start) {
        Vector<Integer> sensorids = new Vector<Integer>();
        Vector<String> sensornames = new Vector<String>();
        Vector<String> sensorvalues = new Vector<String>();
        int[][] hubuffer = new int[12][3];
        try {
            Calendar end = (Calendar)start.clone();
            end.add(5, 7);
            Enumeration<Integer> e2 = Polling.gatewayCache.keys();
            while (e2.hasMoreElements()) {
                ResultSet rs;
                int gatewayid = e2.nextElement();
                GatewayCache gateway = Polling.gatewayCache.get(gatewayid);
                SensorCache sensor = Polling.sensorCache.get(gateway.eqsensorid);
                if (sensor == null) continue;
                sensorids.add(sensor.sensorid);
                sensornames.add(sensor.name);
                PreparedStatement preparedStatement = eqcheckselectstmt;
                synchronized (preparedStatement) {
                    eqcheckselectstmt.setInt(1, sensor.sensorid);
                    eqcheckselectstmt.setTimestamp(2, new Timestamp(start.getTimeInMillis()));
                    eqcheckselectstmt.setTimestamp(3, new Timestamp(end.getTimeInMillis()));
                    rs = eqcheckselectstmt.executeQuery();
                }
                int thdkocounter = 0;
                int thdokcounter = 0;
                int hukocounter = 0;
                int huokcounter = 0;
                int i2 = 0;
                while (i2 < 12) {
                    hubuffer[i2][2] = 0;
                    hubuffer[i2][1] = 0;
                    hubuffer[i2][0] = 0;
                    ++i2;
                }
                int hucounter = 0;
                int tenminutes = 0;
                block10: while (rs.next()) {
                    int i3;
                    if (rs.getBoolean(4)) {
                        ++thdkocounter;
                    } else {
                        ++thdokcounter;
                    }
                    byte[] raw = rs.getBytes(3);
                    Calendar stime = Calendar.getInstance();
                    stime.setTimeInMillis(rs.getTimestamp(2).getTime());
                    int ctm = stime.get(1) * 100000 + stime.get(3) * 1000 + stime.get(11) * 10 + stime.get(12) / 10;
                    if (tenminutes == 0) {
                        tenminutes = ctm;
                    }
                    if (ctm == tenminutes) {
                        switch (sensor.modelid) {
                            case 2: 
                            case 3: {
                                if (raw.length != 324) continue block10;
                                i3 = 0;
                                while (i3 < 12) {
                                    int[] nArray = hubuffer[i3];
                                    nArray[0] = nArray[0] + EMDX3.toInteger(raw, 180 + 6 * i3);
                                    int[] nArray2 = hubuffer[i3];
                                    nArray2[1] = nArray2[1] + EMDX3.toInteger(raw, 182 + 6 * i3);
                                    int[] nArray3 = hubuffer[i3];
                                    nArray3[2] = nArray3[2] + EMDX3.toInteger(raw, 184 + 6 * i3);
                                    ++i3;
                                }
                                ++hucounter;
                            }
                        }
                        continue;
                    }
                    if (hucounter >= 10) {
                        boolean sampleerror = false;
                        int i4 = 0;
                        while (i4 < 12) {
                            if (hubuffer[i4][0] / hucounter >= EMDX3.EN50160LIMITS[i4] || hubuffer[i4][1] / hucounter >= EMDX3.EN50160LIMITS[i4] || hubuffer[i4][2] / hucounter >= EMDX3.EN50160LIMITS[i4]) {
                                sampleerror = true;
                                break;
                            }
                            ++i4;
                        }
                        if (sampleerror) {
                            ++hukocounter;
                        } else {
                            ++huokcounter;
                        }
                    }
                    i3 = 0;
                    while (i3 < 12) {
                        hubuffer[i3][2] = 0;
                        hubuffer[i3][1] = 0;
                        hubuffer[i3][0] = 0;
                        ++i3;
                    }
                    hucounter = 0;
                    tenminutes = ctm;
                }
                rs.close();
                if (hucounter >= 10) {
                    boolean sampleerror = false;
                    int i5 = 0;
                    while (i5 < 12) {
                        if (hubuffer[i5][0] / hucounter >= EMDX3.EN50160LIMITS[i5] || hubuffer[i5][1] / hucounter >= EMDX3.EN50160LIMITS[i5] || hubuffer[i5][2] / hucounter >= EMDX3.EN50160LIMITS[i5]) {
                            sampleerror = true;
                            break;
                        }
                        ++i5;
                    }
                    if (sampleerror) {
                        ++hukocounter;
                    } else {
                        ++huokcounter;
                    }
                }
                if (thdokcounter > 0 || thdkocounter > 0) {
                    int eqerror;
                    String eqmessage;
                    boolean thdckeckerr;
                    boolean bl = thdckeckerr = thdkocounter > 0;
                    boolean hckeckerr = huokcounter > 0 || hukocounter > 0 ? huokcounter * 100 / (huokcounter + hukocounter) < 95 : false;
                    if (!thdckeckerr && !hckeckerr) {
                        eqmessage = "OK";
                        eqerror = 0;
                    } else if (thdckeckerr && hckeckerr) {
                        eqmessage = "KO (THD+H)";
                        eqerror = 3;
                    } else if (thdckeckerr) {
                        eqmessage = "KO (THD)";
                        eqerror = 1;
                    } else {
                        eqmessage = "KO (H)";
                        eqerror = 2;
                    }
                    sensorvalues.add(eqmessage);
                    user.uiSet("xerr.eq" + sensor.sensorid + ".text", "text", eqmessage);
                    PreparedStatement pstmt = user.databaseConnection.prepareStatement("update sensors set qualityerror = ? where sensorid = ?");
                    pstmt.setInt(1, eqerror);
                    pstmt.setInt(2, sensor.sensorid);
                    pstmt.execute();
                    continue;
                }
                sensorvalues.add("");
                user.uiSet("xerr.eq" + sensor.sensorid + ".text", "text", "");
            }
            DataProcessor.eqCheckToFile(start, sensorids, sensornames, sensorvalues);
        }
        catch (Exception e3) {
            user.errorLog("DATAPROCESSOR/EQ: GENERIC ERROR, STAGE 2 [" + e3 + "]");
        }
    }

    public static void deleteOldData() {
        long t = System.currentTimeMillis();
        try {
            if (user.lowDiskSpace) {
                if (user.dbOldDataLifetimeCoefficient < 32) {
                    user.dbOldDataLifetimeCoefficient *= 2;
                }
                user.errorLog("DATAPROCESSOR/DELETEOLD: DISK SPACE LOW [" + user.dbOldDataLifetimeCoefficient + "]");
            } else {
                user.dbOldDataLifetimeCoefficient = 1;
                user.messageLog("DATAPROCESSOR/DELETEOLD: DISK SPACE OK");
            }
            long now = System.currentTimeMillis();
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("delete from stdata where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - (long)user.dbOldDataDeleteAfterDaysST * 86400000L / (long)user.dbOldDataLifetimeCoefficient));
            int rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE STDATA");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from thdata where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - (long)user.dbOldDataDeleteAfterDaysTH * 86400000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE THDATA");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from eqdata where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - (long)user.dbOldDataDeleteAfterDaysEQ * 86400000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE EQDATA");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from endata where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 316224000000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE ENDATA");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from ensdata where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 316224000000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE ENSDATA");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from ensdatawater where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 316224000000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE ENSDATAWATER");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from ensdatagas where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 316224000000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE ENSDATAGAS");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from pfsdata where ltime < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 316224000000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE PFSDATA");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from cscharges where time < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 94694400000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE CSCHARGES");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from csstat where time < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 94694400000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE CSSTAT");
            }
            pstmt = user.databaseConnection.prepareStatement("delete from csstate where time < ? limit 10000");
            pstmt.setTimestamp(1, new Timestamp(now - 94694400000L / (long)user.dbOldDataLifetimeCoefficient));
            rows = pstmt.executeUpdate();
            if (rows > 0) {
                user.messageLog("DATAPROCESSOR/DELETEOLD: [" + rows + "] DELETED FROM TABLE CSSTATE");
            }
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/DELETEOLD: GENERIC ERROR [" + e2 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/DELETEOLD [" + (System.currentTimeMillis() - t) + "]");
    }

    public static void consolidate() {
        long t = System.currentTimeMillis();
        try {
            int samples;
            int rows;
            long meter;
            long now = System.currentTimeMillis();
            PreparedStatement pupd = user.databaseConnection.prepareStatement("update endata set meterhr = meterhr + ? where groupid = ? and loadid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = 0");
            PreparedStatement pins = user.databaseConnection.prepareStatement("insert into endata (groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, ?, 0, ?, ?)");
            PreparedStatement pdel = user.databaseConnection.prepareStatement("delete from endata where groupid = ? and loadid = ? and lyear = ? and lmonth = ? and lday = ? and lhour = ? and lmin = ?");
            PreparedStatement psel = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, meterhr from endata where ltime < ? and lday <> 1 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T3));
            ResultSet rs = psel.executeQuery();
            int delcount = 0;
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(8);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setInt(3, rs.getInt(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, (short)1);
                    pupd.setShort(7, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setInt(2, rs.getInt(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, (short)1);
                        pins.setShort(6, (short)0);
                        pins.setTimestamp(7, DataProcessor.newTimestamp(rs.getShort(3), rs.getShort(4), 1, 0, 0));
                        pins.setLong(8, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setInt(2, rs.getInt(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.setShort(7, rs.getShort(7));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, meterhr from endata where ltime < ? and lhour <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T2));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(8);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setInt(3, rs.getInt(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    pupd.setShort(7, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setInt(2, rs.getInt(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, rs.getShort(5));
                        pins.setShort(6, (short)0);
                        pins.setTimestamp(7, DataProcessor.newTimestamp(rs.getShort(3), rs.getShort(4), rs.getShort(5), 0, 0));
                        pins.setLong(8, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setInt(2, rs.getInt(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.setShort(7, rs.getShort(7));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, meterhr from endata where ltime < ? and lmin <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T1));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(8);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setInt(3, rs.getInt(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    pupd.setShort(7, rs.getShort(6));
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setInt(2, rs.getInt(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, rs.getShort(5));
                        pins.setShort(6, rs.getShort(6));
                        pins.setTimestamp(7, DataProcessor.newTimestamp(rs.getShort(3), rs.getShort(4), rs.getShort(5), rs.getShort(6), 0));
                        pins.setLong(8, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setInt(2, rs.getInt(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.setShort(7, rs.getShort(7));
                pdel.execute();
            }
            rs.close();
            psel.close();
            pupd.close();
            pins.close();
            pdel.close();
            if (delcount > 0) {
                user.messageLog("DATAPROCESSOR/CONSOLIDATE: [" + delcount + "] DELETED FROM TABLE ENDATA");
            }
            pupd = user.databaseConnection.prepareStatement("update ensdata set meterhr = meterhr + ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = 0");
            pins = user.databaseConnection.prepareStatement("insert into ensdata (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, 0, ?, ?)");
            pdel = user.databaseConnection.prepareStatement("delete from ensdata where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = ?");
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdata where ltime < ? and lday <> 1 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T3));
            rs = psel.executeQuery();
            delcount = 0;
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, (short)1);
                    pupd.setShort(6, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, (short)1);
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), 1, 0, 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdata where ltime < ? and lhour <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T2));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), 0, 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdata where ltime < ? and lmin <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T1));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, rs.getShort(5));
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            pupd.close();
            pins.close();
            pdel.close();
            if (delcount > 0) {
                user.messageLog("DATAPROCESSOR/CONSOLIDATE: [" + delcount + "] DELETED FROM TABLE ENSDATA");
            }
            pupd = user.databaseConnection.prepareStatement("update ensdatawater set meterhr = meterhr + ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = 0");
            pins = user.databaseConnection.prepareStatement("insert into ensdatawater (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, 0, ?, ?)");
            pdel = user.databaseConnection.prepareStatement("delete from ensdatawater where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = ?");
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdatawater where ltime < ? and lday <> 1 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T3));
            rs = psel.executeQuery();
            delcount = 0;
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, (short)1);
                    pupd.setShort(6, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, (short)1);
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), 1, 0, 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdatawater where ltime < ? and lhour <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T2));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), 0, 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdatawater where ltime < ? and lmin <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T1));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, rs.getShort(5));
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            pupd.close();
            pins.close();
            pdel.close();
            if (delcount > 0) {
                user.messageLog("DATAPROCESSOR/CONSOLIDATE: [" + delcount + "] DELETED FROM TABLE ENSDATAWATER");
            }
            pupd = user.databaseConnection.prepareStatement("update ensdatagas set meterhr = meterhr + ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = 0");
            pins = user.databaseConnection.prepareStatement("insert into ensdatagas (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr) values (?, ?, ?, ?, ?, 0, ?, ?)");
            pdel = user.databaseConnection.prepareStatement("delete from ensdatagas where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = ?");
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdatagas where ltime < ? and lday <> 1 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T3));
            rs = psel.executeQuery();
            delcount = 0;
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, (short)1);
                    pupd.setShort(6, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, (short)1);
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), 1, 0, 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdatagas where ltime < ? and lhour <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T2));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), 0, 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr from ensdatagas where ltime < ? and lmin <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T1));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                if (meter > 0L) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, rs.getShort(5));
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), 0));
                        pins.setLong(7, meter);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            pupd.close();
            pins.close();
            pdel.close();
            if (delcount > 0) {
                user.messageLog("DATAPROCESSOR/CONSOLIDATE: [" + delcount + "] DELETED FROM TABLE ENSDATAGAS");
            }
            pupd = user.databaseConnection.prepareStatement("update pfsdata set meterhr = meterhr + ?, samples = samples + ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = 0");
            pins = user.databaseConnection.prepareStatement("insert into pfsdata (sensorid, lyear, lmonth, lday, lhour, lmin, ltime, meterhr, samples) values (?, ?, ?, ?, ?, 0, ?, ?, ?)");
            pdel = user.databaseConnection.prepareStatement("delete from pfsdata where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = ?");
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr, samples from pfsdata where ltime < ? and lday <> 1 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T3));
            rs = psel.executeQuery();
            delcount = 0;
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                samples = rs.getInt(8);
                if (samples > 0) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, samples);
                    pupd.setInt(3, rs.getInt(1));
                    pupd.setShort(4, rs.getShort(2));
                    pupd.setShort(5, rs.getShort(3));
                    pupd.setShort(6, (short)1);
                    pupd.setShort(7, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, (short)1);
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), 1, 0, 0));
                        pins.setLong(7, meter);
                        pins.setInt(8, samples);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr, samples from pfsdata where ltime < ? and lhour <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T2));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                samples = rs.getInt(8);
                if (samples > 0) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, samples);
                    pupd.setInt(3, rs.getInt(1));
                    pupd.setShort(4, rs.getShort(2));
                    pupd.setShort(5, rs.getShort(3));
                    pupd.setShort(6, rs.getShort(4));
                    pupd.setShort(7, (short)0);
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, (short)0);
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), 0, 0));
                        pins.setLong(7, meter);
                        pins.setInt(8, samples);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, meterhr, samples from pfsdata where ltime < ? and lmin <> 0 limit 1000");
            psel.setTimestamp(1, new Timestamp(now - T1));
            rs = psel.executeQuery();
            while (rs.next()) {
                ++delcount;
                meter = rs.getLong(7);
                samples = rs.getInt(8);
                if (samples > 0) {
                    pupd.setLong(1, meter);
                    pupd.setInt(2, samples);
                    pupd.setInt(3, rs.getInt(1));
                    pupd.setShort(4, rs.getShort(2));
                    pupd.setShort(5, rs.getShort(3));
                    pupd.setShort(6, rs.getShort(4));
                    pupd.setShort(7, rs.getShort(5));
                    rows = pupd.executeUpdate();
                    if (rows == 0) {
                        pins.setInt(1, rs.getInt(1));
                        pins.setShort(2, rs.getShort(2));
                        pins.setShort(3, rs.getShort(3));
                        pins.setShort(4, rs.getShort(4));
                        pins.setShort(5, rs.getShort(5));
                        pins.setTimestamp(6, DataProcessor.newTimestamp(rs.getShort(2), rs.getShort(3), rs.getShort(4), rs.getShort(5), 0));
                        pins.setLong(7, meter);
                        pins.setInt(8, samples);
                        pins.execute();
                    }
                }
                pdel.setInt(1, rs.getInt(1));
                pdel.setShort(2, rs.getShort(2));
                pdel.setShort(3, rs.getShort(3));
                pdel.setShort(4, rs.getShort(4));
                pdel.setShort(5, rs.getShort(5));
                pdel.setShort(6, rs.getShort(6));
                pdel.execute();
            }
            rs.close();
            psel.close();
            pupd.close();
            pins.close();
            pdel.close();
            if (delcount > 0) {
                user.messageLog("DATAPROCESSOR/CONSOLIDATE: [" + delcount + "] DELETED FROM TABLE PFSDATA");
            }
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/CONSOLIDATE: GENERIC ERROR [" + e2 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/CONSOLIDATE [" + (System.currentTimeMillis() - t) + "]");
    }

    public static synchronized void eqInitUI() {
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select qualityerror from sensors where sensorid = ?");
            Enumeration<Integer> e2 = Polling.gatewayCache.keys();
            while (e2.hasMoreElements()) {
                int gatewayid = e2.nextElement();
                GatewayCache gateway = Polling.gatewayCache.get(gatewayid);
                pstmt.setInt(1, gateway.eqsensorid);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    switch (rs.getInt(1)) {
                        case 0: {
                            user.uiSet("xerr.eq" + gateway.eqsensorid + ".text", "text", "OK");
                            break;
                        }
                        case 1: {
                            user.uiSet("xerr.eq" + gateway.eqsensorid + ".text", "text", "KO (THD)");
                            break;
                        }
                        case 2: {
                            user.uiSet("xerr.eq" + gateway.eqsensorid + ".text", "text", "KO (H)");
                            break;
                        }
                        case 3: {
                            user.uiSet("xerr.eq" + gateway.eqsensorid + ".text", "text", "KO (THD+H)");
                        }
                    }
                }
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Task taskRead(String taskid) throws Exception {
        ResultSet rs;
        PreparedStatement preparedStatement = taskselectstmt;
        synchronized (preparedStatement) {
            taskselectstmt.setString(1, taskid);
            rs = taskselectstmt.executeQuery();
        }
        if (rs.next()) {
            String pointer = rs.getString(1);
            int phase = rs.getInt(2);
            rs.close();
            return new Task(taskid, pointer, phase);
        }
        rs.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void taskWrite(String taskid, String pointer, int phase) throws Exception {
        PreparedStatement preparedStatement = taskupdate2stmt;
        synchronized (preparedStatement) {
            taskupdate2stmt.setString(1, pointer);
            taskupdate2stmt.setInt(2, phase);
            taskupdate2stmt.setString(3, taskid);
            taskupdate2stmt.execute();
            if (taskupdate2stmt.getUpdateCount() < 1) {
                taskinsertstmt.setString(1, taskid);
                taskinsertstmt.setString(2, pointer);
                taskinsertstmt.setInt(3, phase);
                taskinsertstmt.execute();
            }
        }
    }

    private static void rawStDataToFile(int sensorid, int modelid, long timestamp, byte[] raw) throws Exception {
        BufferedWriter fw;
        Hashtable<String, Number> data;
        String filename;
        StringBuffer sb = new StringBuffer();
        boolean newfile = false;
        Integer loadid = null;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/devices/" + sensorid;
        block0 : switch (modelid) {
            case 39: {
                filename = String.valueOf(sensorid) + "_gas_" + yyyymm + ".csv";
                break;
            }
            case 40: {
                filename = String.valueOf(sensorid) + "_water_" + yyyymm + ".csv";
                break;
            }
            case 43: {
                loadid = Polling.sensorCache.get((Object)Integer.valueOf((int)sensorid)).loadid;
                switch (loadid) {
                    case -3: {
                        filename = String.valueOf(sensorid) + "_water_" + yyyymm + ".csv";
                        break block0;
                    }
                    case -4: {
                        filename = String.valueOf(sensorid) + "_gas_" + yyyymm + ".csv";
                        break block0;
                    }
                }
                filename = String.valueOf(sensorid) + "_energy_" + yyyymm + ".csv";
                break;
            }
            default: {
                filename = String.valueOf(sensorid) + "_energy_" + yyyymm + ".csv";
            }
        }
        DataProcessor.newDirs(pathname);
        File file = new File(pathname, filename);
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            block9 : switch (modelid) {
                case 2: 
                case 3: 
                case 48: 
                case 49: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Ea+ [Wh];Er+ [varh];Es [VAh];Ea- [Wh];Er- [varh]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Ea+ [Wh],Er+ [varh],Es [VAh],Ea- [Wh],Er- [varh]\r\n");
                    break;
                }
                case 0: 
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 18: 
                case 19: 
                case 63: 
                case 94: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Ea+ [Wh];Er+ [varh]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Ea+ [Wh],Er+ [varh]\r\n");
                    break;
                }
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 61: 
                case 64: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Ea+ [Wh]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Ea+ [Wh]\r\n");
                    break;
                }
                case 20: 
                case 21: 
                case 41: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 62: 
                case 92: 
                case 93: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Ea+ [Wh];Er+ [varh];Ea- [Wh];Er- [varh]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Ea+ [Wh],Er+ [varh],Ea- [Wh],Er- [varh]\r\n");
                    break;
                }
                case 39: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Gas [dm3]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Gas [dm3]\r\n");
                    break;
                }
                case 40: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Water [dm3]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Water [dm3]\r\n");
                    break;
                }
                case 43: {
                    switch (loadid) {
                        case -3: {
                            sb.append("Timestamp" + user.csvFieldSep + "Water [dm3]\r\n");
                            break block9;
                        }
                        case -4: {
                            sb.append("Timestamp" + user.csvFieldSep + "Gas [dm3]\r\n");
                            break block9;
                        }
                    }
                    sb.append("Timestamp" + user.csvFieldSep + "Ea+ [Wh]\r\n");
                    break;
                }
                case 136: {
                    sb.append("Timestamp");
                    sb.append(user.csvFieldSep);
                    sb.append("Ea+ [Wh]");
                    sb.append(user.csvFieldSep);
                    sb.append("Ea- [Wh]\r\n");
                    break;
                }
                case 141: 
                case 145: 
                case 152: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;Ea+ [Wh];Er+ [varh];Ea- [Wh];Er- [varh]\r\n");
                        break;
                    }
                    sb.append("Timestamp,Ea+ [Wh],Er+ [varh],Ea- [Wh],Er- [varh]\r\n");
                    break;
                }
                case 90: 
                case 91: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    file = null;
                    break;
                }
                default: {
                    throw new Exception("unknown modelid: " + filename);
                }
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        switch (modelid) {
            case 0: 
            case 1: {
                if (raw.length != 44) break;
                data = EMDX3.decodePartialEnergyPos(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                break;
            }
            case 2: 
            case 3: {
                if (raw.length != 160) break;
                data = EMDX3.decodePartialEnergyPos(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = EMDX3.decodePartialEnergyNeg(Arrays.copyOfRange(raw, 8, 20));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Es"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 4: 
            case 5: {
                if (raw.length != 4) break;
                data = IME.decodeEnergyPos467x(raw);
                sb.append(data.get("Ea"));
                break;
            }
            case 6: 
            case 7: {
                if (raw.length != 16) break;
                data = IME.decodeEnergyPos4680(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                break;
            }
            case 94: {
                if (raw.length != 16) break;
                data = IME.decodeEnergyPos412074(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                if (raw.length != 28) break;
                data = IME.decodeEnergyPos468x(Arrays.copyOfRange(raw, 0, 12));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 61: 
            case 64: {
                if (raw.length == 16) {
                    data = EMDX3.decodeTotalEnergyCounter(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length == 14) {
                    data = F4.decodeTotalEnergyCounter(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length == 12) {
                    data = F4.decodeTotalEnergyCounter12(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length == 8) {
                    data = EMS.decodeTotalEnergyCounter(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length != 9 || raw[8] != 4) break;
                data = IME.decodeTotalEnergyCounter(raw);
                sb.append(data.get("Ea"));
                break;
            }
            case 20: {
                if (raw.length != 16) break;
                data = DMX3.decodeEnergyPos(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = DMX3.decodeEnergyNeg(Arrays.copyOfRange(raw, 8, 16));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 21: {
                if (raw.length != 16) break;
                data = DPX3.decodeEnergyPos(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = DPX3.decodeEnergyNeg(Arrays.copyOfRange(raw, 8, 16));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 39: 
            case 40: {
                if (raw.length == 16) {
                    data = EMDX3.decodeTotalM3Counter(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length == 14) {
                    data = F4.decodeTotalM3Counter(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length == 12) {
                    data = F4.decodeTotalM3Counter12(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length == 8) {
                    data = EMS.decodeTotalM3Counter(raw);
                    sb.append(data.get("Ea"));
                    break;
                }
                if (raw.length != 9 || raw[8] != 4) break;
                data = IME.decodeTotalM3Counter(raw);
                sb.append(data.get("Ea"));
                break;
            }
            case 41: {
                if (raw.length != 112) break;
                data = CONTREL.decodePartialEnergyPos(Arrays.copyOfRange(raw, 0, 16));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = CONTREL.decodePartialEnergyNeg(Arrays.copyOfRange(raw, 16, 32));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 42: {
                if (raw.length != 16) break;
                data = DX3.decodeEnergyPos(Arrays.copyOfRange(raw, 0, 16));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = DX3.decodeEnergyNeg(Arrays.copyOfRange(raw, 16, 32));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 43: {
                if (raw.length != 8) break;
                data = GENERIC.decodeTotalEnergy(raw);
                sb.append(data.get("Ea"));
                break;
            }
            case 44: 
            case 92: {
                if (raw.length != 94) break;
                data = F4.decodeEnergyPosN200(Arrays.copyOfRange(raw, 0, 12), 100);
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = F4.decodeEnergyNegN200(Arrays.copyOfRange(raw, 12, 24), 100);
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 45: 
            case 46: 
            case 93: {
                if (raw.length != 94) break;
                data = F4.decodeEnergyPosN200(Arrays.copyOfRange(raw, 0, 12), 10);
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = F4.decodeEnergyNegN200(Arrays.copyOfRange(raw, 12, 24), 10);
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 48: 
            case 49: {
                if (raw.length != 164) break;
                data = ENTES.decodeEnergyPosMPR46S(Arrays.copyOfRange(raw, 0, 16));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = ENTES.decodeEnergyNegMPR46S(Arrays.copyOfRange(raw, 16, 40));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Es"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 62: {
                if (raw.length != 20) break;
                data = EMS.decodeEnergyPos(Arrays.copyOfRange(raw, 0, 10));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                data = EMS.decodeEnergyNeg(Arrays.copyOfRange(raw, 10, 20));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 63: {
                if (raw.length != 8) break;
                data = IME.decodeEnergyPos412068(Arrays.copyOfRange(raw, 0, 12));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                break;
            }
            case 136: {
                if (raw.length != 24) break;
                data = IME.decodeEnergyPosD4DC(Arrays.copyOfRange(raw, 0, 6));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                data = IME.decodeEnergyNegD4DC(Arrays.copyOfRange(raw, 6, 12));
                sb.append(data.get("Ea-"));
                break;
            }
            case 141: {
                if (raw.length != 16) break;
                data = IME.decodeEnergyPosCE2DF(Arrays.copyOfRange(raw, 0, 8));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                sb.append(user.csvFieldSep);
                data = IME.decodeEnergyNegCE2DF(Arrays.copyOfRange(raw, 8, 16));
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 145: 
            case 152: {
                if (raw.length != 62) break;
                data = IME.decodeEnergyPosCE4DF(Arrays.copyOfRange(raw, 0, 12));
                sb.append(data.get("Ea"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er"));
                sb.append(user.csvFieldSep);
                data = IME.decodeEnergyNegCE4DF(Arrays.copyOfRange(raw, 12, 24));
                sb.append(data.get("Ea-"));
                sb.append(user.csvFieldSep);
                sb.append(data.get("Er-"));
                break;
            }
            case 90: 
            case 91: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                file = null;
                break;
            }
            default: {
                throw new Exception("unknown modelid: " + filename);
            }
        }
        sb.append("\r\n");
        if (file != null) {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            fw.write(sb.toString());
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
        filename = String.valueOf(sensorid) + "_stat_" + yyyymm + ".csv";
        file = new File(pathname, filename);
        sb = new StringBuffer();
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            switch (modelid) {
                case 0: 
                case 1: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;maxI1 [mA];maxI2 [mA];maxI3 [mA];maxIn [mA];maxP+ [0.01 kW];maxP- [0.01 kW];maxQ+ [0.01 kvar];maxQ- [0.01 kvar];maxS [0.01 kVA]\r\n");
                        break;
                    }
                    sb.append("Timestamp,maxI1 [mA],maxI2 [mA],maxI3 [mA],maxIn [mA],maxP+ [0.01 kW],maxP- [0.01 kW],maxQ+ [0.01 kvar],maxQ- [0.01 kvar],maxS [0.01 kVA]\r\n");
                    break;
                }
                case 2: 
                case 3: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;");
                        sb.append("avgU12 [0.01 V];avgU23 [0.01 V];avgU31 [0.01 V];avgV1 [0.01 V];avgV2 [0.01 V];avgV3 [0.01 V];avgF [0.01 Hz];avgI1 [mA];avgI2 [mA];avgI3 [mA];avgIn [mA];avgP+ [0.01 kW];avgP- [0.01 kW];avgQ+ [0.01 kvar];avgQ- [0.01 kvar];avgS [0.01 kVA];");
                        sb.append("maxU12 [0.01 V];maxU23 [0.01 V];maxU31 [0.01 V];maxV1 [0.01 V];maxV2 [0.01 V];maxV3 [0.01 V];maxF [0.01 Hz];");
                        sb.append("maxI1 [mA];maxI2 [mA];maxI3 [mA];maxIn [mA];maxP+ [0.01 kW];maxP- [0.01 kW];maxQ+ [0.01 kvar];maxQ- [0.01 kvar];maxS [0.01 kVA];");
                        sb.append("THDminI [0.1 %];THDminIn [0.1 %];THDminU [0.1 %];THDmaxI [0.1 %];THDmaxIn [0.1 %];THDmaxU [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,");
                    sb.append("avgU12 [0.01 V],avgU23 [0.01 V],avgU31 [0.01 V],avgV1 [0.01 V],avgV2 [0.01 V],avgV3 [0.01 V],avgF [0.01 Hz],avgI1 [mA],avgI2 [mA],avgI3 [mA],avgIn [mA],avgP+ [0.01 kW],avgP- [0.01 kW],avgQ+ [0.01 kvar],avgQ- [0.01 kvar],avgS [0.01 kVA],");
                    sb.append("maxU12 [0.01 V],maxU23 [0.01 V],maxU31 [0.01 V],maxV1 [0.01 V],maxV2 [0.01 V],maxV3 [0.01 V],maxF [0.01 Hz],");
                    sb.append("maxI1 [mA],maxI2 [mA],maxI3 [mA],maxIn [mA],maxP+ [0.01 kW],maxP- [0.01 kW],maxQ+ [0.01 kvar],maxQ- [0.01 kvar],maxS [0.01 kVA],");
                    sb.append("THDminI [0.1 %],THDminIn [0.1 %],THDminU [0.1 %],THDmaxI [0.1 %],THDmaxIn [0.1 %],THDmaxU [0.1 %]\r\n");
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 18: 
                case 19: 
                case 94: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;avgP+ [0.01 kW];maxP+ [0.01 kW]\r\n");
                        break;
                    }
                    sb.append("Timestamp,avgP+ [0.01 kW],maxP+ [0.01 kW]\r\n");
                    break;
                }
                case 41: {
                    if (user.csvFieldSep == ';') {
                        sb.append("avgI1 [mA];avgI2 [mA];avgI3 [mA];avgIn [mA];avgP [0.01 kW];avgQ [0.01 kvar];");
                        sb.append("maxI1 [mA];maxI2 [mA];maxI3 [mA];maxIn [mA]\r\n");
                        break;
                    }
                    sb.append("avgI1 [mA],avgI2 [mA],avgI3 [mA],avgIn [mA],avgP [0.01 kW],avgQ [0.01 kvar],");
                    sb.append("maxI1 [mA],maxI2 [mA],maxI3 [mA],maxIn [mA]\r\n");
                    break;
                }
                case 44: 
                case 45: 
                case 46: 
                case 92: 
                case 93: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;");
                        sb.append("avgI1 [mA];avgI2 [mA];avgI3 [mA];avgP+ [W];avgQ+ [var];avgS [VA];");
                        sb.append("maxU12 [mV];maxU23 [mV];maxU31 [mV];maxV1 [mV];maxV2 [mV];maxV3 [mV];");
                        sb.append("maxI1 [mA];maxI2 [mA];maxI3 [mA];maxP+ [W];maxQ+ [var];maxS [VA]\r\n");
                        break;
                    }
                    sb.append("Timestamp,");
                    sb.append("avgI1 [mA],avgI2 [mA],avgI3 [mA],avgP+ [W],avgQ+ [var],avgS [VA],");
                    sb.append("maxU12 [mV],maxU23 [mV],maxU31 [mV],maxV1 [mV],maxV2 [mV],maxV3 [mV],");
                    sb.append("maxI1 [mA],maxI2 [mA],maxI3 [mA],maxP+ [W],maxQ+ [var],maxS [VA]\r\n");
                    break;
                }
                case 48: 
                case 49: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;");
                        sb.append("avgU12 [0.1 V];avgU23 [0.1 V];avgU31 [0.1 V];avgV1 [0.1 V];avgV2 [0.1 V];avgV3 [0.1 V];avgF [0.01 Hz];avgI1 [mA];avgI2 [mA];avgI3 [mA];avgIn [mA];avgP+ [W];avgP- [W];avgQ+ [var];avgQ- [var];avgS [VA];");
                        sb.append("maxU12 [mV];maxU23 [mV];maxU31 [mV];maxV1 [mV];maxV2 [mV];maxV3 [mV];maxF [0.01 Hz];");
                        sb.append("maxI1 [mA];maxI2 [mA];maxI3 [mA];maxIn [mA];maxP+ [W];maxP- [W];maxQ+ [var];maxS [VA]\r\n");
                        break;
                    }
                    sb.append("Timestamp,");
                    sb.append("avgU12 [0.1 V],avgU23 [0.1 V],avgU31 [0.1 V],avgV1 [0.1 V],avgV2 [0.1 V],avgV3 [0.1 V],avgF [0.01 Hz],avgI1 [mA],avgI2 [mA],avgI3 [mA],avgIn [mA],avgP+ [W],avgP- [W],avgQ+ [var],avgQ- [var],avgS [VA],");
                    sb.append("maxU12 [mV],maxU23 [mV],maxU31 [mV],maxV1 [mV],maxV2 [mV],maxV3 [mV],maxF [0.01 Hz],");
                    sb.append("maxI1 [mA],maxI2 [mA],maxI3 [mA],maxIn [mA],maxP+ [W],maxP- [W],maxQ+ [var],maxS [VA]\r\n");
                    break;
                }
                case 124: 
                case 125: 
                case 126: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;");
                        sb.append("maxU12 [V];maxU23 [V];maxU31 [V];maxV1 [V];maxV2 [V];maxV3 [V];");
                        sb.append("maxI1 [A/100];maxI2 [A/100];maxI3 [A/100];maxT [C];maxT [F]\r\n");
                        break;
                    }
                    sb.append("Timestamp,");
                    sb.append("maxU12 [V],maxU23 [V],maxU31 [V],maxV1 [V],maxV2 [V],maxV3 [V],");
                    sb.append("maxI1 [A/100],maxI2 [A/100],maxI3 [A/100],maxT [C],maxT [F]\r\n");
                    break;
                }
                case 127: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;");
                        sb.append("maxT [C];maxT [F]\r\n");
                        break;
                    }
                    sb.append("Timestamp,");
                    sb.append("maxT [C],maxT [F]\r\n");
                    break;
                }
                case 136: {
                    sb.append("Timestamp");
                    sb.append(user.csvFieldSep);
                    sb.append("avgP+ [W]");
                    sb.append(user.csvFieldSep);
                    sb.append("maxP+ [W]\r\n");
                    break;
                }
                case 152: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;");
                        sb.append("avgI1 [mA];avgI2 [mA];avgI3 [mA];");
                        sb.append("maxU12 [mV];maxU23 [mV];maxU31 [mV];maxV1 [mV];maxV2 [mV];maxV3 [mV];");
                        sb.append("maxI1 [mA];maxI2 [mA];maxI3 [mA]\r\n");
                        break;
                    }
                    sb.append("Timestamp,");
                    sb.append("avgI1 [mA],avgI2 [mA],avgI3 [mA],");
                    sb.append("maxU12 [mV],maxU23 [mV],maxU31 [mV],maxV1 [mV],maxV2 [mV],maxV3 [mV],");
                    sb.append("maxI1 [mA],maxI2 [mA],maxI3 [mA]\r\n");
                    break;
                }
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 39: 
                case 40: 
                case 42: 
                case 43: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 90: 
                case 91: 
                case 141: 
                case 145: {
                    file = null;
                    break;
                }
                default: {
                    throw new Exception("unknown modelid: " + filename);
                }
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        switch (modelid) {
            case 0: 
            case 1: {
                if (raw.length != 44) break;
                sb.append(EMDX3.toLongString(raw, 8, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 12, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 16, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 20, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 24, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 28, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 32, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 36, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 40, false));
                break;
            }
            case 2: 
            case 3: {
                if (raw.length != 160) break;
                sb.append(EMDX3.toLongString(raw, 20, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 24, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 28, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 32, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 36, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 40, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 44, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 48, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 52, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 56, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 60, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 64, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 68, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 72, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 76, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 80, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 84, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 88, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 92, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 96, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 100, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 104, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 108, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 112, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 116, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 120, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 124, false));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 128, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 132, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 136, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 140, true));
                sb.append(user.csvFieldSep);
                sb.append(EMDX3.toLongString(raw, 144, false));
                int i2 = 0;
                while (i2 < 6) {
                    sb.append(user.csvFieldSep);
                    sb.append(EMDX3.toIntegerString(raw, 148 + 2 * i2, false));
                    ++i2;
                }
                break;
            }
            case 6: 
            case 7: 
            case 94: {
                if (raw.length != 16) break;
                data = IME.decodeAvgExt4680(Arrays.copyOfRange(raw, 8, 12));
                sb.append(data.get("avgP+"));
                sb.append(user.csvFieldSep);
                data = IME.decodeMaxBase4680(Arrays.copyOfRange(raw, 12, 16));
                sb.append(data.get("maxP+"));
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 19: {
                if (raw.length != 28) break;
                data = IME.decodeAvgExt4686(Arrays.copyOfRange(raw, 12, 20));
                sb.append(data.get("avgP+"));
                sb.append(user.csvFieldSep);
                data = IME.decodeMaxBase4686(Arrays.copyOfRange(raw, 20, 28));
                sb.append(data.get("maxP+"));
                break;
            }
            case 41: {
                if (raw.length != 112) break;
                sb.append(CONTREL.toUnsigned(raw, 48));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 56));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 64));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 72));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 32));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 40));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 80));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 88));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 96));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toSigned(raw, 104));
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 92: 
            case 93: {
                if (raw.length != 94) break;
                Hashtable<String, Integer> decoded = F4.decodeAvgExtN200(Arrays.copyOfRange(raw, 24, 52), modelid == 44 || modelid == 92 ? 100 : 10);
                sb.append(decoded.get("avgI1"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgI2"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgI3"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgP+"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgQ+"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgS"));
                int i3 = 0;
                while (i3 < 3) {
                    sb.append(user.csvFieldSep);
                    switch (raw[53]) {
                        case 0: 
                        case 3: 
                        case 4: {
                            break;
                        }
                        default: {
                            sb.append(F4.toLongString(raw, 54 + 4 * i3, false));
                        }
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < 3) {
                    sb.append(user.csvFieldSep);
                    switch (raw[53]) {
                        case 0: 
                        case 3: 
                        case 4: {
                            sb.append(F4.toLongString(raw, 54 + 4 * i3, false));
                        }
                    }
                    ++i3;
                }
                decoded = F4.decodeMaxBaseN200(Arrays.copyOfRange(raw, 66, 94), modelid == 44 || modelid == 92 ? 100 : 10);
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxI1"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxI2"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxI3"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxP+"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxQ+"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxS"));
                break;
            }
            case 48: 
            case 49: {
                if (raw.length != 164) break;
                int i4 = 0;
                while (i4 < 11) {
                    if (i4 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    sb.append(F4.toLongString(raw, 40 + 4 * i4, false));
                    ++i4;
                }
                i4 = 0;
                while (i4 < 5) {
                    sb.append(user.csvFieldSep);
                    sb.append(F4.toFloatString(raw, 84 + 4 * i4));
                    ++i4;
                }
                i4 = 0;
                while (i4 < 7) {
                    sb.append(user.csvFieldSep);
                    sb.append(F4.toLongString(raw, 104 + 4 * i4, false));
                    ++i4;
                }
                i4 = 0;
                while (i4 < 4) {
                    sb.append(user.csvFieldSep);
                    sb.append(F4.toLongString(raw, 132 + 4 * i4, false));
                    ++i4;
                }
                i4 = 0;
                while (i4 < 4) {
                    sb.append(user.csvFieldSep);
                    sb.append(F4.toFloatString(raw, 148 + 4 * i4));
                    ++i4;
                }
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                if (raw.length != 15 + (modelid == 126 ? 112 : ALPTEC.getNumberOfStepsByModel(modelid) * 8)) break;
                Hashtable<String, Integer> decoded = ALPTEC.decodeMaxExtX2(Arrays.copyOfRange(raw, 0, 10));
                String[] vcolumns = new String[]{"maxU12", "maxU23", "maxU31", "maxV1", "maxV2", "maxV3"};
                int i5 = 0;
                while (i5 < vcolumns.length) {
                    if (i5 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if (decoded.containsKey(vcolumns[i5])) {
                        sb.append(decoded.get(vcolumns[i5]));
                    }
                    ++i5;
                }
                int maxt = decoded.get("maxT");
                int tu = decoded.get("TU");
                decoded = ALPTEC.decodeMaxBaseX2(Arrays.copyOfRange(raw, 10, 15));
                String[] icolumns = new String[]{"maxI1", "maxI2", "maxI3"};
                int i6 = 0;
                while (i6 < icolumns.length) {
                    sb.append(user.csvFieldSep);
                    if (decoded.containsKey(icolumns[i6])) {
                        sb.append(decoded.get(icolumns[i6]));
                    }
                    ++i6;
                }
                sb.append(user.csvFieldSep);
                sb.append(tu == 0 ? maxt : (maxt - 32) * 5 / 9);
                sb.append(user.csvFieldSep);
                sb.append(tu == 1 ? maxt : maxt * 9 / 5 + 32);
                break;
            }
            case 127: {
                if (raw.length != 3 + ALPTEC.getNumberOfStepsByModel(modelid) * 12) break;
                Hashtable<String, Integer> decoded = ALPTEC.decodeMaxExt8(Arrays.copyOfRange(raw, 0, 3));
                int maxt = decoded.get("maxT") / 10;
                int tu = decoded.get("TU");
                sb.append(tu == 0 ? maxt : (maxt - 32) * 5 / 9);
                sb.append(user.csvFieldSep);
                sb.append(tu == 1 ? maxt : maxt * 9 / 5 + 32);
                break;
            }
            case 136: {
                if (raw.length != 20) break;
                data = IME.decodeAvgExtD4DC(Arrays.copyOfRange(raw, 12, 18));
                sb.append(data.get("avgP+"));
                sb.append(user.csvFieldSep);
                data = IME.decodeMaxBaseD4DC(Arrays.copyOfRange(raw, 18, 24));
                sb.append(data.get("maxP+"));
                break;
            }
            case 152: {
                if (raw.length != 62) break;
                Hashtable<String, Integer> decoded = IME.decodeAvgExtCE4DF(Arrays.copyOfRange(raw, 50, 62));
                sb.append(decoded.get("avgI1"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgI2"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("avgI3"));
                decoded = IME.decodeMaxExtCE4DF(Arrays.copyOfRange(raw, 36, 50));
                sb.append(user.csvFieldSep);
                if (decoded.containsKey("maxU12")) {
                    sb.append(decoded.get("maxU12"));
                    sb.append(user.csvFieldSep);
                    sb.append(decoded.get("maxU23"));
                    sb.append(user.csvFieldSep);
                    sb.append(decoded.get("maxU31"));
                    sb.append(user.csvFieldSep);
                    sb.append(user.csvFieldSep);
                    sb.append(user.csvFieldSep);
                } else {
                    sb.append(user.csvFieldSep);
                    sb.append(user.csvFieldSep);
                    sb.append(user.csvFieldSep);
                    sb.append(decoded.get("maxV1"));
                    sb.append(user.csvFieldSep);
                    sb.append(decoded.get("maxV2"));
                    sb.append(user.csvFieldSep);
                    sb.append(decoded.get("maxV3"));
                }
                decoded = IME.decodeMaxBaseCE4DF(Arrays.copyOfRange(raw, 24, 36));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxI1"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxI2"));
                sb.append(user.csvFieldSep);
                sb.append(decoded.get("maxI3"));
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 90: 
            case 91: 
            case 141: 
            case 145: {
                file = null;
                break;
            }
            default: {
                throw new Exception("unknown modelid: " + filename);
            }
        }
        sb.append("\r\n");
        if (file != null) {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            fw.write(sb.toString());
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
        filename = String.valueOf(sensorid) + "_steps_" + yyyymm + ".csv";
        file = new File(pathname, filename);
        sb = new StringBuffer();
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            switch (modelid) {
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    sb.append("Timestamp");
                    int i7 = 0;
                    while (i7 < ALPTEC.getNumberOfStepsByModel(modelid)) {
                        sb.append(user.csvFieldSep);
                        sb.append("Step ");
                        sb.append(i7 + 1);
                        sb.append(modelid == 127 ? " Reactive Power [kVar/100]" : " Residual Power [%]");
                        sb.append(user.csvFieldSep);
                        sb.append("Step ");
                        sb.append(i7 + 1);
                        sb.append(" Number of Insertions");
                        sb.append(user.csvFieldSep);
                        sb.append("Step ");
                        sb.append(i7 + 1);
                        sb.append(" Insertion Time [min.]");
                        ++i7;
                    }
                    sb.append("\r\n");
                    break;
                }
                default: {
                    file = null;
                }
            }
        }
        sb.append(time);
        switch (modelid) {
            case 124: 
            case 125: {
                if (raw.length != 15 + ALPTEC.getNumberOfStepsByModel(modelid) * 8) break;
                Hashtable<String, Integer[]> stepsvalues = ALPTEC.decodeSteps3252(Arrays.copyOfRange(raw, 15, raw.length));
                Integer[] sr = stepsvalues.get("SR");
                Integer[] sn = stepsvalues.get("SN");
                Integer[] st = stepsvalues.get("ST");
                int i8 = 0;
                while (i8 < ALPTEC.getNumberOfStepsByModel(modelid)) {
                    sb.append(user.csvFieldSep);
                    sb.append(sr[i8]);
                    sb.append(user.csvFieldSep);
                    sb.append(sn[i8]);
                    sb.append(user.csvFieldSep);
                    sb.append(st[i8]);
                    ++i8;
                }
                break;
            }
            case 126: {
                if (raw.length != 127) break;
                Hashtable<String, Integer[]> stepsvalues = ALPTEC.decodeSteps82(Arrays.copyOfRange(raw, 15, raw.length));
                Integer[] sr = stepsvalues.get("SR");
                Integer[] sn = stepsvalues.get("SN");
                Integer[] st = stepsvalues.get("ST");
                int i9 = 0;
                while (i9 < ALPTEC.getNumberOfStepsByModel(modelid)) {
                    sb.append(user.csvFieldSep);
                    sb.append(sr[i9]);
                    sb.append(user.csvFieldSep);
                    sb.append(sn[i9]);
                    sb.append(user.csvFieldSep);
                    sb.append(st[i9]);
                    ++i9;
                }
                break;
            }
            case 127: {
                if (raw.length != 3 + ALPTEC.getNumberOfStepsByModel(modelid) * 12) break;
                Hashtable<String, Integer[]> stepsvalues = ALPTEC.decodeSteps8(Arrays.copyOfRange(raw, 3, raw.length));
                Integer[] sr = stepsvalues.get("SR");
                Integer[] sn = stepsvalues.get("SN");
                Integer[] st = stepsvalues.get("ST");
                int i10 = 0;
                while (i10 < ALPTEC.getNumberOfStepsByModel(modelid)) {
                    sb.append(user.csvFieldSep);
                    sb.append(sr[i10]);
                    sb.append(user.csvFieldSep);
                    sb.append(sn[i10]);
                    sb.append(user.csvFieldSep);
                    sb.append(st[i10]);
                    ++i10;
                }
                break;
            }
            default: {
                file = null;
            }
        }
        sb.append("\r\n");
        if (file != null) {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            fw.write(sb.toString());
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
    }

    private static void rawThDataToFile(int sensorid, int modelid, long timestamp, byte[] raw) throws Exception {
        StringBuffer sb = new StringBuffer();
        boolean newfile = false;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/devices/" + sensorid;
        String filename = String.valueOf(sensorid) + "_thd_" + yyyymm + ".csv";
        DataProcessor.newDirs(pathname);
        File file = new File(pathname, filename);
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            switch (modelid) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 21: 
                case 62: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDU12 [0.1 %];THDU23 [0.1 %];THDU31 [0.1 %];THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %];THDIn [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDU12 [0.1 %],THDU23 [0.1 %],THDU31 [0.1 %],THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %],THDIn [0.1 %]\r\n");
                    break;
                }
                case 41: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %]\r\n");
                    break;
                }
                case 42: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %];THDIn [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %],THDIn [0.1 %]\r\n");
                    break;
                }
                case 44: 
                case 45: 
                case 46: 
                case 92: 
                case 93: 
                case 152: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDU12 [0.1 %];THDU23 [0.1 %];THDU31 [0.1 %];THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDU12 [0.1 %],THDU23 [0.1 %],THDU31 [0.1 %],THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %]\r\n");
                    break;
                }
                case 48: 
                case 49: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDU12 [0.1 %];THDU23 [0.1 %];THDU31 [0.1 %];THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %];THDIn [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDU12 [0.1 %],THDU23 [0.1 %],THDU31 [0.1 %],THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %],THDIn [0.1 %]\r\n");
                    break;
                }
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDU12 [0.1 %];THDU23 [0.1 %];THDU31 [0.1 %];THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDU12 [0.1 %],THDU23 [0.1 %],THDU31 [0.1 %],THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %]\r\n");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 63: 
                case 94: 
                case 136: 
                case 141: 
                case 145: {
                    break;
                }
                default: {
                    throw new Exception("unknown modelid: " + filename);
                }
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        block9 : switch (modelid) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (raw.length != 20) break;
                sb.append(EMDX3.toInteger(raw, 0));
                int i2 = 1;
                while (i2 <= 9) {
                    sb.append(user.csvFieldSep);
                    sb.append(EMDX3.toInteger(raw, 2 * i2));
                    ++i2;
                }
                break;
            }
            case 21: {
                if (raw.length != 20) break;
                sb.append(DPX3.toIntegerString(raw, 14, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 18, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 16, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 8, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 10, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 12, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 0, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 2, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 4, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toIntegerString(raw, 6, 10));
                break;
            }
            case 41: {
                if (raw.length != 48) break;
                sb.append(CONTREL.toUnsigned(raw, 0));
                int i3 = 1;
                while (i3 <= 5) {
                    sb.append(user.csvFieldSep);
                    sb.append(CONTREL.toUnsigned(raw, 8 * i3));
                    ++i3;
                }
                break;
            }
            case 42: {
                if (raw.length != 14) break;
                sb.append(DX3.toIntegerString(raw, 8, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toIntegerString(raw, 10, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toIntegerString(raw, 12, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toIntegerString(raw, 0, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toIntegerString(raw, 2, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toIntegerString(raw, 4, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toIntegerString(raw, 6, 10));
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 92: 
            case 93: {
                if (raw.length != 14) break;
                switch (raw[1]) {
                    case 0: 
                    case 3: 
                    case 4: {
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        int i4 = 0;
                        while (i4 < 6) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 2 + 2 * i4, false));
                            ++i4;
                        }
                        break block9;
                    }
                    default: {
                        sb.append(F4.toInteger(raw, 2, false));
                        int i5 = 1;
                        while (i5 < 3) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 2 + 2 * i5, false));
                            ++i5;
                        }
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        i5 = 3;
                        while (i5 < 6) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 2 + 2 * i5, false));
                            ++i5;
                        }
                        break block9;
                    }
                }
            }
            case 48: 
            case 49: {
                if (raw.length != 40) break;
                sb.append(F4.toLong(raw, 0, false));
                int i6 = 1;
                while (i6 < 10) {
                    sb.append(user.csvFieldSep);
                    sb.append(F4.toLong(raw, 4 * i6, false));
                    ++i6;
                }
                break;
            }
            case 62: {
                if (raw.length != 20) break;
                sb.append(EMS.toIntegerString(raw, 14, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 18, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 16, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 8, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 10, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 12, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 0, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 2, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 4, 10));
                sb.append(user.csvFieldSep);
                sb.append(EMS.toIntegerString(raw, 6, 10));
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                if (raw.length != 6) break;
                String[] columns = new String[]{"THDU12", "THDU23", "THDU31", "THDV1", "THDV2", "THDV3", "THDI1", "THDI2", "THDI3"};
                Hashtable<String, Integer> decoded = ALPTEC.decodeTHDX2(raw);
                int i7 = 0;
                while (i7 < columns.length) {
                    if (i7 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if (decoded.containsKey(columns[i7])) {
                        sb.append(decoded.get(columns[i7]));
                    }
                    ++i7;
                }
                break;
            }
            case 127: {
                if (raw.length != 6 && raw.length != 10 && raw.length != 14) break;
                String[] columns = new String[]{"THDU12", "THDU23", "THDU31", "THDV1", "THDV2", "THDV3", "THDI1", "THDI2", "THDI3"};
                Hashtable<String, Integer> decoded = ALPTEC.decodeTHD8(raw);
                int i8 = 0;
                while (i8 < columns.length) {
                    if (i8 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if (decoded.containsKey(columns[i8])) {
                        sb.append(decoded.get(columns[i8]));
                    }
                    ++i8;
                }
                break;
            }
            case 152: {
                if (raw.length != 22) break;
                String[] columns = new String[]{"THDU12", "THDU23", "THDU31", "THDV1", "THDV2", "THDV3", "THDI1", "THDI2", "THDI3"};
                Hashtable<String, Integer> decoded = IME.decodeTHDCE4DF(raw);
                int i9 = 0;
                while (i9 < columns.length) {
                    if (i9 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if (decoded.containsKey(columns[i9])) {
                        sb.append(decoded.get(columns[i9]));
                    }
                    ++i9;
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 63: 
            case 94: 
            case 136: 
            case 141: 
            case 145: {
                file = null;
                break;
            }
            default: {
                throw new Exception("unknown modelid: " + filename);
            }
        }
        sb.append("\r\n");
        if (file != null) {
            BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            fw.write(sb.toString());
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
    }

    private static void rawEqDataToFile(int sensorid, int modelid, long timestamp, byte[] raw) throws Exception {
        BufferedWriter fw;
        Integer v;
        StringBuffer sb = new StringBuffer();
        boolean newfile = false;
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/devices/" + sensorid;
        String filename = String.valueOf(sensorid) + "_thd_" + yyyymm + ".csv";
        DataProcessor.newDirs(pathname);
        File file = new File(pathname, filename);
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            switch (modelid) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 21: 
                case 62: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDU12 [0.1 %];THDU23 [0.1 %];THDU31 [0.1 %];THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %];THDIn [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDU12 [0.1 %],THDU23 [0.1 %],THDU31 [0.1 %],THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %],THDIn [0.1 %]\r\n");
                    break;
                }
                case 41: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %]\r\n");
                    break;
                }
                case 42: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %];THDIn [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %],THDIn [0.1 %]\r\n");
                    break;
                }
                case 44: 
                case 45: 
                case 46: 
                case 92: 
                case 93: 
                case 152: {
                    if (user.csvFieldSep == ';') {
                        sb.append("Timestamp;THDU12 [0.1 %];THDU23 [0.1 %];THDU31 [0.1 %];THDV1 [0.1 %];THDV2 [0.1 %];THDV3 [0.1 %];THDI1 [0.1 %];THDI2 [0.1 %];THDI3 [0.1 %]\r\n");
                        break;
                    }
                    sb.append("Timestamp,THDU12 [0.1 %],THDU23 [0.1 %],THDU31 [0.1 %],THDV1 [0.1 %],THDV2 [0.1 %],THDV3 [0.1 %],THDI1 [0.1 %],THDI2 [0.1 %],THDI3 [0.1 %]\r\n");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 48: 
                case 49: 
                case 63: 
                case 94: 
                case 136: 
                case 141: 
                case 145: {
                    break;
                }
                default: {
                    throw new Exception("unknown modelid: " + filename);
                }
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        block7 : switch (modelid) {
            case 0: 
            case 1: {
                if (raw.length != 20) break;
                sb.append(EMDX3.toInteger(raw, 0));
                int i2 = 1;
                while (i2 <= 9) {
                    sb.append(user.csvFieldSep);
                    sb.append(EMDX3.toInteger(raw, 2 * i2));
                    ++i2;
                }
                break;
            }
            case 2: 
            case 3: {
                if (raw.length != 324) break;
                sb.append(EMDX3.toInteger(raw, 64));
                int i3 = 1;
                while (i3 <= 9) {
                    sb.append(user.csvFieldSep);
                    sb.append(EMDX3.toInteger(raw, 64 + 2 * i3));
                    ++i3;
                }
                break;
            }
            case 21: {
                if (raw.length != 20) break;
                sb.append(DPX3.toInteger(raw, 14));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 18));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 16));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 8));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 10));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 12));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 0));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 2));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 4));
                sb.append(user.csvFieldSep);
                sb.append(DPX3.toInteger(raw, 6));
                break;
            }
            case 41: {
                if (raw.length != 96) break;
                sb.append(CONTREL.toUnsigned(raw, 48));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toUnsigned(raw, 56));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toUnsigned(raw, 64));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toUnsigned(raw, 72));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toUnsigned(raw, 80));
                sb.append(user.csvFieldSep);
                sb.append(CONTREL.toUnsigned(raw, 88));
                break;
            }
            case 42: {
                if (raw.length != 14) break;
                sb.append(DX3.toInteger(raw, 8));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toInteger(raw, 10));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toInteger(raw, 12));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toInteger(raw, 0));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toInteger(raw, 2));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toInteger(raw, 4));
                sb.append(user.csvFieldSep);
                sb.append(DX3.toInteger(raw, 6));
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                if (raw.length != 258) break;
                switch (raw[29]) {
                    case 0: 
                    case 3: 
                    case 4: {
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        int i4 = 0;
                        while (i4 < 6) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 30 + 2 * i4, false));
                            ++i4;
                        }
                        break block7;
                    }
                    default: {
                        sb.append(F4.toInteger(raw, 2, false));
                        int i5 = 1;
                        while (i5 < 3) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 30 + 2 * i5, false));
                            ++i5;
                        }
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        i5 = 3;
                        while (i5 < 6) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 30 + 2 * i5, false));
                            ++i5;
                        }
                        break block7;
                    }
                }
            }
            case 92: 
            case 93: {
                if (raw.length != 42) break;
                switch (raw[29]) {
                    case 0: 
                    case 3: 
                    case 4: {
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        int i6 = 0;
                        while (i6 < 6) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 30 + 2 * i6, false));
                            ++i6;
                        }
                        break block7;
                    }
                    default: {
                        sb.append(F4.toInteger(raw, 2, false));
                        int i7 = 1;
                        while (i7 < 3) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 30 + 2 * i7, false));
                            ++i7;
                        }
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        sb.append(user.csvFieldSep);
                        i7 = 3;
                        while (i7 < 6) {
                            sb.append(user.csvFieldSep);
                            sb.append(F4.toInteger(raw, 30 + 2 * i7, false));
                            ++i7;
                        }
                        break block7;
                    }
                }
            }
            case 62: {
                if (raw.length != 118) break;
                String[] datapoints = new String[]{"THDU12", "THDU23", "THDU31", "THDV1", "THDV2", "THDV3", "THDI1", "THDI2", "THDI3", "THDIn"};
                Hashtable<String, Integer> values = EMS.decodeTHD(raw);
                int i8 = 0;
                while (i8 < datapoints.length) {
                    if (i8 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if ((v = values.get(datapoints[i8])) != null) {
                        sb.append(v);
                    }
                    ++i8;
                }
                break;
            }
            case 152: {
                if (raw.length != 34) break;
                String[] datapoints = new String[]{"THDU12", "THDU23", "THDU31", "THDV1", "THDV2", "THDV3", "THDI1", "THDI2", "THDI3"};
                Hashtable<String, Integer> values = IME.decodeTHDCE4DF(raw);
                int i8 = 0;
                while (i8 < datapoints.length) {
                    if (i8 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if ((v = values.get(datapoints[i8])) != null) {
                        sb.append(v);
                    }
                    ++i8;
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 48: 
            case 49: 
            case 63: 
            case 94: 
            case 136: 
            case 141: 
            case 145: {
                file = null;
                break;
            }
            default: {
                throw new Exception("unknown modelid: " + filename);
            }
        }
        sb.append("\r\n");
        if (file != null) {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            fw.write(sb.toString());
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
        filename = String.valueOf(sensorid) + "_harmonics_" + yyyymm + ".csv";
        file = new File(pathname, filename);
        sb = new StringBuffer();
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            switch (modelid) {
                case 0: 
                case 1: {
                    file = null;
                    return;
                }
                case 2: 
                case 3: {
                    sb.append("Timestamp");
                    int i9 = 0;
                    while (i9 < 12) {
                        sb.append(user.csvFieldSep);
                        sb.append("HI1 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HI2 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HI3 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HIn r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        ++i9;
                    }
                    i9 = 0;
                    while (i9 < 12) {
                        sb.append(user.csvFieldSep);
                        sb.append("HU12 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HU23 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HU31 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        ++i9;
                    }
                    i9 = 0;
                    while (i9 < 12) {
                        sb.append(user.csvFieldSep);
                        sb.append("HV1 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HV2 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HV3 r ");
                        sb.append(2 * i9 + 3);
                        sb.append(" [0.1 %]");
                        ++i9;
                    }
                    sb.append("\r\n");
                    break;
                }
                case 44: 
                case 45: 
                case 46: {
                    sb.append("Timestamp");
                    int i10 = 0;
                    while (i10 < 12) {
                        sb.append(user.csvFieldSep);
                        sb.append("HI1 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HI2 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HI3 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        ++i10;
                    }
                    i10 = 0;
                    while (i10 < 12) {
                        sb.append(user.csvFieldSep);
                        sb.append("HU12 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HU23 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HU31 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        ++i10;
                    }
                    i10 = 0;
                    while (i10 < 12) {
                        sb.append(user.csvFieldSep);
                        sb.append("HV1 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HV2 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HV3 r ");
                        sb.append(2 * i10 + 3);
                        sb.append(" [0.1 %]");
                        ++i10;
                    }
                    sb.append("\r\n");
                    break;
                }
                case 62: {
                    sb.append("Timestamp");
                    int i11 = 0;
                    while (i11 < 7) {
                        sb.append(user.csvFieldSep);
                        sb.append("HI1 r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HI2 r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HI3 r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HIn r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        ++i11;
                    }
                    i11 = 0;
                    while (i11 < 7) {
                        sb.append(user.csvFieldSep);
                        sb.append("HV1 r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HV2 r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        sb.append(user.csvFieldSep);
                        sb.append("HV3 r ");
                        sb.append(2 * i11 + 3);
                        sb.append(" [0.1 %]");
                        ++i11;
                    }
                    sb.append("\r\n");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 42: 
                case 48: 
                case 49: 
                case 63: 
                case 94: {
                    file = null;
                    break;
                }
                default: {
                    throw new Exception("unknown modelid: " + filename);
                }
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        switch (modelid) {
            case 0: 
            case 1: {
                file = null;
                return;
            }
            case 2: 
            case 3: {
                if (raw.length != 324) break;
                sb.append(EMDX3.toInteger(raw, 84));
                int i12 = 1;
                while (i12 < 120) {
                    sb.append(user.csvFieldSep);
                    sb.append(EMDX3.toInteger(raw, 84 + 2 * i12));
                    ++i12;
                }
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                if (raw.length != 258) break;
                sb.append(F4.toInteger(raw, 42, false));
                int i13 = 1;
                while (i13 < 108) {
                    sb.append(user.csvFieldSep);
                    sb.append(F4.toInteger(raw, 42 + 2 * i13, false));
                    ++i13;
                }
                break;
            }
            case 62: {
                if (raw.length != 118) break;
                Hashtable<String, Integer> values = EMS.decodeHarmonicI(Arrays.copyOfRange(raw, 20, 76));
                int i14 = 0;
                while (i14 < 7) {
                    String s = "H" + (2 * i14 + 3) + "I";
                    if (i14 > 0) {
                        sb.append(user.csvFieldSep);
                    }
                    if ((v = values.get(String.valueOf(s) + "1")) != null) {
                        sb.append(v);
                    }
                    sb.append(user.csvFieldSep);
                    v = values.get(String.valueOf(s) + "2");
                    if (v != null) {
                        sb.append(v);
                    }
                    sb.append(user.csvFieldSep);
                    v = values.get(String.valueOf(s) + "3");
                    if (v != null) {
                        sb.append(v);
                    }
                    sb.append(user.csvFieldSep);
                    v = values.get(String.valueOf(s) + "n");
                    if (v != null) {
                        sb.append(v);
                    }
                    ++i14;
                }
                values = EMS.decodeHarmonicV(Arrays.copyOfRange(raw, 76, 118));
                i14 = 0;
                while (i14 < 7) {
                    String s = "H" + (2 * i14 + 3) + "V";
                    sb.append(user.csvFieldSep);
                    v = values.get(String.valueOf(s) + "1");
                    if (v != null) {
                        sb.append(v);
                    }
                    sb.append(user.csvFieldSep);
                    v = values.get(String.valueOf(s) + "2");
                    if (v != null) {
                        sb.append(v);
                    }
                    sb.append(user.csvFieldSep);
                    v = values.get(String.valueOf(s) + "3");
                    if (v != null) {
                        sb.append(v);
                    }
                    ++i14;
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 42: 
            case 48: 
            case 49: 
            case 63: 
            case 94: {
                file = null;
                break;
            }
            default: {
                throw new Exception("unknown modelid: " + filename);
            }
        }
        sb.append("\r\n");
        if (file != null) {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            fw.write(sb.toString());
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
    }

    private static void eqCheckToFile(Calendar start, Vector<Integer> sensorids, Vector<String> sensornames, Vector<String> sensorvalues) throws Exception {
        File file;
        File existingfile = null;
        StringBuffer sb = new StringBuffer();
        boolean newfile = false;
        int fileidx = 0;
        int year = start.get(1);
        int week = start.get(3);
        String pathname = "userdata/eqcheck";
        String basefilename = "eqcheck_" + year;
        DataProcessor.newDirs(pathname);
        sb.append(new String(user.BOM, "UTF-8"));
        sb.append("Week");
        int i2 = 0;
        while (i2 < sensorids.size()) {
            sb.append(user.csvFieldSep);
            sb.append(sensorids.elementAt(i2));
            sb.append(": ");
            sb.append(sensornames.elementAt(i2));
            ++i2;
        }
        String header = sb.toString();
        while ((file = new File(pathname, String.valueOf(basefilename) + (fileidx > 0 ? "_" + fileidx + ".csv" : ".csv"))).isFile()) {
            existingfile = file;
            ++fileidx;
        }
        if (existingfile == null) {
            newfile = true;
        } else {
            BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(existingfile), "UTF-8"));
            String h2 = fr.readLine();
            fr.close();
            if (header.equals(h2)) {
                file = existingfile;
                newfile = false;
            } else {
                newfile = true;
            }
        }
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        if (newfile) {
            fw.write(header);
            fw.write("\r\n");
        }
        fw.write(Integer.toString(week));
        i = 0;
        while (i < sensorids.size()) {
            fw.write(user.csvFieldSep);
            fw.write(sensorvalues.elementAt(i));
            ++i;
        }
        fw.write("\r\n");
        fw.close();
        if (newfile) {
            file.setWritable(true, false);
        }
    }

    private static void rawEnergyToFile(String path, String fileprefix, long ltime, int lyear, int lmonth, int lday, int lhour, int lmin, Vector<Integer> colids, Vector<String> colnames, Hashtable<Integer, Long> energy) throws Exception {
        File file;
        File existingfile = null;
        StringBuffer sb = new StringBuffer();
        boolean newfile = false;
        int fileidx = 0;
        String time = String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:").format(new Date(ltime))) + (lmin < 10 ? "0" + lmin : Integer.toString(lmin));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/" + path;
        String basefilename = String.valueOf(fileprefix) + "_" + yyyymm;
        DataProcessor.newDirs(pathname);
        sb.append(new String(user.BOM, "UTF-8"));
        sb.append("Timestamp");
        int i2 = 0;
        while (i2 < colids.size()) {
            sb.append(user.csvFieldSep);
            int cid = colids.elementAt(i2);
            if (cid > -2) {
                sb.append(colids.elementAt(i2));
                sb.append(": ");
            }
            sb.append(colnames.elementAt(i2));
            ++i2;
        }
        String header = sb.toString();
        while ((file = new File(pathname, String.valueOf(basefilename) + (fileidx > 0 ? "_" + fileidx + ".csv" : ".csv"))).isFile()) {
            existingfile = file;
            ++fileidx;
        }
        if (existingfile == null) {
            newfile = true;
        } else {
            BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(existingfile), "UTF-8"));
            String h2 = fr.readLine();
            fr.close();
            if (header.equals(h2)) {
                file = existingfile;
                newfile = false;
            } else {
                newfile = true;
            }
        }
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        if (newfile) {
            fw.write(header);
            fw.write("\r\n");
        }
        fw.write(time);
        i = 0;
        while (i < colids.size()) {
            fw.write(user.csvFieldSep);
            Long meter = energy.get(colids.elementAt(i));
            if (meter != null) {
                fw.write(meter.toString());
            } else {
                fw.write(48);
            }
            ++i;
        }
        fw.write("\r\n");
        fw.close();
        if (newfile) {
            file.setWritable(true, false);
        }
    }

    private static void csChargesToFile(int sensorid, ResultSet data) throws Exception {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        boolean newfile = false;
        String time = df.format(new Date(data.getTimestamp(2).getTime()));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/devices/" + sensorid;
        String filename = String.valueOf(sensorid) + "_chargehistory_" + yyyymm + ".csv";
        DataProcessor.newDirs(pathname);
        File file = new File(pathname, filename);
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            if (user.csvFieldSep == ';') {
                sb.append("Timestamp;Charge Id;Plug;User Id;Plug IN Date;Plug OUT Date; Avg. Charge Current [mA]; Peak Charge Current [mA]; Charging Time [s]; Waiting Time [s]; 3-Phase; Main Power Failure; Recoverable Hardware Error; Unrecoverable Hardware Error; EV Lock Error; EV Disconnect Error; EV Current Exceeded; EV Control Pilot Error; EV Overheating; DOM Lock Error; DOM Current Exceeded; DOM Overheating; Other Errors\r\n");
            } else {
                sb.append("Timestamp,Charge Id,Plug,User Id,Plug IN Date,Plug OUT Date, Avg. Charge Current [mA], Peak Charge Current [mA], Charging Time [s], Waiting Time [s], 3-Phase, Main Power Failure, Recoverable Hardware Error, Unrecoverable Hardware Error, EV Lock Error, EV Disconnect Error, EV Current Exceeded, EV Control Pilot Error, EV Overheating, DOM Lock Error, DOM Current Exceeded, DOM Overheating, Other Errors\r\n");
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        sb.append(data.getLong(6));
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(5) == 0 ? "EV" : "DOM");
        sb.append(user.csvFieldSep);
        sb.append(data.getString(7));
        sb.append(user.csvFieldSep);
        sb.append(df.format(new Date(data.getTimestamp(8).getTime())));
        sb.append(user.csvFieldSep);
        sb.append(df.format(new Date(data.getTimestamp(9).getTime())));
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(10) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(11) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(12));
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(13));
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(14) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(15) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(16) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(17) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(18) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(19) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(20) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(21) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(22) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(23) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(24) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(25) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(26) ? "1" : "0");
        sb.append("\r\n");
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        fw.write(sb.toString());
        fw.close();
        if (newfile) {
            file.setWritable(true, false);
        }
    }

    private static void csStatToFile(int sensorid, ResultSet data) throws Exception {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        boolean newfile = false;
        String time = df.format(new Date(data.getTimestamp(2).getTime()));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/devices/" + sensorid;
        String filename = String.valueOf(sensorid) + "_statistics_" + yyyymm + ".csv";
        DataProcessor.newDirs(pathname);
        File file = new File(pathname, filename);
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            if (user.csvFieldSep == ';') {
                sb.append("Timestamp; Total Number of Charges; Total Avg. Current [mA]; Total Peak Current [mA]; Total Avg. Charging Time [s]; Total Avg. Waiting Time [s]\r\n");
            } else {
                sb.append("Timestamp, Total Number of Charges, Total Avg. Current [mA], Total Peak Current [mA], Total Avg. Charging Time [s], Total Avg. Waiting Time [s]\r\n");
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        sb.append(data.getLong(4));
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(5) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(6) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getLong(7));
        sb.append(user.csvFieldSep);
        sb.append(data.getLong(8));
        sb.append("\r\n");
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        fw.write(sb.toString());
        fw.close();
        if (newfile) {
            file.setWritable(true, false);
        }
    }

    private static void csStateToFile(int sensorid, ResultSet data) throws Exception {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        boolean newfile = false;
        String time = df.format(new Date(data.getTimestamp(2).getTime()));
        String yyyymm = time.substring(0, 7);
        String pathname = "userdata/devices/" + sensorid;
        String filename = String.valueOf(sensorid) + "_state_" + yyyymm + ".csv";
        DataProcessor.newDirs(pathname);
        File file = new File(pathname, filename);
        if (!file.isFile()) {
            newfile = true;
            sb.append(new String(user.BOM, "UTF-8"));
            if (user.csvFieldSep == ';') {
                sb.append("Timestamp;Plug;User Id;Instant. Charge Current [mA];Avg. Charge Current [mA]; Peak Charge Current [mA]; Charging Time [s]; Waiting Time [s]; 3-Phase; Main Power Failure; Recoverable Hardware Error; Unrecoverable Hardware Error; EV Lock Error; EV Disconnect Error; EV Current Exceeded; EV Control Pilot Error; EV Overheating; DOM Lock Error; DOM Current Exceeded; DOM Overheating; Other Errors\r\n");
            } else {
                sb.append("Timestamp,Plug,User Id,Instant. Charge Current [mA],Avg. Charge Current [mA], Peak Charge Current [mA], Charging Time [s], Waiting Time [s], 3-Phase, Main Power Failure, Recoverable Hardware Error, Unrecoverable Hardware Error, EV Lock Error, EV Disconnect Error, EV Current Exceeded, EV Control Pilot Error, EV Overheating, DOM Lock Error, DOM Current Exceeded, DOM Overheating, Other Errors\r\n");
            }
        }
        sb.append(time);
        sb.append(user.csvFieldSep);
        switch (data.getInt(4)) {
            case 0: {
                sb.append("EV");
                break;
            }
            case 1: {
                sb.append("DOM");
                break;
            }
            default: {
                sb.append("");
            }
        }
        sb.append(user.csvFieldSep);
        sb.append(data.getString(6));
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(7) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(8) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(9) * 10);
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(10));
        sb.append(user.csvFieldSep);
        sb.append(data.getInt(11));
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(12) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(13) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(14) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(15) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(16) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(17) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(18) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(19) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(20) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(21) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(22) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(23) ? "1" : "0");
        sb.append(user.csvFieldSep);
        sb.append(data.getBoolean(24) ? "1" : "0");
        sb.append("\r\n");
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        fw.write(sb.toString());
        fw.close();
        if (newfile) {
            file.setWritable(true, false);
        }
    }

    static String filterLoadNames(String name, boolean latin) throws Exception {
        Properties ptxt = new Properties();
        if (name.startsWith("RT 2012 [") && name.endsWith("]")) {
            String language = user.localeToId();
            HsycoFile f2 = new HsycoFile("www/big", "text_" + (latin && "cn gr pl ru".contains(language) ? "en" : language) + ".txt");
            ByteArrayInputStream bis = new ByteArrayInputStream(f2.getBytes());
            ptxt.load(bis);
            bis.close();
            switch (Integer.parseInt(name.substring(9, 10))) {
                case 1: {
                    return ptxt.getProperty("loadtypesheating");
                }
                case 2: {
                    return ptxt.getProperty("loadtypesairconditioning");
                }
                case 3: {
                    return ptxt.getProperty("loadtypeshotwater");
                }
                case 4: {
                    return ptxt.getProperty("loadtypeslighting");
                }
                case 5: {
                    return ptxt.getProperty("loadtypescooking");
                }
                case 6: {
                    return ptxt.getProperty("loadtypeswallsockets");
                }
            }
            throw new Exception();
        }
        return name;
    }

    private static void newDirs(String pathname) {
        String[] sa = pathname.split("/");
        File f2 = new File(".");
        int i2 = 0;
        while (i2 < sa.length) {
            f2 = new File(f2, sa[i2]);
            try {
                if (!f2.isDirectory()) {
                    f2.mkdir();
                }
                f2.setWritable(true, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    public static void fixTablesTimestamp() {
        try {
            long ctime;
            Calendar cal;
            ResultSet rs;
            long ltime = 0L;
            int rows = -1;
            boolean fixed = false;
            PreparedStatement psel = user.databaseConnection.prepareStatement("select groupid, loadid, lyear, lmonth, lday, lhour, lmin, ltime from endata where ltime > ? limit 1000");
            PreparedStatement pupd = user.databaseConnection.prepareStatement("update endata set ltime = ? where groupid = ? and loadid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = ?");
            while (rows != 0) {
                psel.setTimestamp(1, new Timestamp(ltime));
                rs = psel.executeQuery();
                rows = 0;
                while (rs.next()) {
                    ++rows;
                    cal = Calendar.getInstance();
                    cal.set(1, rs.getShort(3));
                    cal.set(2, rs.getShort(4) - 1);
                    cal.set(5, rs.getShort(5));
                    cal.set(11, rs.getShort(6));
                    cal.set(12, rs.getShort(7));
                    cal.set(13, 0);
                    cal.set(14, 0);
                    ltime = rs.getTimestamp(8).getTime();
                    ctime = cal.getTimeInMillis();
                    if (ltime - ctime <= 3600000L) continue;
                    pupd.setTimestamp(1, new Timestamp(ctime));
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setInt(3, rs.getInt(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    pupd.setShort(7, rs.getShort(6));
                    pupd.setShort(8, rs.getShort(7));
                    if (pupd.executeUpdate() == 1) {
                        fixed = true;
                        continue;
                    }
                    user.errorLog("DATAPROCESSOR/FIXTABLES: FAILED TO UPDATE [ENDATA]");
                }
                rs.close();
                user.databaseConnection.prepareStatement("checkpoint").execute();
            }
            if (fixed) {
                user.messageLog("DATAPROCESSOR/FIXTABLES: FIXED [ENDATA]");
            }
            ltime = 0L;
            rows = -1;
            fixed = false;
            psel = user.databaseConnection.prepareStatement("select sensorid, lyear, lmonth, lday, lhour, lmin, ltime from ensdata where ltime > ? limit 1000");
            pupd = user.databaseConnection.prepareStatement("update ensdata set ltime = ? where sensorid = ? and lyear = ? and lmonth = ? and lday = ? and  lhour = ? and lmin = ?");
            while (rows != 0) {
                psel.setTimestamp(1, new Timestamp(ltime));
                rs = psel.executeQuery();
                rows = 0;
                while (rs.next()) {
                    ++rows;
                    cal = Calendar.getInstance();
                    cal.set(1, rs.getShort(2));
                    cal.set(2, rs.getShort(3) - 1);
                    cal.set(5, rs.getShort(4));
                    cal.set(11, rs.getShort(5));
                    cal.set(12, rs.getShort(6));
                    cal.set(13, 0);
                    cal.set(14, 0);
                    ltime = rs.getTimestamp(7).getTime();
                    ctime = cal.getTimeInMillis();
                    if (ltime - ctime <= 3600000L) continue;
                    pupd.setTimestamp(1, new Timestamp(ctime));
                    pupd.setInt(2, rs.getInt(1));
                    pupd.setShort(3, rs.getShort(2));
                    pupd.setShort(4, rs.getShort(3));
                    pupd.setShort(5, rs.getShort(4));
                    pupd.setShort(6, rs.getShort(5));
                    pupd.setShort(7, rs.getShort(6));
                    if (pupd.executeUpdate() == 1) {
                        fixed = true;
                        continue;
                    }
                    user.errorLog("DATAPROCESSOR/FIXTABLES: FAILED TO UPDATE [ENSDATA]");
                }
                rs.close();
                user.databaseConnection.prepareStatement("checkpoint").execute();
            }
            if (fixed) {
                user.messageLog("DATAPROCESSOR/FIXTABLES: FIXED [ENSDATA]");
            }
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/FIXTABLES: EXCEPTION [" + e2 + "]");
        }
    }

    private static Timestamp newTimestamp(int year, int month, int day, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    static long reportEnergyDevices(int type, boolean cost, int from_year, int from_month, int from_day, int to_year, int to_month, int to_day, int period, long max_file_size, int[] devices) {
        File cfile;
        File efile;
        ResultSet rs;
        PreparedStatement pstmt;
        StringBuffer costheader;
        StringBuffer header;
        String tablename;
        int counter;
        DecimalFormat decimalformat;
        SimpleDateFormat df;
        Hashtable<Integer, Long> costdata;
        Hashtable<Integer, Long> data;
        Vector<Integer> ids;
        long periodmillis;
        block28: {
            periodmillis = (long)period * 60000L;
            ids = new Vector<Integer>();
            Hashtable<Integer, String> allnames = new Hashtable<Integer, String>();
            data = new Hashtable<Integer, Long>();
            costdata = new Hashtable<Integer, Long>();
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            decimalformat = new DecimalFormat("0.###");
            counter = 0;
            tablename = "undefined";
            header = new StringBuffer();
            costheader = new StringBuffer();
            String energycurrency = user.varGet("energycurrency!");
            if (period == 43200) {
                from_day = 1;
            }
            pstmt = user.databaseConnection.prepareStatement("select sensorid, name, loadid from sensors");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int loadid = rs.getInt(3);
                if (!(type == 2 && loadid >= -1 || type == 3 && loadid == -3) && (type != 4 || loadid != -4)) continue;
                allnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            header.append(new String(user.BOM, "UTF-8"));
            header.append("Timestamp");
            costheader.append(new String(user.BOM, "UTF-8"));
            costheader.append("Timestamp");
            int i2 = 0;
            while (i2 < devices.length) {
                if (allnames.containsKey(devices[i2])) {
                    ids.add(devices[i2]);
                    header.append(user.csvFieldSep);
                    header.append(devices[i2]);
                    header.append(": ");
                    header.append((String)allnames.get(devices[i2]));
                    header.append(type == 3 || type == 4 ? " [dm3]" : " [Wh]");
                    costheader.append(user.csvFieldSep);
                    costheader.append(devices[i2]);
                    costheader.append(": ");
                    costheader.append((String)allnames.get(devices[i2]));
                    costheader.append(" [" + energycurrency + "]");
                }
                ++i2;
            }
            if (ids.size() != 0) break block28;
            return 0L;
        }
        DataProcessor.newDirs("reportdata");
        switch (type) {
            case 2: {
                tablename = "ensdata";
                efile = new File("reportdata/report_energy_devices_electricity.csv");
                cfile = new File("reportdata/report_energy_devices_electricity_cost.csv");
                break;
            }
            case 3: {
                tablename = "ensdatawater";
                efile = new File("reportdata/report_energy_devices_water.csv");
                cfile = new File("reportdata/report_energy_devices_water_cost.csv");
                break;
            }
            case 4: {
                tablename = "ensdatagas";
                efile = new File("reportdata/report_energy_devices_gas.csv");
                cfile = new File("reportdata/report_energy_devices_gas_cost.csv");
                break;
            }
            default: {
                return 0L;
            }
        }
        try {
            BufferedWriter cfw;
            BufferedWriter efw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(efile, false), "UTF-8"));
            efw.write(header.toString());
            efw.write("\r\n");
            if (cost) {
                if (user.csvFieldSep != ',') {
                    decimalformat.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
                }
                cfw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cfile, false), "UTF-8"));
                cfw.write(costheader.toString());
                cfw.write("\r\n");
            } else {
                cfw = null;
            }
            pstmt = user.databaseConnection.prepareStatement("select sensorid, sum(meterhr) from " + tablename + " where ltime >= ? and ltime < ? group by sensorid", 1004, 1007);
            Calendar cal = Calendar.getInstance();
            cal.set(1, from_year);
            cal.set(2, from_month - 1);
            cal.set(5, from_day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long fromts = cal.getTimeInMillis();
            cal.set(1, to_year);
            cal.set(2, to_month - 1);
            cal.set(5, to_day);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long tots = cal.getTimeInMillis();
            long t1 = System.currentTimeMillis();
            long ts = fromts;
            while (ts < tots && !user.reportsKillSwitch) {
                cal.setTimeInMillis(ts);
                long tse = DataProcessor.timeMillisIncrement(ts, periodmillis);
                if (counter % 1000 == 0) {
                    user.uiSet("xreport.progress", "value", Long.toString(100L * (ts - fromts) / (tots - fromts)));
                    if (efile.length() + cfile.length() > max_file_size) {
                        user.uiSet("xreport.truncated", "flag", "true");
                        user.messageLog("DATAPROCESSOR/REPORT: FILE SIZE LIMIT EXCEEDED PROCESSING TABLE " + tablename.toUpperCase());
                        break;
                    }
                }
                ++counter;
                data.clear();
                costdata.clear();
                StringBuffer erow = new StringBuffer(df.format(cal.getTime()));
                StringBuffer crow = cost ? new StringBuffer(df.format(cal.getTime())) : null;
                long tso = ts;
                while (tso < tse) {
                    Calendar calo = Calendar.getInstance();
                    calo.setTimeInMillis(tso);
                    pstmt.setTimestamp(1, new Timestamp(tso));
                    pstmt.setTimestamp(2, new Timestamp(tso + 3600000L < tse ? tso + 3600000L : tse));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int k2 = rs.getInt(1);
                        long v = rs.getLong(2);
                        long c2 = CostRates.match(type, -1, calo.get(1), calo.get(2) + 1, calo.get(5), calo.get(11));
                        c2 = c2 < 0L ? -1L : v * c2;
                        Long v0 = (Long)data.get(k2);
                        if (v0 == null) {
                            data.put(k2, v);
                            costdata.put(k2, c2);
                            continue;
                        }
                        data.put(k2, v0 + v);
                        long c0 = (Long)costdata.get(k2);
                        if (c0 == 0L) continue;
                        costdata.put(k2, c2 == -1L ? -1L : c0 + c2);
                    }
                    tso += 3600000L;
                }
                int i3 = 0;
                while (i3 < ids.size()) {
                    int id = (Integer)ids.get(i3);
                    erow.append(user.csvFieldSep);
                    Long v = (Long)data.get(id);
                    if (v != null) {
                        erow.append(v);
                    }
                    if (cost) {
                        crow.append(user.csvFieldSep);
                        if (v != null) {
                            long c3 = (Long)costdata.get(id);
                            crow.append(c3 == -1L ? "0" : decimalformat.format((double)c3 / 1000000.0));
                        }
                    }
                    ++i3;
                }
                efw.write(String.valueOf(erow.toString()) + "\r\n");
                if (cost) {
                    cfw.write(String.valueOf(crow.toString()) + "\r\n");
                }
                ts = tse;
            }
            pstmt.close();
            long t2 = System.currentTimeMillis();
            efw.flush();
            efw.close();
            efile.setWritable(true, false);
            if (cost) {
                cfw.flush();
                cfw.close();
                cfile.setWritable(true, false);
            }
            user.uiSet("xreport.progress", "value", "100");
            user.messageLog("DATAPROCESSOR/REPORT: " + counter + " ROWS PROCESSED FROM TABLE " + tablename.toUpperCase() + " IN " + (t2 - t1) + " MILLIS");
            return cost ? efile.length() + cfile.length() : efile.length();
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/REPORT: EXCEPTION [" + e2 + "] PROCESSING TABLE " + tablename.toUpperCase());
            return -1L;
        }
    }

    static long reportEnergyLoads(boolean cost, int from_year, int from_month, int from_day, int to_year, int to_month, int to_day, int period, long max_file_size, int[] loads) {
        ResultSet rs;
        PreparedStatement pstmt;
        StringBuffer costheader;
        StringBuffer header;
        int counter;
        DecimalFormat decimalformat;
        SimpleDateFormat df;
        Hashtable<Integer, Long> costdata;
        Hashtable<Integer, Long> data;
        Vector<Integer> ids;
        long periodmillis;
        block26: {
            periodmillis = (long)period * 60000L;
            ids = new Vector<Integer>();
            Hashtable<Integer, String> allnames = new Hashtable<Integer, String>();
            data = new Hashtable<Integer, Long>();
            costdata = new Hashtable<Integer, Long>();
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            decimalformat = new DecimalFormat("0.###");
            counter = 0;
            header = new StringBuffer();
            costheader = new StringBuffer();
            String energycurrency = user.varGet("energycurrency!");
            if (period == 43200) {
                from_day = 1;
            }
            pstmt = user.databaseConnection.prepareStatement("select loadid, name from loads");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                allnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            allnames.put(-3, "Water");
            allnames.put(-4, "Gas");
            header.append(new String(user.BOM, "UTF-8"));
            header.append("Timestamp");
            costheader.append(new String(user.BOM, "UTF-8"));
            costheader.append("Timestamp");
            int i2 = 0;
            while (i2 < loads.length) {
                if (allnames.containsKey(loads[i2])) {
                    ids.add(loads[i2]);
                    header.append(user.csvFieldSep);
                    header.append(DataProcessor.filterLoadNames((String)allnames.get(loads[i2]), false));
                    header.append(loads[i2] == -3 || loads[i2] == -4 ? " [dm3]" : " [Wh]");
                    costheader.append(user.csvFieldSep);
                    costheader.append(DataProcessor.filterLoadNames((String)allnames.get(loads[i2]), false));
                    costheader.append(" [" + energycurrency + "]");
                }
                ++i2;
            }
            if (ids.size() != 0) break block26;
            return 0L;
        }
        try {
            BufferedWriter cfw;
            DataProcessor.newDirs("reportdata");
            File efile = new File("reportdata/report_energy_loads.csv");
            File cfile = new File("reportdata/report_energy_loads_cost.csv");
            BufferedWriter efw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(efile, false), "UTF-8"));
            efw.write(header.toString());
            efw.write("\r\n");
            if (cost) {
                if (user.csvFieldSep != ',') {
                    decimalformat.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
                }
                cfw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cfile, false), "UTF-8"));
                cfw.write(costheader.toString());
                cfw.write("\r\n");
            } else {
                cfw = null;
            }
            pstmt = user.databaseConnection.prepareStatement("select loadid, sum(meterhr) from endata where ltime >= ? and ltime < ? and groupid < 0 group by loadid", 1004, 1007);
            Calendar cal = Calendar.getInstance();
            cal.set(1, from_year);
            cal.set(2, from_month - 1);
            cal.set(5, from_day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long fromts = cal.getTimeInMillis();
            cal.set(1, to_year);
            cal.set(2, to_month - 1);
            cal.set(5, to_day);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long tots = cal.getTimeInMillis();
            long t1 = System.currentTimeMillis();
            long ts = fromts;
            while (ts < tots && !user.reportsKillSwitch) {
                cal.setTimeInMillis(ts);
                long tse = DataProcessor.timeMillisIncrement(ts, periodmillis);
                if (counter % 1000 == 0) {
                    user.uiSet("xreport.progress", "value", Long.toString(100L * (ts - fromts) / (tots - fromts)));
                    if (efile.length() + cfile.length() > max_file_size) {
                        user.uiSet("xreport.truncated", "flag", "true");
                        user.messageLog("DATAPROCESSOR/REPORT: FILE SIZE LIMIT EXCEEDED PROCESSING TABLE ENDATA (LOADS)");
                        break;
                    }
                }
                ++counter;
                data.clear();
                costdata.clear();
                StringBuffer erow = new StringBuffer(df.format(cal.getTime()));
                StringBuffer crow = cost ? new StringBuffer(df.format(cal.getTime())) : null;
                long tso = ts;
                while (tso < tse) {
                    Calendar calo = Calendar.getInstance();
                    calo.setTimeInMillis(tso);
                    pstmt.setTimestamp(1, new Timestamp(tso));
                    pstmt.setTimestamp(2, new Timestamp(tso + 3600000L < tse ? tso + 3600000L : tse));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int costratetype;
                        int k2 = rs.getInt(1);
                        long v = rs.getLong(2);
                        switch (k2) {
                            case -3: {
                                costratetype = 3;
                                break;
                            }
                            case -4: {
                                costratetype = 4;
                                break;
                            }
                            default: {
                                costratetype = 2;
                            }
                        }
                        long c2 = CostRates.match(costratetype, -1, calo.get(1), calo.get(2) + 1, calo.get(5), calo.get(11));
                        c2 = c2 < 0L ? -1L : v * c2;
                        Long v0 = (Long)data.get(k2);
                        if (v0 == null) {
                            data.put(k2, v);
                            costdata.put(k2, c2);
                            continue;
                        }
                        data.put(k2, v0 + v);
                        long c0 = (Long)costdata.get(k2);
                        if (c0 == 0L) continue;
                        costdata.put(k2, c2 == -1L ? -1L : c0 + c2);
                    }
                    tso += 3600000L;
                }
                int i3 = 0;
                while (i3 < ids.size()) {
                    int id = (Integer)ids.get(i3);
                    erow.append(user.csvFieldSep);
                    Long v = (Long)data.get(id);
                    if (v != null) {
                        erow.append(v);
                    }
                    if (cost) {
                        crow.append(user.csvFieldSep);
                        if (v != null) {
                            long c3 = (Long)costdata.get(id);
                            crow.append(c3 == -1L ? "0" : decimalformat.format((double)c3 / 1000000.0));
                        }
                    }
                    ++i3;
                }
                efw.write(String.valueOf(erow.toString()) + "\r\n");
                if (cost) {
                    cfw.write(String.valueOf(crow.toString()) + "\r\n");
                }
                ts = tse;
            }
            pstmt.close();
            long t2 = System.currentTimeMillis();
            efw.flush();
            efw.close();
            efile.setWritable(true, false);
            if (cost) {
                cfw.flush();
                cfw.close();
                cfile.setWritable(true, false);
            }
            user.uiSet("xreport.progress", "value", "100");
            user.messageLog("DATAPROCESSOR/REPORT: " + counter + " ROWS PROCESSED FROM TABLE ENDATA (LOADS) IN " + (t2 - t1) + " MILLIS");
            return cost ? efile.length() + cfile.length() : efile.length();
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/REPORT: EXCEPTION [" + e2 + "] PROCESSING TABLE ENDATA (LOADS)");
            return -1L;
        }
    }

    static long reportEnergyGroups(int type, boolean cost, int from_year, int from_month, int from_day, int to_year, int to_month, int to_day, int period, long max_file_size, int[] groups) {
        File cfile;
        File efile;
        ResultSet rs;
        PreparedStatement pstmt;
        StringBuffer costheader;
        StringBuffer header;
        boolean nodata;
        int counter;
        DecimalFormat decimalformat;
        SimpleDateFormat df;
        Hashtable<Integer, Long> costdata;
        Hashtable<Integer, Long> data;
        Vector<Integer> ids;
        long periodmillis;
        block30: {
            periodmillis = (long)period * 60000L;
            ids = new Vector<Integer>();
            Hashtable<Integer, String> allnames = new Hashtable<Integer, String>();
            data = new Hashtable<Integer, Long>();
            costdata = new Hashtable<Integer, Long>();
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            decimalformat = new DecimalFormat("0.###");
            counter = 0;
            nodata = true;
            header = new StringBuffer();
            costheader = new StringBuffer();
            String energycurrency = user.varGet("energycurrency!");
            if (period == 43200) {
                from_day = 1;
            }
            pstmt = user.databaseConnection.prepareStatement("select groupid, name from groups");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                allnames.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            header.append(new String(user.BOM, "UTF-8"));
            header.append("Timestamp");
            costheader.append(new String(user.BOM, "UTF-8"));
            costheader.append("Timestamp");
            int i2 = 0;
            while (i2 < groups.length) {
                if (allnames.containsKey(groups[i2])) {
                    ids.add(groups[i2]);
                    header.append(user.csvFieldSep);
                    header.append((String)allnames.get(groups[i2]));
                    header.append(type == 3 || type == 4 ? " [dm3]" : " [Wh]");
                    costheader.append(user.csvFieldSep);
                    costheader.append((String)allnames.get(groups[i2]));
                    costheader.append(" [" + energycurrency + "]");
                }
                ++i2;
            }
            if (ids.size() != 0) break block30;
            return 0L;
        }
        DataProcessor.newDirs("reportdata");
        switch (type) {
            case 2: {
                pstmt = user.databaseConnection.prepareStatement("select groupid, sum(meterhr) from endata where ltime >= ? and ltime < ? and loadid >= -1 group by groupid", 1004, 1007);
                efile = new File("reportdata/report_energy_groups_electricity.csv");
                cfile = new File("reportdata/report_energy_groups_electricity_cost.csv");
                break;
            }
            case 3: {
                pstmt = user.databaseConnection.prepareStatement("select groupid, sum(meterhr) from endata where ltime >= ? and ltime < ? and loadid = -3 group by groupid", 1004, 1007);
                efile = new File("reportdata/report_energy_groups_water.csv");
                cfile = new File("reportdata/report_energy_groups_water_cost.csv");
                break;
            }
            case 4: {
                pstmt = user.databaseConnection.prepareStatement("select groupid, sum(meterhr) from endata where ltime >= ? and ltime < ? and loadid = -4 group by groupid", 1004, 1007);
                efile = new File("reportdata/report_energy_groups_gas.csv");
                cfile = new File("reportdata/report_energy_groups_gas_cost.csv");
                break;
            }
            default: {
                return 0L;
            }
        }
        try {
            BufferedWriter cfw;
            BufferedWriter efw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(efile, false), "UTF-8"));
            efw.write(header.toString());
            efw.write("\r\n");
            if (cost) {
                if (user.csvFieldSep != ',') {
                    decimalformat.setDecimalFormatSymbols(new DecimalFormatSymbols(user.locale));
                }
                cfw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cfile, false), "UTF-8"));
                cfw.write(costheader.toString());
                cfw.write("\r\n");
            } else {
                cfw = null;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, from_year);
            cal.set(2, from_month - 1);
            cal.set(5, from_day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long fromts = cal.getTimeInMillis();
            cal.set(1, to_year);
            cal.set(2, to_month - 1);
            cal.set(5, to_day);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            long tots = cal.getTimeInMillis();
            long t1 = System.currentTimeMillis();
            long ts = fromts;
            while (ts < tots && !user.reportsKillSwitch) {
                cal.setTimeInMillis(ts);
                long tse = DataProcessor.timeMillisIncrement(ts, periodmillis);
                if (counter % 1000 == 0) {
                    user.uiSet("xreport.progress", "value", Long.toString(100L * (ts - fromts) / (tots - fromts)));
                    if (efile.length() + cfile.length() > max_file_size) {
                        user.uiSet("xreport.truncated", "flag", "true");
                        user.messageLog("DATAPROCESSOR/REPORT: FILE SIZE LIMIT EXCEEDED PROCESSING TABLE ENDATA (GROUPS)");
                        break;
                    }
                }
                ++counter;
                data.clear();
                costdata.clear();
                StringBuffer erow = new StringBuffer(df.format(cal.getTime()));
                StringBuffer crow = cost ? new StringBuffer(df.format(cal.getTime())) : null;
                long tso = ts;
                while (tso < tse) {
                    Calendar calo = Calendar.getInstance();
                    calo.setTimeInMillis(tso);
                    pstmt.setTimestamp(1, new Timestamp(tso));
                    pstmt.setTimestamp(2, new Timestamp(tso + 3600000L < tse ? tso + 3600000L : tse));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int k2 = rs.getInt(1);
                        long v = rs.getLong(2);
                        long c2 = CostRates.match(type, -1, calo.get(1), calo.get(2) + 1, calo.get(5), calo.get(11));
                        c2 = c2 < 0L ? -1L : v * c2;
                        Long v0 = (Long)data.get(k2);
                        if (v0 == null) {
                            data.put(k2, v);
                            costdata.put(k2, c2);
                            continue;
                        }
                        data.put(k2, v0 + v);
                        long c0 = (Long)costdata.get(k2);
                        if (c0 == 0L) continue;
                        costdata.put(k2, c2 == -1L ? -1L : c0 + c2);
                    }
                    tso += 3600000L;
                }
                int i3 = 0;
                while (i3 < ids.size()) {
                    int id = (Integer)ids.get(i3);
                    erow.append(user.csvFieldSep);
                    Long v = (Long)data.get(id);
                    if (v != null) {
                        nodata = false;
                        erow.append(v);
                    }
                    if (cost) {
                        crow.append(user.csvFieldSep);
                        if (v != null) {
                            long c3 = (Long)costdata.get(id);
                            crow.append(c3 == -1L ? "0" : decimalformat.format((double)c3 / 1000000.0));
                        }
                    }
                    ++i3;
                }
                efw.write(String.valueOf(erow.toString()) + "\r\n");
                if (cost) {
                    cfw.write(String.valueOf(crow.toString()) + "\r\n");
                }
                ts = tse;
            }
            pstmt.close();
            long t2 = System.currentTimeMillis();
            efw.flush();
            efw.close();
            efile.setWritable(true, false);
            if (nodata) {
                efile.delete();
            }
            if (cost) {
                cfw.flush();
                cfw.close();
                cfile.setWritable(true, false);
                if (nodata) {
                    cfile.delete();
                }
            }
            user.uiSet("xreport.progress", "value", "100");
            user.messageLog("DATAPROCESSOR/REPORT: " + counter + " ROWS PROCESSED FROM TABLE ENDATA (GROUPS) IN " + (t2 - t1) + " MILLIS");
            return cost ? efile.length() + cfile.length() : efile.length();
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/REPORT: EXCEPTION [" + e2 + "] PROCESSING TABLE ENDATA (GROUPS)");
            return -1L;
        }
    }

    static long reportChargingDevices(int from_year, int from_month, int from_day, int to_year, int to_month, int to_day, long max_file_size, int[] devices) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int counter = 0;
        long filelength = 0L;
        long ts = 0L;
        try {
            DataProcessor.newDirs("reportdata");
            long t1 = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < devices.length && !user.reportsKillSwitch) {
                File file = new File("reportdata/report_charge_device_" + devices[i2] + ".csv");
                StringBuffer header = new StringBuffer();
                header.append(new String(user.BOM, "UTF-8"));
                if (user.csvFieldSep == ';') {
                    header.append("Timestamp;Charge Id;Plug;User Id;Plug IN Date;Plug OUT Date; Avg. Charge Current [mA]; Peak Charge Current [mA]; Charging Time [s]; Waiting Time [s]");
                } else {
                    header.append("Timestamp,Charge Id,Plug,User Id,Plug IN Date,Plug OUT Date, Avg. Charge Current [mA], Peak Charge Current [mA], Charging Time [s], Waiting Time [s]");
                }
                BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
                fw.write(header.toString());
                fw.write("\r\n");
                Calendar cal = Calendar.getInstance();
                cal.set(1, from_year);
                cal.set(2, from_month - 1);
                cal.set(5, from_day);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                long fromts = cal.getTimeInMillis();
                cal.set(1, to_year);
                cal.set(2, to_month - 1);
                cal.set(5, to_day);
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                long tots = cal.getTimeInMillis();
                counter = 0;
                boolean more = true;
                user.uiSet("xreport.progress", "value", Integer.toString(100 * (i2 + 1) / devices.length));
                while (more && !user.reportsKillSwitch) {
                    PreparedStatement pstmt = user.databaseConnection.prepareStatement("select seq, time, side, plug, chargeid, userid, intime, outtime, avgcurrent, peakcurrent, chgtime, waittime from cscharges where sensorid = ? and time >= ? and time < ? order by seq limit 1000");
                    pstmt.setInt(1, devices[i2]);
                    pstmt.setTimestamp(2, new Timestamp(fromts));
                    pstmt.setTimestamp(3, new Timestamp(tots));
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (counter % 1000 == 0 && filelength + file.length() > max_file_size) {
                            user.uiSet("xreport.truncated", "flag", "true");
                            user.messageLog("DATAPROCESSOR/REPORT: FILE SIZE LIMIT EXCEEDED PROCESSING TABLE CSCHARGES");
                            break;
                        }
                        ++counter;
                        StringBuffer row = new StringBuffer();
                        ts = rs.getTimestamp(2).getTime();
                        row.append(df.format(ts));
                        row.append(user.csvFieldSep);
                        row.append(rs.getLong(5));
                        row.append(user.csvFieldSep);
                        row.append(rs.getInt(4) == 0 ? "EV" : "DOM");
                        row.append(user.csvFieldSep);
                        row.append(rs.getString(6));
                        row.append(user.csvFieldSep);
                        row.append(df.format(new Date(rs.getTimestamp(7).getTime())));
                        row.append(user.csvFieldSep);
                        row.append(df.format(new Date(rs.getTimestamp(8).getTime())));
                        row.append(user.csvFieldSep);
                        row.append(rs.getInt(9) * 10);
                        row.append(user.csvFieldSep);
                        row.append(rs.getInt(10) * 10);
                        row.append(user.csvFieldSep);
                        row.append(rs.getInt(11));
                        row.append(user.csvFieldSep);
                        row.append(rs.getInt(12));
                        row.append("\r\n");
                        fw.write(row.toString());
                    }
                    if (rs.getFetchSize() == 1000) {
                        fromts = ts + 1L;
                    } else {
                        more = false;
                    }
                    pstmt.close();
                    long t2 = System.currentTimeMillis();
                    fw.flush();
                    fw.close();
                    file.setWritable(true, false);
                    user.messageLog("DATAPROCESSOR/REPORT: " + counter + " ROWS PROCESSED FROM TABLE CSCHARGES IN " + (t2 - t1) + " MILLIS");
                    filelength += file.length();
                }
                ++i2;
            }
            user.uiSet("xreport.progress", "value", "100");
            return filelength;
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/REPORT: EXCEPTION [" + e2 + "] PROCESSING TABLE CSCHARGES");
            return -1L;
        }
    }

    public static void breakers() {
        Vector<Integer> ids = new Vector<Integer>();
        Vector<String> names = new Vector<String>();
        File existingfile = null;
        StringBuffer sb = new StringBuffer();
        boolean newfile = false;
        int fileidx = 0;
        long t = System.currentTimeMillis();
        try {
            File file;
            int id;
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select sensorid, modelid, name from sensors where  enabled = true order by sensorid");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int modelid = rs.getInt(2);
                switch (modelid) {
                    case 20: 
                    case 21: 
                    case 42: {
                        ids.add(rs.getInt(1));
                        names.add(rs.getString(3));
                    }
                }
            }
            rs.close();
            if (ids.size() == 0) {
                user.messageLog("PROFILING: DATAPROCESSOR/STATES/1 [" + (System.currentTimeMillis() - t) + "]");
                return;
            }
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
            String yyyymm = time.substring(0, 7);
            String pathname = "userdata/states";
            String basefilename = "states_" + yyyymm;
            DataProcessor.newDirs(pathname);
            sb.append(new String(user.BOM, "UTF-8"));
            sb.append("Timestamp");
            int i2 = 0;
            while (i2 < ids.size()) {
                id = (Integer)ids.get(i2);
                sb.append(user.csvFieldSep);
                sb.append(id);
                sb.append(": ");
                sb.append((String)names.get(i2));
                ++i2;
            }
            String header = sb.toString();
            while ((file = new File(pathname, String.valueOf(basefilename) + (fileidx > 0 ? "_" + fileidx + ".csv" : ".csv"))).isFile()) {
                existingfile = file;
                ++fileidx;
            }
            if (existingfile == null) {
                newfile = true;
            } else {
                BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(existingfile), "UTF-8"));
                String h2 = fr.readLine();
                fr.close();
                if (header.equals(h2)) {
                    file = existingfile;
                    newfile = false;
                } else {
                    newfile = true;
                }
            }
            BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            if (newfile) {
                fw.write(header);
                fw.write("\r\n");
            }
            fw.write(time);
            i = 0;
            while (i < ids.size()) {
                Integer state;
                id = (Integer)ids.get(i);
                SensorCache sensor = Polling.sensorCache.get(id);
                fw.write(user.csvFieldSep);
                if (sensor != null && (state = sensor.breakerstate) != null) {
                    switch (state) {
                        case 0: {
                            fw.write("OPEN");
                            break;
                        }
                        case 1: {
                            fw.write("CLOSE");
                            break;
                        }
                        case -1: {
                            fw.write("TRIPPED");
                        }
                    }
                }
                ++i;
            }
            fw.write("\r\n");
            fw.close();
            if (newfile) {
                file.setWritable(true, false);
            }
        }
        catch (Exception e2) {
            user.errorLog("DATAPROCESSOR/STATES: EXCEPTION [" + e2 + "]");
        }
        user.messageLog("PROFILING: DATAPROCESSOR/STATES/2 [" + (System.currentTimeMillis() - t) + "]");
    }

    private static long timeMillisIncrement(long time, long incrementmillis) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        if (incrementmillis == 86400000L) {
            cal.add(6, 1);
        } else if (incrementmillis == 2592000000L) {
            cal.add(2, 1);
        } else {
            cal.add(13, (int)(incrementmillis / 1000L));
        }
        return cal.getTimeInMillis();
    }
}

