/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DX3 {
    public static Integer readBreakerState(String gateway, int unitid) {
        byte[] data = user.modbusReadDiscreteInputs(gateway, unitid, 16384, 2);
        if (data.length == 3) {
            switch (data[2] & 3) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return null;
        }
        return null;
    }

    public static byte[] readVIF(String gateway, int unitid) {
        byte[] byArray = new byte[4];
        byArray[2] = -128;
        byte[] np = byArray;
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20480, 3);
        byte[] data1 = user.modbusReadInputRegisters(gateway, unitid, 20483, 1);
        byte[] data2 = user.modbusReadInputRegisters(gateway, unitid, 20494, 3);
        byte[] data3 = user.modbusReadInputRegisters(gateway, unitid, 20497, 3);
        byte[] data4 = user.modbusReadInputRegisters(gateway, unitid, 20529, 1);
        byte[] data6 = user.modbusReadInputRegisters(gateway, unitid, 20485, 1);
        if (data6.length != 4) {
            data6 = np;
        }
        if (data1.length == 4 && data2.length == 8 && data3.length == 8 && data4.length == 4) {
            ByteBuffer bb = ByteBuffer.allocate(24);
            bb.put(data, 2, 6);
            bb.put(data1, 2, 2);
            bb.put(data2, 2, 6);
            bb.put(data3, 2, 6);
            bb.put(data4, 2, 2);
            bb.put(data6, 2, 2);
            return bb.array();
        }
        if (data1.length == 4) {
            ByteBuffer bb = ByteBuffer.allocate(10);
            bb.put(data, 2, 6);
            bb.put(data1, 2, 2);
            bb.put(data6, 2, 2);
            return bb.array();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(data, 2, 6);
        bb.put(data6, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            switch (data.length) {
                case 8: {
                    values.put("I1", DX3.toInteger(data, 0));
                    values.put("I2", DX3.toInteger(data, 2));
                    values.put("I3", DX3.toInteger(data, 4));
                    values.put("Id", DX3.toInteger(data, 6));
                    break;
                }
                case 10: {
                    values.put("I1", DX3.toInteger(data, 0));
                    values.put("I2", DX3.toInteger(data, 2));
                    values.put("I3", DX3.toInteger(data, 4));
                    values.put("In", DX3.toInteger(data, 6));
                    values.put("Id", DX3.toInteger(data, 8));
                    break;
                }
                case 24: {
                    values.put("I1", DX3.toInteger(data, 0));
                    values.put("I2", DX3.toInteger(data, 2));
                    values.put("I3", DX3.toInteger(data, 4));
                    values.put("In", DX3.toInteger(data, 6));
                    values.put("V1", DX3.toInteger(data, 8));
                    values.put("V2", DX3.toInteger(data, 10));
                    values.put("V3", DX3.toInteger(data, 12));
                    values.put("U12", DX3.toInteger(data, 14));
                    values.put("U31", DX3.toInteger(data, 16));
                    values.put("U23", DX3.toInteger(data, 18));
                    values.put("F", DX3.toInteger(data, 20));
                    values.put("Id", DX3.toInteger(data, 22));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            switch (data.length) {
                case 8: {
                    values.put("I1", DX3.toIntegerString(data, 0, 4, 0, false));
                    values.put("I2", DX3.toIntegerString(data, 2, 4, 0, false));
                    values.put("I3", DX3.toIntegerString(data, 4, 4, 0, false));
                    values.put("Id", DX3.toIntegerString(data, 6, 4, 0, true));
                    break;
                }
                case 10: {
                    values.put("I1", DX3.toIntegerString(data, 0, 4, 0, false));
                    values.put("I2", DX3.toIntegerString(data, 2, 4, 0, false));
                    values.put("I3", DX3.toIntegerString(data, 4, 4, 0, false));
                    values.put("In", DX3.toIntegerString(data, 6, 4, 0, false));
                    values.put("Id", DX3.toIntegerString(data, 8, 4, 0, true));
                    break;
                }
                case 24: {
                    values.put("I1", DX3.toIntegerString(data, 0, 4, 0, false));
                    values.put("I2", DX3.toIntegerString(data, 2, 4, 0, false));
                    values.put("I3", DX3.toIntegerString(data, 4, 4, 0, false));
                    values.put("In", DX3.toIntegerString(data, 6, 4, 0, false));
                    values.put("V1", DX3.toIntegerString(data, 8, 4, 0, false));
                    values.put("V2", DX3.toIntegerString(data, 10, 4, 0, false));
                    values.put("V3", DX3.toIntegerString(data, 12, 4, 0, false));
                    values.put("U12", DX3.toIntegerString(data, 14, 4, 0, false));
                    values.put("U31", DX3.toIntegerString(data, 16, 4, 0, false));
                    values.put("U23", DX3.toIntegerString(data, 18, 4, 0, false));
                    values.put("F", DX3.toIntegerString(data, 20, 4, 2, false));
                    values.put("Id", DX3.toIntegerString(data, 22, 4, 0, true));
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(6);
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20522, 2);
            if (inverted) {
                int i2 = 2;
                while (i2 < 6) {
                    int v = -DX3.decodeInteger(data, i2, 2, true).intValue();
                    data[i2] = (byte)(v >>> 8);
                    data[i2 + 1] = (byte)v;
                    i2 += 2;
                }
            }
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, 20527, 1);
            bb.put(data, 2, 2);
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Integer> decodePower(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("P", DX3.toIntegerSigned(data, 0));
            values.put("Q", DX3.toIntegerSigned(data, 2));
            values.put("PF", DX3.toIntegerSigned(data, 4));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = DX3.decodePower(data);
            values.put("P", DX3.toLongString(decoded.get("P"), 4, 0, true));
            values.put("Q", DX3.toLongString(decoded.get("Q"), 4, 0, true));
            values.put("PF", DX3.toLongString(decoded.get("PF"), 4, 2, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHD(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20512, 7);
        return bb.put(data, 2, 14).array();
    }

    public static Hashtable<String, Integer> decodeTHD(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("THDI1", DX3.toInteger(data, 0) * 10);
            values.put("THDI2", DX3.toInteger(data, 2) * 10);
            values.put("THDI3", DX3.toInteger(data, 4) * 10);
            values.put("THDIn", DX3.toInteger(data, 6) * 10);
            values.put("THDV1", DX3.toInteger(data, 8) * 10);
            values.put("THDV2", DX3.toInteger(data, 10) * 10);
            values.put("THDV3", DX3.toInteger(data, 12) * 10);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHD(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("THDI1", DX3.toIntegerString(data, 0, 3, 0, true));
            values.put("THDI2", DX3.toIntegerString(data, 2, 3, 0, true));
            values.put("THDI3", DX3.toIntegerString(data, 4, 3, 0, true));
            values.put("THDIn", DX3.toIntegerString(data, 6, 3, 0, true));
            values.put("THDV1", DX3.toIntegerString(data, 8, 3, 0, true));
            values.put("THDV2", DX3.toIntegerString(data, 10, 3, 0, true));
            values.put("THDV3", DX3.toIntegerString(data, 12, 3, 0, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean chechTHD(byte[] data) {
        try {
            return DX3.toInteger(data, 14) >= 80 || DX3.toInteger(data, 16) >= 80 || DX3.toInteger(data, 18) >= 80;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readEnergyPos(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] byArray = new byte[6];
        byArray[2] = -128;
        byte[] np = byArray;
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20534 : 20532, 2);
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20540 : 20538, 2);
            bb.put(data.length == 6 ? data : np, 2, 4);
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Long> decodeEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", (long)DX3.toLong(data, 0) * 1000L);
            values.put("Er", (long)DX3.toLong(data, 4) * 1000L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = DX3.decodeEnergyPos(data);
            values.put("Ea", DX3.toLongString(decoded.get("Ea")));
            values.put("Er", DX3.toLongString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNeg(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] byArray = new byte[6];
        byArray[2] = -128;
        byte[] np = byArray;
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20532 : 20534, 2);
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20538 : 20540, 2);
            bb.put(data.length == 6 ? data : np, 2, 4);
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Long> decodeEnergyNeg(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea-", (long)DX3.toLong(data, 0) * 1000L);
            values.put("Er-", (long)DX3.toLong(data, 4) * 1000L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNeg(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = DX3.decodeEnergyNeg(data);
            values.put("Ea-", DX3.toLongString(decoded.get("Ea-")));
            values.put("Er-", DX3.toLongString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    private static int toLong(byte[] data, int index) {
        return DX3.decodeInteger(data, index, 4, false).intValue();
    }

    public static int toInteger(byte[] data, int index) {
        return DX3.decodeInteger(data, index, 2, false).intValue();
    }

    private static int toIntegerSigned(byte[] data, int index) {
        return DX3.decodeInteger(data, index, 2, true).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        if (data[index] == -128 && data[index + 1] == 0 && data[index + 2] == 0 && data[index + 3] == 0) {
            return "";
        }
        return Long.toString(DX3.decodeInteger(data, index, 4, signed).longValue());
    }

    private static String toLongString(int val, int digits, int decimals, boolean signed) {
        if (signed && val == Integer.MIN_VALUE) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static String toLongString(long val) {
        if (val == -2147483648000L) {
            return "";
        }
        return Long.toString(val);
    }

    public static String toIntegerString(byte[] data, int index, int scale) {
        if (data[index] == -128 && data[index + 1] == 0) {
            return "";
        }
        return Integer.toString(DX3.decodeInteger(data, index, 2, false).intValue() * scale);
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, boolean signed) {
        int val = DX3.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == -128 && data[index + 1] == 0) {
            return "";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                if ((d2[0] & 0xFFFFFF80) != 0) {
                    d2[0] = (byte)(d2[0] & 0x7F);
                    return new BigInteger(-1, d2);
                }
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

