/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMX3 {
    public static Integer readBreakerState(String gateway, int unitid) {
        SensorCache sensor = Polling.searchSensorCache(gateway, unitid);
        byte[] data = user.modbusReadDiscreteInputs(gateway, unitid, 16384, 3);
        if (data.length == 3) {
            if (sensor != null && sensor.originalmodelid == 191) {
                if ((data[2] & 1) != 0) {
                    return -1;
                }
                switch (data[2] & 6) {
                    case 4: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return null;
            }
            if ((data[2] & 4) != 0) {
                return -1;
            }
            switch (data[2] & 3) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return null;
        }
        return null;
    }

    public static byte[] readVIF(String gateway, int unitid) {
        byte[] byArray = new byte[4];
        byArray[2] = -128;
        byte[] np = byArray;
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20480, 4);
        byte[] data2 = user.modbusReadInputRegisters(gateway, unitid, 20489, 6);
        byte[] data3 = user.modbusReadInputRegisters(gateway, unitid, 20503, 1);
        byte[] data4 = user.modbusReadInputRegisters(gateway, unitid, 20484, 1);
        byte[] data5 = user.modbusReadInputRegisters(gateway, unitid, 20485, 1);
        if (data4.length != 4) {
            data4 = np;
        }
        if (data5.length != 4) {
            data5 = np;
        }
        if (data2.length == 14 || data3.length == 4) {
            ByteBuffer bb = ByteBuffer.allocate(26);
            bb.put(data, 2, 8);
            bb.put(data2, 2, 12);
            bb.put(data3, 2, 2);
            bb.put(data4, 2, 2);
            bb.put(data5, 2, 2);
            return bb.array();
        }
        ByteBuffer bb = ByteBuffer.allocate(12);
        bb.put(data, 2, 8);
        bb.put(data4, 2, 2);
        bb.put(data5, 2, 2);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("I1", DMX3.toInteger(data, 0));
            values.put("I2", DMX3.toInteger(data, 2));
            values.put("I3", DMX3.toInteger(data, 4));
            values.put("In", DMX3.toInteger(data, 6));
            if (data.length == 26) {
                values.put("V1", DMX3.toInteger(data, 8));
                values.put("V2", DMX3.toInteger(data, 10));
                values.put("V3", DMX3.toInteger(data, 12));
                values.put("U12", DMX3.toInteger(data, 14));
                values.put("U31", DMX3.toInteger(data, 16));
                values.put("U23", DMX3.toInteger(data, 18));
                values.put("F", DMX3.toInteger(data, 20));
                values.put("Ig", DMX3.toInteger(data, 22));
                values.put("Id", DMX3.toInteger(data, 24));
            } else {
                values.put("Ig", DMX3.toInteger(data, 8));
                values.put("Id", DMX3.toInteger(data, 10));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("I1", DMX3.toIntegerString(data, 0, 4, 0, false));
            values.put("I2", DMX3.toIntegerString(data, 2, 4, 0, false));
            values.put("I3", DMX3.toIntegerString(data, 4, 4, 0, false));
            values.put("In", DMX3.toIntegerString(data, 6, 4, 0, false));
            if (data.length == 26) {
                values.put("V1", DMX3.toIntegerString(data, 8, 4, 0, false));
                values.put("V2", DMX3.toIntegerString(data, 10, 4, 0, false));
                values.put("V3", DMX3.toIntegerString(data, 12, 4, 0, false));
                values.put("U12", DMX3.toIntegerString(data, 14, 4, 0, false));
                values.put("U31", DMX3.toIntegerString(data, 16, 4, 0, false));
                values.put("U23", DMX3.toIntegerString(data, 18, 4, 0, false));
                values.put("F", DMX3.toIntegerString(data, 20, 4, 2, false));
                values.put("Ig", DMX3.toIntegerString(data, 22, 4, 0, false));
                values.put("Id", DMX3.toIntegerString(data, 24, 4, 0, false));
            } else {
                values.put("Ig", DMX3.toIntegerString(data, 8, 4, 0, false));
                values.put("Id", DMX3.toIntegerString(data, 10, 4, 0, false));
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(32);
        try {
            int v;
            int i2;
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20499, 4);
            if (inverted) {
                i2 = 2;
                while (i2 < 6) {
                    v = -DMX3.decodeInteger(data, i2, 2, true).intValue();
                    data[i2] = (byte)(v >>> 8);
                    data[i2 + 1] = (byte)v;
                    i2 += 2;
                }
            }
            bb.put(data, 2, 8);
            data = user.modbusReadInputRegisters(gateway, unitid, 20514, 12);
            if (inverted) {
                i2 = 2;
                while (i2 < 14) {
                    v = -DMX3.decodeInteger(data, i2, 2, true).intValue();
                    data[i2] = (byte)(v >>> 8);
                    data[i2 + 1] = (byte)v;
                    i2 += 2;
                }
            }
            bb.put(data, 2, 24);
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Integer> decodePower(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("P", DMX3.toIntegerSigned(data, 0));
            values.put("Q", DMX3.toIntegerSigned(data, 2));
            values.put("S", DMX3.toIntegerSigned(data, 4));
            values.put("PF", DMX3.toIntegerSigned(data, 6));
            values.put("P1", DMX3.toIntegerSigned(data, 8));
            values.put("P2", DMX3.toIntegerSigned(data, 10));
            values.put("P3", DMX3.toIntegerSigned(data, 12));
            values.put("Q1", DMX3.toIntegerSigned(data, 14));
            values.put("Q2", DMX3.toIntegerSigned(data, 16));
            values.put("Q3", DMX3.toIntegerSigned(data, 18));
            values.put("S1", DMX3.toIntegerSigned(data, 20));
            values.put("S2", DMX3.toIntegerSigned(data, 22));
            values.put("S3", DMX3.toIntegerSigned(data, 24));
            values.put("PF1", DMX3.toIntegerSigned(data, 26));
            values.put("PF2", DMX3.toIntegerSigned(data, 28));
            values.put("PF3", DMX3.toIntegerSigned(data, 30));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Integer> decoded = DMX3.decodePower(data);
            values.put("P", DMX3.toLongString(decoded.get("P"), 4, 0, true));
            values.put("Q", DMX3.toLongString(decoded.get("Q"), 4, 0, true));
            values.put("S", DMX3.toLongString(decoded.get("S"), 4, 0, true));
            values.put("PF", DMX3.toLongString(decoded.get("PF"), 4, 2, true));
            values.put("P1", DMX3.toLongString(decoded.get("P1"), 4, 0, true));
            values.put("P2", DMX3.toLongString(decoded.get("P2"), 4, 0, true));
            values.put("P3", DMX3.toLongString(decoded.get("P3"), 4, 0, true));
            values.put("Q1", DMX3.toLongString(decoded.get("Q1"), 4, 0, true));
            values.put("Q2", DMX3.toLongString(decoded.get("Q2"), 4, 0, true));
            values.put("Q3", DMX3.toLongString(decoded.get("Q3"), 4, 0, true));
            values.put("S1", DMX3.toLongString(decoded.get("S1"), 4, 0, true));
            values.put("S2", DMX3.toLongString(decoded.get("S2"), 4, 0, true));
            values.put("S3", DMX3.toLongString(decoded.get("S3"), 4, 0, true));
            values.put("PF1", DMX3.toLongString(decoded.get("PF1"), 4, 2, true));
            values.put("PF2", DMX3.toLongString(decoded.get("PF2"), 4, 2, true));
            values.put("PF3", DMX3.toLongString(decoded.get("PF3"), 4, 2, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] NA = new byte[]{-124};
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20506 : 20504, 2);
            if (data[0] == -124) {
                return NA;
            }
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20510 : 20508, 2);
            if (data[0] == -124) {
                return NA;
            }
            bb.put(data, 2, 4);
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Long> decodeEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", (long)DMX3.toLong(data, 0) * 1000L);
            values.put("Er", (long)DMX3.toLong(data, 4) * 1000L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = DMX3.decodeEnergyPos(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            values.put("Er", Long.toString(decoded.get("Er")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNeg(String gateway, int unitid, boolean inverted) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] NA = new byte[]{-124};
        try {
            byte[] data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20504 : 20506, 2);
            if (data[0] == -124) {
                return NA;
            }
            bb.put(data, 2, 4);
            data = user.modbusReadInputRegisters(gateway, unitid, inverted ? 20508 : 20510, 2);
            if (data[0] == -124) {
                return NA;
            }
            bb.put(data, 2, 4);
            return bb.array();
        }
        catch (Exception e2) {
            return new byte[0];
        }
    }

    public static Hashtable<String, Long> decodeEnergyNeg(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea-", (long)DMX3.toLong(data, 0) * 1000L);
            values.put("Er-", (long)DMX3.toLong(data, 4) * 1000L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNeg(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = DMX3.decodeEnergyNeg(data);
            values.put("Ea-", Long.toString(decoded.get("Ea-")));
            values.put("Er-", Long.toString(decoded.get("Er-")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    private static int toLong(byte[] data, int index) {
        return DMX3.decodeInteger(data, index, 4, false).intValue();
    }

    private static int toInteger(byte[] data, int index) {
        return DMX3.decodeInteger(data, index, 2, false).intValue();
    }

    private static int toIntegerSigned(byte[] data, int index) {
        return DMX3.decodeInteger(data, index, 2, true).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        long val = DMX3.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "";
        }
        return Long.toString(val);
    }

    private static String toLongString(int val, int digits, int decimals, boolean signed) {
        if (signed && val == Integer.MAX_VALUE || !signed && val == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, boolean signed) {
        int val = DMX3.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == -128 && data[index + 1] == 0) {
            return "";
        }
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                if ((d2[0] & 0xFFFFFF80) != 0) {
                    d2[0] = (byte)(d2[0] & 0x7F);
                    return new BigInteger(-1, d2);
                }
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

