/*
 * Decompiled with CFR 0.152.
 */
package plugins.wolf8accessutil;

import com.hsyco.Configuration;
import com.hsyco.userBase;
import drivers.wolf8access.Driver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;

public class Utility
extends userBase {
    private static final String VERSION = "1.1.3";
    static final String PREFIX = "wolf8.";
    static final String PROJECTNAME = "wolf8accessutility";
    static final int DEFAULTLOGSIZE = 500;
    private static boolean initialized;
    private static String ioServerPrefix;
    private static HashMap<String, String> keys;
    private static boolean autoupdate;
    private static int peripheral;
    private static String[] sessions;
    private static int sessionIndex;
    private static File logFile;
    private static String logFilePath;
    private static Vector<String> logs;
    private static String logsVar;
    private static String lastLogVar;
    private static String mostRecentLog;
    private static int logSize;

    static {
        keys = new HashMap();
        autoupdate = false;
        peripheral = 0;
        sessions = new String[]{"", "", "", "", "", "", "", "", "", ""};
        sessionIndex = 0;
        logSize = 500;
    }

    public static void StartupEvent() {
        try {
            initialized = false;
            for (String io : Configuration.ioServers) {
                if (!"wolf8access".equalsIgnoreCase(Configuration.ioServersGetTypeByName(io))) continue;
                ioServerPrefix = String.valueOf(io) + ".";
            }
            if (ioServerPrefix == null) {
                Utility.uiSet(PROJECTNAME, "lock", "wolf8.noioserver");
                return;
            }
            int year = GregorianCalendar.getInstance().get(1);
            logFilePath = "logs/" + year + "/wolf-access.log";
            logFile = new File(logFilePath);
            Utility.uiSet("wolf8.key.edit.delete", "confirm", "true");
            Utility.uiSet("wolf8.search", "value", "");
            Utility.sleep(100L);
            Utility.uiSet("wolf8.search", "helptext", "search");
            Utility.uiSet(PROJECTNAME, "lock", "wolf8.loading");
            Utility.uiSet("wolf8.autodiscovery", "value", "false");
            Utility.readConfigurationFile();
            Utility.loadLogs();
            Utility.messageLog("wolf8accessutility - application started");
            Utility.uiSet("wolf8.version", "value", VERSION);
            initialized = true;
            Utility.messageLog("wolf8accessutility - initialization complete");
        }
        catch (Exception e2) {
            Utility.errorLog("wolf8accessutility - initialization error - " + e2.getMessage());
        }
    }

    public static void pageEvent(String address, String session, String userid, String project, String page) {
        if (project.equals(PROJECTNAME)) {
            Utility.addSession(session);
            if (page.equals("menu")) {
                Utility.uiSet("wolf8.search", "helptext", "search");
                Utility.uiSet("wolf8.autodiscovery", "value", String.valueOf(autoupdate));
                Utility.uiSet(session, "wolf8.module.select", "value", String.valueOf(peripheral + 1));
                Utility.guiUpdateSerialList(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void IOEvent(String id, String value) {
        if (ioServerPrefix == null || !id.startsWith(ioServerPrefix)) {
            return;
        }
        if ("connection".equals(id = id.substring(ioServerPrefix.length()))) {
            boolean online = "online".equals(value);
            Utility.uiSet(PROJECTNAME, "lock", online ? "" : "wolf8.loading");
            if (online) {
                Utility.uiSet(PROJECTNAME, "page", "menu");
                int maxPeriph = Driver.getMaxPeriph();
                String vals = "";
                int i2 = 1;
                while (i2 <= maxPeriph) {
                    vals = String.valueOf(vals) + "," + i2;
                    ++i2;
                }
                Utility.uiSet("wolf8.module.select", "values", vals.substring(1));
                Utility.uiSet("wolf8.module.select", "labels", vals.substring(1));
            }
        } else if (id.startsWith("p") && id.endsWith(".mem.ok")) {
            String[] fields = id.split("\\.");
            String p = fields[0].substring(1);
            Utility.ioSet(String.valueOf(ioServerPrefix) + "p" + p + ".mem", "read");
        } else if (id.startsWith("p") && id.endsWith(".key")) {
            String[] fields = id.split("\\.");
            String p = fields[0].substring(1);
            String serialNum = Utility.ioGet(String.valueOf(ioServerPrefix) + "p" + p + ".k" + value + ".sn");
            Utility.writeLogOnFile(p, serialNum);
        } else if (id.endsWith("sn") && autoupdate) {
            String[] fields = id.split("\\.");
            char p = fields[0].charAt(1);
            HashMap<String, String> hashMap = keys;
            synchronized (hashMap) {
                if (!keys.containsKey(String.valueOf(p) + ":" + value)) {
                    keys.put(String.valueOf(p) + ":" + value, "");
                    String[] stringArray = sessions;
                    int n2 = sessions.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String session = stringArray[n3];
                        Utility.guiUpdateSerialList(session);
                        ++n3;
                    }
                }
            }
        }
    }

    public static String userCommand(String session, String userId, String cmd, String param) {
        return Utility.userCommandOrSubmit(session, userId, cmd, param, null);
    }

    public static String userSubmit(String session, String userId, String cmd, HashMap<String, String> fields) {
        return Utility.userCommandOrSubmit(session, userId, cmd, null, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static String userCommandOrSubmit(String session, String userId, String cmd, String param, HashMap<String, String> fields) {
        block31: {
            try {
                if (!cmd.startsWith(PREFIX)) {
                    return null;
                }
                if (!initialized) {
                    return null;
                }
                Utility.addSession(session);
                if (param != null && param.endsWith("/close")) {
                    return "!";
                }
                if (cmd.equals("wolf8.keylist")) {
                    Utility.uiSet(session, "wolf8.keylist", "internal", param);
                    HashMap<String, String> hashMap = keys;
                    synchronized (hashMap) {
                        String name = keys.get(String.valueOf(peripheral) + ":" + param);
                        Utility.uiSet(session, "wolf8.device.edit.name", "value", name);
                    }
                    Utility.uiSet(session, "wolf8.device.edit.serial", "value", param);
                    Utility.uiSet(session, "wolf8.key.edit.delete", "visible", "true");
                    return "!page:wolf8.edit";
                }
                if (cmd.equals("wolf8.addkey")) {
                    Utility.uiSet(session, "wolf8.keylist", "internal", "");
                    Utility.uiSet(session, "wolf8.device.edit.serial", "value", "");
                    Utility.uiSet(session, "wolf8.device.edit.name", "value", "");
                    Utility.uiSet(session, "wolf8.key.edit.delete", "visible", "false");
                    return "!page:wolf8.edit";
                }
                if (cmd.equals("wolf8.key.edit.save")) {
                    String serial = fields.get("wolf8.device.edit.serial");
                    if (serial.isEmpty()) {
                        return "!error";
                    }
                    String name = fields.get("wolf8.device.edit.name");
                    boolean isNew = Utility.uiGet(session, "wolf8.keylist", "internal").isEmpty();
                    String old = Utility.uiGet(session, "wolf8.keylist", "internal");
                    HashMap<String, String> hashMap = keys;
                    synchronized (hashMap) {
                        if (isNew && keys.containsKey(String.valueOf(peripheral) + ":" + serial) || !isNew && keys.containsKey(String.valueOf(peripheral) + ":" + serial) && !serial.equals(old)) {
                            Utility.uiSet(session, "wolf8.warning.msg", "value", "Serial " + serial + " already present!");
                            return "!page:wolf8.warning";
                        }
                        String oldSerial = Utility.uiGet(session, "wolf8.keylist", "internal");
                        if (oldSerial != null) {
                            keys.remove(String.valueOf(peripheral) + ":" + oldSerial);
                        }
                        keys.put(String.valueOf(peripheral) + ":" + serial, name.replace("&#44;", ","));
                    }
                    Utility.guiUpdateSerialList(session);
                    return "!page:close";
                }
                if (cmd.equals("wolf8.warning.close")) {
                    return "!page:close";
                }
                if (cmd.equals("wolf8.module.select")) {
                    peripheral = Integer.parseInt(param) - 1;
                    Utility.guiUpdateSerialList(session);
                    return "!";
                }
                if (cmd.equals("wolf8.key.edit.delete")) {
                    String serial = Utility.uiGet(session, "wolf8.keylist", "internal");
                    HashMap<String, String> name = keys;
                    synchronized (name) {
                        keys.remove(String.valueOf(peripheral) + ":" + serial);
                    }
                    Utility.guiUpdateSerialList(session);
                    return "!page:close";
                }
                if (cmd.equals("wolf8.commit.yes")) {
                    Utility.writeConfigurationFile();
                    return "!page:close";
                }
                if (!cmd.equals("wolf8.autodiscovery")) break block31;
                Utility.uiSet("wolf8.autodiscovery", "value", param);
                autoupdate = Boolean.parseBoolean(param);
                if (autoupdate) {
                    int i2 = 0;
                    while (i2 < Driver.getMaxPeriph()) {
                        int j2 = 1;
                        while (j2 <= 250) {
                            String serial = Utility.ioGet(String.valueOf(ioServerPrefix) + "p" + i2 + ".k" + j2 + ".sn");
                            HashMap<String, String> hashMap = keys;
                            synchronized (hashMap) {
                                if (serial != null && !keys.containsKey(String.valueOf(i2) + ":" + j2)) {
                                    keys.put(String.valueOf(i2) + ":" + serial, "");
                                }
                            }
                            ++j2;
                        }
                        ++i2;
                    }
                    Utility.guiUpdateSerialList(session);
                    Utility.ioSet(String.valueOf(ioServerPrefix) + "p" + peripheral + ".mem", "read");
                }
                return "!";
            }
            catch (Exception e2) {
                Utility.errorLog("error processing command: " + cmd + " - " + e2.getLocalizedMessage());
                return "!error";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void guiUpdateSerialList(String session) {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        HashMap<String, String> hashMap = keys;
        synchronized (hashMap) {
            for (String key : keys.keySet()) {
                if (!key.startsWith(String.valueOf(peripheral))) continue;
                String s = key.substring(2);
                values.append("," + s);
                labels.append("," + s + "|" + keys.get(key));
            }
        }
        Utility.uiSet(session, "wolf8.keylist", "values", values.length() == 0 ? "" : values.substring(1));
        Utility.uiSet(session, "wolf8.keylist", "labels", labels.length() == 0 ? "" : labels.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfigurationFile() throws Exception {
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("wolf8access-config_" + ioServerPrefix + "ini.tmp"), Charset.forName("UTF-8")));
                HashMap<String, String> hashMap = keys;
                synchronized (hashMap) {
                    for (String key : keys.keySet()) {
                        String p = key.split(":")[0];
                        String s = key.split(":")[1];
                        String n2 = keys.get(key);
                        bw.write("peripheral=" + p + ";serial=" + s + ";name=" + n2);
                        bw.newLine();
                    }
                }
                File f2 = new File("wolf8access-config_" + ioServerPrefix + "ini.tmp");
                if (!f2.renameTo(new File("wolf8access-config_" + ioServerPrefix + "ini"))) {
                    throw new Exception("cannot rename wolf8access-config_" + ioServerPrefix + "ini.tmp");
                }
                f2.setWritable(true, false);
                Utility.ioServersRestart(ioServerPrefix.substring(0, ioServerPrefix.length() - 1));
            }
            catch (Exception e2) {
                throw new Exception("exception while writing to wolf8access-config_" + ioServerPrefix + "ini - " + e2.getLocalizedMessage());
            }
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void readConfigurationFile() {
        BufferedReader br = null;
        File file = null;
        try {
            try {
                String next;
                file = new File("wolf8access-config_" + ioServerPrefix + "ini");
                br = new BufferedReader(new FileReader(file));
                while ((next = br.readLine()) != null) {
                    String[] fields = next.split(";");
                    String p = fields[0].split("=")[1];
                    String s = fields[1].split("=")[1];
                    String n2 = fields[2].split("=").length > 1 ? fields[2].split("=")[1] : "";
                    keys.put(String.valueOf(p) + ":" + s, n2);
                }
            }
            catch (FileNotFoundException e2) {
                try {
                    file.createNewFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception e3) {
                Utility.errorLog("exception while reading wolf8access-config_" + ioServerPrefix + "ini - " + e3.getLocalizedMessage());
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void addSession(String session) {
        int i2 = 0;
        while (i2 < sessions.length) {
            if (sessions[i2].equals(session)) {
                return;
            }
            ++i2;
        }
        if (sessionIndex >= 10) {
            sessionIndex = 0;
        }
        Utility.sessions[Utility.sessionIndex++] = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLogOnFile(String peripheral, String serialNum) {
        OutputStreamWriter fw = null;
        try {
            try {
                fw = new FileWriter(logFile, true);
                SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                String dateString = format.format(new Date());
                String name = "";
                HashMap<String, String> hashMap = keys;
                synchronized (hashMap) {
                    if (keys.containsKey(String.valueOf(peripheral) + ":" + serialNum)) {
                        name = keys.get(String.valueOf(peripheral) + ":" + serialNum);
                        name = name.isEmpty() ? "" : " - " + name;
                    }
                }
                String toWrite = String.valueOf(dateString) + " - access from Peripheral:" + peripheral + " Key:" + serialNum + name + "\n";
                String guiEntry = "<div style=\"font-size:17px\">" + toWrite + "</div>";
                mostRecentLog = toWrite;
                Utility.uiSet(String.valueOf(ioServerPrefix) + "log0", "value", mostRecentLog);
                logs.add(0, guiEntry);
                while (logs.size() > logSize) {
                    logs.remove(logSize);
                }
                StringBuilder text = new StringBuilder();
                int i2 = 0;
                while (i2 < logs.size()) {
                    guiEntry = logs.get(i2);
                    text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
                    ++i2;
                }
                Utility.uiSet(String.valueOf(ioServerPrefix) + "log", "value", text.toString());
                Utility.saveLogs();
                fw.write(toWrite);
                fw.flush();
            }
            catch (Exception exception) {
                try {
                    fw.close();
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void saveLogs() {
        block18: {
            ByteArrayOutputStream out = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    out = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(out);
                    oos.writeObject(logs);
                    userBase.varSet(logsVar, new String(Base64.encodeBase64(out.toByteArray())));
                }
                catch (Exception exception) {
                    try {
                        out.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        oos.close();
                    }
                    catch (Exception exception3) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                oos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mostRecentLog != null) {
            userBase.varSet(lastLogVar, mostRecentLog);
        }
    }

    private static void loadLogs() {
        String lastLog;
        block13: {
            logsVar = "$__HSYCO__WOLF8ACCESS_" + ioServerPrefix + "log!";
            lastLogVar = "$__HSYCO__WOLF8ACCESS_last_log!";
            ObjectInputStream ois = null;
            try {
                try {
                    String s = userBase.varGet(logsVar);
                    if (s == null) {
                        logs = new Vector(logSize);
                    }
                    byte[] data = Base64.decodeBase64(s);
                    ois = new ObjectInputStream(new ByteArrayInputStream(data));
                    logs = (Vector)ois.readObject();
                }
                catch (Exception e2) {
                    logs = new Vector(logSize);
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mostRecentLog = lastLog = userBase.varGet(lastLogVar);
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < logs.size()) {
            String guiEntry = logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
            ++i2;
        }
        Utility.uiSet(String.valueOf(ioServerPrefix) + "log", "value", text.toString());
    }
}

