/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.InputScheduler;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;

public class WiringScenario
extends Wiring {
    private static final long serialVersionUID = 8266001490722571805L;
    public static final String functionsValues;
    public static final String functionsLabels;
    public static final Vector<Wiring.Function> functions;
    private final String onValue;

    static {
        functions = new Vector(1);
        functions.add(0, new Wiring.Function(0, "--", new String[]{"Input:"}, null));
        String vals = "";
        String labs = "";
        for (Wiring.Function f2 : functions) {
            vals = String.valueOf(vals) + "," + f2.id;
            labs = String.valueOf(labs) + "," + f2.label;
        }
        functionsValues = vals.substring(1);
        functionsLabels = labs.substring(1);
    }

    public WiringScenario(String dbString) {
        this(Database.split(dbString, ','));
    }

    private WiringScenario(Vector<String> params) {
        super(params.get(0), params.get(1), WiringScenario.getFunction(params.get(2)));
        this.output = new Output(params.get(3));
        this.onValue = params.get(4);
        int i2 = 5;
        while (i2 < params.size()) {
            this.inputs[i2 - 5] = new Input(params.get(i2));
            ++i2;
        }
    }

    public WiringScenario(String name, Output o2, String[] ins, String schedulerVal, Wiring edited) throws Exception {
        super(name, WiringScenario.getFunction(null), o2, ins, edited);
        this.onValue = this.inputs[0] instanceof InputScheduler ? schedulerVal : "1";
        if (edited == null || !(edited instanceof WiringScenario)) {
            this.record();
        } else {
            this.output.switchScenario((WiringScenario)edited, this);
        }
    }

    static Wiring.Function getFunction(String object) {
        return functions.get(0);
    }

    @Override
    protected void uiSet(String session) throws Exception {
        WiringEditor.uiSet("wiring.type.out", "value", "scenario", session);
        WiringEditor.uiSet("wiring.function", "values", functionsValues, session);
        WiringEditor.uiSet("wiring.function", "labels", functionsLabels, session);
        this.function.uiSet(session);
        WiringEditor.uiSet("wiring.function", "value", "0", session);
        WiringEditor.uiSet("wiring.function", "enabled", "false", session);
        WiringEditor.uiSet("wiring.scenario.rec", "visible", "true", session);
        WiringEditor.uiSet("wiring.scenario.info", "visible", "false", session);
        WiringEditor.uiSet("info.function", "visible", "false", session);
        if (this.inputs[0] instanceof InputScheduler) {
            WiringEditor.uiSet("wiring.scheduler.val", "value", this.onValue, session);
            WiringEditor.uiSet("wiring.scheduler.option", "visible", "true", session);
        }
        WiringEditor.inputs.update("scenario", session);
        WiringEditor.outputs.update("scenario", session);
    }

    @Override
    protected void execute(Input i2, String value) throws Exception {
        if (value.equals(this.onValue)) {
            WiringEditor.log(3, "Executing scenario wiring '" + this.name + "'");
            WiringEditor.UserTask.interrupt(this.output);
            this.output.recallScenario(this);
        }
    }

    @Override
    protected String getOutputTypeName() {
        return "Scenario";
    }

    public void record() throws Exception {
        this.output.recordScenario(this);
    }

    @Override
    public void onRemove() {
        for (Output o2 : WiringEditor.outputs.values()) {
            o2.removeScenario(this);
        }
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.function.id).append(",");
        dbString.append(this.output.id.replace(",", ",,")).append(",");
        dbString.append(this.onValue);
        Input[] inputArray = this.inputs;
        int n2 = this.inputs.length;
        int n3 = 0;
        while (n3 < n2) {
            Input i2 = inputArray[n3];
            dbString.append(',').append(i2.id.replace(",", ",,"));
            ++n3;
        }
        return dbString.toString();
    }
}

