/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.UIText;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;

public class WiringOnOff
extends Wiring {
    private static final long serialVersionUID = 5992086237301476310L;
    private static final int FUNCTION_TOGGLE = 0;
    private static final int FUNCTION_2WAYS = 1;
    private static final int FUNCTION_PUSHBUTTON = 2;
    private static final int FUNCTION_DIRECT = 3;
    public static final String functionsValues;
    public static final String functionsLabels;
    public static final Vector<Wiring.Function> functions;
    private final String onValue;
    private final int delay;
    private final int hold;

    static {
        functions = new Vector(3);
        functions.add(0, new Wiring.Function(0, "Toggle", new String[]{"Input:"}, "value"));
        functions.add(1, new Wiring.Function(1, "2-Ways", new String[]{"Input - on:", "Input - off:"}, null));
        functions.add(2, new Wiring.Function(2, "Push-button", new String[]{"Input:"}, "timers"));
        functions.add(3, new Wiring.Function(3, "Direct", new String[]{"Input:"}, null));
        String vals = "";
        String labs = "";
        for (Wiring.Function f2 : functions) {
            vals = String.valueOf(vals) + "," + f2.id;
            labs = String.valueOf(labs) + "," + f2.label;
        }
        functionsValues = vals.substring(1);
        functionsLabels = labs.substring(1);
    }

    public WiringOnOff(String dbString) {
        this(Database.split(dbString, ','));
    }

    private WiringOnOff(Vector<String> params) {
        super(params.get(0), params.get(1), WiringOnOff.getFunction(params.get(2)));
        this.output = new Output(params.get(3));
        this.onValue = params.get(4);
        this.delay = Integer.parseInt(params.get(5));
        this.hold = Integer.parseInt(params.get(6));
        int i2 = 7;
        while (i2 < params.size()) {
            this.inputs[i2 - 7] = new Input(params.get(i2));
            ++i2;
        }
    }

    public WiringOnOff(String name, String function, Output o2, String[] ins, String value, String delay, String hold, Wiring edited) throws Exception {
        block7: {
            super(name, WiringOnOff.getFunction(function), o2, ins, edited);
            this.onValue = this.function.id == 0 ? (value.equals("1") || value.equals("0") ? value : null) : "1";
            if (this.function.id == 2) {
                try {
                    this.delay = (int)(Float.parseFloat(delay.replace(',', '.')) * 1000.0f);
                    if (this.delay < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new WiringEditor.UserException(String.valueOf(UIText.DELAY_VALUE_NOT_ALLOWED) + ": " + delay);
                }
                try {
                    this.hold = (int)(Float.parseFloat(hold.replace(',', '.')) * 1000.0f);
                    if (this.hold < 0) {
                        throw new Exception();
                    }
                    break block7;
                }
                catch (Exception e3) {
                    throw new WiringEditor.UserException(String.valueOf(UIText.HOLD_VALUE_NOT_ALLOWED) + ": " + hold);
                }
            }
            this.delay = 0;
            this.hold = 0;
        }
    }

    public static Wiring.Function getFunction(String function) {
        return functions.get(Integer.parseInt(function));
    }

    @Override
    protected void uiSet(String session) throws Exception {
        WiringEditor.uiSet("wiring.type.out", "value", "onoff", session);
        WiringEditor.uiSet("wiring.function", "values", functionsValues, session);
        WiringEditor.uiSet("wiring.function", "labels", functionsLabels, session);
        this.function.uiSet(session);
        WiringEditor.uiSet("wiring.option.value", "value", this.onValue == null ? "c" : this.onValue, session);
        WiringEditor.uiSet("wiring.option.delay", "value", "" + (double)this.delay / 1000.0, session);
        WiringEditor.uiSet("wiring.option.hold", "value", "" + (double)this.hold / 1000.0, session);
        WiringEditor.uiSet("info.function", "param", "function.onoff", session);
        WiringEditor.uiSet("info.function", "visible", "true", session);
        WiringEditor.inputs.update("onoff", session);
        WiringEditor.outputs.update("onoff", session);
    }

    @Override
    protected void execute(final Input i2, String value) {
        if (this.function.id == 0) {
            if (this.onValue == null || value.equals(this.onValue)) {
                WiringEditor.log(3, "Executing on/off wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                String currVal = this.output.getValue();
                if (currVal == null || currVal.equals("1")) {
                    this.output.setValue("0");
                } else {
                    this.output.setValue("1");
                }
            }
        } else if (this.function.id == 1) {
            if (value.equals("1")) {
                WiringEditor.log(3, "Executing on/off wiring '" + this.name + "'");
                if (this.inputs[0].matches(i2)) {
                    WiringEditor.UserTask.interrupt(this.output);
                    this.output.setValue("1");
                } else if (this.inputs[1].matches(i2)) {
                    WiringEditor.UserTask.interrupt(this.output);
                    this.output.setValue("0");
                }
            }
        } else if (this.function.id == 3) {
            WiringEditor.log(3, "Executing on/off wiring '" + this.name + "'");
            WiringEditor.UserTask.interrupt(this.output);
            this.output.setValue(value);
        } else if (this.function.id == 2) {
            if (value.equals("1")) {
                WiringEditor.log(3, "Executing on/off wiring '" + this.name + "'");
                new WiringEditor.UserTask(this.output){

                    @Override
                    protected void task() throws InterruptedException {
                        if (WiringOnOff.this.delay > 0) {
                            Thread.sleep(WiringOnOff.this.delay);
                            if (!i2.getValue().equals("1")) {
                                return;
                            }
                        }
                        WiringOnOff.this.output.setValue("1");
                        if (WiringOnOff.this.hold > 0) {
                            Thread.sleep(WiringOnOff.this.hold);
                            WiringOnOff.this.output.setValue("0");
                        }
                    }
                };
            } else {
                WiringEditor.log(3, "Executing on/off wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("0");
            }
        }
    }

    @Override
    protected String getOutputTypeName() {
        return "On/Off";
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.function.id).append(",");
        dbString.append(this.output.id.replace(",", ",,")).append(",");
        dbString.append(this.onValue).append(",");
        dbString.append(this.delay).append(",");
        dbString.append(this.hold);
        Input[] inputArray = this.inputs;
        int n2 = this.inputs.length;
        int n3 = 0;
        while (n3 < n2) {
            Input i2 = inputArray[n3];
            dbString.append(',').append(i2.id.replace(",", ",,"));
            ++n3;
        }
        return dbString.toString();
    }
}

