/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import com.hsyco.Configuration;
import com.hsyco.HsycoFile;
import com.hsyco.userBase;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import plugins.wiringeditor.Backup;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.InputGroup;
import plugins.wiringeditor.InputScheduler;
import plugins.wiringeditor.InputUser;
import plugins.wiringeditor.ListManager;
import plugins.wiringeditor.Listable;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.OutputGroup;
import plugins.wiringeditor.OutputUser;
import plugins.wiringeditor.UIText;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringBlind;
import plugins.wiringeditor.WiringDimmer;
import plugins.wiringeditor.WiringOnOff;
import plugins.wiringeditor.WiringScenario;

public class WiringEditor
extends userBase {
    static final String PREFIX = "__hsyco__wrng.";
    private static final String MAIN_FOLDER = "wiring/";
    private static final String IN_WHITELIST_FILE = "wiring/whitelist.in.txt";
    private static final String OUT_WHITELIST_FILE = "wiring/whitelist.out.txt";
    private static final String IN_BLACKLIST_FILE = "wiring/blacklist.in.txt";
    private static final String OUT_BLACKLIST_FILE = "wiring/blacklist.out.txt";
    private static final String BACKUP_FOLDER = "wiring/backups/";
    private static final String INPUTS_TEMP_BACKUP = "wiring/backups/inputs.bkup.temp";
    private static final String OUTPUTS_TEMP_BACKUP = "wiring/backups/outputs.bkup.temp";
    private static final String WIRINGS_TEMP_BACKUP = "wiring/backups/wirings.bkup.temp";
    private static final String ADDED_INPUTS_TEMP_BACKUP = "wiring/backups/added.inputs.bkup.temp";
    private static final String ADDED_OUTPUTS_TEMP_BACKUP = "wiring/backups/added.outputs.bkup.temp";
    private static String INFO_FOLDER = "plugins/wiringeditor/info/";
    static final int LOG_ERROR = 0;
    static final int LOG_VERBOSE = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_MESSAGE = 3;
    static final int MAX_INPUTS_NUM = 3;
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    static HashMap<String, Input> addedInputs;
    static HashMap<String, Output> addedOutputs;
    static ListManager<Input> inputs;
    static ListManager<Output> outputs;
    static ListManager<Wiring> wirings;
    static Vector<String> wiringOutputSessions;
    static Vector<String>[] wiringInputSessions;
    private static boolean ready;
    static boolean expertMode;
    private static long inWhiteList_lastModified;
    private static long outWhiteList_lastModified;
    private static long inBlackList_lastModified;
    private static long outBlackList_lastModified;
    private static Vector<String> inWhiteList;
    private static Vector<String> outWhiteList;
    private static Vector<String> inBlackList;
    private static Vector<String> outBlackList;
    private static boolean fillInWhiteList;
    private static boolean fillOutWhiteList;
    private static long backups_lastModified;
    static ListManager<Backup> backups;
    static HashMap<String, String> infos;
    private static boolean debug;

    static {
        wiringOutputSessions = new Vector();
        wiringInputSessions = new Vector[3];
        int i2 = 0;
        while (i2 < wiringInputSessions.length) {
            WiringEditor.wiringInputSessions[i2] = new Vector();
            ++i2;
        }
        ready = false;
        expertMode = true;
        inWhiteList_lastModified = 0L;
        outWhiteList_lastModified = 0L;
        inBlackList_lastModified = 0L;
        outBlackList_lastModified = 0L;
        inWhiteList = null;
        outWhiteList = null;
        inBlackList = null;
        outBlackList = null;
        fillInWhiteList = false;
        fillOutWhiteList = false;
        backups_lastModified = 0L;
        infos = new HashMap();
        debug = true;
    }

    public static void putInputDatapoint(String id, String name, String valueType) throws Exception {
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (!WiringEditor.isReady()) {
            throw new Exception("Wiring Editor not ready");
        }
        int vType = valueType == null ? -1 : (valueType.equals("binary") ? 0 : (valueType.equals("level") ? 1 : -1));
        if (inBlackList != null && inBlackList.contains(id)) {
            return;
        }
        Input i2 = new Input(id, null, name, vType);
        inputs.put(i2.id, i2);
        WiringEditor.checkInGroups();
        WiringEditor.checkWirings();
    }

    public static void putOutputDatapoint(String id, String name, String valueType) throws Exception {
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (!WiringEditor.isReady()) {
            throw new Exception("Wiring Editor not ready");
        }
        int vType = valueType == null ? -1 : (valueType.equals("onoff") ? 0 : (valueType.equals("dimmer") ? 1 : (valueType.equals("blind") ? 2 : -1)));
        if (outBlackList != null && outBlackList.contains(id)) {
            return;
        }
        Output o2 = new Output(id, null, name, vType);
        outputs.put(o2.id, o2);
        WiringEditor.checkOutGroups();
        WiringEditor.checkWirings();
    }

    public static boolean isReady() {
        return ready;
    }

    public static void StartupEvent() {
        try {
            WiringEditor.log(1, "application started");
            ready = false;
            if (!WiringEditor.loadIniFile()) {
                WiringEditor.log(1, "wirinig editor disabled");
                return;
            }
            UIText.load();
            switch (Configuration.language) {
                case 1: {
                    INFO_FOLDER = String.valueOf(INFO_FOLDER) + "it/";
                    WiringEditor.uiSet("cancel", "text", "Annulla");
                    WiringEditor.uiSet("close", "text", "Chiudi");
                    WiringEditor.uiSet("name.label", "text", "Nome:");
                    WiringEditor.uiSet("backup.now", "text", "Crea backup");
                    WiringEditor.uiSet("backupoperation.label", "text", "Questa operazione sovrascrivera' tutti i wiring definiti e le impostazioni di input e output");
                    WiringEditor.uiSet("group.input.edit", "text", "Salva");
                    WiringEditor.uiSet("input.delete", "text", "Elimina");
                    WiringEditor.uiSet("members.label", "text", "Membri:");
                    WiringEditor.uiSet("group.output.edit", "text", "Salva");
                    WiringEditor.uiSet("output.delete", "text", "Elimina");
                    WiringEditor.uiSet("type.label", "text", "Tipo:");
                    WiringEditor.uiSet("input.valtype.label", "text", "Tipo valore:");
                    WiringEditor.uiSet("input.new", "text", "Aggiungi");
                    WiringEditor.uiSet("input.edit", "text", "Salva");
                    WiringEditor.uiSet("valuetype.label", "text", "Tipo valore:");
                    WiringEditor.uiSet("output.valtype.label", "text", "Tipo valore:");
                    WiringEditor.uiSet("output.new", "text", "Aggiungi");
                    WiringEditor.uiSet("output.edit", "text", "Salva");
                    WiringEditor.uiSet("outtype.label", "text", "Tipo output:");
                    WiringEditor.uiSet("function.label", "text", "Funzione:");
                    WiringEditor.uiSet("wiring.scenario.info", "text", "Premere il tasto 'Aggiungi' per creare il wiring e registrare lo stato corrente dell'output");
                    WiringEditor.uiSet("wiring.delete", "text", "Elimina");
                    WiringEditor.uiSet("wiring.edit", "text", "Salva");
                    WiringEditor.uiSet("wiring.new", "text", "Aggiungi");
                    break;
                }
                default: {
                    INFO_FOLDER = String.valueOf(INFO_FOLDER) + "en/";
                }
            }
            WiringEditor.loadInfo();
            WiringEditor.uiSet("input.list", "enabled", "false");
            WiringEditor.uiSet("output.list", "enabled", "false");
            WiringEditor.uiSet("wiring.list", "enabled", "false");
            WiringEditor.uiSet("wiring.delete", "icon", "delete");
            WiringEditor.uiSet("wiring.type.out", "autosend", "true");
            WiringEditor.uiSet("wiring.function", "autosend", "true");
            WiringEditor.uiSet("wiring.function", "enabled", "false");
            WiringEditor.uiSet("wiring.option.value", "value", "1");
            WiringEditor.uiSet("wiring.option.delay", "value", "0");
            WiringEditor.uiSet("wiring.option.hold", "value", "0");
            WiringEditor.uiSet("wiring.option.ratio", "value", "1");
            WiringEditor.uiSet("wiring.scheduler.val", "value", "1");
            WiringEditor.uiSet("wiring.input.0.list", "autosend", "true");
            WiringEditor.uiSet("output.type", "autosend", "true");
            WiringEditor.uiSet("output.group.members.list", "multi", "true");
            WiringEditor.uiSet("input.type", "autosend", "true");
            WiringEditor.uiSet("input.group.members.list", "multi", "true");
            WiringEditor.uiSet("output.delete", "icon", "delete");
            WiringEditor.uiSet("input.delete", "icon", "delete");
            WiringEditor.uiSet("input.scheduler", "panel", "false");
            if (!expertMode) {
                WiringEditor.uiSet("input.type", "enabled", "false");
                WiringEditor.uiSet("input.type", "value", "group");
                WiringEditor.uiSet("input.id.label", "text", UIText.MEMBERS);
                WiringEditor.uiSet("input.group.members.list", "visible", "true");
                WiringEditor.uiSet("input.valtype.label", "visible", "false");
                WiringEditor.uiSet("input.valtype", "visible", "false");
                WiringEditor.uiSet("output.type", "enabled", "false");
                WiringEditor.uiSet("output.type", "value", "group");
                WiringEditor.uiSet("output.id.label", "text", UIText.MEMBERS);
                WiringEditor.uiSet("output.group.members.list", "visible", "true");
                WiringEditor.uiSet("output.valtype.label", "visible", "false");
                WiringEditor.uiSet("output.valtype", "visible", "false");
            }
            int i2 = 0;
            while (i2 < 3) {
                WiringEditor.uiSet("wiring.input." + i2 + ".cont", "visible", "false");
                ++i2;
            }
            WiringEditor.uiSet("wiring.output.get", "visible", "false");
            i2 = 0;
            while (i2 < 3) {
                WiringEditor.uiSet("wiring.input." + i2 + ".get", "visible", "false");
                ++i2;
            }
            wirings = new ListManager("wiring");
            wirings.addList("wiring", null);
            try {
                addedInputs = Database.loadStringHashMap("added_inputs");
            }
            catch (IOException e2) {
                addedInputs = new HashMap();
            }
            try {
                addedOutputs = Database.loadStringHashMap("added_outputs");
            }
            catch (IOException e3) {
                addedOutputs = new HashMap();
            }
            inputs = new ListManager();
            inputs.addList("input", null);
            inputs.addList("wiring.input.0", null);
            inputs.addList("wiring.input.1", null);
            inputs.addList("wiring.input.2", null);
            inputs.addList("input.group.members", null);
            for (Input i3 : addedInputs.values()) {
                inputs.put(i3.id, i3);
            }
            outputs = new ListManager();
            outputs.addList("output", null);
            outputs.addList("wiring.output", null);
            outputs.addList("output.group.members", null);
            for (Output o2 : addedOutputs.values()) {
                outputs.put(o2.id, o2);
            }
            try {
                Wiring.wirings_count = Database.loadInt("wirings_count");
            }
            catch (Exception e4) {
                Wiring.wirings_count = 0;
            }
            try {
                OutputGroup.out_groups_count = Database.loadInt("out_groups_count");
            }
            catch (Exception e5) {
                OutputGroup.out_groups_count = 0;
            }
            try {
                InputGroup.in_groups_count = Database.loadInt("in_groups_count");
            }
            catch (Exception e6) {
                InputGroup.in_groups_count = 0;
            }
            backups = new ListManager();
            backups.addList("backup", null);
            WiringEditor.uiSet("input.list", "enabled", "true");
            WiringEditor.uiSet("output.list", "enabled", "true");
            WiringEditor.uiSet("wiring.list", "enabled", "true");
            WiringEditor.uiSet("wiring.add", "enabled", "true");
            WiringEditor.uiSet("input.add", "enabled", "true");
            WiringEditor.uiSet("output.add", "enabled", "true");
            WiringEditor.loadLists(true);
            WiringEditor.checkOutGroups();
            WiringEditor.checkInGroups();
            WiringEditor.checkWirings();
            WiringEditor.checkBackups();
            ready = true;
            WiringEditor.uiSet("backup.open.link", "enabled", "true");
            WiringEditor.log(1, "initialization complete");
        }
        catch (Throwable e7) {
            WiringEditor.log(0, "initialization error - " + WiringEditor.getStackTrace(e7));
        }
    }

    public static void TimeEvent(long timestamp) {
        if (!ready) {
            return;
        }
        try {
            WiringEditor.checkLists();
            WiringEditor.checkBackups();
        }
        catch (Throwable e2) {
            WiringEditor.log(0, "TimeEvent error - " + WiringEditor.getStackTrace(e2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkLists() throws Exception {
        String string = MAIN_FOLDER;
        synchronized (MAIN_FOLDER) {
            boolean reload = false;
            File list = new File(IN_WHITELIST_FILE);
            if (inWhiteList_lastModified == 0L && list.exists() || inWhiteList_lastModified != 0L && !list.exists() || inWhiteList_lastModified != 0L && inWhiteList_lastModified != list.lastModified()) {
                reload = true;
            }
            list = new File(IN_BLACKLIST_FILE);
            if (inBlackList_lastModified == 0L && list.exists() || inBlackList_lastModified != 0L && !list.exists() || inBlackList_lastModified != 0L && inBlackList_lastModified != list.lastModified()) {
                reload = true;
            }
            list = new File(OUT_WHITELIST_FILE);
            if (outWhiteList_lastModified == 0L && list.exists() || outWhiteList_lastModified != 0L && !list.exists() || outWhiteList_lastModified != 0L && outWhiteList_lastModified != list.lastModified()) {
                reload = true;
            }
            list = new File(OUT_BLACKLIST_FILE);
            if (outBlackList_lastModified == 0L && list.exists() || outBlackList_lastModified != 0L && !list.exists() || outBlackList_lastModified != 0L && outBlackList_lastModified != list.lastModified()) {
                reload = true;
            }
            if (reload) {
                WiringEditor.log(3, "white/black list files modified. Reloading...");
                inputs.clearMap();
                outputs.clearMap();
                WiringEditor.loadLists(true);
                for (Input i2 : addedInputs.values()) {
                    inputs.put(i2.id, i2);
                }
                for (Output o2 : addedOutputs.values()) {
                    outputs.put(o2.id, o2);
                }
                int i3 = 0;
                while (i3 < Configuration.ioServers.size()) {
                    WiringEditor.IOStartupEvent(i3);
                    ++i3;
                }
                util.haFilesChangeNotify();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLists(boolean addDatapoints) {
        String string = MAIN_FOLDER;
        synchronized (MAIN_FOLDER) {
            block63: {
                WiringEditor.log(1, "loading white/black list files");
                BufferedReader br = null;
                try {
                    try {
                        File inwl = new File(IN_WHITELIST_FILE);
                        if (inwl.exists()) {
                            String line;
                            br = new BufferedReader(new FileReader(inwl));
                            inWhiteList = new Vector();
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).length() == 0) continue;
                                inWhiteList.add(line);
                            }
                            if (inWhiteList.isEmpty()) {
                                fillInWhiteList = true;
                            }
                            inWhiteList_lastModified = inwl.lastModified();
                        } else {
                            inWhiteList = null;
                            inWhiteList_lastModified = 0L;
                        }
                        try {
                            br.close();
                        }
                        catch (Exception line) {
                            // empty catch block
                        }
                        File outwl = new File(OUT_WHITELIST_FILE);
                        if (outwl.exists()) {
                            String line;
                            br = new BufferedReader(new FileReader(outwl));
                            outWhiteList = new Vector();
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).length() == 0) continue;
                                outWhiteList.add(line);
                            }
                            if (outWhiteList.isEmpty()) {
                                fillOutWhiteList = true;
                            }
                            outWhiteList_lastModified = outwl.lastModified();
                        } else {
                            outWhiteList = null;
                            outWhiteList_lastModified = 0L;
                        }
                        try {
                            br.close();
                        }
                        catch (Exception line) {
                            // empty catch block
                        }
                        File inbl = new File(IN_BLACKLIST_FILE);
                        if (inbl.exists()) {
                            String line;
                            br = new BufferedReader(new FileReader(inbl));
                            inBlackList = new Vector();
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).length() == 0) continue;
                                inBlackList.add(line);
                            }
                            if (inBlackList.isEmpty()) {
                                inBlackList = null;
                            }
                            inBlackList_lastModified = inbl.lastModified();
                        } else {
                            inBlackList = null;
                            inBlackList_lastModified = 0L;
                        }
                        File outbl = new File(OUT_BLACKLIST_FILE);
                        if (outbl.exists()) {
                            String line;
                            br = new BufferedReader(new FileReader(outbl));
                            outBlackList = new Vector();
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).length() == 0) continue;
                                outBlackList.add(line);
                            }
                            if (outBlackList.isEmpty()) {
                                outBlackList = null;
                            }
                            outBlackList_lastModified = outbl.lastModified();
                        } else {
                            outBlackList = null;
                            outBlackList_lastModified = 0L;
                        }
                        if (addDatapoints) {
                            if (inWhiteList != null) {
                                for (String id : inWhiteList) {
                                    if (inBlackList != null && inBlackList.contains(id)) continue;
                                    inputs.put(id, new Input(id, null));
                                }
                            }
                            if (outWhiteList != null) {
                                for (String id : outWhiteList) {
                                    if (outBlackList != null && outBlackList.contains(id)) continue;
                                    outputs.put(id, new Output(id, null));
                                }
                            }
                        }
                    }
                    catch (Throwable e2) {
                        WiringEditor.log(0, "error loading white/black list files - " + WiringEditor.getStackTrace(e2));
                        try {
                            if (!fillInWhiteList && inWhiteList != null) {
                                WiringEditor.log(1, "inputs filtered by white list");
                            } else if (fillInWhiteList) {
                                WiringEditor.log(1, "inputs white list will be auto-compiled");
                            }
                            if (!fillOutWhiteList && outWhiteList != null) {
                                WiringEditor.log(1, "outputs filtered by white list");
                            } else if (fillOutWhiteList) {
                                WiringEditor.log(1, "outputs white list will be auto-compiled");
                            }
                            if (inBlackList != null) {
                                WiringEditor.log(1, "inputs filtered by black list");
                            }
                            if (outBlackList != null) {
                                WiringEditor.log(1, "outputs filtered by black list");
                            }
                            br.close();
                        }
                        catch (Exception exception) {}
                        break block63;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (!fillInWhiteList && inWhiteList != null) {
                            WiringEditor.log(1, "inputs filtered by white list");
                        } else if (fillInWhiteList) {
                            WiringEditor.log(1, "inputs white list will be auto-compiled");
                        }
                        if (!fillOutWhiteList && outWhiteList != null) {
                            WiringEditor.log(1, "outputs filtered by white list");
                        } else if (fillOutWhiteList) {
                            WiringEditor.log(1, "outputs white list will be auto-compiled");
                        }
                        if (inBlackList != null) {
                            WiringEditor.log(1, "inputs filtered by black list");
                        }
                        if (outBlackList != null) {
                            WiringEditor.log(1, "outputs filtered by black list");
                        }
                        br.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (!fillInWhiteList && inWhiteList != null) {
                        WiringEditor.log(1, "inputs filtered by white list");
                    } else if (fillInWhiteList) {
                        WiringEditor.log(1, "inputs white list will be auto-compiled");
                    }
                    if (!fillOutWhiteList && outWhiteList != null) {
                        WiringEditor.log(1, "outputs filtered by white list");
                    } else if (fillOutWhiteList) {
                        WiringEditor.log(1, "outputs white list will be auto-compiled");
                    }
                    if (inBlackList != null) {
                        WiringEditor.log(1, "inputs filtered by black list");
                    }
                    if (outBlackList != null) {
                        WiringEditor.log(1, "outputs filtered by black list");
                    }
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean loadIniFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 20[SIMPLE_IF_ELSE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadInfo() {
        String[] infoFiles;
        String[] stringArray = infoFiles = new String[]{"delay", "function.blind", "function.dimmer", "function.onoff", "hold", "inout", "manned", "onvalue", "outtype", "ratio", "record", "schedval"};
        int n2 = infoFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            String fileName = stringArray[n3];
            HsycoFile file = new HsycoFile(INFO_FOLDER, String.valueOf(fileName) + ".info");
            try {
                byte[] bytes = file.getBytes();
                if (bytes != null) {
                    String content = new String(bytes, "UTF-8");
                    infos.put(fileName, content);
                } else {
                    WiringEditor.log(0, "error loading infos - file '" + INFO_FOLDER + fileName + ".info' not found");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++n3;
        }
    }

    public static synchronized void IOStartupEvent(int ioIndex) {
        block28: {
            try {
                String dp;
                if (!ready) {
                    return;
                }
                String ioServerName = Configuration.ioServersGetName(ioIndex);
                String ioServerType = Configuration.ioServersGetTypeByName(ioServerName).toLowerCase();
                if (ioServerType == null) break block28;
                if (ioServerType.equals("hwgio")) {
                    WiringEditor.programTimerSet("_WIRINGEDITOR_HWGIO_DISCOVERY:" + ioServerName, 30);
                    return;
                }
                Set<String> ids = util.ioListByServerName(ioServerName);
                for (String id : ids) {
                    dp = id.substring(ioServerName.length() + 1);
                    if (ioServerType.equals("domino") || ioServerType.equals("contatto") || ioServerType.equals("artecoio")) {
                        if (dp.charAt(0) == 'i') {
                            WiringEditor.addInput(id, ioServerType.toUpperCase());
                            continue;
                        }
                        if (dp.charAt(0) != 'o') continue;
                        WiringEditor.addOutput(id, ioServerType.toUpperCase());
                        continue;
                    }
                    if (ioServerType.equals("myhome")) {
                        if (!dp.startsWith("light.") && !dp.startsWith("autom.")) continue;
                        WiringEditor.addOutput(id, "MYHOME");
                        continue;
                    }
                    if (ioServerType.equals("knx")) {
                        if (dp.startsWith("autom.")) {
                            WiringEditor.addOutput(id, "KNX automation");
                            continue;
                        }
                        if (dp.startsWith("dimmer.")) {
                            WiringEditor.addOutput(id, "KNX dimmer");
                            continue;
                        }
                        if (dp.equals("connection")) continue;
                        WiringEditor.addInput(id, "KNX datapoint");
                        WiringEditor.addOutput(id, "KNX datapoint");
                        continue;
                    }
                    if (!ioServerType.equals("dummy") || dp.equals("connection")) continue;
                    WiringEditor.addOutput(id, "DUMMY");
                }
                if (ioServerType.equals("domino") || ioServerType.equals("contatto")) {
                    for (String id : ids) {
                        int plus;
                        String type;
                        int n2;
                        int idx;
                        int dot;
                        dp = id.substring(ioServerName.length() + 1);
                        if (!dp.startsWith("detected.")) continue;
                        if (dp.startsWith("input.", 9)) {
                            dot = dp.indexOf(46, 15);
                            idx = Integer.parseInt(dp.substring(15, dot));
                            n2 = Integer.parseInt(dp.substring(dot + 1));
                            type = WiringEditor.ioGet(String.valueOf(ioServerName) + "." + dp).toUpperCase();
                            for (Input i2 : inputs.values()) {
                                plus = 0;
                                while (plus < n2) {
                                    if (i2.id.equals(String.valueOf(ioServerName) + ".i" + (idx + plus)) || i2.id.startsWith(String.valueOf(ioServerName) + ".i" + (idx + plus) + ".")) {
                                        i2.setTypeName(type);
                                    }
                                    ++plus;
                                }
                            }
                            for (Output o2 : outputs.values()) {
                                plus = 0;
                                while (plus < n2) {
                                    if (o2.id.equals(String.valueOf(ioServerName) + ".i" + (idx + plus)) || o2.id.startsWith(String.valueOf(ioServerName) + ".i" + (idx + plus) + ".")) {
                                        o2.setTypeName(type);
                                    }
                                    ++plus;
                                }
                            }
                            continue;
                        }
                        if (!dp.startsWith("output.", 9)) continue;
                        dot = dp.indexOf(46, 16);
                        idx = Integer.parseInt(dp.substring(16, dot));
                        n2 = Integer.parseInt(dp.substring(dot + 1));
                        type = WiringEditor.ioGet(String.valueOf(ioServerName) + "." + dp).toUpperCase();
                        for (Input i2 : inputs.values()) {
                            plus = 0;
                            while (plus < n2) {
                                if (i2.id.equals(String.valueOf(ioServerName) + ".o" + (idx + plus)) || i2.id.startsWith(String.valueOf(ioServerName) + ".o" + (idx + plus) + ".")) {
                                    i2.setTypeName(type);
                                }
                                ++plus;
                            }
                        }
                        for (Output o2 : outputs.values()) {
                            plus = 0;
                            while (plus < n2) {
                                if (o2.id.equals(String.valueOf(ioServerName) + ".o" + (idx + plus)) || o2.id.startsWith(String.valueOf(ioServerName) + ".o" + (idx + plus) + ".")) {
                                    o2.setTypeName(type);
                                }
                                ++plus;
                            }
                        }
                    }
                    inputs.update(null);
                    outputs.update(null);
                }
                if (fillInWhiteList) {
                    WiringEditor.updateInWhiteListFile();
                }
                if (fillOutWhiteList) {
                    WiringEditor.updateOutWhiteListFile();
                }
                WiringEditor.checkInGroups();
                WiringEditor.checkOutGroups();
                WiringEditor.checkWirings();
            }
            catch (Throwable e2) {
                WiringEditor.log(0, "error in IOStartupEvent(" + ioIndex + ") - " + WiringEditor.getStackTrace(e2));
            }
        }
    }

    public static String userCommand(String session, String uid, String cmd, String param) {
        block87: {
            block112: {
                block110: {
                    String buCmd;
                    block111: {
                        block91: {
                            String wirCmd;
                            boolean up;
                            boolean repeat;
                            block109: {
                                block105: {
                                    block108: {
                                        block107: {
                                            int i2;
                                            block106: {
                                                block103: {
                                                    block104: {
                                                        block98: {
                                                            String outType;
                                                            block102: {
                                                                block101: {
                                                                    block100: {
                                                                        block99: {
                                                                            block93: {
                                                                                block97: {
                                                                                    block96: {
                                                                                        block95: {
                                                                                            block94: {
                                                                                                block92: {
                                                                                                    block88: {
                                                                                                        String outCmd;
                                                                                                        block90: {
                                                                                                            block89: {
                                                                                                                block84: {
                                                                                                                    String inCmd;
                                                                                                                    block86: {
                                                                                                                        block85: {
                                                                                                                            block83: {
                                                                                                                                block82: {
                                                                                                                                    block81: {
                                                                                                                                        block80: {
                                                                                                                                            block79: {
                                                                                                                                                block78: {
                                                                                                                                                    if (ready) break block78;
                                                                                                                                                    return null;
                                                                                                                                                }
                                                                                                                                                Input in = addedInputs.get(cmd);
                                                                                                                                                if (in == null) break block79;
                                                                                                                                                WiringEditor.log(1, "processing user input '" + cmd + " = " + param + "'");
                                                                                                                                                String val = ((InputUser)in).setValue(param);
                                                                                                                                                if (val != null) {
                                                                                                                                                    for (Wiring w : wirings.values()) {
                                                                                                                                                        w.event(in, val);
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                return "!";
                                                                                                                                            }
                                                                                                                                            Output ou = addedOutputs.get(cmd);
                                                                                                                                            if (ou == null || !(ou instanceof OutputUser)) break block80;
                                                                                                                                            WiringEditor.log(1, "processing user output '" + cmd + " = " + param + "'");
                                                                                                                                            ((OutputUser)ou).updateValue(param);
                                                                                                                                            return "!";
                                                                                                                                        }
                                                                                                                                        if (cmd.startsWith(PREFIX)) break block81;
                                                                                                                                        return null;
                                                                                                                                    }
                                                                                                                                    cmd = cmd.substring(PREFIX.length());
                                                                                                                                    WiringEditor.log(1, "processing command '" + cmd + " = " + param + "'");
                                                                                                                                    repeat = false;
                                                                                                                                    up = false;
                                                                                                                                    if (!param.endsWith("/close")) break block82;
                                                                                                                                    if (cmd.endsWith(".list") || cmd.endsWith(".add")) {
                                                                                                                                        WiringEditor.uiClear(session);
                                                                                                                                        wiringOutputSessions.remove(session);
                                                                                                                                        WiringEditor.uiSet("wiring.output.list", "enabled", "true", session);
                                                                                                                                        WiringEditor.uiSet("wiring.output.last", "visible", "true", session);
                                                                                                                                        WiringEditor.uiSet("wiring.output.get", "visible", "false", session);
                                                                                                                                        int i3 = 0;
                                                                                                                                        while (i3 < 3) {
                                                                                                                                            wiringInputSessions[i3].remove(session);
                                                                                                                                            WiringEditor.uiSet("wiring.input." + i3 + ".list", "enabled", "true", session);
                                                                                                                                            WiringEditor.uiSet("wiring.input." + i3 + ".last", "visible", "true", session);
                                                                                                                                            WiringEditor.uiSet("wiring.input." + i3 + ".get", "visible", "false", session);
                                                                                                                                            ++i3;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    return "!";
                                                                                                                                }
                                                                                                                                if (param.endsWith("/up")) {
                                                                                                                                    param = param.substring(0, param.length() - 3);
                                                                                                                                    up = true;
                                                                                                                                    break block83;
                                                                                                                                }
                                                                                                                                if (param.contains("/repeat")) {
                                                                                                                                    int slash = param.lastIndexOf("/repeat");
                                                                                                                                    param = param.substring(0, slash);
                                                                                                                                    repeat = true;
                                                                                                                                    break block83;
                                                                                                                                }
                                                                                                                                if (!param.endsWith("/stop") && !param.endsWith("/down")) break block83;
                                                                                                                                return "!";
                                                                                                                            }
                                                                                                                            if (!cmd.startsWith("input.")) break block84;
                                                                                                                            inCmd = cmd.substring(6);
                                                                                                                            if (!inCmd.startsWith("list")) break block85;
                                                                                                                            if (!param.equals("")) {
                                                                                                                                return inputs.select(cmd, param, repeat, up, session);
                                                                                                                            }
                                                                                                                            return "!";
                                                                                                                        }
                                                                                                                        if (!inCmd.equals("add")) break block86;
                                                                                                                        WiringEditor.uiSet("input.name", "text", "", session);
                                                                                                                        WiringEditor.uiSet("input.group.members.list", "value", "", session);
                                                                                                                        if (expertMode) {
                                                                                                                            WiringEditor.uiSet("input.type", "value", "", session);
                                                                                                                            WiringEditor.uiSet("input.id", "text", "", session);
                                                                                                                            WiringEditor.uiSet("input.id.label", "text", "ID:", session);
                                                                                                                            WiringEditor.uiSet("input.valtype", "value", "", session);
                                                                                                                            WiringEditor.uiSet("input.valtype", "visible", "true", session);
                                                                                                                            WiringEditor.uiSet("input.valtype.label", "visible", "true", session);
                                                                                                                            WiringEditor.uiSet("input.group.members.list", "visible", "false", session);
                                                                                                                        }
                                                                                                                        return "!page:input.add";
                                                                                                                    }
                                                                                                                    if (inCmd.equals("type")) {
                                                                                                                        if (param.equals("group")) {
                                                                                                                            WiringEditor.uiSet("input.id.label", "text", UIText.MEMBERS, session);
                                                                                                                            WiringEditor.uiSet("input.group.members.list", "visible", "true", session);
                                                                                                                            WiringEditor.uiSet("input.valtype", "visible", "false", session);
                                                                                                                            WiringEditor.uiSet("input.valtype.label", "visible", "false", session);
                                                                                                                        } else if (param.equals("scheduler")) {
                                                                                                                            WiringEditor.uiSet("input.id.label", "text", "ID:", session);
                                                                                                                            WiringEditor.uiSet("input.group.members.list", "visible", "false", session);
                                                                                                                            WiringEditor.uiSet("input.valtype", "visible", "false", session);
                                                                                                                            WiringEditor.uiSet("input.valtype.label", "visible", "false", session);
                                                                                                                        } else {
                                                                                                                            WiringEditor.uiSet("input.id.label", "text", "ID:", session);
                                                                                                                            WiringEditor.uiSet("input.group.members.list", "visible", "false", session);
                                                                                                                            WiringEditor.uiSet("input.valtype", "visible", "true", session);
                                                                                                                            WiringEditor.uiSet("input.valtype.label", "visible", "true", session);
                                                                                                                        }
                                                                                                                        return "!";
                                                                                                                    }
                                                                                                                    break block87;
                                                                                                                }
                                                                                                                if (!cmd.startsWith("output.")) break block88;
                                                                                                                outCmd = cmd.substring(7);
                                                                                                                if (!outCmd.startsWith("list")) break block89;
                                                                                                                if (!param.equals("")) {
                                                                                                                    return outputs.select(cmd, param, repeat, up, session);
                                                                                                                }
                                                                                                                return "!";
                                                                                                            }
                                                                                                            if (!outCmd.equals("add")) break block90;
                                                                                                            WiringEditor.uiSet("output.name", "text", "", session);
                                                                                                            WiringEditor.uiSet("output.group.members.list", "value", "", session);
                                                                                                            if (expertMode) {
                                                                                                                WiringEditor.uiSet("output.type", "value", "", session);
                                                                                                                WiringEditor.uiSet("output.id", "text", "", session);
                                                                                                                WiringEditor.uiSet("output.id.label", "text", "ID:", session);
                                                                                                                WiringEditor.uiSet("output.valtype", "value", "", session);
                                                                                                                WiringEditor.uiSet("output.group.members.list", "visible", "false", session);
                                                                                                                WiringEditor.uiSet("output.valtype", "visible", "true", session);
                                                                                                                WiringEditor.uiSet("output.valtype.label", "visible", "true", session);
                                                                                                            }
                                                                                                            return "!page:output.add";
                                                                                                        }
                                                                                                        if (outCmd.equals("type")) {
                                                                                                            if (param.equals("group")) {
                                                                                                                WiringEditor.uiSet("output.id.label", "text", UIText.MEMBERS, session);
                                                                                                                WiringEditor.uiSet("output.group.members.list", "visible", "true", session);
                                                                                                                WiringEditor.uiSet("output.valtype", "visible", "false", session);
                                                                                                                WiringEditor.uiSet("output.valtype.label", "visible", "false", session);
                                                                                                            } else {
                                                                                                                WiringEditor.uiSet("output.id.label", "text", "ID:", session);
                                                                                                                WiringEditor.uiSet("output.group.members.list", "visible", "false", session);
                                                                                                                WiringEditor.uiSet("output.valtype", "visible", "true", session);
                                                                                                                WiringEditor.uiSet("output.valtype.label", "visible", "true", session);
                                                                                                            }
                                                                                                            return "!";
                                                                                                        }
                                                                                                        break block87;
                                                                                                    }
                                                                                                    if (!cmd.startsWith("wiring.")) break block91;
                                                                                                    wirCmd = cmd.substring(7);
                                                                                                    if (!wirCmd.equals("add")) break block92;
                                                                                                    WiringEditor.uiSet("wiring.name", "text", "", session);
                                                                                                    WiringEditor.uiSet("wiring.type.out", "value", "", session);
                                                                                                    WiringEditor.uiSet("wiring.function", "value", "", session);
                                                                                                    WiringEditor.uiSet("wiring.function", "enabled", "false", session);
                                                                                                    int i4 = 0;
                                                                                                    while (i4 < 3) {
                                                                                                        WiringEditor.uiSet("wiring.input." + i4 + ".cont", "visible", "false", session);
                                                                                                        ++i4;
                                                                                                    }
                                                                                                    String[] stringArray = Wiring.Function.options;
                                                                                                    int n2 = Wiring.Function.options.length;
                                                                                                    int n3 = 0;
                                                                                                    while (n3 < n2) {
                                                                                                        String opt = stringArray[n3];
                                                                                                        WiringEditor.uiSet("wiring.function.option." + opt, "visible", "false", session);
                                                                                                        ++n3;
                                                                                                    }
                                                                                                    WiringEditor.uiSet("wiring.output.list", "value", "", session);
                                                                                                    WiringEditor.uiSet("wiring.new", "visible", "true", session);
                                                                                                    WiringEditor.uiSet("wiring.edit", "visible", "false", session);
                                                                                                    WiringEditor.uiSet("wiring.delete", "visible", "false", session);
                                                                                                    WiringEditor.uiSet("wiring.scenario.rec", "visible", "false", session);
                                                                                                    WiringEditor.uiSet("wiring.scenario.info", "visible", "false", session);
                                                                                                    WiringEditor.uiSet("info.function", "visible", "false", session);
                                                                                                    WiringEditor.uiSet("wiring.scheduler.option", "visible", "false", session);
                                                                                                    return "!page:wiring.add";
                                                                                                }
                                                                                                if (!wirCmd.equals("type.out")) break block93;
                                                                                                WiringEditor.uiSet("wiring.type.out", "value", param, session);
                                                                                                WiringEditor.uiSet("wiring.function", "value", "", session);
                                                                                                int i5 = 0;
                                                                                                while (i5 < 3) {
                                                                                                    WiringEditor.uiSet("wiring.input." + i5 + ".cont", "visible", "false", session);
                                                                                                    ++i5;
                                                                                                }
                                                                                                String[] stringArray = Wiring.Function.options;
                                                                                                int n4 = Wiring.Function.options.length;
                                                                                                int n5 = 0;
                                                                                                while (n5 < n4) {
                                                                                                    String opt = stringArray[n5];
                                                                                                    WiringEditor.uiSet("wiring.function.option." + opt, "visible", "false", session);
                                                                                                    ++n5;
                                                                                                }
                                                                                                WiringEditor.uiSet("wiring.scenario.rec", "visible", "false", session);
                                                                                                WiringEditor.uiSet("wiring.scenario.info", "visible", "false", session);
                                                                                                WiringEditor.uiSet("wiring.scheduler.option", "visible", "false", session);
                                                                                                if (!param.equals("")) break block94;
                                                                                                WiringEditor.uiSet("wiring.function", "enabled", "false", session);
                                                                                                WiringEditor.uiSet("info.function", "visible", "false", session);
                                                                                                return "!";
                                                                                            }
                                                                                            WiringEditor.uiSet("wiring.function", "enabled", "true", session);
                                                                                            if (!param.equals("onoff")) break block95;
                                                                                            inputs.update(param, session);
                                                                                            outputs.update(param, session);
                                                                                            WiringEditor.uiSet("wiring.function", "values", WiringOnOff.functionsValues, session);
                                                                                            WiringEditor.uiSet("wiring.function", "labels", WiringOnOff.functionsLabels, session);
                                                                                            WiringEditor.uiSet("info.function", "param", "function.onoff", session);
                                                                                            WiringEditor.uiSet("info.function", "visible", "true", session);
                                                                                            return "!";
                                                                                        }
                                                                                        if (!param.equals("dimmer")) break block96;
                                                                                        outputs.update(param, session);
                                                                                        WiringEditor.uiSet("wiring.function", "values", WiringDimmer.functionsValues, session);
                                                                                        WiringEditor.uiSet("wiring.function", "labels", WiringDimmer.functionsLabels, session);
                                                                                        WiringEditor.uiSet("info.function", "param", "function.dimmer", session);
                                                                                        WiringEditor.uiSet("info.function", "visible", "true", session);
                                                                                        return "!";
                                                                                    }
                                                                                    if (!param.equals("blind")) break block97;
                                                                                    inputs.update(param, session);
                                                                                    outputs.update(param, session);
                                                                                    WiringEditor.uiSet("wiring.function", "values", WiringBlind.functionsValues, session);
                                                                                    WiringEditor.uiSet("wiring.function", "labels", WiringBlind.functionsLabels, session);
                                                                                    WiringEditor.uiSet("info.function", "param", "function.blind", session);
                                                                                    WiringEditor.uiSet("info.function", "visible", "true", session);
                                                                                    return "!";
                                                                                }
                                                                                if (param.equals("scenario")) {
                                                                                    inputs.update(param, session);
                                                                                    outputs.update(param, session);
                                                                                    WiringEditor.uiSet("wiring.function", "values", WiringScenario.functionsValues, session);
                                                                                    WiringEditor.uiSet("wiring.function", "labels", WiringScenario.functionsLabels, session);
                                                                                    WiringEditor.uiSet("wiring.function", "enabled", "false", session);
                                                                                    String edit = WiringEditor.uiGet("wiring.edit", "visible", session);
                                                                                    WiringEditor.uiSet("info.function", "visible", "false", session);
                                                                                    if (edit.equals("true")) {
                                                                                        WiringEditor.uiSet("wiring.scenario.rec", "visible", "true", session);
                                                                                        WiringEditor.uiSet("wiring.scenario.info", "visible", "false", session);
                                                                                    } else {
                                                                                        WiringEditor.uiSet("wiring.scenario.rec", "visible", "false", session);
                                                                                        WiringEditor.uiSet("wiring.scenario.info", "visible", "true", session);
                                                                                    }
                                                                                    WiringEditor.userCommand(session, uid, "__hsyco__wrng.wiring.function", "0");
                                                                                    return "!";
                                                                                }
                                                                                break block87;
                                                                            }
                                                                            if (!wirCmd.equals("function")) break block98;
                                                                            if (!param.equals("")) break block99;
                                                                            int i6 = 0;
                                                                            while (i6 < 3) {
                                                                                WiringEditor.uiSet("wiring.input." + i6 + ".cont", "visible", "false", session);
                                                                                ++i6;
                                                                            }
                                                                            String[] stringArray = Wiring.Function.options;
                                                                            int n6 = Wiring.Function.options.length;
                                                                            int n7 = 0;
                                                                            while (n7 < n6) {
                                                                                String opt = stringArray[n7];
                                                                                WiringEditor.uiSet("wiring.function.option." + opt, "visible", "false", session);
                                                                                ++n7;
                                                                            }
                                                                            return "!";
                                                                        }
                                                                        outType = WiringEditor.uiGet("wiring.type.out", "value", session);
                                                                        WiringEditor.uiSet("wiring.option.value", "value", "1", session);
                                                                        WiringEditor.uiSet("wiring.option.delay", "value", "0", session);
                                                                        WiringEditor.uiSet("wiring.option.hold", "value", "0", session);
                                                                        WiringEditor.uiSet("wiring.option.ratio", "value", "1", session);
                                                                        WiringEditor.uiSet("wiring.option.manned", "value", "false", session);
                                                                        if (!outType.equals("onoff")) break block100;
                                                                        WiringOnOff.getFunction(param).uiSet(session);
                                                                        return "!";
                                                                    }
                                                                    if (!outType.equals("dimmer")) break block101;
                                                                    Wiring.Function f2 = WiringDimmer.getFunction(param);
                                                                    f2.uiSet(session);
                                                                    inputs.update("dimmer/" + f2.id, session);
                                                                    return "!";
                                                                }
                                                                if (!outType.equals("blind")) break block102;
                                                                WiringBlind.getFunction(param).uiSet(session);
                                                                return "!";
                                                            }
                                                            if (outType.equals("scenario")) {
                                                                WiringScenario.getFunction(param).uiSet(session);
                                                                return "!";
                                                            }
                                                            break block87;
                                                        }
                                                        if (!wirCmd.startsWith("output.")) break block103;
                                                        if (!wirCmd.endsWith("last")) break block104;
                                                        wiringOutputSessions.add(session);
                                                        WiringEditor.uiSet("wiring.output.list", "enabled", "false", session);
                                                        WiringEditor.uiSet("wiring.output.last", "visible", "false", session);
                                                        WiringEditor.uiSet("wiring.output.get", "visible", "true", session);
                                                        return "!";
                                                    }
                                                    if (wirCmd.endsWith("get")) {
                                                        wiringOutputSessions.remove(session);
                                                        WiringEditor.uiSet("wiring.output.list", "enabled", "true", session);
                                                        WiringEditor.uiSet("wiring.output.last", "visible", "true", session);
                                                        WiringEditor.uiSet("wiring.output.get", "visible", "false", session);
                                                        return "!";
                                                    }
                                                    break block87;
                                                }
                                                if (!wirCmd.startsWith("input.")) break block105;
                                                i2 = Integer.parseInt("" + wirCmd.charAt(6));
                                                if (!wirCmd.endsWith("last")) break block106;
                                                wiringInputSessions[i2].add(session);
                                                WiringEditor.uiSet("wiring.input." + i2 + ".list", "enabled", "false", session);
                                                WiringEditor.uiSet("wiring.input." + i2 + ".last", "visible", "false", session);
                                                WiringEditor.uiSet("wiring.input." + i2 + ".get", "visible", "true", session);
                                                return "!";
                                            }
                                            if (!wirCmd.endsWith("get")) break block107;
                                            wiringInputSessions[i2].remove(session);
                                            WiringEditor.uiSet("wiring.input." + i2 + ".list", "enabled", "true", session);
                                            WiringEditor.uiSet("wiring.input." + i2 + ".last", "visible", "true", session);
                                            WiringEditor.uiSet("wiring.input." + i2 + ".get", "visible", "false", session);
                                            return "!";
                                        }
                                        if (!wirCmd.endsWith("0.list")) break block87;
                                        String outType = WiringEditor.uiGet("wiring.type.out", "value", session);
                                        if (outType != null && outType.equals("scenario")) break block108;
                                        return "!";
                                    }
                                    Input inp = addedInputs.get(param);
                                    if (inp != null && inp instanceof InputScheduler) {
                                        WiringEditor.uiSet("wiring.scheduler.option", "visible", "true", session);
                                    } else {
                                        WiringEditor.uiSet("wiring.scheduler.option", "visible", "false", session);
                                    }
                                    return "!";
                                }
                                if (!wirCmd.equals("scenario.rec")) break block109;
                                String id = WiringEditor.uiGet("wiring.id", "text", session);
                                WiringScenario w = (WiringScenario)wirings.get(id);
                                if (w == null) {
                                    throw new Exception("Wiring not found");
                                }
                                w.record();
                                WiringEditor.uiSet("wiring.scenario.outval", "text", w.output.getScenarioString(w), session);
                                WiringEditor.uiSet("wiring.scenario.ok", "param", "close", session);
                                return "!page:wiring.scenario";
                            }
                            if (wirCmd.equals("scenario.ok")) {
                                return "!page:" + param;
                            }
                            if (wirCmd.startsWith("list")) {
                                if (!param.equals("")) {
                                    return wirings.select(cmd, param, repeat, up, session);
                                }
                                return "!";
                            }
                            break block87;
                        }
                        if (!cmd.startsWith("backup.")) break block110;
                        buCmd = cmd.substring(7);
                        if (!buCmd.equals("list")) break block111;
                        WiringEditor.uiSet("backup.id", "text", param, session);
                        return "!page:backup.restore";
                    }
                    if (!buCmd.equals("restore")) break block87;
                    String id = WiringEditor.uiGet("backup.id", "text", session);
                    Backup b2 = backups.get(id);
                    if (b2 == null) {
                        throw new UserException(UIText.BACKUP_NOT_FOUND);
                    }
                    try {
                        WiringEditor.loadBackup(b2.name, b2.path);
                    }
                    catch (Exception e2) {
                        WiringEditor.log(0, "Error loading backup - " + WiringEditor.getStackTrace(e2));
                        throw new UserException("Error loading backup");
                    }
                    return "!page:menu";
                }
                if (!cmd.equals("info")) break block87;
                if (!param.equals("load")) break block112;
                WiringEditor.loadInfo();
                return "!";
            }
            String i7 = infos.get(param);
            if (i7 != null) {
                WiringEditor.uiSet("info.text", "text", i7);
            } else {
                WiringEditor.uiSet("info.text", "text", "No info found");
            }
            return "!page:info.popup";
        }
        try {
            throw new Exception("Unknown command");
        }
        catch (UserException e3) {
            WiringEditor.uiSet("warning.message", "text", e3.getLocalizedMessage(), session);
            WiringEditor.log(1, "UserException: " + e3.getLocalizedMessage());
            return "!page:warning.popup";
        }
        catch (Throwable e4) {
            WiringEditor.log(0, "error processing command '" + cmd + " = " + param + "' - " + WiringEditor.getStackTrace(e4));
            return "!error";
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String userSubmit(String session, String userid, String cmd, HashMap<String, String> submitted) {
        try {
            Backup b2;
            if (!ready) {
                return null;
            }
            if (!cmd.startsWith(PREFIX)) {
                return null;
            }
            cmd = cmd.substring(PREFIX.length());
            WiringEditor.log(1, "processing submit command '" + cmd + "'");
            if (cmd.startsWith("input.")) {
                Input g2;
                Iterator<Listable> i22;
                Input i3;
                String id;
                block106: {
                    Wiring w;
                    String inCmd = cmd.substring(6);
                    if (inCmd.equals("new")) {
                        String members;
                        String name;
                        String id2;
                        String type;
                        block103: {
                            Input i4;
                            void var10_74;
                            String valType;
                            block104: {
                                Input input;
                                type = submitted.get("__hsyco__wrng.input.type");
                                id2 = submitted.get("__hsyco__wrng.input.id");
                                name = submitted.get("__hsyco__wrng.input.name");
                                valType = submitted.get("__hsyco__wrng.input.valtype");
                                members = submitted.get("__hsyco__wrng.input.group.members.list");
                                if (name.equals("")) {
                                    throw new UserException(UIText.INSERT_A_NAME);
                                }
                                Iterator<Input> iterator = inputs.values().iterator();
                                do {
                                    if (!iterator.hasNext()) {
                                        if (!type.equals("io") && !type.equals("user")) break block103;
                                        if (id2.equals("")) {
                                            throw new UserException(UIText.INSERT_AN_ID);
                                        }
                                        break block104;
                                    }
                                    input = iterator.next();
                                } while (!input.name.equals(name));
                                throw new UserException(UIText.NAME_ALREADY_USED);
                            }
                            if (inputs.containsKey(id2)) {
                                throw new UserException(UIText.ID_ALREADY_USED);
                            }
                            if (valType.equals("")) {
                                throw new UserException(UIText.SELECT_A_VALUE_TYPE);
                            }
                            if (valType.equals("01")) {
                                boolean bl = false;
                            } else {
                                if (!valType.equals("lvl")) throw new Exception("Unknown value type: " + valType);
                                boolean bl = true;
                            }
                            if (!type.equals("io")) {
                                i4 = new InputUser(id2, name, (int)var10_74);
                                addedInputs.put(id2, i4);
                                WiringEditor.uiClear(session);
                                inputs.put(id2, i4);
                                outputs.update(null);
                                wirings.update(null);
                                Database.save("added_inputs", addedInputs);
                                return "!page:close";
                            }
                            String val = WiringEditor.ioGet(id2);
                            if (val == null) {
                                throw new UserException(UIText.DATAPOINT_NOT_FOUND);
                            }
                            i4 = new Input(id2, null);
                            i4.setName(name);
                            Output oWithSameId = outputs.get(id2);
                            if (oWithSameId != null) {
                                oWithSameId.setName(name);
                            }
                            i4.setValueType((int)var10_74);
                            WiringEditor.uiClear(session);
                            inputs.put(id2, i4);
                            outputs.update(null);
                            wirings.update(null);
                            WiringEditor.updateInWhiteListFile();
                            return "!page:close";
                        }
                        if (type.equals("scheduler")) {
                            if (id2.equals("")) {
                                throw new UserException(UIText.INSERT_AN_ID);
                            }
                            InputScheduler inputScheduler = new InputScheduler(id2, name);
                            if (inputs.containsKey(inputScheduler.id)) {
                                throw new UserException(UIText.ID_ALREADY_USED);
                            }
                            addedInputs.put(inputScheduler.id, inputScheduler);
                            Database.save("added_inputs", addedInputs);
                            inputs.put(inputScheduler.id, inputScheduler);
                            return "!page:close";
                        }
                        if (!type.equals("group")) throw new UserException(UIText.SELECT_A_TYPE);
                        if (members.equals("")) {
                            throw new UserException(UIText.SELECT_THE_MEMBERS_OF_THE_GROUP);
                        }
                        InputGroup inputGroup = new InputGroup(name, members);
                        addedInputs.put(inputGroup.id, inputGroup);
                        Database.save("added_inputs", addedInputs);
                        inputs.put(inputGroup.id, inputGroup);
                        return "!page:close";
                    }
                    if (inCmd.equals("edit")) {
                        Input input;
                        Iterator<Input> i4;
                        int valueType;
                        Input i22;
                        block105: {
                            String id3 = WiringEditor.uiGet("input.id", "text", session);
                            String name = submitted.get("__hsyco__wrng.input.name");
                            String valType = submitted.get("__hsyco__wrng.input.valtype");
                            i22 = inputs.get(id3);
                            if (i22 == null) {
                                throw new Exception("input not found");
                            }
                            if (name.equals("")) {
                                throw new UserException(UIText.INSERT_A_NAME);
                            }
                            if (valType.equals("01")) {
                                valueType = 0;
                            } else {
                                if (!valType.equals("lvl")) throw new UserException(UIText.SELECT_A_VALUE_TYPE);
                                valueType = 1;
                            }
                            if (!i22.name.equals(name)) {
                                Input input2;
                                i4 = inputs.values().iterator();
                                do {
                                    if (!i4.hasNext()) {
                                        Output output;
                                        i22.setName(name);
                                        if (i22 instanceof InputUser) {
                                            Database.save("added_inputs", addedInputs);
                                        }
                                        if ((output = outputs.get(id3)) != null) {
                                            output.setName(name);
                                        }
                                        WiringEditor.uiClear(session);
                                        inputs.update(null);
                                        outputs.update(null);
                                        wirings.update(null);
                                        break block105;
                                    }
                                    input2 = i4.next();
                                } while (!input2.name.equals(name));
                                throw new UserException(UIText.NAME_ALREADY_USED);
                            }
                        }
                        if (i22.valueType == valueType) return "!page:close";
                        i4 = addedInputs.values().iterator();
                        do {
                            if (i4.hasNext()) continue;
                            i22.setValueType(valueType);
                            if (!(i22 instanceof InputUser)) return "!page:close";
                            Database.save("added_inputs", addedInputs);
                            return "!page:close";
                        } while (!((input = i4.next()) instanceof InputGroup) || !((InputGroup)input).hasInput(i22));
                        throw new UserException(UIText.IT_IS_NOT_ALLOWED_TO_CHANGE_THE_VALUE_TYPE_OF_AN_INPUT_BELONGING_TO_A_GROUP);
                    }
                    if (!inCmd.equals("delete")) throw new Exception("Unknown command");
                    id = WiringEditor.uiGet("input.id", "text", session);
                    i3 = inputs.get(id);
                    if (i3 == null) {
                        throw new Exception("output not found");
                    }
                    i22 = wirings.values().iterator();
                    do {
                        if (!i22.hasNext()) break block106;
                    } while (!(w = i22.next()).hasInput(i3));
                    throw new UserException(String.valueOf(UIText.OPERATION_NOT_ALLOWED) + ": " + UIText.THIS_INPUT_IS_USED_BY_A_WIRING);
                }
                i22 = addedInputs.values().iterator();
                do {
                    if (i22.hasNext()) continue;
                    WiringEditor.uiClear(session);
                    inputs.remove(id);
                    outputs.update(null);
                    wirings.update(null);
                    if (!(i3 instanceof InputUser || i3 instanceof InputGroup || i3 instanceof InputScheduler)) {
                        WiringEditor.updateInWhiteListFile();
                        return "!page:close";
                    }
                    addedInputs.remove(id);
                    Database.save("added_inputs", addedInputs);
                    return "!page:close";
                } while (!((g2 = (Input)i22.next()) instanceof InputGroup) || !((InputGroup)g2).hasInput(i3));
                throw new UserException(String.valueOf(UIText.OPERATION_NOT_ALLOWED) + ": " + UIText.THIS_INPUT_IS_PART_OF_A_GROUP);
            }
            if (cmd.equals("group.input.edit")) {
                InputGroup i5;
                String members;
                block107: {
                    String id = WiringEditor.uiGet("input.id", "text", session);
                    String name = submitted.get("__hsyco__wrng.input.name");
                    members = submitted.get("__hsyco__wrng.input.group.members.list");
                    i5 = (InputGroup)addedInputs.get(id);
                    if (i5 == null) {
                        throw new Exception("input not found");
                    }
                    if (name.equals("")) {
                        throw new UserException(UIText.INSERT_A_NAME);
                    }
                    if (!i5.name.equals(name)) {
                        Input i12;
                        Iterator<Input> valueType = inputs.values().iterator();
                        do {
                            if (!valueType.hasNext()) {
                                i5.setName(name);
                                break block107;
                            }
                            i12 = valueType.next();
                        } while (!i12.name.equals(name));
                        throw new UserException(UIText.NAME_ALREADY_USED);
                    }
                }
                i5.setMembers(members);
                Database.save("added_inputs", addedInputs);
                inputs.update(null);
                return "!page:close";
            }
            if (cmd.equals("scheduler.input.edit")) {
                Input i1;
                String id = WiringEditor.uiGet("input.id", "text", session);
                String name = submitted.get("__hsyco__wrng.input.name");
                InputScheduler i6 = (InputScheduler)addedInputs.get(id);
                if (i6 == null) {
                    throw new Exception("input not found");
                }
                if (name.equals("")) {
                    throw new UserException(UIText.INSERT_A_NAME);
                }
                if (i6.name.equals(name)) return "!page:close";
                Iterator<Input> i12 = inputs.values().iterator();
                do {
                    if (!i12.hasNext()) {
                        i6.setName(name);
                        Database.save("added_inputs", addedInputs);
                        inputs.update(null);
                        return "!page:close";
                    }
                    i1 = i12.next();
                } while (!i1.name.equals(name));
                throw new UserException(UIText.NAME_ALREADY_USED);
            }
            if (cmd.startsWith("output.")) {
                Output g3;
                Iterator<Listable> o22;
                Output o3;
                String id;
                block111: {
                    Wiring w;
                    String outCmd = cmd.substring(7);
                    if (outCmd.equals("new")) {
                        String members;
                        String name;
                        String type;
                        block108: {
                            Output o4;
                            void var10_85;
                            String valType;
                            String id4;
                            block109: {
                                Output output;
                                type = submitted.get("__hsyco__wrng.output.type");
                                id4 = submitted.get("__hsyco__wrng.output.id");
                                name = submitted.get("__hsyco__wrng.output.name");
                                valType = submitted.get("__hsyco__wrng.output.valtype");
                                members = submitted.get("__hsyco__wrng.output.group.members.list");
                                if (name.equals("")) {
                                    throw new UserException(UIText.INSERT_A_NAME);
                                }
                                Iterator<Output> i4 = outputs.values().iterator();
                                do {
                                    if (!i4.hasNext()) {
                                        if (!type.equals("io") && !type.equals("user")) break block108;
                                        if (id4.equals("")) {
                                            throw new UserException(UIText.INSERT_AN_ID);
                                        }
                                        break block109;
                                    }
                                    output = i4.next();
                                } while (!output.name.equals(name));
                                throw new UserException(UIText.NAME_ALREADY_USED);
                            }
                            if (outputs.containsKey(id4)) {
                                throw new UserException(UIText.ID_ALREADY_USED);
                            }
                            if (valType.equals("")) {
                                throw new UserException(UIText.SELECT_A_VALUE_TYPE);
                            }
                            if (valType.equals("onoff")) {
                                boolean bl = false;
                            } else if (valType.equals("dimmer")) {
                                boolean bl = true;
                            } else {
                                if (!valType.equals("blind")) throw new Exception("Unknown value type: " + valType);
                                int n2 = 2;
                            }
                            if (!type.equals("io")) {
                                o4 = new OutputUser(id4, name, (int)var10_85);
                                addedOutputs.put(id4, o4);
                                WiringEditor.uiClear(session);
                                outputs.put(id4, o4);
                                inputs.update(null);
                                wirings.update(null);
                                Database.save("added_outputs", addedOutputs);
                                return "!page:close";
                            }
                            String val = WiringEditor.ioGet(id4);
                            if (val == null) {
                                throw new UserException(UIText.DATAPOINT_NOT_FOUND);
                            }
                            o4 = new Output(id4, null);
                            o4.setName(name);
                            Input iWithSameId = inputs.get(id4);
                            if (iWithSameId != null) {
                                iWithSameId.setName(name);
                            }
                            o4.setValueType((int)var10_85);
                            WiringEditor.uiClear(session);
                            outputs.put(id4, o4);
                            inputs.update(null);
                            wirings.update(null);
                            WiringEditor.updateOutWhiteListFile();
                            return "!page:close";
                        }
                        if (!type.equals("group")) throw new UserException(UIText.SELECT_A_TYPE);
                        if (members.equals("")) {
                            throw new UserException(UIText.SELECT_THE_MEMBERS_OF_THE_GROUP);
                        }
                        OutputGroup outputGroup = new OutputGroup(name, members);
                        addedOutputs.put(outputGroup.id, outputGroup);
                        Database.save("added_outputs", addedOutputs);
                        outputs.put(outputGroup.id, outputGroup);
                        return "!page:close";
                    }
                    if (outCmd.equals("edit")) {
                        Output output;
                        Iterator<Output> o4;
                        int valueType;
                        Output o22;
                        block110: {
                            String id5 = WiringEditor.uiGet("output.id", "text", session);
                            String name = submitted.get("__hsyco__wrng.output.name");
                            String valType = submitted.get("__hsyco__wrng.output.valtype");
                            o22 = outputs.get(id5);
                            if (o22 == null) {
                                throw new Exception("output not found");
                            }
                            if (name.equals("")) {
                                throw new UserException(UIText.INSERT_A_NAME);
                            }
                            if (valType.equals("onoff")) {
                                valueType = 0;
                            } else if (valType.equals("dimmer")) {
                                valueType = 1;
                            } else {
                                if (!valType.equals("blind")) throw new UserException(UIText.SELECT_A_VALUE_TYPE);
                                valueType = 2;
                            }
                            if (!o22.name.equals(name)) {
                                Output output2;
                                o4 = outputs.values().iterator();
                                do {
                                    if (!o4.hasNext()) {
                                        Input input;
                                        o22.setName(name);
                                        if (o22 instanceof OutputUser) {
                                            Database.save("added_outputs", addedOutputs);
                                        }
                                        if ((input = inputs.get(id5)) != null) {
                                            input.setName(name);
                                        }
                                        WiringEditor.uiClear(session);
                                        inputs.update(null);
                                        outputs.update(null);
                                        wirings.update(null);
                                        break block110;
                                    }
                                    output2 = o4.next();
                                } while (!output2.name.equals(name));
                                throw new UserException(UIText.NAME_ALREADY_USED);
                            }
                        }
                        if (o22.valueType == valueType) return "!page:close";
                        o4 = addedOutputs.values().iterator();
                        do {
                            if (o4.hasNext()) continue;
                            o22.setValueType(valueType);
                            if (!(o22 instanceof OutputUser)) return "!page:close";
                            Database.save("added_outputs", addedOutputs);
                            return "!page:close";
                        } while (!((output = o4.next()) instanceof OutputGroup) || !((OutputGroup)output).hasOutput(o22));
                        throw new UserException(UIText.IT_IS_NOT_ALLOWED_TO_CHANGE_THE_VALUE_TYPE_OF_AN_OUTPUT_BELONGING_TO_A_GROUP);
                    }
                    if (!outCmd.equals("delete")) throw new Exception("Unknown command");
                    id = WiringEditor.uiGet("output.id", "text", session);
                    o3 = outputs.get(id);
                    if (o3 == null) {
                        throw new Exception("output not found");
                    }
                    o22 = wirings.values().iterator();
                    do {
                        if (!o22.hasNext()) break block111;
                    } while (!(w = o22.next()).hasOutput(o3));
                    throw new UserException(String.valueOf(UIText.OPERATION_NOT_ALLOWED) + ": " + UIText.THIS_OUTPUT_IS_USED_BY_A_WIRING);
                }
                o22 = addedOutputs.values().iterator();
                do {
                    if (o22.hasNext()) continue;
                    WiringEditor.uiClear(session);
                    outputs.remove(id);
                    inputs.update(null);
                    wirings.update(null);
                    if (!(o3 instanceof OutputUser) && !(o3 instanceof OutputGroup)) {
                        WiringEditor.updateOutWhiteListFile();
                        return "!page:close";
                    }
                    addedOutputs.remove(id);
                    Database.save("added_outputs", addedOutputs);
                    return "!page:close";
                } while (!((g3 = (Output)o22.next()) instanceof OutputGroup) || !((OutputGroup)g3).hasOutput(o3));
                throw new UserException(String.valueOf(UIText.OPERATION_NOT_ALLOWED) + ": " + UIText.THIS_OUTPUT_IS_PART_OF_A_GROUP);
            }
            if (cmd.equals("group.output.edit")) {
                OutputGroup o5;
                String members;
                block112: {
                    String id = WiringEditor.uiGet("output.id", "text", session);
                    String name = submitted.get("__hsyco__wrng.output.name");
                    members = submitted.get("__hsyco__wrng.output.group.members.list");
                    o5 = (OutputGroup)addedOutputs.get(id);
                    if (o5 == null) {
                        throw new Exception("output not found");
                    }
                    if (name.equals("")) {
                        throw new UserException("Insert a name");
                    }
                    if (!o5.name.equals(name)) {
                        Output o1;
                        Iterator<Output> valueType = outputs.values().iterator();
                        do {
                            if (!valueType.hasNext()) {
                                o5.setName(name);
                                break block112;
                            }
                            o1 = valueType.next();
                        } while (!o1.name.equals(name));
                        throw new UserException(UIText.NAME_ALREADY_USED);
                    }
                }
                o5.setMembers(members);
                Database.save("added_outputs", addedOutputs);
                outputs.update(null);
                return "!page:close";
            }
            if (cmd.startsWith("wiring.")) {
                Wiring oldW;
                String schedVal;
                String ratio;
                String hold;
                String delay;
                String manned;
                String value;
                String wirCmd = cmd.substring(7);
                if (!wirCmd.equals("new") && !wirCmd.equals("edit")) {
                    if (!wirCmd.equals("delete")) throw new Exception("Unknown command");
                    String id = WiringEditor.uiGet("wiring.id", "text", session);
                    WiringEditor.uiClear(session);
                    wirings.remove(id);
                    outputs.update(null);
                    inputs.update(null);
                    return "!page:close";
                }
                String id = WiringEditor.uiGet("wiring.id", "text", session);
                String name = submitted.get("__hsyco__wrng.wiring.name");
                String function = submitted.get("__hsyco__wrng.wiring.function");
                String typeOut = submitted.get("__hsyco__wrng.wiring.type.out");
                String out = submitted.get("__hsyco__wrng.wiring.output.list");
                String[] stringArray = new String[3];
                int i7 = 0;
                while (true) {
                    if (i7 >= 3) {
                        value = submitted.get("__hsyco__wrng.wiring.option.value");
                        manned = submitted.get("__hsyco__wrng.wiring.option.manned");
                        delay = submitted.get("__hsyco__wrng.wiring.option.delay");
                        hold = submitted.get("__hsyco__wrng.wiring.option.hold");
                        ratio = submitted.get("__hsyco__wrng.wiring.option.ratio");
                        schedVal = submitted.get("__hsyco__wrng.wiring.scheduler.val");
                        oldW = null;
                        if (!wirCmd.equals("edit") || (oldW = wirings.get(id)) != null) break;
                        throw new Exception("Wiring not found");
                    }
                    stringArray[i7] = submitted.get("__hsyco__wrng.wiring.input." + i7 + ".list");
                    ++i7;
                }
                if (name.equals("")) {
                    throw new UserException(UIText.INSERT_A_NAME);
                }
                if (oldW == null || !oldW.name.equals(name)) {
                    for (Wiring w : wirings.values()) {
                        if (!w.name.equals(name)) continue;
                        throw new UserException(UIText.NAME_ALREADY_USED);
                    }
                }
                if (typeOut.equals("")) {
                    throw new UserException(UIText.SELECT_AN_OUTPUT_TYPE);
                }
                if (function.equals("")) {
                    throw new UserException(UIText.SELECT_A_FUNCTION);
                }
                if (out.equals("")) {
                    throw new UserException(UIText.SELECT_AN_OUTPUT);
                }
                Wiring newW = Wiring.getInstance(name, typeOut, function, out, stringArray, value, manned, delay, hold, ratio, schedVal, oldW);
                WiringEditor.uiClear(session);
                if (oldW != null) {
                    wirings.remove(oldW.id);
                }
                wirings.put(newW.id, newW);
                inputs.update(null);
                outputs.update(null);
                if (!wirCmd.equals("new")) return "!page:close";
                if (!(newW instanceof WiringScenario)) return "!page:close";
                WiringEditor.uiSet("wiring.scenario.outval", "text", newW.output.getScenarioString((WiringScenario)newW), session);
                WiringEditor.uiSet("wiring.scenario.ok", "param", "menu", session);
                return "!page:wiring.scenario";
            }
            if (!cmd.startsWith("backup.")) throw new Exception("Unknown command");
            String buCmd = cmd.substring(7);
            if (!buCmd.equals("add")) throw new Exception("Unknown command");
            String name = submitted.get("__hsyco__wrng.backup.name");
            if (name.equals("")) {
                throw new UserException(UIText.INSERT_A_NAME);
            }
            Iterator<Backup> iterator = backups.values().iterator();
            do {
                if (!iterator.hasNext()) {
                    try {
                        WiringEditor.createBackUp(name);
                        return "!page:close";
                    }
                    catch (Exception e2) {
                        throw new UserException(e2.getLocalizedMessage());
                    }
                }
                b2 = iterator.next();
            } while (!b2.name.equals(name));
            throw new UserException(UIText.NAME_ALREADY_USED);
        }
        catch (UserException e3) {
            WiringEditor.uiSet("warning.message", "text", e3.getLocalizedMessage(), session);
            WiringEditor.log(1, "UserException: " + e3.getLocalizedMessage());
            return "!page:warning.popup";
        }
        catch (Throwable e4) {
            WiringEditor.log(0, "error processing submit command '" + cmd + "' - " + WiringEditor.getStackTrace(e4));
            return "!error";
        }
    }

    public static boolean UserTimerEvent(String name, boolean active) {
        Input i2;
        block7: {
            block6: {
                if (!ready) {
                    return true;
                }
                i2 = addedInputs.get(name);
                if (i2 != null) break block6;
                return true;
            }
            if (i2 instanceof InputScheduler) break block7;
            return true;
        }
        try {
            WiringEditor.log(1, "processing scheduler input '" + name + " = " + active + "'");
            ((InputScheduler)i2).setValue(active);
            for (Wiring w : wirings.values()) {
                w.event(i2, i2.getValue());
            }
        }
        catch (Throwable e2) {
            WiringEditor.log(0, "error processing scheduler event '" + name + " = " + active + "' - " + WiringEditor.getStackTrace(e2));
        }
        return true;
    }

    public static void programTimerEvent(String name) {
        try {
            if (name.startsWith("_WIRINGEDITOR_HWGIO_DISCOVERY:")) {
                String ioServerName = name.substring(30).toLowerCase();
                Set<String> ids = util.ioListByServerName(ioServerName);
                for (String id : ids) {
                    String dp = id.substring(ioServerName.length() + 1);
                    if (dp.charAt(0) == 'i') {
                        WiringEditor.addInput(id, "HWG IO");
                        continue;
                    }
                    if (dp.charAt(0) != 'o') continue;
                    WiringEditor.addOutput(id, "HWG IO");
                }
                if (fillInWhiteList) {
                    WiringEditor.updateInWhiteListFile();
                }
                if (fillOutWhiteList) {
                    WiringEditor.updateOutWhiteListFile();
                }
                WiringEditor.checkInGroups();
                WiringEditor.checkOutGroups();
                WiringEditor.checkWirings();
            }
        }
        catch (Throwable e2) {
            WiringEditor.log(0, "error processing timer event '" + name + "' - " + WiringEditor.getStackTrace(e2));
        }
    }

    public static void uiClearEvent(String session) {
        WiringEditor.uiSet("wiring", "page", "menu", session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBackup(String name, String path) throws Exception {
        String string = MAIN_FOLDER;
        synchronized (MAIN_FOLDER) {
            new File(IN_WHITELIST_FILE).delete();
            new File(OUT_WHITELIST_FILE).delete();
            new File(IN_BLACKLIST_FILE).delete();
            new File(OUT_BLACKLIST_FILE).delete();
            WiringEditor.unZip(path);
            ListManager bkInputs = (ListManager)WiringEditor.unSerializeFromFile(INPUTS_TEMP_BACKUP);
            ListManager bkOutputs = (ListManager)WiringEditor.unSerializeFromFile(OUTPUTS_TEMP_BACKUP);
            ListManager bkWirings = (ListManager)WiringEditor.unSerializeFromFile(WIRINGS_TEMP_BACKUP);
            HashMap bkAddedInputs = (HashMap)WiringEditor.unSerializeFromFile(ADDED_INPUTS_TEMP_BACKUP);
            HashMap bkAddedOutputs = (HashMap)WiringEditor.unSerializeFromFile(ADDED_OUTPUTS_TEMP_BACKUP);
            new File(INPUTS_TEMP_BACKUP).delete();
            new File(OUTPUTS_TEMP_BACKUP).delete();
            new File(WIRINGS_TEMP_BACKUP).delete();
            new File(ADDED_INPUTS_TEMP_BACKUP).delete();
            new File(ADDED_OUTPUTS_TEMP_BACKUP).delete();
            for (Input i2 : inputs.values()) {
                i2.onRemove();
            }
            for (Output o2 : outputs.values()) {
                o2.onRemove();
            }
            inputs = bkInputs;
            outputs = bkOutputs;
            wirings = bkWirings;
            addedInputs = bkAddedInputs;
            addedOutputs = bkAddedOutputs;
            WiringEditor.loadLists(false);
            for (Input i2 : inputs.values()) {
                i2.setName(i2.name);
                i2.setValueType(i2.valueType);
            }
            for (Output o2 : outputs.values()) {
                o2.setName(o2.name);
                o2.setValueType(o2.valueType);
                o2.saveScenarios();
                o2.checkScenarios();
            }
            wirings.save(null);
            Database.save("added_inputs", addedInputs);
            Database.save("added_outputs", addedOutputs);
            int w_count = 0;
            for (Wiring w : wirings.values()) {
                int id = Integer.parseInt(w.id);
                if (id <= w_count) continue;
                w_count = id;
            }
            Wiring.wirings_count = w_count + 1;
            Database.save("wirings_count", Wiring.wirings_count);
            int ig_count = 0;
            for (Input i3 : addedInputs.values()) {
                int id;
                if (!(i3 instanceof InputGroup) || (id = Integer.parseInt(i3.id.replace("_in_group_", ""))) <= ig_count) continue;
                ig_count = id;
            }
            InputGroup.in_groups_count = ig_count + 1;
            Database.save("in_groups_count", InputGroup.in_groups_count);
            int og_count = 0;
            for (Output o3 : addedOutputs.values()) {
                int id;
                if (!(o3 instanceof OutputGroup) || (id = Integer.parseInt(o3.id.replace("_out_group_", ""))) <= og_count) continue;
                og_count = id;
            }
            OutputGroup.out_groups_count = og_count + 1;
            Database.save("out_groups_count", OutputGroup.out_groups_count);
            WiringEditor.checkInGroups();
            WiringEditor.checkOutGroups();
            WiringEditor.checkWirings();
            util.haFilesChangeNotify();
            WiringEditor.log(3, "Backup loaded: " + name + " (" + path + ")");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createBackUp(String name) throws Exception {
        String string = MAIN_FOLDER;
        synchronized (MAIN_FOLDER) {
            long ts = System.currentTimeMillis();
            SimpleDateFormat filePathFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
            String backupPath = BACKUP_FOLDER + filePathFormat.format(ts) + ".wbu";
            String[] files = new String[]{INPUTS_TEMP_BACKUP, OUTPUTS_TEMP_BACKUP, WIRINGS_TEMP_BACKUP, ADDED_INPUTS_TEMP_BACKUP, ADDED_OUTPUTS_TEMP_BACKUP, IN_WHITELIST_FILE, OUT_WHITELIST_FILE, IN_BLACKLIST_FILE, OUT_BLACKLIST_FILE};
            try {
                WiringEditor.serializeToFile(inputs, files[0]);
                WiringEditor.serializeToFile(outputs, files[1]);
                WiringEditor.serializeToFile(wirings, files[2]);
                WiringEditor.serializeToFile(addedInputs, files[3]);
                WiringEditor.serializeToFile(addedOutputs, files[4]);
                WiringEditor.zip(files, backupPath, String.valueOf(ts) + "\n" + name);
                new File(files[0]).delete();
                new File(files[1]).delete();
                new File(files[2]).delete();
                new File(files[3]).delete();
                new File(files[4]).delete();
                backups.put("" + ts, new Backup(ts, backupPath, name));
                backups_lastModified = new File(BACKUP_FOLDER).lastModified();
                WiringEditor.log(3, "Backup created: " + name + " (" + backupPath + ")");
            }
            catch (Exception e2) {
                throw new Exception("Error creating backup: " + e2.getLocalizedMessage());
            }
            return;
        }
    }

    private static void serializeToFile(Serializable obj, String file) throws IOException {
        ObjectOutputStream oos = null;
        try {
            File f2 = new File(file);
            f2.getParentFile().mkdirs();
            oos = new ObjectOutputStream(new FileOutputStream(f2));
            oos.writeObject(obj);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static <T extends Serializable> T unSerializeFromFile(String file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        ois = new ObjectInputStream(new FileInputStream(file));
        Object o2 = ois.readObject();
        Serializable serializable = (Serializable)o2;
        return (T)serializable;
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void zip(String[] files, String zipFile, String extraData) throws IOException {
        ZipOutputStream zos = null;
        FileInputStream fis = null;
        byte[] buffer = new byte[1024];
        try {
            File f2 = new File(zipFile);
            f2.getParentFile().mkdirs();
            zos = new ZipOutputStream(new FileOutputStream(f2));
            ZipEntry extras = new ZipEntry("extras");
            extras.setExtra(extraData.getBytes());
            zos.putNextEntry(extras);
            try {
                zos.closeEntry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                String file = stringArray[n3];
                try {
                    int len;
                    fis = new FileInputStream(file);
                    ZipEntry ze = new ZipEntry(file);
                    zos.putNextEntry(ze);
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    try {
                        zos.closeEntry();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                ++n3;
            }
        }
        finally {
            try {
                zos.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void unZip(String zipFile) throws IOException {
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        byte[] buffer = new byte[1024];
        try {
            zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                if (!fileName.equals("extras")) {
                    int len;
                    fos = new FileOutputStream(new File(fileName));
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    zis.closeEntry();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            try {
                zis.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void varEvent(String name, String value) {
        try {
            if (!ready) {
                return;
            }
            if (!WiringEditor.haActiveState() && Configuration.haMode == -1 && (name = name.toLowerCase()).startsWith(PREFIX)) {
                if ((name = name.substring(PREFIX.length())).equals("wirings_count!")) {
                    try {
                        Wiring.wirings_count = Database.loadInt("wirings_count");
                    }
                    catch (Exception e2) {
                        Wiring.wirings_count = 0;
                    }
                } else if (name.equals("out_groups_count!")) {
                    try {
                        OutputGroup.out_groups_count = Database.loadInt("out_groups_count");
                    }
                    catch (Exception e3) {
                        OutputGroup.out_groups_count = 0;
                    }
                } else if (name.equals("in_groups_count!")) {
                    try {
                        InputGroup.in_groups_count = Database.loadInt("in_groups_count");
                    }
                    catch (Exception e4) {
                        InputGroup.in_groups_count = 0;
                    }
                } else if (name.equals("wiring.map!")) {
                    WiringEditor.reloadWirings();
                    WiringEditor.reloadAddedOutputs();
                } else if (name.equals("added_inputs.map!")) {
                    WiringEditor.reloadAddedInputs();
                } else if (name.equals("added_outputs.map!")) {
                    WiringEditor.reloadAddedOutputs();
                } else if (name.endsWith(".name!")) {
                    String id = name.substring(0, name.length() - 6);
                    if (value.length() != 0) {
                        Output o2;
                        Input i2;
                        WiringEditor.log(1, "Datapoint name changed on master: " + id);
                        if (inputs != null && (i2 = inputs.get(id)) != null) {
                            i2.setName(value);
                            inputs.update(null);
                        }
                        if (outputs != null && (o2 = outputs.get(id)) != null) {
                            o2.setName(value);
                            outputs.update(null);
                        }
                    }
                } else if (name.endsWith(".valuetype!")) {
                    String id = name.substring(0, name.length() - 11);
                    if (value.length() != 0) {
                        Output o3;
                        Input i3;
                        WiringEditor.log(1, "Datapoint valuetype changed on master: " + id);
                        if (inputs != null && (i3 = inputs.get(id)) != null) {
                            i3.setValueType(Integer.parseInt(value));
                            inputs.update(null);
                        }
                        if (outputs != null && (o3 = outputs.get(id)) != null) {
                            o3.setValueType(Integer.parseInt(value));
                            outputs.update(null);
                        }
                    }
                }
            }
        }
        catch (Throwable e5) {
            WiringEditor.log(0, "error processing varEvent '" + name + " = " + value + "' - " + WiringEditor.getStackTrace(e5));
        }
    }

    private static void reloadAddedOutputs() throws Exception {
        HashMap addedOutputs_new;
        try {
            addedOutputs_new = Database.loadStringHashMap("added_outputs");
        }
        catch (IOException e2) {
            addedOutputs_new = new HashMap();
        }
        for (Output o2 : addedOutputs_new.values()) {
            outputs.put(o2.id, o2);
        }
        for (Output o2 : addedOutputs.values()) {
            if (addedOutputs_new.containsKey(o2.id)) continue;
            outputs.remove(o2.id);
        }
        addedOutputs = addedOutputs_new;
        WiringEditor.checkOutGroups();
        WiringEditor.checkWirings();
    }

    private static void reloadAddedInputs() throws Exception {
        HashMap addedInputs_new;
        try {
            addedInputs_new = Database.loadStringHashMap("added_inputs");
        }
        catch (IOException e2) {
            addedInputs_new = new HashMap();
        }
        for (Input i2 : addedInputs_new.values()) {
            inputs.put(i2.id, i2);
        }
        for (Input i2 : addedInputs.values()) {
            if (addedInputs_new.containsKey(i2.id)) continue;
            inputs.remove(i2.id);
        }
        addedInputs = addedInputs_new;
        WiringEditor.checkInGroups();
        WiringEditor.checkWirings();
    }

    private static void reloadWirings() throws Exception {
        WiringEditor.log(1, "reloading wirings");
        wirings.load();
        wirings.update(null);
        for (Output o2 : outputs.values()) {
            o2.checkScenarios();
        }
        WiringEditor.checkWirings();
    }

    public static void IOEvent(String name, String value) {
        try {
            if (!ready) {
                return;
            }
            Input i2 = inputs.get(name);
            if (i2 != null) {
                WiringEditor.inputEvent(i2, value);
                return;
            }
            Output o2 = outputs.get(name);
            if (o2 != null) {
                WiringEditor.outputEvent(o2);
                return;
            }
        }
        catch (Throwable e2) {
            WiringEditor.log(0, "error processing event '" + name + " = " + value + "' - " + WiringEditor.getStackTrace(e2));
        }
    }

    private static void addInput(String id, String typeName) throws Exception {
        if (inWhiteList != null && !inWhiteList.contains(id) && !fillInWhiteList) {
            return;
        }
        if (inBlackList != null && inBlackList.contains(id)) {
            return;
        }
        if (!inputs.containsKey(id)) {
            inputs.put(id, new Input(id, typeName));
        }
    }

    private static void addOutput(String id, String typeName) throws Exception {
        if (outWhiteList != null && !outWhiteList.contains(id) && !fillOutWhiteList) {
            return;
        }
        if (outBlackList != null && outBlackList.contains(id)) {
            return;
        }
        if (!outputs.containsKey(id)) {
            outputs.put(id, new Output(id, typeName));
        }
    }

    private static void inputEvent(Input i2, String value) throws Exception {
        WiringEditor.log(1, "processing input event '" + i2.id + " = " + value + "'");
        for (Wiring w : wirings.values()) {
            w.event(i2, value);
        }
        int j2 = 0;
        while (j2 < 3) {
            for (String session : wiringInputSessions[j2]) {
                WiringEditor.uiSet("wiring.input." + j2 + ".list", "value", i2.id, session);
            }
            ++j2;
        }
    }

    private static void outputEvent(Output o2) throws Exception {
        WiringEditor.log(1, "processing output event '" + o2.id + "'");
        for (String session : wiringOutputSessions) {
            WiringEditor.uiSet("wiring.output.list", "value", o2.id, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateInWhiteListFile() throws IOException {
        String string = MAIN_FOLDER;
        synchronized (MAIN_FOLDER) {
            BufferedWriter bw = null;
            try {
                ArrayList<String> ids = new ArrayList<String>();
                for (Input i2 : inputs.values()) {
                    if (i2 instanceof InputUser || i2 instanceof InputGroup || i2 instanceof InputScheduler) continue;
                    ids.add(i2.id);
                }
                Collections.sort(ids);
                File inwl = new File(IN_WHITELIST_FILE);
                inwl.getParentFile().mkdirs();
                bw = new BufferedWriter(new FileWriter(inwl));
                for (String id : ids) {
                    bw.write(id);
                    bw.write("\n");
                }
                bw.flush();
                inWhiteList_lastModified = inwl.lastModified();
                util.haFilesChangeNotify();
            }
            finally {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateOutWhiteListFile() throws IOException {
        String string = MAIN_FOLDER;
        synchronized (MAIN_FOLDER) {
            BufferedWriter bw = null;
            try {
                ArrayList<String> ids = new ArrayList<String>();
                for (Output o2 : outputs.values()) {
                    if (o2 instanceof OutputUser || o2 instanceof OutputGroup) continue;
                    ids.add(o2.id);
                }
                Collections.sort(ids);
                File outwl = new File(OUT_WHITELIST_FILE);
                outwl.getParentFile().mkdirs();
                bw = new BufferedWriter(new FileWriter(outwl));
                for (String id : ids) {
                    bw.write(id);
                    bw.write("\n");
                }
                bw.flush();
                inWhiteList_lastModified = outwl.lastModified();
                util.haFilesChangeNotify();
            }
            finally {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void checkWirings() throws Exception {
        for (Wiring w : wirings.values()) {
            w.check();
        }
        wirings.update(null);
    }

    static void checkOutGroups() throws Exception {
        for (Output o2 : addedOutputs.values()) {
            if (!(o2 instanceof OutputGroup)) continue;
            ((OutputGroup)o2).check();
        }
        outputs.update(null);
    }

    static void checkBackups() throws Exception {
        File bkFolder = new File(BACKUP_FOLDER);
        File[] filesList = bkFolder.listFiles();
        if (filesList == null) {
            return;
        }
        if (backups_lastModified == bkFolder.lastModified()) {
            return;
        }
        WiringEditor.log(1, "backup files modified. Reloading...");
        backups.clearMap();
        File[] fileArray = filesList;
        int n2 = filesList.length;
        int n3 = 0;
        while (n3 < n2) {
            String bkName;
            File bkFile = fileArray[n3];
            if (bkFile.isFile() && (bkName = bkFile.getName()).endsWith(".wbu")) {
                ZipInputStream zis = null;
                try {
                    zis = new ZipInputStream(new FileInputStream(bkFile));
                    ZipEntry ze = zis.getNextEntry();
                    while (ze != null) {
                        if (ze.getName().equals("extras")) {
                            String extras = new String(ze.getExtra());
                            String[] ts_name = extras.split("\n");
                            long ts = Long.parseLong(ts_name[0]);
                            String name = ts_name[1];
                            backups.put("" + ts, new Backup(ts, bkFile.getPath(), name));
                        }
                        ze = zis.getNextEntry();
                    }
                }
                finally {
                    try {
                        zis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            ++n3;
        }
        backups_lastModified = bkFolder.lastModified();
        util.haFilesChangeNotify();
    }

    static void checkInGroups() throws Exception {
        for (Input i2 : addedInputs.values()) {
            if (!(i2 instanceof InputGroup)) continue;
            ((InputGroup)i2).check();
        }
        inputs.update(null);
    }

    public static void uiSet(String id, String attr, String value) {
        userBase.uiSet("__hsyco__wrng.scope!", PREFIX + id, attr, value);
    }

    public static void uiSet(String id, String attr, String value, String session) {
        userBase.uiSet(session, PREFIX + id, attr, value);
    }

    public static String uiGet(String id, String attr) {
        return userBase.uiGet(PREFIX + id, attr);
    }

    public static String uiGet(String id, String attr, String session) {
        return userBase.uiGet(session, PREFIX + id, attr);
    }

    private static String getStackTrace(Throwable e2) {
        try {
            StringWriter sw = new StringWriter();
            sw.append(e2.getLocalizedMessage());
            if (Configuration.verboseLog || debug) {
                sw.append("\n\t");
                e2.printStackTrace(new PrintWriter(sw));
            }
            return sw.toString();
        }
        catch (Throwable t) {
            return e2.getLocalizedMessage();
        }
    }

    static void log(int tag, String message) {
        switch (tag) {
            case 2: {
                WiringEditor.messageLog("[WIRING EDITOR] Warning | " + message);
                break;
            }
            case 3: {
                WiringEditor.messageLog("[WIRING EDITOR] Message | " + message);
                break;
            }
            case 0: {
                WiringEditor.errorLog("[WIRING EDITOR] Error | " + message);
                break;
            }
            case 1: {
                if (!Configuration.verboseLog) break;
                WiringEditor.messageLog("[WIRING EDITOR] Verbose | " + message);
                break;
            }
        }
    }

    static class UserException
    extends Exception {
        private static final long serialVersionUID = -7801148157881016332L;

        UserException(String message) {
            super(message);
        }
    }

    static abstract class UserTask
    implements Runnable {
        private static HashMap<Object, UserTask> instances = new HashMap();
        private Thread thisThread;
        private final Object reference;

        UserTask(Object reference) {
            UserTask.interrupt(reference);
            this.reference = reference;
            instances.put(reference, this);
            executor.execute(this);
        }

        protected abstract void task() throws InterruptedException;

        @Override
        public void run() {
            this.thisThread = Thread.currentThread();
            try {
                this.task();
                instances.remove(this.reference);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public static void interrupt(Object reference) {
            UserTask task = instances.remove(reference);
            if (task != null) {
                task.interrupt();
            }
        }

        private void interrupt() {
            this.thisThread.interrupt();
        }
    }
}

