/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;

public class WiringDimmer
extends Wiring {
    private static final long serialVersionUID = -4246551432301300212L;
    static final int FUNCTION_CYCLE = 0;
    static final int FUNCTION_2WAYS = 1;
    static final int FUNCTION_3WAYS = 2;
    static final int FUNCTION_LEVEL = 3;
    public static final String functionsValues;
    public static final String functionsLabels;
    public static final Vector<Wiring.Function> functions;
    private final float ratio;
    private boolean sendOn;
    private boolean sendOff;

    static {
        functions = new Vector(4);
        functions.add(0, new Wiring.Function(0, "Cycle", new String[]{"Input:"}, null));
        functions.add(1, new Wiring.Function(1, "2-Ways", new String[]{"Input - up/on:", "Input - down/off:"}, null));
        functions.add(2, new Wiring.Function(2, "3-Ways", new String[]{"Input - up:", "Input - down:", "Input - on/off:"}, null));
        functions.add(3, new Wiring.Function(3, "Level", new String[]{"Input:"}, "ratio"));
        String vals = "";
        String labs = "";
        for (Wiring.Function f2 : functions) {
            vals = String.valueOf(vals) + "," + f2.id;
            labs = String.valueOf(labs) + "," + f2.label;
        }
        functionsValues = vals.substring(1);
        functionsLabels = labs.substring(1);
    }

    public WiringDimmer(String dbString) {
        this(Database.split(dbString, ','));
    }

    private WiringDimmer(Vector<String> params) {
        super(params.get(0), params.get(1), WiringDimmer.getFunction(params.get(2)));
        this.output = new Output(params.get(3));
        this.ratio = Float.parseFloat(params.get(4));
        int i2 = 5;
        while (i2 < params.size()) {
            this.inputs[i2 - 5] = new Input(params.get(i2));
            ++i2;
        }
    }

    public WiringDimmer(String name, String function, Output o2, String[] ins, String ratio, Wiring edited) throws Exception {
        super(name, WiringDimmer.getFunction(function), o2, ins, edited);
        try {
            this.ratio = Float.parseFloat(ratio.replace(',', '.'));
        }
        catch (Exception e2) {
            throw new WiringEditor.UserException("Ratio value not allowed: " + ratio);
        }
        if (this.ratio <= 0.0f) {
            throw new WiringEditor.UserException("The ratio value must be greater than 0");
        }
    }

    public static Wiring.Function getFunction(String function) {
        return functions.get(Integer.parseInt(function));
    }

    @Override
    protected void uiSet(String session) throws Exception {
        WiringEditor.uiSet("wiring.type.out", "value", "dimmer", session);
        WiringEditor.uiSet("wiring.function", "values", functionsValues, session);
        WiringEditor.uiSet("wiring.function", "labels", functionsLabels, session);
        this.function.uiSet(session);
        WiringEditor.uiSet("wiring.option.ratio", "value", "" + this.ratio, session);
        WiringEditor.uiSet("info.function", "param", "function.dimmer", session);
        WiringEditor.uiSet("info.function", "visible", "true", session);
        WiringEditor.inputs.update("dimmer/" + this.function.id, session);
        WiringEditor.outputs.update("dimmer", session);
    }

    @Override
    protected void execute(final Input i2, String value) {
        if (this.function.id == 0) {
            if (value.equals("1")) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                new WiringEditor.UserTask(this.output){

                    @Override
                    public void task() throws InterruptedException {
                        int currValInt;
                        String currVal = WiringDimmer.this.output.getValue();
                        if (currVal != null && (currVal.equals("off") || currVal.equals("0"))) {
                            WiringDimmer.this.sendOn = true;
                            Thread.sleep(1000L);
                            WiringDimmer.this.sendOn = false;
                        } else {
                            WiringDimmer.this.sendOff = true;
                            Thread.sleep(1000L);
                            WiringDimmer.this.sendOff = false;
                        }
                        try {
                            currValInt = Integer.parseInt(currVal.replace("%", ""));
                        }
                        catch (Exception e2) {
                            currValInt = 0;
                        }
                        boolean up = true;
                        if (currValInt > 50) {
                            up = false;
                        }
                        while (i2.getValue().equals("1") && (up && currValInt < 100 || !up && currValInt > 0)) {
                            if (up) {
                                if ((currValInt += 10) > 100) {
                                    currValInt = 100;
                                }
                            } else if ((currValInt -= 10) < 0) {
                                currValInt = 0;
                            }
                            WiringDimmer.this.output.setValue(String.valueOf(currValInt) + "%");
                            Thread.sleep(500L);
                        }
                    }
                };
            } else if (this.sendOn) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("on");
                this.sendOn = false;
            } else if (this.sendOff) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("off");
                this.sendOff = false;
            }
        } else if (this.function.id == 1) {
            if (value.equals("1")) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                new WiringEditor.UserTask(this.output){

                    /*
                     * Handled impossible loop by duplicating code
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void task() throws InterruptedException {
                        int currValInt;
                        block14: {
                            int currValInt2;
                            block13: {
                                if (WiringDimmer.this.inputs[0].matches(i2)) {
                                    String currVal = WiringDimmer.this.output.getValue();
                                    if (currVal == null || currVal.equals("off") || currVal.equals("0")) {
                                        WiringDimmer.this.sendOn = true;
                                        Thread.sleep(1000L);
                                        WiringDimmer.this.sendOn = false;
                                    }
                                    try {
                                        currValInt2 = Integer.parseInt(currVal.replace("%", ""));
                                        if (!i2.getValue().equals("1")) return;
                                        if (currValInt2 < 100) break block13;
                                        return;
                                    }
                                    catch (Exception e2) {
                                        currValInt2 = 0;
                                    }
                                    if (true) {
                                        if (!i2.getValue().equals("1")) return;
                                        if (currValInt2 >= 100) return;
                                    }
                                } else {
                                    if (!WiringDimmer.this.inputs[1].matches(i2)) return;
                                    String currVal = WiringDimmer.this.output.getValue();
                                    if (currVal == null || !currVal.equals("off") && !currVal.equals("0")) {
                                        WiringDimmer.this.sendOff = true;
                                        Thread.sleep(1000L);
                                        WiringDimmer.this.sendOff = false;
                                    }
                                    try {
                                        currValInt = Integer.parseInt(currVal.replace("%", ""));
                                        if (!true) break block14;
                                        if (!i2.getValue().equals("1")) return;
                                        if (currValInt <= 0) return;
                                    }
                                    catch (Exception e3) {
                                        WiringDimmer.this.output.setValue("off");
                                        return;
                                    }
                                }
                            }
                            do {
                                if ((currValInt2 += 10) > 100) {
                                    currValInt2 = 100;
                                }
                                WiringDimmer.this.output.setValue(String.valueOf(currValInt2) + "%");
                                Thread.sleep(500L);
                                if (!i2.getValue().equals("1")) return;
                            } while (currValInt2 < 100);
                            return;
                        }
                        do {
                            if ((currValInt -= 10) < 0) {
                                currValInt = 0;
                            }
                            WiringDimmer.this.output.setValue(String.valueOf(currValInt) + "%");
                            Thread.sleep(500L);
                            if (!i2.getValue().equals("1")) return;
                        } while (currValInt > 0);
                    }
                };
            } else if (this.inputs[0].matches(i2) && this.sendOn) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("on");
                this.sendOn = false;
            } else if (this.inputs[1].matches(i2) && this.sendOff) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("off");
                this.sendOff = false;
            }
        } else if (this.function.id == 2) {
            if (value.equals("1")) {
                WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
                if (this.inputs[0].matches(i2)) {
                    new WiringEditor.UserTask(this.output){

                        @Override
                        public void task() throws InterruptedException {
                            int currValInt;
                            String currVal = WiringDimmer.this.output.getValue();
                            try {
                                currValInt = Integer.parseInt(currVal.replace("%", ""));
                            }
                            catch (Exception e2) {
                                currValInt = 0;
                            }
                            while (i2.getValue().equals("1") && currValInt < 100) {
                                if ((currValInt += 10) > 100) {
                                    currValInt = 100;
                                }
                                WiringDimmer.this.output.setValue(String.valueOf(currValInt) + "%");
                                Thread.sleep(500L);
                            }
                        }
                    };
                } else if (this.inputs[1].matches(i2)) {
                    new WiringEditor.UserTask(this.output){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public void task() throws InterruptedException {
                            currVal = WiringDimmer.this.output.getValue();
                            if (currVal != null && (currVal.equals("off") || currVal.equals("0"))) {
                                return;
                            }
                            try {
                                currValInt = Integer.parseInt(currVal.replace("%", ""));
                                if (true) ** GOTO lbl15
                            }
                            catch (Exception e) {
                                WiringDimmer.this.output.setValue("off");
                                return;
                            }
                            do {
                                if ((currValInt -= 10) < 0) {
                                    currValInt = 0;
                                }
                                WiringDimmer.this.output.setValue(String.valueOf(currValInt) + "%");
                                Thread.sleep(500L);
lbl15:
                                // 2 sources

                            } while (i2.getValue().equals("1") && currValInt > 0);
                        }
                    };
                } else if (this.inputs[2].matches(i2)) {
                    WiringEditor.UserTask.interrupt(this.output);
                    String currVal = this.output.getValue();
                    if (currVal != null && (currVal.equals("off") || currVal.equals("0"))) {
                        this.output.setValue("on");
                    } else {
                        this.output.setValue("off");
                    }
                }
            }
        } else if (this.function.id == 3) {
            WiringEditor.log(3, "Executing dimmer wiring '" + this.name + "'");
            WiringEditor.UserTask.interrupt(this.output);
            if (!value.equals("off") && !value.equals("0")) {
                int v = Integer.parseInt(value.replace("%", ""));
                if ((v = (int)((float)v * this.ratio)) > 100) {
                    v = 100;
                }
                value = String.valueOf(v) + "%";
            }
            this.output.setValue(value);
        }
    }

    @Override
    protected String getOutputTypeName() {
        return "Dimmer";
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.function.id).append(",");
        dbString.append(this.output.id.replace(",", ",,")).append(",");
        dbString.append(this.ratio);
        Input[] inputArray = this.inputs;
        int n2 = this.inputs.length;
        int n3 = 0;
        while (n3 < n2) {
            Input i2 = inputArray[n3];
            dbString.append(',').append(i2.id.replace(",", ",,"));
            ++n3;
        }
        return dbString.toString();
    }
}

