/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;

public class WiringBlind
extends Wiring {
    private static final long serialVersionUID = -5866445974132546831L;
    private static final int FUNCTION_CYCLE = 0;
    private static final int FUNCTION_2WAYS = 1;
    private static final int FUNCTION_3WAYS = 2;
    public static final String functionsValues;
    public static final String functionsLabels;
    public static final Vector<Wiring.Function> functions;
    private final boolean manned;
    private boolean sendStop;

    static {
        functions = new Vector(3);
        functions.add(0, new Wiring.Function(0, "Cycle", new String[]{"Input:"}, "manned"));
        functions.add(1, new Wiring.Function(1, "2-Ways", new String[]{"Input - up/stop:", "Input - down/stop:"}, "manned"));
        functions.add(2, new Wiring.Function(2, "3-Ways", new String[]{"Input - up:", "Input - down:", "Input - stop:"}, null));
        String vals = "";
        String labs = "";
        for (Wiring.Function f2 : functions) {
            vals = String.valueOf(vals) + "," + f2.id;
            labs = String.valueOf(labs) + "," + f2.label;
        }
        functionsValues = vals.substring(1);
        functionsLabels = labs.substring(1);
    }

    public WiringBlind(String dbString) {
        this(Database.split(dbString, ','));
    }

    private WiringBlind(Vector<String> params) {
        super(params.get(0), params.get(1), WiringBlind.getFunction(params.get(2)));
        this.output = new Output(params.get(3));
        this.manned = Boolean.parseBoolean(params.get(4));
        int i2 = 5;
        while (i2 < params.size()) {
            this.inputs[i2 - 5] = new Input(params.get(i2));
            ++i2;
        }
    }

    public WiringBlind(String name, String function, Output o2, String[] ins, String manned, Wiring edited) throws Exception {
        super(name, WiringBlind.getFunction(function), o2, ins, edited);
        this.manned = Boolean.parseBoolean(manned);
    }

    public static Wiring.Function getFunction(String function) {
        return functions.get(Integer.parseInt(function));
    }

    @Override
    protected void uiSet(String session) throws Exception {
        WiringEditor.uiSet("wiring.type.out", "value", "blind", session);
        WiringEditor.uiSet("wiring.function", "values", functionsValues, session);
        WiringEditor.uiSet("wiring.function", "labels", functionsLabels, session);
        this.function.uiSet(session);
        WiringEditor.uiSet("wiring.option.manned", "value", "" + this.manned, session);
        WiringEditor.uiSet("info.function", "param", "function.blind", session);
        WiringEditor.uiSet("info.function", "visible", "true", session);
        WiringEditor.inputs.update("blind", session);
        WiringEditor.outputs.update("blind", session);
    }

    @Override
    protected void execute(final Input i2, String value) {
        if (this.function.id == 0) {
            if (this.manned) {
                WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                if (value.equals("1")) {
                    this.flip();
                } else {
                    this.output.setValue("stop");
                }
            } else if (value.equals("1")) {
                WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
                new WiringEditor.UserTask(this.output){

                    @Override
                    protected void task() throws InterruptedException {
                        WiringBlind.this.flip();
                        Thread.sleep(1000L);
                        if (i2.getValue().equals("1")) {
                            WiringBlind.this.sendStop = true;
                        }
                    }
                };
            } else if (this.sendStop) {
                WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("stop");
                this.sendStop = false;
            }
        } else if (this.function.id == 1) {
            if (this.manned) {
                WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
                if (value.equals("1")) {
                    if (this.inputs[0].matches(i2)) {
                        WiringEditor.UserTask.interrupt(this.output);
                        this.output.setValue("up");
                    } else if (this.inputs[1].matches(i2)) {
                        WiringEditor.UserTask.interrupt(this.output);
                        this.output.setValue("down");
                    }
                } else {
                    WiringEditor.UserTask.interrupt(this.output);
                    this.output.setValue("stop");
                }
            } else if (value.equals("1")) {
                WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
                if (this.inputs[0].matches(i2)) {
                    String currValue = this.output.getValue();
                    if (currValue != null && (currValue.equals("up") || currValue.equals("down"))) {
                        WiringEditor.UserTask.interrupt(this.output);
                        this.output.setValue("stop");
                    } else {
                        new WiringEditor.UserTask(this.output){

                            @Override
                            protected void task() throws InterruptedException {
                                WiringBlind.this.output.setValue("up");
                                Thread.sleep(1000L);
                                if (i2.getValue().equals("1")) {
                                    WiringBlind.this.sendStop = true;
                                }
                            }
                        };
                    }
                } else if (this.inputs[1].matches(i2)) {
                    String currValue = this.output.getValue();
                    if (currValue != null && (currValue.equals("up") || currValue.equals("down"))) {
                        WiringEditor.UserTask.interrupt(this.output);
                        this.output.setValue("stop");
                    } else {
                        new WiringEditor.UserTask(this.output){

                            @Override
                            protected void task() throws InterruptedException {
                                WiringBlind.this.output.setValue("down");
                                Thread.sleep(1000L);
                                if (i2.getValue().equals("1")) {
                                    WiringBlind.this.sendStop = true;
                                }
                            }
                        };
                    }
                }
            } else if (this.sendStop) {
                WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("stop");
                this.sendStop = false;
            }
        } else if (this.function.id == 2 && value.equals("1")) {
            WiringEditor.log(3, "Executing blind wiring '" + this.name + "'");
            if (this.inputs[0].matches(i2)) {
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("up");
            } else if (this.inputs[1].matches(i2)) {
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("down");
            } else if (this.inputs[2].matches(i2)) {
                WiringEditor.UserTask.interrupt(this.output);
                this.output.setValue("stop");
            }
        }
    }

    private void flip() {
        String currVal = this.output.getValue();
        String val = "down";
        if (currVal != null) {
            if (currVal.equals("up") || currVal.equals("down")) {
                val = "stop";
            } else if (currVal.equals("offdown")) {
                val = "up";
            } else if (currVal.equals("offup")) {
                val = "down";
            }
        }
        this.output.setValue(val);
    }

    @Override
    protected String getOutputTypeName() {
        return "Blind";
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.function.id).append(",");
        dbString.append(this.output.id.replace(",", ",,")).append(",");
        dbString.append(this.manned);
        Input[] inputArray = this.inputs;
        int n2 = this.inputs.length;
        int n3 = 0;
        while (n3 < n2) {
            Input i2 = inputArray[n3];
            dbString.append(',').append(i2.id.replace(",", ",,"));
            ++n3;
        }
        return dbString.toString();
    }
}

