/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Map;
import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.UIText;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringBlind;
import plugins.wiringeditor.WiringDimmer;
import plugins.wiringeditor.WiringEditor;
import plugins.wiringeditor.WiringOnOff;
import plugins.wiringeditor.WiringScenario;

public class OutputGroup
extends Output {
    private static final long serialVersionUID = -1653667228951034090L;
    static final int VALUE_TYPE_MIXED = -2;
    static int out_groups_count;
    Vector<Output> members = null;
    boolean ready = true;

    public OutputGroup(String dbString) {
        this(Database.split(dbString, ','));
    }

    private OutputGroup(Vector<String> params) {
        super(params.get(0), "Group", params.get(1), Integer.parseInt(params.get(2)));
        int memsSize = Integer.parseInt(params.get(3));
        this.members = new Vector(memsSize);
        int i2 = 4;
        while (i2 < 4 + memsSize) {
            this.members.add(new Output(params.get(i2)));
            ++i2;
        }
        i2 = 4 + memsSize;
        while (i2 < params.size()) {
            Wiring s = WiringEditor.wirings.get(params.get(i2));
            if (s != null && s instanceof WiringScenario) {
                this.scenarios.put((WiringScenario)s, params.get(i2 + 1));
            }
            i2 += 2;
        }
    }

    public OutputGroup(String name, String membersList) throws Exception {
        super(OutputGroup.generateID(), "Group", name, -1);
        this.setMembers(membersList);
    }

    private static String generateID() {
        String id = "_out_group_" + Integer.toString(out_groups_count++);
        Database.save("out_groups_count", out_groups_count);
        return id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    public void saveScenarios() {
    }

    @Override
    public void onRemove() {
    }

    void setMembers(String membersList) throws WiringEditor.UserException {
        String[] ms = membersList.split(",");
        if (ms.length < 2) {
            throw new WiringEditor.UserException(UIText.SELECT_AT_LEAST_TWO_MEMBERS);
        }
        if (this.members == null || this.scenarios.isEmpty()) {
            Vector<Output> newMembers = new Vector<Output>(ms.length);
            String[] stringArray = ms;
            int n2 = ms.length;
            int n3 = 0;
            while (n3 < n2) {
                String m2 = stringArray[n3];
                newMembers.add(WiringEditor.outputs.get(m2));
                ++n3;
            }
            this.valueType = this.getValueTypeAndCheck(newMembers);
            this.members = newMembers;
        } else {
            Vector<Output> oldMembers = new Vector<Output>(this.members);
            Vector<Output> newMembers = new Vector<Output>(ms.length);
            String[] stringArray = ms;
            int n4 = ms.length;
            int n5 = 0;
            while (n5 < n4) {
                String m3 = stringArray[n5];
                Output o2 = WiringEditor.outputs.get(m3);
                oldMembers.remove(o2);
                newMembers.add(o2);
                ++n5;
            }
            this.valueType = this.getValueTypeAndCheck(newMembers);
            this.members = newMembers;
            for (WiringScenario s : this.scenarios.keySet()) {
                for (Output o3 : oldMembers) {
                    o3.removeScenario(s);
                }
            }
        }
    }

    @Override
    public void removeScenario(WiringScenario scenario) {
        super.removeScenario(scenario);
        for (Output o2 : this.members) {
            o2.removeScenario(scenario);
        }
    }

    private int getValueTypeAndCheck(Vector<Output> outputs) throws WiringEditor.UserException {
        int type = -1;
        for (Output o2 : outputs) {
            if (type == -1 && o2.valueType != -1) {
                type = o2.valueType;
                continue;
            }
            if (o2.valueType == -1 || o2.valueType == type) continue;
            type = -2;
            break;
        }
        if (type != -1) {
            for (Wiring w : WiringEditor.wirings.values()) {
                if (!w.hasOutput(this)) continue;
                if (w instanceof WiringOnOff && type != 0) {
                    throw new WiringEditor.UserException(String.valueOf(UIText.THIS_GROUP_IS_USED_BY_A_ONOFF_WIRING) + ", " + UIText.ONE_OR_MORE_MEMBERS_HAVE_NOT_COMPATIBLE_VALUE_TYPES);
                }
                if (w instanceof WiringDimmer && type != 1) {
                    throw new WiringEditor.UserException(String.valueOf(UIText.THIS_GROUP_IS_USED_BY_A_DIMMER_WIRING) + ", " + UIText.ONE_OR_MORE_MEMBERS_HAVE_NOT_COMPATIBLE_VALUE_TYPES);
                }
                if (!(w instanceof WiringBlind) || type == 2) continue;
                throw new WiringEditor.UserException(String.valueOf(UIText.THIS_GROUP_IS_USED_BY_A_BLIND_WIRING) + ", " + UIText.ONE_OR_MORE_MEMBERS_HAVE_NOT_COMPATIBLE_VALUE_TYPES);
            }
        }
        for (Output o2 : outputs) {
            if (!(o2 instanceof OutputGroup) || !((OutputGroup)o2).matches(this)) continue;
            throw new WiringEditor.UserException(String.valueOf(UIText.THE_MEMBER) + " '" + o2.name + "' " + UIText.CREATES_A_RECURSION);
        }
        return type;
    }

    private boolean matches(OutputGroup anotherOutput) {
        if (this == anotherOutput) {
            return true;
        }
        for (Output m2 : this.members) {
            if (!(m2 instanceof OutputGroup) || !((OutputGroup)m2).matches(anotherOutput)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String select(String list, boolean repeat, boolean up, String session) throws Exception {
        if (repeat) {
            WiringEditor.uiSet("output.id", "text", this.id, session);
            WiringEditor.uiSet("output.name", "text", this.name, session);
            String mems = "";
            for (Output o2 : this.members) {
                mems = String.valueOf(mems) + "," + o2.id;
            }
            WiringEditor.uiSet("output.group.members.list", "value", mems.substring(1), session);
            WiringEditor.uiSet("output.group.members.list", "visible", "true", session);
            return "page:group.output.edit";
        }
        return super.select(list, repeat, up, session);
    }

    @Override
    protected String getOutputRow() {
        String row = "<table class=\"listtable\">";
        row = String.valueOf(row) + "<colgroup><col class=\"id\"></colgroup>";
        row = String.valueOf(row) + "<tr><td colspan=\"2\" class=\"name\">" + (this.ready ? this.name : "<del>" + this.name + "</del>") + "</td></tr>";
        row = String.valueOf(row) + "<tr>";
        String ms = "";
        for (Output o2 : this.members) {
            ms = String.valueOf(ms) + " - " + o2.name;
        }
        row = String.valueOf(row) + "<td class=\"id\">" + ms.substring(3) + "</td>";
        row = String.valueOf(row) + "<td class=\"type\">" + this.typeName + "</td>";
        row = String.valueOf(row) + "</tr></table>";
        return row;
    }

    @Override
    public void setValue(String value) {
        for (Output o2 : this.members) {
            o2.setValue(value);
        }
    }

    @Override
    public String getValue() {
        String val = null;
        for (Output o2 : this.members) {
            val = o2.getValue();
            if (val == null) continue;
            return val;
        }
        return val;
    }

    @Override
    public void recordScenario(WiringScenario scenario) throws Exception {
        this.scenarios.put(scenario, null);
        for (Output o2 : this.members) {
            o2.recordScenario(scenario);
        }
    }

    @Override
    public void recallScenario(WiringScenario scenario) {
        for (Output o2 : this.members) {
            try {
                o2.recallScenario(scenario);
            }
            catch (Exception e2) {
                WiringEditor.log(2, e2.getLocalizedMessage());
            }
        }
    }

    @Override
    public void switchScenario(WiringScenario from, WiringScenario to) throws Exception {
        this.scenarios.remove(from);
        this.scenarios.put(to, null);
        for (Output o2 : this.members) {
            o2.switchScenario(from, to);
        }
    }

    public void check() {
        this.ready = true;
        int x = 0;
        while (x < this.members.size()) {
            Output o2 = WiringEditor.outputs.get(this.members.get((int)x).id);
            if (o2 == null) {
                this.ready = false;
            } else {
                this.members.set(x, o2);
            }
            ++x;
        }
    }

    public boolean hasOutput(Output o2) {
        for (Output m2 : this.members) {
            if (o2 != m2) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id.replace(",", ",,")).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.valueType).append(",");
        dbString.append(this.members.size());
        for (Output output : this.members) {
            dbString.append(',').append(output.id.replace(",", ",,"));
        }
        for (Map.Entry entry : this.scenarios.entrySet()) {
            dbString.append(",").append(((WiringScenario)entry.getKey()).id);
            dbString.append(",").append((String)entry.getValue());
        }
        return dbString.toString();
    }

    @Override
    public String getScenarioString(WiringScenario scenario) {
        StringBuilder ret = new StringBuilder();
        for (Output o2 : this.members) {
            ret.append(o2.getScenarioString(scenario));
            ret.append("<br />");
        }
        return ret.toString();
    }
}

