/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Listable;
import plugins.wiringeditor.WiringEditor;

public class ListManager<V extends Listable>
implements Serializable {
    private static final long serialVersionUID = -1596924002459778135L;
    private final String name;
    private HashMap<String, V> map = new HashMap();
    private Vector<SelectList> lists = new Vector();

    public ListManager(String name) throws Exception {
        this.name = name;
        this.load();
    }

    void load() throws Exception {
        if (this.name != null) {
            try {
                this.map = Database.loadStringHashMap(this.name);
            }
            catch (IOException e2) {
                WiringEditor.log(1, "List not found: " + this.name);
                this.map = new HashMap();
            }
        }
    }

    public ListManager() throws Exception {
        this(null);
    }

    public void addList(String id, String firstRow) throws Exception {
        this.lists.add(new SelectList(id, firstRow));
        this.update(null);
    }

    public synchronized void put(String key, V value) throws Exception {
        this.map.put(key, value);
        this.save(null);
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized V get(String key) {
        if (key == null) {
            return null;
        }
        return (V)((Listable)this.map.get(key));
    }

    public synchronized V remove(String key) throws Exception {
        return this.remove(key, null);
    }

    public synchronized V remove(String key, String session) throws Exception {
        if (key == null) {
            return null;
        }
        Listable e2 = (Listable)this.map.remove(key);
        this.save(session);
        if (e2 != null) {
            e2.onRemove();
        }
        return (V)e2;
    }

    public synchronized void clearMap() {
        this.map.clear();
    }

    public synchronized void save(String session) throws Exception {
        if (this.name != null) {
            Database.save(this.name, this.map);
        }
        this.update(session);
    }

    public synchronized String select(String list, String key, boolean repeat, boolean up, String session) throws Exception {
        return ((Listable)this.map.get(key)).select(list, repeat, up, session);
    }

    public synchronized boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    public synchronized void update(String session) throws Exception {
        this.update(null, session);
    }

    public synchronized void update(Object filter, String session) throws Exception {
        for (SelectList l2 : this.lists) {
            l2.update(filter, session);
        }
    }

    public synchronized Collection<V> values() {
        return this.map.values();
    }

    public synchronized Set<String> keySet() {
        return this.map.keySet();
    }

    public synchronized Set<Map.Entry<String, V>> entrySet() {
        return this.map.entrySet();
    }

    private synchronized ArrayList<Map.Entry<String, V>> sortedEntrySet() {
        ArrayList<Map.Entry<String, V>> set = new ArrayList<Map.Entry<String, V>>(this.map.entrySet());
        Collections.sort(set, new Comparator<Map.Entry<String, V>>(){

            @Override
            public int compare(Map.Entry<String, V> e1, Map.Entry<String, V> e2) {
                return ((Listable)e1.getValue()).compare((Listable)e2.getValue());
            }
        });
        return set;
    }

    private class SelectList
    implements Serializable {
        private static final long serialVersionUID = -1512631800229450570L;
        private final String id;
        private final String firstRow;

        private SelectList(String id, String firstRow) {
            this.id = String.valueOf(id) + ".list";
            this.firstRow = firstRow;
        }

        private void update(Object filter, String session) throws Exception {
            StringBuilder values = new StringBuilder();
            StringBuilder labels = new StringBuilder();
            if (this.firstRow != null) {
                values.append(this.firstRow).append(",");
                labels.append(this.firstRow).append(",");
            }
            ArrayList set = ListManager.this.sortedEntrySet();
            for (Map.Entry entry : set) {
                String row = ((Listable)entry.getValue()).getRow(this.id, filter);
                if (row == null) continue;
                values.append((String)entry.getKey()).append(",");
                labels.append(row).append(",");
            }
            if (values.length() > 0) {
                values.deleteCharAt(values.length() - 1);
            }
            if (labels.length() > 0) {
                labels.deleteCharAt(labels.length() - 1);
            }
            if (session == null) {
                WiringEditor.uiSet(this.id, "values", values.toString());
                WiringEditor.uiSet(this.id, "labels", labels.toString());
            } else {
                WiringEditor.uiSet(this.id, "values", values.toString(), session);
                WiringEditor.uiSet(this.id, "labels", labels.toString(), session);
            }
        }
    }
}

