/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import java.util.Vector;
import plugins.wiringeditor.Database;
import plugins.wiringeditor.Input;
import plugins.wiringeditor.WiringEditor;

public class InputScheduler
extends Input {
    private static final long serialVersionUID = 462479348729804190L;
    private String value;

    public InputScheduler(String dbString) {
        this(Database.split(dbString, ','));
    }

    private InputScheduler(Vector<String> params) {
        super(params.get(0), "Scheduler", params.get(1), Integer.parseInt(params.get(2)));
    }

    public InputScheduler(String id, String name) {
        super(id, "Scheduler", name, 0);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    public void onRemove() {
    }

    @Override
    public String select(String list, boolean repeat, boolean up, String session) throws Exception {
        if (repeat) {
            WiringEditor.uiSet("input.id", "text", this.id, session);
            WiringEditor.uiSet("input.name", "text", this.name, session);
            WiringEditor.uiSet("input.scheduler", "groups", this.id, session);
            return "page:scheduler.input.edit";
        }
        return super.select(list, repeat, up, session);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(boolean active) {
        this.value = active ? "1" : "0";
    }

    @Override
    public String toDBString() {
        StringBuilder dbString = new StringBuilder();
        dbString.append(this.id.replace(",", ",,")).append(",");
        dbString.append(this.name.replace(",", ",,")).append(",");
        dbString.append(this.valueType);
        return dbString.toString();
    }
}

