/*
 * Decompiled with CFR 0.152.
 */
package plugins.tunnelutil;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Tunnel
extends userBase {
    private static final int MONITOR_INTERVAL_MILLIS = 4000;
    private static final int SSH_TUNNEL_CONNECTION_TIMEOUT_MILLIS = 15000;
    private static final Executor exec = Executors.newCachedThreadPool();
    private static Runtime rt = Runtime.getRuntime();
    private static Process sshProcess = null;
    private static BufferedReader sshProcessOut = null;
    private static BufferedReader sshProcessErr = null;
    private static int sshProcessStatus = 0;
    private static long sshProcessStatusTimestamp = 0L;
    private static Process httpsProcess = null;
    private static BufferedReader httpsProcessOut = null;
    private static BufferedReader httpsProcessErr = null;
    private static int httpsProcessStatus = 0;
    private static long httpsProcessStatusTimestamp = 0L;
    private static Process auxProcess = null;
    private static BufferedReader auxProcessOut = null;
    private static BufferedReader auxProcessErr = null;
    private static int auxProcessStatus = 0;
    private static long auxProcessStatusTimestamp = 0L;
    private static long accessIniFileTimestamp = 0L;
    private static HashSet<String> administrators = new HashSet();
    private static String homeDir = null;
    private static File publicKeyFile = null;
    private static String publicKey = null;
    private static boolean tunnelEnabled = false;
    private static String tunnelHost = null;
    private static String tunnelUser = null;
    private static int tunnelPortSSH = 0;
    private static int tunnelPortHTTPS = 0;
    private static int localPortHTTPS = 0;
    private static int tunnelPortAUX = 0;
    private static int localPortAUX = 0;
    private static boolean tunnelKill = false;
    private static int status = 0;
    private static boolean initialized = false;

    public static void StartupEvent() throws Exception {
    }

    public static Object getMagic() throws Exception {
        block23: {
            BufferedInputStream bin = null;
            Scanner fs = null;
            if (!initialized) {
                initialized = true;
                try {
                    Tunnel.loadAccessIniFile();
                    homeDir = System.getProperty("user.home");
                    publicKeyFile = new File(homeDir, ".ssh/id_rsa.pub");
                    if (!publicKeyFile.canRead()) {
                        File sshDir = new File(homeDir, ".ssh");
                        if (!sshDir.exists()) {
                            sshDir.mkdir();
                        }
                        hsyco.messageLog("HSYCO SSH Tunnel Plugin - geneating public/private rsa key pair...");
                        Tunnel.execKeygen(new File(homeDir, ".ssh/id_rsa").getAbsolutePath());
                        hsyco.messageLog("...done");
                    }
                    if (publicKeyFile.canRead()) {
                        bin = new BufferedInputStream(new FileInputStream(publicKeyFile));
                        fs = new Scanner((InputStream)bin, "UTF-8");
                        fs.useDelimiter("\\r\\n|\\n");
                        publicKey = fs.next();
                        fs.close();
                        bin.close();
                        tunnelEnabled = "true".equalsIgnoreCase(Tunnel.varGet("$sshtunnel.enable!"));
                        tunnelKill = !"false".equalsIgnoreCase(Tunnel.varGet("$sshtunnel.kill!"));
                        tunnelHost = Tunnel.varGet("$sshtunnel.host!");
                        tunnelUser = Tunnel.varGet("$sshtunnel.user!");
                        try {
                            tunnelPortSSH = Integer.parseInt(Tunnel.varGet("$sshtunnel.ssh.port!"));
                            if (tunnelPortSSH < 0 || tunnelPortSSH > 65535) {
                                tunnelPortSSH = 0;
                            }
                        }
                        catch (Exception sshDir) {
                            // empty catch block
                        }
                        try {
                            tunnelPortHTTPS = Integer.parseInt(Tunnel.varGet("$sshtunnel.https.port!"));
                            if (tunnelPortHTTPS < 0 || tunnelPortHTTPS > 65535) {
                                tunnelPortHTTPS = 0;
                            }
                        }
                        catch (Exception sshDir) {
                            // empty catch block
                        }
                        try {
                            localPortHTTPS = Integer.parseInt(Tunnel.varGet("$sshtunnel.https.local.port!"));
                            if (localPortHTTPS < 0 || localPortHTTPS > 65535) {
                                localPortHTTPS = 0;
                            }
                        }
                        catch (Exception sshDir) {
                            // empty catch block
                        }
                        try {
                            tunnelPortAUX = Integer.parseInt(Tunnel.varGet("$sshtunnel.aux.port!"));
                            if (tunnelPortAUX < 0 || tunnelPortAUX > 65535) {
                                tunnelPortAUX = 0;
                            }
                        }
                        catch (Exception sshDir) {
                            // empty catch block
                        }
                        try {
                            localPortAUX = Integer.parseInt(Tunnel.varGet("$sshtunnel.aux.local.port!"));
                            if (localPortAUX < 0 || localPortAUX > 65535) {
                                localPortAUX = 0;
                            }
                        }
                        catch (Exception sshDir) {
                            // empty catch block
                        }
                        if (tunnelPortSSH != 0 && tunnelPortHTTPS != 0 && tunnelPortSSH == tunnelPortHTTPS || tunnelPortSSH != 0 && tunnelPortAUX != 0 && tunnelPortSSH == tunnelPortAUX || tunnelPortHTTPS != 0 && tunnelPortAUX != 0 && tunnelPortHTTPS == tunnelPortAUX) {
                            localPortAUX = 0;
                            tunnelPortAUX = 0;
                            localPortHTTPS = 0;
                            tunnelPortHTTPS = 0;
                            tunnelPortSSH = 0;
                            hsyco.errorLog("HSYCO SSH Tunnel Plugin - overlapping port numbers error");
                        }
                        if (tunnelKill) {
                            Tunnel.exec("killall -q ssh");
                        }
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    while (true) {
                                        Tunnel.monitor();
                                        Thread.sleep(4000L);
                                    }
                                }
                                catch (Exception exception) {
                                    return;
                                }
                            }
                        };
                        exec.execute(task);
                        status = 1;
                        break block23;
                    }
                    hsyco.errorLog("HSYCO SSH Tunnel Plugin - SSH public key error");
                }
                catch (Exception e2) {
                    hsyco.errorLog("HSYCO SSH Tunnel Plugin - Initialization exception");
                }
            }
        }
        return new Integer(0);
    }

    public static void monitor() {
        block45: {
            try {
                if (tunnelEnabled && Tunnel.haActiveState()) {
                    if (sshProcess == null) {
                        try {
                            if (tunnelPortSSH != 0) {
                                sshProcess = rt.exec(Tunnel.sshCommand(22, tunnelPortSSH, tunnelUser, tunnelHost));
                                sshProcessOut = new BufferedReader(new InputStreamReader(sshProcess.getInputStream()));
                                sshProcessErr = new BufferedReader(new InputStreamReader(sshProcess.getErrorStream()));
                            }
                        }
                        catch (IOException e2) {
                            sshProcess = null;
                        }
                    } else if (!sshProcess.isAlive()) {
                        Tunnel.sshProcessStreamsFlush();
                        try {
                            sshProcessOut.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            sshProcessErr.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        sshProcess = null;
                        if (sshProcessStatus == 1) {
                            sshProcessStatus = 0;
                            sshProcessStatusTimestamp = System.currentTimeMillis();
                        }
                    } else {
                        Tunnel.sshProcessStreamsFlush();
                        if (sshProcessStatus == 0) {
                            sshProcessStatus = 1;
                            sshProcessStatusTimestamp = System.currentTimeMillis();
                        }
                    }
                    if (httpsProcess == null) {
                        try {
                            if (localPortHTTPS != 0 && tunnelPortHTTPS != 0) {
                                httpsProcess = rt.exec(Tunnel.sshCommand(localPortHTTPS, tunnelPortHTTPS, tunnelUser, tunnelHost));
                                httpsProcessOut = new BufferedReader(new InputStreamReader(httpsProcess.getInputStream()));
                                httpsProcessErr = new BufferedReader(new InputStreamReader(httpsProcess.getErrorStream()));
                            }
                        }
                        catch (IOException e3) {
                            httpsProcess = null;
                        }
                    } else if (!httpsProcess.isAlive()) {
                        Tunnel.httpsProcessStreamsFlush();
                        try {
                            httpsProcessOut.close();
                        }
                        catch (IOException e3) {
                            // empty catch block
                        }
                        try {
                            httpsProcessErr.close();
                        }
                        catch (IOException e3) {
                            // empty catch block
                        }
                        httpsProcess = null;
                        if (httpsProcessStatus == 1) {
                            httpsProcessStatus = 0;
                            httpsProcessStatusTimestamp = System.currentTimeMillis();
                        }
                    } else {
                        Tunnel.httpsProcessStreamsFlush();
                        if (httpsProcessStatus == 0) {
                            httpsProcessStatus = 1;
                            httpsProcessStatusTimestamp = System.currentTimeMillis();
                        }
                    }
                    if (auxProcess == null) {
                        try {
                            if (localPortAUX != 0 && tunnelPortAUX != 0) {
                                auxProcess = rt.exec(Tunnel.sshCommand(localPortAUX, tunnelPortAUX, tunnelUser, tunnelHost));
                                auxProcessOut = new BufferedReader(new InputStreamReader(auxProcess.getInputStream()));
                                auxProcessErr = new BufferedReader(new InputStreamReader(auxProcess.getErrorStream()));
                            }
                            break block45;
                        }
                        catch (IOException e4) {
                            auxProcess = null;
                        }
                        break block45;
                    }
                    if (!auxProcess.isAlive()) {
                        Tunnel.auxProcessStreamsFlush();
                        try {
                            auxProcessOut.close();
                        }
                        catch (IOException e4) {
                            // empty catch block
                        }
                        try {
                            auxProcessErr.close();
                        }
                        catch (IOException e4) {
                            // empty catch block
                        }
                        auxProcess = null;
                        if (auxProcessStatus == 1) {
                            auxProcessStatus = 0;
                            auxProcessStatusTimestamp = System.currentTimeMillis();
                        }
                        break block45;
                    }
                    Tunnel.auxProcessStreamsFlush();
                    if (auxProcessStatus == 0) {
                        auxProcessStatus = 1;
                        auxProcessStatusTimestamp = System.currentTimeMillis();
                    }
                    break block45;
                }
                if (sshProcess != null && sshProcess.isAlive()) {
                    sshProcess.destroyForcibly();
                }
                if (httpsProcess != null && httpsProcess.isAlive()) {
                    httpsProcess.destroyForcibly();
                }
                if (auxProcess != null && auxProcess.isAlive()) {
                    auxProcess.destroyForcibly();
                }
            }
            catch (Exception e5) {
                hsyco.errorLog("HSYCO SSH Tunnel Plugin - SchedulerEvent exception: " + e5.getLocalizedMessage());
                e5.printStackTrace();
            }
        }
        Tunnel.loadAccessIniFile();
        Tunnel.updateUIStatusField();
    }

    public static String userCommand(String session, String userid, String name, String param) {
        if (name.startsWith("sshtunnel.") && (Tunnel.isSysAdmin(userid) || userid == null)) {
            if (name.endsWith(".enable")) {
                tunnelEnabled = Boolean.parseBoolean(param);
                Tunnel.varSet("$sshtunnel.enable!", Boolean.toString(tunnelEnabled));
                Tunnel.uiSet("tunnelutil", name, "value", Boolean.toString(tunnelEnabled));
                Tunnel.enableUIFields(session);
                return "";
            }
            if (name.endsWith(".host")) {
                tunnelHost = param.trim();
                Tunnel.varSet("$sshtunnel.host!", tunnelHost);
                Tunnel.uiSet("tunnelutil", name, "value", tunnelHost);
                return "";
            }
            if (name.endsWith(".ssh.port")) {
                int i2;
                try {
                    i2 = Integer.parseInt(param.trim());
                }
                catch (NumberFormatException e2) {
                    i2 = 0;
                }
                if (i2 > 0 && i2 < 65535 && i2 != tunnelPortHTTPS && i2 != tunnelPortAUX) {
                    tunnelPortSSH = i2;
                    Tunnel.varSet("$sshtunnel.ssh.port!", Integer.toString(tunnelPortSSH));
                    Tunnel.uiSet("tunnelutil", name, "value", Integer.toString(tunnelPortSSH));
                    return "";
                }
                tunnelPortSSH = 0;
                Tunnel.varSet("$sshtunnel.ssh.port!", "0");
                Tunnel.uiSet("tunnelutil", name, "value", "");
            } else if (name.endsWith(".https.port")) {
                int i3;
                try {
                    i3 = Integer.parseInt(param.trim());
                }
                catch (NumberFormatException e3) {
                    i3 = 0;
                }
                if (i3 > 0 && i3 < 65535 && i3 != tunnelPortSSH && i3 != tunnelPortAUX) {
                    tunnelPortHTTPS = i3;
                    Tunnel.varSet("$sshtunnel.https.port!", Integer.toString(tunnelPortHTTPS));
                    Tunnel.uiSet("tunnelutil", name, "value", Integer.toString(tunnelPortHTTPS));
                    return "";
                }
                tunnelPortHTTPS = 0;
                Tunnel.varSet("$sshtunnel.https.port!", "0");
                Tunnel.uiSet("tunnelutil", name, "value", "");
            } else if (name.endsWith(".https.local.port")) {
                int i4;
                try {
                    i4 = Integer.parseInt(param.trim());
                }
                catch (NumberFormatException e4) {
                    i4 = 0;
                }
                if (i4 > 0 && i4 < 65535) {
                    localPortHTTPS = i4;
                    Tunnel.varSet("$sshtunnel.https.local.port!", Integer.toString(localPortHTTPS));
                    Tunnel.uiSet("tunnelutil", name, "value", Integer.toString(localPortHTTPS));
                    return "";
                }
                localPortHTTPS = 0;
                Tunnel.varSet("$sshtunnel.https.local.port!", "0");
                Tunnel.uiSet("tunnelutil", name, "value", "");
            } else if (name.endsWith(".aux.port")) {
                int i5;
                try {
                    i5 = Integer.parseInt(param.trim());
                }
                catch (NumberFormatException e5) {
                    i5 = 0;
                }
                if (i5 > 0 && i5 < 65535 && i5 != tunnelPortSSH && i5 != tunnelPortHTTPS) {
                    tunnelPortAUX = i5;
                    Tunnel.varSet("$sshtunnel.aux.port!", Integer.toString(tunnelPortAUX));
                    Tunnel.uiSet("tunnelutil", name, "value", Integer.toString(tunnelPortAUX));
                    return "";
                }
                tunnelPortAUX = 0;
                Tunnel.varSet("$sshtunnel.aux.port!", "0");
                Tunnel.uiSet("tunnelutil", name, "value", "");
            } else if (name.endsWith(".aux.local.port")) {
                int i6;
                try {
                    i6 = Integer.parseInt(param.trim());
                }
                catch (NumberFormatException e6) {
                    i6 = 0;
                }
                if (i6 > 0 && i6 < 65535) {
                    localPortAUX = i6;
                    Tunnel.varSet("$sshtunnel.aux.local.port!", Integer.toString(localPortAUX));
                    Tunnel.uiSet("tunnelutil", name, "value", Integer.toString(localPortAUX));
                    return "";
                }
                localPortAUX = 0;
                Tunnel.varSet("$sshtunnel.aux.local.port!", "0");
                Tunnel.uiSet("tunnelutil", name, "value", "");
            } else {
                if (name.endsWith(".user")) {
                    tunnelUser = param.trim();
                    Tunnel.varSet("$sshtunnel.user!", tunnelUser);
                    Tunnel.uiSet("tunnelutil", name, "value", tunnelUser);
                    return "";
                }
                if (name.endsWith(".kill")) {
                    tunnelKill = Boolean.parseBoolean(param);
                    Tunnel.varSet("$sshtunnel.kill!", Boolean.toString(tunnelKill));
                    return "";
                }
            }
        }
        return null;
    }

    public static void pageEvent(String address, String session, String userid, String project, String page) {
        if (project.equals("tunnelutil")) {
            if (Tunnel.isSysAdmin(userid)) {
                Tunnel.updateUIConfigurationFields(session);
            } else {
                Tunnel.uiSet("tunnelutil", project, "page", "logout");
            }
        }
    }

    static void loadAccessIniFile() {
        File ACCESS_INI_FILE = new File("access.ini");
        Properties p = new Properties();
        try {
            long ts = ACCESS_INI_FILE.lastModified();
            if (ts != accessIniFileTimestamp) {
                FileInputStream fis = new FileInputStream(ACCESS_INI_FILE);
                p.load(fis);
                fis.close();
                administrators.clear();
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String key = e2.nextElement().toString();
                    boolean admin = key.startsWith("*");
                    if (!admin) continue;
                    key = key.substring(1);
                    administrators.add(key);
                }
                accessIniFileTimestamp = ts;
            }
        }
        catch (Exception e3) {
            accessIniFileTimestamp = 0L;
        }
    }

    static boolean isSysAdmin(String userid) {
        return administrators.contains(userid);
    }

    private static void updateUIStatusField() {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        long now = System.currentTimeMillis();
        switch (status) {
            case 0: {
                Tunnel.uiSet("tunnelutil", "sshtunnel.status", "value", "starting...");
                Tunnel.varSet("$sshtunnel.ssh", "starting");
                Tunnel.varSet("$sshtunnel.https", "starting");
                break;
            }
            case 1: {
                if (tunnelEnabled) {
                    if (tunnelPortSSH != 0) {
                        if (sshProcessStatus == 1) {
                            if (now > sshProcessStatusTimestamp + 15000L) {
                                Tunnel.varSet("$sshtunnel.ssh", "connected");
                                sb.append("SSH connected (");
                                sb.append(df.format(sshProcessStatusTimestamp));
                                sb.append(")");
                            } else {
                                Tunnel.varSet("$sshtunnel.ssh", "connecting");
                                sb.append("SSH connecting...");
                            }
                        } else {
                            Tunnel.varSet("$sshtunnel.ssh", "notconnected");
                            sb.append("SSH not connected");
                            if (sshProcessStatusTimestamp > 0L) {
                                sb.append(" (");
                                sb.append(df.format(sshProcessStatusTimestamp));
                                sb.append(")");
                            }
                        }
                    }
                    if (localPortHTTPS != 0 && tunnelPortHTTPS != 0) {
                        if (tunnelPortSSH != 0) {
                            sb.append("<br>");
                        }
                        if (httpsProcessStatus == 1) {
                            if (now > httpsProcessStatusTimestamp + 15000L) {
                                Tunnel.varSet("$sshtunnel.https", "connected");
                                sb.append("HTTPS connected (");
                                sb.append(df.format(httpsProcessStatusTimestamp));
                                sb.append(")");
                            } else {
                                Tunnel.varSet("$sshtunnel.https", "connecting");
                                sb.append("HTTPS connecting...");
                            }
                        } else {
                            Tunnel.varSet("$sshtunnel.https", "notconnected");
                            sb.append("HTTPS not connected");
                            if (httpsProcessStatusTimestamp > 0L) {
                                sb.append(" (");
                                sb.append(df.format(httpsProcessStatusTimestamp));
                                sb.append(")");
                            }
                        }
                    }
                    if (localPortAUX != 0 && tunnelPortAUX != 0) {
                        if (tunnelPortSSH != 0 || tunnelPortHTTPS != 0) {
                            sb.append("<br>");
                        }
                        if (auxProcessStatus == 1) {
                            if (now > auxProcessStatusTimestamp + 15000L) {
                                Tunnel.varSet("$sshtunnel.aux", "connected");
                                sb.append("AUX connected (");
                                sb.append(df.format(auxProcessStatusTimestamp));
                                sb.append(")");
                            } else {
                                Tunnel.varSet("$sshtunnel.aux", "connecting");
                                sb.append("AUX connecting...");
                            }
                        } else {
                            Tunnel.varSet("$sshtunnel.aux", "notconnected");
                            sb.append("AUX not connected");
                            if (auxProcessStatusTimestamp > 0L) {
                                sb.append(" (");
                                sb.append(df.format(auxProcessStatusTimestamp));
                                sb.append(")");
                            }
                        }
                    }
                    Tunnel.uiSet("tunnelutil", "sshtunnel.status", "value", sb.toString());
                    break;
                }
                Tunnel.uiSet("tunnelutil", "sshtunnel.status", "value", "disabled");
            }
        }
    }

    private static void updateUIConfigurationFields(String session) {
        Tunnel.enableUIFields(session);
        Tunnel.updateUIStatusField();
        Tunnel.uiSet("tunnelutil", "sshtunnel.enable", "value", Boolean.toString(tunnelEnabled));
        Tunnel.uiSet("tunnelutil", "sshtunnel.host", "value", tunnelHost == null ? "" : tunnelHost);
        Tunnel.uiSet("tunnelutil", "sshtunnel.ssh.port", "value", tunnelPortSSH == 0 ? "" : Integer.toString(tunnelPortSSH));
        Tunnel.uiSet("tunnelutil", "sshtunnel.https.port", "value", tunnelPortHTTPS == 0 ? "" : Integer.toString(tunnelPortHTTPS));
        Tunnel.uiSet("tunnelutil", "sshtunnel.https.local.port", "value", localPortHTTPS == 0 ? "" : Integer.toString(localPortHTTPS));
        Tunnel.uiSet("tunnelutil", "sshtunnel.aux.port", "value", tunnelPortAUX == 0 ? "" : Integer.toString(tunnelPortAUX));
        Tunnel.uiSet("tunnelutil", "sshtunnel.aux.local.port", "value", localPortAUX == 0 ? "" : Integer.toString(localPortAUX));
        Tunnel.uiSet("tunnelutil", "sshtunnel.user", "value", tunnelUser == null ? "" : tunnelUser);
        Tunnel.uiSet("tunnelutil", "sshtunnel.kill", "value", Boolean.toString(tunnelKill));
        Tunnel.uiSet("tunnelutil", "sshtunnel.key", "value", publicKey);
    }

    private static void enableUIFields(String session) {
        String e2 = Boolean.toString(!tunnelEnabled);
        Tunnel.uiSet("tunnelutil", "sshtunnel.host", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.ssh.port", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.https.port", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.https.local.port", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.aux.port", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.aux.local.port", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.user", "enabled", e2);
        Tunnel.uiSet("tunnelutil", "sshtunnel.kill", "enabled", e2);
    }

    private static String exec(String cmd) {
        String ret = null;
        boolean errors = false;
        Process proc = null;
        BufferedReader brerr = null;
        BufferedReader brout = null;
        try {
            String out;
            proc = rt.exec(cmd);
            brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((out = brout.readLine()) != null) {
                ret = out;
            }
            while ((out = brerr.readLine()) != null) {
                if (Configuration.verboseLog) {
                    hsyco.errorLog("HSYCO SSH Tunnel Plugin - command error: " + out);
                }
                errors = true;
            }
            if (errors) {
                return null;
            }
            if (ret == null) {
                return "";
            }
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            if (Configuration.verboseLog) {
                hsyco.errorLog("HSYCO SSH Tunnel Plugin - exec exception: " + e2.getLocalizedMessage());
            }
            return null;
        }
        finally {
            try {
                proc.destroy();
            }
            catch (Exception exception) {}
            try {
                brerr.close();
            }
            catch (Exception exception) {}
            try {
                brout.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void execKeygen(String filename) {
        String out = null;
        Process proc = null;
        BufferedReader brerr = null;
        BufferedReader brout = null;
        BufferedWriter brin = null;
        String[] cmd = new String[]{"ssh-keygen", "-q", "-N", "", "-f", filename};
        try {
            try {
                proc = rt.exec(cmd);
                brin = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
                brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                brin.write("n");
                brin.newLine();
                while (brout.readLine() != null) {
                }
                while ((out = brerr.readLine()) != null) {
                    if (!Configuration.verboseLog) continue;
                    hsyco.errorLog("HSYCO SSH Tunnel Plugin - command error: " + out);
                }
            }
            catch (Exception e2) {
                if (Configuration.verboseLog) {
                    hsyco.errorLog("HSYCO SSH Tunnel Plugin - exec exception: " + e2.getLocalizedMessage());
                }
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    brin.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    brerr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    brout.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                proc.destroy();
            }
            catch (Exception exception) {}
            try {
                brin.close();
            }
            catch (Exception exception) {}
            try {
                brerr.close();
            }
            catch (Exception exception) {}
            try {
                brout.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String sshCommand(int localPort, int remotePort, String user2, String host) {
        StringBuffer sb = new StringBuffer();
        int hostPortSep = host.indexOf(58);
        sb.append("ssh -4 -N -R ");
        sb.append(remotePort);
        sb.append(":localhost:");
        sb.append(localPort);
        sb.append(" -o TCPKeepAlive=yes -o ConnectTimeout=");
        sb.append(15);
        sb.append(" -o ServerAliveInterval=15 -o ServerAliveCountMax=2 -o ExitOnForwardFailure=yes -o BatchMode=yes -o StrictHostKeyChecking=no ");
        if (hostPortSep > 0) {
            sb.append("-p ");
            sb.append(host.substring(hostPortSep + 1).trim());
            sb.append(' ');
            sb.append(user2);
            sb.append("@");
            sb.append(host.substring(0, hostPortSep).trim());
        } else {
            sb.append(user2);
            sb.append("@");
            sb.append(host);
        }
        return sb.toString();
    }

    private static void sshProcessStreamsFlush() {
        String s2;
        try {
            while (sshProcessOut.ready()) {
                s2 = sshProcessOut.readLine();
                if (!Configuration.verboseLog) continue;
                hsyco.messageLog("HSYCO SSH Tunnel Plugin - SSH tunnel out: " + s2);
            }
        }
        catch (IOException s2) {}
        try {
            while (sshProcessErr.ready()) {
                s2 = sshProcessErr.readLine();
                if (!Configuration.verboseLog) continue;
                hsyco.messageLog("HSYCO SSH Tunnel Plugin - SSH tunnel err: " + s2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void httpsProcessStreamsFlush() {
        String s2;
        try {
            while (httpsProcessOut.ready()) {
                s2 = httpsProcessOut.readLine();
                if (!Configuration.verboseLog) continue;
                hsyco.messageLog("HSYCO SSH Tunnel Plugin - HTTPS tunnel out: " + s2);
            }
        }
        catch (IOException s2) {}
        try {
            while (httpsProcessErr.ready()) {
                s2 = httpsProcessErr.readLine();
                if (!Configuration.verboseLog) continue;
                hsyco.messageLog("HSYCO SSH Tunnel Plugin - HTTPS tunnel err: " + s2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void auxProcessStreamsFlush() {
        String s2;
        try {
            while (auxProcessOut.ready()) {
                s2 = auxProcessOut.readLine();
                if (!Configuration.verboseLog) continue;
                hsyco.messageLog("HSYCO SSH Tunnel Plugin - AUX tunnel out: " + s2);
            }
        }
        catch (IOException s2) {}
        try {
            while (auxProcessErr.ready()) {
                s2 = auxProcessErr.readLine();
                if (!Configuration.verboseLog) continue;
                hsyco.messageLog("HSYCO SSH Tunnel Plugin - AUX tunnel err: " + s2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

