/*
 * Decompiled with CFR 0.152.
 */
package plugins.mqttbrokerutil;

import com.hsyco.Configuration;
import com.hsyco.userBase;
import drivers.mqttbroker.Driver;
import drivers.mqttbroker.MQTTClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import plugins.mqttbrokerutil.WarningException;

public class MQTTBrokerUtil
extends userBase {
    private static final String VERSION = "MQTT Broker Util 1.0";
    static final String PREFIX = "__hsyco__mqttbrokerutil.";
    static final int LOG_ERROR = 0;
    static final int LOG_VERBOSE = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_MESSAGE = 3;
    static final int LOG_EVENT = 4;
    private static boolean initialized = false;
    static boolean debug = false;
    private static String ioServerPrefix;

    public static void StartupEvent() {
        block4: {
            try {
                initialized = false;
                for (String io : Configuration.ioServers) {
                    if (!"mqttbroker".equalsIgnoreCase(Configuration.ioServersGetTypeByName(io))) continue;
                    ioServerPrefix = String.valueOf(io) + ".";
                    break;
                }
                if (ioServerPrefix == null) {
                    MQTTBrokerUtil.log(1, "No MQTTBROKER I/O Server - quitting");
                    userBase.uiSet("__hsyco__mqttbrokerutil.scope!", "mqttbrokerutil", "lock", "nobroker");
                    return;
                }
                userBase.uiSet("__hsyco__mqttbrokerutil.scope!", "mqttbrokerutil", "lock", "loading");
                MQTTBrokerUtil.log(3, "application started");
                MQTTBrokerUtil.uiSet("version", "value", VERSION);
                initialized = true;
                MQTTBrokerUtil.log(3, "initialization complete");
            }
            catch (Throwable e2) {
                MQTTBrokerUtil.log(0, "initialization error - " + MQTTBrokerUtil.getStackTrace(e2));
                if (!debug) break block4;
                e2.printStackTrace();
            }
        }
    }

    public static void IOEvent(String id, String value) {
        if (ioServerPrefix == null || !id.startsWith(ioServerPrefix)) {
            return;
        }
        if ("connection".equals(id = id.substring(ioServerPrefix.length()))) {
            boolean online = "online".equals(value);
            userBase.uiSet("__hsyco__mqttbrokerutil.scope!", "mqttbrokerutil", "lock", online ? "" : "loading");
            if (online) {
                MQTTBrokerUtil.uiSet("client.discovery", "value", "" + Driver.INSTANCE.getAcceptUnknown());
                userBase.uiSet("__hsyco__mqttbrokerutil.scope!", "mqttbrokerutil", "page", "menu");
                MQTTBrokerUtil.guiUpdateClientsList();
            }
        } else if (id.endsWith(".connected") || id.contains(".topic.") || id.endsWith(".lastseen")) {
            MQTTBrokerUtil.guiUpdateClientsList();
        }
    }

    public static String userCommand(String session, String userId, String cmd, String param) {
        return MQTTBrokerUtil.userCommandOrSubmit(session, userId, cmd, param, null);
    }

    public static String userSubmit(String session, String userId, String cmd, HashMap<String, String> fields) {
        return MQTTBrokerUtil.userCommandOrSubmit(session, userId, cmd, null, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String userCommandOrSubmit(String session, String userId, String cmd, String param, HashMap<String, String> fields) {
        try {
            if (!cmd.startsWith(PREFIX)) {
                return null;
            }
            if (!initialized) {
                return null;
            }
            if (param != null && param.endsWith("/close")) {
                return "!";
            }
            cmd = cmd.substring(PREFIX.length());
            MQTTBrokerUtil.log(1, "processing command '" + cmd + " = " + param + "'");
            if (cmd.equals("commit")) {
                Driver driver = Driver.INSTANCE;
                synchronized (driver) {
                    if (ioServerPrefix == null) {
                        return "!error";
                    }
                    BufferedWriter bw = null;
                    try {
                        try {
                            File f2;
                            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("mqttbroker.ini.tmp"), Charset.forName("UTF-8")));
                            Iterator<String> iterator = Driver.INSTANCE.getClientsInfo().keySet().iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    f2 = new File("mqttbroker.ini.tmp");
                                    if (f2.renameTo(new File("mqttbroker.ini"))) break;
                                    throw new Exception("cannot rename mqttbroker.ini.tmp");
                                }
                                String clientId = iterator.next();
                                MQTTClient client = Driver.INSTANCE.getClientsInfo().get(clientId);
                                String newId = clientId.replace("\\", "\\\\").replace(":", "\\:").replace("=", "\\=").replace(",", "\\,");
                                if (client.getUsername() != null && client.getPassword() != null) {
                                    bw.write(String.valueOf(newId) + ":");
                                    if (!client.getUsername().equals("")) {
                                        String username = client.getUsername().replace("\\", "\\\\").replace(":", "\\:").replace("=", "\\=").replace(",", "\\,");
                                        bw.write("username=" + username);
                                        if (!client.getPassword().equals("")) {
                                            bw.write(",");
                                        }
                                    }
                                    if (!client.getPassword().equals("")) {
                                        String password = client.getPassword().replace("\\", "\\\\").replace(":", "\\:").replace("=", "\\=").replace(",", "\\,");
                                        bw.write("password=" + password);
                                    }
                                } else {
                                    bw.write(newId);
                                }
                                bw.newLine();
                            }
                            f2.setWritable(true, false);
                            userBase.uiSet("__hsyco__mqttbrokerutil.scope!", "mqttbrokerutil", "lock", "loading");
                        }
                        catch (Exception e2) {
                            throw new Exception("exception while writing to mqttbroker.ini - " + e2.getLocalizedMessage());
                        }
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (Exception exception) {}
                    }
                    return "!page:close";
                }
            }
            if (cmd.startsWith("client.")) {
                if (cmd.endsWith("discovery")) {
                    Driver.INSTANCE.setAcceptUnknown(Boolean.parseBoolean(param));
                    return "!";
                }
                if (cmd.endsWith("list")) {
                    String clientId = param.replace("&#44;", ",");
                    MQTTBrokerUtil.uiSet("client.id", "value", clientId, session);
                    MQTTClient client = Driver.INSTANCE.getClientsInfo().get(clientId);
                    if (client.getUsername() != null && client.getPassword() != null) {
                        MQTTBrokerUtil.uiSet("client.user", "value", client.getUsername(), session);
                        MQTTBrokerUtil.uiSet("client.pass", "value", client.getPassword(), session);
                    } else {
                        MQTTBrokerUtil.uiSet("client.user", "value", "", session);
                        MQTTBrokerUtil.uiSet("client.pass", "value", "", session);
                    }
                    MQTTBrokerUtil.uiSet("client.delete", "text", "Delete", session);
                    MQTTBrokerUtil.uiSet("client.delete", "param", "", session);
                    MQTTBrokerUtil.uiSet("client.delete", "visible", "true", session);
                    return "!page:client.edit";
                }
                if (cmd.endsWith("add")) {
                    MQTTBrokerUtil.uiSet("client.id", "value", "", session);
                    MQTTBrokerUtil.uiSet("client.user", "value", "", session);
                    MQTTBrokerUtil.uiSet("client.pass", "value", "", session);
                    MQTTBrokerUtil.uiSet("client.tools.link", "visible", "false", session);
                    MQTTBrokerUtil.uiSet("client.delete", "visible", "false", session);
                    return "!page:client.edit";
                }
                if (cmd.endsWith("save")) {
                    String pass;
                    String user2;
                    String newId = MQTTBrokerUtil.getSubmitField(fields, "client.id", true);
                    if (newId.isEmpty()) {
                        MQTTBrokerUtil.uiSet("client.id", "error", "true", session);
                        return "!error";
                    }
                    newId = newId.replace("&#44;", ",");
                    String oldId = MQTTBrokerUtil.uiGet("client.id", "value", session);
                    if (!oldId.toLowerCase().equals(newId.toLowerCase()) && Driver.INSTANCE.containsEqualId(newId)) {
                        throw new WarningException("ID already used", "close", session);
                    }
                    try {
                        user2 = MQTTBrokerUtil.getSubmitField(fields, "client.user", true);
                    }
                    catch (Exception e3) {
                        MQTTBrokerUtil.uiSet("client.user", "error", "true", session);
                        return "!error";
                    }
                    try {
                        pass = MQTTBrokerUtil.getSubmitField(fields, "client.pass", true);
                    }
                    catch (Exception e4) {
                        MQTTBrokerUtil.uiSet("client.pass", "error", "true", session);
                        return "!error";
                    }
                    MQTTClient client = new MQTTClient();
                    if (!user2.isEmpty() || !pass.isEmpty()) {
                        client.setUsername(user2.replace("&#44;", ","));
                        client.setPassword(pass.replace("&#44;", ","));
                    }
                    Driver.INSTANCE.updateClient(oldId, newId, client);
                    MQTTBrokerUtil.guiUpdateClientsList();
                    return "!page:close";
                }
                if (!cmd.endsWith("delete")) throw new Exception("Unknown command");
                if ("confirm".equals(param)) {
                    String clientId = MQTTBrokerUtil.uiGet("client.id", "value", session);
                    Driver.INSTANCE.removeClient(clientId);
                    MQTTBrokerUtil.guiUpdateClientsList();
                    return "!page:close";
                }
                MQTTBrokerUtil.uiSet("client.delete", "text", "Confirm", session);
                MQTTBrokerUtil.uiSet("client.delete", "param", "confirm", session);
                return "!";
            }
            if (!cmd.endsWith("warning.close")) throw new Exception("Unknown command");
            return "!page:" + param;
        }
        catch (WarningException e5) {
            return "!page:warning";
        }
        catch (Throwable e6) {
            MQTTBrokerUtil.log(0, "error processing command '" + cmd + " = " + param + "' - " + MQTTBrokerUtil.getStackTrace(e6));
            if (!debug) return "!error";
            e6.printStackTrace();
            return "!error";
        }
    }

    private static String getSubmitField(HashMap<String, String> fields, String id, boolean removeSpaces) {
        return fields.get(PREFIX + id).trim().replaceAll("\\s+", removeSpaces ? "" : " ").replace(",", "&#44;");
    }

    public static void uiSet(String id, String attr, String value) {
        MQTTBrokerUtil.uiSet(id, attr, value, null);
    }

    public static void uiSet(String id, String attr, String value, String session) {
        userBase.uiSet(session == null ? "__hsyco__mqttbrokerutil.scope!" : session, PREFIX + id, attr, value);
    }

    public static String uiGet(String id, String attr) {
        return MQTTBrokerUtil.uiGet(id, attr, null);
    }

    public static String uiGet(String id, String attr, String session) {
        String ret = userBase.uiGet(session == null ? "__hsyco__mqttbrokerutil.scope!" : session, PREFIX + id, attr);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private static void guiUpdateClientsList() {
        HashMap<String, MQTTClient> clientsInfo = Driver.INSTANCE.getClientsInfo();
        StringBuilder labels = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String s : clientsInfo.keySet()) {
            labels.append(',').append(s.replace(",", "&#44;").replace("|", "&#10072"));
            values.append(',').append(s.replace(",", "&#44;"));
            String connected = Driver.INSTANCE.isConnected(s) ? "yes" : "no";
            long timestamp = Driver.INSTANCE.getLastSeenTimestamp(s);
            String tmsp = timestamp != 0L ? "" + timestamp : "---";
            labels.append("|" + connected + "|" + tmsp);
        }
        MQTTBrokerUtil.uiSet("client.list", "values", values.length() > 0 ? values.substring(1) : "", null);
        MQTTBrokerUtil.uiSet("client.list", "labels", labels.length() > 0 ? labels.substring(1) : "", null);
    }

    private static String getStackTrace(Throwable e2) {
        StringWriter sw = new StringWriter();
        sw.append(e2.getLocalizedMessage());
        sw.append("\n\t");
        e2.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static void log(int tag, String message) {
        switch (tag) {
            case 3: {
                MQTTBrokerUtil.messageLog("[MQTTBROKER] Message | " + message);
                break;
            }
            case 0: {
                MQTTBrokerUtil.errorLog("[MQTTBROKER] Error | " + message);
                break;
            }
            case 1: {
                if (!Configuration.verboseLog) break;
                MQTTBrokerUtil.messageLog("[MQTTBROKER] Verbose | " + message);
                break;
            }
        }
    }
}

