/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class SlimPlayer
extends Listable {
    private String playerId;
    private boolean enabled = true;

    SlimPlayer(String id, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal SlimPlayer ID: " + id);
        }
        Settings.log(1, "Created SlimPlayer '" + this.id + "'");
    }

    @Override
    String getListLabel(String list) {
        if (this.enabled) {
            return this.id;
        }
        return "<div style=\"color:#A0A0A0\">" + this.id + "</div>";
    }

    void setPlayerId(String playerId) throws InputException {
        if (playerId == null || playerId.length() == 0) {
            throw new InputException("Illegal Player ID for SlimPlayer '" + this.id + "': " + playerId);
        }
        this.playerId = playerId;
        Settings.log(1, "SlimPlayer '" + this.id + "' - Player ID set to: " + this.playerId);
    }

    void show(String session) {
        Settings.uiSet("sqz.selected", "visible", "true", session);
        Settings.uiSet("sqz.list", "value", this.id, session);
        Settings.uiSet("sqz.enabled", "value", Boolean.toString(this.enabled), session);
        Settings.uiSet("sqz.player", "value", this.playerId == null ? "" : this.playerId, session);
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if (this.playerId == null) {
            new Error("SlimPlayer '" + this.id + "' - Player ID not set", this);
        }
        if (bw != null) {
            bw.write("slimPlayerId." + this.id);
            bw.write(" = ");
            bw.write(this.playerId);
            bw.write("\n");
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

