/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import com.hsyco.Configuration;
import com.hsyco.HsycoFile;
import com.hsyco.userBase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.json.JSONObject;
import plugins.manager_settings.Camera;
import plugins.manager_settings.CommPort;
import plugins.manager_settings.DLogger;
import plugins.manager_settings.DMX;
import plugins.manager_settings.Error;
import plugins.manager_settings.Field;
import plugins.manager_settings.Grid;
import plugins.manager_settings.IOServer;
import plugins.manager_settings.IOServerType;
import plugins.manager_settings.IRTrans;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Location;
import plugins.manager_settings.SlimPlayer;
import plugins.manager_settings.SynchronizedStringHashMap;
import plugins.manager_settings.Timer;
import plugins.manager_settings.WarningException;

public class Settings
extends userBase {
    private static final String PROJECT_NAME = "manager_settings";
    static final String PREFIX = "__hsyco__stng.";
    static final String INI_FILE = "hsyco.ini";
    private static final String FIELDS_FILE = "plugins/manager_settings/settings.json";
    static final int LOG_ERROR = 0;
    static final int LOG_VERBOSE = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_MESSAGE = 3;
    static final String STANDARD_ID_REGEX = "[a-z0-9]+";
    static HashMap<String, String> infos = new HashMap();
    private static boolean debug = true;
    static SynchronizedStringHashMap<Field> fields;
    static SynchronizedStringHashMap<IOServerType> iosTypes;
    static SynchronizedStringHashMap<Field> extraFields;
    static SynchronizedStringHashMap<IRTrans> irTrans;
    static SynchronizedStringHashMap<CommPort> commPorts;
    static SynchronizedStringHashMap<IOServer> ioServers;
    static SynchronizedStringHashMap<DLogger> dLoggers;
    static SynchronizedStringHashMap<Location> locations;
    static SynchronizedStringHashMap<DMX> dmxs;
    static SynchronizedStringHashMap<Timer> timers;
    static SynchronizedStringHashMap<SlimPlayer> slimPlayers;
    static SynchronizedStringHashMap<Camera> cameras;
    static Vector<Grid> grids;
    static SynchronizedStringHashMap<Error> errors;
    private static boolean initialized;
    private static boolean not_saved_changes;

    static {
        initialized = false;
        not_saved_changes = false;
    }

    public static void StartupEvent() {
        try {
            Settings.log(1, "application started");
            Settings.loadStructure();
            for (Field f2 : fields.values()) {
                Settings.uiSet(f2.getId(), "validatevalue", f2.getFormat());
                String keyFormat = f2.getKeyFormat();
                if (keyFormat == null) continue;
                Settings.uiSet(f2.getId(), "validatekey", keyFormat);
            }
            Settings.loadIniFile();
            Settings.uiSet("loading", "visible", "false");
            Settings.log(1, "initialization complete");
            initialized = true;
        }
        catch (Throwable e2) {
            Settings.log(0, "initialization error - " + Settings.getStackTrace(e2));
        }
    }

    private static void loadStructure() throws Exception {
        Settings.log(1, "loading 'plugins/manager_settings/settings.json' file");
        HsycoFile file = new HsycoFile(FIELDS_FILE, null);
        byte[] bytes = file.getBytes();
        if (bytes == null) {
            throw new Exception("file 'plugins/manager_settings/settings.json' not found");
        }
        JSONObject settings = new JSONObject(new String(bytes, "UTF-8"));
        JSONObject regexObj = settings.getJSONObject("regex");
        fields = new SynchronizedStringHashMap();
        JSONObject obj = settings.getJSONObject("fields");
        Iterator<String> keys = obj.keys();
        while (keys.hasNext()) {
            String fieldId = keys.next();
            JSONObject fieldObj = obj.getJSONObject(fieldId);
            Field f2 = Field.parse(fieldId, fieldObj, regexObj);
            fields.put(f2.getId(), f2);
        }
        iosTypes = new SynchronizedStringHashMap();
        obj = settings.getJSONObject("ioservers");
        keys = obj.keys();
        while (keys.hasNext()) {
            String iosId = keys.next();
            JSONObject iosObj = obj.getJSONObject(iosId);
            IOServerType iot = IOServerType.parse(iosId, iosObj);
            iosTypes.put(iot.getId(), iot);
        }
        Settings.addUserDriversSchemas();
        Settings.updateList(iosTypes.sortedValues(), "ios.type");
    }

    private static void addUserDriversSchemas() {
        try {
            HashMap<String, String> drivers_settings = new HashMap<String, String>();
            JarFile jar = new JarFile(new File("hsyco.jar"), false, 1);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().getName();
                String[] path = entry.split("[/\\\\]+");
                if (path.length != 3 || !path[0].equals("drivers") || !path[2].equals("settings.json") || drivers_settings.containsKey(path[1])) continue;
                drivers_settings.put(path[1], entry);
            }
            jar.close();
            File f2 = new File("drivers");
            if (f2.exists() && f2.isDirectory()) {
                File[] drivers;
                File[] fileArray = drivers = f2.listFiles();
                int n2 = drivers.length;
                int n3 = 0;
                while (n3 < n2) {
                    File settingsFile;
                    File driverFolder = fileArray[n3];
                    String driverName = driverFolder.getName();
                    if (driverFolder.isDirectory() && (settingsFile = new File(driverFolder, "settings.json")).exists() && settingsFile.isFile()) {
                        drivers_settings.put(driverName, settingsFile.getPath());
                    }
                    ++n3;
                }
            }
            for (Map.Entry d2 : drivers_settings.entrySet()) {
                String driverName = ((String)d2.getKey()).toUpperCase();
                HsycoFile file = new HsycoFile((String)d2.getValue(), null);
                byte[] bytes = file.getBytes();
                try {
                    JSONObject settings = new JSONObject(new String(bytes, "UTF-8"));
                    IOServerType iot = IOServerType.parse(driverName, settings.getJSONObject(driverName));
                    iosTypes.put(driverName, iot);
                }
                catch (Exception e2) {
                    Settings.log(0, "error loading driver settings '" + driverName + "' - " + e2.getLocalizedMessage());
                }
            }
        }
        catch (Exception e3) {
            Settings.log(0, "error loading drivers settings - " + e3.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadIniFile() throws Exception {
        String string = INI_FILE;
        synchronized (INI_FILE) {
            Settings.log(1, "loading 'hsyco.ini' file");
            extraFields = new SynchronizedStringHashMap();
            irTrans = new SynchronizedStringHashMap();
            commPorts = new SynchronizedStringHashMap();
            ioServers = new SynchronizedStringHashMap();
            dLoggers = new SynchronizedStringHashMap();
            locations = new SynchronizedStringHashMap();
            dmxs = new SynchronizedStringHashMap();
            timers = new SynchronizedStringHashMap();
            slimPlayers = new SynchronizedStringHashMap();
            cameras = new SynchronizedStringHashMap();
            grids = new Vector();
            FileInputStream is = null;
            try {
                try {
                    Object id;
                    String[] ids;
                    is = new FileInputStream(INI_FILE);
                    Properties p = new Properties();
                    p.load(is);
                    HashMap<String, String> lowCaseFields = new HashMap<String, String>(fields.size());
                    for (String key : fields.keySet()) {
                        lowCaseFields.put(key.toLowerCase(), key);
                    }
                    HashMap<String, String> lowCaseProperties = new HashMap<String, String>();
                    for (String param : p.stringPropertyNames()) {
                        Field f2;
                        String value = p.getProperty(param).trim();
                        String paramLowCase = param.toLowerCase();
                        if (paramLowCase.startsWith("ioservers") || paramLowCase.equals("commports") || paramLowCase.startsWith("commport.") || paramLowCase.startsWith("irtrans") || paramLowCase.startsWith("location") || paramLowCase.startsWith("datalogger") && !paramLowCase.equals("dataloggerconsolidationexecutioninterval") || paramLowCase.startsWith("dmxservers") || paramLowCase.startsWith("slimplayer") || paramLowCase.startsWith("camera") && !paramLowCase.equals("camerasrecordingmotiontriggerseconds") && !paramLowCase.equals("camerasrefreshmillis") && !paramLowCase.equals("camerasminfreespacebytes") && !paramLowCase.equals("camerasresizedquality")) {
                            lowCaseProperties.put(paramLowCase, value);
                            continue;
                        }
                        if (paramLowCase.equals("timers")) {
                            String[] tmrs = value.replaceAll("\\s+", "").split(",+");
                            int i2 = 0;
                            while (i2 < tmrs.length) {
                                String id2 = tmrs[i2];
                                boolean enabled = true;
                                if (id2.charAt(0) == '#') {
                                    enabled = false;
                                    id2 = id2.substring(1);
                                }
                                if (!timers.containsKeyIgnoreCase(id2)) {
                                    Timer t = new Timer(id2, false);
                                    t.setEnabled(enabled);
                                    timers.put(t.getId(), t);
                                }
                                ++i2;
                            }
                            continue;
                        }
                        String fieldId = (String)lowCaseFields.get(paramLowCase);
                        if (fieldId != null) {
                            f2 = fields.get(fieldId);
                        } else {
                            f2 = new Field(param, null, null, null);
                            extraFields.put(f2.getId(), f2);
                        }
                        try {
                            f2.setValue(value.replaceAll("\\s+", ""));
                        }
                        catch (InputException e2) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e2.getLocalizedMessage());
                        }
                    }
                    String idList = (String)lowCaseProperties.get("irtrans");
                    if (idList != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int paramLowCase = 0;
                        while (paramLowCase < fieldId) {
                            id = stringArray[paramLowCase];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!irTrans.containsKeyIgnoreCase((String)id)) {
                                IRTrans ir = new IRTrans((String)id, false);
                                ir.setEnabled(enabled);
                                irTrans.put(ir.getId(), ir);
                                try {
                                    ir.setIP((String)lowCaseProperties.get("irtransip." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e3) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e3.getLocalizedMessage());
                                }
                            }
                            ++paramLowCase;
                        }
                    }
                    if ((idList = (String)lowCaseProperties.get("commports")) != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int paramLowCase = 0;
                        while (paramLowCase < fieldId) {
                            id = stringArray[paramLowCase];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!commPorts.containsKeyIgnoreCase((String)id)) {
                                String type = (String)lowCaseProperties.get("commport." + ((String)id).toLowerCase() + ".type");
                                if (type != null) {
                                    CommPort commPort = new CommPort((String)id, type.toLowerCase(), false);
                                    commPort.setEnabled(enabled);
                                    commPorts.put(commPort.getId(), commPort);
                                } else {
                                    Settings.log(0, "error loading 'hsyco.ini' file - Type not defined for CommPort '" + (String)id + "'");
                                }
                            }
                            ++paramLowCase;
                        }
                    }
                    if ((idList = (String)lowCaseProperties.get("ioservers")) != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int paramLowCase = 0;
                        while (paramLowCase < fieldId) {
                            id = stringArray[paramLowCase];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!ioServers.containsKeyIgnoreCase((String)id)) {
                                String type = (String)lowCaseProperties.get("ioserverstype." + ((String)id).toLowerCase());
                                if (type != null) {
                                    IOServerType ioType = iosTypes.get(type.toUpperCase());
                                    if (ioType != null) {
                                        IOServer ios = new IOServer((String)id, ioType, false);
                                        ios.setEnabled(enabled);
                                        ioServers.put(ios.getId(), ios);
                                    } else {
                                        Settings.log(0, "error loading 'hsyco.ini' file - Unknown type for IO Server '" + (String)id + "': " + type);
                                    }
                                } else {
                                    Settings.log(0, "error loading 'hsyco.ini' file - Type not defined for IO Server '" + (String)id + "'");
                                }
                            }
                            ++paramLowCase;
                        }
                    }
                    for (CommPort commPort : commPorts.values()) {
                        if (commPort.getType().equals("serial") || commPort.getType().equals("io")) {
                            try {
                                commPort.setPortId((String)lowCaseProperties.get("commport." + commPort.getId().toLowerCase() + ".id"));
                            }
                            catch (InputException e4) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e4.getLocalizedMessage());
                            }
                            try {
                                commPort.setParams((String)lowCaseProperties.get("commport." + commPort.getId().toLowerCase() + ".params"));
                            }
                            catch (InputException e5) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e5.getLocalizedMessage());
                            }
                            continue;
                        }
                        if (commPort.getType().equals("server")) {
                            try {
                                commPort.setServerIP((String)lowCaseProperties.get("commport." + commPort.getId().toLowerCase() + ".ip"));
                            }
                            catch (InputException e6) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e6.getLocalizedMessage());
                            }
                            try {
                                commPort.setServerPort((String)lowCaseProperties.get("commport." + commPort.getId().toLowerCase() + ".port"));
                            }
                            catch (InputException e7) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e7.getLocalizedMessage());
                            }
                            try {
                                String prms = (String)lowCaseProperties.get("commport." + commPort.getId().toLowerCase() + ".params");
                                if (prms == null) continue;
                                commPort.setParams(prms);
                            }
                            catch (InputException e8) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e8.getLocalizedMessage());
                            }
                            continue;
                        }
                        if (!commPort.getType().equals("irtrans")) continue;
                        try {
                            commPort.setPortId((String)lowCaseProperties.get("commport." + commPort.getId().toLowerCase() + ".id"));
                        }
                        catch (InputException e9) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e9.getLocalizedMessage());
                        }
                    }
                    for (IOServer ios : ioServers.values()) {
                        try {
                            ios.setCommIds((String)lowCaseProperties.get("ioserverscomm." + ios.getId().toLowerCase()));
                        }
                        catch (InputException e10) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e10.getLocalizedMessage());
                        }
                        try {
                            ios.setIP((String)lowCaseProperties.get("ioserversip." + ios.getId().toLowerCase()));
                        }
                        catch (InputException e11) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e11.getLocalizedMessage());
                        }
                        try {
                            ios.setPort((String)lowCaseProperties.get("ioserversport." + ios.getId().toLowerCase()));
                        }
                        catch (InputException e12) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e12.getLocalizedMessage());
                        }
                        ios.setOptions((String)lowCaseProperties.get("ioserversoptions." + ios.getId().toLowerCase()));
                        try {
                            ios.setAuthUser((String)lowCaseProperties.get("ioserversauth." + ios.getId().toLowerCase() + ".user"));
                        }
                        catch (InputException e13) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e13.getLocalizedMessage());
                        }
                        try {
                            ios.setAuthPassword((String)lowCaseProperties.get("ioserversauth." + ios.getId().toLowerCase() + ".password"));
                        }
                        catch (InputException e14) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e14.getLocalizedMessage());
                        }
                        try {
                            ios.setShutdownInactive((String)lowCaseProperties.get("ioserversshutdowninactive." + ios.getId().toLowerCase()));
                        }
                        catch (InputException e15) {
                            Settings.log(0, "error loading 'hsyco.ini' file - " + e15.getLocalizedMessage());
                        }
                    }
                    idList = (String)lowCaseProperties.get("dataloggers");
                    if (idList != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int e15 = 0;
                        while (e15 < fieldId) {
                            id = stringArray[e15];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!dLoggers.containsKeyIgnoreCase((String)id)) {
                                String type = (String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".type");
                                DLogger dl = new DLogger((String)id, type, false);
                                dl.setEnabled(enabled);
                                dLoggers.put(dl.getId(), dl);
                                try {
                                    dl.setDecimals((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".decimals"));
                                }
                                catch (InputException e16) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e16.getLocalizedMessage());
                                }
                                try {
                                    dl.setResolution((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".resolution"));
                                }
                                catch (InputException e17) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e17.getLocalizedMessage());
                                }
                                try {
                                    dl.setVarSet((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".varset"));
                                }
                                catch (InputException e18) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e18.getLocalizedMessage());
                                }
                                try {
                                    dl.setHourInterval((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".hourinterval"));
                                }
                                catch (InputException e19) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e19.getLocalizedMessage());
                                }
                                try {
                                    dl.setDaysBeforeDelete((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".daysbeforedelete"));
                                }
                                catch (InputException e20) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e20.getLocalizedMessage());
                                }
                                try {
                                    dl.setDaysBeforeMonthConsolidation((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".daysbeforemonthconsolidation"));
                                }
                                catch (InputException e21) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e21.getLocalizedMessage());
                                }
                                try {
                                    dl.setDaysBeforeDayConsolidation((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".daysbeforedayconsolidation"));
                                }
                                catch (InputException e22) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e22.getLocalizedMessage());
                                }
                                try {
                                    dl.setDaysBeforeHourConsolidation((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".daysbeforehourconsolidation"));
                                }
                                catch (InputException e23) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e23.getLocalizedMessage());
                                }
                                try {
                                    dl.setHourConsolidationFactor((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".hourconsolidationfactor"));
                                }
                                catch (InputException e24) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e24.getLocalizedMessage());
                                }
                                if (type != null) {
                                    if (type.equals("counter")) {
                                        try {
                                            dl.setUpperLimit((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".counterupperlimit"));
                                        }
                                        catch (InputException e25) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e25.getLocalizedMessage());
                                        }
                                        try {
                                            dl.setMaxDelta((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".countermaxdelta"));
                                        }
                                        catch (InputException e26) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e26.getLocalizedMessage());
                                        }
                                        try {
                                            dl.setSeparateCharts((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".separatecharts"));
                                        }
                                        catch (InputException e27) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e27.getLocalizedMessage());
                                        }
                                        try {
                                            dl.setSlotAlign((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".slotalign"));
                                        }
                                        catch (InputException e28) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e28.getLocalizedMessage());
                                        }
                                        try {
                                            dl.setRatesLogFile((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".rateslogfile"));
                                        }
                                        catch (InputException e29) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e29.getLocalizedMessage());
                                        }
                                    } else {
                                        try {
                                            dl.setOrigin((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".origin"));
                                        }
                                        catch (InputException e30) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e30.getLocalizedMessage());
                                        }
                                        try {
                                            dl.setRange((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".range"));
                                        }
                                        catch (InputException e31) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e31.getLocalizedMessage());
                                        }
                                        try {
                                            dl.setOutOfRangeMode((String)lowCaseProperties.get("dataloggers." + ((String)id).toLowerCase() + ".outofrangemode"));
                                        }
                                        catch (InputException e32) {
                                            Settings.log(0, "error loading 'hsyco.ini' file - " + e32.getLocalizedMessage());
                                        }
                                    }
                                }
                            }
                            ++e15;
                        }
                    }
                    if ((idList = (String)lowCaseProperties.get("dmxservers")) != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int e15 = 0;
                        while (e15 < fieldId) {
                            id = stringArray[e15];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!dmxs.containsKeyIgnoreCase((String)id)) {
                                DMX dmx = new DMX((String)id, false);
                                dmx.setEnabled(enabled);
                                dmxs.put(dmx.getId(), dmx);
                                try {
                                    dmx.setIP((String)lowCaseProperties.get("dmxserversip." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e33) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e33.getLocalizedMessage());
                                }
                                try {
                                    String port = (String)lowCaseProperties.get("dmxserversport." + ((String)id).toLowerCase());
                                    if (port == null) {
                                        port = (String)lowCaseProperties.get("dmxserversport");
                                    }
                                    dmx.setPort(port);
                                }
                                catch (InputException e34) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e34.getLocalizedMessage());
                                }
                                try {
                                    dmx.setComm((String)lowCaseProperties.get("dmxserverscomm." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e35) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e35.getLocalizedMessage());
                                }
                                try {
                                    dmx.setServerId((String)lowCaseProperties.get("dmxserversid." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e36) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e36.getLocalizedMessage());
                                }
                            }
                            ++e15;
                        }
                    }
                    if ((idList = (String)lowCaseProperties.get("slimplayers")) != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int e15 = 0;
                        while (e15 < fieldId) {
                            id = stringArray[e15];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!slimPlayers.containsKeyIgnoreCase((String)id)) {
                                SlimPlayer sp = new SlimPlayer((String)id, false);
                                sp.setEnabled(enabled);
                                slimPlayers.put(sp.getId(), sp);
                                try {
                                    sp.setPlayerId((String)lowCaseProperties.get("slimplayerid." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e37) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e37.getLocalizedMessage());
                                }
                            }
                            ++e15;
                        }
                    }
                    if ((idList = (String)lowCaseProperties.get("locationbases")) != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int e15 = 0;
                        while (e15 < fieldId) {
                            id = stringArray[e15];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!locations.containsKeyIgnoreCase((String)id)) {
                                Location loc = new Location((String)id, false);
                                loc.setEnabled(enabled);
                                locations.put(loc.getId(), loc);
                                try {
                                    loc.setIP((String)lowCaseProperties.get("locationbaseip." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e38) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e38.getLocalizedMessage());
                                }
                                try {
                                    loc.setBeacon((String)lowCaseProperties.get("locationbasebeacon." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e39) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e39.getLocalizedMessage());
                                }
                                try {
                                    loc.setGeo((String)lowCaseProperties.get("locationgeo." + ((String)id).toLowerCase()));
                                }
                                catch (InputException e40) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e40.getLocalizedMessage());
                                }
                            }
                            ++e15;
                        }
                    }
                    if ((idList = (String)lowCaseProperties.get("cameras")) != null) {
                        String[] stringArray = ids = idList.replaceAll("\\s+", "").split(",+");
                        int fieldId = ids.length;
                        int e15 = 0;
                        while (e15 < fieldId) {
                            id = stringArray[e15];
                            boolean enabled = true;
                            if (((String)id).charAt(0) == '#') {
                                enabled = false;
                                id = ((String)id).substring(1);
                            }
                            if (!cameras.containsKeyIgnoreCase((String)id)) {
                                Camera cam = new Camera((String)id, false);
                                cam.setEnabled(enabled);
                                cameras.put(cam.getId(), cam);
                                try {
                                    cam.setURL((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".url"));
                                }
                                catch (InputException e41) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e41.getLocalizedMessage());
                                }
                                try {
                                    cam.setURLSmall((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".url.small"));
                                }
                                catch (InputException e42) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e42.getLocalizedMessage());
                                }
                                try {
                                    cam.setPTZ((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".ptz"));
                                }
                                catch (InputException e43) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e43.getLocalizedMessage());
                                }
                                try {
                                    cam.setType((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".type"));
                                }
                                catch (InputException e44) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e44.getLocalizedMessage());
                                }
                                try {
                                    cam.setIO((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".io"));
                                }
                                catch (InputException e45) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e45.getLocalizedMessage());
                                }
                                try {
                                    cam.setUser((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".user"));
                                }
                                catch (InputException e46) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e46.getLocalizedMessage());
                                }
                                try {
                                    cam.setPassword((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".password"));
                                }
                                catch (InputException e47) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e47.getLocalizedMessage());
                                }
                                try {
                                    cam.setDroppedFrames((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".droppedframes"));
                                }
                                catch (InputException e48) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e48.getLocalizedMessage());
                                }
                                try {
                                    cam.setMaxAge((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".maxage"));
                                }
                                catch (InputException e49) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e49.getLocalizedMessage());
                                }
                                try {
                                    cam.setMotionBuffer((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".motionbuffer"));
                                }
                                catch (InputException e50) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e50.getLocalizedMessage());
                                }
                                try {
                                    cam.setRemoteRequestPassword((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".remoterequestpassword"));
                                }
                                catch (InputException e51) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e51.getLocalizedMessage());
                                }
                                try {
                                    cam.setTrustedRequestPassword((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".trustedrequestpassword"));
                                }
                                catch (InputException e52) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e52.getLocalizedMessage());
                                }
                                try {
                                    cam.setRotate((String)lowCaseProperties.get("camera." + ((String)id).toLowerCase() + ".rotate"));
                                }
                                catch (InputException e53) {
                                    Settings.log(0, "error loading 'hsyco.ini' file - " + e53.getLocalizedMessage());
                                }
                            }
                            ++e15;
                        }
                    }
                    int i3 = 1;
                    while (i3 <= 99) {
                        String grid = (String)lowCaseProperties.get("cameragrid." + i3);
                        if (grid != null) {
                            Grid g2 = new Grid();
                            grids.add(g2);
                            g2.setCameras(grid);
                            try {
                                g2.setResolution((String)lowCaseProperties.get("cameragrid." + i3 + ".resolution"));
                            }
                            catch (InputException e54) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e54.getLocalizedMessage());
                            }
                            try {
                                g2.setRemoteRequestPassword((String)lowCaseProperties.get("cameragrid." + i3 + ".remoterequestpassword"));
                            }
                            catch (InputException e55) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e55.getLocalizedMessage());
                            }
                            try {
                                g2.setTrustedRequestPassword((String)lowCaseProperties.get("cameragrid." + i3 + ".trustedrequestpassword"));
                            }
                            catch (InputException e56) {
                                Settings.log(0, "error loading 'hsyco.ini' file - " + e56.getLocalizedMessage());
                            }
                        }
                        ++i3;
                    }
                    Settings.updateList(extraFields, "extra.list");
                    Settings.updateList(timers, "tmr.list");
                    Settings.updateList(irTrans, "ir.list", "comm.ir");
                    Settings.updateList(commPorts, "comm.list");
                    Settings.updateList(ioServers, "ios.list", "comm.io");
                    Settings.updateList(dLoggers, "dlog.list");
                    Settings.updateList(dmxs, "dmx.list");
                    Settings.updateList(slimPlayers, "sqz.list");
                    Settings.updateList(locations, "lctn.list");
                    Settings.updateList(cameras, "cam.list", "grid.cam11", "grid.cam12", "grid.cam13", "grid.cam14", "grid.cam15", "grid.cam16", "grid.cam21", "grid.cam22", "grid.cam23", "grid.cam24", "grid.cam25", "grid.cam26", "grid.cam31", "grid.cam32", "grid.cam33", "grid.cam34", "grid.cam35", "grid.cam36", "grid.cam41", "grid.cam42", "grid.cam43", "grid.cam44", "grid.cam45", "grid.cam46", "grid.cam51", "grid.cam52", "grid.cam53", "grid.cam54", "grid.cam55", "grid.cam56", "grid.cam61", "grid.cam62", "grid.cam63", "grid.cam64", "grid.cam65", "grid.cam66");
                    Settings.updateList(grids, "grid.list");
                }
                catch (Exception e57) {
                    throw new Exception("Error loading 'hsyco.ini' file - " + e57.getLocalizedMessage(), e57);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            Settings.checkAll();
            not_saved_changes = false;
            Settings.uiSet("notsaved", "visible", "false");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void checkAll() {
        errors = new SynchronizedStringHashMap();
        for (IRTrans ir : irTrans.values()) {
            try {
                ir.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (CommPort cp : commPorts.values()) {
            try {
                cp.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (IOServer io : ioServers.values()) {
            try {
                io.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (DLogger dl : dLoggers.values()) {
            try {
                dl.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Location lo : locations.values()) {
            try {
                lo.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (DMX dm : dmxs.values()) {
            try {
                dm.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (SlimPlayer sp : slimPlayers.values()) {
            try {
                sp.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Camera ca : cameras.values()) {
            try {
                ca.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Grid gr : grids) {
            try {
                gr.writeIniDeclaration(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Settings.showErrors();
    }

    private static void showErrors() {
        Settings.updateList(errors, "error.list");
        if (errors.size() == 0) {
            Settings.uiSet("save.confirm", "enabled", "true");
            Settings.uiSet("save.confirm.mini", "visible", "true");
            Settings.uiSet("errors", "visible", "false");
        } else {
            Settings.uiSet("save.confirm", "enabled", "false");
            Settings.uiSet("save.confirm.mini", "visible", "false");
            Settings.uiSet("errors", "visible", "true");
            int i2 = 0;
            StringBuilder text = new StringBuilder("<div style=\"margin-top:");
            if (errors.size() == 1) {
                text.append("10px\">");
            } else if (errors.size() == 2) {
                text.append("5px\">");
            } else {
                text.append("0px\">");
            }
            for (Error e2 : errors.values()) {
                if (i2 == 2) {
                    text.append("...");
                    break;
                }
                if (i2 > 2) break;
                text.append(String.valueOf(e2.getMessage()) + "<br />");
                ++i2;
            }
            text.append("</div>");
            Settings.uiSet("errors", "text", text.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIniFile() throws Exception {
        String string = INI_FILE;
        synchronized (INI_FILE) {
            Settings.log(3, "writing 'hsyco.ini' file...");
            BufferedWriter bw = null;
            File tempFile = null;
            try {
                tempFile = new File("hsyco.ini.temp");
                bw = new BufferedWriter(new FileWriter(tempFile));
                for (Field f2 : fields.sortedValues()) {
                    if (f2.getValue().length() == 0) continue;
                    bw.write(f2.getId());
                    bw.write(" = ");
                    bw.write(f2.getValue());
                    bw.write("\n");
                }
                bw.write("\n");
                for (Field f2 : extraFields.sortedValues()) {
                    if (f2.getValue().length() == 0) continue;
                    bw.write(f2.getId());
                    bw.write(" = ");
                    bw.write(f2.getValue());
                    bw.write("\n");
                }
                bw.write("\n");
                int size = ioServers.size();
                if (size != 0) {
                    bw.write("\n# I/O Servers\n\n");
                    bw.write("ioServers = ");
                    for (IOServer ios : ioServers.values()) {
                        if (!ios.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(ios.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (IOServer ios : ioServers.values()) {
                        ios.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = commPorts.size()) != 0) {
                    bw.write("\n# Comm Ports\n\n");
                    bw.write("CommPorts = ");
                    for (CommPort cp : commPorts.values()) {
                        if (!cp.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(cp.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (CommPort cp : commPorts.values()) {
                        cp.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = irTrans.size()) != 0) {
                    bw.write("\n# IRTrans\n\n");
                    bw.write("IRTrans = ");
                    for (IRTrans ir : irTrans.values()) {
                        if (!ir.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(ir.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (IRTrans ir : irTrans.values()) {
                        ir.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = cameras.size()) != 0) {
                    bw.write("\n# Cameras\n\n");
                    bw.write("Cameras = ");
                    for (Camera cam : cameras.values()) {
                        if (!cam.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(cam.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (Camera cam : cameras.values()) {
                        cam.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if (grids.size() != 0) {
                    bw.write("\n# Camera Grids\n\n");
                    for (Grid gr : grids) {
                        gr.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = dLoggers.size()) != 0) {
                    bw.write("\n# Data Loggers\n\n");
                    bw.write("DataLoggers = ");
                    for (DLogger dl : dLoggers.values()) {
                        if (!dl.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(dl.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (DLogger dl : dLoggers.values()) {
                        dl.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = dmxs.size()) != 0) {
                    bw.write("\n# DMX\n\n");
                    bw.write("dmxServers = ");
                    for (DMX dmx : dmxs.values()) {
                        if (!dmx.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(dmx.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (DMX dmx : dmxs.values()) {
                        dmx.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = locations.size()) != 0) {
                    bw.write("\n# Location Bases\n\n");
                    bw.write("LocationBases = ");
                    for (Location loc : locations.values()) {
                        if (!loc.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(loc.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (Location loc : locations.values()) {
                        loc.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                if ((size = timers.size()) != 0) {
                    bw.write("\n# Timers\n\n");
                    bw.write("Timers = ");
                    for (Timer tmr : timers.values()) {
                        if (!tmr.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(tmr.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                }
                if ((size = slimPlayers.size()) != 0) {
                    bw.write("\n# Squeezebox\n\n");
                    bw.write("slimPlayers = ");
                    for (SlimPlayer sp : slimPlayers.values()) {
                        if (!sp.isEnabled()) {
                            bw.write(35);
                        }
                        bw.write(sp.getId());
                        if (--size == 0) continue;
                        bw.write(", ");
                    }
                    bw.write("\n\n");
                    for (SlimPlayer sp : slimPlayers.values()) {
                        sp.writeIniDeclaration(bw);
                        bw.write("\n");
                    }
                }
                bw.flush();
                bw.close();
                if (errors.size() == 0) {
                    File oldIni = new File(INI_FILE);
                    if (!tempFile.renameTo(oldIni)) {
                        oldIni.delete();
                        if (!tempFile.renameTo(oldIni)) {
                            throw new Exception("file renaming failed");
                        }
                    }
                } else {
                    throw new WarningException("There are still errors to be fixed");
                }
                Settings.log(3, "file 'hsyco.ini' modified");
            }
            finally {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
                try {
                    tempFile.delete();
                }
                catch (Exception exception) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String userCommand(String session, String uid, String cmd, String param) {
        try {
            String id;
            if (!cmd.startsWith(PREFIX)) {
                return null;
            }
            if (!initialized) {
                return null;
            }
            cmd = cmd.substring(PREFIX.length());
            Settings.log(1, "processing command '" + cmd + " = " + param + "'");
            if (param.endsWith("/close") || param.endsWith("/stop") || param.endsWith("/down") || param.endsWith("/up") || param.endsWith("/repeat")) {
                return "!";
            }
            param = param.trim();
            if (cmd.equals("revert")) {
                Settings.loadStructure();
                Settings.loadIniFile();
                return "!page:close";
            }
            if (cmd.equals("save")) {
                Settings.writeIniFile();
                not_saved_changes = false;
                return "!page:close";
            }
            if (cmd.startsWith("extra.")) {
                if (cmd.endsWith("add")) {
                    Settings.uiSet("extra.id", "value", "", session);
                    Settings.uiSet("extra.id", "enabled", "true", session);
                    Settings.uiSet("extra.value", "value", "", session);
                    return "!page:system_extra_new";
                }
                if (cmd.endsWith("list")) {
                    Field f2 = extraFields.get(param);
                    Settings.uiSet("extra.id", "value", f2.getId(), session);
                    Settings.uiSet("extra.id", "enabled", "false", session);
                    Settings.uiSet("extra.value", "value", f2.getValue(), session);
                    return "!page:system_extra_edit";
                }
            }
            if (cmd.startsWith("ios.")) {
                if (cmd.startsWith("add", 4)) {
                    Settings.uiSet("ios.id", "value", "", session);
                    Settings.uiSet("ios.type", "value", "", session);
                    return "!page:ios_new";
                }
                if (cmd.startsWith("list", 4)) {
                    IOServer ios = ioServers.get(param);
                    ios.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 4)) {
                    id = Settings.uiGet("ios.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    IOServer ios = ioServers.remove(id);
                    Settings.updateList(ioServers, "ios.list", "comm.io");
                    Settings.uiSet("ios.selected", "visible", "false", session);
                    Settings.uiSet("ios.list", "value", "", session);
                    Settings.removeErrorsWithElement(ios);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 4)) {
                    String id2 = Settings.uiGet("ios.list", "value", session);
                    if (id2 == null || id2.equals("")) {
                        return "!error";
                    }
                    IOServer ios = ioServers.get(id2);
                    ios.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(ioServers, "ios.list", "comm.io");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("connection", 4)) {
                    String id3 = Settings.uiGet("ios.list", "value", session);
                    if (id3 != null && !id3.equals("")) {
                        IOServer ios = ioServers.get(id3);
                        ios.setConnection(param, session);
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("ip", 4)) {
                    String id4 = Settings.uiGet("ios.list", "value", session);
                    if (id4 != null && !id4.equals("")) {
                        IOServer ios = ioServers.get(id4);
                        ios.setIP(param);
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("port", 4)) {
                    String id5 = Settings.uiGet("ios.list", "value", session);
                    if (id5 != null && !id5.equals("")) {
                        IOServer ios = ioServers.get(id5);
                        ios.setPort(param);
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("comm.id.", 4)) {
                    String id6 = Settings.uiGet("ios.list", "value", session);
                    if (id6 != null && !id6.equals("")) {
                        IOServer ios = ioServers.get(id6);
                        ios.setCommId(param);
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("comm.fail.id", 4)) {
                    String id7 = Settings.uiGet("ios.list", "value", session);
                    if (id7 != null && !id7.equals("")) {
                        IOServer ios = ioServers.get(id7);
                        ios.setFailoverCommId(param);
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("auth.", 4)) {
                    String id8 = Settings.uiGet("ios.list", "value", session);
                    if (id8 != null && !id8.equals("")) {
                        IOServer ios = ioServers.get(id8);
                        if (cmd.endsWith("user")) {
                            ios.setAuthUser(param);
                        } else if (cmd.endsWith("password")) {
                            ios.setAuthPassword(param);
                        }
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("shdwn", 4)) {
                    String id9 = Settings.uiGet("ios.list", "value", session);
                    if (id9 != null && !id9.equals("")) {
                        IOServer ios = ioServers.get(id9);
                        ios.setShutdownInactive(param);
                        Settings.removeErrorsWithElement(ios);
                        ios.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("option.", 4)) {
                    if (cmd.endsWith("add")) {
                        String ioId = Settings.uiGet("ios.list", "value", session);
                        if (ioId != null && !ioId.equals("")) {
                            IOServer ios = ioServers.get(ioId);
                            ios.loadOptions(session);
                            Settings.uiSet("ios.option.id.select", "value", "", session);
                            Settings.uiSet("ios.option.value.input", "value", "", session);
                            Settings.uiSet("ios.option.value.select", "value", "", session);
                            Settings.uiSet("ios.option.value.input", "enabled", "false", session);
                            Settings.uiSet("ios.option.value.select", "enabled", "false", session);
                            return "!page:ios_option_new";
                        }
                        return "!";
                    }
                    if (cmd.endsWith("id.select")) {
                        String ioId = Settings.uiGet("ios.list", "value", session);
                        Settings.uiSet("ios.option.value.input", "enabled", "true", session);
                        Settings.uiSet("ios.option.value.select", "enabled", "true", session);
                        if (ioId != null && !ioId.equals("")) {
                            IOServer ios = ioServers.get(ioId);
                            ios.loadOptionValues(param, session);
                        }
                        return "!";
                    }
                    if (cmd.endsWith("list")) {
                        String ioId = Settings.uiGet("ios.list", "value", session);
                        if (ioId != null && !ioId.equals("")) {
                            Settings.uiSet("ios.option.id", "text", param, session);
                            IOServer ios = ioServers.get(ioId);
                            ios.loadOptionValues(param, session);
                            return "!page:ios_option_edit";
                        }
                        return "!";
                    }
                    if (cmd.endsWith("remove")) {
                        String ioId = Settings.uiGet("ios.list", "value", session);
                        if (ioId != null && !ioId.equals("")) {
                            ioServers.get(ioId).removeOption(Settings.uiGet("ios.option.id", "text", session), session);
                            not_saved_changes = true;
                        }
                        return "!page:close";
                    }
                }
                if (cmd.startsWith("comm.add", 4)) {
                    return "!page:comm";
                }
            }
            if (cmd.startsWith("ir.")) {
                if (cmd.startsWith("add", 3)) {
                    Settings.uiSet("ir.id", "value", "", session);
                    return "!page:ir_new";
                }
                if (cmd.startsWith("list", 3)) {
                    IRTrans ir = irTrans.get(param);
                    ir.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 3)) {
                    id = Settings.uiGet("ir.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    IRTrans ir = irTrans.remove(id);
                    Settings.updateList(irTrans, "ir.list", "comm.ir");
                    Settings.uiSet("ir.selected", "visible", "false", session);
                    Settings.uiSet("ir.list", "value", "", session);
                    Settings.removeErrorsWithElement(ir);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 3)) {
                    String id10 = Settings.uiGet("ir.list", "value", session);
                    if (id10 == null || id10.equals("")) {
                        return "!error";
                    }
                    IRTrans ir = irTrans.get(id10);
                    ir.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(irTrans, "ir.list", "comm.ir");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("ip", 3)) {
                    String id11 = Settings.uiGet("ir.list", "value", session);
                    if (id11 != null && !id11.equals("")) {
                        IRTrans ir = irTrans.get(id11);
                        ir.setIP(param);
                        Settings.removeErrorsWithElement(ir);
                        ir.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("comm.")) {
                if (cmd.startsWith("add", 5)) {
                    Settings.uiSet("comm.id", "value", "", session);
                    Settings.uiSet("comm.type", "value", "", session);
                    return "!page:comm_new";
                }
                if (cmd.startsWith("list", 5)) {
                    CommPort cp = commPorts.get(param);
                    cp.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 5)) {
                    id = Settings.uiGet("comm.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    CommPort cp = commPorts.remove(id);
                    Settings.updateList(commPorts, "comm.list");
                    Settings.uiSet("comm.type.serial", "visible", "false", session);
                    Settings.uiSet("comm.type.server", "visible", "false", session);
                    Settings.uiSet("comm.type.io", "visible", "false", session);
                    Settings.uiSet("comm.type.irtrans", "visible", "false", session);
                    Settings.uiSet("comm.type.none", "visible", "true", session);
                    Settings.uiSet("comm.list", "value", "", session);
                    Settings.removeErrorsWithElement(cp);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 5)) {
                    String id12 = Settings.uiGet("comm.list", "value", session);
                    if (id12 == null || id12.equals("")) {
                        return "!error";
                    }
                    CommPort cp = commPorts.get(id12);
                    cp.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(commPorts, "comm.list");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("ip", 5)) {
                    String id13 = Settings.uiGet("comm.list", "value", session);
                    if (id13 != null && !id13.equals("")) {
                        CommPort cp = commPorts.get(id13);
                        cp.setServerIP(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("srvport", 5)) {
                    String id14 = Settings.uiGet("comm.list", "value", session);
                    if (id14 != null && !id14.equals("")) {
                        CommPort cp = commPorts.get(id14);
                        cp.setServerPort(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("port", 5) || cmd.startsWith("io", 5) || cmd.startsWith("ir", 5)) {
                    String id15 = Settings.uiGet("comm.list", "value", session);
                    if (id15 != null && !id15.equals("")) {
                        CommPort cp = commPorts.get(id15);
                        cp.setPortId(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("baud", 5)) {
                    String id16 = Settings.uiGet("comm.list", "value", session);
                    if (id16 != null && !id16.equals("")) {
                        CommPort cp = commPorts.get(id16);
                        cp.setBaudRate(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("bits", 5)) {
                    String id17 = Settings.uiGet("comm.list", "value", session);
                    if (id17 != null && !id17.equals("")) {
                        CommPort cp = commPorts.get(id17);
                        cp.setDataBits(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("stop", 5)) {
                    String id18 = Settings.uiGet("comm.list", "value", session);
                    if (id18 != null && !id18.equals("")) {
                        CommPort cp = commPorts.get(id18);
                        cp.setStopBits(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("parity", 5)) {
                    String id19 = Settings.uiGet("comm.list", "value", session);
                    if (id19 != null && !id19.equals("")) {
                        CommPort cp = commPorts.get(id19);
                        cp.setParity(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("flow", 5)) {
                    String id20 = Settings.uiGet("comm.list", "value", session);
                    if (id20 != null && !id20.equals("")) {
                        CommPort cp = commPorts.get(id20);
                        cp.setFlowControl(param);
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("timeout", 5)) {
                    String id21 = Settings.uiGet("comm.list", "value", session);
                    if (id21 != null && !id21.equals("")) {
                        CommPort cp = commPorts.get(id21);
                        if (cmd.endsWith(".use")) {
                            if (param.equals("true")) {
                                Settings.uiSet("comm.timeout", "enabled", "true", session);
                            } else {
                                Settings.uiSet("comm.timeout", "enabled", "false", session);
                                Settings.uiSet("comm.timeout", "value", "", session);
                                cp.setTimeout(null);
                            }
                        } else {
                            cp.setTimeout(param);
                        }
                        Settings.removeErrorsWithElement(cp);
                        cp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("dlog.")) {
                if (cmd.startsWith("add", 5)) {
                    Settings.uiSet("dlog.id", "value", "", session);
                    Settings.uiSet("dlog.type", "value", "", session);
                    return "!page:dlog_new";
                }
                if (cmd.startsWith("list", 5)) {
                    DLogger dl = dLoggers.get(param);
                    dl.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 5)) {
                    id = Settings.uiGet("dlog.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    DLogger dl = dLoggers.remove(id);
                    Settings.updateList(dLoggers, "dlog.list");
                    Settings.uiSet("dlog.list", "value", "", session);
                    Settings.uiSet("dlog.selected", "visible", "false", session);
                    Settings.removeErrorsWithElement(dl);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 5)) {
                    String id22 = Settings.uiGet("dlog.list", "value", session);
                    if (id22 == null || id22.equals("")) {
                        return "!error";
                    }
                    DLogger dl = dLoggers.get(id22);
                    dl.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(dLoggers, "dlog.list");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("decimals", 5)) {
                    String id23 = Settings.uiGet("dlog.list", "value", session);
                    if (id23 != null && !id23.equals("")) {
                        DLogger dl = dLoggers.get(id23);
                        dl.setDecimals(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("resolution", 5)) {
                    String id24 = Settings.uiGet("dlog.list", "value", session);
                    if (id24 != null && !id24.equals("")) {
                        DLogger dl = dLoggers.get(id24);
                        dl.setResolution(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("varset", 5)) {
                    String id25 = Settings.uiGet("dlog.list", "value", session);
                    if (id25 != null && !id25.equals("")) {
                        DLogger dl = dLoggers.get(id25);
                        dl.setVarSet(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("hourinterval", 5)) {
                    String id26 = Settings.uiGet("dlog.list", "value", session);
                    if (id26 != null && !id26.equals("")) {
                        DLogger dl = dLoggers.get(id26);
                        dl.setHourInterval(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("daysbeforedelete", 5)) {
                    String id27 = Settings.uiGet("dlog.list", "value", session);
                    if (id27 != null && !id27.equals("")) {
                        DLogger dl = dLoggers.get(id27);
                        dl.setDaysBeforeDelete(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("daysbeforemonthconsolidation", 5)) {
                    String id28 = Settings.uiGet("dlog.list", "value", session);
                    if (id28 != null && !id28.equals("")) {
                        DLogger dl = dLoggers.get(id28);
                        dl.setDaysBeforeMonthConsolidation(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("daysbeforedayconsolidation", 5)) {
                    String id29 = Settings.uiGet("dlog.list", "value", session);
                    if (id29 != null && !id29.equals("")) {
                        DLogger dl = dLoggers.get(id29);
                        dl.setDaysBeforeDayConsolidation(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("daysbeforehourconsolidation", 5)) {
                    String id30 = Settings.uiGet("dlog.list", "value", session);
                    if (id30 != null && !id30.equals("")) {
                        DLogger dl = dLoggers.get(id30);
                        dl.setDaysBeforeHourConsolidation(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("hourconsolidationfactor", 5)) {
                    String id31 = Settings.uiGet("dlog.list", "value", session);
                    if (id31 != null && !id31.equals("")) {
                        DLogger dl = dLoggers.get(id31);
                        dl.setHourConsolidationFactor(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("upperlimit", 5)) {
                    if (cmd.endsWith(".use")) {
                        String id32;
                        Settings.uiSet("dlog.upperlimit", "enabled", param, session);
                        if (param.equals("false") && (id32 = Settings.uiGet("dlog.list", "value", session)) != null && !id32.equals("")) {
                            DLogger dl = dLoggers.get(id32);
                            dl.setUpperLimit(null);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    } else {
                        String id33 = Settings.uiGet("dlog.list", "value", session);
                        if (id33 != null && !id33.equals("")) {
                            DLogger dl = dLoggers.get(id33);
                            dl.setUpperLimit(param);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    }
                    return "!";
                }
                if (cmd.startsWith("maxdelta", 5)) {
                    if (cmd.endsWith(".use")) {
                        String id34;
                        Settings.uiSet("dlog.maxdelta", "enabled", param, session);
                        if (param.equals("false") && (id34 = Settings.uiGet("dlog.list", "value", session)) != null && !id34.equals("")) {
                            DLogger dl = dLoggers.get(id34);
                            dl.setMaxDelta(null);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    } else {
                        String id35 = Settings.uiGet("dlog.list", "value", session);
                        if (id35 != null && !id35.equals("")) {
                            DLogger dl = dLoggers.get(id35);
                            dl.setMaxDelta(param);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    }
                    return "!";
                }
                if (cmd.startsWith("separatecharts", 5)) {
                    String id36 = Settings.uiGet("dlog.list", "value", session);
                    if (id36 != null && !id36.equals("")) {
                        DLogger dl = dLoggers.get(id36);
                        dl.setSeparateCharts(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("slotalign", 5)) {
                    String id37 = Settings.uiGet("dlog.list", "value", session);
                    if (id37 != null && !id37.equals("")) {
                        DLogger dl = dLoggers.get(id37);
                        dl.setSlotAlign(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("rateslogfile", 5)) {
                    if (cmd.endsWith(".use")) {
                        String id38;
                        Settings.uiSet("dlog.rateslogfile", "enabled", param, session);
                        if (param.equals("false") && (id38 = Settings.uiGet("dlog.list", "value", session)) != null && !id38.equals("")) {
                            DLogger dl = dLoggers.get(id38);
                            dl.setRatesLogFile(null);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    } else {
                        String id39 = Settings.uiGet("dlog.list", "value", session);
                        if (id39 != null && !id39.equals("")) {
                            DLogger dl = dLoggers.get(id39);
                            dl.setRatesLogFile(param);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    }
                    return "!";
                }
                if (cmd.startsWith("origin", 5)) {
                    if (cmd.endsWith(".use")) {
                        String id40;
                        Settings.uiSet("dlog.origin", "enabled", param, session);
                        if (param.equals("false") && (id40 = Settings.uiGet("dlog.list", "value", session)) != null && !id40.equals("")) {
                            DLogger dl = dLoggers.get(id40);
                            dl.setOrigin(null);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    } else {
                        String id41 = Settings.uiGet("dlog.list", "value", session);
                        if (id41 != null && !id41.equals("")) {
                            DLogger dl = dLoggers.get(id41);
                            dl.setOrigin(param);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    }
                    return "!";
                }
                if (cmd.startsWith("range", 5)) {
                    if (cmd.endsWith(".use")) {
                        String id42;
                        Settings.uiSet("dlog.range", "enabled", param, session);
                        if (param.equals("false") && (id42 = Settings.uiGet("dlog.list", "value", session)) != null && !id42.equals("")) {
                            DLogger dl = dLoggers.get(id42);
                            dl.setRange(null);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    } else {
                        String id43 = Settings.uiGet("dlog.list", "value", session);
                        if (id43 != null && !id43.equals("")) {
                            DLogger dl = dLoggers.get(id43);
                            dl.setRange(param);
                            not_saved_changes = true;
                            dl.show(session);
                        }
                    }
                    return "!";
                }
                if (cmd.startsWith("outofrangemode", 5)) {
                    String id44 = Settings.uiGet("dlog.list", "value", session);
                    if (id44 != null && !id44.equals("")) {
                        DLogger dl = dLoggers.get(id44);
                        dl.setOutOfRangeMode(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("bckp_restore_open", 5)) {
                    String completed = Settings.uiGet("dlog.bckp_restore_complete", "visible");
                    if (completed != null && completed.equals("true")) {
                        Settings.uiSet("dlog.bckp_restore_cont", "visible", "true");
                        Settings.uiSet("dlog.bckp_restore_complete", "visible", "false");
                    }
                    return "!page:dlog_restore";
                }
                if (cmd.startsWith("size_open", 5)) {
                    Settings.uiSet("dlog.sizes", "value", "Please wait...");
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                DLogger.showSizes();
                            }
                            catch (Exception e2) {
                                Settings.log(0, "Data loggers sizes error - " + Settings.getStackTrace(e2));
                            }
                        }
                    }.start();
                    return "!page:dlog_size";
                }
            }
            if (cmd.startsWith("lctn.")) {
                if (cmd.startsWith("add", 5)) {
                    Settings.uiSet("lctn.id", "value", "", session);
                    return "!page:lctn_new";
                }
                if (cmd.startsWith("list", 5)) {
                    Location l2 = locations.get(param);
                    l2.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 5)) {
                    id = Settings.uiGet("lctn.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    Location l3 = locations.remove(id);
                    Settings.updateList(locations, "lctn.list");
                    Settings.uiSet("lctn.selected", "visible", "false", session);
                    Settings.uiSet("lctn.list", "value", "", session);
                    Settings.removeErrorsWithElement(l3);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 5)) {
                    String id45 = Settings.uiGet("lctn.list", "value", session);
                    if (id45 == null || id45.equals("")) {
                        return "!error";
                    }
                    Location l4 = locations.get(id45);
                    l4.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(locations, "lctn.list");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("mode", 5)) {
                    String id46 = Settings.uiGet("lctn.list", "value", session);
                    if (id46 != null && !id46.isEmpty()) {
                        Location l5 = locations.get(id46);
                        l5.setMode(param, session);
                        Settings.removeErrorsWithElement(l5);
                        l5.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("ip", 5)) {
                    String id47 = Settings.uiGet("lctn.list", "value", session);
                    if (id47 != null && !id47.equals("")) {
                        Location l6 = locations.get(id47);
                        l6.setIP(param);
                        Settings.removeErrorsWithElement(l6);
                        l6.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("beacon.", 5)) {
                    id = Settings.uiGet("lctn.list", "value", session);
                    if (id != null && !id.equals("")) {
                        Location l7 = locations.get(id);
                        if (cmd.endsWith("uuid")) {
                            l7.setBeaconUUID(param);
                        } else if (cmd.endsWith("major")) {
                            l7.setBeaconMajor(param);
                        } else if (cmd.endsWith("minor")) {
                            l7.setBeaconMinor(param);
                        } else {
                            return "!error";
                        }
                        Settings.removeErrorsWithElement(l7);
                        l7.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("geo.", 5)) {
                    id = Settings.uiGet("lctn.list", "value", session);
                    if (id != null && !id.equals("")) {
                        Location l8 = locations.get(id);
                        if (cmd.endsWith("latitude")) {
                            l8.setGeoLatitude(param);
                        } else if (cmd.endsWith("longitude")) {
                            l8.setGeoLongitude(param);
                        } else if (cmd.endsWith("distance")) {
                            l8.setGeoDistance(param);
                        } else {
                            return "!error";
                        }
                        Settings.removeErrorsWithElement(l8);
                        l8.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("dmx.")) {
                if (cmd.startsWith("add", 4)) {
                    Settings.uiSet("dmx.id", "value", "", session);
                    return "!page:dmx_new";
                }
                if (cmd.startsWith("list", 4)) {
                    DMX dmx = dmxs.get(param);
                    dmx.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 4)) {
                    id = Settings.uiGet("dmx.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    DMX dmx = dmxs.remove(id);
                    Settings.updateList(dmxs, "dmx.list");
                    Settings.uiSet("dmx.selected", "visible", "false", session);
                    Settings.uiSet("dmx.list", "value", "", session);
                    Settings.removeErrorsWithElement(dmx);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 4)) {
                    String id48 = Settings.uiGet("dmx.list", "value", session);
                    if (id48 == null || id48.equals("")) {
                        return "!error";
                    }
                    DMX dmx = dmxs.get(id48);
                    dmx.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(dmxs, "dmx.list");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("connection", 4)) {
                    String id49 = Settings.uiGet("dmx.list", "value", session);
                    if (id49 != null && !id49.equals("")) {
                        DMX dmx = dmxs.get(id49);
                        dmx.setConnection(param, session);
                        Settings.removeErrorsWithElement(dmx);
                        dmx.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("ip", 4)) {
                    String id50 = Settings.uiGet("dmx.list", "value", session);
                    if (id50 != null && !id50.equals("")) {
                        DMX dmx = dmxs.get(id50);
                        dmx.setIP(param);
                        Settings.removeErrorsWithElement(dmx);
                        dmx.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("port", 4)) {
                    String id51 = Settings.uiGet("dmx.list", "value", session);
                    if (id51 != null && !id51.equals("")) {
                        DMX dmx = dmxs.get(id51);
                        dmx.setPort(param);
                        Settings.removeErrorsWithElement(dmx);
                        dmx.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("comm", 4)) {
                    String id52 = Settings.uiGet("dmx.list", "value", session);
                    if (id52 != null && !id52.equals("")) {
                        DMX dmx = dmxs.get(id52);
                        dmx.setComm(param);
                        Settings.removeErrorsWithElement(dmx);
                        dmx.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("srvid", 4)) {
                    String id53 = Settings.uiGet("dmx.list", "value", session);
                    if (id53 != null && !id53.equals("")) {
                        DMX dmx = dmxs.get(id53);
                        dmx.setServerId(param);
                        Settings.removeErrorsWithElement(dmx);
                        dmx.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("tmr.")) {
                if (cmd.startsWith("add", 4)) {
                    Settings.uiSet("tmr.id", "value", "", session);
                    return "!page:tmr_new";
                }
                if (cmd.startsWith("list", 4)) {
                    Timer tmr = timers.get(param);
                    tmr.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 4)) {
                    id = Settings.uiGet("tmr.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    timers.remove(id);
                    Settings.updateList(timers, "tmr.list");
                    Settings.uiSet("tmr.list", "value", "", session);
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("enabled", 4)) {
                    String id54 = Settings.uiGet("tmr.list", "value", session);
                    if (id54 == null || id54.equals("")) {
                        return "!error";
                    }
                    Timer tmr = timers.get(id54);
                    tmr.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(timers, "tmr.list");
                    not_saved_changes = true;
                    return "!";
                }
            }
            if (cmd.startsWith("sqz.")) {
                if (cmd.startsWith("add", 4)) {
                    Settings.uiSet("sqz.id", "value", "", session);
                    return "!page:sqz_new";
                }
                if (cmd.startsWith("list", 4)) {
                    SlimPlayer sp = slimPlayers.get(param);
                    sp.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 4)) {
                    id = Settings.uiGet("sqz.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    SlimPlayer sp = slimPlayers.remove(id);
                    Settings.updateList(slimPlayers, "sqz.list");
                    Settings.uiSet("sqz.selected", "visible", "false", session);
                    Settings.uiSet("sqz.list", "value", "", session);
                    Settings.removeErrorsWithElement(sp);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 4)) {
                    String id55 = Settings.uiGet("sqz.list", "value", session);
                    if (id55 == null || id55.equals("")) {
                        return "!error";
                    }
                    SlimPlayer sp = slimPlayers.get(id55);
                    sp.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(slimPlayers, "sqz.list");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("player", 4)) {
                    String id56 = Settings.uiGet("sqz.list", "value", session);
                    if (id56 != null && !id56.equals("")) {
                        SlimPlayer sp = slimPlayers.get(id56);
                        sp.setPlayerId(param);
                        Settings.removeErrorsWithElement(sp);
                        sp.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("cam.")) {
                if (cmd.startsWith("add", 4)) {
                    Settings.uiSet("cam.id", "value", "", session);
                    return "!page:cam_new";
                }
                if (cmd.startsWith("list", 4)) {
                    Camera cam = cameras.get(param);
                    cam.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 4)) {
                    id = Settings.uiGet("cam.list", "value", session);
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    for (Grid g2 : grids) {
                        String[][] stringArray = g2.cams;
                        int n2 = g2.cams.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String[] row;
                            String[] stringArray2 = row = stringArray[n3];
                            int n4 = row.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                String c2 = stringArray2[n5];
                                if (c2 != null && c2.equals(id)) {
                                    throw new WarningException("Cannot remove this camera, it is used in Grid " + g2.getId());
                                }
                                ++n5;
                            }
                            ++n3;
                        }
                    }
                    Camera cam = cameras.remove(id);
                    Settings.updateList(cameras, "cam.list", "grid.cam11", "grid.cam12", "grid.cam13", "grid.cam14", "grid.cam15", "grid.cam16", "grid.cam21", "grid.cam22", "grid.cam23", "grid.cam24", "grid.cam25", "grid.cam26", "grid.cam31", "grid.cam32", "grid.cam33", "grid.cam34", "grid.cam35", "grid.cam36", "grid.cam41", "grid.cam42", "grid.cam43", "grid.cam44", "grid.cam45", "grid.cam46", "grid.cam51", "grid.cam52", "grid.cam53", "grid.cam54", "grid.cam55", "grid.cam56", "grid.cam61", "grid.cam62", "grid.cam63", "grid.cam64", "grid.cam65", "grid.cam66");
                    Settings.uiSet("cam.selected", "visible", "false", session);
                    Settings.uiSet("grid.selected", "visible", "false", session);
                    Settings.uiSet("cam.list", "value", "", session);
                    Settings.uiSet("grid.list", "value", "", session);
                    Settings.removeErrorsWithElement(cam);
                    not_saved_changes = true;
                    Settings.showErrors();
                    return "!";
                }
                if (cmd.startsWith("enabled", 4)) {
                    String id57 = Settings.uiGet("cam.list", "value", session);
                    if (id57 == null || id57.equals("")) {
                        return "!error";
                    }
                    Camera cam = cameras.get(id57);
                    cam.setEnabled(Boolean.parseBoolean(param));
                    Settings.updateList(cameras, "cam.list", "grid.cam11", "grid.cam12", "grid.cam13", "grid.cam14", "grid.cam15", "grid.cam16", "grid.cam21", "grid.cam22", "grid.cam23", "grid.cam24", "grid.cam25", "grid.cam26", "grid.cam31", "grid.cam32", "grid.cam33", "grid.cam34", "grid.cam35", "grid.cam36", "grid.cam41", "grid.cam42", "grid.cam43", "grid.cam44", "grid.cam45", "grid.cam46", "grid.cam51", "grid.cam52", "grid.cam53", "grid.cam54", "grid.cam55", "grid.cam56", "grid.cam61", "grid.cam62", "grid.cam63", "grid.cam64", "grid.cam65", "grid.cam66");
                    not_saved_changes = true;
                    return "!";
                }
                if (cmd.startsWith("urlsmall", 4)) {
                    String id58 = Settings.uiGet("cam.list", "value", session);
                    if (id58 != null && !id58.equals("")) {
                        Camera cam = cameras.get(id58);
                        cam.setURLSmall(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("url", 4)) {
                    String id59 = Settings.uiGet("cam.list", "value", session);
                    if (id59 != null && !id59.equals("")) {
                        Camera cam = cameras.get(id59);
                        cam.setURL(param);
                        Settings.removeErrorsWithElement(cam);
                        cam.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("ptz", 4)) {
                    String id60 = Settings.uiGet("cam.list", "value", session);
                    if (id60 != null && !id60.equals("")) {
                        Camera cam = cameras.get(id60);
                        cam.setPTZ(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("type", 4)) {
                    String id61 = Settings.uiGet("cam.list", "value", session);
                    if (id61 != null && !id61.equals("")) {
                        Camera cam = cameras.get(id61);
                        cam.setType(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("io", 4)) {
                    String id62 = Settings.uiGet("cam.list", "value", session);
                    if (id62 != null && !id62.equals("")) {
                        Camera cam = cameras.get(id62);
                        cam.setIO(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("user", 4)) {
                    String id63 = Settings.uiGet("cam.list", "value", session);
                    if (id63 != null && !id63.equals("")) {
                        Camera cam = cameras.get(id63);
                        cam.setUser(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("password", 4)) {
                    String id64 = Settings.uiGet("cam.list", "value", session);
                    if (id64 != null && !id64.equals("")) {
                        Camera cam = cameras.get(id64);
                        cam.setPassword(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("dropped", 4)) {
                    String id65 = Settings.uiGet("cam.list", "value", session);
                    if (id65 != null && !id65.equals("")) {
                        Camera cam = cameras.get(id65);
                        cam.setDroppedFrames(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("maxage", 4)) {
                    String id66 = Settings.uiGet("cam.list", "value", session);
                    if (id66 != null && !id66.equals("")) {
                        Camera cam = cameras.get(id66);
                        cam.setMaxAge(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("buffer", 4)) {
                    String id67 = Settings.uiGet("cam.list", "value", session);
                    if (id67 != null && !id67.equals("")) {
                        Camera cam = cameras.get(id67);
                        cam.setMotionBuffer(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("remote", 4)) {
                    String id68 = Settings.uiGet("cam.list", "value", session);
                    if (id68 != null && !id68.equals("")) {
                        Camera cam = cameras.get(id68);
                        cam.setRemoteRequestPassword(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("trusted", 4)) {
                    String id69 = Settings.uiGet("cam.list", "value", session);
                    if (id69 != null && !id69.equals("")) {
                        Camera cam = cameras.get(id69);
                        cam.setTrustedRequestPassword(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("rotate", 4)) {
                    String id70 = Settings.uiGet("cam.list", "value", session);
                    if (id70 != null && !id70.equals("")) {
                        Camera cam = cameras.get(id70);
                        cam.setRotate(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("grid.")) {
                if (cmd.startsWith("add", 5)) {
                    Grid g3 = new Grid();
                    grids.add(g3);
                    Settings.updateList(grids, "grid.list");
                    g3.writeIniDeclaration(null);
                    not_saved_changes = true;
                    Settings.showErrors();
                    g3.show(session);
                    return "!page:close";
                }
                if (cmd.startsWith("list", 5)) {
                    Grid g4 = grids.get(Integer.parseInt(param) - 1);
                    g4.show(session);
                    return "!";
                }
                if (cmd.startsWith("remove", 5)) {
                    String idx = Settings.uiGet("grid.list", "value", session);
                    if (idx != null && !idx.equals("")) {
                        Grid g5 = grids.remove(Integer.parseInt(idx) - 1);
                        Settings.updateList(grids, "grid.list");
                        Settings.uiSet("cam.selected", "visible", "false", session);
                        Settings.uiSet("grid.selected", "visible", "false", session);
                        Settings.uiSet("grid.list", "value", "", session);
                        Settings.uiSet("cam.list", "value", "", session);
                        Settings.removeErrorsWithElement(g5);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("rows", 5)) {
                    if (param.equals("")) {
                        return "!error";
                    }
                    String id71 = Settings.uiGet("grid.list", "value", session);
                    if (id71 != null && !id71.equals("")) {
                        Grid g6 = grids.get(Integer.parseInt(id71) - 1);
                        g6.setRows(param, session);
                        Settings.removeErrorsWithElement(g6);
                        g6.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("cols", 5)) {
                    String id72 = Settings.uiGet("grid.list", "value", session);
                    if (id72 != null && !id72.equals("")) {
                        Grid g7 = grids.get(Integer.parseInt(id72) - 1);
                        g7.setColumns(param, session);
                        Settings.removeErrorsWithElement(g7);
                        g7.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("cam", 5)) {
                    String id73 = Settings.uiGet("grid.list", "value", session);
                    if (id73 != null && !id73.equals("")) {
                        Grid g8 = grids.get(Integer.parseInt(id73) - 1);
                        int r = Character.getNumericValue(cmd.charAt(8));
                        int c3 = Character.getNumericValue(cmd.charAt(9));
                        g8.setCamera(param, r, c3);
                        Settings.removeErrorsWithElement(g8);
                        g8.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("resolution", 5)) {
                    String id74 = Settings.uiGet("grid.list", "value", session);
                    if (id74 != null && !id74.equals("")) {
                        Grid g9 = grids.get(Integer.parseInt(id74) - 1);
                        if (cmd.endsWith(".w")) {
                            g9.setResolutionWidth(param);
                        } else if (cmd.endsWith(".h")) {
                            g9.setResolutionHeight(param);
                        }
                        Settings.removeErrorsWithElement(g9);
                        g9.writeIniDeclaration(null);
                        not_saved_changes = true;
                        Settings.showErrors();
                    }
                    return "!";
                }
                if (cmd.startsWith("remote", 5)) {
                    String id75 = Settings.uiGet("grid.list", "value", session);
                    if (id75 != null && !id75.equals("")) {
                        Grid g10 = grids.get(Integer.parseInt(id75) - 1);
                        g10.setRemoteRequestPassword(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
                if (cmd.startsWith("trusted", 5)) {
                    String id76 = Settings.uiGet("grid.list", "value", session);
                    if (id76 != null && !id76.equals("")) {
                        Grid g11 = grids.get(Integer.parseInt(id76) - 1);
                        g11.setTrustedRequestPassword(param);
                        not_saved_changes = true;
                    }
                    return "!";
                }
            }
            if (cmd.startsWith("error.") && cmd.startsWith("list", 6)) {
                Error w = errors.get(param);
                if (w.element instanceof IOServer) {
                    Settings.uiSet("ios.list", "value", w.element.getId(), session);
                    ((IOServer)w.element).show(session);
                    return "!page:ios";
                }
                if (w.element instanceof CommPort) {
                    Settings.uiSet("comm.list", "value", w.element.getId(), session);
                    ((CommPort)w.element).show(session);
                    return "!page:comm";
                }
                if (w.element instanceof IRTrans) {
                    Settings.uiSet("ir.list", "value", w.element.getId(), session);
                    ((IRTrans)w.element).show(session);
                    return "!page:ir";
                }
                if (w.element instanceof Camera) {
                    Settings.uiSet("cam.list", "value", w.element.getId(), session);
                    ((Camera)w.element).show(session);
                    return "!page:cam";
                }
                if (w.element instanceof Grid) {
                    Settings.uiSet("grid.list", "value", w.element.getId(), session);
                    ((Grid)w.element).show(session);
                    return "!page:cam";
                }
                if (w.element instanceof DLogger) {
                    Settings.uiSet("dlog.list", "value", w.element.getId(), session);
                    ((DLogger)w.element).show(session);
                    return "!page:dlog";
                }
                if (w.element instanceof DMX) {
                    Settings.uiSet("dmx.list", "value", w.element.getId(), session);
                    ((DMX)w.element).show(session);
                    return "!page:dmx";
                }
                if (w.element instanceof Location) {
                    Settings.uiSet("lctn.list", "value", w.element.getId(), session);
                    ((Location)w.element).show(session);
                    return "!page:lctn";
                }
                if (w.element instanceof SlimPlayer) {
                    Settings.uiSet("sqz.list", "value", w.element.getId(), session);
                    ((SlimPlayer)w.element).show(session);
                    return "!page:sqz";
                }
                return "!";
            }
            Field field = fields.get(cmd);
            if (field != null) {
                field.setValue(param);
                not_saved_changes = true;
                return "!";
            }
            field = extraFields.get(cmd);
            if (field != null) {
                field.setValue(param);
                not_saved_changes = true;
                return "!";
            }
            try {
                throw new Exception("Unknown command");
            }
            catch (InputException e2) {
                Settings.log(1, "InputException: " + e2.getLocalizedMessage());
                return "!error";
            }
            catch (WarningException e3) {
                Settings.uiSet("warning.message", "text", e3.getLocalizedMessage(), session);
                Settings.log(1, "WarningException: " + e3.getLocalizedMessage());
                return "!page:warning";
            }
            catch (Throwable e4) {
                Settings.log(0, "error processing command '" + cmd + " = " + param + "' - " + Settings.getStackTrace(e4));
                return "!error";
            }
        }
        finally {
            Settings.uiSet("notsaved", "visible", "" + not_saved_changes);
        }
    }

    public static void pageEvent(String address, String session, String userid, String project, String page) {
        if (!project.equals(PROJECT_NAME)) {
            return;
        }
        if (page.equals("ios")) {
            Settings.uiSet("ios.list", "value", "", session);
            Settings.uiSet("ios.selected", "visible", "false", session);
        } else if (page.equals("comm")) {
            Settings.uiSet("comm.list", "value", "", session);
            Settings.uiSet("comm.type.server", "visible", "false", session);
            Settings.uiSet("comm.type.irtrans", "visible", "false", session);
            Settings.uiSet("comm.type.io", "visible", "false", session);
            Settings.uiSet("comm.type.serial", "visible", "false", session);
        } else if (page.equals("ir")) {
            Settings.uiSet("ir.list", "value", "", session);
            Settings.uiSet("ir.selected", "visible", "false", session);
        } else if (page.equals("cam")) {
            Settings.uiSet("cam.list", "value", "", session);
            Settings.uiSet("grid.list", "value", "", session);
            Settings.uiSet("cam.selected", "visible", "false", session);
            Settings.uiSet("grid.selected", "visible", "false", session);
        } else if (page.equals("dlog")) {
            Settings.uiSet("dlog.list", "value", "", session);
            Settings.uiSet("dlog.selected", "visible", "false", session);
        } else if (page.equals("dmx")) {
            Settings.uiSet("dmx.list", "value", "", session);
            Settings.uiSet("dmx.selected", "visible", "false", session);
        } else if (page.equals("lctn")) {
            Settings.uiSet("lctn.list", "value", "", session);
            Settings.uiSet("lctn.selected", "visible", "false", session);
        } else if (page.equals("tmr")) {
            Settings.uiSet("tmr.list", "value", "", session);
        } else if (page.equals("sqz")) {
            Settings.uiSet("sqz.list", "value", "", session);
            Settings.uiSet("sqz.selected", "visible", "false", session);
        }
    }

    public static String userSubmit(String session, String userid, String cmd, HashMap<String, String> submitted) {
        try {
            if (!cmd.startsWith(PREFIX)) {
                return null;
            }
            if (!initialized) {
                return null;
            }
            cmd = cmd.substring(PREFIX.length());
            Settings.log(1, "processing submit command '" + cmd + "'");
            if (cmd.startsWith("extra.")) {
                if (cmd.endsWith("new") || cmd.endsWith("edit")) {
                    String id = submitted.get("__hsyco__stng.extra.id");
                    String value = submitted.get("__hsyco__stng.extra.value");
                    if (id.equals("")) {
                        throw new InputException("ID not specified");
                    }
                    if (cmd.endsWith("new") && (extraFields.containsKeyIgnoreCase(id) || fields.containsKeyIgnoreCase(id))) {
                        throw new InputException("ID already used");
                    }
                    Field f2 = new Field(id, null, null, null);
                    extraFields.put(f2.id, f2);
                    f2.setValue(value);
                    not_saved_changes = true;
                    Settings.updateList(extraFields, "extra.list");
                    return "!page:close";
                }
                if (cmd.endsWith("remove")) {
                    String id = submitted.get("__hsyco__stng.extra.id");
                    if (id == null || id.length() == 0) {
                        return "!";
                    }
                    extraFields.remove(id);
                    not_saved_changes = true;
                    Settings.updateList(extraFields, "extra.list");
                    Settings.uiSet("extra.list", "value", "", session);
                    return "!page:close";
                }
            }
            if (cmd.startsWith("ios.")) {
                if (cmd.startsWith("new", 4)) {
                    String id = submitted.get("__hsyco__stng.ios.id");
                    String type = submitted.get("__hsyco__stng.ios.type");
                    if (id.equals("")) {
                        throw new InputException("ID not specified");
                    }
                    if (type.equals("")) {
                        throw new InputException("No type selected");
                    }
                    if (ioServers.containsKeyIgnoreCase(id)) {
                        throw new InputException("ID already used");
                    }
                    IOServer ios = new IOServer(id, iosTypes.get(type), true);
                    ioServers.put(ios.getId(), ios);
                    Settings.updateList(ioServers, "ios.list");
                    not_saved_changes = true;
                    ios.writeIniDeclaration(null);
                    Settings.showErrors();
                    ios.show(session);
                    return "!page:close";
                }
                if (cmd.startsWith("option.", 4)) {
                    if (cmd.endsWith("new")) {
                        String ioId = Settings.uiGet("ios.list", "value", session);
                        if (ioId != null && !ioId.equals("")) {
                            String value;
                            IOServer ios = ioServers.get(ioId);
                            String id = submitted.get("__hsyco__stng.ios.option.id.select");
                            if (id.equals("")) {
                                throw new InputException("No option selected");
                            }
                            String valueInput = submitted.get("__hsyco__stng.ios.option.value.input");
                            String valueSelect = submitted.get("__hsyco__stng.ios.option.value.select");
                            if (!valueInput.equals("")) {
                                value = valueInput;
                            } else if (!valueSelect.equals("")) {
                                value = valueSelect;
                            } else {
                                throw new InputException("No value entered");
                            }
                            ios.addOption(id, value, session);
                            not_saved_changes = true;
                        }
                        return "!page:close";
                    }
                    if (cmd.endsWith("edit")) {
                        String ioId = Settings.uiGet("ios.list", "value", session);
                        if (ioId != null && !ioId.equals("")) {
                            String value;
                            IOServer ios = ioServers.get(ioId);
                            String id = Settings.uiGet("ios.option.id", "text", session);
                            String valueInput = submitted.get("__hsyco__stng.ios.option.value.input");
                            String valueSelect = submitted.get("__hsyco__stng.ios.option.value.select");
                            if (!valueInput.equals("")) {
                                value = valueInput;
                            } else if (!valueSelect.equals("")) {
                                value = valueSelect;
                            } else {
                                throw new InputException("No value entered");
                            }
                            ios.setOptionValue(id, value, session);
                            not_saved_changes = true;
                        }
                        return "!page:close";
                    }
                }
            }
            if (cmd.startsWith("ir.") && cmd.startsWith("new", 3)) {
                String id = submitted.get("__hsyco__stng.ir.id");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (irTrans.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                IRTrans ir = new IRTrans(id, true);
                irTrans.put(ir.getId(), ir);
                Settings.updateList(irTrans, "ir.list", "comm.ir");
                not_saved_changes = true;
                ir.writeIniDeclaration(null);
                Settings.showErrors();
                ir.show(session);
                return "!page:close";
            }
            if (cmd.startsWith("comm.") && cmd.startsWith("new", 5)) {
                String id = submitted.get("__hsyco__stng.comm.id");
                String type = submitted.get("__hsyco__stng.comm.type");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (type.equals("")) {
                    throw new InputException("No type selected");
                }
                if (commPorts.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                CommPort cp = new CommPort(id, type, true);
                commPorts.put(cp.getId(), cp);
                Settings.updateList(commPorts, "comm.list");
                not_saved_changes = true;
                cp.writeIniDeclaration(null);
                Settings.showErrors();
                cp.show(session);
                return "!page:close";
            }
            if (cmd.startsWith("dlog.")) {
                if (cmd.startsWith("new", 5)) {
                    String id = submitted.get("__hsyco__stng.dlog.id");
                    String type = submitted.get("__hsyco__stng.dlog.type");
                    if (id.equals("")) {
                        throw new InputException("ID not specified");
                    }
                    if (type.equals("")) {
                        throw new InputException("No type selected");
                    }
                    if (dLoggers.containsKeyIgnoreCase(id)) {
                        throw new InputException("ID already used");
                    }
                    DLogger dl = new DLogger(id, type, true);
                    dLoggers.put(dl.getId(), dl);
                    Settings.updateList(dLoggers, "dlog.list");
                    not_saved_changes = true;
                    dl.writeIniDeclaration(null);
                    Settings.showErrors();
                    dl.show(session);
                    return "!page:close";
                }
                if (cmd.startsWith("bckp", 5)) {
                    final String backupDirectory = submitted.get("__hsyco__stng.dlog.bckp_dir").trim();
                    final boolean overwrite = Boolean.parseBoolean(submitted.get("__hsyco__stng.dlog.bckp_ow"));
                    Settings.uiSet("dlog.bckp_restore_cont", "visible", "false");
                    Settings.uiSet("dlog.bckp_restore_progr_cont", "visible", "true");
                    Settings.uiSet("dlog.bckp_restore_complete", "visible", "false");
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                DLogger.restoreFromBackup(backupDirectory, overwrite);
                                Settings.uiSet("dlog.bckp_restore_complete_msg", "value", "Restore completed");
                            }
                            catch (Exception e2) {
                                Settings.uiSet("dlog.bckp_restore_complete_msg", "value", e2.getLocalizedMessage());
                                Settings.log(0, "Data loggers backup restore error - " + Settings.getStackTrace(e2));
                            }
                            Settings.uiSet("dlog.bckp_restore_progr_cont", "visible", "false");
                            Settings.uiSet("dlog.bckp_restore_complete", "visible", "true");
                        }
                    }.start();
                    return "!";
                }
            }
            if (cmd.startsWith("lctn.") && cmd.startsWith("new", 5)) {
                String id = submitted.get("__hsyco__stng.lctn.id");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (locations.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                Location l2 = new Location(id, true);
                locations.put(l2.getId(), l2);
                Settings.updateList(locations, "lctn.list");
                not_saved_changes = true;
                l2.writeIniDeclaration(null);
                Settings.showErrors();
                l2.show(session);
                return "!page:close";
            }
            if (cmd.startsWith("dmx.") && cmd.startsWith("new", 4)) {
                String id = submitted.get("__hsyco__stng.dmx.id");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (dmxs.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                DMX dmx = new DMX(id, true);
                dmxs.put(dmx.getId(), dmx);
                Settings.updateList(dmxs, "dmx.list");
                not_saved_changes = true;
                dmx.writeIniDeclaration(null);
                Settings.showErrors();
                dmx.show(session);
                return "!page:close";
            }
            if (cmd.startsWith("tmr.") && cmd.startsWith("new", 4)) {
                String id = submitted.get("__hsyco__stng.tmr.id");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (timers.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                Timer tmr = new Timer(id, true);
                timers.put(tmr.getId(), tmr);
                not_saved_changes = true;
                Settings.updateList(timers, "tmr.list");
                tmr.show(session);
                return "!page:close";
            }
            if (cmd.startsWith("sqz.") && cmd.startsWith("new", 4)) {
                String id = submitted.get("__hsyco__stng.sqz.id");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (slimPlayers.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                SlimPlayer sp = new SlimPlayer(id, true);
                slimPlayers.put(sp.getId(), sp);
                Settings.updateList(slimPlayers, "sqz.list");
                not_saved_changes = true;
                sp.writeIniDeclaration(null);
                Settings.showErrors();
                sp.show(session);
                return "!page:close";
            }
            if (cmd.startsWith("cam.") && cmd.startsWith("new", 4)) {
                String id = submitted.get("__hsyco__stng.cam.id");
                if (id.equals("")) {
                    throw new InputException("ID not specified");
                }
                if (cameras.containsKeyIgnoreCase(id)) {
                    throw new InputException("ID already used");
                }
                Camera cam = new Camera(id, true);
                cameras.put(cam.getId(), cam);
                Settings.updateList(cameras, "cam.list", "grid.cam11", "grid.cam12", "grid.cam13", "grid.cam14", "grid.cam15", "grid.cam16", "grid.cam21", "grid.cam22", "grid.cam23", "grid.cam24", "grid.cam25", "grid.cam26", "grid.cam31", "grid.cam32", "grid.cam33", "grid.cam34", "grid.cam35", "grid.cam36", "grid.cam41", "grid.cam42", "grid.cam43", "grid.cam44", "grid.cam45", "grid.cam46", "grid.cam51", "grid.cam52", "grid.cam53", "grid.cam54", "grid.cam55", "grid.cam56", "grid.cam61", "grid.cam62", "grid.cam63", "grid.cam64", "grid.cam65", "grid.cam66");
                not_saved_changes = true;
                cam.writeIniDeclaration(null);
                Settings.showErrors();
                cam.show(session);
                return "!page:close";
            }
            try {
                throw new Exception("Unknown command");
            }
            catch (InputException e2) {
                Settings.log(1, "InputException: " + e2.getLocalizedMessage());
                return "!error";
            }
            catch (WarningException e3) {
                Settings.uiSet("warning.message", "text", e3.getLocalizedMessage(), session);
                Settings.log(1, "WarningException: " + e3.getLocalizedMessage());
                return "!page:warning";
            }
            catch (Throwable e4) {
                Settings.log(0, "error processing submit command '" + cmd + "' - " + Settings.getStackTrace(e4));
                return "!error";
            }
        }
        finally {
            Settings.uiSet("notsaved", "visible", "" + not_saved_changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeErrorsWithElement(Listable element) {
        SynchronizedStringHashMap<Error> synchronizedStringHashMap = errors;
        synchronized (synchronizedStringHashMap) {
            Iterator<Map.Entry<String, Error>> it = errors.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().element != element) continue;
                it.remove();
            }
        }
    }

    public static void uiClearEvent(String session) {
        userBase.uiSet(session, PROJECT_NAME, "page", "menu");
    }

    static <T extends Listable> void updateList(SynchronizedStringHashMap<T> list, String ... listIds) {
        Settings.updateList(list.values(), listIds);
    }

    static <T extends Listable> void updateList(Collection<T> list, String ... listIds) {
        Settings.updateList(null, list, listIds);
    }

    static <T extends Listable> void updateList(String session, SynchronizedStringHashMap<T> list, String ... listIds) {
        Settings.updateList(session, list.values(), listIds);
    }

    static <T extends Listable> void updateList(String session, Collection<T> list, String ... listIds) {
        String[] stringArray = listIds;
        int n2 = listIds.length;
        int n3 = 0;
        while (n3 < n2) {
            String listId = stringArray[n3];
            StringBuilder values = new StringBuilder();
            StringBuilder labels = new StringBuilder();
            for (Listable e2 : list) {
                String lab = e2.getListLabel(listId);
                if (lab == null) continue;
                values.append(',').append(e2.getId());
                labels.append(',').append(lab.replace(",", "&comma;"));
            }
            if (session == null) {
                Settings.uiSet(listId, "values", values.length() > 0 ? values.substring(1) : "");
                Settings.uiSet(listId, "labels", labels.length() > 0 ? labels.substring(1) : "");
            } else {
                Settings.uiSet(listId, "values", values.length() > 0 ? values.substring(1) : "", session);
                Settings.uiSet(listId, "labels", labels.length() > 0 ? labels.substring(1) : "", session);
            }
            ++n3;
        }
    }

    public static void uiSet(String id, String attr, String value) {
        userBase.uiSet("__hsyco__stng.scope!", PREFIX + id, attr, value);
    }

    public static void uiSet(String id, String attr, String value, String session) {
        userBase.uiSet(session, PREFIX + id, attr, value);
    }

    public static String uiGet(String id, String attr) {
        return userBase.uiGet("__hsyco__stng.scope!", PREFIX + id, attr);
    }

    public static String uiGet(String id, String attr, String session) {
        return userBase.uiGet(session, PREFIX + id, attr);
    }

    static String getStackTrace(Throwable e2) {
        try {
            StringWriter sw = new StringWriter();
            sw.append(e2.getLocalizedMessage());
            if (Configuration.verboseLog || debug) {
                sw.append("\n\t");
                e2.printStackTrace(new PrintWriter(sw));
            }
            return sw.toString();
        }
        catch (Throwable t) {
            e2.printStackTrace();
            t.printStackTrace();
            return "check 'console.log'";
        }
    }

    static void log(int tag, String message) {
        switch (tag) {
            case 2: {
                Settings.messageLog("[SETTINGS] Warning | " + message);
                break;
            }
            case 3: {
                Settings.messageLog("[SETTINGS] Message | " + message);
                break;
            }
            case 0: {
                Settings.errorLog("[SETTINGS] Error | " + message);
                break;
            }
            case 1: {
                if (!Configuration.verboseLog) break;
                Settings.messageLog("[SETTINGS]  Verbose | " + message);
                break;
            }
        }
    }
}

