/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class Location
extends Listable {
    private String ip;
    private String beaconUUID;
    private String beaconMajor;
    private String beaconMinor;
    private String geoLatitude;
    private String geoLongitude;
    private String geoDistance;
    private boolean enabled = true;

    Location(String id, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal LocationBase ID: " + id);
        }
        Settings.log(1, "Created LocationBase '" + this.id + "'");
    }

    @Override
    String getListLabel(String list) {
        if (this.enabled) {
            return this.id;
        }
        return "<div style=\"color:#A0A0A0\">" + this.id + "</div>";
    }

    void setMode(String value, String session) {
        if (value.equals("ip")) {
            this.ip = "";
            this.beaconUUID = null;
            this.beaconMajor = null;
            this.beaconMinor = null;
            this.geoLatitude = null;
            this.geoLongitude = null;
            this.geoDistance = null;
        } else if (value.equals("beacon")) {
            this.ip = null;
            this.beaconUUID = "";
            this.beaconMajor = "";
            this.beaconMinor = "";
            this.geoLatitude = null;
            this.geoLongitude = null;
            this.geoDistance = null;
        } else if (value.equals("geo")) {
            this.ip = null;
            this.beaconUUID = null;
            this.beaconMajor = null;
            this.beaconMinor = null;
            this.geoLatitude = "";
            this.geoLongitude = "";
            this.geoDistance = "";
        }
        this.show(session);
    }

    void setIP(String ip) throws InputException {
        if (ip != null && !ip.matches("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])")) {
            throw new InputException("Illegal IP address for LocationBase '" + this.id + "': " + ip);
        }
        this.ip = ip;
        Settings.log(1, "LocationBase '" + this.id + "' - IP set to: " + this.ip);
    }

    void setBeacon(String beacon) throws InputException {
        if (beacon == null) {
            this.beaconUUID = null;
            this.beaconMajor = null;
            this.beaconMinor = null;
        } else {
            String[] umm = beacon.split(",");
            if (umm.length < 3) {
                throw new InputException("Illegal beacon params for LocationBase '" + this.id + "': " + beacon);
            }
            this.setBeaconUUID(umm[0]);
            this.setBeaconMajor(umm[1]);
            this.setBeaconMinor(umm[2]);
        }
    }

    void setBeaconUUID(String uuid) throws InputException {
        if (uuid != null && !uuid.matches("[\\da-fA-F]{8}\\-[\\da-fA-F]{4}\\-[\\da-fA-F]{4}\\-[\\da-fA-F]{4}\\-[\\da-fA-F]{12}")) {
            throw new InputException("Illegal beacon UUID for LocationBase '" + this.id + "': " + uuid);
        }
        this.beaconUUID = uuid;
        Settings.log(1, "LocationBase '" + this.id + "' - Beacon UUID set to: " + this.beaconUUID);
    }

    void setBeaconMajor(String major) throws InputException {
        int m2;
        if (major == null) {
            this.beaconMajor = null;
        }
        try {
            m2 = Integer.parseInt(major);
            if (m2 < 0 || m2 > 65535) {
                throw new Exception();
            }
        }
        catch (Exception e2) {
            throw new InputException("Illegal beacon major for LocationBase '" + this.id + "': " + major);
        }
        this.beaconMajor = "" + m2;
        Settings.log(1, "LocationBase '" + this.id + "' - Beacon major set to: " + this.beaconMajor);
    }

    void setBeaconMinor(String minor) throws InputException {
        int m2;
        if (minor == null) {
            this.beaconMinor = null;
        }
        try {
            m2 = Integer.parseInt(minor);
            if (m2 < 0 || m2 > 65535) {
                throw new Exception();
            }
        }
        catch (Exception e2) {
            throw new InputException("Illegal beacon minor for LocationBase '" + this.id + "': " + minor);
        }
        this.beaconMinor = "" + m2;
        Settings.log(1, "LocationBase '" + this.id + "' - Beacon minor set to: " + this.beaconMinor);
    }

    void setGeo(String geo) throws InputException {
        if (geo == null) {
            this.geoLatitude = null;
            this.geoLongitude = null;
            this.geoDistance = null;
        } else {
            String[] lld = geo.split(",");
            if (lld.length < 3) {
                throw new InputException("Illegal Geo params for LocationBase '" + this.id + "': " + geo);
            }
            this.setGeoLatitude(lld[0]);
            this.setGeoLongitude(lld[1]);
            this.setGeoDistance(lld[2]);
        }
    }

    void setGeoLatitude(String lat) throws InputException {
        if (lat != null) {
            try {
                Double.parseDouble(lat);
            }
            catch (Exception e2) {
                throw new InputException("Illegal Latitude for LocationBase '" + this.id + "': " + lat);
            }
        }
        this.geoLatitude = lat;
        Settings.log(1, "LocationBase '" + this.id + "' - Latitude set to: " + this.geoLatitude);
    }

    void setGeoLongitude(String lon) throws InputException {
        if (lon != null) {
            try {
                Double.parseDouble(lon);
            }
            catch (Exception e2) {
                throw new InputException("Illegal Longitude for LocationBase '" + this.id + "': " + lon);
            }
        }
        this.geoLongitude = lon;
        Settings.log(1, "LocationBase '" + this.id + "' - Longitude set to: " + this.geoLongitude);
    }

    void setGeoDistance(String dis) throws InputException {
        if (dis != null) {
            try {
                Double.parseDouble(dis);
            }
            catch (Exception e2) {
                throw new InputException("Illegal Distance for LocationBase '" + this.id + "': " + dis);
            }
        }
        this.geoDistance = dis;
        Settings.log(1, "LocationBase '" + this.id + "' - Distance set to: " + this.geoDistance);
    }

    void show(String session) {
        Settings.uiSet("lctn.selected", "visible", "true", session);
        Settings.uiSet("lctn.list", "value", this.id, session);
        Settings.uiSet("lctn.enabled", "value", Boolean.toString(this.enabled), session);
        if (this.beaconUUID != null) {
            Settings.uiSet("lctn.mode", "value", "beacon", session);
            Settings.uiSet("lctn.ip", "enabled", "false", session);
            Settings.uiSet("lctn.beacon.uuid", "enabled", "true", session);
            Settings.uiSet("lctn.beacon.major", "enabled", "true", session);
            Settings.uiSet("lctn.beacon.minor", "enabled", "true", session);
            Settings.uiSet("lctn.geo.latitude", "enabled", "false", session);
            Settings.uiSet("lctn.geo.longitude", "enabled", "false", session);
            Settings.uiSet("lctn.geo.distance", "enabled", "false", session);
            Settings.uiSet("lctn.ip", "value", "", session);
            Settings.uiSet("lctn.beacon.uuid", "value", this.beaconUUID != null ? this.beaconUUID : "", session);
            Settings.uiSet("lctn.beacon.major", "value", this.beaconMajor != null ? this.beaconMajor : "", session);
            Settings.uiSet("lctn.beacon.minor", "value", this.beaconMinor != null ? this.beaconMinor : "", session);
            Settings.uiSet("lctn.geo.latitude", "value", "", session);
            Settings.uiSet("lctn.geo.longitude", "value", "", session);
            Settings.uiSet("lctn.geo.distance", "value", "", session);
        } else if (this.geoLatitude != null) {
            Settings.uiSet("lctn.mode", "value", "geo", session);
            Settings.uiSet("lctn.ip", "enabled", "false", session);
            Settings.uiSet("lctn.beacon.uuid", "enabled", "false", session);
            Settings.uiSet("lctn.beacon.major", "enabled", "false", session);
            Settings.uiSet("lctn.beacon.minor", "enabled", "false", session);
            Settings.uiSet("lctn.geo.latitude", "enabled", "true", session);
            Settings.uiSet("lctn.geo.longitude", "enabled", "true", session);
            Settings.uiSet("lctn.geo.distance", "enabled", "true", session);
            Settings.uiSet("lctn.ip", "value", "", session);
            Settings.uiSet("lctn.beacon.uuid", "value", "", session);
            Settings.uiSet("lctn.beacon.major", "value", "", session);
            Settings.uiSet("lctn.beacon.minor", "value", "", session);
            Settings.uiSet("lctn.geo.latitude", "value", this.geoLatitude != null ? this.geoLatitude : "", session);
            Settings.uiSet("lctn.geo.longitude", "value", this.geoLongitude != null ? this.geoLongitude : "", session);
            Settings.uiSet("lctn.geo.distance", "value", this.geoDistance != null ? this.geoDistance : "", session);
        } else {
            Settings.uiSet("lctn.mode", "value", "ip", session);
            Settings.uiSet("lctn.ip", "enabled", "true", session);
            Settings.uiSet("lctn.beacon.uuid", "enabled", "false", session);
            Settings.uiSet("lctn.beacon.major", "enabled", "false", session);
            Settings.uiSet("lctn.beacon.minor", "enabled", "false", session);
            Settings.uiSet("lctn.geo.latitude", "enabled", "false", session);
            Settings.uiSet("lctn.geo.longitude", "enabled", "false", session);
            Settings.uiSet("lctn.geo.distance", "enabled", "false", session);
            Settings.uiSet("lctn.ip", "value", this.ip != null ? this.ip : "", session);
            Settings.uiSet("lctn.beacon.uuid", "value", "", session);
            Settings.uiSet("lctn.beacon.major", "value", "", session);
            Settings.uiSet("lctn.beacon.minor", "value", "", session);
            Settings.uiSet("lctn.geo.latitude", "value", "", session);
            Settings.uiSet("lctn.geo.longitude", "value", "", session);
            Settings.uiSet("lctn.geo.distance", "value", "", session);
        }
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if ((this.ip == null || this.ip.isEmpty()) && (this.beaconUUID == null || this.beaconUUID.isEmpty() || this.beaconMajor == null || this.beaconMajor.isEmpty() || this.beaconMinor == null || this.beaconMinor.isEmpty()) && (this.geoLatitude == null || this.geoLatitude.isEmpty() || this.geoLongitude == null || this.geoLongitude.isEmpty() || this.geoDistance == null || this.geoDistance.isEmpty())) {
            new Error("Location Base '" + this.id + "' - parameters not set", this);
        }
        if (bw != null) {
            if (this.ip != null) {
                bw.write("LocationBaseIP." + this.id);
                bw.write(" = ");
                bw.write(this.ip);
                bw.write("\n");
            } else if (this.beaconUUID != null) {
                bw.write("LocationBaseBeacon." + this.id);
                bw.write(" = ");
                bw.write(this.beaconUUID);
                bw.write(",");
                bw.write(this.beaconMajor);
                bw.write(",");
                bw.write(this.beaconMinor);
                bw.write("\n");
            } else if (this.geoLatitude != null) {
                bw.write("LocationGeo." + this.id);
                bw.write(" = ");
                bw.write(this.geoLatitude);
                bw.write(",");
                bw.write(this.geoLongitude);
                bw.write(",");
                bw.write(this.geoDistance);
                bw.write("\n");
            }
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

