/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.SynchronizedStringHashMap;

class IOServerType
extends Listable {
    static final int AUTH_YES = 0;
    static final int AUTH_NO = 1;
    static final int AUTH_PASSWORD = 2;
    private final boolean connectionIP;
    private final boolean connectionComm;
    private final boolean connectionOptional;
    private final List<String> commTypes;
    private final int usesAuth;
    private final boolean isCommPort;
    private final SynchronizedStringHashMap<OptionType> options;

    private IOServerType(String id, boolean connectionEth, boolean connectionSerial, String commType, boolean connectionOptional, int usesAuth, boolean isCommPort, SynchronizedStringHashMap<OptionType> options) {
        super(id);
        this.connectionIP = connectionEth;
        this.connectionComm = connectionSerial;
        this.commTypes = commType != null ? Arrays.asList(commType.replaceAll("\\s+", "").split(",")) : null;
        this.connectionOptional = connectionOptional;
        this.usesAuth = usesAuth;
        this.isCommPort = isCommPort;
        this.options = options;
    }

    static IOServerType parse(String type, JSONObject typeObj) throws JSONException {
        String connection = typeObj.getString("connection");
        String auth = typeObj.getString("auth");
        int authVal = auth.equals("yes") ? 0 : (auth.equals("password") ? 2 : 1);
        boolean useIP = connection.contains("ip");
        boolean useComm = connection.contains("comm");
        boolean connOptional = connection.contains("?");
        String commType = null;
        if (useComm) {
            commType = typeObj.getString("comm_type");
        }
        String isCommPort = "";
        try {
            isCommPort = typeObj.getString("is_commport");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject obj = typeObj.getJSONObject("options");
        Iterator<String> keys = obj.keys();
        SynchronizedStringHashMap<OptionType> opts = new SynchronizedStringHashMap<OptionType>();
        while (keys.hasNext()) {
            String optionId = keys.next();
            JSONObject optionObj = obj.getJSONObject(optionId);
            OptionType ot = OptionType.parse(optionId, optionObj);
            opts.put(ot.getId(), ot);
        }
        return new IOServerType(type, useIP, useComm, commType, connOptional, authVal, isCommPort.equals("yes"), opts);
    }

    boolean connectionIP() {
        return this.connectionIP;
    }

    boolean connectionComm() {
        return this.connectionComm;
    }

    boolean connectionOptional() {
        return this.connectionOptional;
    }

    boolean hasCommType(String type) {
        return this.commTypes.contains(type);
    }

    List<String> getCommTypes() {
        return this.commTypes;
    }

    int getAuthType() {
        return this.usesAuth;
    }

    boolean isCommPort() {
        return this.isCommPort;
    }

    @Override
    String getListLabel(String list) {
        return this.id;
    }

    boolean checkOptionValue(String optionId, String value) throws InputException {
        OptionType ot = this.options.get(optionId);
        if (ot == null) {
            throw new InputException("unknown option: " + optionId);
        }
        return ot.inputType.equals("select") ? value.toLowerCase().matches(ot.format) || value.toUpperCase().matches(ot.format) : value.matches(ot.format);
    }

    Collection<OptionType> getSortedOptions() {
        return this.options.sortedValues();
    }

    OptionType getOption(String optionId) {
        return this.options.get(optionId);
    }

    static class OptionType
    extends Listable {
        private final String inputType;
        private final String format;
        private final String keyFormat;

        OptionType(String id, String inputType, String format, String keyFormat) {
            super(id);
            this.inputType = inputType;
            this.format = format;
            this.keyFormat = keyFormat;
        }

        static OptionType parse(String optionId, JSONObject optionObj) throws JSONException {
            String inputType = optionObj.getString("type");
            String format = optionObj.getString("format");
            String keyFormat = null;
            if (inputType.equals("input")) {
                keyFormat = optionObj.getString("key_format");
            }
            return new OptionType(optionId, inputType, format, keyFormat);
        }

        @Override
        String getListLabel(String list) {
            return this.id;
        }

        String getInputType() {
            return this.inputType;
        }

        String getFormat() {
            return this.format;
        }

        String getKeyFormat() {
            return this.keyFormat;
        }
    }
}

