/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class Grid
extends Listable {
    private static final int MAX_ROWS = 6;
    private static final int MAX_COLUMNS = 6;
    private String resolution_w;
    private String resolution_h;
    private String remoteRequestPassword;
    private String trustedRequestPassword;
    private Integer columns;
    private Integer rows;
    private String longDeclaration;
    String[][] cams = new String[6][6];

    Grid() throws InputException {
        super("");
        if (Settings.grids.size() >= 99) {
            throw new InputException("Too many camera grids");
        }
        Settings.log(1, "Created Grid");
    }

    @Override
    public String getId() {
        return Integer.toString(Settings.grids.indexOf(this) + 1);
    }

    @Override
    String getListLabel(String list) {
        return "Grid " + this.getId();
    }

    void show(String session) {
        Settings.uiSet("grid.selected", "visible", "true", session);
        Settings.uiSet("cam.selected", "visible", "false", session);
        Settings.uiSet("cam.list", "value", "", session);
        Settings.uiSet("grid.list", "value", this.getId(), session);
        if (this.resolution_w != null && this.resolution_h != null) {
            Settings.uiSet("grid.resolution.w", "value", this.resolution_w, session);
            Settings.uiSet("grid.resolution.h", "value", this.resolution_h, session);
        } else {
            Settings.uiSet("grid.resolution.w", "value", "", session);
            Settings.uiSet("grid.resolution.h", "value", "", session);
        }
        Settings.uiSet("grid.remote", "value", this.remoteRequestPassword == null ? "" : this.remoteRequestPassword, session);
        Settings.uiSet("grid.trusted", "value", this.trustedRequestPassword == null ? "" : this.trustedRequestPassword, session);
        Settings.uiSet("grid.rows", "value", this.rows == null ? "" : "" + this.rows, session);
        Settings.uiSet("grid.cols", "value", this.columns == null ? "" : "" + this.columns, session);
        this.showGrid(session);
    }

    void setResolution(String resolution) throws InputException {
        if (resolution != null) {
            if (resolution.length() == 0) {
                resolution = null;
            } else {
                String[] wh = (resolution = resolution.toLowerCase().replaceAll("\\s+", "")).split("x");
                if (wh.length != 2) {
                    throw new InputException("Illegal resolution for Grid " + this.getId() + ": " + resolution);
                }
                this.setResolutionWidth(wh[0]);
                this.setResolutionHeight(wh[1]);
            }
        }
    }

    void setResolutionWidth(String resolution_w) throws InputException {
        if (resolution_w != null) {
            if (resolution_w.length() == 0) {
                resolution_w = null;
            } else {
                try {
                    Integer.parseInt(resolution_w);
                }
                catch (Exception e2) {
                    throw new InputException("Illegal resolution width for Grid " + this.getId() + ": " + resolution_w);
                }
            }
        }
        this.resolution_w = resolution_w;
        Settings.log(1, "Grid " + this.getId() + " - Resolution width set to: " + this.resolution_w);
    }

    void setResolutionHeight(String resolution_h) throws InputException {
        if (resolution_h != null) {
            if (resolution_h.length() == 0) {
                resolution_h = null;
            } else {
                try {
                    Integer.parseInt(resolution_h);
                }
                catch (Exception e2) {
                    throw new InputException("Illegal resolution height for Grid " + this.getId() + ": " + resolution_h);
                }
            }
        }
        this.resolution_h = resolution_h;
        Settings.log(1, "Grid " + this.getId() + " - Resolution height set to: " + this.resolution_h);
    }

    void setRemoteRequestPassword(String remoteRequestPassword) throws InputException {
        if (remoteRequestPassword != null && remoteRequestPassword.length() == 0) {
            remoteRequestPassword = null;
        }
        this.remoteRequestPassword = remoteRequestPassword;
        Settings.log(1, "Grid " + this.getId() + " - Remote request password set to: " + this.remoteRequestPassword);
    }

    void setTrustedRequestPassword(String trustedRequestPassword) throws InputException {
        if (trustedRequestPassword != null && trustedRequestPassword.length() == 0) {
            trustedRequestPassword = null;
        }
        this.trustedRequestPassword = trustedRequestPassword;
        Settings.log(1, "Grid " + this.getId() + " - Trusted request password set to: " + this.trustedRequestPassword);
    }

    void setCamera(String cam, int r, int c2) throws InputException {
        if (cam != null) {
            if (cam.length() == 0) {
                cam = null;
            } else if (!Settings.cameras.containsKeyIgnoreCase(cam)) {
                throw new InputException("Grid " + this.getId() + " error: Camera '" + cam + "' not defined");
            }
        }
        this.cams[r - 1][c2 - 1] = cam;
    }

    void setRows(String rows, String session) throws InputException {
        int newRows = Integer.parseInt(rows);
        if (this.columns != null && this.columns == 1 && newRows == 1) {
            throw new InputException("Illegal format");
        }
        this.rows = newRows;
        this.longDeclaration = null;
        this.showGrid(session);
    }

    void setColumns(String columns, String session) throws InputException {
        int newCols = Integer.parseInt(columns);
        if (this.rows != null && this.rows == 1 && newCols == 1) {
            throw new InputException("Illegal format");
        }
        this.columns = newCols;
        this.longDeclaration = null;
        this.showGrid(session);
    }

    private void showGrid(String session) {
        if (this.longDeclaration == null) {
            Settings.uiSet("grid.definition", "visible", "false", session);
            if (this.columns != null && this.rows != null) {
                Settings.uiSet("grid.grid", "visible", "true", session);
                int r = 1;
                while (r <= 6) {
                    int c2 = 1;
                    while (c2 <= 6) {
                        if (c2 <= this.columns && r <= this.rows) {
                            Settings.uiSet("grid.cam" + r + c2, "visible", "true", session);
                            if (this.cams[r - 1][c2 - 1] != null) {
                                Settings.uiSet("grid.cam" + r + c2, "value", this.cams[r - 1][c2 - 1], session);
                            } else {
                                Settings.uiSet("grid.cam" + r + c2, "value", "", session);
                            }
                        } else {
                            Settings.uiSet("grid.cam" + r + c2, "visible", "false", session);
                        }
                        ++c2;
                    }
                    ++r;
                }
            } else {
                Settings.uiSet("grid.grid", "visible", "false", session);
            }
        } else {
            Settings.uiSet("grid.definition", "visible", "true", session);
            Settings.uiSet("grid.definition", "value", this.longDeclaration, session);
            Settings.uiSet("grid.grid", "visible", "false", session);
        }
    }

    void setCameras(String gridDeclaration) {
        String[] rows = gridDeclaration.split(",");
        this.rows = rows.length;
        int r = 0;
        while (r < rows.length) {
            String row = rows[r].trim();
            String[] cams = row.split("\\s+");
            if (this.columns == null || this.columns < cams.length) {
                this.columns = cams.length;
            }
            int c2 = 0;
            while (c2 < cams.length) {
                block7: {
                    String cam = cams[c2];
                    if (cam.equals("empty")) {
                        cam = null;
                    }
                    try {
                        this.setCamera(cam, r + 1, c2 + 1);
                    }
                    catch (InputException inputException) {
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        if (this.longDeclaration != null) break block7;
                        this.longDeclaration = gridDeclaration.trim().replaceAll("\\s+", " ").replace(" ,", ",");
                        if (!this.longDeclaration.endsWith(",")) break block7;
                        this.longDeclaration = this.longDeclaration.substring(0, this.longDeclaration.length() - 1);
                    }
                }
                ++c2;
            }
            ++r;
        }
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        String id = this.getId();
        if (bw != null) {
            bw.write("CameraGrid." + id);
            bw.write(" = ");
        }
        if (this.longDeclaration == null) {
            if (this.rows != null && this.columns != null && this.rows == 1 && this.columns == 1) {
                new Error("Grid '" + this.getId() + "' - Set at least two cameras", this);
            }
            boolean ok = false;
            if (this.rows != null && this.columns != null) {
                int r = 0;
                while (r < this.rows) {
                    int c2 = 0;
                    while (c2 < this.columns) {
                        if (this.cams[r][c2] != null) {
                            ok = true;
                            if (bw != null) {
                                bw.write(this.cams[r][c2]);
                            }
                        } else if (bw != null) {
                            bw.write("empty");
                        }
                        if (c2 != this.columns - 1 && bw != null) {
                            bw.write(" ");
                        }
                        ++c2;
                    }
                    if (r != this.rows - 1 && bw != null) {
                        bw.write(", ");
                    }
                    ++r;
                }
                if (bw != null) {
                    bw.write("\n");
                }
            }
            if (!ok) {
                new Error("Grid '" + this.getId() + "' - No camera set", this);
            }
        } else if (bw != null) {
            bw.write(this.longDeclaration);
            bw.write("\n");
        }
        if (this.resolution_h != null && this.resolution_w != null && bw != null) {
            bw.write("CameraGrid." + id + ".Resolution");
            bw.write(" = ");
            bw.write(this.resolution_w);
            bw.write("x");
            bw.write(this.resolution_h);
            bw.write("\n");
        }
        if (this.remoteRequestPassword != null && bw != null) {
            bw.write("CameraGrid." + id + ".RemoteRequestPassword");
            bw.write(" = ");
            bw.write(this.remoteRequestPassword);
            bw.write("\n");
        }
        if (this.trustedRequestPassword != null && bw != null) {
            bw.write("CameraGrid." + id + ".TrustedRequestPassword");
            bw.write(" = ");
            bw.write(this.trustedRequestPassword);
            bw.write("\n");
        }
    }
}

