/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import org.json.JSONException;
import org.json.JSONObject;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

class Field
extends Listable {
    protected final String format;
    protected final String keyFormat;
    protected String value;

    Field(String id, String defaultValue, String format, String keyFormat) throws InputException {
        super(id);
        this.format = format;
        this.keyFormat = keyFormat;
        if (defaultValue != null) {
            this.setValue(defaultValue);
        } else {
            Settings.uiSet(this.id, "value", "");
        }
    }

    static Field parse(String id, JSONObject fieldObj, JSONObject regexObj) throws Exception {
        int sharpClose;
        String fieldDefault = fieldObj.getString("default");
        String fieldFormat = fieldObj.getString("format");
        int sharpOpen = fieldFormat.indexOf(35);
        if (sharpOpen >= 0 && (sharpClose = fieldFormat.indexOf(35, sharpOpen + 1)) > sharpOpen) {
            String placeHolder = fieldFormat.substring(sharpOpen + 1, sharpClose);
            try {
                String regex = regexObj.getString(placeHolder);
                fieldFormat = fieldFormat.replace("#" + placeHolder + "#", regex);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        String fieldKeyFormat = null;
        try {
            fieldKeyFormat = fieldObj.getString("key_format");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new Field(id, fieldDefault, fieldFormat, fieldKeyFormat);
    }

    String getValue() {
        return this.value;
    }

    String getFormat() {
        return this.format;
    }

    String getKeyFormat() {
        return this.keyFormat;
    }

    void setValue(String value) throws InputException {
        if (this.format == null || value.matches(this.format)) {
            if (!value.equals(this.value)) {
                this.value = value;
                Settings.log(1, "Field '" + this.id + "' set to: " + this.value);
            }
        } else {
            throw new InputException("Illegal value for field '" + this.id + "': " + value);
        }
        Settings.uiSet(this.id, "value", this.value);
    }

    @Override
    String getListLabel(String list) {
        return String.valueOf(this.id) + " = " + this.value;
    }
}

