/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import com.hsyco.DataLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class DLogger
extends Listable {
    private static final String ID_REGEX = "[a-zA-Z0-9\\.]+";
    private final String type;
    private String decimals;
    private String resolution;
    private String varSet;
    private String hourInterval;
    private String daysBeforeDelete;
    private String daysBeforeMonthConsolidation;
    private String daysBeforeDayConsolidation;
    private String daysBeforeHourConsolidation;
    private String hourConsolidationFactor;
    private String upperLimit;
    private String maxDelta;
    private String ratesLogFile;
    private String separateCharts;
    private String slotAlign;
    private String range;
    private String origin;
    private String outOfRangeMode;
    private boolean enabled = true;

    DLogger(String id, String type, boolean check) throws InputException {
        super(id);
        if (check && !id.matches(ID_REGEX)) {
            throw new InputException("Illegal DataLogger ID: " + id);
        }
        this.type = type;
        Settings.log(1, "Created DataLogger '" + this.id + "', type '" + this.type + "'");
    }

    @Override
    String getListLabel(String list) {
        String lbl = String.valueOf(this.type) + " - " + this.id;
        if (this.enabled) {
            return lbl;
        }
        return "<div style=\"color:#A0A0A0\">" + lbl + "</div>";
    }

    void show(String session) {
        Settings.uiSet("dlog.list", "value", this.id, session);
        Settings.uiSet("dlog.selected", "visible", "true", session);
        Settings.uiSet("dlog.enabled", "value", Boolean.toString(this.enabled), session);
        Settings.uiSet("dlog.decimals", "value", this.decimals == null ? "1" : this.decimals, session);
        Settings.uiSet("dlog.resolution", "value", this.resolution == null ? "hour" : this.resolution, session);
        Settings.uiSet("dlog.varset", "value", this.varSet == null ? "false" : this.varSet, session);
        Settings.uiSet("dlog.hourinterval", "value", this.hourInterval == null ? "1" : this.hourInterval, session);
        Settings.uiSet("dlog.daysbeforedelete", "value", this.daysBeforeDelete == null ? "" : this.daysBeforeDelete, session);
        Settings.uiSet("dlog.daysbeforemonthconsolidation", "value", this.daysBeforeMonthConsolidation == null ? "" : this.daysBeforeMonthConsolidation, session);
        Settings.uiSet("dlog.daysbeforedayconsolidation", "value", this.daysBeforeDayConsolidation == null ? "" : this.daysBeforeDayConsolidation, session);
        Settings.uiSet("dlog.daysbeforehourconsolidation", "value", this.daysBeforeHourConsolidation == null ? "" : this.daysBeforeHourConsolidation, session);
        Settings.uiSet("dlog.hourconsolidationfactor", "value", this.hourConsolidationFactor == null ? "" : this.hourConsolidationFactor, session);
        if (this.type != null) {
            if (this.type.equals("counter")) {
                Settings.uiSet("dlog.opt.counter", "visible", "true", session);
                Settings.uiSet("dlog.opt.range", "visible", "false", session);
                if (this.upperLimit != null) {
                    Settings.uiSet("dlog.upperlimit.use", "value", "true", session);
                    Settings.uiSet("dlog.upperlimit", "enabled", "true", session);
                    Settings.uiSet("dlog.upperlimit", "value", this.upperLimit, session);
                } else {
                    Settings.uiSet("dlog.upperlimit.use", "value", "false", session);
                    Settings.uiSet("dlog.upperlimit", "enabled", "false", session);
                    Settings.uiSet("dlog.upperlimit", "value", "", session);
                }
                if (this.maxDelta != null) {
                    Settings.uiSet("dlog.maxdelta.use", "value", "true", session);
                    Settings.uiSet("dlog.maxdelta", "enabled", "true", session);
                    Settings.uiSet("dlog.maxdelta", "value", this.maxDelta, session);
                } else {
                    Settings.uiSet("dlog.maxdelta.use", "value", "false", session);
                    Settings.uiSet("dlog.maxdelta", "enabled", "false", session);
                    Settings.uiSet("dlog.maxdelta", "value", "", session);
                }
                Settings.uiSet("dlog.separatecharts", "value", this.separateCharts == null ? "false" : this.separateCharts, session);
                Settings.uiSet("dlog.slotalign", "value", this.slotAlign == null ? "true" : this.slotAlign, session);
                if (this.ratesLogFile != null) {
                    Settings.uiSet("dlog.rateslogfile.use", "value", "true", session);
                    Settings.uiSet("dlog.rateslogfile", "enabled", "true", session);
                    Settings.uiSet("dlog.rateslogfile", "value", this.ratesLogFile, session);
                } else {
                    Settings.uiSet("dlog.rateslogfile.use", "value", "false", session);
                    Settings.uiSet("dlog.rateslogfile", "enabled", "false", session);
                    Settings.uiSet("dlog.rateslogfile", "value", "", session);
                }
            } else {
                Settings.uiSet("dlog.opt.counter", "visible", "false", session);
                Settings.uiSet("dlog.opt.range", "visible", "true", session);
                if (this.origin != null) {
                    Settings.uiSet("dlog.origin.use", "value", "true", session);
                    Settings.uiSet("dlog.origin", "enabled", "true", session);
                    Settings.uiSet("dlog.origin", "value", this.origin, session);
                } else {
                    Settings.uiSet("dlog.origin.use", "value", "false", session);
                    Settings.uiSet("dlog.origin", "enabled", "false", session);
                    Settings.uiSet("dlog.origin", "value", "", session);
                }
                if (this.range != null) {
                    Settings.uiSet("dlog.range.use", "value", "true", session);
                    Settings.uiSet("dlog.range", "enabled", "true", session);
                    Settings.uiSet("dlog.range", "value", this.range, session);
                    if (this.range.indexOf(33) >= 0) {
                        Settings.uiSet("dlog.outofrangemode", "value", this.outOfRangeMode == null ? "cut" : this.outOfRangeMode, session);
                        Settings.uiSet("dlog.outofrangemode", "enabled", "true", session);
                        Settings.uiSet("dlog.outofrangemode.label", "opacity", "1", session);
                    } else {
                        Settings.uiSet("dlog.outofrangemode", "value", "", session);
                        Settings.uiSet("dlog.outofrangemode", "enabled", "false", session);
                        Settings.uiSet("dlog.outofrangemode.label", "opacity", "0.5", session);
                    }
                } else {
                    Settings.uiSet("dlog.range.use", "value", "false", session);
                    Settings.uiSet("dlog.range", "enabled", "false", session);
                    Settings.uiSet("dlog.range", "value", "", session);
                    Settings.uiSet("dlog.outofrangemode", "value", "", session);
                    Settings.uiSet("dlog.outofrangemode", "enabled", "false", session);
                    Settings.uiSet("dlog.outofrangemode.label", "opacity", "0.5", session);
                }
            }
        }
    }

    void setDecimals(String decimals) throws InputException {
        if (decimals != null) {
            if (decimals.equals("")) {
                decimals = null;
            } else {
                try {
                    Integer.parseInt(decimals);
                }
                catch (Exception e2) {
                    throw new InputException("Illegal decimals value for DataLogger '" + this.id + "': " + decimals);
                }
            }
        }
        this.decimals = decimals;
        Settings.log(1, "DataLogger '" + this.id + "' - decimals set to: " + this.decimals);
    }

    void setVarSet(String varSet) throws InputException {
        if (varSet != null) {
            if (varSet.equals("")) {
                varSet = null;
            } else if (!varSet.equals("true") && !varSet.equals("false")) {
                throw new InputException("Illegal varSet value for DataLogger '" + this.id + "': " + varSet);
            }
        }
        this.varSet = varSet;
        Settings.log(1, "DataLogger '" + this.id + "' - varSet set to: " + this.varSet);
    }

    void setResolution(String resolution) throws InputException {
        if (resolution != null) {
            if (resolution.equals("")) {
                resolution = null;
            } else if (!(resolution.equals("month") || resolution.equals("day") || resolution.equals("hour") || resolution.equals("minute"))) {
                throw new InputException("Illegal resolution value for DataLogger '" + this.id + "': " + resolution);
            }
        }
        this.resolution = resolution;
        Settings.log(1, "DataLogger '" + this.id + "' - resolution set to: " + this.resolution);
    }

    void setHourInterval(String hourInterval) throws InputException {
        if (hourInterval != null) {
            if (hourInterval.equals("")) {
                hourInterval = null;
            } else {
                try {
                    int hi = Integer.parseInt(hourInterval);
                    if (hi <= 0 || 24 % hi != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal hourInterval value for DataLogger '" + this.id + "': " + hourInterval);
                }
            }
        }
        this.hourInterval = hourInterval;
        Settings.log(1, "DataLogger '" + this.id + "' - hourInterval set to: " + this.hourInterval);
    }

    void setDaysBeforeDelete(String daysBeforeDelete) throws InputException {
        if (daysBeforeDelete != null) {
            if (daysBeforeDelete.equals("")) {
                daysBeforeDelete = null;
            } else {
                try {
                    int d2 = Integer.parseInt(daysBeforeDelete);
                    if (d2 < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal daysBeforeDelete value for DataLogger '" + this.id + "': " + daysBeforeDelete);
                }
            }
        }
        this.daysBeforeDelete = daysBeforeDelete;
        Settings.log(1, "DataLogger '" + this.id + "' - daysBeforeDelete set to: " + this.daysBeforeDelete);
    }

    void setDaysBeforeMonthConsolidation(String daysBeforeMonthConsolidation) throws InputException {
        if (daysBeforeMonthConsolidation != null) {
            if (daysBeforeMonthConsolidation.equals("")) {
                daysBeforeMonthConsolidation = null;
            } else {
                try {
                    int d2 = Integer.parseInt(daysBeforeMonthConsolidation);
                    if (d2 < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal daysBeforeMonthConsolidation value for DataLogger '" + this.id + "': " + daysBeforeMonthConsolidation);
                }
            }
        }
        this.daysBeforeMonthConsolidation = daysBeforeMonthConsolidation;
        Settings.log(1, "DataLogger '" + this.id + "' - daysBeforeMonthConsolidation set to: " + this.daysBeforeMonthConsolidation);
    }

    void setDaysBeforeDayConsolidation(String daysBeforeDayConsolidation) throws InputException {
        if (daysBeforeDayConsolidation != null) {
            if (daysBeforeDayConsolidation.equals("")) {
                daysBeforeDayConsolidation = null;
            } else {
                try {
                    int d2 = Integer.parseInt(daysBeforeDayConsolidation);
                    if (d2 < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal daysBeforeDayConsolidation value for DataLogger '" + this.id + "': " + daysBeforeDayConsolidation);
                }
            }
        }
        this.daysBeforeDayConsolidation = daysBeforeDayConsolidation;
        Settings.log(1, "DataLogger '" + this.id + "' - daysBeforeDayConsolidation set to: " + this.daysBeforeDayConsolidation);
    }

    void setDaysBeforeHourConsolidation(String daysBeforeHourConsolidation) throws InputException {
        if (daysBeforeHourConsolidation != null) {
            if (daysBeforeHourConsolidation.equals("")) {
                daysBeforeHourConsolidation = null;
            } else {
                try {
                    int d2 = Integer.parseInt(daysBeforeHourConsolidation);
                    if (d2 < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal daysBeforeHourConsolidation value for DataLogger '" + this.id + "': " + daysBeforeHourConsolidation);
                }
            }
        }
        this.daysBeforeHourConsolidation = daysBeforeHourConsolidation;
        Settings.log(1, "DataLogger '" + this.id + "' - daysBeforeHourConsolidation set to: " + this.daysBeforeHourConsolidation);
    }

    void setHourConsolidationFactor(String hourConsolidationFactor) throws InputException {
        if (hourConsolidationFactor != null) {
            if (hourConsolidationFactor.equals("")) {
                hourConsolidationFactor = null;
            } else {
                try {
                    int d2 = Integer.parseInt(hourConsolidationFactor);
                    if (d2 < 1 || d2 >= 60 || 60 % d2 != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal hourConsolidationFactor value for DataLogger '" + this.id + "': " + hourConsolidationFactor);
                }
            }
        }
        this.hourConsolidationFactor = hourConsolidationFactor;
        Settings.log(1, "DataLogger '" + this.id + "' - hourConsolidationFactor set to: " + this.hourConsolidationFactor);
    }

    void setUpperLimit(String upperLimit) throws InputException {
        if (upperLimit != null) {
            if (upperLimit.equals("")) {
                upperLimit = null;
            } else {
                try {
                    double d2 = Double.parseDouble(upperLimit);
                    if (d2 < 0.0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal upperLimit value for DataLogger '" + this.id + "': " + upperLimit);
                }
            }
        }
        this.upperLimit = upperLimit;
        Settings.log(1, "DataLogger '" + this.id + "' - upperLimit set to: " + this.upperLimit);
    }

    void setMaxDelta(String maxDelta) throws InputException {
        if (maxDelta != null) {
            if (maxDelta.equals("")) {
                maxDelta = null;
            } else {
                try {
                    double d2 = Double.parseDouble(maxDelta);
                    if (d2 <= 0.0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal maxDelta value for DataLogger '" + this.id + "': " + maxDelta);
                }
            }
        }
        this.maxDelta = maxDelta;
        Settings.log(1, "DataLogger '" + this.id + "' - maxDelta set to: " + this.maxDelta);
    }

    void setSeparateCharts(String separateCharts) throws InputException {
        if (separateCharts != null) {
            if (separateCharts.equals("")) {
                separateCharts = null;
            } else if (!separateCharts.equals("true") && !separateCharts.equals("false")) {
                throw new InputException("Illegal separateCharts value for DataLogger '" + this.id + "': " + separateCharts);
            }
        }
        this.separateCharts = separateCharts;
        Settings.log(1, "DataLogger '" + this.id + "' - separateCharts set to: " + this.separateCharts);
    }

    void setSlotAlign(String slotAlign) throws InputException {
        if (slotAlign != null) {
            if (slotAlign.equals("")) {
                slotAlign = null;
            } else if (!slotAlign.equals("true") && !slotAlign.equals("false")) {
                throw new InputException("Illegal slotAlign value for DataLogger '" + this.id + "': " + slotAlign);
            }
        }
        this.slotAlign = slotAlign;
        Settings.log(1, "DataLogger '" + this.id + "' - slotAlign set to: " + this.slotAlign);
    }

    void setRatesLogFile(String ratesLogFile) throws InputException {
        if (ratesLogFile != null && ratesLogFile.equals("")) {
            ratesLogFile = null;
        }
        this.ratesLogFile = ratesLogFile;
        Settings.log(1, "DataLogger '" + this.id + "' - ratesLogFile set to: " + this.ratesLogFile);
    }

    void setOrigin(String origin) throws InputException {
        if (origin != null) {
            if (origin.equals("")) {
                origin = null;
            } else {
                try {
                    Double.parseDouble(origin);
                }
                catch (Exception e2) {
                    throw new InputException("Illegal origin value for DataLogger '" + this.id + "': " + origin);
                }
            }
        }
        this.origin = origin;
        Settings.log(1, "DataLogger '" + this.id + "' - origin set to: " + this.origin);
    }

    void setRange(String range) throws InputException {
        if (range != null) {
            if (range.equals("")) {
                range = null;
            } else if (!range.matches("[-|+]?\\d+(\\.\\d+)?(!)?:[-|+]?\\d+(\\.\\d+)?(!)?")) {
                throw new InputException("Illegal range value for DataLogger '" + this.id + "': " + range);
            }
        }
        this.range = range;
        Settings.log(1, "DataLogger '" + this.id + "' - range set to: " + this.range);
    }

    void setOutOfRangeMode(String outOfRangeMode) throws InputException {
        if (outOfRangeMode != null) {
            if (outOfRangeMode.equals("")) {
                outOfRangeMode = null;
            } else if (!outOfRangeMode.equals("cut") && !outOfRangeMode.equals("ignore")) {
                throw new InputException("Illegal outOfRangeMode value for DataLogger '" + this.id + "': " + outOfRangeMode);
            }
        }
        this.outOfRangeMode = outOfRangeMode;
        Settings.log(1, "DataLogger '" + this.id + "' - outOfRangeMode set to: " + this.outOfRangeMode);
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if (this.type == null) {
            new Error("Data Logger '" + this.id + "' - Type not specified. Remove this Data Logger", this);
            return;
        }
        if (!this.type.equals("counter") && !this.type.equals("range")) {
            new Error("Data Logger '" + this.id + "' - Type not valid. Remove this Data Logger", this);
            return;
        }
        if (bw != null) {
            bw.write("DataLoggers." + this.id + ".Type");
            bw.write(" = ");
            bw.write(this.type);
            bw.write("\n");
            if (this.decimals != null) {
                bw.write("DataLoggers." + this.id + ".Decimals");
                bw.write(" = ");
                bw.write(this.decimals);
                bw.write("\n");
            }
            if (this.resolution != null) {
                bw.write("DataLoggers." + this.id + ".Resolution");
                bw.write(" = ");
                bw.write(this.resolution);
                bw.write("\n");
            }
            if (this.varSet != null) {
                bw.write("DataLoggers." + this.id + ".VarSet");
                bw.write(" = ");
                bw.write(this.varSet);
                bw.write("\n");
            }
            if (this.hourInterval != null) {
                bw.write("DataLoggers." + this.id + ".HourInterval");
                bw.write(" = ");
                bw.write(this.hourInterval);
                bw.write("\n");
            }
            if (this.daysBeforeDelete != null) {
                bw.write("DataLoggers." + this.id + ".DaysBeforeDelete");
                bw.write(" = ");
                bw.write(this.daysBeforeDelete);
                bw.write("\n");
            }
            if (this.daysBeforeMonthConsolidation != null) {
                bw.write("DataLoggers." + this.id + ".DaysBeforeMonthConsolidation");
                bw.write(" = ");
                bw.write(this.daysBeforeMonthConsolidation);
                bw.write("\n");
            }
            if (this.daysBeforeDayConsolidation != null) {
                bw.write("DataLoggers." + this.id + ".DaysBeforeDayConsolidation");
                bw.write(" = ");
                bw.write(this.daysBeforeDayConsolidation);
                bw.write("\n");
            }
            if (this.daysBeforeHourConsolidation != null) {
                bw.write("DataLoggers." + this.id + ".DaysBeforeHourConsolidation");
                bw.write(" = ");
                bw.write(this.daysBeforeHourConsolidation);
                bw.write("\n");
            }
            if (this.hourConsolidationFactor != null) {
                bw.write("DataLoggers." + this.id + ".HourConsolidationFactor");
                bw.write(" = ");
                bw.write(this.hourConsolidationFactor);
                bw.write("\n");
            }
            if (this.type.equals("counter")) {
                if (this.upperLimit != null) {
                    bw.write("DataLoggers." + this.id + ".CounterUpperLimit");
                    bw.write(" = ");
                    bw.write(this.upperLimit);
                    bw.write("\n");
                }
                if (this.maxDelta != null) {
                    bw.write("DataLoggers." + this.id + ".CounterMaxDelta");
                    bw.write(" = ");
                    bw.write(this.maxDelta);
                    bw.write("\n");
                }
                if (this.separateCharts != null) {
                    bw.write("DataLoggers." + this.id + ".SeparateCharts");
                    bw.write(" = ");
                    bw.write(this.separateCharts);
                    bw.write("\n");
                }
                if (this.slotAlign != null) {
                    bw.write("DataLoggers." + this.id + ".SlotAlign");
                    bw.write(" = ");
                    bw.write(this.slotAlign);
                    bw.write("\n");
                }
                if (this.ratesLogFile != null) {
                    bw.write("DataLoggers." + this.id + ".RatesLogFile");
                    bw.write(" = ");
                    bw.write(this.ratesLogFile);
                    bw.write("\n");
                }
            } else {
                if (this.origin != null) {
                    bw.write("DataLoggers." + this.id + ".Origin");
                    bw.write(" = ");
                    bw.write(this.origin);
                    bw.write("\n");
                }
                if (this.range != null) {
                    bw.write("DataLoggers." + this.id + ".Range");
                    bw.write(" = ");
                    bw.write(this.range);
                    bw.write("\n");
                    if (this.outOfRangeMode != null) {
                        bw.write("DataLoggers." + this.id + ".OutOfRangeMode");
                        bw.write(" = ");
                        bw.write(this.outOfRangeMode);
                        bw.write("\n");
                    }
                }
            }
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    static void restoreFromBackup(String backupDirectory, boolean overwrite) throws Exception {
        Connection dbConnection;
        Connection backupdDbConnection;
        if (backupDirectory.length() == 0) {
            throw new Exception("Backup folder not specified");
        }
        if (backupDirectory.equals("data")) {
            throw new Exception("The folder 'data' contains HSYCO's database");
        }
        File dir = new File(backupDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new Exception("Database backup folder not found: " + backupDirectory);
        }
        try {
            backupdDbConnection = DriverManager.getConnection("jdbc:hsqldb:file:" + backupDirectory + "/hsyco;hsqldb.write_delay_millis=100", "hsyco", "9h6s2y5c17o");
        }
        catch (Exception e2) {
            throw new Exception("Coudn't connect to backup database", e2);
        }
        try {
            dbConnection = Settings.getHsycoDBConnection();
        }
        catch (Exception e3) {
            throw new Exception("Coudn't connect to hsyco database", e3);
        }
        Settings.log(3, "Starting data loggers backup restore...");
        ResultSet rs = null;
        Statement backupDbStmt = null;
        Statement dbStmt = null;
        try {
            try {
                backupDbStmt = backupdDbConnection.createStatement();
                dbStmt = dbConnection.createStatement();
                for (DLogger dl : Settings.dLoggers.values()) {
                    if (dl.isEnabled()) {
                        long ts;
                        int progr;
                        int tot;
                        Settings.uiSet("dlog.bckp_restore_dl", "value", dl.id);
                        Settings.uiSet("dlog.bckp_restore_progr", "value", "0");
                        if (dl.type.equals("counter")) {
                            rs = backupDbStmt.executeQuery("select count(*) from dl_counter where id = '" + dl.id + "'");
                            rs.next();
                            tot = rs.getInt(1);
                            rs.close();
                            rs = backupDbStmt.executeQuery("select * from dl_counter where id = '" + dl.id + "'");
                            progr = 0;
                            while (rs.next()) {
                                block44: {
                                    ts = rs.getLong("ts");
                                    Double delta = rs.getDouble("delta");
                                    if (rs.wasNull()) {
                                        delta = null;
                                    }
                                    Double cost = rs.getDouble("cost");
                                    if (rs.wasNull()) {
                                        cost = null;
                                    }
                                    boolean locked = rs.getBoolean("locked");
                                    int count = 0;
                                    if (overwrite) {
                                        count = dbStmt.executeUpdate("update dl_counter set delta = " + (delta == null ? "null" : delta) + ", cost = " + (cost == null ? "null" : cost) + ", locked = " + locked + " where id = '" + dl.id + "'" + " and ts = " + ts);
                                    }
                                    if (count == 0) {
                                        try {
                                            dbStmt.executeUpdate("insert into dl_counter (id, ts, delta, cost, locked) values ('" + dl.id + "'," + ts + "," + (delta == null ? "null" : delta) + "," + (cost == null ? "null" : cost) + "," + locked + ")");
                                        }
                                        catch (SQLIntegrityConstraintViolationException e4) {
                                            if (!overwrite) break block44;
                                            throw e4;
                                        }
                                    }
                                }
                                if (++progr % 50 != 0) continue;
                                Settings.uiSet("dlog.bckp_restore_progr", "value", "" + progr * 100 / tot);
                            }
                        } else {
                            rs = backupDbStmt.executeQuery("select count(*) from dl_range where id = '" + dl.id + "'");
                            rs.next();
                            tot = rs.getInt(1);
                            rs.close();
                            rs = backupDbStmt.executeQuery("select * from dl_range where id = '" + dl.id + "'");
                            progr = 0;
                            while (rs.next()) {
                                block45: {
                                    ts = rs.getLong("ts");
                                    double vmin = rs.getDouble("vmin");
                                    double vmax = rs.getDouble("vmax");
                                    double vavg = rs.getDouble("vavg");
                                    int vcount = rs.getInt("vcount");
                                    int count = 0;
                                    if (overwrite) {
                                        count = dbStmt.executeUpdate("update dl_range set vmin = " + vmin + ", vmax = " + vmax + ", vavg = " + vavg + ", vcount = " + vcount + " where id = '" + dl.id + "'" + " and ts = " + ts);
                                    }
                                    if (count == 0) {
                                        try {
                                            dbStmt.executeUpdate("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values ('" + dl.id + "', " + ts + ", " + vmin + ", " + vmax + ", " + vavg + ", " + vcount + ")");
                                        }
                                        catch (SQLIntegrityConstraintViolationException e5) {
                                            if (!overwrite) break block45;
                                            throw e5;
                                        }
                                    }
                                }
                                if (++progr % 50 != 0) continue;
                                Settings.uiSet("dlog.bckp_restore_progr", "value", "" + progr * 100 / tot);
                            }
                        }
                    }
                    rs.close();
                }
                DataLogger.resetFirstDBEntryDates();
                Settings.log(3, "Data loggers restored");
            }
            catch (Exception e6) {
                Settings.log(0, "Error restoring data from database backup: " + e6.getLocalizedMessage());
                throw new Exception("Error restoring data from database backup: " + e6.getLocalizedMessage(), e6);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                backupDbStmt.close();
            }
            catch (Exception exception) {}
            try {
                dbStmt.close();
            }
            catch (Exception exception) {}
            try {
                backupdDbConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    static void showSizes() throws Exception {
        Connection dbConnection;
        try {
            dbConnection = Settings.getHsycoDBConnection();
        }
        catch (Exception e2) {
            throw new Exception("Coudn't connect to hsyco database", e2);
        }
        ResultSet rs = null;
        Statement dbStmt = null;
        try {
            long count;
            dbStmt = dbConnection.createStatement();
            StringBuilder table = new StringBuilder("<table style=\"width:100%; border-collapse:collapse;\">");
            table.append("<tr bgcolor=\"#B8B8B8\" style=\"font-weight:bold;\"><td>Type</td><td>ID</td><td style=\"text-align:center\">Rows</td></tr>");
            rs = dbStmt.executeQuery("select ID, count(*) from dl_counter group by ID");
            long tot = 0L;
            boolean bg = true;
            while (rs.next()) {
                table.append("<tr");
                if (bg = !bg) {
                    table.append(" bgcolor=\"#D0D0D0\"");
                }
                table.append("><td>counter</td><td>");
                table.append(rs.getString(1));
                table.append("</td><td style=\"text-align:right\">");
                count = rs.getLong(2);
                table.append(count);
                table.append("&nbsp;</td></tr>");
                tot += count;
            }
            rs.close();
            rs = dbStmt.executeQuery("select ID, count(*) from dl_range group by ID");
            while (rs.next()) {
                table.append("<tr");
                if (bg = !bg) {
                    table.append(" bgcolor=\"#D0D0D0\"");
                }
                table.append("><td>range</td><td>");
                table.append(rs.getString(1));
                table.append("</td><td style=\"text-align:right\">");
                count = rs.getLong(2);
                table.append(count);
                table.append("&nbsp;</td></tr>");
                tot += count;
            }
            table.append("<tr bgcolor=\"#B8B8B8\" style=\"font-weight: bold;\"");
            table.append("><td colspan=\"2\">Total</td><td style=\"text-align:right\">");
            table.append(tot);
            table.append("&nbsp;</td></tr>");
            Settings.uiSet("dlog.sizes", "value", table.toString());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
        }
    }
}

