/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class Camera
extends Listable {
    private String url;
    private String urlSmall;
    private String ptz;
    private String type;
    private String io;
    private String user;
    private String password;
    private String droppedFrames;
    private String maxAge;
    private String motionBuffer;
    private String remoteRequestPassword;
    private String trustedRequestPassword;
    private String rotate;
    private boolean enabled = true;

    Camera(String id, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal Camera ID: " + id);
        }
        Settings.log(1, "Created Camera '" + this.id + "'");
    }

    @Override
    String getListLabel(String list) {
        if (list.startsWith("grid.")) {
            if (this.enabled) {
                return this.id;
            }
            return null;
        }
        if (this.enabled) {
            return this.id;
        }
        return "<div style=\"color:#A0A0A0\">" + this.id + "</div>";
    }

    void show(String session) {
        Settings.uiSet("cam.selected", "visible", "true", session);
        Settings.uiSet("grid.selected", "visible", "false", session);
        Settings.uiSet("grid.list", "value", "", session);
        Settings.uiSet("cam.enabled", "value", Boolean.toString(this.enabled), session);
        Settings.uiSet("cam.list", "value", this.id, session);
        Settings.uiSet("cam.url", "value", this.url == null ? "" : this.url, session);
        Settings.uiSet("cam.urlsmall", "value", this.urlSmall == null ? "" : this.urlSmall, session);
        Settings.uiSet("cam.ptz", "value", this.ptz == null ? "" : this.ptz, session);
        Settings.uiSet("cam.type", "value", this.type == null ? "" : this.type, session);
        Settings.uiSet("cam.io", "value", this.io == null ? "" : this.io, session);
        Settings.uiSet("cam.user", "value", this.user == null ? "" : this.user, session);
        Settings.uiSet("cam.password", "value", this.password == null ? "" : this.password, session);
        Settings.uiSet("cam.dropped", "value", this.droppedFrames == null ? "" : this.droppedFrames, session);
        Settings.uiSet("cam.maxage", "value", this.maxAge == null ? "" : this.maxAge, session);
        Settings.uiSet("cam.buffer", "value", this.motionBuffer == null ? "" : this.motionBuffer, session);
        Settings.uiSet("cam.remote", "value", this.remoteRequestPassword == null ? "" : this.remoteRequestPassword, session);
        Settings.uiSet("cam.trusted", "value", this.trustedRequestPassword == null ? "" : this.trustedRequestPassword, session);
        Settings.uiSet("cam.rotate", "value", this.rotate == null ? "" : this.rotate, session);
    }

    void setURL(String url) throws InputException {
        if (url == null || url.length() == 0) {
            throw new InputException("Illegal URL for Camera '" + this.id + "': " + url);
        }
        this.url = url;
        Settings.log(1, "Camera '" + this.id + "' - URL set to: " + this.url);
    }

    void setURLSmall(String urlSmall) throws InputException {
        if (urlSmall != null && urlSmall.length() == 0) {
            urlSmall = null;
        }
        this.urlSmall = urlSmall;
        Settings.log(1, "Camera '" + this.id + "' - URL Small set to: " + this.urlSmall);
    }

    void setPTZ(String ptz) throws InputException {
        if (ptz != null) {
            if (ptz.length() == 0) {
                ptz = null;
            } else if (!(ptz.equals("axis") || ptz.equals("axis") || ptz.equals("axis-vptz") || ptz.equals("panasonic") || ptz.equals("panasonic-wv") || ptz.equals("mobotix") || ptz.equals("rovio") || ptz.equals("SNV-3120") || ptz.equals("SNP-3120") || ptz.equals("SNP-3120V") || ptz.equals("SNP-3120H") || ptz.equals("vptz") || ptz.equals("user"))) {
                throw new InputException("Illegal PTZ for Camera '" + this.id + "': " + ptz);
            }
        }
        this.ptz = ptz;
        Settings.log(1, "Camera '" + this.id + "' - PTZ set to: " + this.ptz);
    }

    void setType(String type) throws InputException {
        if (type != null && type.length() == 0) {
            type = null;
        }
        this.type = type;
        Settings.log(1, "Camera '" + this.id + "' - type set to: " + this.type);
    }

    void setIO(String io) throws InputException {
        if (io != null) {
            if (io.length() == 0) {
                io = null;
            } else if (!(io.equals("enabled") || io.equals("enabled:io") || io.equals("enabled:va"))) {
                throw new InputException("Illegal IO for Camera '" + this.id + "': " + io);
            }
        }
        this.io = io;
        Settings.log(1, "Camera '" + this.id + "' - IO set to: " + this.io);
    }

    void setUser(String user2) throws InputException {
        if (user2 != null && user2.length() == 0) {
            user2 = null;
        }
        this.user = user2;
        Settings.log(1, "Camera '" + this.id + "' - User set to: " + this.user);
    }

    void setPassword(String password) throws InputException {
        if (password != null && password.length() == 0) {
            password = null;
        }
        this.password = password;
        Settings.log(1, "Camera '" + this.id + "' - Password set to: " + this.password);
    }

    void setDroppedFrames(String droppedFrames) throws InputException {
        if (droppedFrames != null) {
            if (droppedFrames.length() == 0) {
                droppedFrames = null;
            } else {
                try {
                    int df = Integer.parseInt(droppedFrames);
                    if (df < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal dropped frames for Camera '" + this.id + "': " + droppedFrames);
                }
            }
        }
        this.droppedFrames = droppedFrames;
        Settings.log(1, "Camera '" + this.id + "' - Dropped frames set to: " + this.droppedFrames);
    }

    void setMaxAge(String maxAge) throws InputException {
        if (maxAge != null) {
            if (maxAge.length() == 0) {
                maxAge = null;
            } else {
                try {
                    maxAge = maxAge.toLowerCase();
                    char c2 = maxAge.charAt(maxAge.length() - 1);
                    if (c2 != 'd' && c2 != 'h' && c2 != 'm') {
                        throw new InputException("Illegal max age for Camera '" + this.id + "': " + maxAge);
                    }
                    int v = Integer.parseInt(maxAge.substring(0, maxAge.length() - 1));
                    if (v <= 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal max age for Camera '" + this.id + "': " + maxAge);
                }
            }
        }
        this.maxAge = maxAge;
        Settings.log(1, "Camera '" + this.id + "' - Max age set to: " + this.maxAge);
    }

    void setMotionBuffer(String motionBuffer) throws InputException {
        if (motionBuffer != null) {
            if (motionBuffer.length() == 0) {
                motionBuffer = null;
            } else {
                try {
                    int df = Integer.parseInt(motionBuffer);
                    if (df < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    throw new InputException("Illegal motion buffer for Camera '" + this.id + "': " + motionBuffer);
                }
            }
        }
        this.motionBuffer = motionBuffer;
        Settings.log(1, "Camera '" + this.id + "' - Motion buffer set to: " + this.motionBuffer);
    }

    void setRemoteRequestPassword(String remoteRequestPassword) throws InputException {
        if (remoteRequestPassword != null && remoteRequestPassword.length() == 0) {
            remoteRequestPassword = null;
        }
        this.remoteRequestPassword = remoteRequestPassword;
        Settings.log(1, "Camera '" + this.id + "' - Remote request password set to: " + this.remoteRequestPassword);
    }

    void setTrustedRequestPassword(String trustedRequestPassword) throws InputException {
        if (trustedRequestPassword != null && trustedRequestPassword.length() == 0) {
            trustedRequestPassword = null;
        }
        this.trustedRequestPassword = trustedRequestPassword;
        Settings.log(1, "Camera '" + this.id + "' - Trusted request password set to: " + this.trustedRequestPassword);
    }

    void setRotate(String rotate) throws InputException {
        if (rotate != null) {
            if (rotate.length() == 0) {
                rotate = null;
            } else {
                try {
                    Integer.parseInt(rotate);
                }
                catch (Exception e2) {
                    throw new InputException("Illegal rotate for Camera '" + this.id + "': " + rotate);
                }
            }
        }
        this.rotate = rotate;
        Settings.log(1, "Camera '" + this.id + "' - Rotate set to: " + this.rotate);
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if (this.url == null) {
            new Error("Camera '" + this.id + "' - URL not set", this);
        }
        if (bw != null) {
            bw.write("Camera." + this.id + ".URL");
            bw.write(" = ");
            bw.write(this.url);
            bw.write("\n");
            if (this.urlSmall != null) {
                bw.write("Camera." + this.id + ".URL.Small");
                bw.write(" = ");
                bw.write(this.urlSmall);
                bw.write("\n");
            }
            if (this.ptz != null) {
                bw.write("Camera." + this.id + ".PTZ");
                bw.write(" = ");
                bw.write(this.ptz);
                bw.write("\n");
            }
            if (this.type != null) {
                bw.write("Camera." + this.id + ".Type");
                bw.write(" = ");
                bw.write(this.type);
                bw.write("\n");
            }
            if (this.io != null) {
                bw.write("Camera." + this.id + ".IO");
                bw.write(" = ");
                bw.write(this.io);
                bw.write("\n");
            }
            if (this.user != null) {
                bw.write("Camera." + this.id + ".User");
                bw.write(" = ");
                bw.write(this.user);
                bw.write("\n");
            }
            if (this.password != null) {
                bw.write("Camera." + this.id + ".Password");
                bw.write(" = ");
                bw.write(this.password);
                bw.write("\n");
            }
            if (this.droppedFrames != null) {
                bw.write("Camera." + this.id + ".DroppedFrames");
                bw.write(" = ");
                bw.write(this.droppedFrames);
                bw.write("\n");
            }
            if (this.maxAge != null) {
                bw.write("Camera." + this.id + ".MaxAge");
                bw.write(" = ");
                bw.write(this.maxAge);
                bw.write("\n");
            }
            if (this.motionBuffer != null) {
                bw.write("Camera." + this.id + ".MotionBuffer");
                bw.write(" = ");
                bw.write(this.motionBuffer);
                bw.write("\n");
            }
            if (this.remoteRequestPassword != null) {
                bw.write("Camera." + this.id + ".RemoteRequestPassword");
                bw.write(" = ");
                bw.write(this.remoteRequestPassword);
                bw.write("\n");
            }
            if (this.trustedRequestPassword != null) {
                bw.write("Camera." + this.id + ".TrustedRequestPassword");
                bw.write(" = ");
                bw.write(this.trustedRequestPassword);
                bw.write("\n");
            }
            if (this.rotate != null) {
                bw.write("Camera." + this.id + ".Rotate");
                bw.write(" = ");
                bw.write(this.rotate);
                bw.write("\n");
            }
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

