/*
 * Decompiled with CFR 0.152.
 */
package plugins.lorawanutil;

import com.hsyco.Configuration;
import com.hsyco.userBase;
import drivers.lorawan.Device;
import drivers.lorawan.Driver;
import drivers.lorawan.Entity;
import drivers.lorawan.Gateway;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.json.JSONObject;
import plugins.lorawanutil.ListWrapper;
import plugins.lorawanutil.WarningException;

public class LoRaWanUtil
extends userBase {
    private static final String VERSION = "LoRaWAN Util 1.2.1";
    static final String PREFIX = "__hsyco__lorawanutil.";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final int LOG_ERROR = 0;
    static final int LOG_VERBOSE = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_MESSAGE = 3;
    static final int LOG_EVENT = 4;
    private static boolean initialized = false;
    static boolean debug = false;
    private static String ioServerPrefix;
    private static final ListWrapper<Gateway> GATEWAYS_WRAPPER;
    private static final ListWrapper<Device> DEVICES_WRAPPER;

    static {
        GATEWAYS_WRAPPER = new ListWrapper<Gateway>(){

            @Override
            String getLabel(Gateway e2, String listId) {
                String lastseen = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "gw." + e2.id + ".lastseen");
                String time = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "gw." + e2.id + ".stat.time");
                String ackr = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "gw." + e2.id + ".stat.ackr");
                if (lastseen == null || lastseen.isEmpty()) {
                    lastseen = "-";
                } else {
                    SimpleDateFormat df = new SimpleDateFormat(LoRaWanUtil.DATE_TIME_FORMAT);
                    lastseen = df.format(Long.parseLong(lastseen));
                }
                if (time == null || time.isEmpty()) {
                    time = "-";
                }
                ackr = ackr == null || ackr.isEmpty() ? "-" : String.valueOf(ackr) + "%";
                return String.valueOf(e2.discovered ? "dim" : "") + "|" + e2.id + "|" + lastseen + "|" + time + "|" + ackr;
            }
        };
        DEVICES_WRAPPER = new ListWrapper<Device>(){

            @Override
            String getLabel(Device e2, String listId) {
                String warn;
                String gw;
                String lastseen = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "dev." + e2.id + ".lastseen");
                String string = gw = e2.gateway == null ? "-" : e2.gateway.id;
                warn = e2.discovered ? "" : ((warn = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "dev." + e2.id + ".warning.fcnt")) != null && !warn.equals("0") ? "fcnt" : ("1".equals(warn = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "dev." + e2.id + ".warning.mic")) ? "mic" : ("1".equals(warn = LoRaWanUtil.ioGet(String.valueOf(ioServerPrefix) + "dev." + e2.id + ".warning.data")) ? "data" : "")));
                if (lastseen == null || lastseen.isEmpty()) {
                    lastseen = "-";
                } else {
                    SimpleDateFormat df = new SimpleDateFormat(LoRaWanUtil.DATE_TIME_FORMAT);
                    lastseen = df.format(Long.parseLong(lastseen));
                }
                return String.valueOf(e2.discovered ? "dim" : "") + "|" + e2.id + "|" + lastseen + "|" + gw + "|" + e2.lsnr + "|" + e2.rssi + "|" + warn;
            }
        };
    }

    public static void StartupEvent() {
        block4: {
            try {
                initialized = false;
                userBase.uiSet("__hsyco__lorawanutil.scope!", "lorawanutil", "lock", "loading");
                for (String io : Configuration.ioServers) {
                    if (!"lorawan".equalsIgnoreCase(Configuration.ioServersGetTypeByName(io))) continue;
                    ioServerPrefix = String.valueOf(io) + ".";
                    break;
                }
                if (ioServerPrefix == null) {
                    LoRaWanUtil.log(1, "No LORAWAN I/O Server - quitting");
                    return;
                }
                LoRaWanUtil.log(3, "application started");
                LoRaWanUtil.uiSet("version", "value", VERSION);
                initialized = true;
                LoRaWanUtil.log(3, "initialization complete");
            }
            catch (Throwable e2) {
                LoRaWanUtil.log(0, "initialization error - " + LoRaWanUtil.getStackTrace(e2));
                if (!debug) break block4;
                e2.printStackTrace();
            }
        }
    }

    public static void IOEvent(String id, String value) {
        block17: {
            try {
                if (ioServerPrefix == null || !id.startsWith(ioServerPrefix)) {
                    return;
                }
                if ("connection".equals(id = id.substring(ioServerPrefix.length()))) {
                    boolean online = "online".equals(value);
                    userBase.uiSet("__hsyco__lorawanutil.scope!", "lorawanutil", "lock", online ? "" : "loading");
                    if (online) {
                        LoRaWanUtil.uiSet("gw.discovery", "value", "" + Driver.INSTANCE.discoveryGws);
                        LoRaWanUtil.uiSet("dev.discovery", "value", "" + Driver.INSTANCE.discoveryDevs);
                        userBase.uiSet("__hsyco__lorawanutil.scope!", "lorawanutil", "page", "menu");
                        LoRaWanUtil.guiUpdateGatewaysList();
                        LoRaWanUtil.guiUpdateDevicesList();
                    }
                } else if ("error.iolimit".equals(id)) {
                    if ("0".equals(value)) {
                        LoRaWanUtil.uiSet("loading.msg", "text", "Loading...");
                        LoRaWanUtil.uiSet("gw.iolimitwarn", "visible", "false");
                    } else {
                        LoRaWanUtil.uiSet("loading.msg", "text", "I/O license limit exceeded");
                        LoRaWanUtil.uiSet("gw.iolimitwarn", "visible", "true");
                    }
                } else if (id.startsWith("gw.")) {
                    if (id.endsWith(".lastseen")) {
                        LoRaWanUtil.guiUpdateGatewaysList();
                    }
                } else if (id.startsWith("dev.")) {
                    if (id.endsWith(".lastseen") || id.contains(".warning.")) {
                        LoRaWanUtil.guiUpdateDevicesList();
                    } else if (id.contains(".fcnt.") || id.endsWith(".queue.size") || id.endsWith(".error.tx") || id.endsWith(".frame.json")) {
                        LoRaWanUtil.uiSet(id, "_value", value);
                    }
                }
            }
            catch (Throwable e2) {
                LoRaWanUtil.log(0, "error on event '" + id + " = " + value + "' - " + LoRaWanUtil.getStackTrace(e2));
                if (!debug) break block17;
                e2.printStackTrace();
            }
        }
    }

    public static String userCommand(String session, String userId, String cmd, String param) {
        return LoRaWanUtil.userCommandOrSubmit(session, userId, cmd, param, null);
    }

    public static String userSubmit(String session, String userId, String cmd, HashMap<String, String> fields) {
        return LoRaWanUtil.userCommandOrSubmit(session, userId, cmd, null, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static String userCommandOrSubmit(String session, String userId, String cmd, String param, HashMap<String, String> fields) {
        try {
            if (!cmd.startsWith(PREFIX)) {
                return null;
            }
            if (!initialized) {
                return null;
            }
            if (param != null && param.endsWith("/close")) {
                return "!";
            }
            cmd = cmd.substring(PREFIX.length());
            LoRaWanUtil.log(1, "processing command '" + cmd + " = " + param + "'");
            if (cmd.equals("commit")) {
                Driver driver = Driver.INSTANCE;
                synchronized (driver) {
                    if (ioServerPrefix == null) {
                        return "!error";
                    }
                    BufferedWriter bw = null;
                    try {
                        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("lorawan.ini.tmp"), Charset.forName("UTF-8")));
                        for (Gateway gw : Driver.INSTANCE.gateways.values()) {
                            if (gw.discovered) continue;
                            bw.write(String.valueOf(ioServerPrefix) + "gw." + gw.id + ": ");
                            if (gw.mac != null) {
                                bw.write("mac=" + gw.mac);
                                bw.write(", ");
                            }
                            if (gw.ip != null) {
                                bw.write("ip=" + gw.ip);
                            }
                            bw.newLine();
                        }
                        bw.newLine();
                        for (Device dev : Driver.INSTANCE.devices.values()) {
                            if (dev.discovered) continue;
                            bw.write(String.valueOf(ioServerPrefix) + "dev." + dev.id + ": ");
                            bw.write("addr=" + dev.addr);
                            bw.write(", deviceClass=" + (Object)((Object)dev.deviceClass));
                            bw.write(", nwkSKey=" + dev.getNwkSKeyHexString());
                            bw.write(", appSKey=" + dev.getAppSKeyHexString());
                            bw.write(", downlinkAttempts=" + dev.downlinkAttempts);
                            bw.write(", downlinkPort=" + dev.downlinkPort);
                            bw.write(", fCntCheck=" + dev.fCntCheck);
                            bw.write(", fCntAutoResetThreshold=" + dev.fCntAutoResetThreshold);
                            bw.write(", micCheck=" + dev.micCheck);
                            bw.write(", maxFCntGap=" + dev.fCntMaxGap);
                            bw.write(", cayenne=" + dev.cayenne);
                            bw.newLine();
                        }
                        File f2 = new File("lorawan.ini.tmp");
                        f2.renameTo(new File("lorawan.ini"));
                        f2.setWritable(true, false);
                        userBase.uiSet("__hsyco__lorawanutil.scope!", "lorawanutil", "lock", "loading");
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (Exception exception) {}
                    }
                    return "!page:close";
                }
            }
            if (cmd.startsWith("gw.")) {
                if (cmd.endsWith("discovery")) {
                    Driver.INSTANCE.discoveryGws = Boolean.parseBoolean(param);
                    return "!";
                }
                if (cmd.endsWith("list")) {
                    Gateway g2 = Driver.INSTANCE.gateways.get(param);
                    LoRaWanUtil.uiSet("gw.id", "value", g2.id, session);
                    LoRaWanUtil.uiSet("gw.ip", "value", g2.ip == null ? "" : g2.ip, session);
                    LoRaWanUtil.uiSet("gw.mac", "value", g2.mac == null ? "" : g2.mac, session);
                    LoRaWanUtil.uiSet("gw.iolimit", "text", "" + Driver.INSTANCE.ioLimitsAvailable());
                    LoRaWanUtil.uiSet("gw.delete", "text", "Delete", session);
                    LoRaWanUtil.uiSet("gw.delete", "param", "", session);
                    LoRaWanUtil.uiSet("gw.delete", "visible", "true", session);
                    return "!page:gw.edit";
                }
                if (cmd.endsWith("add")) {
                    int ioLimit = Driver.INSTANCE.ioLimitsAvailable();
                    if (ioLimit < 1) {
                        throw new WarningException("I/O license limit reached", "menu", session);
                    }
                    LoRaWanUtil.uiSet("gw.id", "value", "", session);
                    LoRaWanUtil.uiSet("gw.ip", "value", "", session);
                    LoRaWanUtil.uiSet("gw.mac", "value", "", session);
                    LoRaWanUtil.uiSet("gw.iolimit", "text", "" + ioLimit);
                    LoRaWanUtil.uiSet("gw.delete", "visible", "false", session);
                    return "!page:gw.edit";
                }
                if (cmd.endsWith("save")) {
                    Gateway g3;
                    String ip;
                    String newId = LoRaWanUtil.getSubmitField(fields, "gw.id", true);
                    if (newId.isEmpty()) {
                        LoRaWanUtil.uiSet("gw.id", "error", "true", session);
                        return "!error";
                    }
                    String oldId = LoRaWanUtil.uiGet("gw.id", "value", session);
                    if (!oldId.equals(newId) && Driver.INSTANCE.gateways.containsKey(newId)) {
                        throw new WarningException("ID already used", "close", session);
                    }
                    String mac = LoRaWanUtil.getSubmitField(fields, "gw.mac", true);
                    if (mac.isEmpty()) {
                        mac = null;
                    }
                    if ((ip = LoRaWanUtil.getSubmitField(fields, "gw.ip", true)).isEmpty()) {
                        ip = null;
                    }
                    if (ip == null && mac == null) {
                        LoRaWanUtil.uiSet("gw.ip", "error", "true", session);
                        LoRaWanUtil.uiSet("gw.mac", "error", "true", session);
                        return "!error";
                    }
                    if (oldId.isEmpty()) {
                        g3 = Driver.INSTANCE.addGatewayIoLimits(newId, false);
                        if (g3 == null) {
                            throw new WarningException("I/O license limit reached", "menu", session);
                        }
                    } else {
                        g3 = Driver.INSTANCE.gateways.remove(oldId);
                        g3.id = newId;
                        g3.discovered = false;
                        Driver.INSTANCE.gateways.put(newId, g3);
                    }
                    g3.setMac(mac);
                    g3.setIp(ip);
                    LoRaWanUtil.guiUpdateGatewaysList();
                    return "!page:close";
                }
                if (cmd.endsWith("delete")) {
                    if ("confirm".equals(param)) {
                        Driver.INSTANCE.gateways.remove(LoRaWanUtil.uiGet("gw.id", "value", session));
                        LoRaWanUtil.guiUpdateGatewaysList();
                        return "!page:close";
                    }
                    LoRaWanUtil.uiSet("gw.delete", "text", "Confirm", session);
                    LoRaWanUtil.uiSet("gw.delete", "param", "confirm", session);
                    return "!";
                }
            } else if (cmd.startsWith("dev.")) {
                if (cmd.endsWith("discovery")) {
                    Driver.INSTANCE.discoveryDevs = Boolean.parseBoolean(param);
                    return "!";
                }
                if (cmd.endsWith("list")) {
                    Device d2 = Driver.INSTANCE.devices.get(param);
                    LoRaWanUtil.uiSet("dev.id", "value", d2.id, session);
                    LoRaWanUtil.uiSet("dev.addr", "value", d2.addr, session);
                    String nwkSKey = d2.getNwkSKeyHexString();
                    LoRaWanUtil.uiSet("dev.nwkSKey", "value", nwkSKey == null ? "" : nwkSKey, session);
                    String appSKey = d2.getAppSKeyHexString();
                    LoRaWanUtil.uiSet("dev.appSKey", "value", appSKey == null ? "" : appSKey, session);
                    LoRaWanUtil.uiSet("dev.deviceClass", "value", d2.deviceClass == Device.DeviceClass.A ? "" : d2.deviceClass.name(), session);
                    LoRaWanUtil.uiSet("dev.maxFCntGap", "value", "" + d2.fCntMaxGap, session);
                    LoRaWanUtil.uiSet("dev.downlinkPort", "value", "" + d2.downlinkPort, session);
                    LoRaWanUtil.uiSet("dev.downlink.port", "value", "" + d2.downlinkPort, session);
                    LoRaWanUtil.uiSet("dev.downlinkAttempts", "value", "" + d2.downlinkAttempts, session);
                    LoRaWanUtil.uiSet("dev.fCntCheck", "value", "" + d2.fCntCheck, session);
                    LoRaWanUtil.uiSet("dev.fCntAutoReset", "value", d2.fCntAutoResetThreshold > 0 ? "true" : "false", session);
                    LoRaWanUtil.uiSet("dev.cayenne", "value", "" + d2.cayenne, session);
                    LoRaWanUtil.uiSet("dev.tools.link", "visible", "true", session);
                    LoRaWanUtil.uiSet("dev.fcnt.up", "value", "" + d2.fCntUp32bits, session);
                    LoRaWanUtil.uiSet("dev.fcnt.down", "value", "" + d2.fCntDown, session);
                    LoRaWanUtil.uiSet("dev.queue.size", "value", "" + d2.downlinkQueue.size(), session);
                    LoRaWanUtil.uiSet("dev.error.tx", "value", "-", session);
                    LoRaWanUtil.uiSet("dev.delete", "text", "Delete", session);
                    LoRaWanUtil.uiSet("dev.delete", "param", "", session);
                    LoRaWanUtil.uiSet("dev.delete", "visible", "true", session);
                    return "!page:dev.edit";
                }
                if (cmd.endsWith("add")) {
                    LoRaWanUtil.uiSet("dev.id", "value", "", session);
                    LoRaWanUtil.uiSet("dev.addr", "value", "", session);
                    LoRaWanUtil.uiSet("dev.nwkSKey", "value", "", session);
                    LoRaWanUtil.uiSet("dev.appSKey", "value", "", session);
                    LoRaWanUtil.uiSet("dev.deviceClass", "value", "", session);
                    LoRaWanUtil.uiSet("dev.maxFCntGap", "value", "", session);
                    LoRaWanUtil.uiSet("dev.downlinkPort", "value", "", session);
                    LoRaWanUtil.uiSet("dev.downlinkAttempts", "value", "", session);
                    LoRaWanUtil.uiSet("dev.fCntCheck", "value", "true", session);
                    LoRaWanUtil.uiSet("dev.fCntAutoReset", "value", "false", session);
                    LoRaWanUtil.uiSet("dev.cayenne", "value", "false", session);
                    LoRaWanUtil.uiSet("dev.tools.link", "visible", "false", session);
                    LoRaWanUtil.uiSet("dev.delete", "visible", "false", session);
                    return "!page:dev.edit";
                }
                if (cmd.endsWith("save")) {
                    int downlinkAttempts;
                    int downlinkPort;
                    int fCntMaxGap;
                    String addr;
                    String newId = LoRaWanUtil.getSubmitField(fields, "dev.id", true);
                    if (newId.isEmpty()) {
                        LoRaWanUtil.uiSet("dev.id", "error", "true", session);
                        return "!error";
                    }
                    String oldId = LoRaWanUtil.uiGet("dev.id", "value", session);
                    if (!oldId.equals(newId) && Driver.INSTANCE.devices.containsKey(newId)) {
                        throw new WarningException("ID already used", "close", session);
                    }
                    try {
                        addr = Long.toHexString(Long.parseLong(LoRaWanUtil.getSubmitField(fields, "dev.addr", true), 16));
                    }
                    catch (Exception e2) {
                        LoRaWanUtil.uiSet("dev.addr", "error", "true", session);
                        return "!error";
                    }
                    String nwkSKey = LoRaWanUtil.getSubmitField(fields, "dev.nwkSKey", true);
                    try {
                        if (nwkSKey.isEmpty()) {
                            throw new Exception();
                        }
                        int i2 = 0;
                        while (i2 < nwkSKey.length()) {
                            if (Character.digit(nwkSKey.charAt(i2), 16) < 0) {
                                throw new Exception();
                            }
                            ++i2;
                        }
                    }
                    catch (Exception e3) {
                        LoRaWanUtil.uiSet("dev.nwkSKey", "error", "true", session);
                        return "!error";
                    }
                    String appSKey = LoRaWanUtil.getSubmitField(fields, "dev.appSKey", true);
                    try {
                        if (appSKey.isEmpty()) {
                            throw new Exception();
                        }
                        int i3 = 0;
                        while (i3 < appSKey.length()) {
                            if (Character.digit(appSKey.charAt(i3), 16) < 0) {
                                throw new Exception();
                            }
                            ++i3;
                        }
                    }
                    catch (Exception e4) {
                        LoRaWanUtil.uiSet("dev.appSKey", "error", "true", session);
                        return "!error";
                    }
                    String deviceClass = LoRaWanUtil.getSubmitField(fields, "dev.deviceClass", true);
                    if (deviceClass.isEmpty()) {
                        deviceClass = "A";
                    }
                    try {
                        fCntMaxGap = Integer.parseInt(LoRaWanUtil.getSubmitField(fields, "dev.maxFCntGap", true));
                    }
                    catch (Exception e5) {
                        LoRaWanUtil.uiSet("dev.maxFCntGap", "error", "true", session);
                        return "!error";
                    }
                    try {
                        downlinkPort = Integer.parseInt(LoRaWanUtil.getSubmitField(fields, "dev.downlinkPort", true));
                    }
                    catch (Exception e6) {
                        LoRaWanUtil.uiSet("dev.downlinkPort", "error", "true", session);
                        return "!error";
                    }
                    try {
                        downlinkAttempts = Integer.parseInt(LoRaWanUtil.getSubmitField(fields, "dev.downlinkAttempts", true));
                    }
                    catch (Exception e7) {
                        LoRaWanUtil.uiSet("dev.downlinkAttempts", "error", "true", session);
                        return "!error";
                    }
                    boolean fCntCheck = Boolean.parseBoolean(LoRaWanUtil.getSubmitField(fields, "dev.fCntCheck", true));
                    boolean fCntAutoReset = Boolean.parseBoolean(LoRaWanUtil.getSubmitField(fields, "dev.fCntAutoReset", true));
                    boolean cayenne = Boolean.parseBoolean(LoRaWanUtil.getSubmitField(fields, "dev.cayenne", true));
                    Device d3 = oldId.isEmpty() ? new Device(Driver.INSTANCE, newId, false) : Driver.INSTANCE.devices.remove(oldId);
                    d3.id = newId;
                    d3.setAddr(addr);
                    d3.setNwkSKey(nwkSKey);
                    d3.setAppSKey(appSKey);
                    d3.setDeviceClass(deviceClass);
                    d3.setFCntMaxGap(fCntMaxGap);
                    d3.setDownlinkPort(downlinkPort);
                    d3.setDownlinkAttempts(downlinkAttempts);
                    d3.setFCntCheck(fCntCheck);
                    d3.setFCntAutoResetThreshold(fCntAutoReset ? 3 : 0);
                    d3.setCayenne(cayenne);
                    d3.discovered = false;
                    Driver.INSTANCE.devices.put(d3.id, d3);
                    LoRaWanUtil.guiUpdateDevicesList();
                    return "!page:close";
                }
                if (cmd.endsWith("delete")) {
                    if ("confirm".equals(param)) {
                        Driver.INSTANCE.devices.remove(LoRaWanUtil.uiGet("dev.id", "value", session));
                        LoRaWanUtil.guiUpdateDevicesList();
                        return "!page:close";
                    }
                    LoRaWanUtil.uiSet("dev.delete", "text", "Confirm", session);
                    LoRaWanUtil.uiSet("dev.delete", "param", "confirm", session);
                    return "!";
                }
                if (cmd.endsWith("gen.nwkSKey") || cmd.endsWith("gen.appSKey")) {
                    Random random = new Random();
                    byte[] key = new byte[16];
                    int i4 = 0;
                    while (i4 < key.length) {
                        key[i4] = (byte)random.nextInt(256);
                        ++i4;
                    }
                    String keyStr = Driver.bytesToHex(key, 0, key.length);
                    if (cmd.endsWith("nwkSKey")) {
                        LoRaWanUtil.uiSet("dev.nwkSKey", "value", keyStr, session);
                    } else {
                        LoRaWanUtil.uiSet("dev.appSKey", "value", keyStr, session);
                    }
                    return "!";
                }
                if (cmd.endsWith("fcnt.up")) {
                    Device d4 = Driver.INSTANCE.devices.get(LoRaWanUtil.uiGet("dev.id", "value", session));
                    d4.setFCntUp32bits(Long.parseLong(param));
                    return "!";
                }
                if (cmd.endsWith("fcnt.down")) {
                    Device d5 = Driver.INSTANCE.devices.get(LoRaWanUtil.uiGet("dev.id", "value", session));
                    d5.setFCntDown(Long.parseLong(param));
                    return "!";
                }
                if (cmd.endsWith("fcnt.up.find")) {
                    Device d6 = Driver.INSTANCE.devices.get(LoRaWanUtil.uiGet("dev.id", "value", session));
                    String curr = LoRaWanUtil.uiGet("dev.fcnt.up", "value", session);
                    LoRaWanUtil.uiSet("dev.fcnt.up", "value", "...", session);
                    try {
                        Thread.sleep(300L);
                        d6.lastDataPayload.setNwkSKey(d6.nwkSKey);
                        d6.lastDataPayload.setAppSKey(d6.appSKey);
                        boolean found = false;
                        long hb = 0L;
                        while (hb <= 65535L) {
                            if (d6.lastDataPayload.validateMic((short)hb)) {
                                long fCnt = (hb << 16) + ((long)d6.lastDataPayload.getMac().getFhdr().getfCnt() & 0xFFFFL);
                                d6.setFCntUp32bits(fCnt);
                                found = true;
                                break;
                            }
                            ++hb;
                        }
                        if (!found) {
                            throw new Exception();
                        }
                    }
                    catch (Exception e8) {
                        LoRaWanUtil.uiSet("dev.fcnt.up", "value", curr, session);
                        LoRaWanUtil.uiSet("dev.fcnt.up", "error", "true", session);
                    }
                    return "!";
                }
                if (cmd.endsWith("downlink.cayenne")) {
                    LoRaWanUtil.uiSet("dev.downlink.cayenne_true", "visible", "false", session);
                    LoRaWanUtil.uiSet("dev.downlink.cayenne_false", "visible", "false", session);
                    LoRaWanUtil.uiSet("dev.downlink.cayenne_" + param, "visible", "true", session);
                    return "!";
                }
                if (cmd.endsWith("downlink.queue")) {
                    String id = LoRaWanUtil.uiGet("dev.id", "value", session);
                    Device d7 = Driver.INSTANCE.devices.get(id);
                    if (d7.discovered) {
                        throw new WarningException("Device not configured", "close", session);
                    }
                    boolean cayenne = Boolean.parseBoolean(LoRaWanUtil.getSubmitField(fields, "dev.downlink.cayenne", true));
                    String data = LoRaWanUtil.getSubmitField(fields, "dev.downlink.data", true);
                    String cayCh = LoRaWanUtil.getSubmitField(fields, "dev.downlink.cayenne.ch", true);
                    String cayType = LoRaWanUtil.getSubmitField(fields, "dev.downlink.cayenne.type", true);
                    String cayVal = LoRaWanUtil.getSubmitField(fields, "dev.downlink.cayenne.val", true);
                    String port = LoRaWanUtil.getSubmitField(fields, "dev.downlink.port", true);
                    String powe = LoRaWanUtil.getSubmitField(fields, "dev.downlink.powe", true);
                    String datr = LoRaWanUtil.getSubmitField(fields, "dev.downlink.datr", true);
                    String codr = LoRaWanUtil.getSubmitField(fields, "dev.downlink.codr", true);
                    String rfch = LoRaWanUtil.getSubmitField(fields, "dev.downlink.rfch", true);
                    JSONObject obj = new JSONObject();
                    if (cayenne) {
                        try {
                            Integer.parseInt(cayCh);
                        }
                        catch (Exception e9) {
                            LoRaWanUtil.uiSet("dev.downlink.cayenne.ch", "error", "true", session);
                            return "!error";
                        }
                        try {
                            cayVal = cayVal.replace("&#44;", ".");
                            Float.parseFloat(cayVal);
                        }
                        catch (Exception e10) {
                            LoRaWanUtil.uiSet("dev.downlink.cayenne.val", "error", "true", session);
                            return "!error";
                        }
                        if (cayType.isEmpty()) {
                            cayType = "1";
                        }
                        JSONObject dataObj = new JSONObject();
                        dataObj.put("channel", cayCh);
                        dataObj.put("value", cayVal);
                        dataObj.put("type", cayType);
                        obj.put("data", dataObj);
                    } else {
                        try {
                            if (data.isEmpty()) {
                                throw new Exception();
                            }
                            if (data.length() % 2 == 1) {
                                throw new Exception();
                            }
                            int i5 = 0;
                            while (i5 < data.length()) {
                                if (Character.digit(data.charAt(i5), 16) < 0) {
                                    throw new Exception();
                                }
                                ++i5;
                            }
                        }
                        catch (Exception e11) {
                            LoRaWanUtil.uiSet("dev.downlink.data", "error", "true", session);
                            return "!error";
                        }
                        obj.put("data", data);
                    }
                    if (!port.isEmpty()) {
                        try {
                            obj.put("port", Integer.parseInt(port));
                        }
                        catch (Exception e12) {
                            LoRaWanUtil.uiSet("dev.downlink.port", "error", "true", session);
                            return "!error";
                        }
                    }
                    JSONObject txpk = new JSONObject();
                    if (!powe.isEmpty()) {
                        txpk.put("powe", Integer.parseInt(powe));
                    }
                    if (!datr.isEmpty()) {
                        txpk.put("datr", datr);
                    }
                    if (!codr.isEmpty()) {
                        txpk.put("codr", datr);
                    }
                    txpk.put("rfch", "1".equals(rfch) ? 1 : 0);
                    obj.put("txpk", txpk);
                    Driver.INSTANCE.command("dev." + id + ".queue", obj.toString());
                    return "!";
                }
                if (cmd.endsWith("downlink.clear")) {
                    String id = LoRaWanUtil.uiGet("dev.id", "value", session);
                    Driver.INSTANCE.command("dev." + id + ".queue", "clear");
                    return "!";
                }
            } else if (cmd.endsWith("warning.close")) {
                return "!page:" + param;
            }
            throw new Exception("Unknown command");
        }
        catch (WarningException e13) {
            return "!page:warning";
        }
        catch (Throwable e14) {
            LoRaWanUtil.log(0, "error processing command '" + cmd + " = " + param + "' - " + LoRaWanUtil.getStackTrace(e14));
            if (debug) {
                e14.printStackTrace();
            }
            return "!error";
        }
    }

    private static String getSubmitField(HashMap<String, String> fields, String id, boolean removeSpaces) {
        return fields.get(PREFIX + id).trim().replaceAll("\\s+", removeSpaces ? "" : " ").replace(",", "&#44;");
    }

    public static void uiSet(String id, String attr, String value) {
        LoRaWanUtil.uiSet(id, attr, value, null);
    }

    public static void uiSet(String id, String attr, String value, String session) {
        userBase.uiSet(session == null ? "__hsyco__lorawanutil.scope!" : session, PREFIX + id, attr, value);
    }

    public static String uiGet(String id, String attr) {
        return LoRaWanUtil.uiGet(id, attr, null);
    }

    public static String uiGet(String id, String attr, String session) {
        String ret = userBase.uiGet(session == null ? "__hsyco__lorawanutil.scope!" : session, PREFIX + id, attr);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private static void guiUpdateGatewaysList() {
        LoRaWanUtil.guiUpdateListsSort(Driver.INSTANCE.gateways.values(), GATEWAYS_WRAPPER, "gw.list", null);
    }

    private static void guiUpdateDevicesList() {
        LoRaWanUtil.guiUpdateListsSort(Driver.INSTANCE.devices.values(), DEVICES_WRAPPER, "dev.list", null);
    }

    private static <T extends Entity> void guiUpdateListsSort(Collection<T> list, ListWrapper<T> wrapper, String listId, String session) {
        List<T> sorted = wrapper.sort(list);
        LoRaWanUtil.guiUpdateList(sorted, wrapper, listId, session);
    }

    private static <T extends Entity> void guiUpdateList(Collection<T> list, ListWrapper<T> wrapper, String listId, String session) {
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<String> labelsList = new ArrayList<String>();
        for (Entity e2 : list) {
            String lab = wrapper.getLabel(e2, listId);
            if (lab == null) continue;
            valuesList.add(e2.id);
            labelsList.add(lab);
        }
        LoRaWanUtil.guiUpdateList(valuesList, labelsList, listId, session);
    }

    private static void guiUpdateList(List<String> valuesList, List<String> labelsList, String listId, String session) {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        int i2 = 0;
        while (i2 < valuesList.size()) {
            values.append(',').append(valuesList.get(i2).replace(",", "&#44;"));
            labels.append(',').append(labelsList.get(i2).replace(",", "&#44;"));
            ++i2;
        }
        LoRaWanUtil.uiSet(listId, "values", values.length() > 0 ? values.substring(1) : "", session);
        LoRaWanUtil.uiSet(listId, "labels", labels.length() > 0 ? labels.substring(1) : "", session);
    }

    private static String getStackTrace(Throwable e2) {
        StringWriter sw = new StringWriter();
        sw.append(e2.getLocalizedMessage());
        sw.append("\n\t");
        e2.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static void log(int tag, String message) {
        switch (tag) {
            case 2: {
                LoRaWanUtil.messageLog("[LORAWAN] Warning | " + message);
                break;
            }
            case 3: {
                LoRaWanUtil.messageLog("[LORAWAN] Message | " + message);
                break;
            }
            case 0: {
                LoRaWanUtil.errorLog("[LORAWAN] Error | " + message);
                break;
            }
            case 1: {
                if (!Configuration.verboseLog) break;
                LoRaWanUtil.messageLog("[LORAWAN] Verbose | " + message);
                break;
            }
            case 4: {
                if (!Configuration.eventsLog) break;
                LoRaWanUtil.messageLog("[LORAWAN] Event | " + message);
                break;
            }
        }
    }
}

