/*
 * Decompiled with CFR 0.152.
 */
package plugins.knxutil;

import com.hsyco.Configuration;
import com.hsyco.Knx;
import com.hsyco.userBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import plugins.knxutil.Frame;
import plugins.knxutil.Scanner;
import plugins.knxutil.WarningException;

public class KnxUtil
extends userBase {
    static final String PREFIX = "__hsyco__knxutil.";
    static final int LOG_ERROR = 0;
    static final int LOG_VERBOSE = 1;
    static final int LOG_WARNING = 2;
    static final int LOG_MESSAGE = 3;
    private static String selectedServerName;
    private static boolean monitorActive;
    private static ArrayList<Frame> frames;
    private static Scanner scanner;

    static {
        frames = new ArrayList();
    }

    public static void IOStartupEvent(int ioIndex) {
        try {
            String ioServerName = Configuration.ioServersGetName(ioIndex);
            String ioServerType = Configuration.ioServersGetTypeByName(ioServerName).toLowerCase();
            if (ioServerType == null || !ioServerType.equals("knx")) {
                return;
            }
            if (selectedServerName == null) {
                selectedServerName = ioServerName;
                String knxServers = "";
                int count = 0;
                for (String name : Configuration.ioServersName) {
                    String type = Configuration.ioServersGetTypeByName(name);
                    if (type == null || !type.equalsIgnoreCase("knx")) continue;
                    knxServers = String.valueOf(knxServers) + "," + name;
                    ++count;
                }
                if (knxServers.length() > 0) {
                    knxServers = knxServers.substring(1);
                }
                KnxUtil.uiSet("server.list", "values", knxServers);
                KnxUtil.uiSet("server.list", "labels", knxServers);
                if (count > 1) {
                    KnxUtil.uiSet("server.list", "enabled", "true");
                }
                KnxUtil.uiSet("server.list", "value", ioServerName);
                KnxUtil.showDatapoints();
            }
        }
        catch (Throwable e2) {
            KnxUtil.log(0, "error in IOStartupEvent(" + ioIndex + ") - " + KnxUtil.getStackTrace(e2));
        }
    }

    public static String userCommand(String session, String uid, String cmd, String param) {
        block73: {
            block77: {
                block76: {
                    block75: {
                        block74: {
                            block72: {
                                Knx selectedServer;
                                block70: {
                                    block71: {
                                        block68: {
                                            block69: {
                                                block66: {
                                                    block67: {
                                                        block64: {
                                                            block65: {
                                                                block60: {
                                                                    block63: {
                                                                        block62: {
                                                                            block61: {
                                                                                block58: {
                                                                                    block59: {
                                                                                        block55: {
                                                                                            block57: {
                                                                                                block56: {
                                                                                                    block53: {
                                                                                                        block54: {
                                                                                                            block52: {
                                                                                                                block51: {
                                                                                                                    if (cmd.startsWith(PREFIX)) break block51;
                                                                                                                    return null;
                                                                                                                }
                                                                                                                cmd = cmd.substring(PREFIX.length());
                                                                                                                KnxUtil.log(1, "processing command '" + cmd + " = " + param + "'");
                                                                                                                if (!param.endsWith("/close")) break block52;
                                                                                                                return "!";
                                                                                                            }
                                                                                                            if (!cmd.equals("server.list")) break block53;
                                                                                                            if (param.length() != 0) break block54;
                                                                                                            return "!error";
                                                                                                        }
                                                                                                        Knx srv = Knx.getInstance(param);
                                                                                                        if (srv != null) {
                                                                                                            selectedServerName = param;
                                                                                                            KnxUtil.showDatapoints();
                                                                                                            if (scanner != null) {
                                                                                                                scanner.interrupt();
                                                                                                            }
                                                                                                        } else {
                                                                                                            return "!error";
                                                                                                        }
                                                                                                        frames.clear();
                                                                                                        KnxUtil.updateSortedList(frames, "monitor.list");
                                                                                                        return "!";
                                                                                                    }
                                                                                                    selectedServer = Knx.getInstance(selectedServerName);
                                                                                                    if (selectedServer == null) {
                                                                                                        throw new WarningException("No KNX Server selected");
                                                                                                    }
                                                                                                    if (!cmd.startsWith("dp.")) break block55;
                                                                                                    if (!cmd.endsWith("add")) break block56;
                                                                                                    String writeAddr = KnxUtil.uiGet("monitor.address", "value");
                                                                                                    String writeDpt = KnxUtil.uiGet("monitor.dpt", "value");
                                                                                                    KnxUtil.uiSet("dp.address", "enabled", "true");
                                                                                                    KnxUtil.uiSet("dp.address", "value", writeAddr == null ? "" : writeAddr);
                                                                                                    KnxUtil.uiSet("dp.dpt", "enabled", "true");
                                                                                                    KnxUtil.uiSet("dp.dpt", "value", writeDpt == null ? "" : writeDpt);
                                                                                                    KnxUtil.uiSet("dp.id", "value", writeAddr == null ? "" : writeAddr);
                                                                                                    KnxUtil.uiSet("dp.descr", "value", "");
                                                                                                    KnxUtil.uiSet("dp.priority", "value", "low");
                                                                                                    KnxUtil.uiSet("dp.read", "value", "true");
                                                                                                    KnxUtil.uiSet("dp.dpt1", "enabled", "false");
                                                                                                    KnxUtil.uiSet("dp.icon", "value", "");
                                                                                                    KnxUtil.uiSet("dp.thumb", "value", "");
                                                                                                    KnxUtil.uiSet("dp.del", "visible", "false");
                                                                                                    KnxUtil.uiSet("dp.edit", "visible", "false");
                                                                                                    KnxUtil.uiSet("dp.new", "visible", "true");
                                                                                                    return "!page:dpt_edit";
                                                                                                }
                                                                                                if (!cmd.endsWith("list")) break block57;
                                                                                                Knx.Datapoint d2 = selectedServer.getDatapoint(param);
                                                                                                KnxUtil.uiSet("dp.address", "enabled", "false");
                                                                                                KnxUtil.uiSet("dp.address", "value", d2.addrString);
                                                                                                if (d2.belongsToVirtualDPs()) {
                                                                                                    KnxUtil.uiSet("dp.dpt", "enabled", "false");
                                                                                                } else {
                                                                                                    KnxUtil.uiSet("dp.dpt", "enabled", "true");
                                                                                                }
                                                                                                KnxUtil.uiSet("dp.dpt", "value", "" + d2.dpt);
                                                                                                KnxUtil.uiSet("dp.id", "value", d2.id);
                                                                                                KnxUtil.uiSet("dp.descr", "value", d2.description);
                                                                                                KnxUtil.uiSet("dp.priority", "value", d2.priorityString);
                                                                                                KnxUtil.uiSet("dp.read", "value", "" + d2.read);
                                                                                                if (d2 instanceof Knx.DatapointDPT1) {
                                                                                                    KnxUtil.uiSet("dp.dpt1", "enabled", "true");
                                                                                                    KnxUtil.uiSet("dp.icon", "value", ((Knx.DatapointDPT1)d2).icon != null ? ((Knx.DatapointDPT1)d2).icon : "");
                                                                                                    KnxUtil.uiSet("dp.thumb", "value", ((Knx.DatapointDPT1)d2).thumbnail != null ? ((Knx.DatapointDPT1)d2).thumbnail : "");
                                                                                                } else {
                                                                                                    KnxUtil.uiSet("dp.dpt1", "enabled", "false");
                                                                                                    KnxUtil.uiSet("dp.icon", "value", "");
                                                                                                    KnxUtil.uiSet("dp.thumb", "value", "");
                                                                                                }
                                                                                                KnxUtil.uiSet("dp.del", "visible", "true");
                                                                                                KnxUtil.uiSet("dp.edit", "visible", "true");
                                                                                                KnxUtil.uiSet("dp.new", "visible", "false");
                                                                                                return "!page:dpt_edit";
                                                                                            }
                                                                                            if (!cmd.endsWith("dpt")) break block55;
                                                                                            if (param.equals("1")) {
                                                                                                KnxUtil.uiSet("dp.dpt1", "enabled", "true");
                                                                                                KnxUtil.uiSet("dp.icon", "value", "STD");
                                                                                            } else {
                                                                                                KnxUtil.uiSet("dp.dpt1", "enabled", "false");
                                                                                                KnxUtil.uiSet("dp.icon", "value", "");
                                                                                            }
                                                                                            return "!";
                                                                                        }
                                                                                        if (!cmd.startsWith("light.")) break block58;
                                                                                        if (!cmd.endsWith("add")) break block59;
                                                                                        KnxUtil.uiSet("light.id", "enabled", "true");
                                                                                        KnxUtil.uiSet("light.id", "value", "" + (selectedServer.getLightDPs().size() + 1));
                                                                                        KnxUtil.uiSet("light.fb", "value", "");
                                                                                        KnxUtil.uiSet("light.cmd", "value", "");
                                                                                        KnxUtil.uiSet("light.on", "value", "1");
                                                                                        KnxUtil.uiSet("light.descr", "value", "");
                                                                                        KnxUtil.uiSet("light.icon", "value", "LIGHT");
                                                                                        KnxUtil.uiSet("light.thumb", "value", "");
                                                                                        KnxUtil.uiSet("light.del", "visible", "false");
                                                                                        KnxUtil.uiSet("light.edit", "visible", "false");
                                                                                        KnxUtil.uiSet("light.new", "visible", "true");
                                                                                        return "!page:light_edit";
                                                                                    }
                                                                                    if (!cmd.endsWith("list")) break block58;
                                                                                    Knx.Light l2 = selectedServer.getLight(param);
                                                                                    KnxUtil.uiSet("light.id", "enabled", "false");
                                                                                    KnxUtil.uiSet("light.id", "value", "" + l2.id);
                                                                                    KnxUtil.uiSet("light.fb", "value", l2.fb_onoff != null ? l2.fb_onoff.addrString : "");
                                                                                    KnxUtil.uiSet("light.cmd", "value", l2.cmd_onoff != null ? l2.cmd_onoff.addrString : "");
                                                                                    KnxUtil.uiSet("light.on", "value", l2.on);
                                                                                    KnxUtil.uiSet("light.descr", "value", l2.description);
                                                                                    KnxUtil.uiSet("light.icon", "value", l2.icon != null ? l2.icon : "");
                                                                                    KnxUtil.uiSet("light.thumb", "value", l2.thumbnail != null ? l2.thumbnail : "");
                                                                                    KnxUtil.uiSet("light.del", "visible", "true");
                                                                                    KnxUtil.uiSet("light.edit", "visible", "true");
                                                                                    KnxUtil.uiSet("light.new", "visible", "false");
                                                                                    return "!page:light_edit";
                                                                                }
                                                                                if (!cmd.startsWith("dimm.")) break block60;
                                                                                if (!cmd.endsWith("add")) break block61;
                                                                                KnxUtil.uiSet("dimm.id", "enabled", "true");
                                                                                KnxUtil.uiSet("dimm.id", "value", "" + (selectedServer.getDimmerDPs().size() + 1));
                                                                                KnxUtil.uiSet("dimm.fb.level", "value", "");
                                                                                KnxUtil.uiSet("dimm.fb.onoff", "value", "");
                                                                                KnxUtil.uiSet("dimm.cmd.level", "value", "");
                                                                                KnxUtil.uiSet("dimm.cmd.onoff", "value", "");
                                                                                KnxUtil.uiSet("dimm.cmd.step", "value", "");
                                                                                KnxUtil.uiSet("dimm.on", "value", "1");
                                                                                KnxUtil.uiSet("dimm.descr", "value", "");
                                                                                KnxUtil.uiSet("dimm.thumb", "value", "");
                                                                                KnxUtil.uiSet("dimm.stepval", "value", "3");
                                                                                KnxUtil.uiSet("dimm.descr", "value", "");
                                                                                KnxUtil.uiSet("dimm.thumb", "value", "");
                                                                                KnxUtil.uiSet("dimm.dimming", "value", "false");
                                                                                KnxUtil.uiSet("dimm.trip", "enabled", "false");
                                                                                KnxUtil.uiSet("dimm.trip", "value", "");
                                                                                KnxUtil.uiSet("dimm.trip.val", "enabled", "false");
                                                                                KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                                KnxUtil.uiSet("dimm.del", "visible", "false");
                                                                                KnxUtil.uiSet("dimm.edit", "visible", "false");
                                                                                KnxUtil.uiSet("dimm.new", "visible", "true");
                                                                                return "!page:dimm_edit";
                                                                            }
                                                                            if (!cmd.endsWith("list")) break block62;
                                                                            Knx.Dimmer d3 = selectedServer.getDimmer(param);
                                                                            KnxUtil.uiSet("dimm.id", "enabled", "false");
                                                                            KnxUtil.uiSet("dimm.id", "value", "" + d3.id);
                                                                            KnxUtil.uiSet("dimm.fb.level", "value", d3.fb_level != null ? d3.fb_level.addrString : "");
                                                                            KnxUtil.uiSet("dimm.fb.onoff", "value", d3.fb_onoff != null ? d3.fb_onoff.addrString : "");
                                                                            KnxUtil.uiSet("dimm.cmd.level", "value", d3.cmd_level != null ? d3.cmd_level.addrString : "");
                                                                            KnxUtil.uiSet("dimm.cmd.onoff", "value", d3.cmd_onoff != null ? d3.cmd_onoff.addrString : "");
                                                                            KnxUtil.uiSet("dimm.cmd.step", "value", d3.cmd_step != null ? d3.cmd_step.addrString : "");
                                                                            KnxUtil.uiSet("dimm.on", "value", d3.on);
                                                                            KnxUtil.uiSet("dimm.stepval", "value", d3.stepVal);
                                                                            KnxUtil.uiSet("dimm.descr", "value", d3.description);
                                                                            KnxUtil.uiSet("dimm.thumb", "value", d3.thumbnail != null ? d3.thumbnail : "");
                                                                            if (d3.tripTime == 0) {
                                                                                KnxUtil.uiSet("dimm.dimming", "value", "false");
                                                                                KnxUtil.uiSet("dimm.trip", "enabled", "false");
                                                                                KnxUtil.uiSet("dimm.trip", "value", "");
                                                                                KnxUtil.uiSet("dimm.trip.val", "enabled", "false");
                                                                                KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                            } else if (d3.tripTime < 0) {
                                                                                KnxUtil.uiSet("dimm.dimming", "value", "true");
                                                                                KnxUtil.uiSet("dimm.trip", "enabled", "true");
                                                                                KnxUtil.uiSet("dimm.trip", "value", "auto");
                                                                                KnxUtil.uiSet("dimm.trip.val", "enabled", "false");
                                                                                KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                            } else {
                                                                                KnxUtil.uiSet("dimm.dimming", "value", "true");
                                                                                KnxUtil.uiSet("dimm.trip", "enabled", "true");
                                                                                KnxUtil.uiSet("dimm.trip", "value", "val");
                                                                                KnxUtil.uiSet("dimm.trip.val", "enabled", "true");
                                                                                KnxUtil.uiSet("dimm.trip.val", "value", "" + d3.tripTime);
                                                                            }
                                                                            KnxUtil.uiSet("dimm.del", "visible", "true");
                                                                            KnxUtil.uiSet("dimm.edit", "visible", "true");
                                                                            KnxUtil.uiSet("dimm.new", "visible", "false");
                                                                            return "!page:dimm_edit";
                                                                        }
                                                                        if (!cmd.endsWith("dimming")) break block63;
                                                                        if (param.equals("true")) {
                                                                            KnxUtil.uiSet("dimm.trip", "enabled", "true");
                                                                            KnxUtil.uiSet("dimm.trip", "value", "auto");
                                                                            KnxUtil.uiSet("dimm.trip.val", "enabled", "false");
                                                                            KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                        } else {
                                                                            KnxUtil.uiSet("dimm.trip", "enabled", "false");
                                                                            KnxUtil.uiSet("dimm.trip", "value", "");
                                                                            KnxUtil.uiSet("dimm.trip.val", "enabled", "false");
                                                                            KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                        }
                                                                        return "!";
                                                                    }
                                                                    if (!cmd.endsWith("trip")) break block60;
                                                                    if (param.length() == 0 || param.equals("auto")) {
                                                                        KnxUtil.uiSet("dimm.trip", "value", "auto");
                                                                        KnxUtil.uiSet("dimm.trip.val", "enabled", "false");
                                                                        KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                    } else {
                                                                        KnxUtil.uiSet("dimm.trip.val", "enabled", "true");
                                                                        KnxUtil.uiSet("dimm.trip.val", "value", "");
                                                                    }
                                                                    return "!";
                                                                }
                                                                if (!cmd.startsWith("rgb.")) break block64;
                                                                if (!cmd.endsWith("add")) break block65;
                                                                KnxUtil.uiSet("rgb.id", "enabled", "true");
                                                                KnxUtil.uiSet("rgb.id", "value", "" + (selectedServer.getRgbDPs().size() + 1));
                                                                KnxUtil.uiSet("rgb.fb.rgb", "value", "");
                                                                KnxUtil.uiSet("rgb.fb.onoff", "value", "");
                                                                KnxUtil.uiSet("rgb.cmd.rgb", "value", "");
                                                                KnxUtil.uiSet("rgb.cmd.onoff", "value", "");
                                                                KnxUtil.uiSet("rgb.on", "value", "1");
                                                                KnxUtil.uiSet("rgb.descr", "value", "");
                                                                KnxUtil.uiSet("rgb.descr", "value", "");
                                                                KnxUtil.uiSet("rgb.del", "visible", "false");
                                                                KnxUtil.uiSet("rgb.edit", "visible", "false");
                                                                KnxUtil.uiSet("rgb.new", "visible", "true");
                                                                return "!page:rgb_edit";
                                                            }
                                                            if (!cmd.endsWith("list")) break block64;
                                                            Knx.RGB d4 = selectedServer.getRgb(param);
                                                            KnxUtil.uiSet("rgb.id", "enabled", "false");
                                                            KnxUtil.uiSet("rgb.id", "value", "" + d4.id);
                                                            KnxUtil.uiSet("rgb.fb.rgb", "value", d4.fb_rgb != null ? d4.fb_rgb.addrString : "");
                                                            KnxUtil.uiSet("rgb.fb.onoff", "value", d4.fb_onoff != null ? d4.fb_onoff.addrString : "");
                                                            KnxUtil.uiSet("rgb.cmd.rgb", "value", d4.cmd_rgb != null ? d4.cmd_rgb.addrString : "");
                                                            KnxUtil.uiSet("rgb.cmd.onoff", "value", d4.cmd_onoff != null ? d4.cmd_onoff.addrString : "");
                                                            KnxUtil.uiSet("rgb.on", "value", d4.on);
                                                            KnxUtil.uiSet("rgb.descr", "value", d4.description);
                                                            KnxUtil.uiSet("rgb.del", "visible", "true");
                                                            KnxUtil.uiSet("rgb.edit", "visible", "true");
                                                            KnxUtil.uiSet("rgb.new", "visible", "false");
                                                            return "!page:rgb_edit";
                                                        }
                                                        if (!cmd.startsWith("autom.")) break block66;
                                                        if (!cmd.endsWith("add")) break block67;
                                                        KnxUtil.uiSet("autom.id", "enabled", "true");
                                                        KnxUtil.uiSet("autom.id", "value", "" + (selectedServer.getAutomDPs().size() + 1));
                                                        KnxUtil.uiSet("autom.fb.moving", "value", "");
                                                        KnxUtil.uiSet("autom.fb.position", "value", "");
                                                        KnxUtil.uiSet("autom.fb.stopdown", "value", "");
                                                        KnxUtil.uiSet("autom.fb.stopup", "value", "");
                                                        KnxUtil.uiSet("autom.fb.updown", "value", "");
                                                        KnxUtil.uiSet("autom.cmd.stop", "value", "");
                                                        KnxUtil.uiSet("autom.cmd.updown", "value", "");
                                                        KnxUtil.uiSet("autom.cmd.position", "value", "");
                                                        KnxUtil.uiSet("autom.up", "value", "0");
                                                        KnxUtil.uiSet("autom.closed", "value", "255");
                                                        KnxUtil.uiSet("autom.position", "value", "false");
                                                        KnxUtil.uiSet("autom.trip", "value", "");
                                                        KnxUtil.uiSet("autom.descr", "value", "");
                                                        KnxUtil.uiSet("autom.icon", "value", "VSHUT");
                                                        KnxUtil.uiSet("autom.thumb", "value", "");
                                                        KnxUtil.uiSet("autom.del", "visible", "false");
                                                        KnxUtil.uiSet("autom.edit", "visible", "false");
                                                        KnxUtil.uiSet("autom.new", "visible", "true");
                                                        return "!page:autom_edit";
                                                    }
                                                    if (!cmd.endsWith("list")) break block66;
                                                    Knx.Autom a2 = selectedServer.getAutom(param);
                                                    KnxUtil.uiSet("autom.id", "enabled", "false");
                                                    KnxUtil.uiSet("autom.id", "value", "" + a2.id);
                                                    KnxUtil.uiSet("autom.fb.moving", "value", a2.fb_moving != null ? a2.fb_moving.addrString : "");
                                                    KnxUtil.uiSet("autom.fb.position", "value", a2.fb_position != null ? a2.fb_position.addrString : "");
                                                    KnxUtil.uiSet("autom.fb.stopdown", "value", a2.fb_stopDown != null ? a2.fb_stopDown.addrString : "");
                                                    KnxUtil.uiSet("autom.fb.stopup", "value", a2.fb_stopUp != null ? a2.fb_stopUp.addrString : "");
                                                    KnxUtil.uiSet("autom.fb.updown", "value", a2.fb_upDown != null ? a2.fb_upDown.addrString : "");
                                                    KnxUtil.uiSet("autom.cmd.stop", "value", a2.cmd_stop != null ? a2.cmd_stop.addrString : "");
                                                    KnxUtil.uiSet("autom.cmd.updown", "value", a2.cmd_upDown != null ? a2.cmd_upDown.addrString : "");
                                                    KnxUtil.uiSet("autom.cmd.position", "value", a2.cmd_position != null ? a2.cmd_position.addrString : "");
                                                    KnxUtil.uiSet("autom.up", "value", a2.up);
                                                    KnxUtil.uiSet("autom.closed", "value", a2.closed);
                                                    KnxUtil.uiSet("autom.position", "value", "" + a2.usePosition);
                                                    KnxUtil.uiSet("autom.trip", "value", a2.tripTime > 0 ? "" + a2.tripTime : "");
                                                    KnxUtil.uiSet("autom.descr", "value", a2.description);
                                                    KnxUtil.uiSet("autom.icon", "value", a2.icon);
                                                    KnxUtil.uiSet("autom.thumb", "value", a2.thumbnail != null ? a2.thumbnail : "");
                                                    KnxUtil.uiSet("autom.del", "visible", "true");
                                                    KnxUtil.uiSet("autom.edit", "visible", "true");
                                                    KnxUtil.uiSet("autom.new", "visible", "false");
                                                    return "!page:autom_edit";
                                                }
                                                if (!cmd.startsWith("thermo.")) break block68;
                                                if (!cmd.endsWith("add")) break block69;
                                                KnxUtil.uiSet("thermo.id", "enabled", "true");
                                                KnxUtil.uiSet("thermo.id", "value", "" + (selectedServer.getThermostatDPs().size() + 1));
                                                KnxUtil.uiSet("thermo.fb.setpoint", "value", "");
                                                KnxUtil.uiSet("thermo.fb.status", "value", "");
                                                KnxUtil.uiSet("thermo.fb.temp", "value", "");
                                                KnxUtil.uiSet("thermo.fb.mode", "value", "");
                                                KnxUtil.uiSet("thermo.fb.heating.status", "value", "");
                                                KnxUtil.uiSet("thermo.fb.cooling.status", "value", "");
                                                KnxUtil.uiSet("thermo.cmd.setpoint", "value", "");
                                                KnxUtil.uiSet("thermo.cmd.setpoint.mode", "value", "");
                                                KnxUtil.uiSet("thermo.unit", "value", "C");
                                                KnxUtil.uiSet("thermo.descr", "value", "");
                                                KnxUtil.uiSet("thermo.del", "visible", "false");
                                                KnxUtil.uiSet("thermo.edit", "visible", "false");
                                                KnxUtil.uiSet("thermo.new", "visible", "true");
                                                return "!page:thermo_edit";
                                            }
                                            if (!cmd.endsWith("list")) break block68;
                                            Knx.Thermostat t = selectedServer.getThermostat(param);
                                            KnxUtil.uiSet("thermo.id", "enabled", "false");
                                            KnxUtil.uiSet("thermo.id", "value", "" + t.id);
                                            KnxUtil.uiSet("thermo.fb.setpoint", "value", t.fb_setpoint != null ? t.fb_setpoint.addrString : "");
                                            KnxUtil.uiSet("thermo.fb.status", "value", t.fb_status != null ? t.fb_status.addrString : "");
                                            KnxUtil.uiSet("thermo.fb.temp", "value", t.fb_temp != null ? t.fb_temp.addrString : "");
                                            KnxUtil.uiSet("thermo.fb.mode", "value", t.fb_mode != null ? t.fb_mode.addrString : "");
                                            KnxUtil.uiSet("thermo.fb.heating.status", "value", t.fb_heating_status != null ? t.fb_heating_status.addrString : "");
                                            KnxUtil.uiSet("thermo.fb.cooling.status", "value", t.fb_cooling_status != null ? t.fb_cooling_status.addrString : "");
                                            KnxUtil.uiSet("thermo.cmd.setpoint", "value", t.cmd_setpoint != null ? t.cmd_setpoint.addrString : "");
                                            KnxUtil.uiSet("thermo.cmd.setpoint.mode", "value", t.cmd_setpoint_mode != null ? t.cmd_setpoint_mode.addrString : "");
                                            KnxUtil.uiSet("thermo.unit", "value", t.unit);
                                            KnxUtil.uiSet("thermo.descr", "value", t.description);
                                            KnxUtil.uiSet("thermo.del", "visible", "true");
                                            KnxUtil.uiSet("thermo.edit", "visible", "true");
                                            KnxUtil.uiSet("thermo.new", "visible", "false");
                                            return "!page:thermo_edit";
                                        }
                                        if (!cmd.startsWith("import.")) break block70;
                                        if (!cmd.endsWith("open")) break block71;
                                        KnxUtil.uiSet("import.file", "value", "");
                                        KnxUtil.uiSet("import.keep", "value", "true");
                                        return "!page:import";
                                    }
                                    if (!cmd.endsWith("close")) break block70;
                                    return "!page:menu";
                                }
                                if (!cmd.equals("commit")) break block72;
                                selectedServer.commitConfiguration();
                                return "!page:close";
                            }
                            if (!cmd.startsWith("monitor.")) break block73;
                            if (!cmd.endsWith("start")) break block74;
                            KnxUtil.uiSet("monitor.start", "visible", "false");
                            KnxUtil.uiSet("monitor.stop", "visible", "true");
                            KnxUtil.uiSet("monitor.tools", "enabled", "true");
                            KnxUtil.uiSet("monitor.status", "text", "Monitoring...");
                            KnxUtil.uiSet("monitor.status", "blink", "true");
                            monitorActive = true;
                            return "!";
                        }
                        if (!cmd.endsWith("stop")) break block75;
                        KnxUtil.uiSet("monitor.start", "visible", "true");
                        KnxUtil.uiSet("monitor.stop", "visible", "false");
                        KnxUtil.uiSet("monitor.tools", "enabled", "false");
                        KnxUtil.uiSet("monitor.status", "text", "Stopped");
                        KnxUtil.uiSet("monitor.status", "blink", "false");
                        monitorActive = false;
                        if (scanner != null) {
                            scanner.interrupt();
                        }
                        return "!";
                    }
                    if (!cmd.endsWith("list")) break block76;
                    String addr = param.split("-")[1];
                    KnxUtil.uiSet("monitor.address", "value", addr);
                    return "!";
                }
                if (!cmd.endsWith("clear")) break block77;
                frames.clear();
                KnxUtil.updateSortedList(frames, "monitor.list");
                return "!";
            }
            if (!cmd.endsWith("dpt")) break block73;
            if (param.equals("18")) {
                KnxUtil.uiSet("monitor.dpt18", "visible", "true");
                KnxUtil.uiSet("monitor.value", "visible", "false");
            } else {
                KnxUtil.uiSet("monitor.dpt18", "visible", "false");
                KnxUtil.uiSet("monitor.value", "visible", "true");
            }
            KnxUtil.uiSet("monitor.value", "value", "");
            KnxUtil.uiSet("monitor.value18", "value", "");
            KnxUtil.uiSet("monitor.scene18", "value", "");
            return "!";
        }
        try {
            throw new Exception("Unknown command");
        }
        catch (WarningException e2) {
            KnxUtil.uiSet("warning.message", "text", e2.getLocalizedMessage());
            KnxUtil.log(1, "WarningException: " + e2.getLocalizedMessage());
            return "!page:warning";
        }
        catch (Throwable e3) {
            KnxUtil.log(0, "error processing command '" + cmd + " = " + param + "' - " + KnxUtil.getStackTrace(e3));
            return "!error";
        }
    }

    public static String userSubmit(String session, String userid, String cmd, HashMap<String, String> submitted) {
        block120: {
            Knx selectedServer;
            block122: {
                block121: {
                    block119: {
                        block117: {
                            block118: {
                                block115: {
                                    block116: {
                                        block113: {
                                            block114: {
                                                block111: {
                                                    block112: {
                                                        String trip;
                                                        block109: {
                                                            block110: {
                                                                block107: {
                                                                    block108: {
                                                                        block106: {
                                                                            if (cmd.startsWith(PREFIX)) break block106;
                                                                            return null;
                                                                        }
                                                                        cmd = cmd.substring(PREFIX.length());
                                                                        KnxUtil.log(1, "processing submit command '" + cmd + "'");
                                                                        selectedServer = Knx.getInstance(selectedServerName);
                                                                        if (selectedServer == null) {
                                                                            throw new WarningException("No KNX Server selected");
                                                                        }
                                                                        if (!cmd.startsWith("dp.")) break block107;
                                                                        if (!cmd.endsWith("new") && !cmd.endsWith("edit")) break block108;
                                                                        String addr = submitted.get("__hsyco__knxutil.dp.address");
                                                                        String dpt = submitted.get("__hsyco__knxutil.dp.dpt");
                                                                        String id = submitted.get("__hsyco__knxutil.dp.id");
                                                                        String descr = submitted.get("__hsyco__knxutil.dp.descr");
                                                                        String priority = submitted.get("__hsyco__knxutil.dp.priority");
                                                                        String icon = submitted.get("__hsyco__knxutil.dp.icon");
                                                                        String thumb = submitted.get("__hsyco__knxutil.dp.thumb");
                                                                        boolean read = Boolean.parseBoolean(submitted.get("__hsyco__knxutil.dp.read"));
                                                                        if (icon.equals("")) {
                                                                            icon = null;
                                                                        }
                                                                        if (thumb.equals("")) {
                                                                            thumb = null;
                                                                        }
                                                                        try {
                                                                            try {
                                                                                if (cmd.endsWith("new")) {
                                                                                    selectedServer.addDatapoint(dpt, addr, id, descr, priority, read, icon, thumb);
                                                                                }
                                                                                selectedServer.editDatapoint(dpt, addr, id, descr, priority, read, icon, thumb);
                                                                            }
                                                                            catch (Exception e2) {
                                                                                throw new WarningException(e2.getLocalizedMessage());
                                                                            }
                                                                        }
                                                                        finally {
                                                                            KnxUtil.showDatapoints();
                                                                        }
                                                                    }
                                                                    if (!cmd.endsWith("del")) break block107;
                                                                    String addr = submitted.get("__hsyco__knxutil.dp.address");
                                                                    try {
                                                                        try {
                                                                            selectedServer.deleteDatapoint(addr);
                                                                        }
                                                                        catch (Exception e3) {
                                                                            throw new WarningException(e3.getLocalizedMessage());
                                                                        }
                                                                    }
                                                                    finally {
                                                                        KnxUtil.showDatapoints();
                                                                    }
                                                                }
                                                                if (!cmd.startsWith("light.")) break block109;
                                                                if (!cmd.endsWith("new") && !cmd.endsWith("edit")) break block110;
                                                                String id = submitted.get("__hsyco__knxutil.light.id");
                                                                String fbOnOff = submitted.get("__hsyco__knxutil.light.fb");
                                                                String cmdOnOff = submitted.get("__hsyco__knxutil.light.cmd");
                                                                String on = submitted.get("__hsyco__knxutil.light.on");
                                                                String descr = submitted.get("__hsyco__knxutil.light.descr");
                                                                String icon = submitted.get("__hsyco__knxutil.light.icon");
                                                                String thumb = submitted.get("__hsyco__knxutil.light.thumb");
                                                                try {
                                                                    try {
                                                                        selectedServer.addLight(id, fbOnOff, cmdOnOff, on, descr, icon, thumb, cmd.endsWith("edit"));
                                                                    }
                                                                    catch (Exception e4) {
                                                                        throw new WarningException(e4.getLocalizedMessage());
                                                                    }
                                                                }
                                                                finally {
                                                                    KnxUtil.showDatapoints();
                                                                }
                                                            }
                                                            if (!cmd.endsWith("del")) break block109;
                                                            String id = submitted.get("__hsyco__knxutil.light.id");
                                                            try {
                                                                try {
                                                                    selectedServer.deleteLight(id);
                                                                }
                                                                catch (Exception e5) {
                                                                    throw new WarningException(e5.getLocalizedMessage());
                                                                }
                                                            }
                                                            finally {
                                                                KnxUtil.showDatapoints();
                                                            }
                                                        }
                                                        if (!cmd.startsWith("dimm.")) break block111;
                                                        if (!cmd.endsWith("new") && !cmd.endsWith("edit")) break block112;
                                                        String id = submitted.get("__hsyco__knxutil.dimm.id");
                                                        String fbLevel = submitted.get("__hsyco__knxutil.dimm.fb.level");
                                                        String fbOnOff = submitted.get("__hsyco__knxutil.dimm.fb.onoff");
                                                        String cmdLevel = submitted.get("__hsyco__knxutil.dimm.cmd.level");
                                                        String cmdOnOff = submitted.get("__hsyco__knxutil.dimm.cmd.onoff");
                                                        String cmdStep = submitted.get("__hsyco__knxutil.dimm.cmd.step");
                                                        String stepVal = submitted.get("__hsyco__knxutil.dimm.stepval");
                                                        String on = submitted.get("__hsyco__knxutil.dimm.on");
                                                        String descr = submitted.get("__hsyco__knxutil.dimm.descr");
                                                        String thumb = submitted.get("__hsyco__knxutil.dimm.thumb");
                                                        String dimming = submitted.get("__hsyco__knxutil.dimm.dimming");
                                                        if (dimming.equals("true")) {
                                                            trip = submitted.get("__hsyco__knxutil.dimm.trip");
                                                            if (!trip.equals("auto")) {
                                                                trip = submitted.get("__hsyco__knxutil.dimm.trip.val");
                                                            }
                                                        } else {
                                                            trip = "0";
                                                        }
                                                        try {
                                                            try {
                                                                selectedServer.addDimmer(id, fbLevel, fbOnOff, cmdLevel, cmdOnOff, cmdStep, stepVal, on, trip, descr, thumb, cmd.endsWith("edit"));
                                                            }
                                                            catch (Exception e6) {
                                                                throw new WarningException(e6.getLocalizedMessage());
                                                            }
                                                        }
                                                        finally {
                                                            KnxUtil.showDatapoints();
                                                        }
                                                    }
                                                    if (!cmd.endsWith("del")) break block111;
                                                    String id = submitted.get("__hsyco__knxutil.dimm.id");
                                                    try {
                                                        try {
                                                            selectedServer.deleteDimmer(id);
                                                        }
                                                        catch (Exception e7) {
                                                            throw new WarningException(e7.getLocalizedMessage());
                                                        }
                                                    }
                                                    finally {
                                                        KnxUtil.showDatapoints();
                                                    }
                                                }
                                                if (!cmd.startsWith("rgb.")) break block113;
                                                if (!cmd.endsWith("new") && !cmd.endsWith("edit")) break block114;
                                                String id = submitted.get("__hsyco__knxutil.rgb.id");
                                                String fbRgb = submitted.get("__hsyco__knxutil.rgb.fb.rgb");
                                                String fbOnOff = submitted.get("__hsyco__knxutil.rgb.fb.onoff");
                                                String cmdRgb = submitted.get("__hsyco__knxutil.rgb.cmd.rgb");
                                                String cmdOnOff = submitted.get("__hsyco__knxutil.rgb.cmd.onoff");
                                                String on = submitted.get("__hsyco__knxutil.rgb.on");
                                                String descr = submitted.get("__hsyco__knxutil.rgb.descr");
                                                try {
                                                    try {
                                                        selectedServer.addRgb(id, fbRgb, fbOnOff, cmdRgb, cmdOnOff, on, descr, cmd.endsWith("edit"));
                                                    }
                                                    catch (Exception e8) {
                                                        throw new WarningException(e8.getLocalizedMessage());
                                                    }
                                                }
                                                finally {
                                                    KnxUtil.showDatapoints();
                                                }
                                            }
                                            if (!cmd.endsWith("del")) break block113;
                                            String id = submitted.get("__hsyco__knxutil.rgb.id");
                                            try {
                                                try {
                                                    selectedServer.deleteRgb(id);
                                                }
                                                catch (Exception e9) {
                                                    throw new WarningException(e9.getLocalizedMessage());
                                                }
                                            }
                                            finally {
                                                KnxUtil.showDatapoints();
                                            }
                                        }
                                        if (!cmd.startsWith("autom.")) break block115;
                                        if (!cmd.endsWith("new") && !cmd.endsWith("edit")) break block116;
                                        String id = submitted.get("__hsyco__knxutil.autom.id");
                                        String fbMov = submitted.get("__hsyco__knxutil.autom.fb.moving");
                                        String fbPos = submitted.get("__hsyco__knxutil.autom.fb.position");
                                        String fbStopDown = submitted.get("__hsyco__knxutil.autom.fb.stopdown");
                                        String fbStopUp = submitted.get("__hsyco__knxutil.autom.fb.stopup");
                                        String fbUpDown = submitted.get("__hsyco__knxutil.autom.fb.updown");
                                        String cmdStop = submitted.get("__hsyco__knxutil.autom.cmd.stop");
                                        String cmdUpDown = submitted.get("__hsyco__knxutil.autom.cmd.updown");
                                        String cmdPosition = submitted.get("__hsyco__knxutil.autom.cmd.position");
                                        String usePosition = submitted.get("__hsyco__knxutil.autom.position");
                                        String trip = submitted.get("__hsyco__knxutil.autom.trip");
                                        String up = submitted.get("__hsyco__knxutil.autom.up");
                                        String closed = submitted.get("__hsyco__knxutil.autom.closed");
                                        String descr = submitted.get("__hsyco__knxutil.autom.descr");
                                        String iconb = submitted.get("__hsyco__knxutil.autom.icon");
                                        String thumb = submitted.get("__hsyco__knxutil.autom.thumb");
                                        try {
                                            try {
                                                selectedServer.addAutom(id, fbMov, fbPos, fbStopDown, fbStopUp, fbUpDown, cmdStop, cmdUpDown, cmdPosition, usePosition, trip, up, closed, descr, iconb, thumb, cmd.endsWith("edit"));
                                            }
                                            catch (Exception e10) {
                                                throw new WarningException(e10.getLocalizedMessage());
                                            }
                                        }
                                        finally {
                                            KnxUtil.showDatapoints();
                                        }
                                    }
                                    if (!cmd.endsWith("del")) break block115;
                                    String id = submitted.get("__hsyco__knxutil.autom.id");
                                    try {
                                        try {
                                            selectedServer.deleteAutom(id);
                                        }
                                        catch (Exception e11) {
                                            throw new WarningException(e11.getLocalizedMessage());
                                        }
                                    }
                                    finally {
                                        KnxUtil.showDatapoints();
                                    }
                                }
                                if (!cmd.startsWith("thermo.")) break block117;
                                if (!cmd.endsWith("new") && !cmd.endsWith("edit")) break block118;
                                String id = submitted.get("__hsyco__knxutil.thermo.id");
                                String fbSetpoint = submitted.get("__hsyco__knxutil.thermo.fb.setpoint");
                                String fbStatus = submitted.get("__hsyco__knxutil.thermo.fb.status");
                                String fbTemp = submitted.get("__hsyco__knxutil.thermo.fb.temp");
                                String fbMode = submitted.get("__hsyco__knxutil.thermo.fb.mode");
                                String fbHeatingSt = submitted.get("__hsyco__knxutil.thermo.fb.heating.status");
                                String fbCoolingSt = submitted.get("__hsyco__knxutil.thermo.fb.cooling.status");
                                String cmdSetpoint = submitted.get("__hsyco__knxutil.thermo.cmd.setpoint");
                                String cmdSetpointMode = submitted.get("__hsyco__knxutil.thermo.cmd.setpoint.mode");
                                String unit = submitted.get("__hsyco__knxutil.thermo.unit");
                                String descr = submitted.get("__hsyco__knxutil.thermo.descr");
                                try {
                                    try {
                                        selectedServer.addThermostat(id, fbSetpoint, fbStatus, fbTemp, fbMode, fbHeatingSt, fbCoolingSt, cmdSetpoint, cmdSetpointMode, unit, descr, cmd.endsWith("edit"));
                                    }
                                    catch (Exception e12) {
                                        throw new WarningException(e12.getLocalizedMessage());
                                    }
                                }
                                finally {
                                    KnxUtil.showDatapoints();
                                }
                            }
                            if (!cmd.endsWith("del")) break block117;
                            String id = submitted.get("__hsyco__knxutil.thermo.id");
                            try {
                                try {
                                    selectedServer.deleteThermostat(id);
                                }
                                catch (Exception e13) {
                                    throw new WarningException(e13.getLocalizedMessage());
                                }
                            }
                            finally {
                                KnxUtil.showDatapoints();
                            }
                        }
                        if (!cmd.startsWith("import.") || !cmd.endsWith("ok")) break block119;
                        final String file = submitted.get("__hsyco__knxutil.import.file").trim();
                        final boolean keep = Boolean.parseBoolean(submitted.get("__hsyco__knxutil.import.keep"));
                        if (file.length() == 0) {
                            throw new WarningException("No file specified.");
                        }
                        KnxUtil.uiSet("import.wait.close", "visible", "false");
                        KnxUtil.uiSet("import.wait.message", "text", "Loading project...");
                        new Thread(){

                            @Override
                            public void run() {
                                String err = null;
                                try {
                                    err = selectedServer.importETS4Project(file, keep);
                                    if (err != null) {
                                        err = "Import errors:<br />" + err;
                                    }
                                }
                                catch (Exception e2) {
                                    err = "Import failed: " + e2.getLocalizedMessage();
                                }
                                if (err == null) {
                                    KnxUtil.uiSet("import.wait.message", "text", "Import complete");
                                } else {
                                    KnxUtil.uiSet("import.wait.message", "text", err);
                                }
                                KnxUtil.uiSet("import.wait.close", "visible", "true");
                                KnxUtil.showDatapoints();
                            }
                        }.start();
                        return "!page:import_wait";
                    }
                    if (!cmd.startsWith("monitor.")) break block120;
                    if (!cmd.endsWith("write")) break block121;
                    String addr = submitted.get("__hsyco__knxutil.monitor.address").trim();
                    String dpt = submitted.get("__hsyco__knxutil.monitor.dpt").trim();
                    String val = submitted.get("__hsyco__knxutil.monitor.value").trim();
                    String val18 = submitted.get("__hsyco__knxutil.monitor.value18").trim();
                    String scene18 = submitted.get("__hsyco__knxutil.monitor.scene18").trim();
                    KnxUtil.uiSet("monitor.address", "value", addr);
                    KnxUtil.uiSet("monitor.dpt", "value", dpt);
                    if (addr.length() == 0) {
                        throw new WarningException("Enter a group address.");
                    }
                    if (dpt.length() == 0) {
                        throw new WarningException("Select a DPT.");
                    }
                    try {
                        if (dpt.equals("18")) {
                            selectedServer.writeDPT18(addr, val18, scene18);
                        } else {
                            selectedServer.write(dpt, addr, val);
                        }
                    }
                    catch (Exception e14) {
                        throw new WarningException(e14.getLocalizedMessage());
                    }
                    return "!";
                }
                if (!cmd.endsWith("read")) break block122;
                String addr = submitted.get("__hsyco__knxutil.monitor.address").trim();
                String dpt = submitted.get("__hsyco__knxutil.monitor.dpt").trim();
                KnxUtil.uiSet("monitor.address", "value", addr);
                KnxUtil.uiSet("monitor.dpt", "value", dpt);
                if (addr.length() == 0) {
                    throw new WarningException("Enter a group address.");
                }
                if (dpt.length() == 0) {
                    throw new WarningException("Select a DPT.");
                }
                KnxUtil.uiSet("monitor.tools", "enabled", "false");
                KnxUtil.uiSet("monitor.value", "value", "");
                KnxUtil.uiSet("monitor.value18", "value", "");
                KnxUtil.uiSet("monitor.scene18", "value", "");
                try {
                    String val = selectedServer.read(dpt, addr, true);
                    if (val == null) {
                        KnxUtil.uiSet("monitor.value", "value", "error");
                        KnxUtil.uiSet("monitor.value18", "value", "error");
                    } else if (dpt.equals("18")) {
                        String[] sc_val = val.split("/");
                        KnxUtil.uiSet("monitor.scene18", "value", sc_val[0]);
                        KnxUtil.uiSet("monitor.value18", "value", sc_val[1]);
                    } else {
                        KnxUtil.uiSet("monitor.value", "value", val);
                    }
                }
                catch (Exception e15) {
                    throw new WarningException(e15.getLocalizedMessage());
                }
                KnxUtil.uiSet("monitor.tools", "enabled", "true");
                return "!";
            }
            if (!cmd.endsWith("scan")) break block120;
            String from = submitted.get("__hsyco__knxutil.monitor.scan.from").trim();
            String to = submitted.get("__hsyco__knxutil.monitor.scan.to").trim();
            String[] from123 = from.split("/");
            if (from123.length != 3) {
                throw new Exception("illegal address '" + from + "': must use format X/Y/Z");
            }
            int from1 = Integer.parseInt(from123[0].trim());
            int from2 = Integer.parseInt(from123[1].trim());
            int from3 = Integer.parseInt(from123[2].trim());
            if (from1 < 0 || from1 > 31 || from2 < 0 || from2 > 7 || from3 < 0 || from3 > 255 || from1 == 0 && from2 == 0 && from3 == 0) {
                throw new Exception("illegal address '" + from + "': out of range [0/0/1 - 31/7/255]");
            }
            String[] to123 = to.split("/");
            if (to123.length != 3) {
                throw new Exception("illegal address '" + to + "': must use format X/Y/Z");
            }
            int to1 = Integer.parseInt(to123[0].trim());
            int to2 = Integer.parseInt(to123[1].trim());
            int to3 = Integer.parseInt(to123[2].trim());
            if (to1 < 0 || to1 > 31 || to2 < 0 || to2 > 7 || to3 < 0 || to3 > 255 || to1 == 0 && to2 == 0 && to3 == 0) {
                throw new Exception("illegal address '" + to + "': out of range [0/0/1 - 31/7/255]");
            }
            scanner = new Scanner(selectedServer, from1, from2, from3, to1, to2, to3);
            return "!";
        }
        try {
            throw new Exception("Unknown command");
        }
        catch (WarningException e16) {
            KnxUtil.uiSet("warning.message", "text", e16.getLocalizedMessage());
            KnxUtil.log(1, "WarningException: " + e16.getLocalizedMessage());
            return "!page:warning";
        }
        catch (Throwable e17) {
            KnxUtil.log(0, "error processing submit command '" + cmd + "' - " + KnxUtil.getStackTrace(e17));
            return "!error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processFrame(String serverName, byte[] data, String sourceAddr, String destAddr, boolean isResponse) {
        try {
            if (!serverName.equals(selectedServerName)) return;
            if (!monitorActive) {
                return;
            }
            while (true) {
                if (frames.size() <= 1000) {
                    frames.add(0, new Frame(System.currentTimeMillis(), sourceAddr, destAddr, data));
                    KnxUtil.updateSortedList(frames, "monitor.list");
                    return;
                }
                frames.remove(1000);
            }
        }
        catch (Exception e2) {
            KnxUtil.log(0, "error processing KNX frame (" + serverName + ") - " + KnxUtil.getStackTrace(e2));
        }
    }

    private static void showDatapoints() {
        Knx selectedServer = Knx.getInstance(selectedServerName);
        KnxUtil.updateList(selectedServer.getDatapoints(), "dp.list");
        KnxUtil.updateList(selectedServer.getLightDPs(), "light.list");
        KnxUtil.updateList(selectedServer.getDimmerDPs(), "dimm.list");
        KnxUtil.updateList(selectedServer.getRgbDPs(), "rgb.list");
        KnxUtil.updateList(selectedServer.getAutomDPs(), "autom.list");
        KnxUtil.updateList(selectedServer.getThermostatDPs(), "thermo.list");
        Collection<Knx.Datapoint> dps = selectedServer.getDatapoints();
        ArrayList<Knx.Datapoint> dps1 = new ArrayList<Knx.Datapoint>();
        ArrayList<Knx.Datapoint> dps3 = new ArrayList<Knx.Datapoint>();
        ArrayList<Knx.Datapoint> dps5 = new ArrayList<Knx.Datapoint>();
        ArrayList<Knx.Datapoint> dps9 = new ArrayList<Knx.Datapoint>();
        ArrayList<Knx.Datapoint> dps232 = new ArrayList<Knx.Datapoint>();
        for (Knx.Datapoint dp : dps) {
            if (dp instanceof Knx.DatapointDPT1) {
                dps1.add(dp);
                continue;
            }
            if (dp instanceof Knx.DatapointDPT3) {
                dps3.add(dp);
                continue;
            }
            if (dp instanceof Knx.DatapointDPT5) {
                dps5.add(dp);
                continue;
            }
            if (dp instanceof Knx.DatapointDPT9) {
                dps9.add(dp);
                continue;
            }
            if (!(dp instanceof Knx.DatapointDPT232)) continue;
            dps232.add(dp);
        }
        KnxUtil.updateList(dps1, "light.fb");
        KnxUtil.updateList(dps1, "light.cmd");
        KnxUtil.updateList(dps1, "dimm.fb.onoff");
        KnxUtil.updateList(dps1, "dimm.cmd.onoff");
        KnxUtil.updateList(dps1, "rgb.fb.onoff");
        KnxUtil.updateList(dps1, "rgb.cmd.onoff");
        KnxUtil.updateList(dps1, "autom.fb.updown");
        KnxUtil.updateList(dps1, "autom.fb.moving");
        KnxUtil.updateList(dps1, "autom.fb.stopup");
        KnxUtil.updateList(dps1, "autom.fb.stopdown");
        KnxUtil.updateList(dps1, "autom.cmd.updown");
        KnxUtil.updateList(dps1, "autom.cmd.stop");
        KnxUtil.updateList(dps1, "thermo.fb.mode");
        KnxUtil.updateList(dps3, "dimm.cmd.step");
        KnxUtil.updateList(dps5, "dimm.fb.level");
        KnxUtil.updateList(dps5, "dimm.cmd.level");
        KnxUtil.updateList(dps5, "autom.fb.position");
        KnxUtil.updateList(dps5, "autom.cmd.position");
        KnxUtil.updateList(dps5, "thermo.fb.status");
        KnxUtil.updateList(dps5, "thermo.fb.heating.status");
        KnxUtil.updateList(dps5, "thermo.fb.cooling.status");
        KnxUtil.updateList(dps5, "thermo.cmd.setpoint.mode");
        KnxUtil.updateList(dps9, "thermo.fb.setpoint");
        KnxUtil.updateList(dps9, "thermo.fb.temp");
        KnxUtil.updateList(dps9, "thermo.cmd.setpoint");
        KnxUtil.updateList(dps232, "rgb.fb.rgb");
        KnxUtil.updateList(dps232, "rgb.cmd.rgb");
    }

    static <T extends Comparable<T>> void updateList(Collection<T> list, String listId) {
        ArrayList<T> sortedValues = null;
        if (list != null) {
            sortedValues = new ArrayList<T>(list);
            Collections.sort(sortedValues, new Comparator<T>(){

                @Override
                public int compare(T a2, T b2) {
                    return a2.compareTo(b2);
                }
            });
        }
        KnxUtil.updateSortedList(sortedValues, listId);
    }

    static void updateSortedList(List<? extends Object> sortedValues, String listId) {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        if (sortedValues != null) {
            for (Object object : sortedValues) {
                values.append(',').append(KnxUtil.getListId(object));
                labels.append(',').append(KnxUtil.getListLabel(object, listId));
            }
        }
        KnxUtil.uiSet(listId, "values", values.length() > 0 ? values.substring(1) : "");
        KnxUtil.uiSet(listId, "labels", labels.length() > 0 ? labels.substring(1) : "");
    }

    private static String getListId(Object e2) {
        if (e2 instanceof Knx.Datapoint) {
            return ((Knx.Datapoint)e2).addrString;
        }
        if (e2 instanceof Knx.Light) {
            return "" + ((Knx.Light)e2).id;
        }
        if (e2 instanceof Knx.Dimmer) {
            return "" + ((Knx.Dimmer)e2).id;
        }
        if (e2 instanceof Knx.RGB) {
            return "" + ((Knx.RGB)e2).id;
        }
        if (e2 instanceof Knx.Autom) {
            return "" + ((Knx.Autom)e2).id;
        }
        if (e2 instanceof Knx.Thermostat) {
            return "" + ((Knx.Thermostat)e2).id;
        }
        if (e2 instanceof Frame) {
            return ((Frame)e2).ts + "-" + ((Frame)e2).destination;
        }
        return null;
    }

    private static String getListLabel(Object e2, String list) {
        StringBuilder sb = new StringBuilder();
        if (e2 instanceof Knx.Datapoint) {
            Knx.Datapoint d2 = (Knx.Datapoint)e2;
            if (list.endsWith(".list")) {
                sb.append(d2.id).append(" - ").append(d2.description != null ? d2.description : "").append("<div style=\"font-size:12px\">");
                sb.append("Address: ").append(d2.addrString).append("&emsp;&emsp;&emsp;&emsp;");
                sb.append("DPT: ");
                if (d2 instanceof Knx.DatapointGeneric) {
                    sb.append(((Knx.DatapointGeneric)d2).bytes).append('B');
                } else {
                    sb.append(d2.dpt);
                }
                sb.append("&emsp;&emsp;&emsp;&emsp;");
                sb.append("Priority: ").append(d2.priorityString);
                sb.append("</div>");
            } else {
                sb.append(d2.id).append("&nbsp;-&nbsp;").append(d2.description.replaceAll("\\s+", "&nbsp;") != null ? d2.description : "");
            }
        } else if (e2 instanceof Knx.Light) {
            Knx.Light d3 = (Knx.Light)e2;
            sb.append(d3.prefix).append(" - ").append(d3.description).append("<div style=\"font-size:12px\">");
            if (d3.fb_onoff != null) {
                sb.append("On/Off FB: ").append(d3.fb_onoff.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d3.cmd_onoff != null) {
                sb.append("On/Off CMD: ").append(d3.cmd_onoff.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            sb.append("On value: ").append(d3.on);
            sb.append("</div>");
        } else if (e2 instanceof Knx.Dimmer) {
            Knx.Dimmer d4 = (Knx.Dimmer)e2;
            sb.append(d4.prefix).append(" - ").append(d4.description).append("<div style=\"font-size:12px\">");
            if (d4.fb_level != null) {
                sb.append("Level FB: ").append(d4.fb_level.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d4.fb_onoff != null) {
                sb.append("On/Off FB: ").append(d4.fb_onoff.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d4.cmd_level != null) {
                sb.append("Level CMD: ").append(d4.cmd_level.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d4.cmd_onoff != null) {
                sb.append("On/Off CMD: ").append(d4.cmd_onoff.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            sb.append("On value: ").append(d4.on);
            sb.append("</div>");
        } else if (e2 instanceof Knx.RGB) {
            Knx.RGB r = (Knx.RGB)e2;
            sb.append(r.prefix).append(" - ").append(r.description).append("<div style=\"font-size:12px\">");
            if (r.fb_rgb != null) {
                sb.append("RGB FB: ").append(r.fb_rgb.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (r.fb_onoff != null) {
                sb.append("On/Off FB: ").append(r.fb_onoff.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (r.cmd_rgb != null) {
                sb.append("Level CMD: ").append(r.cmd_rgb.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (r.cmd_onoff != null) {
                sb.append("On/Off CMD: ").append(r.cmd_onoff.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            sb.append("On value: ").append(r.on);
            sb.append("</div>");
        } else if (e2 instanceof Knx.Autom) {
            Knx.Autom d5 = (Knx.Autom)e2;
            sb.append(d5.prefix).append(" - ").append(d5.description).append("<div style=\"font-size:12px\">");
            if (d5.fb_position != null) {
                sb.append("Position FB: ").append(d5.fb_position.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.fb_moving != null) {
                sb.append("Moving FB: ").append(d5.fb_moving.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.fb_upDown != null) {
                sb.append("Up/Down FB: ").append(d5.fb_upDown.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.fb_stopUp != null) {
                sb.append("Stop up FB: ").append(d5.fb_stopUp.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.fb_stopDown != null) {
                sb.append("Stop down FB: ").append(d5.fb_stopDown.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.cmd_upDown != null) {
                sb.append("Up/Down CMD: ").append(d5.cmd_upDown.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.cmd_position != null) {
                sb.append("Position CMD: ").append(d5.cmd_position.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d5.cmd_stop != null) {
                sb.append("Stop CMD: ").append(d5.cmd_stop.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            sb.append("Up value: ").append(d5.up).append("&emsp;&emsp;&emsp;&emsp;");
            sb.append("Closed value: ").append(d5.closed).append("&emsp;&emsp;&emsp;&emsp;");
            if (d5.tripTime > 0) {
                sb.append("Trip time: ").append(d5.tripTime).append("&emsp;&emsp;&emsp;&emsp;");
            }
            sb.append("Use position: ").append(d5.usePosition);
            sb.append("</div>");
        } else if (e2 instanceof Knx.Thermostat) {
            Knx.Thermostat d6 = (Knx.Thermostat)e2;
            sb.append(d6.prefix).append(" - ").append(d6.description).append("<div style=\"font-size:12px\">");
            if (d6.fb_setpoint != null) {
                sb.append("Setpoint FB: ").append(d6.fb_setpoint.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.fb_temp != null) {
                sb.append("Temperature FB: ").append(d6.fb_temp.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.fb_status != null) {
                sb.append("Setpoint Mode FB: ").append(d6.fb_status.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.fb_cooling_status != null) {
                sb.append("Cooling Status FB: ").append(d6.fb_cooling_status.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.fb_heating_status != null) {
                sb.append("Heating Status FB: ").append(d6.fb_heating_status.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.fb_mode != null) {
                sb.append("Mode FB: ").append(d6.fb_mode.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.cmd_setpoint != null) {
                sb.append("Setpoint CMD: ").append(d6.cmd_setpoint.id).append("&emsp;&emsp;&emsp;&emsp;");
            }
            if (d6.cmd_setpoint_mode != null) {
                sb.append("Setpoint Mode CMD: ").append(d6.cmd_setpoint_mode.id);
            }
            sb.append("</div>");
        } else if (e2 instanceof Frame) {
            Frame f2 = (Frame)e2;
            sb.append(Frame.DATE_FORMAT.format(f2.ts)).append(" - ");
            sb.append("Destination: ").append(f2.destination);
            Knx.Datapoint d7 = null;
            try {
                Knx selectedServer = Knx.getInstance(selectedServerName);
                d7 = selectedServer.getDatapoint(f2.destination);
                if (d7 != null) {
                    sb.append(" (").append(d7.id).append(" - ").append(d7.description != null ? d7.description : "").append(")");
                }
            }
            catch (Exception selectedServer) {
                // empty catch block
            }
            sb.append(" Source: ").append(f2.source);
            sb.append("<br />Data: ");
            int i2 = 0;
            while (i2 < f2.data.length) {
                sb.append(Integer.toHexString(f2.data[i2] & 0xFF | 0x100).substring(1).toUpperCase()).append(" ");
                ++i2;
            }
            if (d7 != null) {
                sb.append(" [");
                try {
                    sb.append(d7.userDataToStringValue(f2.data));
                }
                catch (Exception ex) {
                    sb.append("?");
                }
                sb.append("]");
            }
        }
        return sb.toString().replace(",", "&#44;");
    }

    public static void uiSet(String id, String attr, String value) {
        userBase.uiSet("__hsyco__knxutil.scope!", PREFIX + id, attr, value);
    }

    public static String uiGet(String id, String attr) {
        return userBase.uiGet(PREFIX + id, attr);
    }

    static String getStackTrace(Throwable e2) {
        try {
            StringWriter sw = new StringWriter();
            sw.append(e2.getLocalizedMessage());
            if (Configuration.verboseLog) {
                sw.append("\n\t");
                e2.printStackTrace(new PrintWriter(sw));
            }
            return sw.toString();
        }
        catch (Throwable t) {
            e2.printStackTrace();
            t.printStackTrace();
            return "check 'console.log'";
        }
    }

    static void log(int tag, String message) {
        switch (tag) {
            case 2: {
                KnxUtil.messageLog("[KNX UTIL] Warning | " + message);
                break;
            }
            case 3: {
                KnxUtil.messageLog("[KNX UTIL] Message | " + message);
                break;
            }
            case 0: {
                KnxUtil.errorLog("[KNX UTIL] Error | " + message);
                break;
            }
            case 1: {
                if (!Configuration.verboseLog) break;
                KnxUtil.messageLog("[KNX UTIL]  Verbose | " + message);
                break;
            }
        }
    }
}

