/*
 * Decompiled with CFR 0.152.
 */
package plugins.bacnetutil;

import com.hsyco.BACnet;
import com.hsyco.Configuration;
import com.hsyco.userBase;
import java.util.HashMap;

public class BACnetUtil
extends userBase {
    private static final String PREFIX = "__hsyco__bacnet";
    private static final int LOG_ERROR = 0;
    private static final int LOG_VERBOSE = 1;
    private static final int LOG_WARNING = 2;
    private static final int LOG_MESSAGE = 3;
    private static String selectedServerName;

    public static void IOStartupEvent(int ioIndex) {
        String bacnetServers = "";
        int count = 0;
        String firstName = null;
        try {
            String ioServerName = Configuration.ioServersGetName(ioIndex);
            String ioServerType = Configuration.ioServersGetTypeByName(ioServerName).toLowerCase();
            if (ioServerType == null || !ioServerType.equals("bacnet")) {
                return;
            }
            if (selectedServerName == null) {
                selectedServerName = ioServerName;
                for (String name : Configuration.ioServersName) {
                    String type = Configuration.ioServersGetTypeByName(name);
                    if (type == null || !type.equalsIgnoreCase("bacnet") || BACnet.getInstance(name) == null) continue;
                    bacnetServers = count == 0 ? (firstName = new String(name)) : String.valueOf(bacnetServers) + "," + name;
                    ++count;
                }
                if (count > 0) {
                    BACnetUtil.uiSet("__hsyco__bacnet.browse.server.id", "values", bacnetServers);
                    BACnetUtil.uiSet("__hsyco__bacnet.browse.server.id", "labels", bacnetServers);
                    BACnetUtil.uiSet("__hsyco__bacnet.browse.server.id", "value", firstName);
                }
                if (count < 2) {
                    BACnetUtil.uiSet("__hsyco__bacnet.browse.server.id", "enabled", "false");
                }
            }
        }
        catch (Throwable e2) {
            BACnetUtil.log(0, "error in IOStartupEvent(" + ioIndex + ")");
        }
    }

    public static String userCommand(String session, String uid, String cmd, String param) {
        block3: {
            try {
                if (cmd.startsWith(PREFIX)) break block3;
                return null;
            }
            catch (Exception e2) {
                BACnetUtil.log(0, "error processing command: " + cmd + " = " + param);
                return "!error";
            }
        }
        return BACnet.getInstance(selectedServerName).utilCommands(cmd.substring(PREFIX.length() + 1), param, null);
    }

    public static String userSubmit(String session, String userid, String cmd, HashMap<String, String> submitted) {
        block4: {
            try {
                if (cmd.startsWith(PREFIX)) break block4;
                return null;
            }
            catch (Exception e2) {
                BACnetUtil.log(0, "error processing submit command: " + cmd);
                return "!error";
            }
        }
        if (cmd.endsWith("browse")) {
            selectedServerName = submitted.get("__hsyco__bacnet.browse.server.id");
        }
        return BACnet.getInstance(selectedServerName).utilCommands(cmd.substring(PREFIX.length() + 1), null, submitted);
    }

    private static void log(int tag, String message) {
        switch (tag) {
            case 2: {
                BACnetUtil.messageLog("[BACNET UTIL] Warning | " + message);
                break;
            }
            case 3: {
                BACnetUtil.messageLog("[BACNET UTIL] Message | " + message);
                break;
            }
            case 0: {
                BACnetUtil.errorLog("[BACNET UTIL] Error | " + message);
                break;
            }
            case 1: {
                if (!Configuration.verboseLog) break;
                BACnetUtil.messageLog("[BACNET UTIL]  Verbose | " + message);
                break;
            }
        }
    }
}

