/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.movtool.streaming.tracks.SeekableByteChannelWrapper;

public class FilePool {
    private BlockingQueue<SeekableByteChannel> channels;
    private List<SeekableByteChannel> allChannels = Collections.synchronizedList(new ArrayList());
    private File file;
    private int max;

    public FilePool(File file, int max) {
        this.file = file;
        this.max = max;
        this.channels = new LinkedBlockingQueue<SeekableByteChannel>();
    }

    public SeekableByteChannel getChannel() throws IOException {
        SeekableByteChannel channel = (SeekableByteChannel)this.channels.poll();
        if (channel == null) {
            System.out.println("NO CHANNEL");
            if (this.allChannels.size() < this.max) {
                channel = this.newChannel(this.file);
                this.allChannels.add(channel);
                System.out.println("CHANNELS: " + this.allChannels.size() + "(" + this.max + ")");
            } else {
                while (true) {
                    try {
                        channel = this.channels.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        return new PoolChannel(channel);
    }

    protected SeekableByteChannel newChannel(File file) throws FileNotFoundException {
        return NIOUtils.readableFileChannel(file);
    }

    public void close() {
        while (!this.allChannels.isEmpty()) {
            SeekableByteChannel channel = this.allChannels.remove(0);
            if (channel == null) continue;
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("CLOSED FILE");
        }
        System.out.println("FILE POOL CLOSED!!!");
    }

    public class PoolChannel
    extends SeekableByteChannelWrapper {
        public PoolChannel(SeekableByteChannel src) {
            super(src);
        }

        @Override
        public boolean isOpen() {
            return this.src != null;
        }

        @Override
        public void close() throws IOException {
            SeekableByteChannel ret = this.src;
            this.src = null;
            while (true) {
                try {
                    FilePool.this.channels.put(ret);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

