/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jcodec.common.NIOUtils;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualMovie;

public class MovieRange
extends InputStream {
    private VirtualMovie movie;
    private long remaining;
    private int chunkNo;
    private ByteBuffer chunkData;

    public MovieRange(VirtualMovie movie, long from, long to) throws IOException {
        if (to < from) {
            throw new IllegalArgumentException("from < to");
        }
        this.movie = movie;
        MovieSegment chunk = movie.getPacketAt(from);
        this.remaining = to - from + 1L;
        if (chunk != null) {
            this.chunkData = chunk.getData();
            this.chunkNo = chunk.getNo();
            NIOUtils.skip(this.chunkData, (int)(from - chunk.getPos()));
        }
    }

    @Override
    public int read(byte[] b2, int from, int len) throws IOException {
        this.tryFetch();
        if (this.chunkData == null || this.remaining == 0L) {
            return -1;
        }
        len = (int)Math.min(this.remaining, (long)len);
        int totalRead = 0;
        while (len > 0) {
            int toRead = Math.min(this.chunkData.remaining(), len);
            this.chunkData.get(b2, from, toRead);
            totalRead += toRead;
            len -= toRead;
            from += toRead;
            this.tryFetch();
            if (this.chunkData != null) continue;
            break;
        }
        this.remaining -= (long)totalRead;
        return totalRead;
    }

    private void tryFetch() throws IOException {
        if (this.chunkData == null || !this.chunkData.hasRemaining()) {
            MovieSegment chunk = this.movie.getPacketByNo(this.chunkNo + 1);
            if (chunk != null) {
                this.chunkData = chunk.getData();
                this.chunkNo = chunk.getNo();
            } else {
                this.chunkData = null;
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.tryFetch();
        if (this.chunkData == null || this.remaining == 0L) {
            return -1;
        }
        --this.remaining;
        return this.chunkData.get() & 0xFF;
    }
}

