/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.LongArrayList;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.TrackType;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import org.jcodec.containers.mp4.boxes.DataInfoBox;
import org.jcodec.containers.mp4.boxes.DataRefBox;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.GenericMediaInfoBox;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.MediaBox;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MediaInfoBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import org.jcodec.containers.mp4.boxes.SoundMediaHeaderBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import org.jcodec.containers.mp4.boxes.TimecodeMediaInfoBox;
import org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoMediaHeaderBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.movtool.streaming.VirtualMovie;
import org.jcodec.movtool.streaming.VirtualTrack;

public class MovieHelper {
    private static final int MEBABYTE = 0x100000;
    private static int[] timescales = new int[]{10000, 12000, 15000, 24000, 25000, 30000, 50000, 41000, 48000, 96000};

    public static ByteBuffer produceHeader(VirtualMovie.PacketChunk[] chunks, VirtualTrack[] tracks, long dataSize) {
        int defaultTimescale = 1000;
        ByteBuffer buf = ByteBuffer.allocate(0x600000);
        MovieBox movie = new MovieBox();
        double[] trackDurations = MovieHelper.calcTrackDurations(chunks, tracks);
        long movieDur = MovieHelper.calcMovieDuration(tracks, defaultTimescale, trackDurations);
        movie.add(MovieHelper.movieHeader(movie, tracks.length, movieDur, defaultTimescale));
        for (int trackId = 0; trackId < tracks.length; ++trackId) {
            VirtualTrack track = tracks[trackId];
            SampleEntry se = track.getSampleEntry();
            boolean pcm = se instanceof AudioSampleEntry && ((AudioSampleEntry)se).isPCM();
            int trackTimescale = track.getPreferredTimescale();
            if (trackTimescale <= 0) {
                trackTimescale = pcm ? MovieHelper.getPCMTs((AudioSampleEntry)se, chunks, trackId) : MovieHelper.chooseTimescale(chunks, trackId);
            } else if (trackTimescale < 100) {
                trackTimescale *= 1000;
            } else if (trackTimescale < 1000) {
                trackTimescale *= 100;
            } else if (trackTimescale < 10000) {
                trackTimescale *= 10;
            }
            long totalDur = (long)((double)trackTimescale * trackDurations[trackId]);
            TrakBox trak = new TrakBox();
            Size dd = new Size(0, 0);
            if (se instanceof VideoSampleEntry) {
                VideoSampleEntry vse = (VideoSampleEntry)se;
                dd = new Size(vse.getWidth(), vse.getHeight());
            }
            TrackHeaderBox tkhd = new TrackHeaderBox(trackId + 1, movieDur, dd.getWidth(), dd.getHeight(), new Date().getTime(), new Date().getTime(), 1.0f, 0, 0L, new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000});
            tkhd.setFlags(15);
            trak.add(tkhd);
            MediaBox media = new MediaBox();
            trak.add(media);
            media.add(new MediaHeaderBox(trackTimescale, totalDur, 0, new Date().getTime(), new Date().getTime(), 0));
            TrackType tt = se instanceof AudioSampleEntry ? TrackType.SOUND : TrackType.VIDEO;
            HandlerBox hdlr = new HandlerBox("mhlr", tt.getHandler(), "appl", 0, 0);
            media.add(hdlr);
            MediaInfoBox minf = new MediaInfoBox();
            media.add(minf);
            MovieHelper.mediaHeader(minf, tt);
            minf.add(new HandlerBox("dhlr", "url ", "appl", 0, 0));
            MovieHelper.addDref(minf);
            NodeBox stbl = new NodeBox(new Header("stbl"));
            minf.add(stbl);
            stbl.add(new SampleDescriptionBox(se));
            if (pcm) {
                MovieHelper.populateStblPCM(stbl, chunks, trackId, se);
            } else {
                MovieHelper.populateStblGeneric(stbl, chunks, trackId, se, trackTimescale);
            }
            MovieHelper.addEdits(trak, track, defaultTimescale, trackTimescale);
            movie.add(trak);
        }
        Brand.MP4.getFileTypeBox().write(buf);
        movie.write(buf);
        new Header("mdat", dataSize).write(buf);
        buf.flip();
        return buf;
    }

    private static int chooseTimescale(VirtualMovie.PacketChunk[] chunks, int trackId) {
        for (int ch = 0; ch < chunks.length; ++ch) {
            if (chunks[ch].getTrack() != trackId) continue;
            double dur = chunks[ch].getPacket().getDuration();
            double min = Double.MAX_VALUE;
            int minTs = -1;
            for (int ts = 0; ts < timescales.length; ++ts) {
                double dd = (double)timescales[ts] * dur;
                double diff = dd - (double)((int)dd);
                if (!(diff < min)) continue;
                minTs = ts;
                min = diff;
            }
            return timescales[minTs];
        }
        return 0;
    }

    private static void addEdits(TrakBox trak, VirtualTrack track, int defaultTimescale, int trackTimescale) {
        VirtualTrack.VirtualEdit[] edits = track.getEdits();
        if (edits == null) {
            return;
        }
        ArrayList<Edit> result = new ArrayList<Edit>();
        for (VirtualTrack.VirtualEdit virtualEdit : edits) {
            result.add(new Edit((int)(virtualEdit.getDuration() * (double)defaultTimescale), (int)(virtualEdit.getIn() * (double)trackTimescale), 1.0f));
        }
        trak.setEdits(result);
    }

    private static long calcMovieDuration(VirtualTrack[] tracks, int defaultTimescale, double[] dur) {
        long movieDur = 0L;
        for (int trackId = 0; trackId < tracks.length; ++trackId) {
            movieDur = Math.max(movieDur, (long)((double)defaultTimescale * dur[trackId]));
        }
        return movieDur;
    }

    private static double[] calcTrackDurations(VirtualMovie.PacketChunk[] chunks, VirtualTrack[] tracks) {
        double[] dur = new double[tracks.length];
        Arrays.fill(dur, -1.0);
        int n2 = 0;
        for (int chunkId = chunks.length - 1; chunkId >= 0 && n2 < dur.length; --chunkId) {
            VirtualMovie.PacketChunk chunk = chunks[chunkId];
            int track = chunk.getTrack();
            if (dur[track] != -1.0) continue;
            dur[track] = chunk.getPacket().getPts() + chunk.getPacket().getDuration();
            ++n2;
        }
        return dur;
    }

    private static void populateStblGeneric(NodeBox stbl, VirtualMovie.PacketChunk[] chunks, int trackId, SampleEntry se, int timescale) {
        LongArrayList stco = new LongArrayList(256000);
        IntArrayList stsz = new IntArrayList(256000);
        ArrayList<TimeToSampleBox.TimeToSampleEntry> stts = new ArrayList<TimeToSampleBox.TimeToSampleEntry>();
        IntArrayList stss = new IntArrayList(4096);
        double prevDur = 0.0;
        int prevCount = -1;
        boolean allKey = true;
        for (int chunkNo = 0; chunkNo < chunks.length; ++chunkNo) {
            VirtualMovie.PacketChunk chunk = chunks[chunkNo];
            if (chunk.getTrack() != trackId) continue;
            stco.add(chunk.getPos());
            stsz.add(chunk.getDataLen());
            double dur = chunk.getPacket().getDuration();
            if (dur != prevDur) {
                if (prevCount != -1) {
                    stts.add(new TimeToSampleBox.TimeToSampleEntry(prevCount, (int)Math.round(prevDur * (double)timescale)));
                }
                prevDur = dur;
                prevCount = 0;
            }
            ++prevCount;
            boolean key = chunk.getPacket().isKeyframe();
            allKey &= key;
            if (!key) continue;
            stss.add(chunk.getPacket().getFrameNo() + 1);
        }
        if (prevCount > 0) {
            stts.add(new TimeToSampleBox.TimeToSampleEntry(prevCount, (int)Math.round(prevDur * (double)timescale)));
        }
        if (!allKey) {
            stbl.add(new SyncSamplesBox(stss.toArray()));
        }
        stbl.add(new ChunkOffsets64Box(stco.toArray()));
        stbl.add(new SampleToChunkBox(new SampleToChunkBox.SampleToChunkEntry[]{new SampleToChunkBox.SampleToChunkEntry(1L, 1, 1)}));
        stbl.add(new SampleSizesBox(stsz.toArray()));
        stbl.add(new TimeToSampleBox(stts.toArray(new TimeToSampleBox.TimeToSampleEntry[0])));
    }

    private static void populateStblPCM(NodeBox stbl, VirtualMovie.PacketChunk[] chunks, int trackId, SampleEntry se) {
        AudioSampleEntry ase = (AudioSampleEntry)se;
        int frameSize = ase.calcFrameSize();
        LongArrayList stco = new LongArrayList(256000);
        ArrayList<SampleToChunkBox.SampleToChunkEntry> stsc = new ArrayList<SampleToChunkBox.SampleToChunkEntry>();
        int stscCount = -1;
        int stscFirstChunk = -1;
        int totalFrames = 0;
        int stscCurChunk = 1;
        for (int chunkNo = 0; chunkNo < chunks.length; ++chunkNo) {
            VirtualMovie.PacketChunk chunk = chunks[chunkNo];
            if (chunk.getTrack() != trackId) continue;
            stco.add(chunk.getPos());
            int framesPerChunk = chunk.getDataLen() / frameSize;
            if (framesPerChunk != stscCount) {
                if (stscCount != -1) {
                    stsc.add(new SampleToChunkBox.SampleToChunkEntry(stscFirstChunk, stscCount, 1));
                }
                stscFirstChunk = stscCurChunk;
                stscCount = framesPerChunk;
            }
            ++stscCurChunk;
            totalFrames += framesPerChunk;
        }
        if (stscCount != -1) {
            stsc.add(new SampleToChunkBox.SampleToChunkEntry(stscFirstChunk, stscCount, 1));
        }
        stbl.add(new ChunkOffsets64Box(stco.toArray()));
        stbl.add(new SampleToChunkBox(stsc.toArray(new SampleToChunkBox.SampleToChunkEntry[0])));
        stbl.add(new SampleSizesBox(ase.calcFrameSize(), totalFrames));
        stbl.add(new TimeToSampleBox(new TimeToSampleBox.TimeToSampleEntry[]{new TimeToSampleBox.TimeToSampleEntry(totalFrames, 1)}));
    }

    private static int getPCMTs(AudioSampleEntry se, VirtualMovie.PacketChunk[] chunks, int trackId) {
        for (int chunkNo = 0; chunkNo < chunks.length; ++chunkNo) {
            if (chunks[chunkNo].getTrack() != trackId) continue;
            return (int)Math.round((double)chunks[chunkNo].getDataLen() / ((double)se.calcFrameSize() * chunks[chunkNo].getPacket().getDuration()));
        }
        throw new RuntimeException("Crap");
    }

    private static void mediaHeader(MediaInfoBox minf, TrackType type) {
        switch (type) {
            case VIDEO: {
                VideoMediaHeaderBox vmhd = new VideoMediaHeaderBox(0, 0, 0, 0);
                vmhd.setFlags(1);
                minf.add(vmhd);
                break;
            }
            case SOUND: {
                SoundMediaHeaderBox smhd = new SoundMediaHeaderBox();
                smhd.setFlags(1);
                minf.add(smhd);
                break;
            }
            case TIMECODE: {
                NodeBox gmhd = new NodeBox(new Header("gmhd"));
                gmhd.add(new GenericMediaInfoBox());
                NodeBox tmcd = new NodeBox(new Header("tmcd"));
                gmhd.add(tmcd);
                tmcd.add(new TimecodeMediaInfoBox(0, 0, 12, new short[]{0, 0, 0}, new short[]{255, 255, 255}, "Lucida Grande"));
                minf.add(gmhd);
                break;
            }
            default: {
                throw new IllegalStateException("Handler " + type.getHandler() + " not supported");
            }
        }
    }

    private static void addDref(NodeBox minf) {
        DataInfoBox dinf = new DataInfoBox();
        minf.add(dinf);
        DataRefBox dref = new DataRefBox();
        dinf.add(dref);
        dref.add(new LeafBox(new Header("alis", 0L), ByteBuffer.wrap(new byte[]{0, 0, 0, 1})));
    }

    private static MovieHeaderBox movieHeader(NodeBox movie, int nTracks, long duration, int timescale) {
        return new MovieHeaderBox(timescale, duration, 1.0f, 1.0f, new Date().getTime(), new Date().getTime(), new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000}, nTracks + 1);
    }
}

