/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.nio.ByteBuffer;
import org.jcodec.codecs.prores.ProresFix;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.movtool.Remux;

public class ReExport
extends Remux {
    private ByteBuffer outBuf;

    @Override
    protected MP4Packet processFrame(MP4Packet pkt) {
        if (this.outBuf == null) {
            this.outBuf = ByteBuffer.allocate(pkt.getData().remaining() * 2);
        }
        ByteBuffer out = ProresFix.transcode(pkt.getData(), this.outBuf);
        return new MP4Packet(pkt, out);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("reexport <movie> <out>");
            return;
        }
        File tgt = new File(args[0]);
        File src = ReExport.hidFile(tgt);
        tgt.renameTo(src);
        try {
            new ReExport().remux(tgt, src);
        }
        catch (Throwable t) {
            t.printStackTrace();
            tgt.renameTo(new File(tgt.getParentFile(), tgt.getName() + ".error"));
            src.renameTo(tgt);
        }
    }
}

