/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mp4.MP4Util;

public class MovDump {
    public static void main(String[] args) throws Exception {
        int idx;
        if (args.length < 1) {
            System.out.println("Syntax: movdump [options] <filename>");
            System.out.println("Options: -f <filename> save header to a file");
        }
        File headerFile = null;
        for (idx = 0; idx < args.length && "-f".equals(args[idx]); ++idx) {
            int n2 = ++idx;
            headerFile = new File(args[n2]);
        }
        File source = new File(args[idx]);
        if (headerFile != null) {
            MovDump.dumpHeader(headerFile, source);
        }
        System.out.println(MovDump.print(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpHeader(File headerFile, File source) throws IOException, FileNotFoundException {
        FileChannelWrapper raf = null;
        FileChannelWrapper daos = null;
        try {
            raf = NIOUtils.readableFileChannel(source);
            daos = NIOUtils.writableFileChannel(headerFile);
            for (MP4Util.Atom atom : MP4Util.getRootAtoms(raf)) {
                String fourcc = atom.getHeader().getFourcc();
                if (!"moov".equals(fourcc) && !"ftyp".equals(fourcc)) continue;
                atom.copy(raf, daos);
            }
        }
        finally {
            raf.close();
            daos.close();
        }
    }

    public static String print(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        MP4Util.parseMovie(file).dump(sb);
        return sb.toString();
    }
}

