/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.Assert;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.BoxFactory;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;

public abstract class InplaceEdit {
    protected abstract void apply(MovieBox var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(File f2) throws IOException, Exception {
        FileChannelWrapper fi = null;
        try {
            fi = NIOUtils.rwFileChannel(f2);
            MP4Util.Atom moov = this.getMoov(fi);
            Assert.assertNotNull(moov);
            fi.position(moov.getOffset());
            ByteBuffer oldMov = NIOUtils.fetchFrom(fi, (int)moov.getHeader().getSize());
            Header header = Header.read(oldMov);
            MovieBox movBox = (MovieBox)NodeBox.parseBox(oldMov, header, BoxFactory.getDefault());
            this.apply(movBox);
            oldMov.position(0);
            oldMov.limit(oldMov.capacity());
            try {
                movBox.write(oldMov);
            }
            catch (Exception e2) {
                boolean bl = false;
                if (fi != null) {
                    fi.close();
                }
                return bl;
            }
            if (oldMov.hasRemaining()) {
                if (oldMov.remaining() < 8) {
                    boolean bl = false;
                    return bl;
                }
                oldMov.putInt(oldMov.remaining());
                oldMov.put(new byte[]{102, 114, 101, 101});
            }
            fi.position(moov.getOffset());
            fi.write(oldMov);
            boolean bl = true;
            return bl;
        }
        finally {
            if (fi != null) {
                fi.close();
            }
        }
    }

    private MP4Util.Atom getMoov(SeekableByteChannel f2) throws IOException {
        for (MP4Util.Atom atom : MP4Util.getRootAtoms(f2)) {
            if (!"moov".equals(atom.getHeader().getFourcc())) continue;
            return atom;
        }
        return null;
    }
}

