/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.StringUtils;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.movtool.Flattern;
import org.jcodec.movtool.Strip;
import org.jcodec.movtool.Util;

public class Cut {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Syntax: cut [-command arg]...[-command arg] [-self] <movie file>\n\tCreates a reference movie out of the file and applies a set of changes specified by the commands to it.");
            System.exit(-1);
        }
        ArrayList<Slice> slices = new ArrayList<Slice>();
        ArrayList<String> sliceNames = new ArrayList<String>();
        boolean selfContained = false;
        int shift = 0;
        while (true) {
            if ("-cut".equals(args[shift])) {
                String[] pt = StringUtils.split(args[shift + 1], ":");
                slices.add(new Slice(Integer.parseInt(pt[0]), Integer.parseInt(pt[1])));
                if (pt.length > 2) {
                    sliceNames.add(pt[2]);
                } else {
                    sliceNames.add(null);
                }
                shift += 2;
                continue;
            }
            if (!"-self".equals(args[shift])) break;
            ++shift;
            selfContained = true;
        }
        File source = new File(args[shift]);
        FileChannelWrapper input = null;
        Channel out = null;
        ArrayList outs = new ArrayList();
        try {
            List<MovieBox> slicesMovs;
            input = NIOUtils.readableFileChannel(source);
            MovieBox movie = MP4Util.createRefMovie(input, "file://" + source.getCanonicalPath());
            if (!selfContained) {
                out = NIOUtils.writableFileChannel(new File(source.getParentFile(), JCodecUtil.removeExtension(source.getName()) + ".ref.mov"));
                slicesMovs = new Cut().cut(movie, slices);
                MP4Util.writeMovie((SeekableByteChannel)out, movie);
            } else {
                out = NIOUtils.writableFileChannel(new File(source.getParentFile(), JCodecUtil.removeExtension(source.getName()) + ".self.mov"));
                slicesMovs = new Cut().cut(movie, slices);
                new Strip().strip(movie);
                new Flattern().flattern(movie, (SeekableByteChannel)out);
            }
            Cut.saveSlices(slicesMovs, sliceNames, source.getParentFile());
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (out != null) {
                out.close();
            }
            for (SeekableByteChannel o2 : outs) {
                o2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSlices(List<MovieBox> slices, List<String> names, File parentFile) throws IOException {
        for (int i2 = 0; i2 < slices.size(); ++i2) {
            if (names.get(i2) == null) continue;
            FileChannelWrapper out = null;
            try {
                out = NIOUtils.writableFileChannel(new File(parentFile, names.get(i2)));
                MP4Util.writeMovie(out, slices.get(i2));
            }
            catch (Throwable throwable) {
                NIOUtils.closeQuietly(out);
                throw throwable;
            }
            NIOUtils.closeQuietly(out);
        }
    }

    public List<MovieBox> cut(MovieBox movie, List<Slice> commands) {
        TrakBox[] tracks;
        TrakBox videoTrack = movie.getVideoTrack();
        if (videoTrack != null && videoTrack.getTimescale() != movie.getTimescale()) {
            movie.fixTimescale(videoTrack.getTimescale());
        }
        for (TrakBox trakBox : tracks = movie.getTracks()) {
            Util.forceEditList(movie, trakBox);
            List<Edit> edits = trakBox.getEdits();
            for (Slice cut : commands) {
                this.split(edits, cut.inSec, movie, trakBox);
                this.split(edits, cut.outSec, movie, trakBox);
            }
        }
        ArrayList<MovieBox> result = new ArrayList<MovieBox>();
        for (Slice cut : commands) {
            MovieBox clone = (MovieBox)MP4Util.cloneBox(movie, 0x1000000);
            for (TrakBox trakBox : clone.getTracks()) {
                this.selectInner(trakBox.getEdits(), cut, movie, trakBox);
            }
            result.add(clone);
        }
        long movDuration = 0L;
        for (TrakBox trakBox : movie.getTracks()) {
            this.selectOuter(trakBox.getEdits(), commands, movie, trakBox);
            trakBox.setEdits(trakBox.getEdits());
            movDuration = Math.max(movDuration, trakBox.getDuration());
        }
        movie.setDuration(movDuration);
        return result;
    }

    private void selectOuter(List<Edit> edits, List<Slice> commands, MovieBox movie, TrakBox trakBox) {
        long[] inMv = new long[commands.size()];
        long[] outMv = new long[commands.size()];
        for (int i2 = 0; i2 < commands.size(); ++i2) {
            inMv[i2] = (long)(commands.get(i2).inSec * (double)movie.getTimescale());
            outMv[i2] = (long)(commands.get(i2).outSec * (double)movie.getTimescale());
        }
        long editStartMv = 0L;
        ListIterator<Edit> lit = edits.listIterator();
        while (lit.hasNext()) {
            Edit edit = lit.next();
            for (int i3 = 0; i3 < inMv.length; ++i3) {
                if (editStartMv + edit.getDuration() <= inMv[i3] || editStartMv >= outMv[i3]) continue;
                lit.remove();
            }
            editStartMv += edit.getDuration();
        }
    }

    private void selectInner(List<Edit> edits, Slice cut, MovieBox movie, TrakBox trakBox) {
        long inMv = (long)((double)movie.getTimescale() * cut.inSec);
        long outMv = (long)((double)movie.getTimescale() * cut.outSec);
        long editStart = 0L;
        ListIterator<Edit> lit = edits.listIterator();
        while (lit.hasNext()) {
            Edit edit = lit.next();
            if (editStart + edit.getDuration() <= inMv || editStart >= outMv) {
                lit.remove();
            }
            editStart += edit.getDuration();
        }
    }

    private void split(List<Edit> edits, double sec, MovieBox movie, TrakBox trakBox) {
        Util.split(movie, trakBox, (long)(sec * (double)movie.getTimescale()));
    }

    public static class Slice {
        private double inSec;
        private double outSec;

        public Slice(double in, double out) {
            this.inSec = in;
            this.outSec = out;
        }
    }
}

