/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.filters.color;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jcodec.common.model.Picture;

public class CVTColorFilter {
    public void yuv42210BitTObgr24(Picture yuv, ByteBuffer rgb32) {
        IntBuffer y = IntBuffer.wrap(yuv.getPlaneData(0));
        IntBuffer cb = IntBuffer.wrap(yuv.getPlaneData(1));
        IntBuffer cr = IntBuffer.wrap(yuv.getPlaneData(2));
        while (y.hasRemaining()) {
            int c1 = y.get() - 64;
            int c2 = y.get() - 64;
            int d2 = cb.get() - 512;
            int e2 = cr.get() - 512;
            rgb32.put(CVTColorFilter.blue(d2, c1));
            rgb32.put(CVTColorFilter.green(d2, e2, c1));
            rgb32.put(CVTColorFilter.red(e2, c1));
            rgb32.put(CVTColorFilter.blue(d2, c2));
            rgb32.put(CVTColorFilter.green(d2, e2, c2));
            rgb32.put(CVTColorFilter.red(e2, c2));
        }
    }

    private static byte blue(int d2, int c2) {
        int blue = 1192 * c2 + 2064 * d2 + 512 >> 10;
        blue = blue < 0 ? 0 : (blue > 1023 ? 1023 : blue);
        return (byte)(blue >> 2 & 0xFF);
    }

    private static byte green(int d2, int e2, int c2) {
        int green = 1192 * c2 - 400 * d2 - 832 * e2 + 512 >> 10;
        green = green < 0 ? 0 : (green > 1023 ? 1023 : green);
        return (byte)(green >> 2 & 0xFF);
    }

    private static byte red(int e2, int c2) {
        int red = 1192 * c2 + 1636 * e2 + 512 >> 10;
        red = red < 0 ? 0 : (red > 1023 ? 1023 : red);
        return (byte)(red >> 2 & 0xFF);
    }
}

