/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.TrackType;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.FramesMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.PCMMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.TimecodeMP4DemuxerTrack;

public class MP4Demuxer {
    private List<AbstractMP4DemuxerTrack> tracks;
    private TimecodeMP4DemuxerTrack timecodeTrack;
    MovieBox movie;
    private SeekableByteChannel input;
    private static int ftyp = 1718909296;
    private static int free = 1718773093;
    private static int moov = 1836019574;
    private static int mdat = 1835295092;

    public AbstractMP4DemuxerTrack create(TrakBox trak) {
        SampleSizesBox stsz = Box.findFirst((NodeBox)trak, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        if (stsz.getDefaultSize() == 0) {
            return new FramesMP4DemuxerTrack(this.movie, trak, this.input);
        }
        return new PCMMP4DemuxerTrack(this.movie, trak, this.input);
    }

    public MP4Demuxer(SeekableByteChannel input) throws IOException {
        this.input = input;
        this.tracks = new LinkedList<AbstractMP4DemuxerTrack>();
        this.findMovieBox(input);
    }

    public AbstractMP4DemuxerTrack[] getTracks() {
        return this.tracks.toArray(new AbstractMP4DemuxerTrack[0]);
    }

    private void findMovieBox(SeekableByteChannel input) throws IOException {
        this.movie = MP4Util.parseMovie(input);
        if (this.movie == null) {
            throw new IOException("Could not find movie meta information box");
        }
        this.processHeader(this.movie);
    }

    private void processHeader(NodeBox moov) throws IOException {
        AbstractMP4DemuxerTrack video;
        TrakBox tt = null;
        for (TrakBox trak : Box.findAll((Box)moov, TrakBox.class, "trak")) {
            SampleEntry se = Box.findFirst((NodeBox)trak, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null);
            if ("tmcd".equals(se.getFourcc())) {
                tt = trak;
                continue;
            }
            this.tracks.add(this.create(trak));
        }
        if (tt != null && (video = this.getVideoTrack()) != null) {
            this.timecodeTrack = new TimecodeMP4DemuxerTrack(this.movie, tt, this.input);
        }
    }

    public static TrackType getTrackType(TrakBox trak) {
        HandlerBox handler = Box.findFirst((NodeBox)trak, HandlerBox.class, "mdia", "hdlr");
        return TrackType.fromHandler(handler.getComponentSubType());
    }

    public AbstractMP4DemuxerTrack getVideoTrack() {
        for (AbstractMP4DemuxerTrack demuxerTrack : this.tracks) {
            if (!demuxerTrack.box.isVideo()) continue;
            return demuxerTrack;
        }
        return null;
    }

    public MovieBox getMovie() {
        return this.movie;
    }

    public AbstractMP4DemuxerTrack getTrack(int no) {
        for (AbstractMP4DemuxerTrack track : this.tracks) {
            if (track.getNo() != no) continue;
            return track;
        }
        return null;
    }

    public List<AbstractMP4DemuxerTrack> getAudioTracks() {
        ArrayList<AbstractMP4DemuxerTrack> result = new ArrayList<AbstractMP4DemuxerTrack>();
        for (AbstractMP4DemuxerTrack demuxerTrack : this.tracks) {
            if (!demuxerTrack.box.isAudio()) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    public TimecodeMP4DemuxerTrack getTimecodeTrack() {
        return this.timecodeTrack;
    }

    public static int probe(ByteBuffer b2) {
        ByteBuffer fork = b2.duplicate();
        int success = 0;
        int total = 0;
        while (fork.remaining() >= 8) {
            long len = fork.getInt();
            int fcc = fork.getInt();
            int hdrLen = 8;
            if (len == 1L) {
                len = fork.getLong();
                hdrLen = 16;
            } else if (len < 8L) break;
            if (fcc == ftyp && len < 64L || fcc == moov && len < 0x6400000L || fcc == free || fcc == mdat) {
                ++success;
            }
            ++total;
            if (len >= Integer.MAX_VALUE) break;
            NIOUtils.skip(fork, (int)(len - (long)hdrLen));
        }
        return success * 100 / total;
    }
}

