/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.QTTimeUtil;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;

public class FramesMP4DemuxerTrack
extends AbstractMP4DemuxerTrack {
    private int[] sizes;
    private long offInChunk;
    private int noInChunk;
    private int[] syncSamples;
    private int ssOff;
    private CompositionOffsetsBox.Entry[] compOffsets;
    private int cttsInd;
    private int cttsSubInd;
    private SeekableByteChannel input;
    private MovieBox movie;

    public FramesMP4DemuxerTrack(MovieBox mov, TrakBox trak, SeekableByteChannel input) {
        super(trak);
        this.input = input;
        this.movie = mov;
        SampleSizesBox stsz = Box.findFirst((NodeBox)trak, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        SyncSamplesBox stss = Box.findFirst((NodeBox)trak, SyncSamplesBox.class, "mdia", "minf", "stbl", "stss");
        CompositionOffsetsBox ctts = Box.findFirst((NodeBox)trak, CompositionOffsetsBox.class, "mdia", "minf", "stbl", "ctts");
        CompositionOffsetsBox.Entry[] entryArray = this.compOffsets = ctts == null ? null : ctts.getEntries();
        if (stss != null) {
            this.syncSamples = stss.getSyncSamples();
        }
        this.sizes = stsz.getSizes();
    }

    @Override
    public synchronized MP4Packet nextFrame() throws IOException {
        if (this.curFrame >= (long)this.sizes.length) {
            return null;
        }
        int size = this.sizes[(int)this.curFrame];
        return this.nextFrame(ByteBuffer.allocate(size));
    }

    @Override
    public synchronized MP4Packet nextFrame(ByteBuffer storage) throws IOException {
        boolean sync;
        if (this.curFrame >= (long)this.sizes.length) {
            return null;
        }
        int size = this.sizes[(int)this.curFrame];
        if (storage != null && storage.remaining() < size) {
            throw new IllegalArgumentException("Buffer size is not enough to fit a packet");
        }
        long pktPos = this.chunkOffsets[this.stcoInd] + this.offInChunk;
        ByteBuffer result = this.readPacketData(this.input, storage, pktPos, size);
        if (result.remaining() < size) {
            return null;
        }
        int duration = this.timeToSamples[this.sttsInd].getSampleDuration();
        boolean bl = sync = this.syncSamples == null;
        if (this.syncSamples != null && this.ssOff < this.syncSamples.length && this.curFrame + 1L == (long)this.syncSamples[this.ssOff]) {
            sync = true;
            ++this.ssOff;
        }
        long realPts = this.pts;
        if (this.compOffsets != null) {
            realPts = this.pts + (long)this.compOffsets[this.cttsInd].getOffset();
            ++this.cttsSubInd;
            if (this.cttsInd < this.compOffsets.length - 1 && this.cttsSubInd == this.compOffsets[this.cttsInd].getCount()) {
                ++this.cttsInd;
                this.cttsSubInd = 0;
            }
        }
        MP4Packet pkt = new MP4Packet(result, QTTimeUtil.mediaToEdited(this.box, realPts, this.movie.getTimescale()), this.timescale, duration, this.curFrame, sync, null, realPts, this.sampleToChunks[this.stscInd].getEntry() - 1, pktPos, size);
        this.offInChunk += (long)size;
        ++this.curFrame;
        ++this.noInChunk;
        if (this.noInChunk >= this.sampleToChunks[this.stscInd].getCount()) {
            this.noInChunk = 0;
            this.offInChunk = 0L;
            this.nextChunk();
        }
        this.shiftPts(1L);
        ++this.sttsSubInd;
        return pkt;
    }

    @Override
    protected void seekPointer(long frameNo) {
        if (this.compOffsets != null) {
            this.cttsSubInd = (int)frameNo;
            this.cttsInd = 0;
            while (this.cttsSubInd >= this.compOffsets[this.cttsInd].getCount()) {
                this.cttsSubInd -= this.compOffsets[this.cttsInd].getCount();
                ++this.cttsInd;
            }
        }
        this.curFrame = (int)frameNo;
        this.stcoInd = 0;
        this.stscInd = 0;
        this.noInChunk = (int)frameNo;
        this.offInChunk = 0L;
        while (this.noInChunk >= this.sampleToChunks[this.stscInd].getCount()) {
            this.noInChunk -= this.sampleToChunks[this.stscInd].getCount();
            this.nextChunk();
        }
        for (int i2 = 0; i2 < this.noInChunk; ++i2) {
            this.offInChunk += (long)this.sizes[(int)frameNo - this.noInChunk + i2];
        }
        if (this.syncSamples != null) {
            this.ssOff = 0;
            while ((long)this.syncSamples[this.ssOff] < this.curFrame + 1L) {
                ++this.ssOff;
            }
        }
    }

    @Override
    public long getFrameCount() {
        return this.sizes.length;
    }
}

