/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ChannelBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.channel.ChannelLayout;
import org.jcodec.containers.mp4.boxes.channel.Label;

public class ChannelUtils {
    private static final List<Label> MONO = Arrays.asList(Label.Mono);
    private static final List<Label> STEREO = Arrays.asList(Label.Left, Label.Right);
    private static final List<Label> MATRIX_STEREO = Arrays.asList(Label.LeftTotal, Label.RightTotal);
    private static final Label[] EMPTY = new Label[0];

    public static Label[] getLabels(AudioSampleEntry se) {
        ChannelBox channel = Box.findFirst((NodeBox)se, ChannelBox.class, "chan");
        if (channel != null) {
            return ChannelUtils.getLabels(channel);
        }
        short channelCount = se.getChannelCount();
        switch (channelCount) {
            case 1: {
                return new Label[]{Label.Mono};
            }
            case 2: {
                return new Label[]{Label.Left, Label.Right};
            }
            case 3: {
                return new Label[]{Label.Left, Label.Right, Label.Center};
            }
            case 4: {
                return new Label[]{Label.Left, Label.Right, Label.LeftSurround, Label.RightSurround};
            }
            case 5: {
                return new Label[]{Label.Left, Label.Right, Label.Center, Label.LeftSurround, Label.RightSurround};
            }
            case 6: {
                return new Label[]{Label.Left, Label.Right, Label.Center, Label.LFEScreen, Label.LeftSurround, Label.RightSurround};
            }
        }
        Label[] res = new Label[channelCount];
        Arrays.fill((Object[])res, (Object)Label.Mono);
        return res;
    }

    public static Label[] getLabels(TrakBox trakBox) {
        return ChannelUtils.getLabels((AudioSampleEntry)trakBox.getSampleEntries()[0]);
    }

    public static void setLabel(TrakBox trakBox, int channel, Label label) {
        Label[] labels = ChannelUtils.getLabels(trakBox);
        labels[channel] = label;
        ChannelUtils.setLabels(trakBox, labels);
    }

    private static void setLabels(TrakBox trakBox, Label[] labels) {
        ChannelBox channel = Box.findFirst((NodeBox)trakBox, ChannelBox.class, "mdia", "minf", "stbl", "stsd", null, "chan");
        if (channel == null) {
            channel = new ChannelBox();
            Box.findFirst((NodeBox)trakBox, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null).add(channel);
        }
        ChannelUtils.setLabels(labels, channel);
    }

    public static void setLabels(Label[] labels, ChannelBox channel) {
        channel.setChannelLayout(ChannelLayout.kCAFChannelLayoutTag_UseChannelDescriptions.getCode());
        ChannelBox.ChannelDescription[] list = new ChannelBox.ChannelDescription[labels.length];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            list[i2] = new ChannelBox.ChannelDescription(labels[i2].getVal(), 0, new float[]{0.0f, 0.0f, 0.0f});
        }
        channel.setDescriptions(list);
    }

    public static Label[] getLabels(ChannelBox box) {
        long tag = box.getChannelLayout();
        for (ChannelLayout layout : EnumSet.allOf(ChannelLayout.class)) {
            if ((long)layout.getCode() != tag) continue;
            switch (layout) {
                case kCAFChannelLayoutTag_UseChannelDescriptions: {
                    return ChannelUtils.extractLabels(box.getDescriptions());
                }
                case kCAFChannelLayoutTag_UseChannelBitmap: {
                    return ChannelUtils.getLabelsByBitmap(box.getChannelBitmap());
                }
            }
            return layout.getLabels();
        }
        return EMPTY;
    }

    private static Label[] extractLabels(ChannelBox.ChannelDescription[] descriptions) {
        Label[] result = new Label[descriptions.length];
        for (int i2 = 0; i2 < descriptions.length; ++i2) {
            result[i2] = descriptions[i2].getLabel();
        }
        return result;
    }

    public static Label[] getLabelsByBitmap(long channelBitmap) {
        ArrayList<Label> result = new ArrayList<Label>();
        for (Label label : Label.values()) {
            if ((label.bitmapVal & channelBitmap) == 0L) continue;
            result.add(label);
        }
        return result.toArray(new Label[0]);
    }
}

