/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.tools.ToJSON;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.BoxFactory;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.SampleEntry;

public class TimecodeSampleEntry
extends SampleEntry {
    public static final int FLAG_DROPFRAME = 1;
    public static final int FLAG_24HOURMAX = 2;
    public static final int FLAG_NEGATIVETIMEOK = 4;
    public static final int FLAG_COUNTER = 8;
    private static final MyFactory FACTORY = new MyFactory();
    private int flags;
    private int timescale;
    private int frameDuration;
    private byte numFrames;

    public TimecodeSampleEntry(Header header) {
        super(header);
        this.factory = FACTORY;
    }

    public TimecodeSampleEntry() {
        super(new Header("tmcd"));
        this.factory = FACTORY;
    }

    public TimecodeSampleEntry(int flags, int timescale, int frameDuration, int numFrames) {
        super(new Header("tmcd"));
        this.flags = flags;
        this.timescale = timescale;
        this.frameDuration = frameDuration;
        this.numFrames = (byte)numFrames;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        NIOUtils.skip(input, 4);
        this.flags = input.getInt();
        this.timescale = input.getInt();
        this.frameDuration = input.getInt();
        this.numFrames = input.get();
        NIOUtils.skip(input, 1);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(0);
        out.putInt(this.flags);
        out.putInt(this.timescale);
        out.putInt(this.frameDuration);
        out.put(this.numFrames);
        out.put((byte)-49);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getTimescale() {
        return this.timescale;
    }

    public int getFrameDuration() {
        return this.frameDuration;
    }

    public byte getNumFrames() {
        return this.numFrames;
    }

    public boolean isDropFrame() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void dump(StringBuilder sb) {
        sb.append(this.header.getFourcc() + ": {\n");
        sb.append("entry: ");
        ToJSON.toJSON(this, sb, "flags", "timescale", "frameDuration", "numFrames");
        sb.append(",\nexts: [\n");
        this.dumpBoxes(sb);
        sb.append("\n]\n");
        sb.append("}\n");
    }

    public static class MyFactory
    extends BoxFactory {
        private Map<String, Class<? extends Box>> mappings = new HashMap<String, Class<? extends Box>>();

        @Override
        public Class<? extends Box> toClass(String fourcc) {
            return this.mappings.get(fourcc);
        }
    }
}

