/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.util.HashMap;
import java.util.Map;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import org.jcodec.containers.mp4.boxes.ClearApertureBox;
import org.jcodec.containers.mp4.boxes.ClipRegionBox;
import org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import org.jcodec.containers.mp4.boxes.DataInfoBox;
import org.jcodec.containers.mp4.boxes.DataRefBox;
import org.jcodec.containers.mp4.boxes.EditListBox;
import org.jcodec.containers.mp4.boxes.EncodedPixelBox;
import org.jcodec.containers.mp4.boxes.FileTypeBox;
import org.jcodec.containers.mp4.boxes.GenericMediaInfoBox;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.LoadSettingsBox;
import org.jcodec.containers.mp4.boxes.MediaBox;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MediaInfoBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NameBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.ProductionApertureBox;
import org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import org.jcodec.containers.mp4.boxes.SoundMediaHeaderBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import org.jcodec.containers.mp4.boxes.TimecodeMediaInfoBox;
import org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoMediaHeaderBox;

public class BoxFactory {
    private Map<String, Class<? extends Box>> mappings = new HashMap<String, Class<? extends Box>>();
    private static BoxFactory instance = new BoxFactory();

    public static BoxFactory getDefault() {
        return instance;
    }

    public BoxFactory() {
        this.mappings.put(VideoMediaHeaderBox.fourcc(), VideoMediaHeaderBox.class);
        this.mappings.put(FileTypeBox.fourcc(), FileTypeBox.class);
        this.mappings.put(MovieBox.fourcc(), MovieBox.class);
        this.mappings.put(MovieHeaderBox.fourcc(), MovieHeaderBox.class);
        this.mappings.put(TrakBox.fourcc(), TrakBox.class);
        this.mappings.put(TrackHeaderBox.fourcc(), TrackHeaderBox.class);
        this.mappings.put("edts", NodeBox.class);
        this.mappings.put(EditListBox.fourcc(), EditListBox.class);
        this.mappings.put(MediaBox.fourcc(), MediaBox.class);
        this.mappings.put(MediaHeaderBox.fourcc(), MediaHeaderBox.class);
        this.mappings.put(MediaInfoBox.fourcc(), MediaInfoBox.class);
        this.mappings.put(HandlerBox.fourcc(), HandlerBox.class);
        this.mappings.put(DataInfoBox.fourcc(), DataInfoBox.class);
        this.mappings.put("stbl", NodeBox.class);
        this.mappings.put(SampleDescriptionBox.fourcc(), SampleDescriptionBox.class);
        this.mappings.put(TimeToSampleBox.fourcc(), TimeToSampleBox.class);
        this.mappings.put(SyncSamplesBox.fourcc(), SyncSamplesBox.class);
        this.mappings.put(SampleToChunkBox.fourcc(), SampleToChunkBox.class);
        this.mappings.put(SampleSizesBox.fourcc(), SampleSizesBox.class);
        this.mappings.put(ChunkOffsetsBox.fourcc(), ChunkOffsetsBox.class);
        this.mappings.put("mvex", NodeBox.class);
        this.mappings.put("moof", NodeBox.class);
        this.mappings.put("traf", NodeBox.class);
        this.mappings.put("mfra", NodeBox.class);
        this.mappings.put("skip", NodeBox.class);
        this.mappings.put("meta", LeafBox.class);
        this.mappings.put(DataRefBox.fourcc(), DataRefBox.class);
        this.mappings.put("ipro", NodeBox.class);
        this.mappings.put("sinf", NodeBox.class);
        this.mappings.put(ChunkOffsets64Box.fourcc(), ChunkOffsets64Box.class);
        this.mappings.put(SoundMediaHeaderBox.fourcc(), SoundMediaHeaderBox.class);
        this.mappings.put("clip", NodeBox.class);
        this.mappings.put(ClipRegionBox.fourcc(), ClipRegionBox.class);
        this.mappings.put(LoadSettingsBox.fourcc(), LoadSettingsBox.class);
        this.mappings.put("tapt", NodeBox.class);
        this.mappings.put("gmhd", NodeBox.class);
        this.mappings.put("tmcd", LeafBox.class);
        this.mappings.put("tref", NodeBox.class);
        this.mappings.put(ClearApertureBox.fourcc(), ClearApertureBox.class);
        this.mappings.put(ProductionApertureBox.fourcc(), ProductionApertureBox.class);
        this.mappings.put(EncodedPixelBox.fourcc(), EncodedPixelBox.class);
        this.mappings.put(GenericMediaInfoBox.fourcc(), GenericMediaInfoBox.class);
        this.mappings.put(TimecodeMediaInfoBox.fourcc(), TimecodeMediaInfoBox.class);
        this.mappings.put("udta", NodeBox.class);
        this.mappings.put(CompositionOffsetsBox.fourcc(), CompositionOffsetsBox.class);
        this.mappings.put(NameBox.fourcc(), NameBox.class);
    }

    public void override(String fourcc, Class<? extends Box> cls) {
        this.mappings.put(fourcc, cls);
    }

    public Class<? extends Box> toClass(String fourcc) {
        return this.mappings.get(fourcc);
    }
}

