/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.BoxFactory;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.TrakBox;

public class MP4Util {
    public static MovieBox createRefMovie(SeekableByteChannel input, String url) throws IOException {
        MovieBox movie = MP4Util.parseMovie(input);
        for (TrakBox trakBox : movie.getTracks()) {
            trakBox.setDataRef(url);
        }
        return movie;
    }

    public static MovieBox parseMovie(SeekableByteChannel input) throws IOException {
        for (Atom atom : MP4Util.getRootAtoms(input)) {
            if (!"moov".equals(atom.getHeader().getFourcc())) continue;
            return (MovieBox)atom.parseBox(input);
        }
        return null;
    }

    public static List<Atom> getRootAtoms(SeekableByteChannel input) throws IOException {
        Header atom;
        input.position(0L);
        ArrayList<Atom> result = new ArrayList<Atom>();
        for (long off = 0L; off < input.size(); off += atom.getSize()) {
            input.position(off);
            atom = Header.read(NIOUtils.fetchFrom(input, 16));
            if (atom == null) break;
            result.add(new Atom(atom, off));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovieBox parseMovie(File source) throws IOException {
        FileChannelWrapper input = null;
        try {
            input = NIOUtils.readableFileChannel(source);
            MovieBox movieBox = MP4Util.parseMovie(input);
            return movieBox;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovieBox createRefMovie(File source) throws IOException {
        FileChannelWrapper input = null;
        try {
            input = NIOUtils.readableFileChannel(source);
            MovieBox movieBox = MP4Util.createRefMovie(input, "file://" + source.getCanonicalPath());
            return movieBox;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMovie(File f2, MovieBox movie) throws IOException {
        AbstractInterruptibleChannel out = null;
        try {
            out = new FileInputStream(f2).getChannel();
            MP4Util.writeMovie(f2, movie);
        }
        finally {
            out.close();
        }
    }

    public static void writeMovie(SeekableByteChannel out, MovieBox movie) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(0x1000000);
        movie.write(buf);
        buf.flip();
        out.write(buf);
    }

    public static Box cloneBox(Box track, int approxSize) {
        ByteBuffer buf = ByteBuffer.allocate(approxSize);
        track.write(buf);
        buf.flip();
        return NodeBox.parseBox(buf, track.getHeader(), BoxFactory.getDefault());
    }

    public static class Atom {
        private long offset;
        private Header header;

        public Atom(Header header, long offset) {
            this.header = header;
            this.offset = offset;
        }

        public long getOffset() {
            return this.offset;
        }

        public Header getHeader() {
            return this.header;
        }

        public Box parseBox(SeekableByteChannel input) throws IOException {
            input.position(this.offset + this.header.headerSize());
            return NodeBox.parseBox(NIOUtils.fetchFrom(input, (int)this.header.getSize()), this.header, BoxFactory.getDefault());
        }

        public void copy(SeekableByteChannel input, WritableByteChannel out) throws IOException {
            input.position(this.offset);
            NIOUtils.copy(input, out, this.header.getSize());
        }
    }
}

