/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.elements;

public class Track {
    public short trackNo;
    public long trackUID;
    public byte trackType;
    public long defaultDuration;
    public String name;
    public String language;
    public String codecID;
    public byte[] codecPrivate;
    public short videoPixelWidth;
    public short videoPixelHeight;
    public short videoDisplayWidth;
    public short videoDisplayHeight;
    public float audioSamplingFrequency;
    public float audioOutputSamplingFrequency;
    public short audioChannels;
    public byte audioBitDepth;
    public static byte track_video = 1;
    public static byte track_audio = (byte)2;
    public static byte track_complex = (byte)3;
    public static byte track_logo = (byte)16;
    public static byte track_subtitle = (byte)17;
    public static byte track_control = (byte)32;

    public String toString() {
        String s = new String();
        s = s + "\t\tTrackNo: " + this.trackNo + "\n";
        s = s + "\t\tTrackUID: " + this.trackUID + "\n";
        s = s + "\t\tTrackType: " + Track.trackTypeToString(this.trackType) + "\n";
        s = s + "\t\tDefaultDuration: " + this.defaultDuration + "\n";
        s = s + "\t\tName: " + this.name + "\n";
        s = s + "\t\tLanguage: " + this.language + "\n";
        s = s + "\t\tCodecID: " + this.codecID + "\n";
        if (this.codecPrivate != null) {
            s = s + "\t\tCodecPrivate: " + this.codecPrivate.length + " byte(s)" + "\n";
        }
        if (this.trackType == track_video) {
            s = s + "\t\tPixelWidth: " + this.videoPixelWidth + "\n";
            s = s + "\t\tPixelHeight: " + this.videoPixelHeight + "\n";
            s = s + "\t\tDisplayWidth: " + this.videoDisplayWidth + "\n";
            s = s + "\t\tDisplayHeight: " + this.videoDisplayHeight + "\n";
        }
        if (this.trackType == track_audio) {
            s = s + "\t\tSamplingFrequency: " + this.audioSamplingFrequency + "\n";
            if (this.audioOutputSamplingFrequency != 0.0f) {
                s = s + "\t\tOutputSamplingFrequency: " + this.audioOutputSamplingFrequency + "\n";
            }
            s = s + "\t\tChannels: " + this.audioChannels + "\n";
            if (this.audioBitDepth != 0) {
                s = s + "\t\tBitDepth: " + this.audioBitDepth + "\n";
            }
        }
        return s;
    }

    public static String trackTypeToString(byte trackType) {
        if (trackType == track_video) {
            return "Video";
        }
        if (trackType == track_audio) {
            return "Audio";
        }
        if (trackType == track_complex) {
            return "Complex";
        }
        if (trackType == track_logo) {
            return "Logo";
        }
        if (trackType == track_subtitle) {
            return "Subtitle";
        }
        if (trackType == track_control) {
            return "Control";
        }
        return "";
    }
}

