/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.elements;

import java.io.IOException;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.elements.Frame;
import org.jcodec.containers.mkv.util.ArrayCopy;
import org.jcodec.containers.mkv.util.TLinkedList;

public class MatroskaCluster
extends MasterElement {
    protected int[] laceMode = null;
    protected TLinkedList frames = new TLinkedList();
    protected long clusterTimecode = 0L;

    public MatroskaCluster(byte[] type) {
        super(type);
    }

    void setLaceMode(short trackNo, int laceMode) {
        if (this.laceMode == null) {
            this.laceMode = new int[trackNo];
        }
        if (this.laceMode.length < trackNo) {
            int[] oldLaceMode = this.laceMode;
            this.laceMode = new int[trackNo];
            ArrayCopy.arraycopy(this.laceMode, 0, oldLaceMode, 0, oldLaceMode.length);
        }
        this.laceMode[trackNo - 1] = laceMode;
    }

    int getLaceMode(short trackNo) {
        if (this.laceMode == null) {
            return -1;
        }
        if (this.laceMode.length < trackNo) {
            return -1;
        }
        return this.laceMode[trackNo - 1];
    }

    public void AddFrame(Frame frame) {
        if (frame.Timecode < this.clusterTimecode) {
            this.clusterTimecode = frame.Timecode;
        }
        this.frames.add(frame);
    }

    @Override
    public Element readNextChild(Reader reader) throws IOException {
        if (this.usedSize > this.size) {
            System.err.println("Size " + this.size + " of Cluster block is lesser then number of actual elements read ( " + this.usedSize + " ). File offset: " + reader.getPos());
        } else if (this.usedSize == this.size) {
            return null;
        }
        Element elem = reader.readNextElement();
        if (elem != null) {
            elem.setParent(this);
            this.usedSize += elem.getSize();
        }
        return elem;
    }
}

